/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreAddDef;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.dbstore.binders.CMDbStoreTimestampBinder;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMDateUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

class CMDbStoreBaseTableAddDef
extends CMDbStoreAddDef {
    private Timestamp creationTime_;
    private Timestamp modificationTime_;
    private int parentID_;

    public CMDbStoreBaseTableAddDef(int parentID, CMObjectClass objectClass) {
        super("CMOBJECTS");
        boolean isDerby = CMDbConnection.dbms_ == 5;
        this.parentID_ = parentID;
        this.modificationTime_ = this.creationTime_ = CMDateUtils.getTimestamp(isDerby);
        if (objectClass != null) {
            this.addColumn((CMDbProperty)CMProperty.OBJECTCLASS, objectClass);
        }
    }

    public Timestamp getCreationDate() {
        return this.creationTime_;
    }

    public void setCreationDate(Timestamp time) {
        this.creationTime_ = time;
    }

    public void setModificationDate(Timestamp time) {
        this.modificationTime_ = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CMDbConnection con, int objectID) throws SQLException, CMException {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        StringBuffer stmt = new StringBuffer(500);
        StringBuffer values = new StringBuffer(100);
        sqlGenerator.appendInsertIntoTable("CMOBJECTS", stmt);
        sqlGenerator.appendColumnNames(new String[]{"CMID", "PCMID", "CREATED", "MODIFIED"}, stmt);
        values.append(sqlGenerator.createValuesForInsertIntoCMOBJECTSSql());
        this.completeCommand(con, stmt, values, false);
        PreparedStatement insertStmt = null;
        try {
            insertStmt = con.prepareStatement(stmt.toString());
            int bindOffset = 1;
            insertStmt.setInt(bindOffset++, objectID);
            insertStmt.setInt(bindOffset++, this.parentID_);
            CMDbStoreTimestampBinder timestampBinder = new CMDbStoreTimestampBinder();
            bindOffset = timestampBinder.bindData(insertStmt, bindOffset, this.creationTime_);
            bindOffset = timestampBinder.bindData(insertStmt, bindOffset, this.modificationTime_);
            this.bindParameters(insertStmt, bindOffset);
            CMDbConnection.executeUpdate(insertStmt);
        }
        finally {
            if (insertStmt != null) {
                try {
                    insertStmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

