/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.CAM.AAAException;
import com.cognos.cm.cam.azn.AznUtil;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbObjectClass;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbPropertyHandlerProvider;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreAcquiredPropertiesHandler;
import com.cognos.cm.dbstore.CMDbStoreAcquiredValue;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.dbstore.CMDbStoreDefaultOutput;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreObjectsBase;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreSecurityHandler;
import com.cognos.cm.dbstore.CMDbStoreSelectDef;
import com.cognos.cm.dbstore.CMDbStoreSimpleResultSet;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.CMPropertyHandler;
import com.cognos.cm.dbstore.plugins.PropertyPlugin;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.dbstore.properties.CMDbStorePermissions;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.dbstore.properties.CMDbStoreUserCapabilities;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multipart.Base64;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMBaseClassArray;
import com.cognos.cm.properties.CMDescendantModifiedProperty;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ComponentDependentCapabilities;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.ExtendedUserCapabilities;
import com.cognos.cm.server.profileSettings.SessionProfileSettings;
import com.cognos.cm.server.routing.RoutingManager;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.util.CMAAAObjectPropertiesDoc;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMIDBasedReferencesUtils;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.date.DateUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CMDbStoreCacheComplexObjects
extends CMDbStoreObjectsBase {
    @Deprecated
    private static final int CAMID_LOCALE = 0;
    public static final Object UNSET = new Object();
    public static final int IDX_SETPOLICY = 0;
    public static final int IDX_WRITE = 1;
    public static final int IDX_EXECUTE = 2;
    public static final int IDX_TRAVERSE = 3;
    public static final int IDX_READ = 4;
    private static final int REWIND_POSITION = -1;
    private boolean bReturnReferencesAsSearchPath_ = false;
    boolean wasAcquired_;
    int currReferenceCount_;
    int currObjectID_;
    int currObjectIndex_ = 0;
    byte[] currPolicies_;
    byte[] currUCPolicies_;
    CMDbStoreObjectReference currOwner_;
    int currObjectState_;
    Date currCreationTime_;
    CMDbObjectClass currObjectClass_;
    boolean lastObjectExcluded_;
    BitSet objectsSelected_;
    Object[] values_;
    BitSet wasAcquiredSet_;
    ResultSet rs_;
    int[] selectedObjects_;
    CMDbStoreSecurityHandler securityHandler_;
    CMAAAObjectPropertiesDoc currExternalProps_;
    CMDbStoreAcquiredPropertiesHandler acquiredProperties_;
    int queryOptions_;
    CMCacheQueryInstance query_;
    CMDbStore store_;
    CMDbStoreSelectDef selectStmt_;
    CMDbStore.ReadTransactionHandle rtHandle_;
    boolean retrievingDefaultOutput_;
    boolean bTrimmed_ = false;
    int parametersIdx = -1;
    boolean bReset_ = false;
    CMDbStoreUserCapabilities userCapabilities_ = null;
    boolean userCapabilitiesCalculated_ = false;
    private CMDbStoreString accManName;
    private CMDbPropertyHandlerProvider propertyHandlerProvider;

    public CMDbStoreCacheComplexObjects(CMDbStore store, CMDbStoreSelectDef selectStmt, List<String> permissions, int[] filterPermissions, List<String> otherPermissions, int queryOptions, CMCacheQueryInstance query2, int[] useObjectIDs) throws CMException {
        super(selectStmt.getProperties());
        this.query_ = query2;
        this.store_ = store;
        this.selectStmt_ = selectStmt;
        this.queryOptions_ = queryOptions;
        this.propertyHandlerProvider = new CMDbPropertyHandlerProvider(this.store_);
        try {
            this.selectedObjects_ = query2.resultObjects();
        }
        catch (CMCacheException e) {
            throw new CMStoreUnexpected(e, "cmStoreUnexpectedCacheQuery");
        }
        if (this.selectedObjects_.length == 0) {
            return;
        }
        this.securityHandler_ = new CMDbStoreSecurityHandler(permissions, filterPermissions, otherPermissions, queryOptions);
        this.objectsSelected_ = new BitSet(this.selectedObjects_.length);
        CMDbConnection con = null;
        try {
            if (selectStmt.resolvableInCache()) {
                this.rs_ = new CMDbStoreSimpleResultSet(useObjectIDs == null ? this.selectedObjects_ : useObjectIDs);
            } else {
                con = this.store_.getConnection();
                if (selectStmt.retrievingLobs()) {
                    this.rtHandle_ = this.store_.beginReadTransaction();
                }
                this.rs_ = selectStmt.execute(con, useObjectIDs == null ? this.selectedObjects_ : useObjectIDs);
            }
        }
        catch (SQLException e) {
            CMDbStoreExceptionUtil.handleSQLException(con, e, "cmUnexpectedResultProcessingFailure");
        }
        CMProperty[] props = selectStmt.getProperties();
        if (props != null) {
            for (int propIdx = 0; propIdx != props.length; ++propIdx) {
                if (!props[propIdx].hasMeaning(CMPropertyMeaning.DEFAULTOUTPUTFORMAT)) continue;
                this.retrievingDefaultOutput_ = true;
                break;
            }
        }
    }

    public void finalize() throws Throwable {
        this.release();
    }

    @Override
    public void release() {
        try {
            if (this.query_ != null) {
                try {
                    this.query_.release();
                }
                catch (CMCacheException cMCacheException) {
                    // empty catch block
                }
            }
            CMDbStoreUtil.safeCloseStatementViaResultSet(this.rs_);
            CMDbStore.releaseReadTransaction(this.rtHandle_);
        }
        finally {
            this.query_ = null;
            this.rs_ = null;
            this.rtHandle_ = null;
        }
    }

    private boolean logicalNext() throws CMException {
        boolean result = false;
        while (this.currReferenceCount_ != 0) {
            --this.currReferenceCount_;
            ++this.currObjectIndex_;
            if (this.currPolicies_ != null) {
                if (this.lastObjectExcluded_ || !this.objectsSelected_.get(this.currObjectIndex_ - 1)) continue;
                this.objectsSelected_.set(this.currObjectIndex_);
                result = true;
                break;
            }
            if (!this.securityHandler_.keepObjectAfterAccessChecks(this.store_, this.currObjectClass_, this.currOwner_, this.query_, this.currPolicies_, this.currObjectID_, this.currObjectIndex_, this.retrievingDefaultOutput_)) continue;
            this.objectsSelected_.set(this.currObjectIndex_);
            result = true;
            break;
        }
        this.lastObjectExcluded_ = false;
        return result;
    }

    @Override
    public boolean next() throws CMException {
        boolean bReturn = false;
        do {
            bReturn = false;
            if (this.rs_ != null) {
                if (this.logicalNext()) {
                    bReturn = true;
                    continue;
                }
                try {
                    boolean more = this.currObjectIndex_ == -1 && this.rs_.getRow() == 1 ? true : this.rs_.next();
                    while (more) {
                        this.getValues();
                        if (this.securityHandler_.keepObjectAfterAccessChecks(this.store_, this.currObjectClass_, this.currOwner_, this.query_, this.currPolicies_, this.currObjectID_, this.currObjectIndex_, this.retrievingDefaultOutput_)) {
                            this.objectsSelected_.set(this.currObjectIndex_);
                            break;
                        }
                        if (this.currReferenceCount_ != 0 && this.logicalNext()) {
                            bReturn = true;
                            break;
                        }
                        more = this.rs_.next();
                    }
                    bReturn = !bReturn ? more : bReturn;
                }
                catch (SQLException e) {
                    CMDbStoreExceptionUtil.handleSQLException(this.store_.getConnection(), e, "cmUnexpectedResultProcessingFailure");
                    return false;
                }
            }
            ++this.currObjectIndex_;
            if (this.currObjectIndex_ < this.selectedObjects_.length) {
                this.currObjectID_ = this.selectedObjects_[this.currObjectIndex_];
                try {
                    int classID = this.store_.getCache().CMCacheGetClass(this.currObjectID_);
                    this.currObjectClass_ = (CMDbObjectClass)CMDbStoreFactory.objectClasses_.getClassByID(classID);
                }
                catch (CMCacheException ex2) {
                    throw new CMStoreUnexpected(ex2, "cmStoreUnexpectedNoObjectClass");
                }
            }
            boolean bl = bReturn = this.currObjectIndex_ < this.selectedObjects_.length;
        } while (bReturn && this.currObjectClass_ == CMObjectClass._DELETEDOBJECT);
        return bReturn;
    }

    public static long hashPathForURL(String path) {
        long val = 0L;
        int hash_len = path.length();
        for (int hash_i = 0; hash_i < hash_len; ++hash_i) {
            val += (long)path.charAt(hash_i);
        }
        return val % 65535L;
    }

    @Override
    public Object getValue(int index) throws CMException {
        int dbPropCount = this.selectStmt_.getDbPropertyCount();
        this.selectStmt_.getDbPropertyMap();
        int[] propertyColumnMap = this.selectStmt_.getPropertyDBColumnMap();
        CMProperty[] properties = this.selectStmt_.getProperties();
        this.wasAcquired_ = false;
        if (dbPropCount != 0 && this.rs_ == null || this.bReset_) {
            throw new IllegalStateException();
        }
        if (properties == null || index < 0 || index >= properties.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        CMDbProperty prop = (CMDbProperty)properties[index];
        if (this.securityHandler_.readAccessDenied() && prop.requiresReadAccess()) {
            return null;
        }
        if (this.securityHandler_.setPolicyAccessDenied() && prop == CMProperty.POLICIES) {
            return null;
        }
        int i = dbPropCount;
        if (propertyColumnMap[index] >= 0) {
            i = propertyColumnMap[index];
        }
        if (i != dbPropCount && !prop.isCached()) {
            this.wasAcquired_ = this.wasAcquiredSet_.get(i);
            if (prop == CMProperty.POLICIES && this.values_[i] == null && !this.wasAcquired_) {
                try {
                    this.values_[i] = this.query_.getAcquiredPolicy(this.currObjectIndex_, 1);
                    this.wasAcquiredSet_.set(i);
                    this.wasAcquired_ = true;
                }
                catch (CMCacheException ex) {
                    throw new CMStoreUnexpected(ex, "cmStoreUnexpectedErrAquirePolicy");
                }
            }
            if (this.values_[i] == UNSET && prop.isStoredAsArray()) {
                this.values_[i] = this.getArrayValue(prop);
            }
            if (prop == CMProperty.PARAMETERS && this.currObjectClass_ == CMObjectClass.ACCOUNT) {
                this.values_[i] = this.values_[this.parametersIdx];
                this.wasAcquiredSet_.set(i);
                this.wasAcquired_ = true;
            }
            if (prop.hasSubproperties()) {
                for (int subpropertyIdx = 0; subpropertyIdx < prop.getSubproperties().size(); ++subpropertyIdx) {
                    CMDbProperty currentProperty = (CMDbProperty)prop.getSubproperties().get(subpropertyIdx);
                    if (!currentProperty.isStoredAsArray()) continue;
                    this.values_[i] = CMIDBasedReferencesUtils.mergeComplexType(this.values_[i], CMDbStoreUtil.getArray(this.store_.getConnection(), currentProperty, this.currObjectID_, true));
                }
            }
            if (prop.getMeaning() == CMPropertyMeaning.SHOWN) {
                boolean showHiddenObjects = CMExecutionContext.get().currentUserCanSeeHiddenObjects();
                boolean hidden = null == this.values_[i] ? false : Boolean.valueOf(this.values_[i].toString());
                return showHiddenObjects || !hidden;
            }
            return this.values_[i];
        }
        if (this.currObjectClass_.hasProperty(prop)) {
            try {
                if (prop == CMProperty.ANCESTORS) {
                    return this.store_.getCache().getAncestors(this.currObjectID_, CMDbStoreCacheUtil.getCacheSearchLocales());
                }
                if (prop == CMProperty.NAME) {
                    ArrayList<String> values = new ArrayList<String>();
                    ArrayList<Integer> locales = new ArrayList<Integer>();
                    this.populateNames(values, locales);
                    CMDbStoreLocalizedStringArray names = new CMDbStoreLocalizedStringArray();
                    int nameCount = values.size();
                    for (int nameIdx = 0; nameIdx != nameCount; ++nameIdx) {
                        names.add(CMDbStoreCacheComplexObjects.createLocalizedString(values, locales, nameIdx));
                    }
                    return names;
                }
                if (prop == CMProperty.OBJECTCLASS) {
                    return this.currObjectClass_;
                }
                if (prop == CMProperty.STOREID) {
                    String storeId = this.getStoreID();
                    return storeId == null ? null : new CMDbStoreString(storeId);
                }
                if (prop == CMProperty.SEARCHPATH) {
                    return new CMDbStoreString(this.getSearchPath());
                }
                if (prop == CMProperty.SEARCHPATHFORURL) {
                    CMCache cache = this.store_.getCache();
                    CMDbStoreStringLocale sysLocale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(ConfigurationFactory.getConfig().getServerLocale().toString());
                    StringBuffer urlBuf = new StringBuffer(30);
                    urlBuf.append(Integer.toString(this.currObjectID_));
                    urlBuf.append(":");
                    urlBuf.append(Long.toString(DateUtils.getUTCTime((Date)this.currCreationTime_)));
                    urlBuf.append(":");
                    urlBuf.append(Long.toString(CMDbStoreCacheComplexObjects.hashPathForURL(cache.CMCacheGetNameOnlyPath(this.currObjectID_, new int[]{sysLocale.getInternalID(), sysLocale.getMappedID()}))));
                    return new CMDbStoreString("URLID(\"" + Base64.encode(urlBuf.toString().getBytes()) + "\")");
                }
                if (prop == CMProperty.DEFAULTNAME) {
                    if (this.accManName != null) {
                        return this.accManName;
                    }
                    return new CMDbStoreString(this.store_.getCache().CMCacheGetName(this.currObjectID_, CMDbStoreCacheUtil.getCacheSearchLocales()));
                }
                if (prop == CMProperty.DISABLED) {
                    int value = this.store_.getCache().CMCacheGetIntegerProperty(this.currObjectID_, 6);
                    boolean disabledValue = false;
                    if (value == 0) {
                        disabledValue = this.store_.getCache().CMCacheIsObjectDisabled(this.currObjectID_);
                        this.wasAcquired_ = true;
                    } else {
                        disabledValue = value == 1;
                    }
                    return new CMDbStoreString(CMXMLUtils.getBooleanXMLValue(disabledValue));
                }
                if (prop == CMProperty.ID) {
                    String idValue = this.store_.getCache().CMCacheGetName(this.currObjectID_, new int[]{0});
                    if (idValue != null) {
                        return new CMDbStoreString(idValue);
                    }
                    return null;
                }
                if (prop == CMProperty.PARENT) {
                    if (this.currObjectID_ == 0) {
                        return null;
                    }
                    int parentID = this.query_.objectParent(this.currObjectIndex_);
                    String parentSearchPath = this.store_.getCache().CMCacheGetSearchPath(parentID, CMDbStoreCacheUtil.getCacheSearchLocales());
                    String parentStoreID = this.store_.getObjectStoreID(parentID);
                    CMDbStoreBaseClassArray value = new CMDbStoreBaseClassArray();
                    CMDbStoreObjectReference reference = new CMDbStoreObjectReference(parentID, this.store_.getObjectClass(parentID), parentSearchPath);
                    reference.setStoreID(parentStoreID);
                    value.add(reference);
                    return value;
                }
                if (prop.getBehaviourName() == "parameterString") {
                    String parameterName = prop.getBehaviourParms().get(0).toString();
                    String confValue = ConfigurationFactory.getConfig().getCognosProp(parameterName);
                    if (confValue == null) {
                        return null;
                    }
                    return new CMDbStoreString(confValue);
                }
                if (prop.getBehaviourName() == "parameterBoolean") {
                    String parameterName = prop.getBehaviourParms().get(0).toString();
                    String confValue = ConfigurationFactory.getConfig().getCognosProp(parameterName);
                    if (confValue == null) {
                        return null;
                    }
                    return new CMDbStoreString(CMXMLUtils.getBooleanXMLValue(CMXMLUtils.parseBooleanAttribute(confValue)));
                }
                if (prop.getBehaviourName() == "parameterPropertyValue") {
                    String parameterName = prop.getBehaviourParms().get(0).toString();
                    return ConfigurationFactory.getConfig().getObject(parameterName);
                }
                if (prop.hasMeaning(CMPropertyMeaning.USERCAPABILITIES) || prop.hasMeaning(CMPropertyMeaning.EFFECTIVEUSERCAPABILITIES)) {
                    int size = prop.getSupportedEnumValues().size();
                    this.calculateUserCapabilitiesOnObj(prop);
                    if (prop.hasMeaning(CMPropertyMeaning.EFFECTIVEUSERCAPABILITIES)) {
                        return this.calculateEffectiveCapabilities(size);
                    }
                    return this.userCapabilities_;
                }
                if (prop == CMProperty.LASTCONFIGURATIONMODIFICATIONTIME) {
                    return CMDescendantModifiedProperty.get();
                }
                if (prop == CMProperty._HASRECIPIENTS) {
                    return this.store_.getCache().CMCacheGetBooleanProperty(this.currObjectID_, 15);
                }
                if (prop == CMProperty._HASRECIPIENTSEMAIL) {
                    return this.store_.getCache().CMCacheGetBooleanProperty(this.currObjectID_, 16);
                }
                if (prop == CMProperty.COMMONSYMMETRICKEY) {
                    return CMExecutionContext.get().getCommonSymmetricKey();
                }
                if (prop == CMProperty.CACHEDCACERTIFICATES) {
                    return CMExecutionContext.get().getCACertificates();
                }
                if (prop.hasMeaning(CMPropertyMeaning.DEFAULTOUTPUTFORMAT)) {
                    return CMDbStoreDefaultOutput.getDefaultOutputFormat(this.store_, this.query_, this.getSearchPath(), this.securityHandler_.getGrantedPermissions(), this.currObjectIndex_);
                }
                if (prop == CMProperty.DISPATCHERPATH) {
                    String dpValue = this.store_.getCache().CMCacheGetName(this.currObjectID_, new int[]{0});
                    if (dpValue != null) {
                        return new CMDbStoreString(dpValue);
                    }
                    return null;
                }
                if (prop == CMProperty.TASKID || prop == CMProperty.EVENTID || prop == CMProperty.DOCUMENTID) {
                    String dpValue = this.store_.getCache().CMCacheGetExactName(this.currObjectID_, 0);
                    if (dpValue != null) {
                        return new CMDbStoreString(dpValue);
                    }
                    return null;
                }
                if (prop == CMProperty.HASCHILDREN) {
                    return new CMDbStoreString(this.store_.getCache().CMCacheGetHasChildren(this.currObjectID_) ? "true" : "false");
                }
                if (prop == CMProperty.IDENTITY) {
                    ArrayList<CMObjectReference> userMembership = CMExecutionContext.get().getCurrentUserIdentity();
                    CMDbStoreBaseClassArray anonymousIdentities = new CMDbStoreBaseClassArray();
                    for (int iIdent = 0; iIdent < userMembership.size(); ++iIdent) {
                        anonymousIdentities.add(userMembership.get(iIdent));
                    }
                    return anonymousIdentities;
                }
                if (prop == CMProperty.PACKAGEBASE) {
                    CMAncestors propValue = this.store_.getCache().getAncestors(this.currObjectID_, CMDbStoreCacheUtil.getCacheSearchLocales());
                    for (int ancestor = propValue.getSize() - 1; ancestor >= 0; --ancestor) {
                        String sClassName = propValue.getObjectClass(ancestor);
                        if (!sClassName.equalsIgnoreCase(CMObjectClass.PACKAGE.getName())) continue;
                        return new CMDbStoreString(propValue.getSearchPath(ancestor));
                    }
                    return new CMDbStoreString("/");
                }
                if (prop == CMProperty.PERMISSIONS) {
                    CMDbStorePermissions value = new CMDbStorePermissions();
                    int[] policyCheckResults = this.securityHandler_.getPolicyCheckResults();
                    List<String> permissions = this.securityHandler_.getPermissions();
                    for (int j = 0; j < policyCheckResults.length; ++j) {
                        if (policyCheckResults[j] != 0) continue;
                        value.add(permissions.get(j));
                    }
                    return value;
                }
                if (prop == CMProperty.POLICIES) {
                    byte[] value = null;
                    try {
                        value = this.query_.getAcquiredPolicy(this.currObjectIndex_, 1);
                        if (value != null) {
                            this.wasAcquired_ = true;
                        }
                    }
                    catch (CMCacheException ex) {
                        throw new CMStoreUnexpected(ex, "cmStoreUnexpectedErrAquirePolicy");
                    }
                    return value;
                }
                if (prop == CMProperty.ROUTINGSERVERGROUP) {
                    return RoutingManager.getInstance().determineRouting(this.currObjectID_);
                }
                if (prop == CMProperty.ROUTINGSERVERGROUPEDITION) {
                    return new CMDbStoreString("");
                }
                if (prop == CMProperty.TENANTID) {
                    int tenantID = this.store_.getCache().CMCacheGetTenantID(this.currObjectID_);
                    return new CMDbStoreString(this.store_.getTenantRegistry().getTenantIdStringFromInt(tenantID));
                }
                if (prop == CMProperty.VERSION) {
                    int version = this.store_.getCache().getVersionNumber(this.currObjectID_);
                    return new CMDbStoreString(Integer.toString(version));
                }
                if (this.currObjectClass_ == CMObjectClass.SESSION) {
                    SessionProfileSettings ps;
                    if ("profileRole".equals(prop.getName())) {
                        CMDbStoreBaseClassArray bca = new CMDbStoreBaseClassArray();
                        CMObjectReference ref = CMExecutionContext.get().getSessionProfileRole();
                        if (ref != null) {
                            bca.add(ref);
                        }
                        return bca;
                    }
                    if ("userProfileSettings".equals(prop.getName())) {
                        SessionProfileSettings ps2 = CMExecutionContext.get().getCurrentUserProfileSettings();
                        if (ps2 != null) {
                            return new CMDbStoreString(ps2.toString());
                        }
                    } else if (prop == CMProperty.EFFECTIVEGLOBALPARAMETERS && (ps = CMExecutionContext.get().getCurrentUserProfileSettings()) != null) {
                        return ps.getEffectiveGlobalParameters();
                    }
                }
            }
            catch (CMCacheException e) {
                CMException cmex = new CMException(e, "cmErrCache");
                CMIndications.logException(cmex);
            }
        }
        return null;
    }

    private static CMDbStoreLocalizedString createLocalizedString(List<String> values, List<Integer> locales, int index) {
        short localeId = locales.get(index).shortValue();
        CMStringLocale locale = CMDbStoreStringLocales.findLocale(localeId);
        String value = values.get(index);
        boolean isDefault = CMDbStoreStringLocales.isDefaultLocale(localeId);
        return new CMDbStoreLocalizedString(locale, value, isDefault, false);
    }

    private Object getArrayValue(CMDbProperty prop) throws CMException {
        PropertyPlugin propFunc = this.store_.getPropertyFunction(prop.getName());
        return propFunc != null ? propFunc.getArrayValue(this.store_, this.currObjectID_) : CMDbStoreUtil.getArray(this.store_.getConnection(), prop, this.currObjectID_);
    }

    private void populateNames(List<String> values, List<Integer> locales) throws CMCacheException {
        if (this.accManName == null) {
            this.store_.getCache().CMCacheGetAllNames(this.currObjectID_, values, locales);
        } else {
            this.store_.getCache().packageAccManName(this.currObjectID_, this.accManName.getValue(), values, locales);
        }
    }

    @Override
    public boolean wasAcquired() {
        return this.wasAcquired_;
    }

    @Override
    public int getObjectID() {
        return this.currObjectID_;
    }

    @Override
    public int[] getObjectIDs() {
        return this.selectedObjects_;
    }

    @Override
    public boolean hasChildren() {
        try {
            return this.store_.getCache().CMCacheGetHasChildren(this.currObjectID_);
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException((Exception)e, "cmErrCacheAddRollBack", new CMException.Parm("Location", "CacheObjects.hasChildren"));
            CMIndications.logException(cmex);
            return false;
        }
    }

    @Override
    public String getPath() {
        try {
            return this.query_.objectPath(this.currObjectIndex_, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException((Exception)e, "cmErrCacheAddRollBack", new CMException.Parm("Location", "CacheObjects.getPath"));
            CMIndications.logException(cmex);
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
        return null;
    }

    @Override
    public String getSearchPath() {
        String sp;
        if (this.bReturnReferencesAsSearchPath_ && (sp = this.getSecurityReference()) != null) {
            return sp;
        }
        try {
            return this.store_.getCache().CMCacheGetSearchPath(this.currObjectID_, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException((Exception)e, "cmErrCacheIn", new CMException.Parm("Location", "CacheObjects.getSearchPath"));
            CMIndications.logException(cmex);
        }
        catch (CMException cMException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public InternalStoreId getInternalStoreID() {
        return this.store_.getInternalStoreId(this.currObjectID_);
    }

    @Override
    public String getStoreID() {
        try {
            return this.store_.getObjectStoreID(this.currObjectID_);
        }
        catch (CMException e) {
            CMIndications.logException(e);
            return null;
        }
    }

    @Override
    public int getParentObjectID() {
        return this.store_.getCache().CMCacheGetIntegerProperty(this.currObjectID_, 5);
    }

    @Override
    public String getParentSearchPath() {
        try {
            int parentID = this.store_.getCache().CMCacheGetIntegerProperty(this.currObjectID_, 5);
            return this.store_.getCache().CMCacheGetSearchPath(parentID, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException((Exception)e, "cmErrCacheAddRollBack", new CMException.Parm("Location", "CacheObjects.getSearchPath"));
            CMIndications.logException(cmex);
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
        return null;
    }

    @Override
    public int getTenantID() {
        return this.store_.getCache().CMCacheGetTenantID(this.currObjectID_);
    }

    @Override
    public int getVersion() {
        return this.store_.getCache().getVersionNumber(this.currObjectID_);
    }

    @Override
    public String getSecurityReference() {
        try {
            return this.store_.getCache().CMCacheGetSecurityReference(this.currObjectID_);
        }
        catch (CMCacheException e) {
            CMIndications.logException(new CMException((Exception)e, "cmErrCacheAddRollBack", new CMException.Parm("Location", "CacheObjects.getSearchPath")));
            return null;
        }
    }

    @Override
    public String getName() {
        try {
            return this.store_.getCache().CMCacheGetName(this.currObjectID_, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException((Exception)e, "cmErrCacheAddRollBack", new CMException.Parm("Location", "CacheObjects.getName"));
            CMIndications.logException(cmex);
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
        return null;
    }

    @Override
    public void exclude() {
        this.objectsSelected_.clear(this.currObjectIndex_);
        this.lastObjectExcluded_ = true;
    }

    @Override
    public void reset() {
        CMDbStoreUtil.safeCloseStatementViaResultSet(this.rs_);
        this.rs_ = null;
        CMDbStore.releaseReadTransaction(this.rtHandle_);
        this.rtHandle_ = null;
        this.trim();
        this.currObjectIndex_ = -1;
        this.bReset_ = true;
    }

    private void trim() {
        if (this.bTrimmed_) {
            return;
        }
        this.bTrimmed_ = true;
        for (int i = this.selectedObjects_.length; i > 0; --i) {
            if (this.objectsSelected_ == null || this.objectsSelected_.get(i - 1)) continue;
            int maxIdx = i - 1;
            while (i > 0 && !this.objectsSelected_.get(i - 1)) {
                --i;
            }
            try {
                this.query_.trimObjects(i, maxIdx);
            }
            catch (CMCacheException e) {
                CMException cmex = new CMException(e, "cmErrResetResultSet");
                CMIndications.logException(cmex);
            }
            if (i == 0) break;
        }
        try {
            this.selectedObjects_ = this.query_.resultObjects();
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException(e, "cmErrResetResultSet");
            CMIndications.logException(cmex);
        }
        this.objectsSelected_ = null;
    }

    @Override
    public void rewind() throws CMException {
        try {
            if (this.rs_ != null && this.rs_.getRow() != 1) {
                this.rs_.beforeFirst();
            }
            this.currObjectIndex_ = -1;
        }
        catch (SQLException e) {
            CMException cmex = new CMException(e, "cmErrResetResultSet");
            throw cmex;
        }
    }

    @Override
    public int delete(boolean clearInvalidReferences) throws CMException {
        return this.store_.delete(this, clearInvalidReferences);
    }

    @Override
    public int delete2(boolean clearInvalidReferences, Integer maxObjsInTransaction) throws CMException {
        return this.store_.delete2(this, clearInvalidReferences, maxObjsInTransaction);
    }

    @Override
    public void update(List<CMProperty> props, List<Object> values, Map<String, Object> additionalParameters) throws CMException {
        this.store_.update(this, props, values, additionalParameters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getValues() throws CMException {
        int dbPropCount = this.selectStmt_.getDbPropertyCount();
        int[] columnMap = this.selectStmt_.getDbPropertyMap();
        CMProperty[] properties = this.selectStmt_.getProperties();
        if (this.values_ == null) {
            if (dbPropCount > 0) {
                this.values_ = new Object[dbPropCount];
                this.wasAcquiredSet_ = new BitSet(dbPropCount);
            }
        } else {
            for (int i = 0; i < this.values_.length; ++i) {
                this.values_[i] = null;
            }
            this.wasAcquiredSet_.xor(this.wasAcquiredSet_);
        }
        try {
            this.currObjectID_ = this.rs_.getInt(1);
            this.calculateReferences();
            this.currPolicies_ = null;
            this.currUCPolicies_ = null;
            this.currObjectClass_ = null;
            this.currExternalProps_ = null;
            this.currOwner_ = null;
            this.accManName = null;
            this.currCreationTime_ = null;
            this.currObjectState_ = 1;
            this.userCapabilities_ = null;
            this.userCapabilitiesCalculated_ = false;
            try {
                int classID = this.store_.getCache().CMCacheGetClass(this.currObjectID_);
                this.currObjectClass_ = (CMDbObjectClass)this.store_.getObjectClasses().getClassByID(classID);
            }
            catch (CMCacheException ex2) {
                throw new CMStoreUnexpected(ex2, "cmStoreUnexpectedNoObjectClass");
            }
            int propOffset = 2;
            String externalID = null;
            int contentLocaleIdx = -1;
            int productLocaleIdx = -1;
            boolean needsName = false;
            int propsize = properties == null ? 0 : properties.length;
            int idx = 0;
            while (true) {
                block22: {
                    CMDbProperty prop;
                    block27: {
                        block23: {
                            block26: {
                                block24: {
                                    block25: {
                                        if (idx >= propsize) {
                                            this.handleAcquiredProps();
                                            this.handleExternalProps(externalID, productLocaleIdx, contentLocaleIdx, needsName);
                                            return;
                                        }
                                        if (this.propertyIsName(properties[idx]) && this.currObjectClass_ != CMObjectClass.NAMESPACE) {
                                            needsName = true;
                                        }
                                        if (idx >= dbPropCount) break block22;
                                        prop = (CMDbProperty)properties[columnMap[idx]];
                                        if (prop.columnCount() <= 0) break block23;
                                        if (!prop.isStoredAsArray() || prop.isStoreIDBased() && prop.getMaxOccurs() == 1) break block24;
                                        if (this.currObjectClass_ != CMObjectClass.ACCOUNT || prop != CMProperty.PARAMETERS) break block25;
                                        this.parametersIdx = idx;
                                        --propOffset;
                                        break block26;
                                    }
                                    if (prop != CMProperty.NAME) {
                                        this.values_[idx] = UNSET;
                                    }
                                    --propOffset;
                                    break block22;
                                }
                                CMPropertyHandler handler = this.getPropertyHandler(prop);
                                this.values_[idx] = handler.getValue(idx + propOffset, this.rs_);
                                if (handler.isValueAcquired()) {
                                    this.wasAcquiredSet_.set(idx);
                                }
                            }
                            if (prop == CMProperty.PRODUCTLOCALE) {
                                productLocaleIdx = idx;
                            } else if (prop == CMProperty.CONTENTLOCALE) {
                                contentLocaleIdx = idx;
                            } else if (prop == CMProperty.PARAMETERS && this.currObjectClass_ == CMObjectClass.ACCOUNT) {
                                this.parametersIdx = idx;
                                --propOffset;
                            }
                            if (!prop.isDefaultMultilingualProperty()) {
                                propOffset += prop.columnCount() - 1;
                            }
                            break block27;
                        }
                        if (prop.getBehaviourName() == "evalDBPredicate") {
                            this.values_[idx] = CMDbStorePropertySerialization.getColumnByProperty(this.rs_, idx + propOffset, prop);
                        } else {
                            this.values_[idx] = null;
                            --propOffset;
                        }
                    }
                    this.setPersistedValue(prop, this.values_[idx]);
                    if (prop == CMProperty.ID && this.values_[idx] != null) {
                        externalID = this.values_[idx].toString();
                    }
                }
                ++idx;
            }
        }
        catch (SQLException e) {
            CMDbStoreExceptionUtil.handleSQLException(this.store_.getConnection(), e, "cmUnexpectedResultProcessingFailure");
        }
    }

    private CMPropertyHandler getPropertyHandler(CMDbProperty prop) throws CMException {
        this.initAcquiredPropertiesHandler();
        return this.propertyHandlerProvider.getHandler(this.currObjectClass_, prop, this.currObjectID_, this.selectStmt_, this.acquiredProperties_);
    }

    private void initAcquiredPropertiesHandler() {
        if (this.acquiredProperties_ == null) {
            this.acquiredProperties_ = new CMDbStoreAcquiredPropertiesHandler(this.store_, this.selectStmt_);
        }
    }

    private boolean propertyIsName(CMProperty property) {
        return property == CMProperty.NAME || property == CMProperty.DEFAULTNAME;
    }

    private void handleExternalProps(String externalID, int productLocaleIdx, int contentLocaleIdx, boolean needsName) throws CMException {
        int[] columnMap = this.selectStmt_.getDbPropertyMap();
        CMProperty[] properties = this.selectStmt_.getProperties();
        int externalPropCount = this.selectStmt_.getExternalPropertyCount();
        int[] externalProps = this.selectStmt_.getExternalPropertyMap();
        if (this.currObjectClass_.isExternal()) {
            if (externalID == null) {
                externalID = CMCAMIDHelper.CAMIDFromSearchPath(this.getSearchPath());
            }
            if (externalID != null) {
                if (CMCAMIDHelper.CAMIDIsExternal(externalID)) {
                    boolean needParamFromExt;
                    this.currObjectState_ |= 2;
                    if (CMCAMIDHelper.isOpenIDNamespaceObject(externalID) && this.currObjectClass_ != CMObjectClass.NAMESPACE && !externalID.equals(CMExecutionContext.get().getCurrentUser())) {
                        return;
                    }
                    boolean bl = needParamFromExt = this.parametersIdx != -1 && this.currObjectClass_ == CMObjectClass.ACCOUNT;
                    if (externalPropCount > 0 || this.needLocales(productLocaleIdx, contentLocaleIdx) || this.parametersIdx != -1) {
                        int numSearchProps = this.getNumberSearchProps(productLocaleIdx, contentLocaleIdx, needsName, externalPropCount, needParamFromExt);
                        CMProperty[] externProps = this.getExternProps(productLocaleIdx, contentLocaleIdx, needsName, columnMap, properties, externalPropCount, externalProps, needParamFromExt, numSearchProps);
                        this.currExternalProps_ = new CMAAAObjectPropertiesDoc(this.currObjectClass_, externalID, externProps);
                        this.populateValues(productLocaleIdx, contentLocaleIdx, needsName, externalPropCount, externalProps, needParamFromExt);
                    }
                } else if (this.currObjectClass_ == CMObjectClass.NAMESPACE && externalPropCount > 0) {
                    CMProperty[] externProps = new CMProperty[externalPropCount];
                    for (int k = 0; k < externalPropCount; ++k) {
                        externProps[k] = properties[columnMap[externalProps[k]]];
                        if (externProps[k] != CMProperty.CAPABILITIES) continue;
                        CMDbStoreStringArray cogCaps = new CMDbStoreStringArray();
                        cogCaps.add("contains");
                        cogCaps.add("equals");
                        cogCaps.add("startsWith");
                        cogCaps.add("sort");
                        this.values_[externalProps[k]] = cogCaps;
                    }
                }
            }
        }
    }

    private CMProperty[] getExternProps(int productLocaleIdx, int contentLocaleIdx, boolean needsName, int[] columnMap, CMProperty[] properties, int externalPropCount, int[] externalProps, boolean needParamFromExt, int numSearchProps) {
        CMProperty[] externProps = new CMProperty[numSearchProps];
        for (int j = 0; j < externalPropCount; ++j) {
            externProps[j] = properties[columnMap[externalProps[j]]];
        }
        if (productLocaleIdx != -1 && this.values_[productLocaleIdx] == null) {
            externProps[j++] = CMProperty.PRODUCTLOCALE;
        }
        if (contentLocaleIdx != -1 && this.values_[contentLocaleIdx] == null) {
            externProps[j++] = CMProperty.CONTENTLOCALE;
        }
        if (needParamFromExt) {
            externProps[j++] = CMProperty.PARAMETERS;
        }
        if (needsName) {
            externProps[j++] = CMProperty.DEFAULTNAME;
        }
        return externProps;
    }

    private boolean needLocales(int productLocaleIdx, int contentLocaleIdx) {
        boolean needLocales = false;
        if (productLocaleIdx != -1 && this.values_[productLocaleIdx] == null || contentLocaleIdx != -1 && this.values_[contentLocaleIdx] == null) {
            needLocales = true;
        }
        return needLocales;
    }

    private void populateValues(int productLocaleIdx, int contentLocaleIdx, boolean needsName, int externalPropCount, int[] externalProps, boolean needParamFromExt) {
        int j1;
        for (j1 = 0; j1 < externalPropCount; ++j1) {
            if (!this.currExternalProps_.hasProperty(j1) || this.currExternalProps_.isModifyableProperty(j1)) continue;
            this.values_[externalProps[j1]] = this.currExternalProps_.getValue(j1);
        }
        if (productLocaleIdx != -1 && this.values_[productLocaleIdx] == null) {
            this.values_[productLocaleIdx] = this.currExternalProps_.getValue(j1++);
            this.wasAcquiredSet_.set(productLocaleIdx);
            this.wasAcquired_ = true;
        }
        if (contentLocaleIdx != -1 && this.values_[contentLocaleIdx] == null) {
            this.values_[contentLocaleIdx] = this.currExternalProps_.getValue(j1++);
            this.wasAcquiredSet_.set(contentLocaleIdx);
            this.wasAcquired_ = true;
        }
        if (needParamFromExt) {
            this.values_[this.parametersIdx] = this.currExternalProps_.getValue(j1++);
        }
        if (needsName) {
            this.accManName = (CMDbStoreString)this.currExternalProps_.getValue(j1++);
        }
    }

    private int getNumberSearchProps(int productLocaleIdx, int contentLocaleIdx, boolean needsName, int externalPropCount, boolean needParamFromExt) {
        int numSearchProps = externalPropCount;
        if (productLocaleIdx != -1 && this.values_[productLocaleIdx] == null) {
            ++numSearchProps;
        }
        if (contentLocaleIdx != -1 && this.values_[contentLocaleIdx] == null) {
            ++numSearchProps;
        }
        if (needParamFromExt) {
            ++numSearchProps;
        }
        if (needsName) {
            ++numSearchProps;
        }
        return numSearchProps;
    }

    private void handleAcquiredProps() throws CMException, CMStoreUnexpected {
        if (this.acquiredProperties_ == null) {
            return;
        }
        HashMap<CMProperty, CMDbStoreAcquiredValue> props = this.acquiredProperties_.populateAcquiredValues(this.currObjectID_, this.values_, this.wasAcquiredSet_);
        if (props != null) {
            for (CMProperty prop : props.keySet()) {
                this.setPersistedValue(prop, props.get(prop).getValue());
            }
        }
    }

    private void setPersistedValue(CMProperty prop, Object value) throws CMStoreUnexpected {
        if (value == null) {
            return;
        }
        if (prop == CMProperty.USERCAPABILITYPOLICIES) {
            this.currUCPolicies_ = (byte[])value;
        } else if (prop == CMProperty.POLICIES) {
            this.currPolicies_ = (byte[])value;
        } else if (prop == CMProperty.OWNER) {
            CMBaseClassArray arr = (CMBaseClassArray)value;
            this.currOwner_ = (CMDbStoreObjectReference)arr.getItem(0);
        } else if (prop == CMProperty.CREATIONTIME) {
            String dateString = value.toString();
            try {
                this.currCreationTime_ = DateUtils.parse((String)dateString);
            }
            catch (Exception ex) {
                throw new CMStoreUnexpected(new CMException((Exception)new CMException(ex, "cmBadDateProp", new CMException.Parm("Value", dateString)), "cmFailReadProp", new CMException.Parm("Class", this.currObjectClass_ != null ? this.currObjectClass_.getName() : "Unknown Class"), new CMException.Parm("Property", CMProperty.CREATIONTIME.getName())), "cmUnexpectedResultProcessingFailure");
            }
        }
    }

    @Override
    public boolean hasPermission(String permission) {
        if (this.bReset_) {
            throw new IllegalStateException();
        }
        return this.securityHandler_.hasPermission(permission);
    }

    @Override
    public boolean hasExternalProperty(CMProperty property) {
        int i;
        if (this.bReset_) {
            throw new IllegalStateException();
        }
        int[] columnMap = this.selectStmt_.getDbPropertyMap();
        CMProperty[] properties = this.selectStmt_.getProperties();
        int externalPropCount = this.selectStmt_.getExternalPropertyCount();
        int[] externalProperties = this.selectStmt_.getExternalPropertyMap();
        if (!property.isExternal()) {
            throw new IllegalStateException("hasExternalProperty called for a non external property");
        }
        for (i = 0; i < externalPropCount && properties[columnMap[externalProperties[i]]] != property; ++i) {
        }
        if (i == externalPropCount || this.currExternalProps_ == null) {
            return false;
        }
        return this.currExternalProps_.getValue(i) != null;
    }

    @Override
    public int getState() {
        if (this.bReset_) {
            throw new IllegalStateException();
        }
        return this.currObjectState_;
    }

    private void calculateReferences() {
        this.currObjectIndex_ = Arrays.binarySearch(this.selectedObjects_, this.currObjectID_);
    }

    @Override
    public CMStoreQueryResults move(int parent_objid, String sNewFileName) throws CMException {
        return this.store_.move(this.query_, parent_objid, sNewFileName);
    }

    @Override
    public CMCacheQueryInstance getQuery() {
        return this.query_;
    }

    @Override
    public CMCacheQueryInstance getQuery(boolean bRemove) {
        CMCacheQueryInstance ret = this.query_;
        this.query_ = null;
        return ret;
    }

    @Override
    public CMObjectClass getObjectClass() {
        return this.currObjectClass_;
    }

    @Override
    public void setIsMembershipQuery() {
        this.bReturnReferencesAsSearchPath_ = CMExecutionContext.get().executingStaticRequest();
    }

    @Override
    public void setIsCAMInternal(boolean camInternal) {
        this.bReturnReferencesAsSearchPath_ = camInternal;
    }

    private void calculateUserCapabilitiesOnObj(CMProperty prop) {
        boolean bGrantAll;
        if (this.userCapabilitiesCalculated_) {
            return;
        }
        ArrayList<String> capabilities = new ArrayList<String>();
        for (String capability : prop.getSupportedEnumValues()) {
            if (!ComponentDependentCapabilities.isCapabilitySupported(capability)) continue;
            capabilities.add(capability);
        }
        int[] ucPoliciesResult = null;
        CMExecutionContext context = CMExecutionContext.get();
        boolean bl = bGrantAll = context.executingStaticRequest() || context.getCurrentUserIsAdministrator();
        if (!bGrantAll) {
            bGrantAll = this.securityHandler_.isCurrentUserOwnerOf(this.currObjectID_);
        }
        if (!bGrantAll) {
            bGrantAll = this.isMyFolders(context);
        }
        if (bGrantAll) {
            ucPoliciesResult = AznUtil.getAllGrantedResults(capabilities);
        } else if (this.currUCPolicies_ != null) {
            try {
                AznUtil azn = new AznUtil(this.store_.getAAA(), context.getAccManPassportID(), context.getCAMAdditionalInfo());
                ucPoliciesResult = azn.bulkCheckAccess(this.currUCPolicies_, capabilities, false);
            }
            catch (AAAException ex) {
                CMIndications.logException(ex);
            }
        }
        this.userCapabilities_ = new CMDbStoreUserCapabilities(capabilities.size());
        if (ucPoliciesResult != null) {
            for (int j = 0; j < ucPoliciesResult.length; ++j) {
                if (ucPoliciesResult[j] != 0) continue;
                this.userCapabilities_.add(capabilities.get(j));
            }
            this.userCapabilitiesCalculated_ = true;
        }
    }

    private boolean isMyFolders(CMExecutionContext context) {
        try {
            CMAncestors ancestors = this.store_.getCache().getAncestors(this.currObjectID_);
            if (ancestors != null && ancestors.getSize() > 2) {
                if (!"directory".equals(ancestors.getObjectClass(0))) {
                    return false;
                }
                for (int i = 1; i < ancestors.getSize(); ++i) {
                    if (!"account".equals(ancestors.getObjectClass(i))) continue;
                    return ancestors.getSearchPath(i).equals(context.getCurrentUserSearchPath());
                }
            }
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
        return false;
    }

    private CMDbStoreUserCapabilities calculateEffectiveCapabilities(int size) throws CMException {
        CMDbStoreUserCapabilities ret = new CMDbStoreUserCapabilities(size);
        if (this.userCapabilities_ == null || this.userCapabilities_.getSize() == 0) {
            return ret;
        }
        ExtendedUserCapabilities userCaps = CMExecutionContext.get().getUserCapabilities();
        for (String s : this.userCapabilities_.items()) {
            if (!userCaps.hasCapability(s)) continue;
            ret.add(s);
        }
        return ret;
    }

    @Override
    public int getDefaultOutput(int[] supportedFormats) throws CMException {
        return CMDbStoreDefaultOutput.getDefaultOutput(this.query_, this.securityHandler_.getGrantedPermissions(), this.currObjectIndex_, supportedFormats);
    }

    @Override
    public CMStore getStore() {
        return this.store_;
    }
}

