/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.dbstore.CMDbStoreDefaultOutput;
import com.cognos.cm.dbstore.CMDbStoreLockUtil;
import com.cognos.cm.dbstore.CMDbStoreObjectsBase;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbStore;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.dbstore.properties.CMDbStorePermissions;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMDescendantModifiedProperty;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.ICMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.routing.RoutingManager;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStorePathFunctionArgument;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStorePredicateStringLiteral;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMIntList;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;

public class CMDbStoreCacheObjects
extends CMDbStoreObjectsBase {
    private boolean bReturnReferencesAsSearchPath_;
    int currObjectID_;
    int currObjectIndex_ = -1;
    int currObjectState_;
    CMObjectClass currObjectClass_;
    String currObjectPath_;
    boolean wasAcquired_;
    BitSet objectsSelected_;
    int[] selectedObjects_;
    CMCacheQueryInstance query_;
    ICMDbStore store_;

    public CMDbStoreCacheObjects(ICMDbStore store, ICMProperty[] properties, CMCacheQueryInstance query2) throws CMException {
        super(properties);
        this.query_ = query2;
        this.store_ = store;
        try {
            this.selectedObjects_ = query2.resultObjects();
        }
        catch (CMCacheException e) {
            throw new CMStoreUnexpected(e, "cmStoreUnexpectedCacheQuery");
        }
        if (this.selectedObjects_.length == 0) {
            return;
        }
        this.objectsSelected_ = new BitSet(this.selectedObjects_.length);
    }

    protected CMDbStoreCacheObjects(CMDbStore store, int[] resultObjects) throws CMException, CMCacheAccessDenied {
        super(null);
        CMIntList objs = new CMIntList(resultObjects.length);
        for (int i = 0; i < resultObjects.length; ++i) {
            if (resultObjects[i] < 0) continue;
            objs.add(resultObjects[i]);
        }
        int[] cacheObjs = objs.toArray();
        if (cacheObjs.length > 0) {
            CMStoreXPath path = new CMStoreXPath("/*");
            String cacheQueryPath = path.getCacheQueryPath();
            this.query_ = store.getCache().executeAdminQuery(cacheObjs, cacheObjs.length, cacheQueryPath, 0, CMDbStoreLockUtil.getLockUsageFromAction(0), true);
        } else {
            this.query_ = null;
        }
        this.store_ = store;
        this.selectedObjects_ = cacheObjs;
        this.objectsSelected_ = new BitSet(cacheObjs.length);
    }

    public void finalize() throws Throwable {
        this.release();
    }

    @Override
    public void release() {
        try {
            if (this.query_ != null) {
                try {
                    this.query_.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.query_ = null;
        }
    }

    @Override
    public boolean next() throws CMException {
        boolean bReturn = false;
        do {
            bReturn = false;
            ++this.currObjectIndex_;
            if (this.currObjectIndex_ < this.selectedObjects_.length) {
                this.currObjectID_ = this.selectedObjects_[this.currObjectIndex_];
                try {
                    CMStoreXPath path;
                    CMStorePathStep step;
                    this.currObjectClass_ = this.store_.getObjectClass(this.currObjectID_);
                    this.currObjectState_ = 1;
                    this.currObjectPath_ = null;
                    if (this.currObjectClass_ == null) {
                        throw new CMStoreUnexpected(null, "cmStoreUnexpectedNoObjectClass");
                    }
                    if (this.currObjectClass_.isExternal() && (step = (path = new CMStoreXPath(this.store_.getCache().CMCacheGetSearchPath(this.currObjectID_, CMDbStoreCacheUtil.getCacheSearchLocales()))).stepAt(0)).getNodeSetFunction() != null) {
                        CMStorePathPredicateFunction parsedFunc = (CMStorePathPredicateFunction)step.Predicates.get(0);
                        if (parsedFunc.args.size() > 0) {
                            CMStorePathFunctionArgument arg = (CMStorePathFunctionArgument)parsedFunc.args.get(0);
                            CMStorePredicateStringLiteral camidLiteral = (CMStorePredicateStringLiteral)arg.PredicateExpressions.get(0);
                            if (CMCAMIDHelper.CAMIDIsExternal(camidLiteral.literal)) {
                                this.currObjectState_ |= 2;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    throw new CMStoreUnexpected(ex, "cmStoreUnexpectedValueFail");
                }
                this.objectsSelected_.set(this.currObjectIndex_);
            }
            boolean bl = bReturn = this.currObjectIndex_ < this.selectedObjects_.length;
        } while (bReturn && this.currObjectClass_ == CMObjectClass._DELETEDOBJECT);
        return bReturn;
    }

    @Override
    public Object getValue(int index) throws CMException {
        if (this.properties_ == null || index < 0 || index >= this.properties_.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        CMDbProperty prop = (CMDbProperty)this.properties_[index];
        this.wasAcquired_ = false;
        try {
            if (prop == CMProperty.ANCESTORS) {
                return this.store_.getCache().getAncestors(this.currObjectID_, CMDbStoreCacheUtil.getCacheSearchLocales());
            }
            if (prop == CMProperty.SEARCHPATH) {
                return this.getSearchPath();
            }
            if (prop == CMProperty.SEARCHPATHFORURL) {
                CMCache cache = this.store_.getCache();
                return new CMDbStoreString(cache.CMCacheGetSearchPath(this.currObjectID_, CMDbStoreCacheUtil.getCacheSearchLocales()));
            }
            if (prop == CMProperty.NAME) {
                ArrayList<String> values = new ArrayList<String>();
                ArrayList<Integer> locales = new ArrayList<Integer>();
                this.store_.getCache().CMCacheGetAllNames(this.currObjectID_, values, locales);
                CMDbStoreLocalizedStringArray names = new CMDbStoreLocalizedStringArray();
                int nameCount = values.size();
                for (int nameIdx = 0; nameIdx != nameCount; ++nameIdx) {
                    names.add(new CMDbStoreLocalizedString(CMDbStoreStringLocales.findLocale((short)((Integer)locales.get(nameIdx)).intValue()), (String)values.get(nameIdx)));
                }
                return names;
            }
            if (prop == CMProperty.DEFAULTNAME) {
                return new CMDbStoreString(this.store_.getCache().CMCacheGetName(this.currObjectID_, CMDbStoreCacheUtil.getCacheSearchLocales()));
            }
            if (prop == CMProperty.OBJECTCLASS) {
                return this.currObjectClass_;
            }
            if (prop == CMProperty.STOREID) {
                String storeId = this.getStoreID();
                return storeId == null ? null : new CMDbStoreString(storeId);
            }
            if (prop == CMProperty.DISABLED) {
                int value = this.store_.getCache().CMCacheGetIntegerProperty(this.currObjectID_, 6);
                boolean disabledValue = false;
                if (value == 0) {
                    disabledValue = this.store_.getCache().CMCacheIsObjectDisabled(this.currObjectID_);
                    this.wasAcquired_ = true;
                } else {
                    disabledValue = value == 1;
                }
                return new CMDbStoreString(CMXMLUtils.getBooleanXMLValue(disabledValue));
            }
            if (prop == CMProperty.POLICIES) {
                byte[] value = null;
                try {
                    value = this.query_.getAcquiredPolicy(this.currObjectIndex_, 1);
                    if (value != null) {
                        this.wasAcquired_ = true;
                    }
                }
                catch (CMCacheException ex) {
                    throw new CMStoreUnexpected(ex, "cmStoreUnexpectedErrAquirePolicy");
                }
                return value;
            }
            if (prop == CMProperty.PARENT) {
                if (this.currObjectID_ == 0) {
                    return null;
                }
                int parentID = this.query_.objectParent(this.currObjectIndex_);
                String parentSearchPath = this.store_.getCache().CMCacheGetSearchPath(parentID, CMDbStoreCacheUtil.getCacheSearchLocales());
                String parentStoreID = this.store_.getObjectStoreID(parentID);
                CMDbStoreBaseClassArray value = new CMDbStoreBaseClassArray();
                CMDbStoreObjectReference reference = new CMDbStoreObjectReference(parentID, this.store_.getObjectClass(parentID), parentSearchPath);
                reference.setStoreID(parentStoreID);
                value.add(reference);
                return value;
            }
            if (prop.getBehaviourName() == "parameterString") {
                String parameterName = prop.getBehaviourParms().get(0).toString();
                String confValue = ConfigurationFactory.getConfig().getCognosProp(parameterName);
                if (confValue == null) {
                    return null;
                }
                return new CMDbStoreString(confValue);
            }
            if (prop.getBehaviourName() == "parameterBoolean") {
                String parameterName = prop.getBehaviourParms().get(0).toString();
                String confValue = ConfigurationFactory.getConfig().getCognosProp(parameterName);
                if (confValue == null) {
                    return null;
                }
                return new CMDbStoreString(CMXMLUtils.getBooleanXMLValue(CMXMLUtils.parseBooleanAttribute(confValue)));
            }
            if (prop.getBehaviourName() == "parameterPropertyValue") {
                String parameterName = prop.getBehaviourParms().get(0).toString();
                return ConfigurationFactory.getConfig().getObject(parameterName);
            }
            if (prop == CMProperty.LASTCONFIGURATIONMODIFICATIONTIME) {
                return CMDescendantModifiedProperty.get();
            }
            if (prop == CMProperty._HASRECIPIENTS) {
                return this.store_.getCache().CMCacheGetBooleanProperty(this.currObjectID_, 15);
            }
            if (prop == CMProperty._HASRECIPIENTSEMAIL) {
                return this.store_.getCache().CMCacheGetBooleanProperty(this.currObjectID_, 16);
            }
            if (prop == CMProperty.COMMONSYMMETRICKEY) {
                return CMExecutionContext.get().getCommonSymmetricKey();
            }
            if (prop == CMProperty.CACHEDCACERTIFICATES) {
                return CMExecutionContext.get().getCACertificates();
            }
            if (prop == CMProperty.HASCHILDREN) {
                return new CMDbStoreString(this.store_.getCache().CMCacheGetHasChildren(this.currObjectID_) ? "true" : "false");
            }
            if (prop == CMProperty.PACKAGEBASE) {
                CMAncestors propValue = this.store_.getCache().getAncestors(this.currObjectID_, CMDbStoreCacheUtil.getCacheSearchLocales());
                for (int ancestor = propValue.getSize() - 1; ancestor >= 0; --ancestor) {
                    String sClassName = propValue.getObjectClass(ancestor);
                    if (!sClassName.equalsIgnoreCase(CMObjectClass.PACKAGE.getName())) continue;
                    return new CMDbStoreString(propValue.getSearchPath(ancestor));
                }
                return new CMDbStoreString("/");
            }
            if (prop == CMProperty.DISPATCHERPATH) {
                String dpValue;
                if (this.currObjectClass_.hasProperty(prop) && (dpValue = this.store_.getCache().CMCacheGetName(this.currObjectID_, new int[]{0})) != null) {
                    return new CMDbStoreString(dpValue);
                }
                return null;
            }
            if (prop == CMProperty.TASKID || prop == CMProperty.EVENTID || prop == CMProperty.DOCUMENTID) {
                String dpValue;
                if (this.currObjectClass_.hasProperty(prop) && (dpValue = this.store_.getCache().CMCacheGetExactName(this.currObjectID_, 0)) != null) {
                    return new CMDbStoreString(dpValue);
                }
                return null;
            }
            if (prop.hasMeaning(CMPropertyMeaning.DEFAULTOUTPUTFORMAT)) {
                return CMDbStoreDefaultOutput.getDefaultOutputFormat(this.store_, this.query_, this.getSearchPath(), 0, this.currObjectIndex_);
            }
            if (prop == CMProperty.ID) {
                String idValue;
                if (this.currObjectClass_.hasProperty(prop) && (idValue = this.store_.getCache().CMCacheGetName(this.currObjectID_, new int[]{0})) != null) {
                    return new CMDbStoreString(idValue);
                }
                return null;
            }
            if (prop == CMProperty.PERMISSIONS) {
                if (CMExecutionContext.get().requireAccessCheck()) {
                    throw new IllegalStateException("Should not be retrieving the permissions property through this class unless current security context is administrator or fully trusted");
                }
                CMDbStorePermissions value = new CMDbStorePermissions();
                int actnCount = CMConstants.ALL_ACTIONS.length;
                for (int actnIdx = 0; actnIdx != actnCount; ++actnIdx) {
                    value.add(CMConstants.ALL_ACTIONS[actnIdx]);
                }
                return value;
            }
            if (prop == CMProperty.ROUTINGSERVERGROUP) {
                return RoutingManager.getInstance().determineRouting(this.currObjectID_);
            }
            if (prop == CMProperty.ROUTINGSERVERGROUPEDITION) {
                return new CMDbStoreString("");
            }
            if (prop == CMProperty.TENANTID) {
                int tenantID = this.store_.getCache().CMCacheGetTenantID(this.currObjectID_);
                return new CMDbStoreString(this.store_.getTenantRegistry().getTenantIdStringFromInt(tenantID));
            }
            if (prop == CMProperty.VERSION) {
                int version = this.store_.getCache().getVersionNumber(this.currObjectID_);
                return new CMDbStoreString(Integer.toString(version));
            }
            if (prop.isStoredAsArray()) {
                return CMDbStoreUtil.getArray(this.store_.getICMDbConnection(), prop, this.currObjectID_);
            }
        }
        catch (CMCacheException e) {
            throw new CMStoreUnexpected(e, "cmStoreUnexpectedValueFail");
        }
        return null;
    }

    @Override
    public int getDefaultOutput(int[] supportedFormats) throws CMException {
        return CMDbStoreDefaultOutput.getDefaultOutput(this.query_, 0, this.currObjectIndex_, supportedFormats);
    }

    @Override
    public boolean wasAcquired() {
        return this.wasAcquired_;
    }

    @Override
    public int getObjectID() {
        return this.currObjectID_;
    }

    @Override
    public int[] getObjectIDs() {
        return this.selectedObjects_;
    }

    @Override
    public boolean hasChildren() {
        try {
            return this.store_.getCache().CMCacheGetHasChildren(this.currObjectID_);
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException((Exception)e, "cmErrCacheIn", new CMException.Parm("Location", "CacheObjects.hasChildren"));
            CMIndications.logException(cmex);
            return false;
        }
    }

    @Override
    public String getPath() {
        if (this.currObjectPath_ == null) {
            try {
                this.currObjectPath_ = this.query_.objectPath(this.currObjectIndex_, CMDbStoreCacheUtil.getCacheSearchLocales());
            }
            catch (Exception ex) {
                CMStoreUnexpected cmex = new CMStoreUnexpected(ex, "cmStoreUnexpectedValueFail");
                CMIndications.logException(cmex);
            }
        }
        return this.currObjectPath_;
    }

    @Override
    public String getSearchPath() {
        String sp;
        if (this.bReturnReferencesAsSearchPath_ && (sp = this.getSecurityReference()) != null) {
            return sp;
        }
        try {
            return this.store_.getCache().CMCacheGetSearchPath(this.currObjectID_, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (CMException e) {
            CMException cmex = new CMException((Exception)e, "cmErrCacheIn", new CMException.Parm("Location", "CacheObjects.getSearchPath"));
            CMIndications.logException(cmex);
            return null;
        }
    }

    @Override
    public InternalStoreId getInternalStoreID() {
        return this.store_.getInternalStoreId(this.currObjectID_);
    }

    @Override
    public String getStoreID() {
        try {
            return this.store_.getObjectStoreID(this.currObjectID_);
        }
        catch (CMException e) {
            CMException cmex = new CMException((Exception)e, "cmErrCacheIn", new CMException.Parm("Location", "CacheObjects.getStoreID"));
            CMIndications.logException(cmex);
            return null;
        }
    }

    @Override
    public int getParentObjectID() {
        return this.store_.getCache().CMCacheGetIntegerProperty(this.currObjectID_, 5);
    }

    @Override
    public String getParentSearchPath() {
        try {
            int parentID = this.store_.getCache().CMCacheGetIntegerProperty(this.currObjectID_, 5);
            return this.store_.getCache().CMCacheGetSearchPath(parentID, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException((Exception)e, "cmErrCacheAddRollBack", new CMException.Parm("Location", "CacheObjects.getSearchPath"));
            CMIndications.logException(cmex);
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
        return null;
    }

    @Override
    public int getTenantID() {
        return this.store_.getCache().CMCacheGetTenantID(this.currObjectID_);
    }

    @Override
    public int getVersion() {
        return this.store_.getCache().getVersionNumber(this.currObjectID_);
    }

    @Override
    public String getSecurityReference() {
        try {
            return this.store_.getCache().CMCacheGetSecurityReference(this.currObjectID_);
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException((Exception)e, "cmErrCacheIn", new CMException.Parm("Location", "CacheObjects.getName"));
            CMIndications.logException(cmex);
            return null;
        }
    }

    @Override
    public String getName() {
        try {
            return this.query_.objectName(this.currObjectIndex_, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException((Exception)e, "cmErrCacheIn", new CMException.Parm("Location", "CacheObjects.getName"));
            CMIndications.logException(cmex);
        }
        catch (CMException cMException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void exclude() {
        this.objectsSelected_.clear(this.currObjectIndex_);
    }

    @Override
    public void reset() {
        this.trim();
        this.currObjectIndex_ = -1;
    }

    private void trim() {
        boolean someRemoved = false;
        for (int i = this.selectedObjects_.length; i > 0; --i) {
            if (this.objectsSelected_ == null || this.objectsSelected_.get(i - 1)) continue;
            int maxIdx = i - 1;
            while (i > 0 && !this.objectsSelected_.get(i - 1)) {
                --i;
            }
            someRemoved = true;
            try {
                this.query_.trimObjects(i, maxIdx);
            }
            catch (CMCacheException e) {
                CMException cmex = new CMException(e, "cmErrResetQuery");
                CMIndications.logException(cmex);
            }
            if (i == 0) break;
        }
        if (someRemoved) {
            try {
                this.selectedObjects_ = this.query_.resultObjects();
            }
            catch (CMCacheException e) {
                CMException cmex = new CMException(e, "cmErrResetQuery");
                CMIndications.logException(cmex);
            }
        }
        this.objectsSelected_ = new BitSet(this.selectedObjects_.length);
        this.objectsSelected_.set(0, this.selectedObjects_.length);
    }

    @Override
    public void rewind() {
        this.currObjectIndex_ = 0;
    }

    @Override
    public int delete(boolean clearInvalidReferences) throws CMException {
        return this.store_.delete(this, clearInvalidReferences);
    }

    @Override
    public int delete2(boolean clearInvalidReferences, Integer maxObjsInTransaction) throws CMException {
        return this.store_.delete2(this, clearInvalidReferences, maxObjsInTransaction);
    }

    @Override
    public void update(List<CMProperty> props, List<Object> values, Map<String, Object> additionalParameters) throws CMException {
        this.store_.update(this, props, values, additionalParameters);
    }

    @Override
    public CMStoreQueryResults move(int parent_objid, String sNewFileName) throws CMException {
        return this.store_.move(this.query_, parent_objid, sNewFileName);
    }

    @Override
    public CMCacheQueryInstance getQuery() {
        return this.query_;
    }

    @Override
    public CMCacheQueryInstance getQuery(boolean bRemove) {
        CMCacheQueryInstance ret = this.query_;
        this.query_ = null;
        return ret;
    }

    @Override
    public boolean hasPermission(String permission) {
        if (CMExecutionContext.get().requireAccessCheck()) {
            throw new IllegalStateException("Should not be testing permission property through this class unless current security context is administrator or fully trusted");
        }
        return true;
    }

    @Override
    public int getState() {
        return this.currObjectState_;
    }

    @Override
    public boolean hasExternalProperty(CMProperty property) {
        throw new IllegalStateException("CMDbStoreCacheObjects.hasExternalProperty called for a non external property");
    }

    @Override
    public CMObjectClass getObjectClass() {
        return this.currObjectClass_;
    }

    @Override
    public void setIsMembershipQuery() {
        this.bReturnReferencesAsSearchPath_ = CMExecutionContext.get().executingStaticRequest();
    }

    @Override
    public void setIsCAMInternal(boolean camInternal) {
        this.bReturnReferencesAsSearchPath_ = camInternal;
    }

    @Override
    public CMStore getStore() {
        return this.store_;
    }
}

