/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.cache.ICacheAccessMan;
import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheComplexObjects;
import com.cognos.cm.dbstore.CMDbStoreCacheObjects;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStoreLockUtil;
import com.cognos.cm.dbstore.CMDbStoreSelectDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ObjectsWrapperQueryResults;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMStorePathPredicate;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMIntList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CMDbStoreCacheQueryResults
extends ObjectsWrapperQueryResults {
    private static CMStorePathStep burstOnlyStep_;
    private static CMStorePathStep burstMixedStep_;
    private static CMStorePathStep allChildrenStep_;
    private CMDbStore store_;

    protected CMDbStoreCacheQueryResults() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMDbStoreCacheQueryResults(CMDbStore store, ICMStorePath query2, CMProperty[] properties, OrderByField[] orderBy, int action, int permissionFlags, String AccManPassportID, List<String> appPerms) throws CMCacheException, CMCacheAccessDenied, CMException {
        this.store_ = store;
        CMCache cache = store.getCache();
        List<String> permissions = null;
        ArrayList<String> otherPermissions = null;
        int[] filterPermissions = null;
        int queryOpts = 0;
        int[] initialObjects = null;
        int objectCount = 0;
        String firstStepAsString = null;
        int initialObjectsStepIndex = -1;
        boolean bLastStepHasBurstChildren = false;
        if (query2 == null) {
            return;
        }
        CMStorePathStep firstStep = null;
        if (query2.size() > 0) {
            firstStep = query2.stepAt(0);
        }
        if (firstStep != null && firstStep.isDescendant() && query2.getCacheResults() == null && !firstStep.searchingByGloballyUniqueString()) {
            ResultSet rs = null;
            try {
                CMExecutionContext.checkCancelOrTimeOut();
                CMDbStoreSelectDef descendantQuery = this.newSelectDef(store.getConnection(), firstStep, null, null, false, false, null, true, action);
                rs = descendantQuery.execute(store.getConnection());
                initialObjects = new int[1024];
                while (rs.next()) {
                    if (objectCount == initialObjects.length) {
                        int[] newArray = new int[initialObjects.length + initialObjects.length / 2];
                        System.arraycopy(initialObjects, 0, newArray, 0, initialObjects.length);
                        initialObjects = newArray;
                    }
                    initialObjects[objectCount++] = rs.getInt(1);
                }
                if (objectCount == 0) {
                    CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
                    return;
                }
                firstStepAsString = "/" + firstStep.getCacheQuery();
                initialObjectsStepIndex = 0;
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
            }
            catch (SQLException ex) {
                CMDbStoreExceptionUtil.handleSQLException(store.getConnection(), ex, "cmUnexpectedResultProcessingFailure");
            }
            finally {
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
            }
        }
        if ((permissionFlags & 0x200) == 0) {
            if (permissionFlags != 0) {
                if ((permissionFlags & 2) != 0) {
                    if (appPerms == null) {
                        appPerms = new ArrayList<String>();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(appPerms, "write");
                }
                if ((permissionFlags & 1) != 0 || (permissionFlags & 0x400) != 0) {
                    if (appPerms == null) {
                        appPerms = new ArrayList<String>();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(appPerms, "read");
                }
                if ((permissionFlags & 0x400) != 0) {
                    queryOpts |= 0x10;
                }
                if ((permissionFlags & 4) != 0) {
                    if (appPerms == null) {
                        appPerms = new ArrayList<String>();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(appPerms, "setPolicy");
                }
                if ((permissionFlags & 0x10) != 0) {
                    queryOpts |= 4;
                }
            }
            if (query2.size() > 0) {
                List<String> filterPerms;
                CMStorePathStep step = query2.stepAt(query2.size() - 1);
                if (step.requiresReadAccess()) {
                    if (appPerms == null) {
                        appPerms = new ArrayList<String>();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(appPerms, "read");
                }
                if ((permissionFlags & 0x4000) != 0 && (filterPerms = step.getFilterPermissions()) != null && filterPerms.size() > 0) {
                    otherPermissions = new ArrayList();
                    filterPermissions = new int[filterPerms.size()];
                    for (int i = 0; i < filterPerms.size(); ++i) {
                        filterPermissions[i] = CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, filterPerms.get(i));
                    }
                }
            }
            permissions = appPerms;
            if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "write")) {
                if (otherPermissions == null) {
                    otherPermissions = new ArrayList<String>();
                }
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "write");
            }
            if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "setPolicy")) {
                if (otherPermissions == null) {
                    otherPermissions = new ArrayList();
                }
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "setPolicy");
            }
            if ((permissionFlags & 0x20) != 0) {
                if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "read")) {
                    if (otherPermissions == null) {
                        otherPermissions = new ArrayList();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "read");
                }
                if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "write")) {
                    if (otherPermissions == null) {
                        otherPermissions = new ArrayList();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "read");
                }
                if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "setPolicy")) {
                    if (otherPermissions == null) {
                        otherPermissions = new ArrayList();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "setPolicy");
                }
                if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "execute")) {
                    if (otherPermissions == null) {
                        otherPermissions = new ArrayList();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "execute");
                }
                if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "traverse")) {
                    if (otherPermissions == null) {
                        otherPermissions = new ArrayList();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "traverse");
                }
            }
            if ((permissionFlags & 0x40) != 0 && !CMDbStoreCacheQueryResults.hasPermission(appPerms, "execute")) {
                if (otherPermissions == null) {
                    otherPermissions = new ArrayList();
                }
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "execute");
            }
            if ((permissionFlags & 0x80) != 0) {
                if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "traverse")) {
                    if (otherPermissions == null) {
                        otherPermissions = new ArrayList();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "traverse");
                }
                queryOpts = action == 2 || action == 8 ? (queryOpts |= 0x80) : (queryOpts |= 8);
            }
            if ((permissionFlags & 0x800) != 0) {
                if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "execute")) {
                    if (otherPermissions == null) {
                        otherPermissions = new ArrayList();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "execute");
                }
                queryOpts |= 0x20;
            }
            if ((permissionFlags & 8) != 0) {
                if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "setPolicy")) {
                    if (otherPermissions == null) {
                        otherPermissions = new ArrayList();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "setPolicy");
                }
                queryOpts |= 1;
            }
            if (CMExecutionContext.get().getServiceId() != null && !CMDbStoreCacheQueryResults.hasPermission(appPerms, "execute")) {
                if (otherPermissions == null) {
                    otherPermissions = new ArrayList();
                }
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "execute");
            }
        }
        ICacheAccessMan accMan = cache.newCacheAccessMan(AccManPassportID, queryOpts, permissions, otherPermissions, permissionFlags);
        if ((permissionFlags & 0x1000) != 0) {
            queryOpts |= 0x40;
        }
        if (action == 4 || action == 2 || action == 8) {
            queryOpts |= 2;
        }
        CacheQueryInitialObjects queryInitialObjects = new CacheQueryInitialObjects();
        queryInitialObjects.firstStepAsString = firstStepAsString;
        queryInitialObjects.initialObjects = initialObjects;
        queryInitialObjects.initialObjectsStepIndex = initialObjectsStepIndex;
        queryInitialObjects.objectCount = objectCount;
        CMExecutionContext.checkCancelOrTimeOut();
        queryInitialObjects = this.processDbSteps(store, queryInitialObjects, query2, action, permissionFlags, AccManPassportID);
        if (queryInitialObjects != null) {
            if (queryInitialObjects.objectCount == 0) {
                return;
            }
            firstStepAsString = queryInitialObjects.firstStepAsString;
            initialObjects = queryInitialObjects.initialObjects;
            initialObjectsStepIndex = queryInitialObjects.initialObjectsStepIndex;
            objectCount = queryInitialObjects.objectCount;
            bLastStepHasBurstChildren = queryInitialObjects.lastStepHasBurstChildren;
        }
        CMCacheQueryInstance cacheQuery = null;
        try {
            CMExecutionContext.checkCancelOrTimeOut();
            if (bLastStepHasBurstChildren) {
                CMStorePathStep lastStep = query2.stepAt(initialObjectsStepIndex + 1);
                cacheQuery = this.performBurstOptimizedQuery(store, initialObjects, objectCount, lastStep, action, accMan);
                if (cacheQuery == null) {
                    return;
                }
            } else if (initialObjects != null) {
                cacheQuery = store.getCache().executeQuery(initialObjects, objectCount, firstStepAsString + query2.getCacheQueryPath(initialObjectsStepIndex + 1), action, CMDbStoreLockUtil.getLockUsageFromAction(action), query2.getLocksHaveBeenObtained(), accMan);
            } else if (query2.getCacheResults() == null) {
                cacheQuery = store.getCache().executeQuery(query2, action, accMan);
            } else {
                int[] resultsObjs = query2.getCacheResults();
                query2.setCacheResults(null);
                String queryString = null;
                CMStorePathStep lastStep = query2.stepAt(query2.size() - 1);
                queryString = lastStep.getNodeSetFunction() == CMConstants.FUNC_STOREID_DEF ? "/*" : "/" + lastStep.getCacheQuery();
                cacheQuery = store.getCache().executeQuery(resultsObjs, resultsObjs.length, queryString, action, CMDbStoreLockUtil.getLockUsageFromAction(action), query2.getLocksHaveBeenObtained(), accMan);
            }
            boolean filterBurstOutput = false;
            if (bLastStepHasBurstChildren) {
                filterBurstOutput = false;
            } else {
                try {
                    if (action != 2 && action != 8 && (permissionFlags & 0x200) == 0 && CMExecutionContext.get().requireAccessCheck()) {
                        filterBurstOutput = CMDbStoreUtil.mightSelectBurstOutput(store, cacheQuery);
                    }
                }
                catch (Exception queryString) {
                    // empty catch block
                }
            }
            if (!(permissions == null && otherPermissions == null || CMExecutionContext.get().getCurrentUserIsAdministrator() || !cacheQuery.getSelectionHasPolicies() && orderBy == null)) {
                properties = CMDbStoreCacheQueryResults.addPermissionProperties(properties);
            }
            CMStorePathStep step = null;
            if (query2.size() > 0) {
                step = query2.stepAt(query2.size() - 1);
            }
            CMDbStoreSelectDef selectStmt = null;
            int[] objectIDs = cacheQuery.resultObjects();
            Object[] ancestorIds = null;
            if (step != null && step.hasAcquirablePropertyPredicate()) {
                ancestorIds = CMDbStoreUtil.getAncestorIds(store, objectIDs);
            }
            this.objects_ = (selectStmt = this.newSelectDef(store.getConnection(), step, properties, orderBy, filterBurstOutput, true, cacheQuery.getDistinctSelectedClasses(), cacheQuery.getSelectionHasPolicies(), ancestorIds, objectIDs, action)).resolvableInCache() && (permissionFlags & 0x200) != 0 ? new CMDbStoreCacheObjects(store, selectStmt.getProperties(), cacheQuery) : new CMDbStoreCacheComplexObjects(store, selectStmt, permissions, filterPermissions, otherPermissions, queryOpts, cacheQuery, objectIDs);
            cacheQuery = null;
        }
        finally {
            if (cacheQuery != null) {
                try {
                    cacheQuery.release();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMDbStoreCacheQueryResults(CMDbStore store, int[] initialObjects, ICMStorePath query2, CMProperty[] properties, OrderByField[] orderBy, int action, int permissionFlags, String AccManPassportID, List<String> appPerms) throws CMCacheException, CMCacheAccessDenied, CMException {
        boolean bAdminQuery;
        List<String> permissions = null;
        ArrayList<String> otherPermissions = null;
        int[] filterPermissions = null;
        int queryOpts = 0;
        int objectCount = initialObjects.length;
        String firstStepAsString = null;
        int initialObjectsStepIndex = -1;
        boolean bLastStepHasBurstChildren = false;
        String checkPolicies = ConfigurationFactory.getConfig().getInternalProp("CMCheckPolicies");
        boolean bl = bAdminQuery = (permissionFlags & 0x200) != 0;
        if (checkPolicies != null && checkPolicies.equals("1")) {
            if (permissionFlags != 0) {
                if ((permissionFlags & 2) != 0) {
                    if (appPerms == null) {
                        appPerms = new ArrayList<String>();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(appPerms, "write");
                }
                if ((permissionFlags & 1) != 0 || (permissionFlags & 0x400) != 0) {
                    if (appPerms == null) {
                        appPerms = new ArrayList<String>();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(appPerms, "read");
                }
                if ((permissionFlags & 0x400) != 0) {
                    queryOpts |= 0x10;
                }
                if ((permissionFlags & 4) != 0) {
                    if (appPerms == null) {
                        appPerms = new ArrayList<String>();
                    }
                    CMDbStoreCacheQueryResults.addPermissionToList(appPerms, "setPolicy");
                }
                if ((permissionFlags & 0x10) != 0) {
                    queryOpts |= 4;
                }
            }
            permissions = appPerms;
        }
        if (!bAdminQuery) {
            if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "write")) {
                otherPermissions = new ArrayList<String>();
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "write");
            }
            if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "setPolicy")) {
                if (otherPermissions == null) {
                    otherPermissions = new ArrayList();
                }
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "setPolicy");
            }
        }
        if ((permissionFlags & 0x20) != 0) {
            if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "read")) {
                if (otherPermissions == null) {
                    otherPermissions = new ArrayList();
                }
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "read");
            }
            if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "write")) {
                if (otherPermissions == null) {
                    otherPermissions = new ArrayList();
                }
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "read");
            }
            if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "setPolicy")) {
                if (otherPermissions == null) {
                    otherPermissions = new ArrayList();
                }
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "setPolicy");
            }
            if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "execute")) {
                if (otherPermissions == null) {
                    otherPermissions = new ArrayList();
                }
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "execute");
            }
            if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "traverse")) {
                if (otherPermissions == null) {
                    otherPermissions = new ArrayList();
                }
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "traverse");
            }
        }
        if ((permissionFlags & 0x40) != 0 && !CMDbStoreCacheQueryResults.hasPermission(appPerms, "execute")) {
            if (otherPermissions == null) {
                otherPermissions = new ArrayList();
            }
            CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "execute");
        }
        if ((permissionFlags & 0x80) != 0) {
            if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "traverse")) {
                if (otherPermissions == null) {
                    otherPermissions = new ArrayList();
                }
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "traverse");
            }
            queryOpts = action == 2 || action == 8 ? (queryOpts |= 0x80) : (queryOpts |= 8);
        }
        if ((permissionFlags & 0x800) != 0) {
            if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "execute")) {
                if (otherPermissions == null) {
                    otherPermissions = new ArrayList();
                }
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "execute");
            }
            queryOpts |= 0x20;
        }
        if ((permissionFlags & 8) != 0) {
            if (!CMDbStoreCacheQueryResults.hasPermission(appPerms, "setPolicy")) {
                if (otherPermissions == null) {
                    otherPermissions = new ArrayList();
                }
                CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "setPolicy");
            }
            queryOpts |= 1;
        }
        if (!bAdminQuery && CMExecutionContext.get().getServiceId() != null && !CMDbStoreCacheQueryResults.hasPermission(appPerms, "execute")) {
            if (otherPermissions == null) {
                otherPermissions = new ArrayList();
            }
            CMDbStoreCacheQueryResults.addPermissionToList(otherPermissions, "execute");
        }
        ICacheAccessMan accMan = store.getCache().newCacheAccessMan(AccManPassportID, queryOpts, permissions, otherPermissions, permissionFlags);
        if ((permissionFlags & 0x1000) != 0) {
            queryOpts |= 0x40;
        }
        if (action == 4 || action == 2 || action == 8) {
            queryOpts |= 2;
        }
        CacheQueryInitialObjects queryInitialObjects = new CacheQueryInitialObjects();
        queryInitialObjects.firstStepAsString = firstStepAsString;
        queryInitialObjects.initialObjects = initialObjects;
        queryInitialObjects.initialObjectsStepIndex = initialObjectsStepIndex;
        queryInitialObjects.objectCount = objectCount;
        if ((queryInitialObjects = this.processDbSteps(store, queryInitialObjects, query2, action, permissionFlags, AccManPassportID)) != null) {
            if (queryInitialObjects.objectCount == 0) {
                return;
            }
            firstStepAsString = queryInitialObjects.firstStepAsString;
            initialObjects = queryInitialObjects.initialObjects;
            initialObjectsStepIndex = queryInitialObjects.initialObjectsStepIndex;
            objectCount = queryInitialObjects.objectCount;
            bLastStepHasBurstChildren = queryInitialObjects.lastStepHasBurstChildren;
        }
        CMCacheQueryInstance cacheQuery = null;
        try {
            CMExecutionContext.checkCancelOrTimeOut();
            if (bLastStepHasBurstChildren) {
                if (allChildrenStep_ == null) {
                    CMStoreXPath allChildrenPath = new CMStoreXPath("/*");
                    allChildrenStep_ = allChildrenPath.stepAt(0);
                }
                if ((cacheQuery = this.performBurstOptimizedQuery(store, initialObjects, objectCount, allChildrenStep_, action, accMan)) == null) {
                    return;
                }
            } else if (query2 == null) {
                cacheQuery = store.getCache().executeQuery(initialObjects, objectCount, "/*", action, CMDbStoreLockUtil.getLockUsageFromAction(action), false, accMan);
            } else if (query2.getCacheResults() == null) {
                cacheQuery = firstStepAsString == null ? store.getCache().executeQuery(initialObjects, objectCount, query2, action, accMan) : store.getCache().executeQuery(initialObjects, objectCount, firstStepAsString + query2.getCacheQueryPath(initialObjectsStepIndex + 1), action, CMDbStoreLockUtil.getLockUsageFromAction(action), query2.getLocksHaveBeenObtained(), accMan);
            } else {
                int[] resultsObjs = query2.getCacheResults();
                query2.setCacheResults(null);
                String queryString = null;
                CMStorePathStep lastStep = query2.stepAt(query2.size() - 1);
                queryString = lastStep.getNodeSetFunction() == CMConstants.FUNC_STOREID_DEF ? "/*" : "/" + lastStep.getCacheQuery();
                cacheQuery = store.getCache().executeQuery(resultsObjs, resultsObjs.length, queryString, action, CMDbStoreLockUtil.getLockUsageFromAction(action), query2.getLocksHaveBeenObtained(), accMan);
            }
            boolean filterBurstOutput = false;
            if (bLastStepHasBurstChildren) {
                filterBurstOutput = false;
            } else {
                try {
                    if (action != 2 && action != 8 && !bAdminQuery && CMExecutionContext.get().requireAccessCheck()) {
                        filterBurstOutput = CMDbStoreUtil.mightSelectBurstOutput(store, cacheQuery);
                    }
                }
                catch (Exception queryString) {
                    // empty catch block
                }
            }
            if (!(permissions == null && otherPermissions == null || bAdminQuery || CMExecutionContext.get().getCurrentUserIsAdministrator())) {
                properties = CMDbStoreCacheQueryResults.addPermissionProperties(properties);
            }
            CMStorePathStep step = null;
            if (query2 != null && query2.size() > 0) {
                step = query2.stepAt(query2.size() - 1);
            }
            CMDbStoreSelectDef selectStmt = null;
            int[] objectIDs = cacheQuery.resultObjects();
            Object[] ancestorIds = null;
            if (step != null && step.hasAcquirablePropertyPredicate()) {
                ancestorIds = CMDbStoreUtil.getAncestorIds(store, objectIDs);
            }
            this.objects_ = (selectStmt = this.newSelectDef(store.getConnection(), step, properties, orderBy, filterBurstOutput, true, cacheQuery.getDistinctSelectedClasses(), cacheQuery.getSelectionHasPolicies(), ancestorIds, objectIDs, action)).resolvableInCache() && bAdminQuery ? new CMDbStoreCacheObjects(store, selectStmt.getProperties(), cacheQuery) : new CMDbStoreCacheComplexObjects(store, selectStmt, permissions, filterPermissions, otherPermissions, queryOpts, cacheQuery, objectIDs);
            cacheQuery = null;
        }
        finally {
            if (cacheQuery != null) {
                try {
                    cacheQuery.release();
                }
                catch (Exception allChildrenPath) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CacheQueryInitialObjects processDbSteps(CMDbStore store, CacheQueryInitialObjects queryInitialObjects, ICMStorePath query2, int action, int permissionFlags, String AccManPassportID) throws CMException, CMCacheAccessDenied {
        CacheQueryInitialObjects newQueryInitialObjects = null;
        String firstStepAsString = queryInitialObjects.firstStepAsString;
        int[] initialObjects = queryInitialObjects.initialObjects;
        int initialObjectsStepIndex = queryInitialObjects.initialObjectsStepIndex;
        int objectCount = queryInitialObjects.objectCount;
        boolean bFoundDBStep = false;
        if (query2 == null) {
            return newQueryInitialObjects;
        }
        int numSteps = query2.size();
        if (numSteps <= 1) {
            return newQueryInitialObjects;
        }
        int[] previousDBStepObjects = initialObjects;
        int previousDBStepObjectCount = objectCount;
        String previousDBCacheQueryString = firstStepAsString == null ? new String() : firstStepAsString;
        int previousDBStepIdx = initialObjectsStepIndex;
        boolean bAdminQuery = (permissionFlags & 0x200) > 0 || !CMExecutionContext.get().requireAccessCheck();
        boolean bIsDelete = action == 2 || action == 8;
        int stepIdx = previousDBStepIdx + 1;
        while (true) {
            boolean bNonDBStep;
            if (stepIdx >= numSteps - 1) {
                if (!bFoundDBStep) return newQueryInitialObjects;
                newQueryInitialObjects.firstStepAsString = previousDBCacheQueryString;
                newQueryInitialObjects.initialObjects = previousDBStepObjects;
                newQueryInitialObjects.initialObjectsStepIndex = previousDBStepIdx;
                newQueryInitialObjects.objectCount = previousDBStepObjectCount;
                return newQueryInitialObjects;
            }
            CMStorePathStep step = query2.stepAt(stepIdx);
            boolean bPenultimateStep = stepIdx == numSteps - 2;
            boolean bResolvableInCache = step.resolvableInCache();
            boolean bCheckIfBurstParent = step.isBurstStep() && !bAdminQuery && !bIsDelete;
            boolean bl = bNonDBStep = bResolvableInCache && !bCheckIfBurstParent;
            if (bNonDBStep) {
                if (firstStepAsString == null && stepIdx == 0 && step.getNodeSetFunction() == CMConstants.FUNC_STOREID_DEF) {
                    CMStorePathPredicateFunction parsedFunc = (CMStorePathPredicateFunction)step.Predicates.get(0);
                    previousDBCacheQueryString = parsedFunc.toCacheExpression(null);
                } else {
                    previousDBCacheQueryString = previousDBCacheQueryString + "/" + step.getCacheQuery();
                }
                if (bFoundDBStep) {
                    previousDBStepIdx = stepIdx;
                }
            } else {
                if (newQueryInitialObjects == null) {
                    newQueryInitialObjects = new CacheQueryInitialObjects();
                }
                bFoundDBStep = true;
                previousDBStepIdx = stepIdx;
                CMCacheQueryInstance cacheQuery = null;
                try {
                    String thisDBCacheQueryString = previousDBCacheQueryString + "/" + step.getCacheQuery();
                    CMExecutionContext.checkCancelOrTimeOut();
                    cacheQuery = store.getCache().executeQuery(previousDBStepObjects, previousDBStepObjectCount, thisDBCacheQueryString, action, CMDbStoreLockUtil.getLockUsageFromAction(action), true, store.getCache().newAccessMan(AccManPassportID));
                    int[] objectIDs = cacheQuery.resultObjects();
                    if (objectIDs == null || objectIDs.length == 0) {
                        newQueryInitialObjects.objectCount = 0;
                        CacheQueryInitialObjects cacheQueryInitialObjects = newQueryInitialObjects;
                        return cacheQueryInitialObjects;
                    }
                    boolean bIsBurstParent = false;
                    if (bCheckIfBurstParent) {
                        bIsBurstParent = store.getCache().useDBFiltering(objectIDs);
                        if (bIsBurstParent && bPenultimateStep && !bIsDelete) {
                            newQueryInitialObjects.lastStepHasBurstChildren = true;
                        }
                        previousDBStepObjects = objectIDs;
                        previousDBStepObjectCount = objectIDs.length;
                        previousDBCacheQueryString = "/*";
                    }
                    if (!bResolvableInCache) {
                        int numObjs;
                        CMIntList useObjectIDs = CMDbStoreSelectDef.executeStepInDB(store, step, objectIDs, false);
                        if (useObjectIDs == null || useObjectIDs.size() == 0) {
                            newQueryInitialObjects.objectCount = 0;
                            CacheQueryInitialObjects cacheQueryInitialObjects = newQueryInitialObjects;
                            return cacheQueryInitialObjects;
                        }
                        previousDBStepObjectCount = numObjs = useObjectIDs.size();
                        previousDBCacheQueryString = "/*";
                        int tmpSize = numObjs + 1023 & 0xFFFFFC00;
                        if (previousDBStepObjects == null) {
                            previousDBStepObjects = new int[tmpSize];
                        } else if (numObjs > previousDBStepObjects.length) {
                            int[] newArray = new int[tmpSize];
                            previousDBStepObjects = newArray;
                        }
                        for (int i = 0; i < numObjs; ++i) {
                            previousDBStepObjects[i] = useObjectIDs.get(i);
                        }
                    }
                }
                finally {
                    if (cacheQuery != null) {
                        try {
                            cacheQuery.release();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            ++stepIdx;
        }
    }

    int getDefaultOutput(int[] supportedFormats) throws CMException {
        return this.objects_.getDefaultOutput(supportedFormats);
    }

    public static boolean hasPermission(List<String> perms, String perm) {
        if (null == perms) {
            return false;
        }
        return perms.contains(perm);
    }

    public static int addPermissionToList(List<String> perms, String perm) {
        for (int i = 0; i < perms.size(); ++i) {
            if (!perms.get(i).equals(perm)) continue;
            return i;
        }
        perms.add(perm);
        return perms.size() - 1;
    }

    public static CMProperty[] addPermissionProperties(CMProperty[] properties) {
        if (properties != null) {
            boolean hasOwnerProp = false;
            boolean hasPolicies = false;
            for (int i = 0; i < properties.length; ++i) {
                if (properties[i] == CMProperty.OWNER) {
                    hasOwnerProp = true;
                    continue;
                }
                if (properties[i] != CMProperty.POLICIES) continue;
                hasPolicies = true;
            }
            int numProps2Add = 0;
            if (!hasPolicies) {
                ++numProps2Add;
            }
            if (!hasOwnerProp) {
                ++numProps2Add;
            }
            if (numProps2Add > 0) {
                CMProperty[] newProps = new CMProperty[properties.length + numProps2Add];
                System.arraycopy(properties, 0, newProps, 0, properties.length);
                if (!hasPolicies) {
                    newProps[properties.length + --numProps2Add] = CMProperty.POLICIES;
                }
                if (!hasOwnerProp) {
                    newProps[properties.length + --numProps2Add] = CMProperty.OWNER;
                }
                return newProps;
            }
            return properties;
        }
        return new CMProperty[]{CMProperty.POLICIES, CMProperty.OWNER};
    }

    @Override
    public boolean next() throws CMException {
        if (this.objects_ == null) {
            return false;
        }
        return this.objects_.next();
    }

    @Override
    public void rewind() throws CMException {
        if (this.objects_ != null) {
            this.objects_.rewind();
        }
    }

    @Override
    public boolean supportsRewind() {
        return true;
    }

    @Override
    public boolean supportsSkipObjects() {
        return false;
    }

    public void setIsMembershipQuery() {
        this.objects_.setIsMembershipQuery();
    }

    public void setIsCAMInternal(boolean camInternal) {
        this.objects_.setIsCAMInternal(camInternal);
    }

    private CMCacheQueryInstance performBurstOptimizedQuery(CMDbStore store, int[] objs, int numObjs, CMStorePathStep lastStep, int action, ICacheAccessMan accMan) throws CMCacheException, CMCacheAccessDenied, CMException {
        CMStoreXPath path;
        if (burstOnlyStep_ == null) {
            path = new CMStoreXPath("/*[matchesIdentity(@_UfRecipients)]");
            burstOnlyStep_ = path.stepAt(0);
        }
        if (burstMixedStep_ == null) {
            path = new CMStoreXPath("/*[( ( not(hasProperty('_recipientsEMail')) and not(hasProperty('_recipients') ) ) or matchesIdentity(@_UfRecipients) )]");
            burstMixedStep_ = path.stepAt(0);
        }
        CMStorePathStep filterStep = burstOnlyStep_;
        if (!AdvancedSettings.STRICTBURSTRECIPIENTSFILTER) {
            for (int i = 0; i < objs.length; ++i) {
                int type = store.getCache().CMCacheGetTypeOfChildren(objs[i]);
                if (type != 2 && type != 4) continue;
                filterStep = burstMixedStep_;
                break;
            }
        }
        CMStorePathPredicate pred = (CMStorePathPredicate)filterStep.Predicates.get(0);
        lastStep.appendPredicate(pred);
        int[] prevIDs = new int[numObjs];
        System.arraycopy(objs, 0, prevIDs, 0, numObjs);
        CMIntList useObjectIDs = CMDbStoreSelectDef.executeChildStepInDB(store, prevIDs, lastStep);
        int[] ids = useObjectIDs.toArray();
        int numIds = ids.length;
        if (numIds == 0) {
            return null;
        }
        lastStep.removePredicate(lastStep.numPredicates() - 1);
        CMExecutionContext.checkCancelOrTimeOut();
        boolean locksAcquired = true;
        CMCacheQueryInstance cacheQuery = store.getCache().executeQuery(ids, numIds, "/*" + lastStep.getCacheQuery(), action, CMDbStoreLockUtil.getLockUsageFromAction(action), locksAcquired, accMan);
        return cacheQuery;
    }

    private CMDbStoreSelectDef newSelectDef(CMDbConnection conn, CMStorePathStep step, CMProperty[] properties, OrderByField[] orderBys, boolean filterBurstOutput, boolean suppressCachePredicates, CMObjectClass[] selectedClasses, boolean selectPolicies, int action) throws CMStoreUnexpected {
        return this.newSelectDef(conn, step, properties, orderBys, filterBurstOutput, suppressCachePredicates, selectedClasses, selectPolicies, null, null, action);
    }

    private CMDbStoreSelectDef newSelectDef(CMDbConnection conn, CMStorePathStep step, CMProperty[] properties, OrderByField[] orderBys, boolean filterBurstOutput, boolean suppressCachePredicates, CMObjectClass[] selectedClasses, boolean selectPolicies, Object[] ancestorIds, int[] objectIds, int action) throws CMStoreUnexpected {
        CMDbStoreSelectDef selectDef = new CMDbStoreSelectDef(conn, step, properties, orderBys, filterBurstOutput, suppressCachePredicates, selectedClasses, selectPolicies, ancestorIds, objectIds, action);
        return selectDef;
    }

    @Override
    public CMStore getStore() {
        return this.store_;
    }

    private class CacheQueryInitialObjects {
        int[] initialObjects;
        int objectCount;
        String firstStepAsString;
        int initialObjectsStepIndex;
        boolean lastStepHasBurstChildren;

        private CacheQueryInitialObjects() {
        }
    }
}

