/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.constants.CMError;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreAddArrayDef;
import com.cognos.cm.dbstore.CMDbStoreAddDef;
import com.cognos.cm.dbstore.CMDbStoreConsistencyUtil;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreMetadataUtil;
import com.cognos.cm.dbstore.CMDbStoreUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cmutils.values.CMInt;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class CMDbStoreConsistency
extends CMDbStoreDMLDef {
    private static final HashSet<String> TABLES_CAN_HAVE_MISSING_CMID = new HashSet<String>(Arrays.asList("CMOBJPROPS13", "CMOBJPROPS3", "CMOBJPROPS39", "CMREFNOORD1", "CMREFORD1", "CMREFORD2", "CMREFNOORD2", "CMOBJPROPS33", "CMOBJPROPS69", "CMVIEWED", "CMTAGS"));
    private CMDbConnection con_;
    private static boolean bInitialized_ = false;
    private static List<String> propertyTables_ = null;
    private boolean useVirtualDB = false;
    List<String> currentObjAncestors_ = new ArrayList<String>();
    private final String Root_CMID = new String("0");
    private Map<String, String> childParentIDMap_ = null;

    public CMDbStoreConsistency(CMDbConnection con) {
        super(con.getSqlGenerator().createTemporaryTablePrefix(con.getDbms()) + "CMCHECKCONSISTENCY");
        this.con_ = con;
    }

    public CMException checkConsistency() throws CMConfigurationException {
        CMException cMException;
        CMException details = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            int count;
            if (CMDbConnection.dbms_ != 4) {
                this.con_.beginTransaction();
            }
            File scriptFile = CMDbStoreFactory.getScriptManager().getScriptFile("dbCheckConsistency", CMDbConnection.getDbmsInfo());
            CMDbStoreFactory.executeScript(this.con_.getConnection(), scriptFile, "com.cognos.cm.dbstore.CMDbStoreUpgrade", true, false, null);
            stmt = this.con_.createStatement();
            rs = stmt.executeQuery("select count(*) from " + this.tableName_ + " where INCONSISTENCY in (1,3,4)");
            if (rs.next()) {
                count = rs.getInt(1);
                if (count > 0) {
                    details = CMDbStoreConsistency.addInconsistencyDetailCMID(details, "cmInconsistentCMID", count, null);
                }
            } else {
                throw new CMConfigurationException("cmStoreUnexpected");
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
            stmt = this.con_.createStatement();
            rs = stmt.executeQuery("select count(*), l.NAME from " + this.tableName_ + " c " + "left outer join CMOBJECTS o on c.CMID=o.CMID " + "left outer join CMCLASSES l on l.CLASSID=o.CLASSID " + "where c.INCONSISTENCY=2 group by l.NAME");
            while (rs.next()) {
                count = rs.getInt(1);
                if (count <= 0) continue;
                String className = rs.getString(2);
                details = CMDbStoreConsistency.addInconsistencyDetailCMID(details, "cmInconsistentCMID", count, className);
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
            if (details != null) {
                stmt = this.con_.createStatement();
                rs = stmt.executeQuery("select * from " + this.tableName_);
                StringBuffer buffer = new StringBuffer();
                boolean bFirstRecord = true;
                ResultSetMetaData metaData = null;
                while (rs.next()) {
                    if (bFirstRecord) {
                        try {
                            buffer.append("\r\n");
                            metaData = rs.getMetaData();
                            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                                String name = metaData.getColumnName(i);
                                int size = metaData.getColumnDisplaySize(i);
                                CMDbStoreConsistency.appendString(buffer, name, size);
                            }
                        }
                        catch (Exception i) {
                            // empty catch block
                        }
                    }
                    buffer.append("\r\n");
                    int columnCount = metaData != null ? metaData.getColumnCount() : 3;
                    for (int i = 1; i <= columnCount; ++i) {
                        Object columnValue = rs.getObject(i);
                        String valueString = columnValue != null ? columnValue.toString() : "null";
                        int size = metaData != null ? metaData.getColumnDisplaySize(i) : -1;
                        CMDbStoreConsistency.appendString(buffer, valueString, size);
                    }
                    bFirstRecord = false;
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
                CMIndications.Audit_Message_FreeFormText("cmInconsistentCSInfo", new CMException.Parm[]{new CMException.Parm("details", buffer.toString())}, 50000, "UpgradeDetails", "ContentManagerService", "", "Info", null);
            }
            cMException = details;
        }
        catch (SQLException ex) {
            try {
                throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                if (CMDbConnection.dbms_ != 4) {
                    try {
                        this.con_.rollbackTransaction();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        if (CMDbConnection.dbms_ != 4) {
            try {
                this.con_.rollbackTransaction();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cMException;
    }

    public void performConsistencyCheckAtStartup() throws CMConfigurationException, CMException {
        CMDbStoreConsistencyUtil.Action action = CMDbStoreConsistencyUtil.getConsistencyCheckActionAtStartup();
        if (this.performConsistencyCheck(action, "StartService")) {
            CMDbStoreConsistencyUtil.deleteAction(this.con_);
        }
    }

    public void performConsistencyCheckAtUpgrade() throws CMConfigurationException, CMException {
        CMDbStoreConsistencyUtil.Action action = CMDbStoreConsistencyUtil.getConsistencyCheckActionAtUpgrade();
        this.performConsistencyCheck(action, "Upgrade");
    }

    private boolean performConsistencyCheck(CMDbStoreConsistencyUtil.Action action, String ipfOperation) throws CMConfigurationException, CMException {
        if (action.isNoneAction()) {
            return false;
        }
        CMIndications.Audit_Message_FreeFormText("cmConsistencyCheckStart", null, 50000, ipfOperation, "ContentManagerService", "", "Info", null);
        boolean bInconsistent = false;
        List<CMException> errors = null;
        if (action.isCheckAction()) {
            errors = this.checkInternalInconsistencies();
        } else if (action.isFixAction()) {
            errors = this.repairInternalInconsistencies(true);
        }
        if (errors != null && !errors.isEmpty()) {
            Iterator<CMException> iterator = errors.iterator();
            while (iterator.hasNext()) {
                CMException errorObj;
                CMException ex = errorObj = iterator.next();
                CMIndications.logException(ex);
            }
            bInconsistent = true;
        }
        if (bInconsistent) {
            CMIndications.Audit_Message_FreeFormText("cmInconsistentCS", null, 50000, ipfOperation, "ContentManagerService", "", "Info", null);
        }
        CMIndications.Audit_Message_FreeFormText("cmConsistencyCheckEnd", null, 50000, ipfOperation, "ContentManagerService", "", "Info", null);
        return !action.isAlways();
    }

    public List<CMException> checkInternalInconsistencies() throws CMConfigurationException {
        if (!bInitialized_) {
            this.initialize();
        }
        ArrayList<CMException> exceptions = new ArrayList<CMException>();
        CMException error = null;
        try {
            if (CMDbConnection.dbms_ != 4) {
                this.con_.beginTransaction();
            }
            TreeMap<String, SortedSet<String>> missingIdsMap = new TreeMap<String, SortedSet<String>>();
            error = this.checkMissingCMIDs(missingIdsMap);
            this.collectErrors(exceptions, error);
            Set<String> idsToExclude = null;
            if (missingIdsMap.size() > 0) {
                idsToExclude = missingIdsMap.keySet();
            }
            error = this.checkJunkRows(idsToExclude);
            this.collectErrors(exceptions, error);
            error = this.checkMissingRows();
            this.collectErrors(exceptions, error);
            error = this.checkCircularChildParentCMIDs();
            this.collectErrors(exceptions, error);
            error = this.checkStoreIDs(this.getObjectsWithNullStoreIDs(), "cmFoundNullData");
            this.collectErrors(exceptions, error);
            error = this.checkStoreIDs(this.getObjectsWithNonUniqueStoreIDs(), "cmFoundDuplicateData");
            this.collectErrors(exceptions, error);
        }
        catch (SQLException ex) {
            throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
        }
        finally {
            if (CMDbConnection.dbms_ != 4) {
                try {
                    this.con_.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
        return exceptions;
    }

    private void collectErrors(List<CMException> exceptions, CMException error) {
        if (error != null) {
            exceptions.add(error);
            error = null;
        }
    }

    public List<CMException> repairInternalInconsistencies(boolean bFix) throws CMConfigurationException, CMException {
        if (!bFix) {
            return this.checkInternalInconsistencies();
        }
        if (!bInitialized_) {
            this.initialize();
        }
        ArrayList<CMException> exceptions = new ArrayList<CMException>();
        CMException error = null;
        try {
            this.con_.beginTransaction();
            error = this.deleteJunkRowsForMissingCMIDs();
            if (error != null) {
                exceptions.add(error);
                error = null;
            }
            if ((error = this.deleteJunkRowsWithCMIDs()) != null) {
                exceptions.add(error);
                error = null;
            }
            if ((error = this.addMissingRows()) != null) {
                exceptions.add(error);
                error = null;
            }
            if ((error = this.fixInvalidStoreIDs(this.getObjectsWithNullStoreIDs(), "cmFixedNullStoreID", "cmFixedTotalNullStoreIDs")) != null) {
                exceptions.add(error);
                error = null;
            }
            if ((error = this.fixInvalidStoreIDs(this.getObjectsWithNonUniqueStoreIDs(), "cmFixedDuplicateStoreID", "cmFixedTotalDuplicateStoreIDs")) != null) {
                exceptions.add(error);
                error = null;
            }
            this.con_.commitTransaction();
        }
        catch (SQLException ex) {
            throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
        }
        finally {
            if (this.con_.inTransaction()) {
                try {
                    this.con_.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
        return exceptions;
    }

    private CMException fixInvalidStoreIDs(List<CMInt> cmidsWithInvalidStoreIDs, String fixedErrCode, String totalFixedErrCode) throws CMException {
        int count = 0;
        CMException error = null;
        CMException details = null;
        if (cmidsWithInvalidStoreIDs != null) {
            count = cmidsWithInvalidStoreIDs.size();
            Iterator<CMInt> iter = cmidsWithInvalidStoreIDs.iterator();
            while (iter.hasNext()) {
                int objectID = iter.next().intValue();
                String generatedStoreID = CMDbStore.generateStoreId();
                CMDbStoreUpdateDef updateDef = new CMDbStoreUpdateDef("CMSTOREIDS");
                updateDef.addColumn((CMDbProperty)CMProperty.STOREID, generatedStoreID);
                try {
                    updateDef.execute(this.con_, objectID);
                }
                catch (SQLException ex) {
                    throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
                }
                details = this.addDetailForRegeneratedStoreID(details, objectID, generatedStoreID.toUpperCase(), fixedErrCode);
            }
        }
        if (count > 0) {
            ArrayList<String> table = new ArrayList<String>();
            table.add("CMSTOREIDS");
            error = CMDbStoreConsistency.getHighLevelError(details, count, table, totalFixedErrCode);
        }
        return error;
    }

    private CMException addDetailForRegeneratedStoreID(CMException details, int objectID, String generatedStoreID, String errorCode) {
        CMException error = details;
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("cmid", Integer.toString(objectID)), new CMException.Parm("storeID", generatedStoreID)};
        error = CMDbStoreConsistency.addDetails(error, errorCode, parms);
        return error;
    }

    private List<CMInt> getObjectsWithNullStoreIDs() throws CMConfigurationException {
        StringBuffer selectRows = new StringBuffer();
        selectRows.append("select CMID from CMSTOREIDS");
        selectRows.append(" where STOREID is null");
        return this.getObjectsWithInvalidStoreIDs(selectRows.toString());
    }

    private List<CMInt> getObjectsWithNonUniqueStoreIDs() throws CMConfigurationException {
        StringBuffer upperStoreIDSQL = new StringBuffer();
        upperStoreIDSQL.append("select b.CMID, UPPER(b.STOREID) as STOREID");
        upperStoreIDSQL.append(" from CMSTOREIDS b");
        boolean isAliasReq = CMDbConnection.dbms_ != 2;
        String alias = "UPPERSTOREIDS";
        String assignAlias = isAliasReq ? "as UPPERSTOREIDS" : "";
        String aliasPrefix = isAliasReq ? "UPPERSTOREIDS." : "";
        StringBuffer duplicateStoreIDSQL = new StringBuffer();
        duplicateStoreIDSQL.append("select ");
        duplicateStoreIDSQL.append(aliasPrefix).append("STOREID");
        duplicateStoreIDSQL.append(" from");
        duplicateStoreIDSQL.append(" (").append(upperStoreIDSQL).append(") ");
        duplicateStoreIDSQL.append(assignAlias);
        duplicateStoreIDSQL.append(" group by ");
        duplicateStoreIDSQL.append(aliasPrefix).append("STOREID");
        duplicateStoreIDSQL.append(" having COUNT(");
        duplicateStoreIDSQL.append(aliasPrefix).append("CMID");
        duplicateStoreIDSQL.append(") > 1");
        StringBuffer cmidSQL = new StringBuffer();
        cmidSQL.append("select s.CMID from CMSTOREIDS s");
        cmidSQL.append(" where UPPER(s.STOREID) in");
        cmidSQL.append(" (").append(duplicateStoreIDSQL).append(")");
        return this.getObjectsWithInvalidStoreIDs(cmidSQL.toString());
    }

    private List<CMInt> getObjectsWithInvalidStoreIDs(String selectRows) throws CMConfigurationException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<CMInt> objectIDsWithInvalidStoreIDs = null;
        try {
            stmt = this.con_.prepareStatement(selectRows);
            rs = stmt.executeQuery();
            while (rs != null && rs.next()) {
                int CMID = rs.getInt(1);
                if (objectIDsWithInvalidStoreIDs == null) {
                    objectIDsWithInvalidStoreIDs = new ArrayList<CMInt>();
                }
                objectIDsWithInvalidStoreIDs.add(new CMInt(CMID));
            }
        }
        catch (SQLException ex) {
            try {
                throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        return objectIDsWithInvalidStoreIDs;
    }

    private void initialize() throws CMConfigurationException {
        if (bInitialized_) {
            return;
        }
        propertyTables_ = CMDbStoreMetadataUtil.getPropertyTablesList();
        this.getTablesMap();
        bInitialized_ = true;
    }

    private CMException checkMissingCMIDs(Map<String, SortedSet<String>> missingIDsMap) throws CMConfigurationException {
        if (propertyTables_ == null) {
            throw new IllegalStateException("propertyTables is not initialized.");
        }
        CMException error = null;
        CMException details = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (missingIDsMap == null) {
            missingIDsMap = new TreeMap<String, SortedSet<String>>();
        }
        Iterator<String> iter = propertyTables_.iterator();
        try {
            while (iter.hasNext()) {
                String sTable = iter.next();
                ArrayList<String> missingIDs = new ArrayList<String>();
                String selectRows = this.getMissingCMIDsSelectStmt(sTable);
                stmt = this.con_.createStatement();
                rs = stmt.executeQuery(selectRows);
                while (rs.next()) {
                    Set<String> tables;
                    int CMID = rs.getInt(1);
                    String sKey = String.valueOf(CMID);
                    missingIDs.add(sKey);
                    if (missingIDsMap.containsKey(sKey)) {
                        tables = missingIDsMap.get(sKey);
                        tables.add(sTable);
                        continue;
                    }
                    tables = new TreeSet();
                    tables.add(sTable);
                    missingIDsMap.put(sKey, (SortedSet<String>)tables);
                }
                if (missingIDs.size() > 0) {
                    details = CMDbStoreConsistency.addDetailForCheckMissingIDInCMOBJS(details, missingIDs, sTable);
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
        }
        catch (SQLException ex) {
            throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        if (missingIDsMap.size() > 0) {
            int count = missingIDsMap.size();
            ArrayList<String> tables = new ArrayList<String>();
            tables.add("CMOBJECTS");
            error = CMDbStoreConsistency.getHighLevelError(details, count, tables, "cmFoundMissingCMIDs");
        }
        return error;
    }

    private CMException checkJunkRows(Set<String> cmIDsToExclude) throws CMConfigurationException {
        if (propertyTables_ == null) {
            throw new IllegalStateException("propertyTables_ is not initialized.");
        }
        ResultSet rs = null;
        PreparedStatement stmt = null;
        CMException error = null;
        try {
            int rowsCount = 0;
            ArrayList<String> tablesHasJunk = new ArrayList<String>();
            CMException details = null;
            for (String tableName : propertyTables_) {
                Map<String, SortedSet<String>> tablesMap = this.getTablesMap();
                SortedSet<String> tableClassIds = tablesMap.get(tableName);
                String sJunkRowsSelect = this.getJunkRowsSelectStmt(tableName, tableClassIds.size());
                stmt = this.con_.prepareStatement(sJunkRowsSelect);
                Iterator classesIt = tableClassIds.iterator();
                int paramIdx = 1;
                while (classesIt.hasNext()) {
                    String classId = (String)classesIt.next();
                    stmt.setInt(paramIdx++, Integer.valueOf(classId));
                }
                rs = stmt.executeQuery();
                CMInt count = new CMInt(0);
                details = CMDbStoreConsistency.addDetailForCheckJunkRows(details, rs, tableName, cmIDsToExclude, count);
                if (count.intValue() > 0) {
                    tablesHasJunk.add(tableName);
                    rowsCount += count.intValue();
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
            if (rowsCount > 0) {
                error = CMDbStoreConsistency.getHighLevelError(details, rowsCount, tablesHasJunk, "cmFoundJunkRows");
            }
        }
        catch (SQLException ex) {
            throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        return error;
    }

    private CMException checkMissingRows() throws CMConfigurationException {
        if (propertyTables_ == null) {
            throw new IllegalStateException("propertyTables_ is not initialized.");
        }
        ResultSet rs = null;
        PreparedStatement stmt = null;
        CMException error = null;
        CMException details = null;
        Iterator<String> tableIter = propertyTables_.iterator();
        int rowsCount = 0;
        ArrayList<String> tablesHasMissing = new ArrayList<String>();
        try {
            while (tableIter.hasNext()) {
                String sTable = tableIter.next();
                if (CMDbStoreConsistency.isMissingCmidAllowed(sTable)) continue;
                Map<String, SortedSet<String>> tablesMap = this.getTablesMap();
                SortedSet<String> tableClassIds = tablesMap.get(sTable);
                String missingRowsSelect = this.getMissingRowsSelectStmt(sTable, tableClassIds.size());
                stmt = this.con_.prepareStatement(missingRowsSelect);
                Iterator classesIt = tableClassIds.iterator();
                int paramIdx = 1;
                while (classesIt.hasNext()) {
                    String classId = (String)classesIt.next();
                    stmt.setInt(paramIdx++, Integer.valueOf(classId));
                }
                rs = stmt.executeQuery();
                CMInt count = new CMInt(0);
                details = CMDbStoreConsistency.addDetailForCheckMissingRows(details, rs, count, sTable);
                if (count.intValue() > 0) {
                    rowsCount += count.intValue();
                    tablesHasMissing.add(sTable);
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
        }
        catch (SQLException ex) {
            throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        if (rowsCount > 0) {
            error = CMDbStoreConsistency.getHighLevelError(details, rowsCount, tablesHasMissing, "cmFoundMissingRows");
        }
        return error;
    }

    private CMException checkStoreIDs(List<CMInt> cmidsWithInvalidStoreID, String errCode) {
        CMException error = null;
        CMException details = null;
        if (cmidsWithInvalidStoreID != null) {
            details = CMDbStoreConsistency.addDetailForInvalidStoreIDs(details, cmidsWithInvalidStoreID, errCode);
            int count = cmidsWithInvalidStoreID.size();
            ArrayList<String> tables = new ArrayList<String>();
            tables.add("CMSTOREIDS");
            error = CMDbStoreConsistency.getHighLevelError(details, count, tables, "cmFoundInvalidData");
        }
        return error;
    }

    private static CMException addInconsistencyDetailCMID(CMException details, String errorCode, int count, String className) {
        details = details == null ? new CMException(errorCode, new CMException.Parm("name", className), new CMException.Parm("count", String.valueOf(count))) : new CMException((Exception)details, errorCode, new CMException.Parm("name", className), new CMException.Parm("count", String.valueOf(count)));
        return details;
    }

    private static void appendSpaces(StringBuffer buffer, int count) {
        for (int j = 0; j < count; ++j) {
            buffer.append(" ");
        }
    }

    private static void appendString(StringBuffer buffer, String value, int size) {
        if (size > 0 && value.length() > size) {
            value = value.substring(0, size);
        }
        buffer.append(value);
        int sizeDiff = size - value.length();
        CMDbStoreConsistency.appendSpaces(buffer, sizeDiff);
    }

    public CMException makeTablesConsistent(Set<String> tables) throws CMConfigurationException {
        if (!bInitialized_) {
            this.initialize();
        }
        PreparedStatement stmt = null;
        CMException details = null;
        try {
            for (String tableName : tables) {
                Map<String, SortedSet<String>> tablesMap = this.getTablesMap();
                SortedSet<String> tableClassIds = tablesMap.get(tableName);
                this.con_.beginTransaction();
                StringBuffer extraRowsDelete = new StringBuffer();
                extraRowsDelete.append("delete from ");
                extraRowsDelete.append(tableName);
                extraRowsDelete.append(" where CMID not in (select CMID from CMOBJECTS where CLASSID ");
                CMDbStoreConsistency.appendInBindVariables(this.con_, extraRowsDelete, tableClassIds.size());
                extraRowsDelete.append(")");
                stmt = this.con_.prepareStatement(extraRowsDelete.toString());
                Iterator classesIt = tableClassIds.iterator();
                int paramIdx = 1;
                while (classesIt.hasNext()) {
                    String classId = (String)classesIt.next();
                    stmt.setInt(paramIdx++, Integer.valueOf(classId));
                }
                int rowsCount = stmt.executeUpdate();
                if (rowsCount > 0) {
                    details = CMDbStoreConsistency.addInconsistencyDetailCMID(details, "cmFixedInconsistentCMID", rowsCount, tableName);
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
                this.con_.commitTransaction();
            }
            CMException cMException = details;
            return cMException;
        }
        catch (SQLException ex) {
            throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
            try {
                if (this.con_.inTransaction()) {
                    this.con_.rollbackTransaction();
                }
            }
            catch (Exception exception) {}
        }
    }

    private CMException deleteJunkRowsForMissingCMIDs() throws CMConfigurationException {
        if (propertyTables_ == null) {
            throw new IllegalStateException("propertyTables_ is not initialized.");
        }
        CMException error = null;
        CMException details = null;
        Statement stmt = null;
        int rowsCount = 0;
        TreeMap<String, String> fixedTableMap = new TreeMap<String, String>();
        Iterator<String> iter = propertyTables_.iterator();
        try {
            while (iter.hasNext()) {
                String tableName = iter.next();
                StringBuffer extraRowsDelete = new StringBuffer();
                extraRowsDelete.append("delete from ");
                extraRowsDelete.append(tableName);
                extraRowsDelete.append(" where CMID not in (select CMID from CMOBJECTS)");
                stmt = this.con_.createStatement();
                int count = stmt.executeUpdate(extraRowsDelete.toString());
                if (count > 0) {
                    fixedTableMap.put(tableName, Integer.toString(count));
                    rowsCount += count;
                    details = this.addDetailForFixInTable(details, count, tableName, "cmFixedInconsistentCMID");
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
        }
        catch (SQLException ex) {
            throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        if (rowsCount > 0) {
            error = CMDbStoreConsistency.getHighLevelError(details, rowsCount, fixedTableMap.keySet(), "cmFixedMissingCMIDsInCMOBJS");
        }
        return error;
    }

    private CMException deleteJunkRowsWithCMIDs() throws CMConfigurationException {
        if (propertyTables_ == null) {
            throw new IllegalStateException("propertyTables_ is not initialized.");
        }
        PreparedStatement stmt = null;
        CMException error = null;
        CMException details = null;
        ArrayList<String> corruptedTables = new ArrayList<String>();
        int rowsCount = 0;
        try {
            for (String tableName : propertyTables_) {
                Map<String, SortedSet<String>> tablesMap = this.getTablesMap();
                SortedSet<String> tableClassIds = tablesMap.get(tableName);
                StringBuffer extraRowsDelete = new StringBuffer();
                extraRowsDelete.append("delete from ");
                extraRowsDelete.append(tableName);
                extraRowsDelete.append(" where CMID not in (select CMID from CMOBJECTS where CLASSID ");
                CMDbStoreConsistency.appendInBindVariables(this.con_, extraRowsDelete, tableClassIds.size());
                extraRowsDelete.append(")");
                stmt = this.con_.prepareStatement(extraRowsDelete.toString());
                Iterator classesIt = tableClassIds.iterator();
                int paramIdx = 1;
                while (classesIt.hasNext()) {
                    String classId = (String)classesIt.next();
                    stmt.setInt(paramIdx++, Integer.valueOf(classId));
                }
                int count = stmt.executeUpdate();
                if (count > 0) {
                    rowsCount += count;
                    corruptedTables.add(tableName);
                    details = this.addDetailForFixInTable(details, count, tableName, "cmFixedInconsistentCMID");
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
        }
        catch (SQLException ex) {
            throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        if (rowsCount > 0) {
            error = CMDbStoreConsistency.getHighLevelError(details, rowsCount, corruptedTables, "cmFixedJunkRows");
        }
        return error;
    }

    protected Map<String, SortedSet<String>> getTablesMap() throws CMConfigurationException {
        return CMDbStoreMetadataUtil.getTablesMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMException addMissingRows() throws CMConfigurationException, CMException {
        if (propertyTables_ == null) {
            throw new IllegalStateException("propertyTables_ is not initialized.");
        }
        CMException error = null;
        CMException details = null;
        int rowsCount = 0;
        Iterator<String> tableIter = propertyTables_.iterator();
        ArrayList<String> corruptedTables = new ArrayList<String>();
        while (tableIter.hasNext()) {
            PreparedStatement stmt = null;
            try {
                String sTable = tableIter.next();
                if (CMDbStoreConsistency.isMissingCmidAllowed(sTable)) continue;
                Map<String, SortedSet<String>> tablesMap = this.getTablesMap();
                Set tableClassIds = tablesMap.get(sTable);
                int count = 0;
                if (sTable.equals("CMOBJNAMES")) {
                    Map<Integer, String> missingNames = this.getMissingRowsForTable(sTable, tableClassIds);
                    if (missingNames != null) {
                        for (Integer key : missingNames.keySet()) {
                            int CMID = key;
                            String objClsName = missingNames.get(key);
                            try {
                                CMDbStoreAddArrayDef addDef = new CMDbStoreAddArrayDef("CMOBJNAMES");
                                CMDbStoreLocalizedStringArray name = new CMDbStoreLocalizedStringArray();
                                CMStringLocale locale = this.getServerLocale();
                                name.add(new CMDbStoreLocalizedString(locale, this.getRepairedName(CMID, objClsName)));
                                addDef.addColumn((CMDbProperty)CMProperty.NAME, name);
                                ((CMDbStoreAddDef)addDef).execute(this.con_, CMID);
                            }
                            catch (SQLException sqlEx) {
                                CMIndications.logException(sqlEx);
                            }
                            catch (CMException cmEx) {
                                CMIndications.logException(cmEx);
                            }
                        }
                        count = missingNames.size();
                    }
                } else {
                    String missingRowsInsert = this.getMissingRowsInsertStmt(sTable, tableClassIds.size());
                    stmt = this.con_.prepareStatement(missingRowsInsert);
                    Iterator classesIt = tableClassIds.iterator();
                    int paramIdx = 1;
                    while (classesIt.hasNext()) {
                        String classId = (String)classesIt.next();
                        stmt.setInt(paramIdx++, Integer.valueOf(classId));
                    }
                    count = CMDbConnection.executeUpdate(stmt);
                    CMDbStoreUtil.safeCloseStatement(stmt);
                }
                if (count > 0) {
                    rowsCount += count;
                    corruptedTables.add(sTable);
                    details = this.addDetailForFixInTable(details, count, sTable, "cmFixedMissingRowsInTable");
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
            catch (SQLException ex) {
                CMIndications.logException(ex);
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
        }
        if (rowsCount > 0) {
            error = CMDbStoreConsistency.getHighLevelError(details, rowsCount, corruptedTables, "cmFixedMissingRows");
        }
        return error;
    }

    protected CMStringLocale getServerLocale() {
        return CMDbStoreStringLocales.findLocale(ConfigurationFactory.getConfig().getServerLocale().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, String> getMissingRowsForTable(String table, Set<String> tableClassIds) throws SQLException {
        TreeMap<Integer, String> missingRows = null;
        PreparedStatement missingRowsSelectStmt = null;
        String missingRowsSelect = this.getMissingRowsSelectStmt(table, tableClassIds.size());
        missingRowsSelectStmt = this.con_.prepareStatement(missingRowsSelect);
        try {
            Iterator<String> classesIt = tableClassIds.iterator();
            int paramIdx = 1;
            while (classesIt.hasNext()) {
                String classId = classesIt.next();
                missingRowsSelectStmt.setInt(paramIdx++, Integer.valueOf(classId));
            }
            ResultSet rs = missingRowsSelectStmt.executeQuery();
            while (rs.next()) {
                int CMID = rs.getInt(1);
                String objClsName = rs.getString(2);
                if (missingRows == null) {
                    missingRows = new TreeMap<Integer, String>();
                }
                missingRows.put(new Integer(CMID), objClsName);
            }
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(missingRowsSelectStmt);
        }
        return missingRows;
    }

    private String getMissingCMIDsSelectStmt(String sTable) {
        StringBuffer selectRows = new StringBuffer();
        selectRows.append("select t.CMID, o.CLASSID from ");
        selectRows.append(sTable);
        selectRows.append(" t");
        selectRows.append(" left outer join CMOBJECTS o on t.CMID=o.CMID");
        selectRows.append(" where o.CLASSID Is NULL");
        return selectRows.toString();
    }

    private String getJunkRowsSelectStmt(String sTableName, int classIdCount) {
        StringBuffer junkRowsSelect = new StringBuffer();
        junkRowsSelect.append("select p.CMID,l.NAME from ");
        junkRowsSelect.append(sTableName);
        junkRowsSelect.append(" p left outer join CMOBJECTS o on p.CMID=o.CMID ");
        junkRowsSelect.append(" left outer join CMCLASSES l on o.CLASSID=l.CLASSID ");
        junkRowsSelect.append(" where o.CLASSID not ");
        CMDbStoreDMLDef.appendInBindVariables(this.con_, junkRowsSelect, classIdCount);
        junkRowsSelect.append(" order by l.NAME ASC");
        return junkRowsSelect.toString();
    }

    private String getMissingRowsSelectStmt(String sTableName, int classIdCount) {
        StringBuffer missingRowSelect = new StringBuffer();
        missingRowSelect.append("select o.CMID, l.NAME from CMOBJECTS o");
        missingRowSelect.append(" left outer join CMCLASSES l on l.CLASSID=o.CLASSID");
        missingRowSelect.append(" where o.CLASSID ");
        CMDbStoreDMLDef.appendInBindVariables(this.con_, missingRowSelect, classIdCount);
        missingRowSelect.append(" and ");
        if (CMDbConnection.getDbmsInfo().getDbmsReplaceNotExistsWithCount()) {
            missingRowSelect.append("0 = (select count(CMID)");
        } else {
            missingRowSelect.append("not exists (select CMID");
        }
        missingRowSelect.append(" from ");
        missingRowSelect.append(sTableName);
        missingRowSelect.append(" p where p.CMID=o.CMID)");
        return missingRowSelect.toString();
    }

    private String getMissingRowsInsertStmt(String sTableName, int classIdCount) {
        StringBuffer missingRowInsert = new StringBuffer();
        missingRowInsert.append("insert into ");
        missingRowInsert.append(sTableName);
        missingRowInsert.append(" (CMID) ");
        missingRowInsert.append("select o.CMID from CMOBJECTS o");
        missingRowInsert.append(" where o.CLASSID ");
        CMDbStoreDMLDef.appendInBindVariables(this.con_, missingRowInsert, classIdCount);
        missingRowInsert.append(" and ");
        if (CMDbConnection.getDbmsInfo().getDbmsReplaceNotExistsWithCount()) {
            missingRowInsert.append("0 = (select count(CMID)");
        } else {
            missingRowInsert.append("not exists (select CMID");
        }
        missingRowInsert.append(" from ");
        missingRowInsert.append(sTableName);
        missingRowInsert.append(" p where p.CMID=o.CMID)");
        return missingRowInsert.toString();
    }

    private String getRepairedName(int cmID, String sClassName) {
        StringBuffer name = new StringBuffer();
        String prefixWithCode = CMError.getMessage("cmRepairedNamePrefix", null, null);
        String prefix = CMError.trimErrorCode(prefixWithCode);
        name.append(prefix);
        name.append(", Object Class (");
        name.append(sClassName);
        name.append("), CMID (");
        name.append(Integer.toString(cmID));
        name.append(")");
        return name.toString();
    }

    public static boolean isMissingCmidAllowed(String sTableName) {
        return TABLES_CAN_HAVE_MISSING_CMID.contains(sTableName);
    }

    private static CMException getHighLevelError(CMException detail, int rowsCount, Collection<?> tables, String errorCode) {
        CMException cmEx = new CMException((Exception)detail, errorCode, new CMException.Parm("count", Integer.toString(rowsCount)), new CMException.Parm("tables", tables.toString()));
        return cmEx;
    }

    private CMException addDetailForFixInTable(CMException details, int count, String sTable, String errorCode) {
        CMException error = details;
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("count", Integer.toString(count)), new CMException.Parm("name", sTable)};
        error = CMDbStoreConsistency.addDetails(error, errorCode, parms);
        return error;
    }

    private static CMException addDetailForCheckMissingIDInCMOBJS(CMException details, List<?> missingIDs, String sTable) {
        CMException error = details;
        if (!missingIDs.isEmpty()) {
            CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("CMIDs", missingIDs.toString()), new CMException.Parm("table", sTable)};
            error = CMDbStoreConsistency.addDetails(error, "cmFoundCMIDsInTableNotInCMOBJS", parms);
        }
        return error;
    }

    private static CMException addDetailForCheckJunkRows(CMException details, ResultSet rs, String tableName, Set<?> cmIDsToExclude, CMInt rowsCount) throws SQLException {
        CMException error = details;
        LinkedList<String> cmIDs = new LinkedList<String>();
        while (rs.next()) {
            int cmID = rs.getInt(1);
            String cmIDStr = String.valueOf(cmID);
            if (cmIDsToExclude != null && cmIDsToExclude.contains(cmIDStr)) continue;
            cmIDs.add(cmIDStr);
        }
        if (!cmIDs.isEmpty()) {
            int cmIdsSize = cmIDs.size();
            CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("count", Integer.toString(cmIdsSize)), new CMException.Parm("CMIDs", ((Object)cmIDs).toString()), new CMException.Parm("name", tableName)};
            error = CMDbStoreConsistency.addDetails(error, "cmFoundJunkRowsInTable", parms);
            rowsCount.setValue(cmIdsSize);
        }
        return error;
    }

    private static CMException addDetailForCheckMissingRows(CMException details, ResultSet rs, CMInt rowsCount, String sTable) throws SQLException {
        CMException error = details;
        int count = 0;
        while (rs.next()) {
            ++count;
            int CMID = rs.getInt(1);
            String className = rs.getString(2);
            CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("class", className), new CMException.Parm("CMID", String.valueOf(CMID)), new CMException.Parm("table", sTable)};
            error = CMDbStoreConsistency.addDetails(error, "cmFoundMissingRowInTable", parms);
        }
        rowsCount.setValue(count);
        return error;
    }

    private static CMException addDetailForInvalidStoreIDs(CMException details, List<CMInt> cmids, String errKey) {
        CMException error = details;
        if (!cmids.isEmpty()) {
            CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("count", Integer.toString(cmids.size())), new CMException.Parm("CMIDs", cmids.toString()), new CMException.Parm("table", "CMSTOREIDS"), new CMException.Parm("column", "STOREID")};
            error = CMDbStoreConsistency.addDetails(error, errKey, parms);
        }
        return error;
    }

    private static CMException addDetails(CMException details, String errorCode, CMException.Parm[] parms) {
        CMException error = details;
        error = error == null ? new CMException(errorCode, parms) : new CMException((Exception)error, errorCode, parms);
        return error;
    }

    protected CMException checkCircularChildParentCMIDs() {
        CMException error = null;
        ArrayList<String> circularCMIDs = new ArrayList<String>();
        Map<String, String> childParentCMIDMap = this.getChildParentIDs();
        if (childParentCMIDMap != null) {
            Iterator<String> iter = childParentCMIDMap.keySet().iterator();
            while (iter.hasNext()) {
                boolean hasObjAncestors;
                this.resetAncestors();
                String currentCMID = iter.next().toString();
                boolean bCircular = this.isCircular(currentCMID, childParentCMIDMap);
                boolean bl = hasObjAncestors = this.currentObjAncestors_ != null && !this.currentObjAncestors_.isEmpty();
                if (!bCircular || !hasObjAncestors) continue;
                circularCMIDs.add(this.currentObjAncestors_.toString());
            }
        }
        error = this.getCircularCMIDErrorReport(circularCMIDs);
        return error;
    }

    private CMException getCircularCMIDErrorReport(List<String> circularCMIDs) {
        CMException error = circularCMIDs.isEmpty() ? null : new CMException("cmFoundCircularCMIDs", new CMException.Parm("count", String.valueOf(circularCMIDs.size())), new CMException.Parm("table", "CMOBJECTS"), new CMException.Parm("detail", circularCMIDs.toString()));
        return error;
    }

    protected boolean isCircular(String currentCMID, Map<String, String> childParentCMIDMap) {
        String pID = childParentCMIDMap.get(currentCMID).toString();
        if (this.isRoot(pID)) {
            return false;
        }
        if (currentCMID.equals(pID) || this.currentObjAncestors_.contains(pID)) {
            this.currentObjAncestors_.add(currentCMID);
            return true;
        }
        this.currentObjAncestors_.add(currentCMID);
        return this.isCircular(pID, childParentCMIDMap);
    }

    private void resetAncestors() {
        this.currentObjAncestors_ = null;
        this.currentObjAncestors_ = new ArrayList<String>();
    }

    private boolean isRoot(String pid) {
        return pid.equals(this.Root_CMID);
    }

    private Map<String, String> getChildParentIDs() {
        if (this.useVirtualDB) {
            return this.getChildParentIDsForTest();
        }
        return this.getChildParentIDsFromDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getChildParentIDsFromDB() {
        String selectSql = this.getChildParentSelect();
        Statement stmt = null;
        ResultSet rs = null;
        TreeMap<String, String> childParentIDMap = new TreeMap<String, String>();
        try {
            stmt = this.con_.createStatement();
            rs = stmt.executeQuery(selectSql);
            while (rs.next()) {
                int cmID = rs.getInt(1);
                int pcmID = rs.getInt(2);
                childParentIDMap.put(String.valueOf(cmID), String.valueOf(pcmID));
            }
        }
        catch (SQLException ex) {
            CMIndications.logException(ex);
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        return childParentIDMap;
    }

    private String getChildParentSelect() {
        return "select CMID, PCMID from CMOBJECTS";
    }

    protected void setChildParentIDs(Map<String, String> childParentIDMap) {
        this.childParentIDMap_ = childParentIDMap;
    }

    protected Map<String, String> getChildParentIDsForTest() {
        return this.childParentIDMap_;
    }

    protected void setUseVirtualDB(boolean useVirtualDB) {
        this.useVirtualDB = useVirtualDB;
    }

    protected void setInitialize(boolean initialized) {
        bInitialized_ = initialized;
    }

    protected void setPropertyTables(List<String> propTables) {
        propertyTables_ = propTables;
    }
}

