/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreSysProperties;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class CMDbStoreConsistencyUtil {
    private static final String CHECK = "CHECK AT STARTUP";
    private static final String FIX = "FIX AT STARTUP";
    private static final String ALWAYS_PREFIX = "ALWAYS";
    private static final String NO_CHECK_AT_UPG = "DISABLE CHECK AT UPGRADE";
    private static final Map<String, Action> startupActionMap = CMDbStoreConsistencyUtil.getPropValueToActionMap();

    public static Action getConsistencyCheckActionAtStartup() {
        String actionValue = ConfigurationFactory.getConfig().getInternalProp("CMInternalConsistency");
        Action action = startupActionMap.containsKey(actionValue) ? startupActionMap.get(actionValue) : new Action(ActionId.ACTION_NONE);
        return action;
    }

    public static Action getConsistencyCheckActionAtUpgrade() {
        Action action = new Action(ActionId.ACTION_CHECK);
        String actionValue = ConfigurationFactory.getConfig().getInternalProp("CMInternalConsistencyAtUpgrade");
        if (actionValue != null && actionValue.equals(NO_CHECK_AT_UPG)) {
            action = new Action(ActionId.ACTION_NONE);
        }
        return action;
    }

    public static void addAction(CMDbConnection con, Action action) {
        try {
            if (action.isNoneAction()) {
                return;
            }
            CMDbStoreConsistencyUtil.deleteAction(con);
            String propValue = action.getActionValue();
            con.beginTransaction();
            CMDbStoreSysProperties.addSysProp(con, "CMInternalConsistency", propValue);
            con.commitTransaction();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        catch (CMException cmEx) {
            CMIndications.logException(cmEx);
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (SQLException ex) {}
            }
        }
    }

    public static void deleteAction(CMDbConnection con) {
        try {
            con.beginTransaction();
            CMDbStoreSysProperties.deleteSysProp(con, "CMInternalConsistency");
            con.commitTransaction();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        catch (CMException cmEx) {
            CMIndications.logException(cmEx);
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (SQLException ex) {}
            }
        }
    }

    private static Map<String, Action> getPropValueToActionMap() {
        HashMap<String, Action> startupActionMap = new HashMap<String, Action>();
        startupActionMap.put(CHECK, new Action(ActionId.ACTION_CHECK));
        Action alwaysCheck = new Action(ActionId.ACTION_CHECK, true);
        startupActionMap.put(alwaysCheck.getActionValue(), alwaysCheck);
        startupActionMap.put(FIX, new Action(ActionId.ACTION_FIX));
        Action alwaysFix = new Action(ActionId.ACTION_FIX, true);
        startupActionMap.put(alwaysFix.getActionValue(), alwaysFix);
        return startupActionMap;
    }

    public static class Action {
        private boolean isAlways = false;
        private ActionId action = ActionId.ACTION_NONE;

        private Action() {
        }

        public Action(ActionId actionKey) {
            this();
            this.action = actionKey;
        }

        public Action(ActionId actionKey, boolean isAlways) {
            this(actionKey);
            this.isAlways = isAlways;
        }

        public boolean isNoneAction() {
            return this.action == ActionId.ACTION_NONE;
        }

        public boolean isCheckAction() {
            return this.action == ActionId.ACTION_CHECK;
        }

        public boolean isFixAction() {
            return this.action == ActionId.ACTION_FIX;
        }

        public boolean isAlways() {
            return this.isAlways;
        }

        public String getActionValue() {
            boolean isAlways;
            String formattedValue = this.action.getValue();
            boolean bl = isAlways = this.isAlways() && formattedValue != null;
            if (isAlways) {
                formattedValue = "ALWAYS " + formattedValue;
            }
            return formattedValue;
        }

        public ActionId getActionId() {
            return this.action;
        }
    }

    public static enum ActionId {
        ACTION_NONE,
        ACTION_CHECK("CHECK AT STARTUP"),
        ACTION_FIX("FIX AT STARTUP");

        private String value = null;

        private ActionId() {
        }

        private ActionId(String value) {
            this();
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

