/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreTransactionAction;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMStoreQueryResults;

public class CMDbStoreCopyCacheObjects
implements CMDbStoreTransactionAction {
    CMDbStore store_;
    CMStoreQueryResults objectsSrc_;
    int[] objectsCopied_;
    int parent_objid_;

    CMDbStoreCopyCacheObjects(CMDbStore store, CMStoreQueryResults objectsSrc, int[] objectsCopied, int parent_objid) {
        this.store_ = store;
        this.objectsSrc_ = objectsSrc;
        this.objectsCopied_ = objectsCopied;
        this.parent_objid_ = parent_objid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        CMCache cache = this.store_.getCache();
        try {
            if (this.objectsSrc_ != null && !this.objectsSrc_.next()) {
                CMException ex = new CMException("cmErrCommitCopy");
                CMIndications.logException(ex);
                return;
            }
            for (int i = 0; i < this.objectsCopied_.length; ++i) {
                cache.CMCacheCommitObject(this.objectsCopied_[i], this.parent_objid_, null);
            }
        }
        catch (CMException e) {
            CMException cmex = new CMException(e, "cmErrCommitCopyOp");
            CMIndications.logException(cmex);
        }
        finally {
            if (this.objectsSrc_ != null) {
                this.objectsSrc_.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        CMCache cache = this.store_.getCache();
        try {
            for (int i = 0; i < this.objectsCopied_.length; ++i) {
                if (this.objectsCopied_[i] <= 0) continue;
                cache.CMCacheDeleteObject(this.objectsCopied_[i]);
            }
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException(e, "cmErrCommitCopyOp");
            CMIndications.logException(cmex);
        }
        finally {
            if (this.objectsSrc_ != null) {
                this.objectsSrc_.release();
            }
        }
    }
}

