/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.CMDbTempTableId;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.server.CMException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class CMDbStoreCopyDef
extends CMDbStoreDMLDef {
    static String CMTMPCOPYIDSTable_;
    private String[] columnNames_;
    private boolean hasPROPIDColumn_;
    private boolean columnNamesSet_;

    public CMDbStoreCopyDef(String tableName) {
        super(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insertCopyCMIDs(CMDbConnection con, int groupId, int[] sourceIDs, int[] targetIDs, CMDbTempTableId tempTableId) throws SQLException, CMException {
        PreparedStatement stmt;
        int queryId;
        block10: {
            ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
            if (sourceIDs.length != targetIDs.length) {
                throw new IllegalStateException("sourceIDs and targetIDs should have same number of IDs.");
            }
            CMDbStoreCopyDef.setCMTMPCOPYIDSTableName(con);
            int count = sourceIDs.length;
            if (count == 0) {
                return -1;
            }
            queryId = tempTableId.getId();
            stmt = null;
            try {
                if (CMDbConnection.dbms_ == 1) {
                    ByteArrayOutputStream usSource = new ByteArrayOutputStream();
                    DataOutputStream dosSource = new DataOutputStream(usSource);
                    ByteArrayOutputStream usTarget = new ByteArrayOutputStream();
                    DataOutputStream dosTarget = new DataOutputStream(usTarget);
                    try {
                        for (int i = 0; i < count; ++i) {
                            dosSource.writeInt(sourceIDs[i]);
                            dosTarget.writeInt(targetIDs[i]);
                        }
                        dosSource.flush();
                        dosTarget.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    stmt = con.prepareStatement(sqlGenerator.createExecProcedureWithNBindParameters("CMPARSECOPYIDS", 4));
                    stmt.setInt(1, queryId);
                    stmt.setInt(2, groupId);
                    stmt.setBytes(3, usSource.toByteArray());
                    stmt.setBytes(4, usTarget.toByteArray());
                    CMDbConnection.executeUpdate(stmt);
                    break block10;
                }
                StringBuffer insertSQL = new StringBuffer();
                sqlGenerator.appendInsertIntoCMTMPCOPYIDS(CMTMPCOPYIDSTable_, insertSQL);
                stmt = con.prepareStatement(insertSQL.toString());
                for (int i = 0; i < count; ++i) {
                    stmt.setInt(1, queryId);
                    stmt.setInt(2, groupId);
                    stmt.setInt(3, sourceIDs[i]);
                    stmt.setInt(4, targetIDs[i]);
                    stmt.addBatch();
                    if ((i + 1 & 0x3FF) != 0) continue;
                    stmt.executeBatch();
                }
                if ((count & 0x3FF) != 0) {
                    stmt.executeBatch();
                }
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        return queryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyCorrectedReferences(CMDbConnection con, int groupId, int[] includePROPIDs, int[] excludePROPIDs, CMDbTempTableId tempTableId) throws SQLException, CMException {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        this.setColumnNames(con);
        if (this.columnNames_ == null) {
            throw new IllegalStateException(this.getTableName() + " is not a reference table");
        }
        int queryId = tempTableId.getId();
        CMDbStoreCopyDef.setCMTMPCOPYIDSTableName(con);
        PreparedStatement stmt = null;
        StringBuffer buffer = new StringBuffer(400);
        StringBuffer addCondition = new StringBuffer(300);
        StringBuffer addDeleteCondition = new StringBuffer(300);
        this.appendPROPIDsConditions(con, addCondition, "r", includePROPIDs, excludePROPIDs);
        this.appendPROPIDsConditions(con, addDeleteCondition, null, includePROPIDs, excludePROPIDs);
        try {
            int i;
            buffer.setLength(0);
            sqlGenerator.appendDeleteFromTableSql(this.getTableName(), buffer);
            buffer.append(sqlGenerator.createWhereSql());
            buffer.append("CMID");
            buffer.append(sqlGenerator.createInSql());
            sqlGenerator.appendSelectTARGETCMIDFromCMTMPCOPYIDSSql(CMTMPCOPYIDSTable_, buffer);
            if (addDeleteCondition.length() > 0) {
                buffer.append(sqlGenerator.createAndSql());
                buffer.append(addDeleteCondition);
            }
            stmt = con.prepareStatement(buffer.toString());
            int bindIndex = 1;
            stmt.setInt(bindIndex++, queryId);
            stmt.setInt(bindIndex++, groupId);
            this.bindPROPIDs(stmt, bindIndex, includePROPIDs, excludePROPIDs);
            stmt.execute();
            stmt.close();
            buffer.setLength(0);
            buffer.append(sqlGenerator.createInsertIntoTableWithCMIDSql(this.getTableName()));
            buffer.append(sqlGenerator.createColumnsSeparator());
            buffer.append("REFCMID");
            for (i = 0; i < this.columnNames_.length; ++i) {
                buffer.append(sqlGenerator.createColumnsSeparator());
                buffer.append(this.columnNames_[i]);
            }
            buffer.append(sqlGenerator.createClosingBracket());
            sqlGenerator.appendSelectJoinWithCMTMPCOPYIDSNotIn(this.getTableName(), CMTMPCOPYIDSTable_, this.columnNames_, buffer);
            if (addCondition.length() > 0) {
                buffer.append(sqlGenerator.createAndSql());
                buffer.append(addCondition);
            }
            stmt = con.prepareStatement(buffer.toString());
            bindIndex = 1;
            stmt.setInt(bindIndex++, queryId);
            stmt.setInt(bindIndex++, groupId);
            stmt.setInt(bindIndex++, queryId);
            stmt.setInt(bindIndex++, groupId);
            this.bindPROPIDs(stmt, bindIndex, includePROPIDs, excludePROPIDs);
            stmt.execute();
            stmt.close();
            buffer.setLength(0);
            buffer.append(sqlGenerator.createInsertIntoTableWithCMIDSql(this.getTableName()));
            buffer.append(sqlGenerator.createColumnsSeparator());
            buffer.append("REFCMID");
            for (i = 0; i < this.columnNames_.length; ++i) {
                buffer.append(sqlGenerator.createColumnsSeparator());
                buffer.append(this.columnNames_[i]);
            }
            buffer.append(sqlGenerator.createClosingBracket());
            sqlGenerator.appendSelectJoinWithCMTMPCOPYIDSIn(this.getTableName(), CMTMPCOPYIDSTable_, this.columnNames_, buffer);
            if (addCondition.length() > 0) {
                buffer.append(sqlGenerator.createWhereSql());
                buffer.append(addCondition);
            }
            stmt = con.prepareStatement(buffer.toString());
            bindIndex = 1;
            stmt.setInt(bindIndex++, queryId);
            stmt.setInt(bindIndex++, groupId);
            stmt.setInt(bindIndex++, queryId);
            stmt.setInt(bindIndex++, groupId);
            this.bindPROPIDs(stmt, bindIndex, includePROPIDs, excludePROPIDs);
            stmt.execute();
            stmt.close();
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCorrectedReferences(CMDbConnection con, int[] includePROPIDs, int[] excludePROPIDs, CMDbTempTableId tempTableId) throws SQLException, CMException {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        this.setColumnNames(con);
        if (this.columnNames_ == null) {
            throw new IllegalStateException(this.getTableName() + " is not a reference table");
        }
        int queryId = tempTableId.getId();
        CMDbStoreCopyDef.setCMTMPCOPYIDSTableName(con);
        PreparedStatement stmt = null;
        PreparedStatement deleteStmt = null;
        StringBuffer buffer = new StringBuffer(400);
        try {
            buffer.setLength(0);
            sqlGenerator.appendDeleteFromCMTMPCOPYIDSForTargetCMIDAndQueryID(CMTMPCOPYIDSTable_, buffer);
            deleteStmt = con.prepareStatement(buffer.toString());
            deleteStmt.setInt(1, queryId);
            deleteStmt.setInt(2, queryId);
            deleteStmt.execute();
            deleteStmt.close();
            buffer.setLength(0);
            int bindQueryIdTimes = 0;
            StringBuffer addCondition = new StringBuffer(300);
            this.appendPROPIDsConditions(con, addCondition, this.getTableName(), includePROPIDs, excludePROPIDs);
            sqlGenerator.appendUpdateJoinWithCMTMPCOPYIDS(this.getTableName(), CMTMPCOPYIDSTable_, buffer);
            if (addCondition.length() > 0) {
                buffer.append(sqlGenerator.createAndSql());
                buffer.append(addCondition);
            }
            bindQueryIdTimes = 3;
            stmt = con.prepareStatement(buffer.toString());
            int bindIndex = 1;
            for (int i = 0; i < bindQueryIdTimes; ++i) {
                stmt.setInt(bindIndex++, queryId);
            }
            this.bindPROPIDs(stmt, bindIndex, includePROPIDs, excludePROPIDs);
            stmt.execute();
            stmt.close();
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(deleteStmt);
            CMDbStoreUtil.safeCloseStatement(stmt);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(deleteStmt);
        CMDbStoreUtil.safeCloseStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCopyCMIDs(CMDbConnection con, CMDbTempTableId tempTableId) throws SQLException {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        CMDbStoreCopyDef.setCMTMPCOPYIDSTableName(con);
        PreparedStatement stmt = null;
        try {
            StringBuffer deleteSQL = new StringBuffer();
            sqlGenerator.appendDeleteFromCMTMPCOPYIDSByQueryID(CMTMPCOPYIDSTable_, deleteSQL);
            stmt = con.prepareStatement(deleteSQL.toString());
            stmt.setInt(1, tempTableId.getId());
            stmt.execute();
            stmt.close();
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
    }

    private void setColumnNames(CMDbConnection con) throws SQLException {
        if (this.columnNamesSet_) {
            return;
        }
        this.columnNamesSet_ = true;
        String[] colNames = CMDbStoreFactory.getColumnNamesOfTable(this.getTableName(), con.getConnection());
        if (colNames == null || colNames.length < 2) {
            this.columnNames_ = null;
            return;
        }
        boolean bCMID = false;
        boolean bREFCMID = false;
        this.columnNames_ = new String[colNames.length - 2];
        int count = 0;
        for (int i = 0; i < colNames.length; ++i) {
            String columnName = colNames[i];
            if (columnName.equalsIgnoreCase("CMID")) {
                bCMID = true;
                continue;
            }
            if (columnName.equalsIgnoreCase("REFCMID")) {
                bREFCMID = true;
                continue;
            }
            this.columnNames_[count++] = columnName;
            if (!columnName.equalsIgnoreCase("PROPID")) continue;
            this.hasPROPIDColumn_ = true;
        }
        if (!bCMID || !bREFCMID) {
            this.columnNames_ = null;
        }
    }

    private static void setCMTMPCOPYIDSTableName(CMDbConnection con) {
        if (CMTMPCOPYIDSTable_ != null) {
            return;
        }
        CMTMPCOPYIDSTable_ = con.getSqlGenerator().createTemporaryTablePrefix(con.getDbms()) + "CMTMPCOPYIDS";
    }

    private void appendPROPIDsConditions(CMDbConnection con, StringBuffer addCondition, String alias, int[] includePROPIDs, int[] excludePROPIDs) {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        if (this.hasPROPIDColumn_) {
            if (alias != null) {
                addCondition.append(alias);
                addCondition.append(sqlGenerator.createAliasSeparator());
            }
            addCondition.append("PROPID");
            if (includePROPIDs != null) {
                CMDbStoreCopyDef.appendInBindVariables(con, addCondition, includePROPIDs.length);
            } else if (excludePROPIDs != null) {
                CMDbStoreCopyDef.appendNotInBindVariables(con, addCondition, excludePROPIDs.length);
            }
        }
    }

    private int bindPROPIDs(PreparedStatement stmt, int bindIndex, int[] includePROPIDs, int[] excludePROPIDs) throws SQLException {
        block4: {
            block3: {
                if (!this.hasPROPIDColumn_) {
                    return bindIndex;
                }
                if (includePROPIDs == null) break block3;
                for (int i = 0; i < includePROPIDs.length; ++i) {
                    stmt.setInt(bindIndex++, includePROPIDs[i]);
                }
                break block4;
            }
            if (excludePROPIDs == null) break block4;
            for (int i = 0; i < excludePROPIDs.length; ++i) {
                stmt.setInt(bindIndex++, excludePROPIDs[i]);
            }
        }
        return bindIndex;
    }
}

