/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreArrayTableUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import java.sql.SQLException;

public class CMDbStoreCopyOwnerToRecipsDef
extends CMDbStoreArrayTableUpdateDef {
    private CMDbProperty recipsProperty;
    private CMDbProperty ownerProperty;

    public CMDbStoreCopyOwnerToRecipsDef(CMDbProperty recipsProperty, CMDbProperty ownerProperty) {
        super(recipsProperty.getColumn(0).getTable());
        this.recipsProperty = recipsProperty;
        this.ownerProperty = ownerProperty;
    }

    @Override
    void execute(CMDbConnection con, int[] objectIDs) throws SQLException, CMException {
        this.clearExistingEntries(con, objectIDs, (CMDbProperty)CMProperty._OTHERRECIPIENTS);
        String baseSQL = this.createBaseSql(con);
        CMDbStoreDMLDef updateDef = new CMDbStoreDMLDef(this.getTableName());
        updateDef.executeInGroups(con, baseSQL, objectIDs, null);
    }

    private String createBaseSql(CMDbConnection con) {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        StringBuffer buffer = new StringBuffer();
        sqlGenerator.appendInsertIntoTableWithCMID(this.recipsProperty.getColumn(0).getTable(), buffer);
        buffer.append(sqlGenerator.createColumnsSeparator());
        buffer.append("ORD");
        if (this.recipsProperty.hasPropertyID()) {
            buffer.append(sqlGenerator.createColumnsSeparator());
            buffer.append("PROPID");
        }
        buffer.append(sqlGenerator.createColumnsSeparator());
        buffer.append("REFCMID");
        buffer.append(sqlGenerator.createClosingBracket());
        buffer.append(sqlGenerator.createSelectForInsertSql());
        buffer.append("CMID");
        buffer.append(sqlGenerator.createColumnsSeparator());
        buffer.append(" 0");
        buffer.append(sqlGenerator.createColumnsSeparator());
        buffer.append(this.recipsProperty.getPropertyID());
        buffer.append(sqlGenerator.createColumnsSeparator());
        buffer.append("REFCMID");
        buffer.append(sqlGenerator.createFromSql());
        buffer.append(this.ownerProperty.getColumn(0).getTable());
        buffer.append(sqlGenerator.createWhereSql());
        if (this.ownerProperty.hasPropertyID()) {
            buffer.append("PROPID");
            buffer.append(sqlGenerator.createEqualsSql());
            buffer.append(this.ownerProperty.getPropertyID());
            buffer.append(sqlGenerator.createAndSql());
        }
        return buffer.toString();
    }
}

