/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStoreQueryInfo;
import com.cognos.cm.store.CMStoreUnexpected;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class CMDbStoreDMLDef {
    protected String tableName_;
    protected CMDbProperty[] properties_ = new CMDbProperty[100];
    protected Object[] values_ = new Object[100];
    protected int numProps_;
    protected Integer[] blobStmts_;
    protected Object[] bindObjects_ = new Object[100];
    protected int numBindObjects_;

    public CMDbStoreDMLDef(String tableName) {
        this.tableName_ = tableName;
    }

    public String getTableName() {
        return this.tableName_;
    }

    public void addColumn(CMDbProperty column, Object value) {
        if (this.numProps_ >= 100) {
            throw new IllegalStateException("Cannot have more than 100 property values.");
        }
        this.properties_[this.numProps_] = column;
        this.values_[this.numProps_++] = value;
    }

    protected int bindParameters(int bindOffset, PreparedStatement stmt) throws SQLException, CMException {
        int i;
        for (i = 0; i < this.numProps_; ++i) {
            boolean boundBlob;
            CMDbProperty prop = this.properties_[i];
            boolean bl = boundBlob = prop.storedAsBlob() && this.blobStmts_ != null && this.blobStmts_[i] != null;
            if (!boundBlob) {
                this.bindParameter(stmt, bindOffset, this.properties_[i], this.values_[i]);
            } else {
                stmt.setInt(bindOffset, this.blobStmts_[i]);
            }
            bindOffset += prop.columnCount();
        }
        for (i = 0; i < this.numBindObjects_; ++i) {
            stmt.setObject(bindOffset++, this.bindObjects_[i]);
        }
        return bindOffset;
    }

    protected int bindParametersNext(int bindOffset, PreparedStatement stmt) throws SQLException, CMException {
        throw new IllegalStateException("bindParametersNext must be implemented in derived class");
    }

    public void addBindVariable(Object bindObject) {
        if (this.numBindObjects_ >= 100) {
            throw new IllegalStateException("Cannot have more than 100 bind objects.");
        }
        this.bindObjects_[this.numBindObjects_++] = bindObject;
    }

    protected boolean executeNTimesInGroupsNext(CMDbConnection con) throws SQLException, CMException {
        throw new IllegalStateException("executeNTimesInGroupsNext must be implemented in " + this.getClass().getName());
    }

    protected void resetBindParameters() throws SQLException {
        throw new IllegalStateException("resetBindParameters must be implemented in " + this.getClass().getName());
    }

    public static int bindCMIDs(int bindOffset, PreparedStatement stmt, int[] objectIDs, int startObjectIndex, int endObjectIndex) throws SQLException {
        return CMDbStoreDMLDef.bindInts(bindOffset, stmt, objectIDs, startObjectIndex, endObjectIndex);
    }

    public static int bindInts(int bindOffset, PreparedStatement stmt, int[] ints, int startObjectIndex, int endObjectIndex) throws SQLException {
        if (endObjectIndex > ints.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = startObjectIndex; i < endObjectIndex; ++i) {
            stmt.setInt(bindOffset, ints[i]);
            ++bindOffset;
        }
        return bindOffset;
    }

    public static int bindWhereCMIDsInfo(int bindOffset, PreparedStatement stmt, int[] objectIDs, CMDbStoreWhereCMIDsInfo whereCMIDsInfo) throws SQLException {
        if (whereCMIDsInfo.bindCMIDs_) {
            for (int j = 0; j < objectIDs.length; ++j) {
                stmt.setInt(bindOffset++, objectIDs[j]);
            }
        } else {
            stmt.setInt(bindOffset++, whereCMIDsInfo.queryId_);
        }
        return bindOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeInGroups(CMDbConnection con, String beginUpdateStmt, int[] objectIDs, Integer maxObjsInTransaction) throws SQLException, CMException {
        int rowCount = 0;
        int previousBindObjectIDsNumber = -1;
        StringBuffer updateStmt = new StringBuffer(700);
        PreparedStatement stmt = null;
        try {
            int maxObjectsInGroup = this.determineMaxObjectsInGroup(maxObjsInTransaction);
            for (int j = 0; j < objectIDs.length; j += maxObjectsInGroup) {
                int maxObjectIndex = Math.min(objectIDs.length, j + maxObjectsInGroup);
                int bindObjectIDsNumber = maxObjectIndex - j;
                if (bindObjectIDsNumber != previousBindObjectIDsNumber) {
                    CMDbStoreDMLDef.constructStatementWithCMIDBindVariables(con, updateStmt, beginUpdateStmt, bindObjectIDsNumber);
                    previousBindObjectIDsNumber = bindObjectIDsNumber;
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    stmt = con.prepareStatement(updateStmt.toString());
                }
                int bindOffset = this.bindParameters(1, stmt);
                bindOffset = CMDbStoreDMLDef.bindCMIDs(bindOffset, stmt, objectIDs, j, maxObjectIndex);
                rowCount += CMDbConnection.executeUpdate(stmt);
            }
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeNTimesInGroups(CMDbConnection con, String beginUpdateStmt, int[] objectIDs, Integer maxObjsInTransaction) throws SQLException, CMException {
        int previousBindObjectIDsNumber = -1;
        StringBuffer updateStmt = new StringBuffer(700);
        PreparedStatement stmt = null;
        try {
            int maxObjectsInGroup = this.determineMaxObjectsInGroup(maxObjsInTransaction);
            for (int j = 0; j < objectIDs.length; j += maxObjectsInGroup) {
                int maxObjectIndex = Math.min(objectIDs.length, j + maxObjectsInGroup);
                int bindObjectIDsNumber = maxObjectIndex - j;
                if (bindObjectIDsNumber != previousBindObjectIDsNumber) {
                    CMDbStoreDMLDef.constructStatementWithCMIDBindVariables(con, updateStmt, beginUpdateStmt, bindObjectIDsNumber);
                    previousBindObjectIDsNumber = bindObjectIDsNumber;
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    stmt = con.prepareStatement(updateStmt.toString());
                }
                this.resetBindParameters();
                while (this.executeNTimesInGroupsNext(con)) {
                    int bindOffset = this.bindParametersNext(1, stmt);
                    bindOffset = CMDbStoreDMLDef.bindCMIDs(bindOffset, stmt, objectIDs, j, maxObjectIndex);
                    CMDbConnection.executeUpdate(stmt);
                }
            }
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
    }

    private int determineMaxObjectsInGroup(Integer maxObjsInTransaction) {
        int maxObjsInTrans;
        int maxObjectsInGroup = CMDbConnection.getMaxObjectsInUpdate();
        if (maxObjsInTransaction != null && (maxObjsInTrans = maxObjsInTransaction.intValue()) > 0 && maxObjsInTrans < maxObjectsInGroup) {
            maxObjectsInGroup = maxObjsInTrans;
        }
        return maxObjectsInGroup;
    }

    public static void constructStatementWithCMIDBindVariables(CMDbConnection con, StringBuffer updateStmt, String beginUpdateStmt, int objectIDsNumber) {
        updateStmt.setLength(0);
        updateStmt.append(beginUpdateStmt);
        updateStmt.append(" CMID");
        CMDbStoreDMLDef.appendInBindVariables(con, updateStmt, objectIDsNumber);
    }

    public static void appendInBindVariables(CMDbConnection con, StringBuffer buffer, int objectIDsNumber) {
        CMDbStoreDMLDef.appendInBindVariables(con.getSqlGenerator(), buffer, objectIDsNumber);
    }

    public static void appendInBindVariables(ICMDbStoreSqlGenerator sqlGenerator, StringBuffer buffer, int objectIDsNumber) {
        buffer.append(sqlGenerator.createInNoSpaceSql());
        CMDbStoreDMLDef.appendBindVariables(sqlGenerator, buffer, objectIDsNumber);
    }

    public static void appendNotInBindVariables(CMDbConnection con, StringBuffer buffer, int objectIDsNumber) {
        buffer.append(con.getSqlGenerator().createNotInNoSpaceSql());
        CMDbStoreDMLDef.appendBindVariables(con.getSqlGenerator(), buffer, objectIDsNumber);
    }

    private static void appendBindVariables(ICMDbStoreSqlGenerator sqlGenerator, StringBuffer buffer, int objectIDsNumber) {
        buffer.append(" ");
        buffer.append(sqlGenerator.createOpeningBracket());
        for (int i = 0; i < objectIDsNumber; ++i) {
            if (i > 0) {
                buffer.append(sqlGenerator.createBindParametersSeparator());
            }
            buffer.append(sqlGenerator.createBindParameterSymbol());
        }
        buffer.append(sqlGenerator.createClosingBracket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertCMIDsIntoTempTable(CMDbConnection con, int[] objectIDs, CMDbStoreWhereCMIDsInfo whereCMIDs) throws SQLException, CMException {
        PreparedStatement stmt;
        block9: {
            if (objectIDs.length == 0) {
                return;
            }
            ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
            stmt = null;
            String tempTable = sqlGenerator.createTemporaryTablePrefix(CMDbConnection.dbms_) + "CMTMPIDS";
            try {
                if (CMDbConnection.dbms_ == 1) {
                    ByteArrayOutputStream us = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(us);
                    try {
                        for (int i = 0; i < objectIDs.length; ++i) {
                            dos.writeInt(objectIDs[i]);
                        }
                        dos.flush();
                    }
                    catch (IOException ex) {
                        throw new CMStoreUnexpected(ex, "cmErrInsertingIntoTemporaryTable");
                    }
                    stmt = con.prepareStatement(sqlGenerator.createExecProcedureWithNBindParameters("CMPARSEIDS", 2));
                    stmt.setInt(1, whereCMIDs.queryId_);
                    stmt.setBytes(2, us.toByteArray());
                    CMDbConnection.executeUpdate(stmt);
                    break block9;
                }
                StringBuffer insertSQL = new StringBuffer();
                sqlGenerator.appendInsertIntoCMTMPIDS(tempTable, insertSQL);
                stmt = con.prepareStatement(insertSQL.toString());
                for (int i = 0; i < objectIDs.length; ++i) {
                    stmt.setInt(1, whereCMIDs.queryId_);
                    stmt.setInt(2, objectIDs[i]);
                    stmt.addBatch();
                    if ((i + 1 & 0x3FF) != 0) continue;
                    stmt.executeBatch();
                }
                if ((objectIDs.length & 0x3FF) != 0) {
                    stmt.executeBatch();
                }
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CMDbStoreWhereCMIDsInfo constructWhereCMIDs(CMDbConnection con, int[] objectIDs, String columnName, boolean forIN, boolean firstTime) throws SQLException, CMException {
        if (objectIDs.length == 0) {
            return null;
        }
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        CMDbStoreWhereCMIDsInfo whereCMIDs = new CMDbStoreWhereCMIDsInfo();
        int maxObjectsInGroup = CMDbConnection.getMaxObjectsInline();
        if (objectIDs.length > maxObjectsInGroup) {
            whereCMIDs.queryId_ = con.getTmpTableId().getId();
            whereCMIDs.bindCMIDs_ = false;
            Statement stmt = null;
            String tempTable = sqlGenerator.createTemporaryTablePrefix(CMDbConnection.dbms_) + "CMTMPIDS";
            try {
                whereCMIDs.fromClause_ = whereCMIDs.fromClause_ + sqlGenerator.createJoinTableWithAliasSql(tempTable, "t") + " ";
                whereCMIDs.whereClause_ = columnName + sqlGenerator.createJoinWithTempTableForQueryIDConditionSql(forIN, "QUERYID", "t");
                if (!firstTime) return whereCMIDs;
                CMDbStoreDMLDef.insertCMIDsIntoTempTable(con, objectIDs, whereCMIDs);
                return whereCMIDs;
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
        } else {
            StringBuffer inClause = new StringBuffer(5 + objectIDs.length * 2);
            inClause.append(columnName);
            if (forIN) {
                CMDbStoreDMLDef.appendInBindVariables(con, inClause, objectIDs.length);
            } else {
                CMDbStoreDMLDef.appendNotInBindVariables(con, inClause, objectIDs.length);
            }
            whereCMIDs.whereClause_ = inClause.toString();
        }
        return whereCMIDs;
    }

    public CMDbStoreWhereCMIDsInfo constructWhereCMIDsNotInline(CMDbConnection con, int objectIDsLength, String columnName, boolean forIN) throws CMException {
        if (objectIDsLength == 0) {
            return null;
        }
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        CMDbStoreWhereCMIDsInfo whereCMIDs = new CMDbStoreWhereCMIDsInfo();
        whereCMIDs.queryId_ = con.getTmpTableId().getId();
        whereCMIDs.bindCMIDs_ = false;
        String tempTable = sqlGenerator.createTemporaryTablePrefix(CMDbConnection.dbms_) + "CMTMPIDS";
        whereCMIDs.fromClause_ = whereCMIDs.fromClause_ + sqlGenerator.createJoinTableWithAliasSql(tempTable, "q") + " ";
        whereCMIDs.whereClause_ = columnName + sqlGenerator.createJoinWithTempTableForQueryIDConditionSql(forIN, "QUERYID", "q");
        return whereCMIDs;
    }

    void bindParameter(PreparedStatement stmt, int paramPos, CMDbProperty property, Object value) throws SQLException, CMException {
        CMDbStorePropertySerialization.bindParameterByProperty(stmt, paramPos, property, value);
    }

    public class CMDbStoreWhereCMIDsInfo
    implements CMStoreQueryInfo {
        public String fromClause_ = new String();
        public String whereClause_ = new String();
        public boolean bindCMIDs_ = true;
        public int queryId_;

        @Override
        public String getFromClause() {
            return this.fromClause_;
        }

        @Override
        public String getWhereClause() {
            return this.whereClause_;
        }

        @Override
        public int getQueryID() {
            return this.queryId_;
        }
    }
}

