/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreMultipleLocalizedStringTableUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreSelectDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.dbstore.binders.CMDbStoreStringBinder;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.store.CMStoreUnexpected;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class CMDbStoreDefaultNamesTableUpdateDef
extends CMDbStoreMultipleLocalizedStringTableUpdateDef {
    public CMDbStoreDefaultNamesTableUpdateDef(String table) {
        super(table);
    }

    @Override
    void execute(CMDbConnection con, int objectID) throws SQLException, CMException, CMStoreUnexpected {
        int[] objectIDs = new int[]{objectID};
        this.execute(con, objectIDs);
    }

    @Override
    void execute(CMDbConnection con, String additionToSetClause, int objectID) throws SQLException, CMException, CMStoreUnexpected {
        throw new IllegalStateException("Function is not implemented");
    }

    @Override
    void execute(CMDbConnection con, String additionToSetClause, int[] objectIDs) throws SQLException, CMException, CMStoreUnexpected {
        throw new IllegalStateException("Function is not implemented");
    }

    @Override
    void execute(CMDbConnection con, String additionToSetClause, String additionToWhereClause, int[] objectIDs) throws SQLException, CMException, CMStoreUnexpected {
        throw new IllegalStateException("Function is not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void execute(CMDbConnection con, int[] objectIDs) throws SQLException, CMException {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        for (int propIdx = 0; propIdx != this.numProps_; ++propIdx) {
            CMDbProperty prop = this.properties_[propIdx];
            String value = (String)this.values_[propIdx];
            if (value == null) {
                value = "";
            }
            CMProperty localeIdProp = null;
            if (prop != CMProperty.DEFAULTNAME) {
                throw new IllegalStateException("invalid property in CMDbStoreDefaultNamesTableUpdateDef");
            }
            localeIdProp = CMProperty._DEFAULTNAMELOCALEID;
            CMDbStoreSelectDef localeIdSelectDef = new CMDbStoreSelectDef(con, null, new CMProperty[]{localeIdProp}, null);
            String localeIdSelectStmt = localeIdSelectDef.getSelectStmt();
            if (localeIdSelectStmt == null) {
                throw new IllegalStateException("localeIdSelectStmt couldn't be null");
            }
            String localeIdWhereClause = localeIdSelectDef.getWhereClause();
            String[] sqlFragments = sqlGenerator.createDefaultNamesTableUpdateSQLs(this.getTableName(), prop, value, localeIdSelectStmt, localeIdWhereClause);
            String insertSQL = sqlFragments[0];
            String insertSQLEnd = sqlFragments[1];
            String updateSQL = sqlFragments[2];
            String updateSQLEnd = sqlFragments[3];
            int maxUpdateCMIDs = CMDbConnection.getMaxObjectsInUpdate();
            int maxStmtLength = CMDbConnection.getDbmsInfo().getDbmsMaxStatementLength();
            int maxObjectsInSQL = maxUpdateCMIDs;
            if (maxStmtLength > 0) {
                StringBuffer insertSQL1 = new StringBuffer();
                StringBuffer updateSQL1 = new StringBuffer();
                sqlGenerator.appendDefaultNamesTableUpdateMiddleSQLsForOneCMID(100, localeIdSelectStmt, localeIdWhereClause, insertSQL1, updateSQL1);
                maxObjectsInSQL = (maxStmtLength - updateSQL.length() - updateSQLEnd.length()) / updateSQL1.length();
                if (maxObjectsInSQL > maxUpdateCMIDs) {
                    maxObjectsInSQL = maxUpdateCMIDs;
                }
            }
            int iCMID = 0;
            while (iCMID < objectIDs.length) {
                StringBuffer insertSQL1 = new StringBuffer(256);
                StringBuffer updateSQL1 = new StringBuffer(256);
                int firstCMIDIdx = iCMID;
                int numberOfCMIDsToBindUpdate = 0;
                int numberOfCMIDsToBindInsert = 0;
                for (int iObjectInSQL = 0; iCMID < objectIDs.length && iObjectInSQL < maxObjectsInSQL; ++iCMID, ++iObjectInSQL) {
                    int[] numbersToBind = sqlGenerator.appendDefaultNamesTableUpdateMiddleSQLsForOneCMID(iObjectInSQL, localeIdSelectStmt, localeIdWhereClause, insertSQL1, updateSQL1);
                    numberOfCMIDsToBindInsert = numbersToBind[0];
                    numberOfCMIDsToBindUpdate = numbersToBind[1];
                }
                int lastCMIDIdx = iCMID;
                String updateSQLComplete = updateSQL + updateSQL1.toString() + updateSQLEnd;
                PreparedStatement update2 = con.prepareStatement(updateSQLComplete);
                PreparedStatement insertStmt = null;
                CMDbStoreStringLocale locale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(CMExecutionContext.get().getPreference(CMPreference.CONTENTLOCALE));
                try {
                    int colIdx = 1;
                    CMDbStoreStringBinder.bind(update2, colIdx++, value);
                    for (int bindCMIDIdx = firstCMIDIdx; bindCMIDIdx < lastCMIDIdx; ++bindCMIDIdx) {
                        for (int CMIDColIdx = 0; CMIDColIdx < numberOfCMIDsToBindUpdate; ++CMIDColIdx) {
                            update2.setInt(colIdx++, objectIDs[bindCMIDIdx]);
                        }
                    }
                    int result = CMDbConnection.executeUpdate(update2);
                    if (result != 0 || value.equals("")) continue;
                    String insertSQLComplete = insertSQL + insertSQL1.toString() + insertSQLEnd;
                    insertStmt = con.prepareStatement(insertSQLComplete);
                    colIdx = 1;
                    insertStmt.setShort(colIdx++, locale.getInternalID());
                    CMDbStoreStringBinder.bind(insertStmt, colIdx++, value);
                    insertStmt.setBoolean(colIdx++, true);
                    insertStmt.setShort(colIdx++, locale.getMappedID());
                    insertStmt.setShort(colIdx++, locale.getMappedID());
                    for (int bindCMIDIdx = firstCMIDIdx; bindCMIDIdx < lastCMIDIdx; ++bindCMIDIdx) {
                        for (int CMIDColIdx = 0; CMIDColIdx < numberOfCMIDsToBindInsert; ++CMIDColIdx) {
                            update2.setInt(colIdx++, objectIDs[bindCMIDIdx]);
                        }
                    }
                    CMDbConnection.executeUpdate(insertStmt);
                }
                finally {
                    CMDbStoreUtil.safeCloseStatement(update2);
                    CMDbStoreUtil.safeCloseStatement(insertStmt);
                }
            }
        }
    }
}

