/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringArray;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.server.UserPreferences;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMObjectRef;

class CMDbStoreDefaultOutput {
    CMDbStoreDefaultOutput() {
    }

    public static boolean isValidClass(CMObjectClass objClass) {
        return objClass.getMaxOccursFor(CMObjectClass.REPORTVERSION) != 0 || objClass.subclassof(CMObjectClass.REPORTVERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(CMStorePath defaultOutputFor) throws CMException {
        CMStoreQueryResults results = CMExecutionContext.get().getStore().executeQuery(defaultOutputFor, null, null, 0, 1, null);
        try {
            if (results.next()) {
                String curObjectSearchPath = results.getSearchPath();
                CMObjectClass curObjectClass = results.getObjectClass();
                if (results.next()) {
                    throw new CMException("cmInvalidArgGT1ObjectSel", new CMException.Parm("Argument", "searchPath"));
                }
                if (!CMDbStoreDefaultOutput.isValidClass(curObjectClass)) {
                    throw new CMException("cmInvalidArgObjectBadClass", new CMException.Parm("Argument", "searchPath"));
                }
                results.reset();
                String string = CMDbStoreDefaultOutput.findOutputObject(curObjectSearchPath, null);
                return string;
            }
        }
        finally {
            results.release();
        }
        return null;
    }

    public static Object getDefaultOutputFormat(String searchPath) throws CMException {
        CMObjectRef format = new CMObjectRef();
        if (CMDbStoreDefaultOutput.findOutputObject(searchPath, format) != null && format.get() != null) {
            CMDbStoreStringArray results = new CMDbStoreStringArray();
            results.add(format.get());
            return results;
        }
        return null;
    }

    public static int getDefaultOutput(CMCacheQueryInstance query2, int permissionFlags, int objectIndex, int[] supportedFormats) throws CMException {
        UserPreferences userPreferences;
        CMExecutionContext context = CMExecutionContext.get();
        CMDbProperty propFormat = (CMDbProperty)CMProperty.FORMAT;
        String prefFormat = context.getPreference(CMPreference.FORMAT);
        int formatEnumID = -1;
        if ((prefFormat == null || prefFormat.length() == 0) && (userPreferences = context.getCurrentUserSessionVars()) != null) {
            prefFormat = userPreferences.get(CMPreference.FORMAT);
        }
        formatEnumID = prefFormat == null || prefFormat.length() == 0 ? (int)propFormat.getEnumID("HTML") : (int)propFormat.getEnumID(prefFormat);
        try {
            return query2.getDefaultOutput(objectIndex, permissionFlags, CMDbStoreCacheUtil.getCacheSearchLocales(), formatEnumID, supportedFormats);
        }
        catch (CMCacheException ex) {
            throw new CMException(ex, "cmUnexpectedError");
        }
    }

    public static Object getDefaultOutputFormat(CMStore store, CMCacheQueryInstance query2, String basePath, int permissionFlags, int objectIndex) throws CMException {
        int result;
        ICMLockManager lockMgr = store.getLockManager();
        if (!lockMgr.currentThreadHasExclusiveLocks()) {
            try {
                int[] lockObjects = new int[]{query2.resultObjects()[objectIndex]};
                lockMgr.requestLocksToObjects(lockObjects, 16);
            }
            catch (CMCacheException ex) {
                throw new CMException(ex, "cmUnexpectedError");
            }
        }
        if ((result = CMDbStoreDefaultOutput.getDefaultOutput(query2, permissionFlags, objectIndex, new int[0])) == -1) {
            return null;
        }
        if (result == 0) {
            int[] objs;
            Object defaultFormat;
            if (AdvancedSettings.LAZYDEFAULTOUTPUTFORMAT && (defaultFormat = CMDbStoreDefaultOutput.lazyDefaultOutputFormat(objs = new int[]{query2.resultObjects()[objectIndex]})) != null) {
                return defaultFormat;
            }
            CMObjectRef format = new CMObjectRef();
            if (CMDbStoreDefaultOutput.findOutputObject(basePath, format) != null && format.get() != null) {
                CMDbStoreStringArray results = new CMDbStoreStringArray();
                results.add(format.get());
                return results;
            }
        } else {
            return CMDbStoreDefaultOutput.getCacheFormatProperty(result);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object lazyDefaultOutputFormat(int[] reportIds) throws CMException {
        if (reportIds == null) {
            return null;
        }
        CMDbStore store = (CMDbStore)CMExecutionContext.get().getStore();
        CMStoreXPath rvPath = new CMStoreXPath("/*/reportVersion[last()]");
        int reportVersionId = -1;
        CMCacheQueryInstance qresults = null;
        try {
            qresults = store.getCache().executeAdminQuery(reportIds, reportIds.length, rvPath, 0);
            int[] objs = qresults.resultObjects();
            if (objs != null && objs.length > 0) {
                reportVersionId = objs[0];
            }
        }
        catch (CMCacheAccessDenied e) {
            reportVersionId = -1;
        }
        finally {
            if (qresults != null) {
                qresults.release();
            }
        }
        if (reportVersionId > 0) {
            return CMDbStoreDefaultOutput.getCacheFormatProperty(reportVersionId);
        }
        return null;
    }

    private static Object getCacheFormatProperty(int objId) throws CMException {
        CMDbStore store = (CMDbStore)CMExecutionContext.get().getStore();
        CMDbProperty propFormat = (CMDbProperty)CMProperty.FORMAT;
        int formatValue = store.getCache().CMCacheGetIntegerProperty(objId, 12);
        if (formatValue == 255) {
            return null;
        }
        String formatString = propFormat.getEnumValue((short)formatValue);
        if (formatString == null) {
            return null;
        }
        CMDbStoreStringArray results = new CMDbStoreStringArray();
        results.add(new CMDbStoreString(formatString));
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findOutputObject(String basePath, CMObjectRef defaultFormat) throws CMException {
        if (basePath == null) {
            return null;
        }
        CMStorePath childQuery = null;
        CMExecutionContext context = CMExecutionContext.get();
        CMStore store = context.getStore();
        String queryExpr = "/reportVersion[last()]/output[permission('read')]";
        try {
            childQuery = CMStoreXPath.parse(basePath + queryExpr);
            childQuery.setLockManagerUsageFlag(10);
        }
        catch (CMStoreParseException ex) {
            throw new IllegalStateException("bad path: " + ex.toString());
        }
        CMStoreXPath lockPath = new CMStoreXPath(basePath);
        lockPath.setLockManagerUsageFlag(16);
        store.getLockManager().requestLocks(lockPath);
        childQuery.setLocksHaveBeenObtained();
        CMStoreQueryResults results = context.getStore().executeQuery(childQuery, new CMProperty[]{CMProperty.FORMAT}, new OrderByField[]{new OrderByField(true, CMProperty._BESTLOCALEMATCHRANK), new OrderByField(true, CMProperty._BESTFORMATMATCHRANK)}, 0, 1, null);
        try {
            if (results.next()) {
                if (defaultFormat != null) {
                    defaultFormat.set(results.getValue(0));
                }
                String string = results.getSearchPath();
                return string;
            }
        }
        finally {
            results.release();
        }
        queryExpr = "/*[@objectClass='reportVersion']/output[permission('read')]";
        try {
            childQuery = CMStoreXPath.parse(basePath + queryExpr);
            CMStorePathStep rvStep = childQuery.stepAt(childQuery.size() - 2);
            rvStep.setClass(CMObjectClass.REPORTVERSION);
            childQuery.setLockManagerUsageFlag(10);
        }
        catch (CMStoreParseException ex) {
            throw new IllegalStateException("bad path: " + ex.toString());
        }
        results = context.getStore().executeQuery(childQuery, new CMProperty[]{CMProperty.FORMAT}, new OrderByField[]{new OrderByField(true, CMProperty._BESTLOCALEMATCHRANK), new OrderByField(true, CMProperty._BESTFORMATMATCHRANK), new OrderByField(true, CMProperty.CREATIONTIME)}, 0, 1, null);
        try {
            if (results.next()) {
                if (defaultFormat != null) {
                    defaultFormat.set(results.getValue(0));
                }
                String string = results.getSearchPath();
                return string;
            }
        }
        finally {
            results.release();
        }
        return null;
    }
}

