/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.server.AdvancedSettings;

public class CMDbStoreDefaultSqlGenerator
implements ICMDbStoreSqlGenerator {
    private static final String EMPTY_STRING = "";
    static final String stmtCacheInitSelect = "select b.CMID, b.PCMID, c.NAME, c.LOCALEID + (case when c.ISDEFAULT=0 then 0 else 1 end) + coalesce(c.MAPDLOCALEID, 0)*65536, b.CLASSID, '', (case when p.POLICIES is null then 0 else 1 end) as HASSECURITY, (case when exists(select * from  CMREFORD1 r where r.CMID=b.CMID and r.ID=26) then 1 else 0 end), b.DISABLED, case b.CLASSID when 39 then (select sched.TASKID from CMOBJPROPS2 sched where sched.CMID=b.CMID) when 111 then (p11.EVENTID) else coalesce((select p2.OBJID from CMOBJPROPS1 p2 where p2.CMID=b.CMID), d.DISPATCHERPATH) end, (case when d.CREDNAMESPACES is null then 0 else 1 end) as HASCREDNAMESPACES, (case when p2.OLOCALEID is null then 0 else p2.OLOCALEID+65536*coalesce(l.MAPDLOCALEID,0) end), coalesce(p2.FORMAT, 255), (case when deploy.MESSAGE is null then 0 else 1 end), deploy.DEPLOYOBJUSAGE, (case when bo.RECIPSEMAIL is null then 0 else 1 end), sid.STOREID, b.OWNER, b.VERSION, b.TENANTID from CMOBJECTS b left outer join CMOBJPROPS6 d on b.CMID=d.CMID left outer join CMOBJPROPS11 p11 on b.CMID=p11.CMID left outer join CMOBJPROPS54 p2 on b.CMID=p2.CMID left outer join CMOBJPROPS25 deploy on b.CMID=deploy.CMID left outer join CMLOCALES l on l.LOCALEID=p2.OLOCALEID left outer join CMOBJPROPS14 bo on bo.CMID=b.CMID left outer join CMSTOREIDS sid on sid.CMID=b.CMID, CMPOLICIES p, CMOBJNAMES c where b.CMID=p.CMID and b.CMID=c.CMID order by b.CMID";
    static final String stmtCacheInitSelect_IDBased = "select b.CMID, b.PCMID, c.NAME, c.LOCALEID + (case when c.ISDEFAULT=0 then 0 else 1 end) + coalesce(c.MAPDLOCALEID, 0)*65536, b.CLASSID, '', (case when p.POLICIES is null then 0 else 1 end) as HASSECURITY, (case when exists(select * from  CMREFORD1 r where r.CMID=b.CMID and r.PROPID=26) then 1 else 0 end), b.DISABLED, case b.CLASSID when 39 then (select sched.TASKID from CMOBJPROPS2 sched where sched.CMID=b.CMID) when 111 then (p11.EVENTID) else coalesce((select p2.OBJID from CMOBJPROPS1 p2 where p2.CMID=b.CMID), d.DISPATCHERPATH) end, (case when exists(select * from CMREFNOORD1 d1 where d1.CMID=b.CMID and d1.PROPID=9) then 1 else 0 end) as HASCREDNAMESPACES, (case when p2.OLOCALEID is null then 0 else p2.OLOCALEID+65536*coalesce(l.MAPDLOCALEID,0) end), coalesce(p2.FORMAT, 255), (case when deploy.MESSAGE is null then 0 else 1 end), deploy.DEPLOYOBJUSAGE, (case when bo.RECIPSEMAIL is null then 0 else 1 end), sid.STOREID, owner.REFCMID, b.VERSION, b.TENANTID from CMOBJECTS b left outer join CMOBJPROPS6 d on b.CMID=d.CMID left outer join CMOBJPROPS11 p11 on b.CMID=p11.CMID left outer join CMOBJPROPS54 p2 on b.CMID=p2.CMID left outer join CMOBJPROPS25 deploy on b.CMID=deploy.CMID left outer join CMLOCALES l on l.LOCALEID=p2.OLOCALEID left outer join CMOBJPROPS14 bo on bo.CMID=b.CMID left outer join CMSTOREIDS sid on sid.CMID=b.CMID left outer join CMREFNOORD2 owner on owner.CMID=b.CMID, CMPOLICIES p, CMOBJNAMES c where b.CMID=p.CMID and b.CMID=c.CMID order by b.CMID";
    static final String stmtCacheInitSelectDB2zOS_IDBased = "select b.CMID, b.PCMID, c.NAME, c.LOCALEID + (case when c.ISDEFAULT=0 then 0 else 1 end) + coalesce(c.MAPDLOCALEID, 0)*65536, b.CLASSID, '', (case when p.POLICIES is null then 0 else 1 end) as HASSECURITY, (case when (select count(*)  from  CMREFORD1 r where r.CMID=b.CMID and r.PROPID=26) >0 then 1 else 0 end), b.DISABLED, case b.CLASSID when 39 then (select sched.TASKID from CMOBJPROPS2 sched where sched.CMID=b.CMID) when 111 then (p11.EVENTID) else coalesce((select p2.OBJID from CMOBJPROPS1 p2 where p2.CMID=b.CMID), d.DISPATCHERPATH) end, (case when (select count(*)  from CMREFNOORD1 d1 where d1.CMID=b.CMID and d1.PROPID=9) >0 then 1 else 0 end) as HASCREDNAMESPACES, (case when p2.OLOCALEID is null then 0 else p2.OLOCALEID+65536*coalesce(l.MAPDLOCALEID, 0) end), coalesce(p2.FORMAT, 255), (case when deploy.MESSAGE is null then 0 else 1 end), deploy.DEPLOYOBJUSAGE, (case when bo.RECIPSEMAIL is null then 0 else 1 end), sid.STOREID, owner.REFCMID, b.VERSION, b.TENANTID from CMOBJECTS b left outer join CMOBJPROPS6 d on b.CMID=d.CMID left outer join CMOBJPROPS11 p11 on b.CMID=p11.CMID left outer join CMOBJPROPS54 p2 on b.CMID=p2.CMID left outer join CMOBJPROPS25 deploy on b.CMID=deploy.CMID left outer join CMLOCALES l on l.LOCALEID=p2.OLOCALEID left outer join CMOBJPROPS14 bo on bo.CMID=b.CMID left outer join CMSTOREIDS sid on sid.CMID=b.CMID left outer join CMREFNOORD2 owner on owner.CMID=b.CMID, CMPOLICIES p, CMOBJNAMES c where b.CMID=p.CMID and b.CMID=c.CMID order by b.CMID";
    static final String stmtCacheInitSelectSybase = "select b.CMID, b.PCMID, c.NAME, c.LOCALEID + (case when c.ISDEFAULT=0 then 0 else 1 end) + coalesce(c.MAPDLOCALEID, 0)*65536, b.CLASSID, '', (case when (datalength(p.POLICIES) is null or datalength(p.POLICIES) < 1) then 0 else 1 end) as HASSECURITY, (case when exists(select * from  CMREFORD1 r where r.CMID=b.CMID and r.PROPID=26) then 1 else 0 end), b.DISABLED, case b.CLASSID when 39 then (select sched.TASKID from CMOBJPROPS2 sched where sched.CMID=b.CMID) when 111 then (p11.EVENTID) else coalesce((select p2.OBJID from CMOBJPROPS1 p2 where p2.CMID=b.CMID), d.DISPATCHERPATH) end, (case when d.CREDNAMESPACES is null then 0 else 1 end) as HASCREDNAMESPACES, (case when p2.OLOCALEID is null then 0 else p2.OLOCALEID+65536*coalesce(l.MAPDLOCALEID,0) end), coalesce(p2.FORMAT, 255), (case when (datalength(deploy.MESSAGE) is null or datalength(deploy.MESSAGE) < 1) then 0 else 1 end), deploy.DEPLOYOBJUSAGE, (case when (datalength(bo.RECIPSEMAIL) is null or datalength(bo.RECIPSEMAIL) < 1) then 0 else 1 end), sid.STOREID, b.OWNER, b.VERSION, b.TENANTID from CMOBJECTS b left outer join CMOBJPROPS6 d on b.CMID=d.CMID left outer join CMOBJPROPS11 p11 on b.CMID=p11.CMID left outer join CMOBJPROPS54 p2 on b.CMID=p2.CMID left outer join CMOBJPROPS25 deploy on b.CMID=deploy.CMID left outer join CMLOCALES l on l.LOCALEID=p2.OLOCALEID left outer join CMOBJPROPS14 bo on bo.CMID=b.CMID left outer join CMSTOREIDS sid on sid.CMID=b.CMID, CMPOLICIES p, CMOBJNAMES c where b.CMID=p.CMID and b.CMID=c.CMID order by b.CMID";
    static final String stmtCacheInitSelectSybase_IDBased = "select b.CMID, b.PCMID, c.NAME, c.LOCALEID + (case when c.ISDEFAULT=0 then 0 else 1 end) + coalesce(c.MAPDLOCALEID, 0)*65536, b.CLASSID, '', (case when (datalength(p.POLICIES) is null or datalength(p.POLICIES) < 1) then 0 else 1 end) as HASSECURITY, (case when exists(select * from  CMREFORD1 r where r.CMID=b.CMID and r.PROPID=26) then 1 else 0 end), b.DISABLED, case b.CLASSID when 39 then (select sched.TASKID from CMOBJPROPS2 sched where sched.CMID=b.CMID) when 111 then (p11.EVENTID) else coalesce((select p2.OBJID from CMOBJPROPS1 p2 where p2.CMID=b.CMID), d.DISPATCHERPATH) end, (case when exists(select * from CMREFNOORD1 d1 where d1.CMID=b.CMID and d1.PROPID=9) then 1 else 0 end) as HASCREDNAMESPACES, (case when p2.OLOCALEID is null then 0 else p2.OLOCALEID+65536*coalesce(l.MAPDLOCALEID,0) end), coalesce(p2.FORMAT, 255), (case when (datalength(deploy.MESSAGE) is null or datalength(deploy.MESSAGE) < 1) then 0 else 1 end), deploy.DEPLOYOBJUSAGE, (case when (datalength(bo.RECIPSEMAIL) is null or datalength(bo.RECIPSEMAIL) < 1) then 0 else 1 end), sid.STOREID, owner.REFCMID, b.VERSION, b.TENANTID from CMOBJECTS b left outer join CMOBJPROPS6 d on b.CMID=d.CMID left outer join CMOBJPROPS11 p11 on b.CMID=p11.CMID left outer join CMOBJPROPS54 p2 on b.CMID=p2.CMID left outer join CMOBJPROPS25 deploy on b.CMID=deploy.CMID left outer join CMLOCALES l on l.LOCALEID=p2.OLOCALEID left outer join CMOBJPROPS14 bo on bo.CMID=b.CMID left outer join CMSTOREIDS sid on sid.CMID=b.CMID left outer join CMREFNOORD2 owner on owner.CMID=b.CMID, CMPOLICIES p, CMOBJNAMES c where b.CMID=p.CMID and b.CMID=c.CMID order by b.CMID";
    static final String stmtCacheInitSelectDerby = "select b.CMID, b.PCMID, c.NAME, c.LOCALEID + (case when c.ISDEFAULT=0 then 0 else 1 end) + coalesce(c.MAPDLOCALEID, 0)*65536, b.CLASSID, '', (case when p.POLICIES is null then 0 else 1 end) as HASSECURITY, (case when exists(select * from  CMREFORD1 r where r.CMID=b.CMID and r.PROPID=26) then 1 else 0 end), b.DISABLED, case when b.CLASSID = 39 then (select sched.TASKID from CMOBJPROPS2 sched where sched.CMID=b.CMID) else (case when b.CLASSID = 111 then (p11.EVENTID) else coalesce(derbyP2.OBJID, d.DISPATCHERPATH) end ) end, (case when d.CREDNAMESPACES is null then 0 else 1 end) as HASCREDNAMESPACES, (case when p2.OLOCALEID is null then 0 else p2.OLOCALEID+65536*coalesce(l.MAPDLOCALEID,0) end), coalesce(p2.FORMAT, 255), (case when deploy.MESSAGE is null then 0 else 1 end), deploy.DEPLOYOBJUSAGE, (case when bo.RECIPSEMAIL is null then 0 else 1 end), sid.STOREID, b.OWNER, b.VERSION, b.TENANTID from CMOBJECTS b left outer join CMOBJPROPS6 d on b.CMID=d.CMID left outer join CMOBJPROPS11 p11 on b.CMID=p11.CMID left outer join CMOBJPROPS54 p2 on b.CMID=p2.CMID left outer join CMOBJPROPS25 deploy on b.CMID=deploy.CMID left outer join CMLOCALES l on l.LOCALEID=p2.OLOCALEID left outer join CMOBJPROPS14 bo on bo.CMID=b.CMID left outer join CMOBJPROPS1 derbyP2 on derbyP2.CMID=b.CMID left outer join CMSTOREIDS sid on sid.CMID=b.CMID, CMPOLICIES p, CMOBJNAMES c where b.CMID=p.CMID and b.CMID=c.CMID order by b.CMID";
    static final String stmtCacheInitSelectDerby_IDBased = "select b.CMID, b.PCMID, c.NAME, c.LOCALEID + (case when c.ISDEFAULT=0 then 0 else 1 end) + coalesce(c.MAPDLOCALEID, 0)*65536, b.CLASSID, '', (case when p.POLICIES is null then 0 else 1 end) as HASSECURITY, (case when exists(select * from  CMREFORD1 r where r.CMID=b.CMID and r.PROPID=26) then 1 else 0 end), b.DISABLED, case when b.CLASSID = 39 then (select sched.TASKID from CMOBJPROPS2 sched where sched.CMID=b.CMID) else (case when b.CLASSID = 111 then (p11.EVENTID) else coalesce(derbyP2.OBJID, d.DISPATCHERPATH) end ) end, (case when exists(select * from CMREFNOORD1 d1 where d1.CMID=b.CMID and d1.PROPID=9) then 1 else 0 end) as HASCREDNAMESPACES, (case when p2.OLOCALEID is null then 0 else p2.OLOCALEID+65536*coalesce(l.MAPDLOCALEID,0) end), coalesce(p2.FORMAT, 255), (case when deploy.MESSAGE is null then 0 else 1 end), deploy.DEPLOYOBJUSAGE, (case when bo.RECIPSEMAIL is null then 0 else 1 end), sid.STOREID, owner.REFCMID, b.VERSION, b.TENANTID from CMOBJECTS b left outer join CMOBJPROPS6 d on b.CMID=d.CMID left outer join CMOBJPROPS11 p11 on b.CMID=p11.CMID left outer join CMOBJPROPS54 p2 on b.CMID=p2.CMID left outer join CMOBJPROPS25 deploy on b.CMID=deploy.CMID left outer join CMLOCALES l on l.LOCALEID=p2.OLOCALEID left outer join CMOBJPROPS14 bo on bo.CMID=b.CMID left outer join CMOBJPROPS1 derbyP2 on derbyP2.CMID=b.CMID left outer join CMSTOREIDS sid on sid.CMID=b.CMID left outer join CMREFNOORD2 owner on owner.CMID=b.CMID, CMPOLICIES p, CMOBJNAMES c where b.CMID=p.CMID and b.CMID=c.CMID order by b.CMID";
    static final String stmtCacheInitSelectInformix = "select b.CMID, b.PCMID, c.NAME, c.LOCALEID + (case when c.ISDEFAULT=0 then 0 else 1 end) + NVL(c.MAPDLOCALEID, 0)*65536, b.CLASSID, '', (case when p.POLICIES is null then 0 else 1 end) as HASSECURITY, (case when exists(select * from  CMREFORD1 r where r.CMID=b.CMID and r.PROPID=26) then 1 else 0 end), b.DISABLED, case b.CLASSID when 39 then (select sched.TASKID from CMOBJPROPS2 sched where sched.CMID=b.CMID) when 111 then (p11.EVENTID) else NVL((select p2.OBJID from CMOBJPROPS1 p2 where p2.CMID=b.CMID), d.DISPATCHERPATH) end, (case when d.CREDNAMESPACES is null then 0 else 1 end) as HASCREDNAMESPACES, (case when p2.OLOCALEID is null then 0 else p2.OLOCALEID+65536*NVL(l.MAPDLOCALEID,0) end), NVL(p2.FORMAT, 255), (case when deploy.MESSAGE is null then 0 else 1 end), deploy.DEPLOYOBJUSAGE, (case when bo.RECIPSEMAIL is null then 0 else 1 end), sid.STOREID, b.OWNER, b.VERSION, b.TENANTID from CMOBJECTS b left outer join CMOBJPROPS6 d on b.CMID=d.CMID left outer join CMOBJPROPS11 p11 on b.CMID=p11.CMID left outer join CMOBJPROPS54 p2 on b.CMID=p2.CMID left outer join CMOBJPROPS25 deploy on b.CMID=deploy.CMID left outer join CMLOCALES l on l.LOCALEID=p2.OLOCALEID left outer join CMOBJPROPS14 bo on bo.CMID=b.CMID left outer join CMSTOREIDS sid on sid.CMID=b.CMID, CMPOLICIES p, CMOBJNAMES c where b.CMID=p.CMID and b.CMID=c.CMID order by b.CMID";
    static final String stmtCacheInitSelectInformix_IDBased = "select b.CMID, b.PCMID, c.NAME, c.LOCALEID + (case when c.ISDEFAULT=0 then 0 else 1 end) + NVL(c.MAPDLOCALEID, 0)*65536, b.CLASSID, '', (case when p.POLICIES is null then 0 else 1 end) as HASSECURITY, (case when exists(select * from  CMREFORD1 r where r.CMID=b.CMID and r.PROPID=26) then 1 else 0 end), b.DISABLED, case b.CLASSID when 39 then (select sched.TASKID from CMOBJPROPS2 sched where sched.CMID=b.CMID) when 111 then (p11.EVENTID) else NVL((select p2.OBJID from CMOBJPROPS1 p2 where p2.CMID=b.CMID), d.DISPATCHERPATH) end,(case when exists(select * from CMREFNOORD1 d1 where d1.CMID=b.CMID and d1.PROPID=9) then 1 else 0 end) as HASCREDNAMESPACES, (case when p2.OLOCALEID is null then 0 else p2.OLOCALEID+65536*NVL(l.MAPDLOCALEID,0) end), NVL(p2.FORMAT, 255), (case when deploy.MESSAGE is null then 0 else 1 end), deploy.DEPLOYOBJUSAGE, (case when bo.RECIPSEMAIL is null then 0 else 1 end), sid.STOREID, owner.REFCMID, b.VERSION, b.TENANTID from CMOBJECTS b left outer join CMOBJPROPS6 d on b.CMID=d.CMID left outer join CMOBJPROPS11 p11 on b.CMID=p11.CMID left outer join CMOBJPROPS54 p2 on b.CMID=p2.CMID left outer join CMOBJPROPS25 deploy on b.CMID=deploy.CMID left outer join CMLOCALES l on l.LOCALEID=p2.OLOCALEID left outer join CMOBJPROPS14 bo on bo.CMID=b.CMID left outer join CMSTOREIDS sid on sid.CMID=b.CMID left outer join CMREFNOORD2 owner on owner.CMID=b.CMID, CMPOLICIES p, CMOBJNAMES c where b.CMID=p.CMID and b.CMID=c.CMID order by b.CMID";

    @Override
    public String[] createCreateTemporaryTableSqls() {
        if (CMDbConnection.getDbmsInfo().getDbms() == 1 || CMDbConnection.getDbmsInfo().getDbms() == 4) {
            return new String[]{"create table #CMTMPIDS (QUERYID int not null, CMID int not null)", "create table #CMTMPCOPYIDS (QUERYID int not null, GROUPID int not null, SOURCECMID int not null, TARGETCMID int not null)"};
        }
        if (CMDbConnection.getDbmsInfo().getDbms() == 3) {
            if (CMDbConnection.getDbmsInfo().getDbmsSubtype() == 6) {
                return new String[]{"declare global temporary table CMTMPIDS (QUERYID int not null, CMID integer not null) on commit preserve rows", "declare global temporary table CMTMPCOPYIDS (QUERYID int not null, GROUPID int not null, SOURCECMID integer not null, TARGETCMID integer not null)on commit preserve rows"};
            }
            return new String[]{"declare global temporary table CMTMPIDS (QUERYID int not null, CMID integer not null) with replace on commit preserve rows not logged", "declare global temporary table CMTMPCOPYIDS (QUERYID int not null, GROUPID int not null, SOURCECMID integer not null, TARGETCMID integer not null) with replace on commit preserve rows not logged"};
        }
        if (CMDbConnection.getDbmsInfo().getDbms() == 5) {
            return new String[]{"declare global temporary table CMTMPIDS (QUERYID int not null, CMID integer not null) on commit preserve rows not logged", "declare global temporary table CMTMPCOPYIDS (QUERYID int not null, GROUPID int not null, SOURCECMID integer not null, TARGETCMID integer not null) on commit preserve rows not logged"};
        }
        if (CMDbConnection.getDbmsInfo().getDbms() == 8) {
            return new String[]{"create temp table CMTMPIDS (QUERYID integer not null, CMID integer not null)with no log", "create temp table CMTMPCOPYIDS (QUERYID integer not null, GROUPID integer not null, SOURCECMID integer not null, TARGETCMID integer not null)with no log"};
        }
        return new String[]{EMPTY_STRING, EMPTY_STRING};
    }

    @Override
    public String createInsertIntoCMTMPLOBSSql() {
        if (CMDbConnection.dbms_ == 2) {
            StringBuffer buffer = new StringBuffer();
            this.appendInsertIntoTable("CMTMPLOBS", buffer);
            this.appendColumnNames(new String[]{"LOBID", "TMPCLOB", "TMPBLOB"}, buffer);
            buffer.append(this.createClosingBracket());
            this.appendValuesForInsertIntoTable(buffer);
            buffer.append(this.createBindParameterSymbol());
            buffer.append(this.createColumnsSeparator());
            buffer.append(" empty_clob(), empty_blob()");
            buffer.append(this.createClosingBracket());
            return buffer.toString();
        }
        return EMPTY_STRING;
    }

    @Override
    public String createSelectFromCMTMPLOBSSql(int columnDbType) {
        return this.createSelectSql() + (columnDbType == 2004 ? "TMPBLOB" : "TMPCLOB") + this.createFromSql() + "CMTMPLOBS" + this.createWhereSql() + "LOBID" + this.createEqualsBindParameterSymbol();
    }

    @Override
    public String createFromSql() {
        return " from ";
    }

    @Override
    public String createSelectSql() {
        return "select ";
    }

    @Override
    public String createSelectForInsertSql() {
        return " select ";
    }

    @Override
    public String createWhereSql() {
        return " where ";
    }

    @Override
    public String createInSql() {
        return " in ";
    }

    @Override
    public String createInNoSpaceSql() {
        return " in";
    }

    @Override
    public String createNotInSql() {
        return " not in ";
    }

    @Override
    public String createNotExistsSql() {
        return " not exists ";
    }

    @Override
    public String createNotInNoSpaceSql() {
        return " not in";
    }

    @Override
    public String createAndSql() {
        return " and ";
    }

    @Override
    public String createOrSql() {
        return " or ";
    }

    @Override
    public String createOrderBySql() {
        return " order by ";
    }

    @Override
    public String createCount() {
        return " count";
    }

    @Override
    public String createAsSql() {
        return " as ";
    }

    @Override
    public String createDescSql() {
        return " DESC";
    }

    @Override
    public String createAscSql() {
        return " ASC";
    }

    @Override
    public String createStartCaseWhenSql() {
        return "(case when ";
    }

    @Override
    public String createEndCaseForBooleanSql() {
        return " then 1 else 0 end)";
    }

    @Override
    public String createExistsSelectFromSql() {
        return "exists(select * from ";
    }

    @Override
    public String createSelectCountInsteadOfExistsSql() {
        return "0 <> (select count(*) from ";
    }

    @Override
    public String createPlusSql() {
        return "+";
    }

    @Override
    public String createStartSumSql() {
        return "SUM(";
    }

    @Override
    public String createStartJsqllobSql() {
        return "jsqllob(";
    }

    @Override
    public String createJsqllobSeparator() {
        return ",";
    }

    @Override
    public String createSelectCMIDFromCMOBJECTSSql() {
        return "select CMID FROM CMOBJECTS";
    }

    @Override
    public String createUpperCastAsVarcharSql(int strLength) {
        if (CMDbConnection.dbms_ == 8) {
            return "upper(cast(? as lvarchar(" + strLength + ")))";
        }
        return "upper(cast(? as varchar(" + strLength + ")))";
    }

    @Override
    public void appendOrderByForNationalCharacters(StringBuffer buffer, StringBuffer orderByClause) {
        if (CMDbConnection.dbms_ == 2) {
            orderByClause.append("NLSSORT(");
            orderByClause.append(buffer);
            orderByClause.append(",'NLS_SORT=");
            orderByClause.append(AdvancedSettings.SORTCOLLATION);
            orderByClause.append("')");
        } else if (CMDbConnection.dbms_ == 1) {
            orderByClause.append(buffer);
            orderByClause.append(" COLLATE ");
            orderByClause.append(AdvancedSettings.SORTCOLLATION);
        } else {
            orderByClause.append(buffer);
        }
    }

    @Override
    public void appendEndCaseForColumnIsNotNullSql(String columnName, boolean storedAsLob, StringBuffer buffer) {
        if (CMDbConnection.dbms_ == 4 && storedAsLob) {
            buffer.append(" datalength(");
            buffer.append(columnName);
            buffer.append(") > 0 then 1 else 0 end)");
        } else {
            buffer.append(columnName);
            buffer.append(" is not NULL then 1 else 0 end)");
        }
    }

    @Override
    public void appendDeleteFromTableSql(String tableName, StringBuffer buffer) {
        buffer.append(this.createDeleteFromSql());
        buffer.append(tableName);
    }

    public String createDeleteFromSql() {
        return "delete from ";
    }

    @Override
    public String createUpdateFromTableSetSql(String tableName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("update ");
        buffer.append(tableName);
        buffer.append(" set ");
        return buffer.toString();
    }

    @Override
    public String createDeleteFromTableSql(String tableName) {
        StringBuffer buffer = new StringBuffer();
        this.appendDeleteFromTableSql(tableName, buffer);
        return buffer.toString();
    }

    @Override
    public String createIncrementVersionSql() {
        return " VERSION=(case when VERSION=2147483647 then 1 else VERSION+1 end)";
    }

    @Override
    public String createCacheInitSelectSql() {
        if (CMDbConnection.dbms_ == 4) {
            return stmtCacheInitSelectSybase_IDBased;
        }
        if (CMDbConnection.dbms_ == 5) {
            return stmtCacheInitSelectDerby_IDBased;
        }
        if (CMDbConnection.getDbmsInfo().getDbmsSubtype() == 6) {
            return stmtCacheInitSelectDB2zOS_IDBased;
        }
        if (CMDbConnection.getDbmsInfo().getDbmsSubtype() == 8) {
            return stmtCacheInitSelectInformix_IDBased;
        }
        return stmtCacheInitSelect_IDBased;
    }

    @Override
    public String createCacheInitClassTableSelectSql() {
        return "select CLASSID, NAME FROM CMCLASSES ORDER BY CLASSID";
    }

    @Override
    public String createCacheGetObjectsSql() {
        return "select b.CMID, b.PCMID, b.NAME, b.CLASSID, '', 0, 0, b.DISABLED from CMOBJECTS b, CMPOLICIES p WHERE b.CMID=p.CMID and p.POLICIES IS NULL AND b.CMID >= ? AND b.CMID <= ? UNION select b.CMID, b.PCMID, b.NAME, b.CLASSID, '', 1, 0, b.DISABLED from CMOBJECTS b, CMPOLICIES p WHERE b.CMID=p.CMID and p.POLICIES IS NOT NULL  AND b.CMID >= ? AND b.CMID <= ? ORDER BY b.CMID";
    }

    @Override
    public String createCacheGetChildrenSql() {
        return "select b.CMID, b.PCMID, b.NAME, b.CLASSID,'', 0, 0, b.DISABLED from CMOBJECTS b, CMPOLICIES p WHERE b.CMID=p.CMID and p.POLICIES IS NULL AND b.PCMID = ? UNION select b.CMID, b.PCMID, b.NAME, b.CLASSID, '', 1, 0, b.DISABLED from CMOBJECTS WHERE b.CMID=p.CMID and p.POLICIES IS NOT NULL AND b.PCMID = ? ORDER BY b.CMID";
    }

    @Override
    public String createGetPoliciesBeginSql() {
        return "select CMID, POLICIES from CMPOLICIES WHERE ";
    }

    @Override
    public String createGetPoliciesEndSql() {
        return " ORDER BY CMID";
    }

    @Override
    public String createGetPoliciesOfOneObjectSql() {
        return "select CMID, POLICIES from CMPOLICIES WHERE CMID IN (?)";
    }

    @Override
    public String createColumnsSeparator() {
        return ",";
    }

    @Override
    public String createLiteralsSeparator() {
        return ",";
    }

    @Override
    public String createOrderByColumnsSeparator() {
        return ", ";
    }

    @Override
    public String createBindParametersSeparator() {
        return ",";
    }

    @Override
    public String createBindParameterSymbol() {
        return "?";
    }

    @Override
    public String createAliasSeparator() {
        return ".";
    }

    @Override
    public String createStringLiteralSingleQuote() {
        return "'";
    }

    @Override
    public String createStartUpperSql() {
        return "upper(";
    }

    @Override
    public String createUpperBindParameterSql() {
        return "upper(?)";
    }

    @Override
    public String createIsNullExpression(String column, boolean bIsNull) {
        if (CMDbConnection.dbms_ == 4) {
            StringBuffer expr = new StringBuffer();
            expr.append("datalength(").append(column).append(")");
            if (bIsNull) {
                expr.append(" < 1 ");
            } else {
                expr.append(" > 0 ");
            }
            return expr.toString();
        }
        throw new IllegalStateException("unsupported for database types other then SYBASE");
    }

    @Override
    public void appendColumnDatalength(String columnName, StringBuffer buffer) {
        buffer.append(" datalength").append(this.createOpeningBracket()).append(columnName).append(this.createClosingBracket());
    }

    @Override
    public String createStartIsNullExpression(String columnName, boolean requiresSpecialIsNullHandling) {
        StringBuffer expr = new StringBuffer();
        if (requiresSpecialIsNullHandling) {
            this.appendColumnDatalength(columnName, expr);
        } else {
            expr.append(columnName);
        }
        return expr.toString();
    }

    @Override
    public String createEndIsNullExpression(boolean requiresSpecialIsNullHandling, boolean isNull) {
        StringBuffer expr = new StringBuffer();
        if (requiresSpecialIsNullHandling) {
            if (isNull) {
                expr.append(" = 0 ");
            } else {
                expr.append(" > 0 ");
            }
        } else {
            expr.append(" is ");
            if (!isNull) {
                expr.append("not ");
            }
            expr.append("null ");
        }
        return expr.toString();
    }

    @Override
    public void appendBindParametersSeparatorAndSymbol(StringBuffer buffer) {
        buffer.append(this.createBindParametersSeparator());
        buffer.append(this.createBindParameterSymbol());
    }

    @Override
    public void appendBindParametersSeparatorAndIntegerSymbol(StringBuffer buffer) {
        buffer.append(this.createBindParametersSeparator());
        if (CMDbConnection.dbms_ == 3 || CMDbConnection.dbms_ == 8) {
            buffer.append(this.createCastBindParameterAsInteger());
        } else {
            buffer.append(this.createBindParameterSymbol());
        }
    }

    @Override
    public void appendBindParameterSymbolWithCast(int columnDbType, int columnLength, boolean columnIsLob, StringBuffer parmList) {
        if (CMDbConnection.dbms_ == 3 || CMDbConnection.dbms_ == 8) {
            parmList.append(", cast(? as ");
            switch (columnDbType) {
                case 4: {
                    parmList.append("integer");
                    break;
                }
                case 5: {
                    parmList.append("smallint");
                    break;
                }
                case 12: {
                    if (CMDbConnection.dbms_ == 8) {
                        parmList.append("lvarchar(");
                    } else {
                        parmList.append("varchar(");
                    }
                    parmList.append(columnLength);
                    parmList.append(")");
                    break;
                }
                case -1: {
                    parmList.append("lvarchar(");
                    parmList.append(columnLength);
                    parmList.append(")");
                    break;
                }
                case 3: {
                    parmList.append("decimal(1, 0)");
                    break;
                }
                case 8: {
                    parmList.append("double");
                    break;
                }
                case 6: {
                    parmList.append("double");
                    break;
                }
                case 2005: {
                    if (CMDbConnection.dbms_ == 8) {
                        parmList.append("clob");
                        break;
                    }
                    parmList.append("clob(1G)");
                    break;
                }
                case 2004: {
                    if (CMDbConnection.dbms_ == 8) {
                        parmList.append("blob");
                        break;
                    }
                    parmList.append("blob(1G)");
                    break;
                }
                case 93: {
                    parmList.append("timestamp");
                }
            }
            parmList.append(")");
        } else if (CMDbConnection.dbms_ == 2 && CMDbConnection.getDbmsInfo().getIsThinDriver() && columnIsLob) {
            parmList.append(",(select " + (columnDbType == 2004 ? "TMPBLOB" : "TMPCLOB") + " from CMTMPLOBS where LOBID=?)");
        } else {
            parmList.append(",?");
        }
    }

    @Override
    public void appendColumnEqualsBindParameterSymbol(String columnName, StringBuffer buffer) {
        buffer.append(columnName);
        buffer.append(this.createEqualsBindParameterSymbol());
    }

    @Override
    public String createEqualsBindParameterSymbol() {
        return "=?";
    }

    @Override
    public String createEqualsSql() {
        return "=";
    }

    @Override
    public String createInsertIntoTableWithCMIDSql(String tableName) {
        StringBuffer buffer = new StringBuffer(500);
        this.appendInsertIntoTableWithCMID(tableName, buffer);
        return buffer.toString();
    }

    @Override
    public void appendInsertIntoTableWithCMID(String tableName, StringBuffer buffer) {
        this.appendInsertIntoTable(tableName, buffer);
        buffer.append("CMID");
    }

    @Override
    public void appendInsertIntoTable(String tableName, StringBuffer buffer) {
        buffer.append("insert into ");
        buffer.append(tableName);
        buffer.append(" (");
    }

    @Override
    public void appendColumnNames(String[] columnNames, StringBuffer buffer) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (i > 0) {
                buffer.append(this.createColumnsSeparator());
            }
            buffer.append(columnNames[i]);
        }
    }

    @Override
    public void appendValuesForInsertIntoTableWithCMID(StringBuffer buffer) {
        buffer.append(" values (?");
    }

    @Override
    public void appendValuesForInsertIntoTable(StringBuffer buffer) {
        buffer.append(" values (");
    }

    @Override
    public void appendEmptyLob(int lobColumnDbType, StringBuffer buffer) {
        buffer.append(lobColumnDbType == 2005 ? "empty_clob()" : "empty_blob()");
    }

    @Override
    public void appendCIColumn(String columnName, StringBuffer buffer) {
        buffer.append("CI_");
        buffer.append(columnName);
    }

    @Override
    public String createCopyPropertyTableSql(String tableName, String columns) {
        return this.createCopyTableSql(tableName, columns, false, false);
    }

    @Override
    public String createCopyTableSql(String tableName, String columns, boolean includePCMID, boolean includeTenantID) {
        StringBuffer buffer = new StringBuffer();
        this.appendInsertIntoTableWithCMID(tableName, buffer);
        buffer.append(this.createColumnsSeparator());
        if (includePCMID) {
            buffer.append("PCMID");
            buffer.append(this.createColumnsSeparator());
        }
        if (includeTenantID) {
            buffer.append("TENANTID");
            buffer.append(this.createColumnsSeparator());
        }
        buffer.append(columns);
        buffer.append(this.createClosingBracket());
        buffer.append(this.createSelectForInsertSql());
        if (CMDbConnection.dbms_ == 3 || CMDbConnection.dbms_ == 8) {
            buffer.append(this.createCastBindParameterAsInteger());
        } else {
            buffer.append(this.createBindParameterSymbol());
        }
        buffer.append(this.createBindParametersSeparator());
        if (includePCMID) {
            if (CMDbConnection.dbms_ == 3 || CMDbConnection.dbms_ == 8) {
                buffer.append(this.createCastBindParameterAsInteger());
            } else {
                buffer.append(this.createBindParameterSymbol());
            }
            buffer.append(this.createBindParametersSeparator());
        }
        if (includeTenantID) {
            if (CMDbConnection.dbms_ == 3 || CMDbConnection.dbms_ == 8) {
                buffer.append(this.createCastBindParameterAsInteger());
            } else {
                buffer.append(this.createBindParameterSymbol());
            }
            buffer.append(this.createBindParametersSeparator());
        }
        buffer.append(columns);
        buffer.append(this.createFromSql());
        buffer.append(tableName);
        buffer.append(this.createWhereSql());
        buffer.append("CMID");
        buffer.append(this.createEqualsBindParameterSymbol());
        return buffer.toString();
    }

    @Override
    public String createCastBindParameterAsInteger() {
        return "cast(? as integer)";
    }

    @Override
    public String createStartCastSql() {
        return "cast(";
    }

    @Override
    public String createDelStmtFragment(String tableName) {
        String s = AdvancedSettings.DBVENDORHINTSENABLED && CMDbConnection.dbms_ == 2 && CMDbConnection.getDbmsInfo().getDbmsVer() < 10 ? "delete /*+ ALL_ROWS INDEX(" + tableName + ")*/ from " + tableName : "delete from " + tableName;
        return s;
    }

    @Override
    public String createClosingBracket() {
        return ")";
    }

    @Override
    public String createOpeningBracket() {
        return "(";
    }

    @Override
    public String createCase1EqualsThenSql() {
        return "(case when 1=? then ";
    }

    @Override
    public String createElseNullEndSql() {
        return " else null end)";
    }

    @Override
    public String createValuesForInsertIntoCMOBJECTSSql() {
        return " values (?,?,?,?";
    }

    @Override
    public void appendNBindParameters(int parametersNumber, StringBuffer buffer) {
        for (int i = 0; i < parametersNumber; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append("?");
        }
    }

    @Override
    public String createCaseSelectCountFromSql() {
        return "(case when (select count(*) from ";
    }

    @Override
    public String createCaseExistsSelectFromSql() {
        return "(case when exists(select * from ";
    }

    @Override
    public String createExecProcedureWithNBindParameters(String procedureName, int parametersNumber) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("exec ");
        buffer.append(procedureName);
        buffer.append(" ");
        this.appendNBindParameters(parametersNumber, buffer);
        return buffer.toString();
    }

    @Override
    public int[] appendDefaultNamesTableUpdateMiddleSQLsForOneCMID(int iObjectInSQL, String localeIdSelectStmt, String localeIdWhereClause, StringBuffer insertSQL1, StringBuffer updateSQL1) {
        int numberOfCMIDsToBindUpdate = 0;
        int numberOfCMIDsToBindInsert = 0;
        if (iObjectInSQL > 0) {
            updateSQL1.append(" or ");
            insertSQL1.append(",");
        }
        updateSQL1.append("(CMID=?");
        ++numberOfCMIDsToBindUpdate;
        updateSQL1.append(" and LOCALEID=(");
        updateSQL1.append(localeIdSelectStmt);
        this.appendLocaleIdWhereClauseToUpdate(localeIdWhereClause, updateSQL1);
        updateSQL1.append("))");
        insertSQL1.append("?");
        int[] returnValues = new int[]{++numberOfCMIDsToBindInsert, ++numberOfCMIDsToBindUpdate};
        return returnValues;
    }

    private void appendLocaleIdWhereClauseToUpdate(String localeIdWhereClause, StringBuffer updateSQL) {
        if (localeIdWhereClause != null) {
            updateSQL.append(localeIdWhereClause);
            updateSQL.append(" and o.CMID=?");
        } else {
            updateSQL.append(" where o.CMID=?");
        }
    }

    @Override
    public String[] createDefaultNamesTableUpdateSQLs(String tableName, CMDbProperty prop, String value, String localeIdSelectStmt, String localeIdWhereClause) {
        StringBuffer insertSQL = new StringBuffer(1024);
        StringBuffer updateSQL = new StringBuffer(1024);
        StringBuffer parmList = new StringBuffer(1024);
        insertSQL.append("insert into " + tableName + " (CMID, LOCALEID ");
        parmList.append(",?,");
        updateSQL.append("update " + tableName + " set ");
        insertSQL.append(", ");
        insertSQL.append(prop.getColumn(1).getName());
        insertSQL.append(", ");
        insertSQL.append(prop.getColumn(2).getName());
        insertSQL.append(", ");
        insertSQL.append(prop.getColumn(3).getName());
        updateSQL.append(prop.getColumn(1).getName());
        updateSQL.append("=?");
        parmList.append("?,");
        if (CMDbConnection.getDbmsInfo().getDbmsReplaceExistsWithCount()) {
            parmList.append("(case when (select count(*) from ");
        } else {
            parmList.append("(case when exists(select * from ");
        }
        parmList.append(tableName);
        parmList.append(" ins where ins.");
        parmList.append(prop.getColumn(2).getName());
        if (CMDbConnection.getDbmsInfo().getDbmsReplaceExistsWithCount()) {
            parmList.append("=1 and ins.CMID=z.CMID)>0 then 0 else ? end),");
        } else {
            parmList.append("=1 and ins.CMID=z.CMID) then 0 else ? end),");
        }
        if (CMDbConnection.getDbmsInfo().getDbmsReplaceExistsWithCount()) {
            parmList.append("(case when (select count(*) from ");
        } else {
            parmList.append("(case when exists(select * from ");
        }
        parmList.append(tableName);
        parmList.append(" ins where ins.");
        parmList.append(prop.getColumn(3).getName());
        if (CMDbConnection.getDbmsInfo().getDbmsReplaceExistsWithCount()) {
            parmList.append("=? and ins.CMID=z.CMID)>0");
        } else {
            parmList.append("=? and ins.CMID=z.CMID)");
        }
        if (CMDbConnection.dbms_ == 5) {
            parmList.append(" then cast(null as smallint) else cast(? as smallint) end)");
        } else if (CMDbConnection.dbms_ == 4) {
            parmList.append(" then null else ? end)");
        } else {
            parmList.append(" then null else cast(? as smallint) end)");
        }
        updateSQL.append(" where (");
        insertSQL.append(") select CMID");
        insertSQL.append(parmList.toString());
        insertSQL.append(" from CMOBJECTS z where z.CMID in (");
        if (localeIdSelectStmt == null) {
            throw new IllegalStateException("localeIdSelectStmt couldn't be null");
        }
        StringBuffer insertSQLEnd = new StringBuffer(256);
        StringBuffer updateSQLEnd = new StringBuffer(100);
        updateSQLEnd.append(")");
        insertSQLEnd.append(")");
        String[] SQLs = new String[]{insertSQL.toString(), insertSQLEnd.toString(), updateSQL.toString(), updateSQLEnd.toString()};
        return SQLs;
    }

    @Override
    public String[] createDefaultLocalizedStringTableUpdateSQLs(String tableName, CMDbProperty prop, String value, String localeIdSelectStmt, String localeIdWhereClause) {
        StringBuffer insertSQL = new StringBuffer(1024);
        StringBuffer updateSQL = new StringBuffer(1024);
        StringBuffer parmList = new StringBuffer(1024);
        this.appendInsertAndParmListForLocalizedString(tableName, prop, insertSQL, parmList);
        updateSQL.append("update " + tableName + " set ");
        updateSQL.append(prop.getColumn(1).getName());
        updateSQL.append("=?");
        parmList.append("?,");
        if (CMDbConnection.getDbmsInfo().getDbmsReplaceExistsWithCount()) {
            parmList.append("(case when (select count(*) from ");
        } else {
            parmList.append("(case when exists(select * from ");
        }
        parmList.append(tableName);
        parmList.append(" ins where ins.");
        parmList.append(prop.getColumn(2).getName());
        parmList.append("=1");
        if (prop.isMultilingualRelated()) {
            parmList.append(" and ins.PROPNAME='");
            parmList.append(prop.getNameInTable());
            parmList.append("'");
        }
        if (CMDbConnection.getDbmsInfo().getDbmsReplaceExistsWithCount()) {
            parmList.append(" and ins.CMID=?)>0 then 0 else ? end),");
        } else {
            parmList.append(" and ins.CMID=z.CMID) then 0 else ? end),");
        }
        if (CMDbConnection.getDbmsInfo().getDbmsReplaceExistsWithCount()) {
            parmList.append("(case when (select count(*) from ");
        } else {
            parmList.append("(case when exists(select * from ");
        }
        parmList.append(tableName);
        parmList.append(" ins where ins.");
        parmList.append(prop.getColumn(3).getName());
        parmList.append("=?");
        if (prop.isMultilingualRelated()) {
            parmList.append(" and ins.PROPNAME='");
            parmList.append(prop.getNameInTable());
            parmList.append("'");
        }
        if (CMDbConnection.getDbmsInfo().getDbmsReplaceExistsWithCount()) {
            parmList.append(" and ins.CMID=?)>0");
        } else {
            parmList.append(" and ins.CMID=z.CMID)");
        }
        if (CMDbConnection.dbms_ == 5) {
            parmList.append(" then cast(null as smallint) else cast(? as smallint) end)");
        } else if (CMDbConnection.dbms_ == 4) {
            parmList.append(" then null else ? end)");
        } else {
            parmList.append(" then null else cast(? as smallint) end)");
        }
        updateSQL.append(" where ");
        if (CMDbConnection.dbms_ == 3 || CMDbConnection.dbms_ == 5 || CMDbConnection.dbms_ == 8) {
            insertSQL.append(") values (");
        } else {
            insertSQL.append(") select ");
        }
        insertSQL.append(parmList.toString());
        if (CMDbConnection.dbms_ == 3 || CMDbConnection.dbms_ == 5 || CMDbConnection.dbms_ == 8) {
            insertSQL.append(")");
        } else {
            insertSQL.append(" from CMOBJECTS z where z.CMID in (?)");
        }
        if (localeIdSelectStmt == null) {
            throw new IllegalStateException("localeIdSelectStmt couldn't be null");
        }
        updateSQL.append("(CMID=?");
        updateSQL.append(" and LOCALEID=(");
        updateSQL.append(localeIdSelectStmt);
        this.appendLocaleIdWhereClauseToUpdate(localeIdWhereClause, updateSQL);
        updateSQL.append(")");
        if (prop.isMultilingualRelated()) {
            updateSQL.append(" and PROPNAME='");
            updateSQL.append(prop.getNameInTable());
            updateSQL.append("'");
        }
        updateSQL.append(")");
        String[] SQLs = new String[]{insertSQL.toString(), updateSQL.toString(), parmList.toString()};
        return SQLs;
    }

    public void appendInsertAndParmListForLocalizedString(String tableName, CMDbProperty prop, StringBuffer insertSQL, StringBuffer parmList) {
        this.appendInsertIntoTableWithCMID(tableName, insertSQL);
        insertSQL.append(this.createColumnsSeparator());
        if (prop.isMultilingualRelated()) {
            insertSQL.append("PROPNAME");
            insertSQL.append(this.createColumnsSeparator());
            this.appendNBindParameters(3, parmList);
        } else {
            this.appendNBindParameters(2, parmList);
        }
        insertSQL.append("LOCALEID");
        parmList.append(this.createBindParametersSeparator());
        insertSQL.append(this.createColumnsSeparator());
        insertSQL.append(prop.getColumn(1).getName());
        insertSQL.append(this.createColumnsSeparator());
        insertSQL.append(prop.getColumn(2).getName());
        insertSQL.append(this.createColumnsSeparator());
        insertSQL.append(prop.getColumn(3).getName());
    }

    @Override
    public String createInsertMultipleLocalizedStringTableAddSql(String tableName, CMDbProperty property) {
        StringBuffer insertSQL = new StringBuffer(1024);
        StringBuffer parmList = new StringBuffer(1024);
        this.appendInsertAndParmListForLocalizedString(tableName, property, insertSQL, parmList);
        this.appendNBindParameters(3, parmList);
        insertSQL.append(") values (");
        insertSQL.append(parmList.toString());
        insertSQL.append(")");
        return insertSQL.toString();
    }

    @Override
    public String createInsertMultipleLocalizedStringTableUpdateSql(String tableName, CMDbProperty property) {
        StringBuffer insertSQL = new StringBuffer(1024);
        StringBuffer parmList = new StringBuffer(1024);
        if (tableName.equals("CMOBJNAMES")) {
            insertSQL.append("insert into " + tableName + " (CMID, LOCALEID");
            parmList.append(this.createBindParametersSeparator());
            if (CMDbConnection.dbms_ == 3 || CMDbConnection.dbms_ == 8) {
                this.appendCastBindParameterAsSmallint(parmList);
            } else {
                parmList.append(this.createBindParameterSymbol());
            }
        } else {
            insertSQL.append("insert into " + tableName + " (CMID, PROPNAME, LOCALEID");
            if (CMDbConnection.dbms_ == 3 || CMDbConnection.dbms_ == 8) {
                parmList.append(this.createBindParametersSeparator());
                this.appendCastBindParameterAsVarchar(50, parmList);
                parmList.append(this.createBindParametersSeparator());
                this.appendCastBindParameterAsSmallint(parmList);
            } else {
                parmList.append(this.createBindParametersSeparator());
                this.appendNBindParameters(2, parmList);
            }
        }
        int colLength = property.getColumn(1).getLength();
        insertSQL.append(", ");
        insertSQL.append(property.getColumn(1).getName());
        insertSQL.append(", ");
        insertSQL.append(property.getColumn(2).getName());
        insertSQL.append(", ");
        insertSQL.append(property.getColumn(3).getName());
        if (CMDbConnection.dbms_ == 3 || CMDbConnection.dbms_ == 8) {
            parmList.append(this.createBindParametersSeparator());
            this.appendCastBindParameterAsVarchar(colLength, parmList);
            parmList.append(this.createBindParametersSeparator());
            this.appendCastBindParameterAsDecimal(1, 0, parmList);
            parmList.append(this.createBindParametersSeparator());
            this.appendCastBindParameterAsSmallint(parmList);
        } else {
            parmList.append(this.createBindParametersSeparator());
            this.appendNBindParameters(3, parmList);
        }
        insertSQL.append(") select CMID");
        insertSQL.append(parmList.toString());
        insertSQL.append(" from CMOBJECTS where ");
        return insertSQL.toString();
    }

    @Override
    public void appendCastBindParameterAsVarchar(int colLength, StringBuffer buffer) {
        if (CMDbConnection.dbms_ == 3) {
            buffer.append("cast(? as varchar(" + colLength + "))");
        } else if (CMDbConnection.dbms_ == 8) {
            buffer.append("cast(? as lvarchar(" + colLength + "))");
        }
    }

    @Override
    public void appendCastBindParameterAsDecimal(int digits, int digitsAfterDecimalSeparator, StringBuffer buffer) {
        buffer.append("cast(? as decimal(" + digits + this.createDecimalDefinitionSeparator() + digitsAfterDecimalSeparator + "))");
    }

    public void appendCastBindParameterAsSmallint(StringBuffer buffer) {
        buffer.append("cast(? as smallint)");
    }

    @Override
    public String createDecimalDefinitionSeparator() {
        return ",";
    }

    @Override
    public void appendInsertMultipleLocalizedStringTableBatchUpdateBeginningSql(String tableName, StringBuffer updateSQL, StringBuffer insertSQL, StringBuffer parmList) {
        updateSQL.append("update " + tableName + " set ");
        insertSQL.append("insert into " + tableName + " (CMID, PROPNAME, LOCALEID ");
        parmList.append(" values (?, ?, ?");
    }

    @Override
    public void appendInsertMultipleLocalizedStringTableBatchUpdatePropertySql(CMDbProperty prop, StringBuffer updateSQL, StringBuffer insertSQL, StringBuffer parmList) {
        insertSQL.append(", ");
        insertSQL.append(prop.getColumn(1).getName());
        insertSQL.append(", ");
        insertSQL.append(prop.getColumn(2).getName());
        insertSQL.append(", ");
        insertSQL.append(prop.getColumn(3).getName());
        updateSQL.append(prop.getColumn(1).getName());
        updateSQL.append("=?,");
        updateSQL.append(prop.getColumn(2).getName());
        updateSQL.append("=?,");
        updateSQL.append(prop.getColumn(3).getName());
        updateSQL.append("=?");
        parmList.append(",?,?,?");
    }

    @Override
    public void appendInsertMultipleLocalizedStringTableBatchUpdateEndSql(StringBuffer updateSQL, StringBuffer insertSQL, StringBuffer parmList) {
        updateSQL.append(" where CMID=? and PROPNAME=? and LOCALEID=?");
        insertSQL.append(")");
        insertSQL.append(parmList);
        insertSQL.append(")");
    }

    @Override
    public String createMultipleLocalizedStringTableBatchUpdateAdditionToSetClause(CMDbProperty prop) {
        return prop.getColumn(1).getName() + "=NULL," + prop.getColumn(2).getName() + "=0, " + prop.getColumn(3).getName() + "=null ";
    }

    @Override
    public String createIsNullSql() {
        return " is null";
    }

    @Override
    public void appendUPPERColumn(String columnName, StringBuffer buffer) {
        buffer.append("UPPER(");
        buffer.append(columnName);
        buffer.append(")");
    }

    @Override
    public void appendUPPERBindParameter(StringBuffer buffer) {
        if (CMDbConnection.dbms_ == 3) {
            buffer.append("UPPER(cast(? as varchar(4000)))");
        } else if (CMDbConnection.dbms_ == 8) {
            buffer.append("UPPER(cast(? as lvarchar(4000)))");
        } else {
            buffer.append("UPPER(?)");
        }
    }

    @Override
    public void appendInsertIntoCMTMPIDS(String CMTMPIDSTableName, StringBuffer buffer) {
        this.appendInsertIntoTable(CMTMPIDSTableName, buffer);
        buffer.append("QUERYID, CMID) values (?, ?)");
    }

    @Override
    public void appendInsertIntoCMTMPCOPYIDS(String CMTMPCOPYIDSTableName, StringBuffer buffer) {
        this.appendInsertIntoTable(CMTMPCOPYIDSTableName, buffer);
        buffer.append("QUERYID, GROUPID, SOURCECMID, TARGETCMID) values (?, ?, ?, ?)");
    }

    @Override
    public void appendDeleteFromCMTMPCOPYIDSForTargetCMIDAndQueryID(String CMTMPCOPYIDSTableName, StringBuffer buffer) {
        buffer.append("delete from ");
        buffer.append(CMTMPCOPYIDSTableName);
        buffer.append(" where QUERYID=? and GROUPID < all (select MAX(GROUPID) from ");
        buffer.append(CMTMPCOPYIDSTableName);
        buffer.append(" c where c.TARGETCMID = TARGETCMID and c.QUERYID=? group by c.TARGETCMID)");
    }

    @Override
    public void appendDeleteFromCMTMPCOPYIDSByQueryID(String CMTMPCOPYIDSTableName, StringBuffer buffer) {
        buffer.append("delete from ");
        buffer.append(CMTMPCOPYIDSTableName);
        buffer.append(" where QUERYID=?");
    }

    @Override
    public void appendSelectJoinWithCMTMPCOPYIDSIn(String tableName, String CMTMPCOPYIDSTableName, String[] columnNames, StringBuffer buffer) {
        buffer.append(" select c.TARGETCMID,ct.TARGETCMID");
        for (int i = 0; i < columnNames.length; ++i) {
            buffer.append(",r.");
            buffer.append(columnNames[i]);
        }
        buffer.append(" from ");
        buffer.append(tableName);
        buffer.append(" r inner join ");
        buffer.append(CMTMPCOPYIDSTableName);
        buffer.append(" c on r.CMID=c.SOURCECMID and c.QUERYID=? and c.GROUPID=? ");
        buffer.append("inner join ");
        buffer.append(CMTMPCOPYIDSTableName);
        buffer.append(" ct on r.REFCMID=ct.SOURCECMID and ct.QUERYID=? and ct.GROUPID=?");
    }

    @Override
    public void appendSelectJoinWithCMTMPCOPYIDSNotIn(String tableName, String CMTMPCOPYIDSTableName, String[] columnNames, StringBuffer buffer) {
        buffer.append(" select c.TARGETCMID,r.REFCMID");
        for (int i = 0; i < columnNames.length; ++i) {
            buffer.append(",r.");
            buffer.append(columnNames[i]);
        }
        buffer.append(" from ");
        buffer.append(tableName);
        buffer.append(" r inner join ");
        buffer.append(CMTMPCOPYIDSTableName);
        buffer.append(" c on r.CMID=c.SOURCECMID and c.QUERYID=? and c.GROUPID=? ");
        buffer.append("where r.REFCMID not in (select SOURCECMID from ");
        buffer.append(CMTMPCOPYIDSTableName);
        buffer.append(" where QUERYID=? and GROUPID=?)");
    }

    @Override
    public String createInnerJoin() {
        return " inner join ";
    }

    @Override
    public void appendUpdateJoinWithCMTMPCOPYIDS(String tableName, String CMTMPCOPYIDSTableName, StringBuffer buffer) {
        buffer.append("update ");
        buffer.append(tableName);
        buffer.append(" set REFCMID=(select c.TARGETCMID from ");
        buffer.append(CMTMPCOPYIDSTableName);
        buffer.append("  c where c.QUERYID=? and ");
        buffer.append(tableName);
        buffer.append(".REFCMID=c.SOURCECMID)");
        buffer.append(" where CMID in (select TARGETCMID from ");
        buffer.append(CMTMPCOPYIDSTableName);
        buffer.append(" where QUERYID=?)");
        buffer.append(" and exists (select c.TARGETCMID from ");
        buffer.append(CMTMPCOPYIDSTableName);
        buffer.append(" c where c.QUERYID=? and ");
        buffer.append(tableName);
        buffer.append(".REFCMID=c.SOURCECMID )");
    }

    @Override
    public void appendSelectTARGETCMIDFromCMTMPCOPYIDSSql(String tableName, StringBuffer buffer) {
        buffer.append("(select TARGETCMID from ");
        buffer.append(tableName);
        buffer.append(" where QUERYID=? and GROUPID=?)");
    }

    @Override
    public String createOnSql() {
        return " on ";
    }

    @Override
    public String createDistinctSql() {
        return "DISTINCT ";
    }

    @Override
    public String createBasicLocaleComparePrefix(String columnName, String alias) {
        return this.createWhenSql() + alias + this.createAliasSeparator() + columnName + this.createEqualsSql();
    }

    @Override
    public String createWhenSql() {
        return " when ";
    }

    @Override
    public String createStartCaseSql() {
        return "(case ";
    }

    @Override
    public String createThenSql() {
        return " then ";
    }

    @Override
    public String createElseSql() {
        return " else ";
    }

    @Override
    public String createEndWithClosingBracketSql() {
        return " end)";
    }

    @Override
    public String createElseCastNullAsIntegerSql() {
        return " else cast(null as integer)";
    }

    @Override
    public String createStartCoalesceSql() {
        if (CMDbConnection.dbms_ == 8) {
            return "NVL(";
        }
        return "coalesce(";
    }

    @Override
    public String createNotEqualsSql() {
        return "!=";
    }

    @Override
    public String createLockInDbSql() {
        return "update CMOBJECTS set CMID=CMID where CMID in (select i.PCMID from CMOBJECTS i";
    }

    @Override
    public String createColumnWithAliasEqualsLiteralSql(String columnName, String alias, String literal) {
        StringBuffer buffer = new StringBuffer();
        this.appendColumnWithAliasEqualsLiteral(columnName, alias, literal, buffer);
        return buffer.toString();
    }

    @Override
    public void appendColumnWithAliasEqualsLiteral(String columnName, String alias, String literal, StringBuffer buffer) {
        this.appendColumnWithAlias(columnName, alias, buffer);
        buffer.append(this.createEqualsSql());
        buffer.append(literal);
    }

    @Override
    public void appendColumnWithAliasNotEqualsLiteral(String columnName, String alias, String literal, StringBuffer buffer) {
        this.appendColumnWithAlias(columnName, alias, buffer);
        buffer.append(this.createNotEqualsSql());
        buffer.append(literal);
    }

    @Override
    public String createColumnWithAliasSql(String columnName, String alias) {
        StringBuffer buffer = new StringBuffer();
        this.appendColumnWithAlias(columnName, alias, buffer);
        return buffer.toString();
    }

    @Override
    public String createColumnWithAliasIsNotNullSql(String columnName, String alias) {
        StringBuffer buffer = new StringBuffer();
        this.appendColumnWithAliasIsNotNull(columnName, alias, buffer);
        return buffer.toString();
    }

    @Override
    public void appendColumnWithAliasIsNotNull(String columnName, String alias, StringBuffer buffer) {
        this.appendColumnWithAlias(columnName, alias, buffer);
        buffer.append(" is not NULL");
    }

    @Override
    public void appendOnJoinColumns(String leftColumnName, String leftColumnAlias, String rightColumnName, String rightColumnAlias, StringBuffer buffer) {
        buffer.append(this.createOnSql());
        this.appendJoinColumnsWithAlias(leftColumnName, leftColumnAlias, rightColumnName, rightColumnAlias, buffer);
    }

    @Override
    public void appendJoinColumnsWithAlias(String leftColumnName, String leftColumnAlias, String rightColumnName, String rightColumnAlias, StringBuffer buffer) {
        this.appendColumnWithAlias(leftColumnName, leftColumnAlias, buffer);
        buffer.append(this.createEqualsSql());
        this.appendColumnWithAlias(rightColumnName, rightColumnAlias, buffer);
    }

    @Override
    public void appendColumnWithAlias(String columnName, String alias, StringBuffer buffer) {
        buffer.append(alias);
        buffer.append(this.createAliasSeparator());
        buffer.append(columnName);
    }

    @Override
    public String createLeftOuterJoinTableWithAliasSql(String tableName, String alias) {
        return " left outer join " + this.createTableWithAliasSql(tableName, alias);
    }

    @Override
    public String createInnerJoinTableWithAliasSql(String tableName, String alias) {
        return " inner join " + this.createTableWithAliasSql(tableName, alias);
    }

    @Override
    public String createJoinTableWithAliasSql(String tableName, String alias) {
        return ", " + this.createTableWithAliasSql(tableName, alias);
    }

    @Override
    public String createTableWithAliasSql(String tableName, String alias) {
        return tableName + " " + alias;
    }

    @Override
    public String createSelectAllClassCountsSql() {
        return "select  o.CLASSID, count(*) from CMOBJECTS o, CMCLASSES c group by o.CLASSID, c.CLASSID having c.CLASSID=o.CLASSID";
    }

    @Override
    public String createJoinWithTempTableForQueryIDConditionSql(boolean forIN, String QUERYIDColumnName, String alias) {
        StringBuffer buffer = new StringBuffer();
        if (!forIN) {
            buffer.append("!");
        }
        buffer.append(this.createEqualsSql());
        this.appendColumnWithAlias("CMID", alias, buffer);
        buffer.append(this.createAndSql());
        this.appendColumnWithAlias(QUERYIDColumnName, alias, buffer);
        buffer.append(this.createEqualsBindParameterSymbol());
        return buffer.toString();
    }

    @Override
    public String createTemporaryTablePrefix(int dbType) {
        String prefix = null;
        if (dbType == 1) {
            prefix = "#";
        } else if (dbType == 2 || dbType == 8) {
            prefix = EMPTY_STRING;
        } else if (dbType == 3 || dbType == 5) {
            prefix = "SESSION.";
        } else if (dbType == 4) {
            prefix = "#";
        } else {
            throw new IllegalStateException("The current database type is unknown and is preventing a massive query from occurring");
        }
        return prefix;
    }

    @Override
    public String createCMDBTESTInsertWithBindParameterSql() {
        return "insert into CMDBTEST (CMID, NAME) values (1, ?)";
    }

    @Override
    public String createCMDBTESTSelectWhereCMIDIs1Sql() {
        return "select NAME from CMDBTEST where CMID = 1";
    }

    @Override
    public String createCMDBTESTInsertWithUpperCaseLetterSql() {
        return "insert into CMDBTEST (CMID, NAME) values (1, 'A')";
    }

    @Override
    public String createCMDBTESTSelectWithLowerCaseLetterSql() {
        return "select CMID from CMDBTEST where NAME='a'";
    }

    @Override
    public String createDropTableSql(String tableName) {
        return "drop table " + tableName;
    }

    @Override
    public String createPurgeTableSql(String tableName) {
        return "purge table " + tableName;
    }

    @Override
    public String createSelectCountFromTableSql(String tableName) {
        return "select count(*) from " + tableName;
    }

    @Override
    public String createSelectColumnNamesFromTableSql(String[] columnNames, String tableName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.createSelectSql());
        this.appendColumnNames(columnNames, buffer);
        buffer.append(this.createFromSql());
        buffer.append(tableName);
        return buffer.toString();
    }

    @Override
    public String createInsertIntoTableValuesBindPatrametersSql(String[] columnNames, String tableName) {
        StringBuffer buffer = new StringBuffer();
        this.appendInsertIntoTable(tableName, buffer);
        this.appendColumnNames(columnNames, buffer);
        buffer.append(this.createClosingBracket());
        this.appendValuesForInsertIntoTable(buffer);
        this.appendNBindParameters(columnNames.length, buffer);
        buffer.append(this.createClosingBracket());
        return buffer.toString();
    }

    @Override
    public void appendCaseSensitiveBindParameterSymbolSql(boolean dbmsIsCaseSensitive, int dbType, StringBuilder buffer) {
        if (dbmsIsCaseSensitive) {
            if (dbType == 3) {
                buffer.append("UPPER(cast(? as varchar(4000)))");
            } else if (dbType == 8) {
                buffer.append("UPPER(cast(? as lvarchar(4000)))");
            } else {
                buffer.append("UPPER(?)");
            }
        } else {
            buffer.append("?");
        }
    }

    @Override
    public String createGroupBy() {
        return " group by ";
    }

    @Override
    public String[] createRecalculateMappedLocaleDefaultsSqls(String tableName, int dbType) {
        StringBuffer stmtStr = null;
        if (dbType == 1) {
            String[] SQLs = new String[2];
            SQLs[0] = "update " + tableName + " set MAPDLOCALEID=null from " + tableName + " a where a.MAPDLOCALEID is not null and a.MAPDLOCALEID <> (select b.MAPDLOCALEID from CMLOCALES b where a.LOCALEID=b.LOCALEID)";
            stmtStr = new StringBuffer();
            stmtStr.append("update ");
            stmtStr.append(tableName);
            stmtStr.append(" set MAPDLOCALEID=c.DMAPDLOCALEID from (SELECT TOP 100 PERCENT a.CMID as DCMID, b.MAPDLOCALEID as DMAPDLOCALEID, min(a.LOCALEID) as DLOCALEID from ");
            stmtStr.append(tableName);
            stmtStr.append(" a, CMLOCALES b where a.LOCALEID=b.LOCALEID and b.MAPDLOCALEID <> 0");
            if (!tableName.equals("CMOBJNAMES")) {
                stmtStr.append(" and a.VALUE is not null");
            }
            stmtStr.append(" and not exists(select * from ");
            stmtStr.append(tableName);
            stmtStr.append(" d where d.CMID=a.CMID and d.MAPDLOCALEID=b.MAPDLOCALEID");
            if (!tableName.equals("CMOBJNAMES")) {
                stmtStr.append(" and d.VALUE is not null");
            }
            stmtStr.append(") group by a.CMID, b.MAPDLOCALEID order by a.CMID, b.MAPDLOCALEID) c where LOCALEID=c.DLOCALEID and CMID=c.DCMID");
            SQLs[1] = stmtStr.toString();
            return SQLs;
        }
        if (dbType == 2) {
            String[] SQLs = new String[2];
            SQLs[0] = "update " + tableName + "_BASE a set a.MAPDLOCALEID=null where a.MAPDLOCALEID is not null and a.MAPDLOCALEID <> (select b.MAPDLOCALEID from CMLOCALES b where a.LOCALEID=b.LOCALEID)";
            stmtStr = new StringBuffer();
            stmtStr.append("update ");
            stmtStr.append(tableName);
            stmtStr.append("_BASE u set u.MAPDLOCALEID=(select b.MAPDLOCALEID from CMLOCALES b where u.LOCALEID=b.LOCALEID) where (u.CMID, u.LOCALEID) in (select a.CMID, min(a.LOCALEID) from ");
            stmtStr.append(tableName);
            stmtStr.append("_BASE a, CMLOCALES b where a.LOCALEID=b.LOCALEID");
            if (!tableName.equals("CMOBJNAMES")) {
                stmtStr.append(" and a.VALUE is not null");
            }
            stmtStr.append(" and b.MAPDLOCALEID <> 0 and not exists(select * from ");
            stmtStr.append(tableName);
            stmtStr.append("_BASE d where d.CMID=a.CMID and d.MAPDLOCALEID=b.MAPDLOCALEID");
            if (!tableName.equals("CMOBJNAMES")) {
                stmtStr.append(" and d.VALUE is not null");
            }
            stmtStr.append(") group by a.CMID, b.MAPDLOCALEID)");
            SQLs[1] = stmtStr.toString();
            return SQLs;
        }
        if (dbType == 3) {
            String[] SQLs = new String[2];
            SQLs[0] = "update " + tableName + " a set a.MAPDLOCALEID=null where a.MAPDLOCALEID is not null and a.MAPDLOCALEID <> (select b.MAPDLOCALEID from CMLOCALES b where a.LOCALEID=b.LOCALEID)";
            stmtStr = new StringBuffer();
            stmtStr.append("update ");
            stmtStr.append(tableName);
            stmtStr.append(" u set u.MAPDLOCALEID=(select b.MAPDLOCALEID from CMLOCALES b where u.LOCALEID=b.LOCALEID) where (u.CMID, u.LOCALEID) in (select a.CMID, min(a.LOCALEID) from ");
            stmtStr.append(tableName);
            stmtStr.append(" a, CMLOCALES b where a.LOCALEID=b.LOCALEID");
            if (!tableName.equals("CMOBJNAMES")) {
                stmtStr.append(" and a.VALUE is not null");
            }
            stmtStr.append(" and b.MAPDLOCALEID <> 0 and not exists(select * from ");
            stmtStr.append(tableName);
            stmtStr.append(" d where d.CMID=a.CMID and d.MAPDLOCALEID=b.MAPDLOCALEID");
            if (!tableName.equals("CMOBJNAMES")) {
                stmtStr.append(" and d.VALUE is not null");
            }
            stmtStr.append(") group by a.CMID, b.MAPDLOCALEID)");
            SQLs[1] = stmtStr.toString();
            return SQLs;
        }
        if (dbType == 5 || dbType == 4 || dbType == 8) {
            String[] SQLs = new String[3];
            String tempTablePrefix = this.createTemporaryTablePrefix(dbType);
            SQLs[0] = "update " + tableName + " set MAPDLOCALEID=null" + " where MAPDLOCALEID is not null and MAPDLOCALEID <> (select b.MAPDLOCALEID from CMLOCALES b where " + tableName + ".LOCALEID=b.LOCALEID)";
            stmtStr = new StringBuffer();
            stmtStr.append("insert into " + tempTablePrefix + "CMTMPLOCALEREMAP (CMID, MAPDLOCALEID, LOCALEID) select a.CMID, b.MAPDLOCALEID, min(a.LOCALEID) from ");
            stmtStr.append(tableName);
            stmtStr.append(" a, CMLOCALES b where a.LOCALEID=b.LOCALEID and b.MAPDLOCALEID <> 0");
            if (!tableName.equals("CMOBJNAMES")) {
                stmtStr.append(" and a.VALUE is not null");
            }
            stmtStr.append(" and not exists(select * from ");
            stmtStr.append(tableName);
            stmtStr.append(" d where d.CMID=a.CMID and d.MAPDLOCALEID=b.MAPDLOCALEID");
            if (!tableName.equals("CMOBJNAMES")) {
                stmtStr.append(" and d.VALUE is not null");
            }
            stmtStr.append(") group by a.CMID, b.MAPDLOCALEID");
            SQLs[1] = stmtStr.toString();
            stmtStr = new StringBuffer();
            stmtStr.append("update ");
            stmtStr.append(tableName);
            stmtStr.append(" set MAPDLOCALEID=(select t.MAPDLOCALEID from " + tempTablePrefix + "CMTMPLOCALEREMAP t where t.CMID=");
            stmtStr.append(tableName);
            stmtStr.append(".CMID and t.LOCALEID = ");
            stmtStr.append(tableName);
            stmtStr.append(".LOCALEID) where CMID in (select c.CMID from " + tempTablePrefix + "CMTMPLOCALEREMAP c where c.CMID = ");
            stmtStr.append(tableName);
            stmtStr.append(".CMID) and LOCALEID in (select d.LOCALEID from " + tempTablePrefix + "CMTMPLOCALEREMAP d where d.LOCALEID = ");
            stmtStr.append(tableName);
            stmtStr.append(".LOCALEID)");
            if (!tableName.equals("CMOBJNAMES")) {
                stmtStr.append(" and VALUE is not null");
            }
            SQLs[2] = stmtStr.toString();
            return SQLs;
        }
        return new String[0];
    }

    @Override
    public String createCreateCMTMPLOCALEREMAPSql(int dbType) {
        if (dbType == 5) {
            return "declare global temporary table CMTMPLOCALEREMAP (CMID int not null, MAPDLOCALEID smallint not null, LOCALEID smallint not null) on commit preserve rows not logged";
        }
        if (dbType == 4) {
            return "create table #CMTMPLOCALEREMAP (CMID int not null, MAPDLOCALEID smallint not null, LOCALEID smallint not null)";
        }
        if (dbType == 8) {
            return "create temp table CMTMPLOCALEREMAP (CMID int not null, MAPDLOCALEID smallint not null, LOCALEID smallint not null) with no log";
        }
        throw new IllegalStateException("unexpected dbType");
    }
}

