/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.archiving.ArchivalTempFileCache;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreTransactionAction;
import com.cognos.cm.dbstore.CMUserCapabilityPoliciesHandler;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheException;

public class CMDbStoreDelCacheObjects
implements CMDbStoreTransactionAction {
    CMDbStore store_;
    int[] objectsToDelete_;

    CMDbStoreDelCacheObjects(CMDbStore store, int[] objectsToDelete) {
        this.store_ = store;
        this.objectsToDelete_ = objectsToDelete;
    }

    @Override
    public void commit() {
        CMCache cache = this.store_.getCache();
        boolean[] deleted = new boolean[this.objectsToDelete_.length];
        boolean bDeleted = false;
        try {
            int numWithChildren;
            do {
                numWithChildren = 0;
                bDeleted = false;
                for (int i = 0; i < this.objectsToDelete_.length; ++i) {
                    if (!deleted[i] && !cache.CMCacheIsObjectValid(this.objectsToDelete_[i])) {
                        deleted[i] = true;
                        bDeleted = true;
                    }
                    if (deleted[i]) continue;
                    if (cache.CMCacheGetHasChildren(this.objectsToDelete_[i])) {
                        ++numWithChildren;
                        continue;
                    }
                    CMDbStoreFactory.policyCache_.remove(new Integer(this.objectsToDelete_[i]));
                    CMUserCapabilityPoliciesHandler.policyUpdated(new Integer(this.objectsToDelete_[i]), true);
                    CMDbStoreFactory.tempfileCache_.removeCachedFilesForObjectId(this.objectsToDelete_[i]);
                    ArchivalTempFileCache.get().removeCachedFilesForObjectId(this.objectsToDelete_[i]);
                    deleted[i] = true;
                    bDeleted = true;
                    cache.CMCacheDeleteObject(this.objectsToDelete_[i]);
                }
            } while (numWithChildren > 0 && bDeleted);
            if (numWithChildren > 0) {
                CMException cmex = new CMException("cmErrCommitDelete");
                CMIndications.logException(cmex);
            }
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException(e, "cmErrCommitDelete");
            CMIndications.logException(cmex);
        }
    }

    @Override
    public void rollback() {
    }
}

