/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStoreDataException;
import com.cognos.cm.store.CMStoreDeadlock;
import com.cognos.cm.store.CMStoreDuplicateObject;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreUnexpected;
import java.sql.SQLException;
import java.sql.Statement;

public class CMDbStoreExceptionUtil {
    public static void handleSQLException(ICMDbConnection con, SQLException ex, String unexpectedMsg) throws CMException {
        CMException exception = CMDbStoreExceptionUtil.analyzeSQLException(con, ex, unexpectedMsg);
        throw exception;
    }

    public static CMException analyzeSQLException(ICMDbConnection connection, SQLException ex, String unexpectedMsg) {
        String state;
        CMDbConnection con = (CMDbConnection)connection;
        if (CMIndications.logEnabled("Trace.CM.SQL", 40000)) {
            CMIndications.logException(new CMException("cmSQLConnectionException", new CMException.Parm("Exception", ex.getMessage()), new CMException.Parm("ConID", con == null ? "null" : Integer.toString(con.getID()))));
        }
        if (con != null) {
            try {
                con.rollbackTransaction();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (CMDbConnection.isDataProblem(ex)) {
            if (CMDbConnection.isStringTruncationProblem(ex)) {
                return new CMException(ex, "cmStringTruncationException");
            }
            return new CMStoreDataException(ex);
        }
        if (CMDbConnection.isConnectionProblem(ex)) {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return new CMStoreNotAvailable(ex);
        }
        String message = ex.getMessage();
        if (message == null) {
            message = "";
        }
        if ((state = ex.getSQLState()) == null) {
            state = "";
        }
        if (message.indexOf("SQL0911N") > -1 || CMDbConnection.dbms_ == 5 && (state.equals("40001") || message.indexOf("40001") > -1) || (CMDbConnection.dbms_ == 4 || CMDbConnection.dbms_ == 1) && state.equals("40001")) {
            return new CMStoreDeadlock(ex);
        }
        return new CMStoreUnexpected(ex, unexpectedMsg);
    }

    protected static void rollbackForNewObject(CMDbConnection con, String unexpectedMsg, int objectID, String objectSearchPath, String rollbackFailedMsg) throws CMException {
        if (objectID != -1) {
            Statement x = null;
            try {
                x = con.createStatement();
                CMDbConnection.executeUpdate(x, "delete from CMOBJNAMES where CMID=" + objectID);
                CMDbConnection.executeUpdate(x, "delete from CMOBJECTS where CMID=" + objectID);
            }
            catch (SQLException sqlEx) {
                CMException ex = CMDbStoreExceptionUtil.newDatabaseException(sqlEx, "rollbackForNewObject", "cmDatabaseRollback", objectID, objectSearchPath);
                con.setException(ex);
                throw ex;
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(x);
            }
        }
    }

    public static void handleSQLExceptionForNewObject(CMDbConnection con, SQLException ex, String unexpectedMsg, boolean bDoRollback, int objectID, String objectSearchPath, String rollbackFailedMsg) throws CMException {
        if (CMDbStoreExceptionUtil.isTriggerException(ex)) {
            CMDbStoreExceptionUtil.handleTriggerException(con, ex, unexpectedMsg, bDoRollback, objectID, objectSearchPath, rollbackFailedMsg);
        }
        if (CMDbConnection.isConstraintViolation(ex)) {
            CMDbStoreExceptionUtil.handleConstraintViolation(con, ex, unexpectedMsg, bDoRollback, objectID, objectSearchPath, rollbackFailedMsg);
        }
        CMDbStoreExceptionUtil.handleSQLException(con, ex, unexpectedMsg);
    }

    private static boolean isTriggerException(SQLException ex) {
        boolean isTriggerException = ex.getMessage().indexOf("ID_CMOBJECTS") >= 0 || CMDbConnection.dbms_ == 5 && ex.getSQLState().equals("38499");
        return isTriggerException;
    }

    private static void handleTriggerException(CMDbConnection con, SQLException ex, String unexpectedMsg, boolean bDoRollback, int objectID, String objectSearchPath, String rollbackFailedMsg) throws CMException {
        if (CMDbConnection.dbms_ == 5) {
            if (con.inTransaction()) {
                try {
                    con.getConnection().rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            con.discardOnReturnToPool();
        }
        if (bDoRollback) {
            CMDbStoreExceptionUtil.rollbackForNewObject(con, unexpectedMsg, objectID, objectSearchPath, rollbackFailedMsg);
        }
        throw new CMStoreDuplicateObject();
    }

    private static void handleConstraintViolation(CMDbConnection con, SQLException ex, String unexpectedMsg, boolean bDoRollback, int objectID, String objectSearchPath, String rollbackFailedMsg) throws CMException {
        if (bDoRollback) {
            CMDbStoreExceptionUtil.rollbackForNewObject(con, unexpectedMsg, objectID, objectSearchPath, rollbackFailedMsg);
        }
        if (!CMDbConnection.isDataProblem(ex)) {
            CMException dbEx = CMDbStoreExceptionUtil.newDatabaseException(ex, "handleSQLExceptionForNewObject", "cmDatabaseConstraintViolation", objectID, objectSearchPath);
            con.setException(dbEx);
            if (ex.toString().indexOf("FK_PARENT") != -1) {
                dbEx = new CMException("cmNoDelChild", new CMException.Parm("Path", objectSearchPath));
            }
            throw dbEx;
        }
    }

    private static CMException newDatabaseException(SQLException sqlEx, String methodName, String cmErrorCode, int objectID, String objectSearchPath) throws CMException {
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("MethodName", methodName), new CMException.Parm("ObjectID", Integer.toString(objectID))};
        CMException cmEx = sqlEx == null ? new CMException(cmErrorCode, parms) : new CMException((Exception)sqlEx, cmErrorCode, parms);
        return cmEx;
    }
}

