/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbConnectionParameters;
import com.cognos.cm.dbstore.CMDbConnectionPool;
import com.cognos.cm.dbstore.CMDbObjectClass;
import com.cognos.cm.dbstore.CMDbObjectClasses;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbPropertySet;
import com.cognos.cm.dbstore.CMDbPropertySets;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreAddDef;
import com.cognos.cm.dbstore.CMDbStoreConsistency;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStoreExecutor;
import com.cognos.cm.dbstore.CMDbStoreFactoryObserver;
import com.cognos.cm.dbstore.CMDbStoreMultipleCMsUtil;
import com.cognos.cm.dbstore.CMDbStoreNonObjectAddDef;
import com.cognos.cm.dbstore.CMDbStorePrepStmtCache;
import com.cognos.cm.dbstore.CMDbStoreScriptManager;
import com.cognos.cm.dbstore.CMDbStoreScriptParameters;
import com.cognos.cm.dbstore.CMDbStoreSysProperties;
import com.cognos.cm.dbstore.CMDbStoreTenantRegistry;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.CMDriverManager;
import com.cognos.cm.dbstore.CMObjectClassMapping;
import com.cognos.cm.dbstore.CMPropertyMapping;
import com.cognos.cm.dbstore.CMStoreMetadata;
import com.cognos.cm.dbstore.ICMDbConnectionParameters;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.dbstore.plugins.PluginFactory;
import com.cognos.cm.dbstore.properties.CMDbStoreArrayXMLValue;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.AdvancedSettingsObserver;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMFactory;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreConnectionProblemReporter;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.ObjectClassMapping;
import com.cognos.cm.store.PropertyMapping;
import com.cognos.cm.util.CMDeferredInitActionUtils;
import com.cognos.cm.util.CMMethodInvoker;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cm.util.CMTempFileLRUCache;
import com.cognos.cm.util.CMThreadPool;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cm.util.DOMUtils;
import com.cognos.cm.util.DOMWriter;
import com.cognos.cm.util.UrlUtils;
import com.cognos.cm.util.caching.CMCacheEntryScale;
import com.cognos.cm.util.caching.CMCacheFactory;
import com.cognos.cm.util.caching.CMObjectCache;
import com.cognos.cmutils.io.CMStreamUtils;
import com.cognos.cmutils.resource.CMResourceLoader;
import com.cognos.cmutils.tempcache.CMTempFileFactory;
import com.cognos.cmutils.values.CMInt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.jdbc.OracleConnection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CMDbStoreFactory {
    public static final String DB_VERSION = "7.7003";
    public static final double DB_UPGRADE_CUTOFF_VERSION = (double)0.9983f;
    public static final double DB_NEWLOCALE_VERSION = (double)0.89f;
    public static final double DB_INCONSISTENTHISTORY_START_VERSION = (double)2.0013f;
    public static final double DB_INCONSISTENTHISTORY_END_VERSION = (double)2.0038f;
    public static final double DB_OLD_BSE_START_VERSION = (double)3.0001f;
    public static final double DB_OLD_BSE_END_VERSION = (double)3.0037f;
    public static final String DB_BSE_MAJOR_VERSION = "4";
    private static final String CM_DERBY_FUNCTIONS_VERSION = "1.0001";
    public static final String PARM_STOREDIR = "CMStoreDir";
    public static final String PARM_VERSION = "CMStoreVersion";
    public static final String PARM_SERVER = "CMStoreServer";
    public static final String PARM_JDBCLOGFILE = "CMJDBCLogFile";
    public static final String PARM_DATAUPGRADEINPROGRESS = "CMDataUpgradeInProgress";
    public static final String PARM_INTERNALCONSISTENCY = "CMInternalConsistency";
    public static final String PARM_CONSISTENCYCHECKATUPG = "CMInternalConsistencyAtUpgrade";
    public static final String PARM_SCRIPTSTEPS = "CMScriptSteps";
    public static final String UPGRADEFILENAMEPREFIX = "dbupgrade";
    public static final String PARM_STOREUPGRADEHISTORY = "CMDbUpgradeHistory";
    public static final int LOCALEMAPPINGCHANGED = 2;
    public static final int LOCALESADDED = 1;
    public static final int LOCALESUNCHANGED = 0;
    public static CMDbPropertySets propertySets_;
    public static CMDbObjectClasses objectClasses_;
    public static final String baseTable_ = "CMOBJECTS";
    public static volatile boolean initedContentIndependentBeforeLock_;
    public static volatile boolean initedContentIndependentAfterLock_;
    public static volatile boolean initedContentDependent_;
    public static int dbInitializationState_;
    public static double versionBeforeUpgrade_;
    public static String storeDir_;
    public static CMObjectCache<Integer, byte[]> policyCache_;
    public static CMObjectCache<Integer, byte[]> userCapabilityPoliciesCache_;
    public static CMTempFileLRUCache tempfileCache_;
    public static CMThreadPool asyncDataReadThreadPool_;
    public static boolean bDatabaseEmpty_;
    private static CMStoreMetadata metadata_;
    public static PluginFactory pluginFactory_;
    private static CMDbStoreScriptManager scriptManager_;
    private static CMDbStoreScriptParameters scriptParameters_;
    private static CMStore staticStore;
    public static TenantRegistry tenantRegistry;
    static final String CMSCRIPT_SKIP_COMMAND = "CMSCRIPT_SKIP_COMMAND";
    static final String CMSCRIPT_UPGRADE_SKIP_COMMAND = "CMSCRIPT_UPGRADE_SKIP_COMMAND";
    static final String CMSCRIPT_SQL_COMMENT = "--";
    private static final String PROPIDDEF = "<property name='_propid' table='CMPROPERTIES' column='PROPID' type='xs:int'/>";
    private static final String PROPNAMEDEF = "<property name='_propname' table='CMPROPERTIES' column='NAME' type='xs:string'/>";
    private static final String PROPDEFDEF = "<property name='_propdef' table='CMPROPERTIES' column='DEF' type='xs:base64Binary'/>";
    private static final String CLASSIDDEF = "<property name='_classid' table='CMCLASSES' column='CLASSID' type='xs:int'/>";
    private static final String CLASSNAMEDEF = "<property name='_classname' table='CMCLASSES' column='NAME' type='xs:string'/>";
    private static final String CLASSUSAGEDEF = "<property name='_classusage' table='CMCLASSES' column='USAGE' type='xs:int'/>";
    private static final String CLASSDEFDEF = "<property name='_classdef' table='CMCLASSES' column='DEF' type='xs:base64Binary'/>";
    private static CMDbConnectionPool connectionPool_;
    private static boolean useCache_;
    private static HashMap<String, HashMap<String, HashMap<String, Object>>> schemaTablesAndColumns_;
    private static boolean schemaMayHaveChanged_;
    private static boolean includeSynonymsWithOracleConnection_;
    private static List<Double> upgradeHistory_;

    public static void setStaticStore(CMStore store) {
        staticStore = store;
    }

    public static synchronized CMDbStoreScriptManager getScriptManager() {
        if (scriptManager_ == null) {
            scriptManager_ = new CMDbStoreScriptManager(CMDbStoreFactory.getConfig().getSchemasDirectory());
        }
        return scriptManager_;
    }

    public static CMDbStoreScriptParameters getScriptParameters() {
        return scriptParameters_;
    }

    public static CMStore getStore() {
        CMStore store = staticStore != null ? staticStore : new CMDbStore(metadata_, pluginFactory_, tenantRegistry);
        return store;
    }

    public static String versionToFileNameVersion(String version) {
        int dotIndex = version.indexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        return version.substring(0, dotIndex) + "_" + version.substring(dotIndex + 1);
    }

    public static String versionFromFileNameVersion(String version) {
        int dotIndex = version.indexOf(95);
        if (dotIndex == -1) {
            return null;
        }
        return version.substring(0, dotIndex) + "." + version.substring(dotIndex + 1);
    }

    public static void createTenantRegistry() throws CMException {
        tenantRegistry = new CMDbStoreTenantRegistry();
    }

    private static int parseArg(String commandLine, int startPos, StringBuffer arg) throws CMException {
        int index;
        int maxPos = commandLine.length();
        char curChar = '\u0000';
        char quotChar = '\u0000';
        for (index = startPos; index < maxPos && ((curChar = commandLine.charAt(index)) == ' ' || curChar == '\t'); ++index) {
        }
        if (index < maxPos) {
            if (curChar == '\"' || curChar == '\'') {
                quotChar = curChar;
                startPos = ++index;
                arg.setLength(0);
                while (index < maxPos) {
                    curChar = commandLine.charAt(index);
                    if (curChar == quotChar && quotChar != '\u0000') {
                        arg.append(commandLine.substring(startPos, index));
                        startPos = index + 1;
                        if (startPos == maxPos || commandLine.charAt(startPos) != quotChar) break;
                    }
                    ++index;
                }
                if (index == maxPos) {
                    throw new CMConfigurationException("Mismatch quote in executor command line");
                }
                maxPos = index + 1;
            } else {
                startPos = index++;
                while (index < maxPos && (curChar = commandLine.charAt(index)) != ' ' && curChar != '\t') {
                    ++index;
                }
                maxPos = index;
                arg.replace(0, arg.length(), commandLine.substring(startPos, maxPos));
            }
        }
        return maxPos;
    }

    private static boolean executeScriptCommand(Connection con, String codeBase, String commandLine, String actionName) throws CMException, SQLException {
        CMDbStoreExecutor exec;
        char curChar;
        int index;
        String executorClassName = null;
        commandLine = commandLine.trim();
        ArrayList<String> args = new ArrayList<String>();
        for (index = 0; index < commandLine.length() && (curChar = commandLine.charAt(index)) != ' ' && curChar != '\t' && curChar != '\"'; ++index) {
        }
        executorClassName = commandLine.substring(0, index);
        int nextArgPos = index;
        while (nextArgPos < commandLine.length()) {
            StringBuffer arg = new StringBuffer();
            nextArgPos = CMDbStoreFactory.parseArg(commandLine, nextArgPos, arg);
            if (arg.length() <= 0) continue;
            args.add(arg.toString());
        }
        try {
            Class<?> executorClass = Class.forName(codeBase + "$" + executorClassName);
            exec = (CMDbStoreExecutor)executorClass.newInstance();
        }
        catch (Exception ex) {
            throw new CMConfigurationException((Throwable)ex, "Unable to load executor class");
        }
        return exec.execute(con, args.toArray(new String[args.size()]), actionName);
    }

    public static void executeScript(Connection con, File scriptFile, String codeBase, boolean ignoreErrors, boolean registerSteps, String newDbversion) throws CMConfigurationException {
        CMDbStoreFactory.executeScript(con, scriptFile, codeBase, ignoreErrors, registerSteps, newDbversion, 1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void executeScript(Connection con, File scriptFile, String codeBase, boolean ignoreErrors, boolean registerSteps, String newDbversion, int stepNumberToExecute, boolean executeTheRest) throws CMConfigurationException {
        BufferedReader script;
        Statement stmt;
        block45: {
            if (!scriptFile.exists()) {
                throw new CMConfigurationException("cmNoCMScriptFile", new CMException.Parm("FileName", scriptFile.getAbsolutePath()));
            }
            CMIndications.CMTrace("cmRunScript", new CMException.Parm("Script", scriptFile.getAbsolutePath()));
            boolean skipCommand = false;
            stmt = null;
            CallableStatement callstmt = null;
            CMDbConnection dbcon = null;
            try {
                dbcon = new CMDbConnection(con, true);
            }
            catch (SQLException ex) {
                throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
            }
            script = null;
            try {
                script = new BufferedReader(new InputStreamReader(new FileInputStream(scriptFile)));
                StringBuffer currentBatch = new StringBuffer();
                stmt = dbcon.createStatement();
                int stepNumber = 0;
                String lastScriptStepName = null;
                boolean lastStepCompleted = false;
                boolean eof = false;
                while (!eof) {
                    boolean stepCompleted;
                    block44: {
                        String currentLine = script.readLine();
                        if (currentLine == null) {
                            eof = true;
                            currentLine = "";
                        } else {
                            currentLine = currentLine.trim();
                        }
                        if (currentLine.length() > 0) {
                            boolean appendLine = true;
                            if (currentLine.indexOf(CMSCRIPT_SKIP_COMMAND) >= 0) {
                                skipCommand = true;
                            } else if (currentLine.indexOf(CMSCRIPT_UPGRADE_SKIP_COMMAND) >= 0) {
                                skipCommand = CMDbStoreFactory.skipCommandForThisUpgrade(currentLine);
                                appendLine = false;
                            } else if (currentLine.indexOf(CMSCRIPT_SQL_COMMENT) >= 0) {
                                appendLine = false;
                            }
                            currentLine = CMDbStoreFactory.getScriptParameters().replaceAllParameters(currentLine);
                            if (!appendLine) continue;
                            currentBatch.append(currentLine);
                            currentBatch.append("\n");
                            continue;
                        }
                        if (currentBatch.length() <= 0) continue;
                        String scriptStepName = null;
                        if (++stepNumber < stepNumberToExecute || skipCommand) {
                            currentBatch.setLength(0);
                            skipCommand = false;
                            continue;
                        }
                        if (registerSteps) {
                            scriptStepName = scriptFile.getName() + "+" + String.valueOf(stepNumber);
                            if (stepNumber == 1 || !lastStepCompleted) {
                                CMDbStoreUtil.storeScriptStepName(dbcon, scriptStepName);
                            } else {
                                CMDbStoreUtil.storeScriptStepNameReplacePrevious(dbcon, scriptStepName, lastScriptStepName);
                            }
                            lastScriptStepName = scriptStepName;
                        }
                        stepCompleted = false;
                        try {
                            int batchSize;
                            if (currentBatch.charAt(0) == '!') {
                                stepCompleted = CMDbStoreFactory.executeScriptCommand(con, codeBase, currentBatch.substring(1), scriptStepName);
                                break block44;
                            }
                            if (CMDbConnection.dbms_ == 2) {
                                int batchSize2 = currentBatch.length();
                                if (batchSize2 >= 2 && currentBatch.charAt(batchSize2 - 1) == '\n' && (currentBatch.charAt(batchSize2 - 2) == '/' || currentBatch.charAt(batchSize2 - 2) == ';')) {
                                    currentBatch.setLength(batchSize2 - 2);
                                }
                            } else if (CMDbConnection.dbms_ == 1 || CMDbConnection.dbms_ == 4) {
                                int batchSize3 = currentBatch.length();
                                if (batchSize3 >= 3 && currentBatch.substring(batchSize3 - 3).equalsIgnoreCase("GO\n")) {
                                    currentBatch.setLength(batchSize3 - 3);
                                }
                            } else if ((CMDbConnection.dbms_ == 5 || CMDbConnection.dbms_ == 3 && CMDbConnection.getDbmsInfo().getDbmsSubtype() == 6) && (batchSize = currentBatch.length()) >= 2 && currentBatch.charAt(batchSize - 1) == '\n' && currentBatch.charAt(batchSize - 2) == ';') {
                                currentBatch.setLength(batchSize - 2);
                            }
                            if (CMDbConnection.dbms_ == 2 && currentBatch.substring(0, 4).equalsIgnoreCase("exec")) {
                                currentBatch.replace(0, 4, "{call");
                                currentBatch.append("}");
                                callstmt = con.prepareCall(currentBatch.toString());
                                try {
                                    callstmt.execute();
                                }
                                finally {
                                    CMDbStoreUtil.safeCloseStatement(callstmt);
                                }
                            } else {
                                stmt.execute(currentBatch.toString());
                            }
                            stepCompleted = true;
                        }
                        catch (Exception e) {
                            if (ignoreErrors) break block44;
                            throw e;
                        }
                    }
                    lastStepCompleted = stepCompleted;
                    currentBatch.setLength(0);
                    skipCommand = false;
                    if (stepNumberToExecute != stepNumber || executeTheRest) continue;
                    eof = true;
                }
                if (!registerSteps) break block45;
                if (!lastStepCompleted && newDbversion != null) {
                    CMDbStoreUtil.updateDbversion(dbcon, newDbversion);
                    break block45;
                }
                if (lastStepCompleted && newDbversion != null) {
                    CMDbStoreUtil.deleteScriptStepNameUpdateDbversion(dbcon, newDbversion, lastScriptStepName);
                    break block45;
                }
                if (lastStepCompleted) {
                    CMDbStoreUtil.deleteScriptStepName(dbcon, lastScriptStepName);
                }
            }
            catch (CMConfigurationException ex) {
                try {
                    throw ex;
                    catch (Exception ex2) {
                        throw new CMConfigurationException((Throwable)ex2, "cmBadCMScript", new CMException.Parm("FileName", scriptFile.getAbsolutePath()));
                    }
                }
                catch (Throwable throwable) {
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    try {
                        if (script == null) throw throwable;
                        script.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        try {
            if (script != null) {
                script.close();
            }
        }
        catch (Exception currentLine) {}
        schemaMayHaveChanged_ = true;
    }

    private static String getDbScriptSuffix() {
        StringBuilder buf = new StringBuilder();
        String dbname = CMDbStoreFactory.getScriptManager().getDefaultDbScriptSuffix(CMDbConnection.getDbmsInfo());
        return buf.append('_').append(dbname.toLowerCase()).append(".sql").toString();
    }

    private static List<CMUpgradeFile> getUpgradeFiles() throws CMConfigurationException {
        double endVersion;
        double currentVersion;
        String startingVersion;
        String suffix;
        block5: {
            CMUpgradeFile next;
            suffix = CMDbStoreFactory.getDbScriptSuffix();
            startingVersion = CMDbStoreFactory.getConfig().getInternalProp(PARM_VERSION);
            currentVersion = Double.parseDouble(startingVersion);
            endVersion = Double.parseDouble(DB_VERSION);
            File scriptFolder = CMDbStoreFactory.getScriptManager().getScriptFolder(CMDbConnection.getDbmsInfo());
            ArrayList<CMUpgradeFile> upgradeFiles = new ArrayList<CMUpgradeFile>();
            for (String name : scriptFolder.list()) {
                String lcname = name.toLowerCase();
                if (!lcname.startsWith(UPGRADEFILENAMEPREFIX) || !lcname.endsWith(suffix)) continue;
                try {
                    double[] versions = CMUpgradeFile.getVersionFromTo(name);
                    if (!(versions[0] >= currentVersion) || !(versions[1] <= endVersion)) continue;
                    upgradeFiles.add(new CMUpgradeFile(name, versions[0], versions[1]));
                }
                catch (CMConfigurationException ignore) {
                    // empty catch block
                }
            }
            ArrayList<CMUpgradeFile> result = new ArrayList<CMUpgradeFile>();
            do {
                next = null;
                for (CMUpgradeFile file : upgradeFiles) {
                    if (file.fromVersionNumber_ != currentVersion || next != null && !(next.toVersionNumber_ < file.toVersionNumber_)) continue;
                    next = file;
                }
                if (next == null) break block5;
                result.add(next);
            } while ((currentVersion = next.toVersionNumber_) != endVersion);
            return result;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(UPGRADEFILENAMEPREFIX).append(currentVersion).append("-to-").append(endVersion).append(suffix);
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("OldSchemaVersion", startingVersion), new CMException.Parm("NewSchemaVersion", DB_VERSION), new CMException.Parm("FileName", buf.toString())};
        throw new CMConfigurationException("cmNoUpgradeScript", parms);
    }

    public static boolean isNameValid(String prefix, String suffix, String fileName) {
        return fileName.length() > prefix.length() + suffix.length() && fileName.toLowerCase().startsWith(prefix.toLowerCase()) && fileName.toLowerCase().endsWith(suffix.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void verifyDBConfigurationIsSupported(Connection con) throws CMConfigurationException, CMException {
        block47: {
            ICMDbStoreSqlGenerator sqlGenerator = null;
            boolean bTestTableExists = false;
            try {
                ResultSet rs;
                String sql;
                CMDbConnection dbConnection = new CMDbConnection(con, true);
                sqlGenerator = dbConnection.getSqlGenerator();
                if (!CMDbStoreFactory.isCMDBTESTCreated(con)) {
                    CMDbStoreFactory.executeScript(con, CMDbStoreFactory.getScriptManager().getScriptFile("dbInitTest", CMDbConnection.getDbmsInfo()), "com.cognos.cm.dbstore.CMDbStoreUpgrade", false, false, null);
                }
                bTestTableExists = true;
                Statement stmt = null;
                Statement tranStmt = null;
                PreparedStatement stmtPrep = null;
                try {
                    if (CMDbConnection.dbms_ == 4) {
                        tranStmt = con.createStatement();
                        tranStmt.execute("begin transaction");
                    } else {
                        con.setAutoCommit(false);
                    }
                    try {
                        try {
                            String dbString;
                            byte[] japaneseUTF8bytes = new byte[]{-27, -123, -79, -26, -100, -119, -29, -125, -107, -29, -126, -87, -29, -125, -85, -29, -125, -128};
                            String japaneseString = new String(japaneseUTF8bytes, "utf-8");
                            stmtPrep = con.prepareStatement(sqlGenerator.createCMDBTESTInsertWithBindParameterSql());
                            stmtPrep.setString(1, japaneseString);
                            CMDbConnection.executeUpdate(stmtPrep);
                            stmt = con.createStatement();
                            String sql2 = sqlGenerator.createCMDBTESTSelectWhereCMIDIs1Sql();
                            ResultSet rs2 = stmt.executeQuery(sql2);
                            if (rs2.next() && japaneseString.compareTo(dbString = rs2.getString(1)) != 0) {
                                CMException eCS = CMDbStoreFactory.logDBCharacterSetNames(con, 40000);
                                throw new CMConfigurationException((Throwable)eCS, "cmUnsupportedCharacterSet");
                            }
                        }
                        catch (UnsupportedEncodingException japaneseUTF8bytes) {
                        }
                        catch (SQLException ex) {
                            if (ex.getErrorCode() == -23103 && CMDbConnection.dbms_ == 8) {
                                CMException eCS = CMDbStoreFactory.logDBCharacterSetNames(con, 40000);
                                throw new CMConfigurationException((Throwable)eCS, "cmUnsupportedCharacterSet");
                            }
                            throw new SQLException(ex.toString());
                        }
                        if (!CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive()) {
                            CMDbConnection.executeUpdate(stmt, sqlGenerator.createCMDBTESTInsertWithUpperCaseLetterSql());
                            sql = sqlGenerator.createCMDBTESTSelectWithLowerCaseLetterSql();
                            rs = stmt.executeQuery(sql);
                            if (!rs.next()) {
                                CMException eCollation = CMDbStoreFactory.logDBCollationName(con, 40000);
                                throw new CMConfigurationException((Throwable)eCollation, "cmUnsupportedCaseSensitivity");
                            }
                        }
                    }
                    finally {
                        try {
                            con.rollback();
                            if (CMDbConnection.dbms_ != 4) {
                                con.setAutoCommit(true);
                            }
                        }
                        catch (SQLException ex) {
                            CMIndications.logException(new CMConfigurationException((Throwable)ex, "cmStoreUnexpected"));
                        }
                    }
                }
                catch (SQLException ex) {
                    throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
                }
                finally {
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    CMDbStoreUtil.safeCloseStatement(tranStmt);
                }
                if (CMDbConnection.dbms_ != 5 || CMDbConnection.getDbmsInfo().getIsEmdeddedDerbyCS()) break block47;
                try {
                    stmt = con.createStatement();
                    sql = "values CM_GETDERBYFUNCTIONSVERSION()";
                    rs = stmt.executeQuery("values CM_GETDERBYFUNCTIONSVERSION()");
                    if (rs.next()) {
                        String serverFunctionVers = rs.getString(1);
                        if (!serverFunctionVers.equalsIgnoreCase(CM_DERBY_FUNCTIONS_VERSION)) {
                            throw new CMConfigurationException("cmWrongDerbyFuncVer", new CMException.Parm[]{new CMException.Parm("Version", CM_DERBY_FUNCTIONS_VERSION)});
                        }
                        break block47;
                    }
                    throw new CMConfigurationException("cmDerbyFuncVersionMissing");
                }
                catch (SQLException ex) {
                    if (ex.getSQLState().equalsIgnoreCase("42X51")) {
                        throw new CMConfigurationException((Throwable)ex, "cmDerbyFuncNotInstalled");
                    }
                    throw new CMConfigurationException((Throwable)ex, "cmErrVerifyDBConfiguration");
                }
                finally {
                    CMDbStoreUtil.safeCloseStatement(stmt);
                }
            }
            catch (SQLException ex) {
                throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
            }
            finally {
                if (bTestTableExists && sqlGenerator != null) {
                    Statement dropStmt;
                    block48: {
                        dropStmt = null;
                        try {
                            String dropSQL = sqlGenerator.createDropTableSql("CMDBTEST");
                            dropStmt = con.createStatement();
                            dropStmt.execute(dropSQL);
                            if (CMDbConnection.dbms_ == 2) {
                                dropStmt.execute(sqlGenerator.createPurgeTableSql("CMDBTEST"));
                            }
                            CMDbStoreUtil.safeCloseStatement(dropStmt);
                            dropStmt = null;
                            if (CMDbConnection.dbms_ != 5) break block48;
                            dropSQL = "drop function CM_GETDERBYFUNCTIONSVERSION";
                            dropStmt = con.createStatement();
                            dropStmt.execute(dropSQL);
                        }
                        catch (SQLException sQLException) {
                            CMDbStoreUtil.safeCloseStatement(dropStmt);
                            catch (Throwable throwable) {
                                CMDbStoreUtil.safeCloseStatement(dropStmt);
                                throw throwable;
                            }
                        }
                    }
                    CMDbStoreUtil.safeCloseStatement(dropStmt);
                }
            }
        }
    }

    private static void upgradeDatabase(CMDbConnection con) throws CMConfigurationException {
        CMUpgradeFile upgradeFile;
        String currentVersion = CMDbStoreFactory.getConfig().getInternalProp(PARM_VERSION);
        double currentVersionNumber = 0.0;
        double endVersionNumber = 0.0;
        try {
            currentVersionNumber = Double.parseDouble(currentVersion);
            endVersionNumber = Double.parseDouble(DB_VERSION);
        }
        catch (NumberFormatException ex) {
            throw new CMConfigurationException("cmNoVersion");
        }
        CMDbStoreFactory.initializeUpgradeHistory(con, currentVersionNumber);
        int startFirstUpgradeScriptWithStepNumber = -1;
        List<CMScriptStep> scriptSteps = CMDbStoreFactory.getConfig().getList(PARM_SCRIPTSTEPS);
        if (scriptSteps != null) {
            CMDbStoreFactory.sortScriptSteps(scriptSteps);
            for (int i = 0; i < scriptSteps.size(); ++i) {
                CMScriptStep scriptStep = scriptSteps.get(i);
                if (scriptStep.scriptFileName_ == null || !scriptStep.scriptFileName_.toLowerCase().startsWith(UPGRADEFILENAMEPREFIX)) continue;
                if (scriptStep.stepNumber_ <= 0) {
                    throw new CMConfigurationException("cmNoVersion");
                }
                upgradeFile = new CMUpgradeFile(scriptStep.scriptFileName_, scriptStep.fromVersionNumber_, scriptStep.toVersionNumber_);
                if (upgradeFile.fromVersionNumber_ < currentVersionNumber) {
                    CMDbStoreFactory.executeScript(con.getConnection(), upgradeFile.file_, "com.cognos.cm.dbstore.CMDbStoreUpgrade", false, true, null, scriptStep.stepNumber_, false);
                    continue;
                }
                if (upgradeFile.fromVersionNumber_ != currentVersionNumber) continue;
                if (startFirstUpgradeScriptWithStepNumber > 0 || currentVersionNumber == endVersionNumber) {
                    CMDbStoreFactory.executeScript(con.getConnection(), upgradeFile.file_, "com.cognos.cm.dbstore.CMDbStoreUpgrade", false, true, null, startFirstUpgradeScriptWithStepNumber, false);
                }
                startFirstUpgradeScriptWithStepNumber = scriptStep.stepNumber_;
            }
        }
        if (currentVersionNumber < endVersionNumber) {
            List<CMUpgradeFile> upgradeFiles = CMDbStoreFactory.getUpgradeFiles();
            for (int i = 0; i < upgradeFiles.size(); ++i) {
                upgradeFile = upgradeFiles.get(i);
                if (upgradeFile.fromVersionNumber_ == currentVersionNumber && startFirstUpgradeScriptWithStepNumber > 0) {
                    CMDbStoreFactory.executeScript(con.getConnection(), upgradeFile.file_, "com.cognos.cm.dbstore.CMDbStoreUpgrade", false, true, String.valueOf(upgradeFile.toVersionNumber_), startFirstUpgradeScriptWithStepNumber, true);
                } else {
                    CMDbStoreFactory.executeScript(con.getConnection(), upgradeFile.file_, "com.cognos.cm.dbstore.CMDbStoreUpgrade", false, true, String.valueOf(upgradeFile.toVersionNumber_));
                }
                CMDbStoreFactory.updateUpgradeHistory(upgradeFile.toVersionNumber_);
            }
        }
        CMDbStoreFactory.clearUpgradeHistory();
        CMDbStoreFactory.loadCMMetadataIntoDb(con);
        if (dbInitializationState_ != 1) {
            dbInitializationState_ = 2;
        }
    }

    public static boolean databaseRequiresUpgrade() throws CMConfigurationException {
        String dbVersion = CMDbStoreFactory.getConfig().getInternalProp(PARM_VERSION);
        if (dbVersion == null) {
            throw new CMConfigurationException("cmVersionMissing", new CMException.Parm("Version", PARM_VERSION));
        }
        try {
            versionBeforeUpgrade_ = Double.parseDouble(dbVersion);
            double requiredVersion = Double.parseDouble(DB_VERSION);
            if (versionBeforeUpgrade_ < (double)0.9983f) {
                throw new CMConfigurationException("cmBadVersion", new CMException.Parm[]{new CMException.Parm("CurrentVersion", Double.toString(versionBeforeUpgrade_)), new CMException.Parm("Version", DB_VERSION)});
            }
            if (versionBeforeUpgrade_ > requiredVersion) {
                throw new CMConfigurationException("cmBadVersion", new CMException.Parm[]{new CMException.Parm("CurrentVersion", Double.toString(versionBeforeUpgrade_)), new CMException.Parm("Version", DB_VERSION)});
            }
            if (versionBeforeUpgrade_ < requiredVersion) {
                return true;
            }
            return CMDbStoreFactory.hasPreviousUpgradeSteps();
        }
        catch (NumberFormatException ex) {
            throw new CMConfigurationException("cmNoVersion");
        }
    }

    private static IConfiguration getConfig() {
        return ConfigurationFactory.getConfig();
    }

    private static boolean hasPreviousUpgradeSteps() {
        List<?> scriptSteps = CMDbStoreFactory.getConfig().getList(PARM_SCRIPTSTEPS);
        return scriptSteps != null & scriptSteps.size() > 0;
    }

    public static boolean dbMajorUpgradeRequired() throws CMConfigurationException {
        if (versionBeforeUpgrade_ == 0.0) {
            throw new CMConfigurationException("cmVersionMissing", new CMException.Parm("Version", PARM_VERSION));
        }
        return CMDbStoreFactory.compareMajorDBVersions(new Double(versionBeforeUpgrade_).intValue());
    }

    private static boolean databaseRequiresMajorUpgrade() throws CMConfigurationException {
        String dbVersion = CMDbStoreFactory.getConfig().getInternalProp(PARM_VERSION);
        if (dbVersion == null) {
            throw new CMConfigurationException("cmVersionMissing", new CMException.Parm("Version", PARM_VERSION));
        }
        return CMDbStoreFactory.compareMajorDBVersions(Double.valueOf(dbVersion).intValue());
    }

    private static boolean compareMajorDBVersions(int majorVersBeforeUpgrade) throws CMConfigurationException {
        try {
            int requiredMajorVersion = Double.valueOf(DB_VERSION).intValue();
            if (majorVersBeforeUpgrade > requiredMajorVersion) {
                throw new CMConfigurationException("cmBadVersion", new CMException.Parm[]{new CMException.Parm("CurrentVersion", Double.toString(majorVersBeforeUpgrade)), new CMException.Parm("Version", DB_VERSION)});
            }
            return majorVersBeforeUpgrade < requiredMajorVersion;
        }
        catch (NumberFormatException ex) {
            throw new CMConfigurationException("cmNoVersion");
        }
    }

    private static boolean isDatabaseEmpty(Connection con) throws CMConfigurationException {
        boolean bl;
        Statement stmt;
        ResultSet rs;
        block11: {
            int defaultIsolationLevel;
            block10: {
                ICMDbStoreSqlGenerator sqlGenerator;
                block9: {
                    rs = null;
                    stmt = null;
                    sqlGenerator = null;
                    CMDbConnection dbConnection = new CMDbConnection(con, true);
                    sqlGenerator = dbConnection.getSqlGenerator();
                    DatabaseMetaData dbInfo = con.getMetaData();
                    rs = CMDbConnection.getDbmsInfo().getNamesAreInLowerCase() ? dbInfo.getTables(null, CMDbConnection.getDbmsInfo().getDbSchema(), "cmobjects", null) : dbInfo.getTables(null, CMDbConnection.getDbmsInfo().getDbSchema(), baseTable_, null);
                    if (rs.next()) break block9;
                    boolean bl2 = true;
                    CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    return bl2;
                }
                rs.close();
                defaultIsolationLevel = con.getTransactionIsolation();
                if (CMDbConnection.getDbmsInfo().getDbms() != 2) {
                    con.setTransactionIsolation(1);
                }
                if ((rs = (stmt = con.createStatement()).executeQuery(sqlGenerator.createSelectCountFromTableSql(baseTable_))).next()) break block10;
                boolean bl3 = true;
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
                CMDbStoreUtil.safeCloseStatement(stmt);
                return bl3;
            }
            int count = rs.getInt(1);
            rs.close();
            if (CMDbConnection.getDbmsInfo().getDbms() != 2) {
                con.setTransactionIsolation(defaultIsolationLevel);
            }
            if (count != 0) break block11;
            boolean bl4 = true;
            CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
            CMDbStoreUtil.safeCloseStatement(stmt);
            return bl4;
        }
        try {
            bl = false;
        }
        catch (SQLException ex) {
            try {
                throw new CMConfigurationException((Throwable)ex, "cmErrInitialized");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
                CMDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
        CMDbStoreUtil.safeCloseStatement(stmt);
        return bl;
    }

    private static boolean hasDatabaseCreationFailedPreviously(Connection con) throws CMConfigurationException {
        boolean bl;
        ResultSet rs = null;
        Statement stmt = null;
        ICMDbStoreSqlGenerator sqlGenerator = null;
        try {
            CMDbConnection dbConnection = new CMDbConnection(con, true);
            sqlGenerator = dbConnection.getSqlGenerator();
            DatabaseMetaData dbInfo = con.getMetaData();
            rs = CMDbConnection.getDbmsInfo().getNamesAreInLowerCase() ? dbInfo.getTables(null, CMDbConnection.getDbmsInfo().getDbSchema(), "cmsysprops", null) : dbInfo.getTables(null, CMDbConnection.getDbmsInfo().getDbSchema(), "CMSYSPROPS", null);
            if (!rs.next()) {
                boolean bl2 = false;
                return bl2;
            }
            rs.close();
            rs = CMDbConnection.getDbmsInfo().getNamesAreInLowerCase() ? dbInfo.getTables(null, CMDbConnection.getDbmsInfo().getDbSchema(), "cmobjects", null) : dbInfo.getTables(null, CMDbConnection.getDbmsInfo().getDbSchema(), baseTable_, null);
            if (!rs.next()) {
                boolean bl3 = true;
                return bl3;
            }
            rs.close();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sqlGenerator.createSelectColumnNamesFromTableSql(new String[]{"PROPNAME"}, "CMSYSPROPS"));
            while (rs.next()) {
                String parmName = rs.getString(1);
                if (parmName.indexOf("dbInit") <= -1) continue;
                boolean bl4 = true;
                CMDbStoreUtil.safeCloseStatement(stmt);
                return bl4;
            }
            bl = false;
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        catch (SQLException ex) {
            throw new CMConfigurationException((Throwable)ex, "cmErrInitialized");
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        return bl;
    }

    private static boolean isCMDBTESTCreated(Connection con) throws CMConfigurationException {
        boolean bl;
        ResultSet rs;
        block5: {
            rs = null;
            DatabaseMetaData dbInfo = con.getMetaData();
            rs = CMDbConnection.getDbmsInfo().getNamesAreInLowerCase() ? dbInfo.getTables(null, CMDbConnection.getDbmsInfo().getDbSchema(), "cmdbtest", null) : dbInfo.getTables(null, CMDbConnection.getDbmsInfo().getDbSchema(), "CMDBTEST", null);
            if (rs.next()) break block5;
            boolean bl2 = false;
            CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (SQLException ex) {
            try {
                throw new CMConfigurationException((Throwable)ex, "cmErrVerifyDBConfiguration");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
        return bl;
    }

    public static void createRootObject() throws CMException {
        CMDbConnection con = ((CMDbStore)CMExecutionContext.get().getStore()).getConnection();
        try {
            int i;
            con.beginTransaction();
            CMDbStoreAddDef[] addDefs = ((CMDbObjectClass)CMObjectClass.ROOT).getAddDefs(0);
            CMDbProperty nameProp = (CMDbProperty)CMProperty.NAME;
            CMDbProperty storeIdProp = (CMDbProperty)CMProperty.STOREID;
            String namePropTable = nameProp.getColumn(0).getTable();
            String storeIdPropTable = storeIdProp.getColumn(0).getTable();
            boolean nameAdded = false;
            boolean storeIdAdded = false;
            for (i = 0; i != addDefs.length; ++i) {
                if (!nameAdded && addDefs[i].getTableName().equals(namePropTable)) {
                    CMDbStoreLocalizedStringArray rootNames = new CMDbStoreLocalizedStringArray();
                    CMDbStoreLocalizedString rootName = new CMDbStoreLocalizedString(CMDbStoreStringLocales.findLocale(CMDbStoreFactory.getConfig().getServerLocale().toString()), "/");
                    rootNames.add(rootName);
                    addDefs[i].addColumn(nameProp, rootNames);
                    if (storeIdAdded) break;
                    nameAdded = true;
                    continue;
                }
                if (!addDefs[i].getTableName().equals(storeIdPropTable)) continue;
                addDefs[i].addColumn(storeIdProp, CMDbStore.generateStoreId());
                if (nameAdded) break;
                storeIdAdded = true;
            }
            for (i = 0; i != addDefs.length; ++i) {
                addDefs[i].execute(con, 0);
            }
            con.commitTransaction();
        }
        catch (SQLException ex) {
            CMException e = CMDbStoreExceptionUtil.analyzeSQLException(con, ex, "cmErrAddRoot");
            if (e instanceof CMStoreNotAvailable) {
                throw e;
            }
            throw new CMConfigurationException((Throwable)ex, "cmErrAddRoot");
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void upgradeRootObject(CMDbConnection con) throws CMStoreNotAvailable, CMConfigurationException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("select count(*) from CMOBJPROPS1 where CMID=0");
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            if (count == 0) {
                con.beginTransaction();
                CMDbStoreAddDef[] addDefs = ((CMDbObjectClass)CMObjectClass.ROOT).getAddDefs(0);
                for (int i = 1; i < addDefs.length; ++i) {
                    addDefs[i].execute(con, 0);
                }
                con.commitTransaction();
            }
        }
        catch (SQLException ex) {
            CMException e = CMDbStoreExceptionUtil.analyzeSQLException(con, ex, "cmErrAddRoot");
            if (e instanceof CMStoreNotAvailable) {
                throw (CMStoreNotAvailable)e;
            }
            throw new CMConfigurationException((Throwable)ex, "cmErrAddRoot");
        }
        catch (CMException ex) {
            throw new CMConfigurationException((Throwable)ex, "cmErrAddRoot");
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
    }

    static void recalculateMappedLocaleDefaults(CMDbConnection con) throws CMConfigurationException {
        Statement stmt = null;
        List<String> multilingualPropTables = CMDbProperty.getMultilingualPropTables();
        int dbType = con.getDbms();
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        try {
            stmt = con.createStatement();
            if (dbType == 1) {
                con.beginTransaction();
                for (int i = 0; i < multilingualPropTables.size(); ++i) {
                    String tableName = multilingualPropTables.get(i).toString();
                    String[] SQLs = sqlGenerator.createRecalculateMappedLocaleDefaultsSqls(tableName, dbType);
                    for (int is = 0; is < SQLs.length; ++is) {
                        stmt.executeUpdate(SQLs[is]);
                    }
                }
                con.commitTransaction();
            } else if (dbType == 2) {
                con.beginTransaction();
                for (int i = 0; i < multilingualPropTables.size(); ++i) {
                    String tableName = multilingualPropTables.get(i).toString();
                    String[] SQLs = sqlGenerator.createRecalculateMappedLocaleDefaultsSqls(tableName, dbType);
                    for (int is = 0; is < SQLs.length; ++is) {
                        stmt.executeUpdate(SQLs[is]);
                    }
                }
                con.commitTransaction();
            } else if (dbType == 3) {
                con.beginTransaction();
                for (int i = 0; i < multilingualPropTables.size(); ++i) {
                    String tableName = multilingualPropTables.get(i).toString();
                    String[] SQLs = sqlGenerator.createRecalculateMappedLocaleDefaultsSqls(tableName, dbType);
                    for (int is = 0; is < SQLs.length; ++is) {
                        stmt.executeUpdate(SQLs[is]);
                    }
                }
                con.commitTransaction();
            } else if (dbType == 5 || dbType == 4 || dbType == 8) {
                stmt.execute(sqlGenerator.createCreateCMTMPLOCALEREMAPSql(dbType));
                String tempTablePrefix = sqlGenerator.createTemporaryTablePrefix(con.getDbms());
                con.beginTransaction();
                for (int i = 0; i < multilingualPropTables.size(); ++i) {
                    String tableName = multilingualPropTables.get(i).toString();
                    String[] SQLs = sqlGenerator.createRecalculateMappedLocaleDefaultsSqls(tableName, dbType);
                    for (int is = 0; is < SQLs.length; ++is) {
                        stmt.executeUpdate(SQLs[is]);
                    }
                    stmt.execute(sqlGenerator.createDeleteFromTableSql(tempTablePrefix + "CMTMPLOCALEREMAP"));
                }
                con.commitTransaction();
                stmt.execute(sqlGenerator.createDropTableSql(tempTablePrefix + "CMTMPLOCALEREMAP"));
            }
        }
        catch (SQLException ex) {
            throw new CMConfigurationException((Throwable)ex, "Failed to recalculate the default Strings for mapped locales");
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
    }

    private static void loadCMMetadataIntoDb(CMDbConnection con) throws CMConfigurationException {
        CMResourceLoader resourceLoader = CMResourceUtils.getResourceLoader();
        InputStream metadataFileInputStream = resourceLoader.getResourceInputStream("/WEB-INF/cm/cmMetadata.xml");
        if (metadataFileInputStream == null) {
            throw new CMConfigurationException("cmNoConfigFile", new CMException.Parm("Resource", "/WEB-INF/cm/cmMetadata.xml"));
        }
        Statement stmt = null;
        try {
            con.beginTransaction();
            stmt = con.createStatement();
            CMDbConnection.executeUpdate(stmt, con.getSqlGenerator().createDeleteFromTableSql("CMPROPERTIES"));
            CMDbConnection.executeUpdate(stmt, con.getSqlGenerator().createDeleteFromTableSql("CMCLASSES"));
            Document metadataDoc = CMXMLUtils.parse(new InputSource(metadataFileInputStream));
            NodeList groups = metadataDoc.getDocumentElement().getChildNodes();
            Element classes = null;
            Element enumerations = null;
            for (int i = 0; i < groups.getLength(); ++i) {
                Node curNode = groups.item(i);
                if (curNode.getNodeType() != 1) continue;
                if (curNode.getNodeName().equals("classes")) {
                    classes = (Element)curNode;
                    continue;
                }
                if (!curNode.getNodeName().equals("enumerations")) continue;
                enumerations = (Element)curNode;
            }
            if (classes == null || enumerations == null) {
                throw new CMConfigurationException(null, "cmUnexpectedErrLoadingClassDefs");
            }
            CMDbStoreFactory.addClassDefs(con.getConnection(), classes);
            CMDbStoreFactory.addEnumerationDefs(con.getConnection(), enumerations);
            con.commitTransaction();
        }
        catch (Exception ex) {
            try {
                throw new CMConfigurationException((Throwable)ex, "cmUnexpectedErrLoadingClassDefs");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                if (con != null && con.inTransaction()) {
                    try {
                        con.rollbackTransaction();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        if (con != null && con.inTransaction()) {
            try {
                con.rollbackTransaction();
            }
            catch (Exception metadataDoc) {}
        }
    }

    private static void addEnumerationDefs(Connection con, Element enumDefs) throws CMConfigurationException {
        try {
            CMDbConnection dbCon = new CMDbConnection(con, true);
            CMDbProperty PROPID = new CMDbProperty(con, PROPIDDEF);
            CMDbProperty PROPNAME = new CMDbProperty(con, PROPNAMEDEF);
            CMDbProperty PROPDEF = new CMDbProperty(con, PROPDEFDEF);
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            DOMWriter writer = new DOMWriter(false, data);
            Iterator<Node> it = DOMUtils.elementIterator(enumDefs);
            int i = 0;
            while (it.hasNext()) {
                data.reset();
                Element enumElem = (Element)it.next();
                String enumName = enumElem.getAttribute("name");
                writer.print(enumElem);
                CMDbStoreNonObjectAddDef addDef = new CMDbStoreNonObjectAddDef("CMPROPERTIES", PROPID);
                addDef.addColumn(PROPNAME, enumName);
                addDef.addColumn(PROPDEF, data.toByteArray());
                addDef.execute(dbCon, new Integer(i++));
            }
        }
        catch (Exception ex) {
            throw new CMConfigurationException((Throwable)ex, "cmUnexpectedErrLoadingClassDefs");
        }
    }

    private static void addClassDefs(Connection con, Element classDefs) throws CMConfigurationException {
        try {
            CMDbProperty CLASSID = new CMDbProperty(con, CLASSIDDEF);
            CMDbProperty CLASSNAME = new CMDbProperty(con, CLASSNAMEDEF);
            CMDbProperty CLASSUSAGE = new CMDbProperty(con, CLASSUSAGEDEF);
            CMDbProperty CLASSDEF = new CMDbProperty(con, CLASSDEFDEF);
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            DOMWriter writer = new DOMWriter(false, data);
            CMDbConnection dbCon = new CMDbConnection(con, true);
            Iterator<Node> it = DOMUtils.elementIterator(classDefs);
            while (it.hasNext()) {
                data.reset();
                Element classElem = (Element)it.next();
                String className = classElem.getAttribute("name");
                String classID = classElem.getAttribute("id");
                String usageStr = classElem.getAttribute("usage");
                writer.print(classElem);
                CMDbStoreNonObjectAddDef addDef = new CMDbStoreNonObjectAddDef("CMCLASSES", CLASSID);
                addDef.addColumn(CLASSNAME, className);
                addDef.addColumn(CLASSUSAGE, new Integer(CMDbObjectClass.getUsageID(usageStr)));
                addDef.addColumn(CLASSDEF, data.toByteArray());
                addDef.execute(dbCon, new Integer(classID));
            }
        }
        catch (Exception ex) {
            throw new CMConfigurationException((Throwable)ex, "cmUnexpectedErrLoadingClassDefs");
        }
    }

    static int loadConfiguredLocales() throws CMConfigurationException {
        int status = 0;
        IConfiguration config = CMDbStoreFactory.getConfig();
        XMLElement el = ((CMDbStoreArrayXMLValue)config.getObject("supportedContentLocales")).getElement();
        ArrayList<XMLElement> entries = el.getChildren();
        if (entries != null) {
            int elCount = entries.size();
            for (int elIdx = 0; elIdx != elCount; ++elIdx) {
                XMLElement childEl = (XMLElement)entries.get(elIdx);
                String localeStr = childEl.value_;
                String mappedLocaleStr = config.mapContentLocale(localeStr, false);
                CMDbStoreStringLocale locale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(localeStr);
                CMDbStoreStringLocale mappedLocale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(mappedLocaleStr);
                if (mappedLocale == null) {
                    mappedLocale = (CMDbStoreStringLocale)CMDbStoreStringLocales.getLocale(mappedLocaleStr, null);
                    mappedLocale.setMappedID(mappedLocale.getInternalID());
                    status = Math.max(status, 1);
                }
                if (locale == null) {
                    CMDbStoreStringLocales.getLocale(localeStr, mappedLocale);
                    status = Math.max(status, 1);
                    continue;
                }
                short mappedID = locale.getMappedID();
                if (mappedID == mappedLocale.getInternalID()) continue;
                locale.setMappedID(mappedLocale.getInternalID());
                status = Math.max(status, 2);
            }
        }
        return status;
    }

    static void saveLocaleInformation(CMDbConnection con) throws CMConfigurationException {
        PreparedStatement insertStmt = null;
        Statement deleteStmt = null;
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        try {
            deleteStmt = con.createStatement();
            CMDbConnection.executeUpdate(deleteStmt, sqlGenerator.createDeleteFromTableSql("CMLOCALES"));
            insertStmt = con.prepareStatement(sqlGenerator.createInsertIntoTableValuesBindPatrametersSql(new String[]{"LOCALEID", "MAPDLOCALEID", "LOCALE"}, "CMLOCALES"));
            CMDbStoreStringLocales.saveLocales(insertStmt);
        }
        catch (SQLException ex) {
            try {
                throw new CMConfigurationException((Throwable)ex, "Failed to save localeInformation");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(insertStmt);
                CMDbStoreUtil.safeCloseStatement(deleteStmt);
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(insertStmt);
        CMDbStoreUtil.safeCloseStatement(deleteStmt);
    }

    private static void initDatabaseContentDependent(CMDbConnection con, boolean readOnly) throws CMConfigurationException {
        File scriptFile = CMDbStoreFactory.getScriptManager().getScriptFile("dbInitScript", CMDbConnection.getDbmsInfo());
        CMDbStoreFactory.executeScript(con.getConnection(), scriptFile, "com.cognos.cm.dbstore.CMDbStoreUpgrade", false, true, null);
        if (!readOnly) {
            CMDbStoreFactory.loadCMMetadataIntoDb(con);
        }
        CMDbStoreFactory.loadConfiguredLocales();
        if (!readOnly) {
            CMDbStoreFactory.saveLocaleInformation(con);
        }
        dbInitializationState_ = 1;
    }

    private static void initAndReportDbMetadata(Connection con, String connectString) throws CMException {
        try {
            CMDbConnection.initMetaData(con, connectString);
            CMIndications.CMTrace("cmDatabaseVendor", new CMException.Parm("Value", CMDbConnection.getDbmsInfo().getDbmsName()));
            CMIndications.CMTrace("cmDatabaseVersion", new CMException.Parm("Value", CMDbConnection.getDbmsInfo().getDbmsVersion()));
            CMIndications.CMTrace("cmDriverVendor", new CMException.Parm("Value", CMDbConnection.getDbmsInfo().getDbmsDriverName()));
            CMIndications.CMTrace("cmDriverVersion", new CMException.Parm("Value", CMDbConnection.getDbmsInfo().getDbmsDriverVersion()));
            if (CMDbConnection.dbms_ != 2 || CMDbConnection.dbms_ != 3) {
                CMIndications.CMTrace("cmConnectedToDB", new CMException.Parm("Value", CMDbConnection.getDbmsInfo().getDbName()));
            }
            CMIndications.CMTrace("cmConnectedAs", new CMException.Parm("Value", CMDbConnection.getDbmsInfo().getDbUserName()));
            CMDbStoreFactory.logDBCharacterSetNames(con, 20000);
        }
        catch (SQLException e) {
            CMConfigurationException configE = new CMConfigurationException((Throwable)e, "cmMissCSInfo");
            if (CMIndicationGlobals.bDebugLogEnabled) {
                CMIndications.CMDebugTrace(configE);
            }
            throw configE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CMException logDBCharacterSetNames(Connection con, int nLevel) {
        CMException eCM = null;
        String sql = CMDbConnection.getDbmsInfo().getCharacterCodeStmt();
        if (sql != null) {
            Statement stmt = null;
            try {
                stmt = con.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    if (nLevel == 20000) {
                        CMIndications.CMTrace("cmDatabaseDbCS", new CMException.Parm("Value", rs.getString(1)));
                    } else if (nLevel == 40000) {
                        eCM = new CMException("cmDatabaseDbCSFatal", new CMException.Parm("Value", rs.getString(1)));
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
        }
        return eCM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static CMException logDBCollationName(Connection con, int nLevel) {
        CMException eCM = null;
        if (CMDbConnection.dbms_ == 1) {
            Statement stmt;
            block6: {
                stmt = null;
                try {
                    String sql = "select cast(DATABASEPROPERTYEX('" + CMDbConnection.getDbmsInfo().getDbName() + "', 'Collation') as nvarchar)";
                    stmt = con.createStatement();
                    ResultSet rs = stmt.executeQuery(sql);
                    if (!rs.next()) break block6;
                    if (nLevel == 20000) {
                        CMIndications.CMTrace("cmDatabaseClientCS", new CMException.Parm("Value", rs.getString(1)));
                        break block6;
                    }
                    if (nLevel != 40000) break block6;
                    eCM = new CMException("cmDatabaseCollationFatal", new CMException.Parm("Value", rs.getString(1)));
                }
                catch (Exception exception) {
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    catch (Throwable throwable) {
                        CMDbStoreUtil.safeCloseStatement(stmt);
                        throw throwable;
                    }
                }
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        return eCM;
    }

    private static void loadSysProps(Connection con) throws CMConfigurationException {
        IConfiguration config;
        Statement stmt;
        block23: {
            stmt = null;
            config = CMDbStoreFactory.getConfig();
            ICMDbStoreSqlGenerator sqlGenerator = null;
            try {
                CMDbConnection dbConnection = new CMDbConnection(con, true);
                sqlGenerator = dbConnection.getSqlGenerator();
                stmt = con.createStatement();
                if (CMDbConnection.dbms_ == 3) {
                    con.setAutoCommit(false);
                }
                ResultSet rs = stmt.executeQuery(sqlGenerator.createSelectColumnNamesFromTableSql(new String[]{"PROPNAME", "PROPVALUE"}, "CMSYSPROPS"));
                ArrayList<CMScriptStep> scriptSteps = new ArrayList<CMScriptStep>();
                ArrayList<String> upgradeHistorySteps = new ArrayList<String>();
                while (rs.next()) {
                    String value = null;
                    String parmName = rs.getString(1);
                    if (CMDbConnection.dbms_ == 1 || CMDbConnection.dbms_ == 4) {
                        value = rs.getString(2);
                    } else {
                        ResultSetMetaData metaData = rs.getMetaData();
                        if (metaData.getColumnType(2) == 12) {
                            value = rs.getString(2);
                        } else if (metaData.getColumnType(2) == -1) {
                            value = rs.getString(2);
                        } else {
                            Clob data = rs.getClob(2);
                            if (data != null) {
                                value = data.getSubString(1L, (int)data.length());
                            }
                        }
                    }
                    if (parmName.indexOf(".sql+") > -1) {
                        scriptSteps.add(new CMScriptStep(parmName, value));
                        continue;
                    }
                    if (parmName.indexOf(PARM_STOREUPGRADEHISTORY) > -1) {
                        upgradeHistorySteps.add(value);
                        continue;
                    }
                    config.setInternalProp(parmName, value);
                }
                Properties props = CMDbStoreFactory.getConfig().getProperties();
                props.put(PARM_SCRIPTSTEPS, scriptSteps);
                if (upgradeHistorySteps.size() > 0) {
                    props.put(PARM_STOREUPGRADEHISTORY, upgradeHistorySteps);
                }
                if (CMDbConnection.dbms_ != 3) break block23;
                con.commit();
            }
            catch (SQLException e) {
                try {
                    CMConfigurationException configE = new CMConfigurationException((Throwable)e, "cmErrReadCSParm");
                    if (CMIndicationGlobals.bDebugLogEnabled) {
                        CMIndications.CMDebugTrace(configE);
                    }
                    throw configE;
                }
                catch (Throwable throwable) {
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    if (CMDbConnection.dbms_ == 3) {
                        try {
                            con.setAutoCommit(true);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        if (CMDbConnection.dbms_ == 3) {
            try {
                con.setAutoCommit(true);
            }
            catch (SQLException dbConnection) {}
        }
        CMDbStoreFactory.correctCurrentDBVersion(config);
    }

    private static void correctCurrentDBVersion(IConfiguration config) throws CMConfigurationException {
        String dbVersion = config.getInternalProp(PARM_VERSION);
        if (dbVersion != null) {
            try {
                double currentDBVersion = Double.parseDouble(dbVersion);
                if (currentDBVersion >= (double)3.0001f && currentDBVersion <= (double)3.0037f) {
                    String bseDbVersion = DB_BSE_MAJOR_VERSION + dbVersion.substring(dbVersion.indexOf("."));
                    config.setInternalProp(PARM_VERSION, bseDbVersion);
                }
            }
            catch (NumberFormatException ex) {
                throw new CMConfigurationException("cmNoVersion");
            }
        }
    }

    private static void loadMetadata(CMDbConnection con) throws CMConfigurationException {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        propertySets_ = new CMDbPropertySets();
        try {
            objectClasses_ = new CMDbObjectClasses((CMDbPropertySet)CMPropertySet.CM);
            objectClasses_.load(con);
        }
        catch (Exception e) {
            throw new CMConfigurationException((Throwable)e, "cmNoClassDefs");
        }
        if (dbInitializationState_ != 1 && (dbInitializationState_ != 2 || versionBeforeUpgrade_ >= (double)0.89f)) {
            Statement localeStmt = null;
            try {
                localeStmt = con.createStatement();
                CMDbStoreStringLocales.loadLocales(localeStmt.executeQuery(sqlGenerator.createSelectColumnNamesFromTableSql(new String[]{"LOCALEID", "MAPDLOCALEID", "LOCALE"}, "CMLOCALES")));
            }
            catch (SQLException ex) {
                throw new CMConfigurationException((Throwable)ex, "Failed to load locale information");
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(localeStmt);
            }
            int localeState = CMDbStoreFactory.loadConfiguredLocales();
            if (localeState != 0) {
                CMDbStoreFactory.saveLocaleInformation(con);
            }
            if (localeState == 2) {
                CMDbStoreFactory.recalculateMappedLocaleDefaults(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Connection getInitialConnection() throws CMConfigurationException, CMStoreNotAvailable {
        IConfiguration config = CMDbStoreFactory.getConfig();
        String thisCMURI = config.getCognosProp("localCMURL");
        if (thisCMURI != null) {
            try {
                thisCMURI = UrlUtils.convertURItoDispatcherPath(thisCMURI, true);
            }
            catch (CMException ex) {
                thisCMURI = null;
            }
        }
        storeDir_ = config.getInternalProp("CMStoreInitDir");
        String dbType = config.getDatabaseType();
        CMDbStoreFactory.setupConnectionString(config);
        CMDriverManager.init(config);
        CMDbConnectionParameters connectParms = new CMDbConnectionParameters(config);
        Connection con = null;
        try {
            con = connectParms.getMaxConnectionAttempts() > 1 ? CMDbStoreFactory.getInitialConnectionWithRetry(connectParms) : CMDbStoreFactory.getJDBCConnection(connectParms);
            CMDbStoreFactory.initAndReportDbMetadata(con, connectParms.getConnectionURL());
            scriptParameters_ = new CMDbStoreScriptParameters(CMDbStoreFactory.getConfig());
            scriptParameters_.initialize();
            if (CMDbConnection.dbms_ == 2) {
                ResultSet rs;
                block26: {
                    rs = null;
                    try {
                        DatabaseMetaData dbInfo = con.getMetaData();
                        rs = dbInfo.getColumns(null, CMDbConnection.getDbmsInfo().getDbSchema(), baseTable_, "CMID");
                        if (rs.next()) break block26;
                        CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
                        ((OracleConnection)con).setIncludeSynonyms(true);
                        dbInfo = con.getMetaData();
                        rs = dbInfo.getColumns(null, CMDbConnection.getDbmsInfo().getDbSchema(), baseTable_, "CMID");
                        if (rs.next()) {
                            includeSynonymsWithOracleConnection_ = true;
                        }
                        ((OracleConnection)con).setIncludeSynonyms(false);
                    }
                    catch (SQLException sQLException) {
                        CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
                        catch (Throwable throwable) {
                            CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
                            throw throwable;
                        }
                    }
                }
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
            }
            int maxConnections = con.getMetaData().getMaxConnections();
            connectionPool_ = new CMDbConnectionPool(connectParms, maxConnections, thisCMURI);
        }
        catch (SQLException e) {
            int vendorCode;
            String sSQLState = e.getSQLState();
            if (sSQLState != null && sSQLState.length() >= 2 && sSQLState.substring(0, 2).compareTo("08") == 0) {
                throw new CMStoreNotAvailable(e);
            }
            if (dbType.equalsIgnoreCase("Microsoft") && (vendorCode = e.getErrorCode()) == 18452) {
                CMConfigurationException newExc = new CMConfigurationException((Throwable)e, "cmSqlServerWinAuthError");
                throw new CMConfigurationException((Throwable)newExc, "cmNoCSConnect", new CMException.Parm[]{new CMException.Parm("Connect", connectParms.getConnectionURL()), new CMException.Parm("AdvProp", connectParms.getConnectionAdvancedParameters()), new CMException.Parm("ConnectError", e.getMessage())});
            }
            if (dbType.equalsIgnoreCase("Derby") && connectParms.getConnectionURL().contains("localhost:1527")) {
                throw new CMConfigurationException((Throwable)e, "cmNoCSConnectDerby", new CMException.Parm[]{new CMException.Parm("Connect", connectParms.getConnectionURL()), new CMException.Parm("ConnectError", e.getMessage())});
            }
            throw new CMConfigurationException((Throwable)e, "cmNoCSConnect", new CMException.Parm[]{new CMException.Parm("Connect", connectParms.getConnectionURL()), new CMException.Parm("AdvProp", connectParms.getConnectionAdvancedParameters()), new CMException.Parm("ConnectError", e.getMessage())});
        }
        catch (Exception ex) {
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception sSQLState) {
                    // empty catch block
                }
            }
            throw new CMConfigurationException((Throwable)ex, "cmNoCSConnect", new CMException.Parm[]{new CMException.Parm("Connect", connectParms.getConnectionURL()), new CMException.Parm("AdvProp", connectParms.getConnectionAdvancedParameters()), new CMException.Parm("ConnectError", ex.getMessage())});
        }
        if (CMDbConnection.dbms_ == 4) {
            CMDbStoreFactory.throwIfSybaseDbDoesNotMatchConfig(config, connectParms);
        }
        Statement stmt = null;
        try {
            if (CMDbConnection.dbms_ == 1) {
                int optionValue;
                String sql = "select @@OPTIONS";
                stmt = con.createStatement();
                ResultSet rs = stmt.executeQuery("select @@OPTIONS");
                if (rs.next() && ((optionValue = rs.getInt(1)) & 0x200) != 0) {
                    throw new CMConfigurationException("cmUnsupportedDBOption", new CMException.Parm("Option", "NOCOUNT"));
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        return con;
    }

    private static void throwIfSybaseDbDoesNotMatchConfig(IConfiguration config, ICMDbConnectionParameters connectParms) throws CMConfigurationException {
        if (System.getProperty("com.cognos.cm.server.configuration.databaseType") != null) {
            return;
        }
        String desiredDB = config.getDatabaseProp("databaseName");
        if (!desiredDB.equals(CMDbConnection.getDbmsInfo().getDbName())) {
            Locale locale = CMDbStoreFactory.getConfig().getServerLocale().toLocale();
            String sybaseConfigError = CMError.getMessage("cmSybaseIncorrectDB", null, locale);
            throw new CMConfigurationException("cmNoCSConnect", new CMException.Parm[]{new CMException.Parm("Connect", connectParms.getConnectionURL()), new CMException.Parm("AdvProp", connectParms.getConnectionAdvancedParameters()), new CMException.Parm("ConnectError", sybaseConfigError)});
        }
    }

    public static Connection getInitialConnectionWithRetry(ICMDbConnectionParameters conParms) throws SQLException, CAMCryptoException {
        int maxNumberOfAttempts = conParms.getMaxConnectionAttempts();
        int secondsBetweenRetries = conParms.getSecondsBetweenConnectionAttempts();
        Connection con = null;
        boolean connectionEstablished = false;
        int numberOfConnectionAttempts = 0;
        while (!connectionEstablished && numberOfConnectionAttempts < maxNumberOfAttempts) {
            ++numberOfConnectionAttempts;
            try {
                con = CMDbStoreFactory.getJDBCConnection(conParms);
                if (con == null) continue;
                connectionEstablished = true;
            }
            catch (SQLException ex) {
                if (numberOfConnectionAttempts >= maxNumberOfAttempts) {
                    throw ex;
                }
                if (CMDbStoreFactory.isConnectionProblem(ex)) {
                    CMIndications.logException(new CMStoreNotAvailable(ex));
                    try {
                        Thread.sleep(secondsBetweenRetries * 1000);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw ex;
            }
        }
        return con;
    }

    private static boolean isConnectionProblem(SQLException ex) {
        boolean connectProblem = false;
        String sqlState = ex.getSQLState();
        int sqlCode = ex.getErrorCode();
        if (sqlState != null) {
            if (sqlState.startsWith("08") || sqlState.equalsIgnoreCase("JZ006")) {
                connectProblem = true;
            }
        } else if (sqlCode == -4499) {
            connectProblem = true;
        }
        return connectProblem;
    }

    private static Connection getJDBCConnection(ICMDbConnectionParameters connParams) throws CAMCryptoException, SQLException {
        return CMDriverManager.getConnection(connParams);
    }

    public static synchronized void closeInitialConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static synchronized Connection initContentIndependentBeforeLock() throws CMConfigurationException, CMStoreNotAvailable, CMException {
        File scriptFile;
        Connection con = null;
        if (initedContentIndependentBeforeLock_) {
            return con;
        }
        con = CMDbStoreFactory.getInitialConnection();
        String cleanScript = System.getProperty("com.cognos.cm.dbClean");
        if (cleanScript != null) {
            if (cleanScript.length() == 0) {
                cleanScript = "dbClean";
            }
            scriptFile = CMDbStoreFactory.getScriptManager().getScriptFile(cleanScript, CMDbConnection.getDbmsInfo());
            CMDbStoreFactory.executeScript(con, scriptFile, "com.cognos.cm.dbstore.CMDbStoreUpgrade", true, false, null);
        }
        if (CMDbStoreFactory.hasDatabaseCreationFailedPreviously(con)) {
            CMDbStoreFactory.verifyDBConfigurationIsSupported(con);
            throw new CMConfigurationException((Throwable)new CMException("cmErrIncompleteDbInit"), "cmErrInitContentStore");
        }
        bDatabaseEmpty_ = CMDbStoreFactory.isDatabaseEmpty(con);
        if (bDatabaseEmpty_) {
            CMDbStoreFactory.verifyDBConfigurationIsSupported(con);
            scriptFile = CMDbStoreFactory.getScriptManager().getScriptFile("dbInitLock", CMDbConnection.getDbmsInfo());
            CMDbStoreFactory.executeScript(con, scriptFile, "com.cognos.cm.dbstore.CMDbStoreUpgrade", false, false, null);
        } else {
            CMDbStoreFactory.checkCMLOCK(con);
        }
        try {
            CMDbStoreMultipleCMsUtil.getInstance().checkCMLockConsistency(new CMDbConnection(con, true));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        AdvancedSettings.addObserver(new CMDbStoreFactoryObserver());
        initedContentIndependentBeforeLock_ = true;
        dbInitializationState_ = 0;
        return con;
    }

    public static synchronized boolean configTestDBConnection() throws CMConfigurationException, CMStoreNotAvailable, CMException {
        Connection con = CMDbStoreFactory.getInitialConnection();
        if (con == null) {
            return false;
        }
        try {
            CMDbStoreFactory.verifyDBConfigurationIsSupported(con);
        }
        finally {
            CMDbStoreFactory.closeInitialConnection(con);
        }
        return true;
    }

    public static synchronized Connection configTestGetConnection() throws CMConfigurationException, CMStoreNotAvailable, CMException {
        return CMDbStoreFactory.getInitialConnection();
    }

    public static synchronized boolean configDbUpgradeRequired() throws CMConfigurationException, CMStoreNotAvailable, CMException {
        Connection con = null;
        try {
            con = CMDbStoreFactory.getInitialConnection();
            if (con == null) {
                throw new CMConfigurationException("cmErrInitContentStore");
            }
            if (CMDbStoreFactory.isDatabaseEmpty(con)) {
                boolean bl = false;
                return bl;
            }
            CMDbStoreFactory.loadSysProps(con);
            boolean bl = CMDbStoreFactory.databaseRequiresMajorUpgrade();
            return bl;
        }
        finally {
            CMDbStoreFactory.closeInitialConnection(con);
        }
    }

    public static synchronized void initContentIndependentAfterLock(CMStoreConnectionProblemReporter connectionProblemReporter) throws CMConfigurationException, CMStoreNotAvailable {
        if (initedContentIndependentAfterLock_) {
            return;
        }
        connectionPool_.setProblemReporter(connectionProblemReporter);
        CMDbConnection con = null;
        try {
            con = CMDbStoreFactory.getAdminConnection();
            dbInitializationState_ = 0;
            if (bDatabaseEmpty_) {
                File scriptFile = CMDbStoreFactory.getScriptManager().getScriptFile("dbInitMeta", CMDbConnection.getDbmsInfo());
                CMDbStoreFactory.executeScript(con.getConnection(), scriptFile, "com.cognos.cm.dbstore.CMDbStoreUpgrade", false, true, null);
            }
            storeDir_ = null;
            CMDbStoreFactory.loadSysProps(con.getConnection());
            CMDbStoreFactory.setupJDBCLogging();
        }
        finally {
            if (con != null) {
                try {
                    CMDbStoreFactory.releaseConnection(con);
                }
                catch (Exception exception) {}
            }
        }
        initedContentIndependentAfterLock_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initContentDependent(boolean readOnly) throws CMConfigurationException, CMStoreNotAvailable, CMException {
        if (initedContentDependent_) {
            return;
        }
        CMDbConnection con = null;
        try {
            con = CMDbStoreFactory.getAdminConnection();
            CMException.Parm dbSchemaVersionParm = new CMException.Parm("SchemaVersion", DB_VERSION);
            dbInitializationState_ = 0;
            if (bDatabaseEmpty_) {
                CMException.Parm[] parms = new CMException.Parm[]{dbSchemaVersionParm};
                CMIndications.Audit_Message_FreeFormText("cmCreateCSTables", parms, 50000, "StartService", "ContentManagerService", "", "Info", null);
                CMDbStoreFactory.initDatabaseContentDependent(con, readOnly);
            }
            storeDir_ = null;
            CMDbStoreFactory.loadSysProps(con.getConnection());
            if (CMDbStoreFactory.databaseRequiresUpgrade()) {
                if (!readOnly) {
                    CMDbStoreFactory.verifyDBConfigurationIsSupported(con.getConnection());
                    if (!CMDbStoreFactory.hasPreviousUpgradeSteps()) {
                        try {
                            if (versionBeforeUpgrade_ >= (double)2.0013f && versionBeforeUpgrade_ <= (double)2.0038f) {
                                CMDbStoreFactory.makeConsistentHistory(con);
                            }
                            CMIndications.CMTrace("cmCheckingCSConsistency");
                            CMDbStoreFactory.checkConsistencyBeforeUpgrade(con);
                        }
                        catch (Throwable parms) {
                            // empty catch block
                        }
                    }
                    CMIndications.CMTrace("cmUpgradeCSTables", dbSchemaVersionParm);
                    boolean requireMajorUpgrade = CMDbStoreFactory.databaseRequiresMajorUpgrade();
                    String ipfOp = "UpgradeDetails";
                    if (requireMajorUpgrade) {
                        ipfOp = "Upgrade";
                    }
                    CMIndications.Audit_Message_FreeFormText("cmDBSchemaUpgradeStart", null, 50000, ipfOp, "ContentManagerService", "", "Info", null);
                    CMDbStoreFactory.upgradeDatabase(con);
                    CMIndications.Audit_Message_FreeFormText("cmDBSchemaUpgradeEnd", null, 50000, ipfOp, "ContentManagerService", "", "Info", null);
                } else {
                    String cmURI = null;
                    try {
                        cmURI = CMDbStoreFactory.getStore().getRunningContentStoreName();
                    }
                    catch (CMException ex) {
                        CMIndications.logException(new CMException(ex, "cmErrInitContentStore"));
                    }
                    throw new CMConfigurationException("cmCannotUpgradeInStandByMode", new CMException.Parm("URL", cmURI));
                }
            }
            if (!readOnly) {
                CMDbStoreFactory.loadCMMetadataIntoDb(con);
                CMDbStoreFactory.initNameUniquenessScope(con);
            }
            CMDbStoreFactory.loadMetadata(con);
            CMDbStorePrepStmtCache.init(con);
            if (dbInitializationState_ == 1) {
                try {
                    CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreFactory.class.getDeclaredMethod("createRootObject", new Class[0]), null), "PRECACHEINITACTIONS", null);
                }
                catch (NoSuchMethodException ex) {
                    throw new CMRuntimeException(ex);
                }
            } else if (versionBeforeUpgrade_ <= (double)0.27f) {
                CMDbStoreFactory.upgradeRootObject(con);
            }
            CMDbStoreFactory.setupJDBCLogging();
            policyCache_ = CMDbStoreFactory.setupCMObjectCache("policyCache", AdvancedSettings.POLICYCACHESIZE, AdvancedSettings.POLICYCACHEMAXBYTES);
            userCapabilityPoliciesCache_ = CMDbStoreFactory.setupCMObjectCache("userCapabilityPoliciesCache", AdvancedSettings.USERCAPABILITYPOLICIESCACHESIZE, AdvancedSettings.USERCAPABILITYPOLICIESCACHEMAXBYTES);
            CMDbStoreFactory.setupTempFileCache();
        }
        finally {
            if (con != null) {
                try {
                    CMDbStoreFactory.releaseConnection(con);
                }
                catch (Exception exception) {}
            }
        }
        initedContentDependent_ = true;
    }

    private static void initNameUniquenessScope(CMDbConnection con) throws CMException {
        String propValue = CMDbStoreFactory.getConfig().getConfigAdvancedProp("CM_PER_TENANT_NAME_UNIQUENESS");
        if (propValue == null) {
            return;
        }
        switch (propValue) {
            case "true": {
                CMDbStoreSysProperties.setProperty(con, "CM_PER_TENANT_NAME_UNIQUENESS", "1");
            }
            case "1": {
                CMDbStoreFactory.getConfig().enablePerTenantNameUniqueness();
            }
        }
    }

    private static void setupJDBCLogging() {
        String jdbcLogFile = CMDbStoreFactory.getConfig().getInternalProp(PARM_JDBCLOGFILE);
        if (jdbcLogFile != null && jdbcLogFile.length() > 0) {
            try {
                DriverManager.setLogWriter(new PrintWriter(new PrintStream(new FileOutputStream(jdbcLogFile)), true));
            }
            catch (Exception ex) {
                System.out.println("Failed to configure a jdbc log writer, no logging will be done: " + ex.getMessage());
            }
        }
    }

    public static void clearCache() {
        policyCache_.clear();
        userCapabilityPoliciesCache_.clear();
    }

    private static <K, V> CMObjectCache<K, V> setupCMObjectCache(String name, CMInt advSize, CMInt advMaxBytes) {
        if (name == null) {
            return null;
        }
        int size = advSize.intValue();
        int maxBytes = advMaxBytes.intValue();
        CMObjectCache cache = CMCacheFactory.createCache(name, 0, size, maxBytes, new CMCacheEntryScale(){

            @Override
            public long weigh(Object obj) {
                if (obj instanceof byte[]) {
                    return ((byte[])obj).length;
                }
                return 0L;
            }
        });
        CMDbStoreFactory.registerAsObserver(cache, advSize, advMaxBytes);
        return cache;
    }

    private static <K, V> void registerAsObserver(CMObjectCache<K, V> objCache, CMInt advMaxSize, CMInt advMaxBytes) {
        class MyObserver
        implements AdvancedSettingsObserver {
            private final CMObjectCache<K, V> objCache;
            private final CMInt advMaxSize;
            private final CMInt advMaxBytes;

            public MyObserver(CMObjectCache<K, V> objCache, CMInt advMaxSize, CMInt advMaxBytes) {
                this.objCache = objCache;
                this.advMaxSize = advMaxSize;
                this.advMaxBytes = advMaxBytes;
            }

            @Override
            public void updateSettings() {
                int curMax = this.objCache.getMaxSize();
                long curMaxBytes = this.objCache.getMaxBytes();
                if (this.advMaxSize.intValue() != curMax) {
                    this.objCache.setMaxSize(this.advMaxSize.intValue());
                }
                if ((long)this.advMaxBytes.intValue() != curMaxBytes) {
                    this.objCache.setMaxBytes(this.advMaxBytes.intValue());
                }
            }
        }
        AdvancedSettings.addObserver(new MyObserver(objCache, advMaxSize, advMaxBytes));
    }

    private static void setupTempFileCache() {
        tempfileCache_ = new CMTempFileLRUCache(CMTempFileFactory.getInstance(), AdvancedSettings.DATACACHEMAXK, AdvancedSettings.TEMPFILETIMEOUT.intValue());
    }

    public static CMDbConnection getConnection() throws CMStoreNotAvailable {
        if (connectionPool_ == null) {
            throw new IllegalStateException("no pool");
        }
        return connectionPool_.get();
    }

    public static CMDbConnection getAdminConnection() throws CMStoreNotAvailable {
        if (connectionPool_ == null) {
            throw new IllegalStateException("no pool");
        }
        return connectionPool_.getForAdministration();
    }

    public static void releaseConnection(CMDbConnection x) {
        if (connectionPool_ == null) {
            throw new IllegalStateException("no pool");
        }
        connectionPool_.release(x);
    }

    public static boolean useCache() {
        return useCache_;
    }

    public static void SetUseCache(boolean use) {
        useCache_ = use;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkCMLOCK(Connection con) {
        File scriptFile2;
        double versionInDB = 0.0;
        Statement stmtUpgrade = null;
        ResultSet rs = null;
        try {
            if (CMDbConnection.dbms_ == 3) {
                con.setAutoCommit(false);
            }
            stmtUpgrade = con.createStatement();
            rs = CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive() ? stmtUpgrade.executeQuery("select PROPVALUE from CMSYSPROPS where CI_PROPNAME=upper('CMStoreVersion')") : stmtUpgrade.executeQuery("select PROPVALUE from CMSYSPROPS where PROPNAME='CMStoreVersion'");
            if (rs.next()) {
                Reader dbVersionReader = rs.getCharacterStream(1);
                String dbVersion = CMStreamUtils.readReaderIntoString((Reader)dbVersionReader);
                versionInDB = Double.parseDouble(dbVersion);
            }
        }
        catch (SQLException dbVersionReader) {
        }
        catch (Exception dbVersionReader) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException dbVersionReader) {}
            }
            if (stmtUpgrade != null) {
                try {
                    stmtUpgrade.close();
                    stmtUpgrade = null;
                }
                catch (SQLException dbVersionReader) {}
            }
            if (con != null && CMDbConnection.dbms_ == 3) {
                try {
                    con.commit();
                    con.setAutoCommit(true);
                }
                catch (SQLException dbVersionReader) {}
            }
        }
        if (versionInDB > 0.0 && versionInDB < (double)0.9965f) {
            try {
                scriptFile2 = CMDbStoreFactory.getScriptManager().getScriptFile("dbUpgradeLock", CMDbConnection.getDbmsInfo());
                CMDbStoreFactory.executeScript(con, scriptFile2, "com.cognos.cm.dbstore.CMDbStoreUpgrade", false, false, null);
            }
            catch (Exception scriptFile2) {
                // empty catch block
            }
        }
        if (versionInDB > 0.0 && versionInDB < (double)0.9969f) {
            try {
                scriptFile2 = CMDbStoreFactory.getScriptManager().getScriptFile("dbUpgradeCapacity", CMDbConnection.getDbmsInfo());
                CMDbStoreFactory.executeScript(con, scriptFile2, "com.cognos.cm.dbstore.CMDbStoreUpgrade", false, false, null);
            }
            catch (Exception scriptFile3) {
                // empty catch block
            }
        }
        if (versionInDB >= (double)0.9969f && versionInDB < 0.9981) {
            try {
                scriptFile2 = CMDbStoreFactory.getScriptManager().getScriptFile("dbUpgradeCapacity1", CMDbConnection.getDbmsInfo());
                CMDbStoreFactory.executeScript(con, scriptFile2, "com.cognos.cm.dbstore.CMDbStoreUpgrade", false, false, null);
            }
            catch (Exception scriptFile4) {
                // empty catch block
            }
        }
        if (versionInDB >= (double)0.9969f && versionInDB < 4.0063) {
            try {
                scriptFile2 = CMDbStoreFactory.getScriptManager().getScriptFile("dbUpgradeCapacity8_3", CMDbConnection.getDbmsInfo());
                CMDbStoreFactory.executeScript(con, scriptFile2, "com.cognos.cm.dbstore.CMDbStoreUpgrade", false, false, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static synchronized void terminate() {
        connectionPool_.close();
        if (CMDbConnection.getDbmsInfo().getIsEmdeddedDerbyCS()) {
            try {
                String dbShutdownStr = "jdbc:derby:" + CMDbConnection.getDbmsInfo().getDbName() + ";shutdown=true";
                CMDriverManager.getConnection(dbShutdownStr);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        CMDbStoreFactory.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSchemaTablesAndColumnsFromDB(Connection con) throws SQLException {
        ResultSet columnRS = null;
        HashMap<String, HashMap<String, Object>> columns = null;
        HashMap<String, Object> columnProps = null;
        boolean toUpperCase = CMDbConnection.getDbmsInfo().getNamesAreInLowerCase();
        schemaTablesAndColumns_ = null;
        try {
            if (CMDbConnection.dbms_ == 2 && includeSynonymsWithOracleConnection_) {
                ((OracleConnection)con).setIncludeSynonyms(true);
            }
            if (CMDbConnection.dbms_ == 4) {
                con.commit();
            }
            DatabaseMetaData dbInfo = con.getMetaData();
            columnRS = dbInfo.getColumns(null, CMDbConnection.getDbmsInfo().getDbSchema(), "%", "%");
            if (CMDbConnection.dbms_ == 2 && includeSynonymsWithOracleConnection_) {
                ((OracleConnection)con).setIncludeSynonyms(false);
            }
            while (columnRS.next()) {
                String dbColumnName;
                String dbTableName = columnRS.getString(3);
                if (dbTableName == null || dbTableName.length() <= 0) continue;
                if (toUpperCase) {
                    dbTableName = dbTableName.toUpperCase(Locale.ENGLISH);
                }
                if (schemaTablesAndColumns_ == null) {
                    schemaTablesAndColumns_ = new HashMap();
                }
                columns = null;
                columns = schemaTablesAndColumns_.get(dbTableName);
                if (columns == null) {
                    columns = new HashMap();
                    schemaTablesAndColumns_.put(dbTableName, columns);
                }
                if ((dbColumnName = columnRS.getString(4)) == null || dbColumnName.length() <= 0) continue;
                if (toUpperCase) {
                    dbColumnName = dbColumnName.toUpperCase(Locale.ENGLISH);
                }
                columnProps = null;
                columnProps = columns.get(dbColumnName);
                if (columnProps == null) {
                    columnProps = new HashMap();
                    columns.put(dbColumnName, columnProps);
                }
                columnProps.put("DATA_TYPE", new BigDecimal(columnRS.getInt(5)));
                columnProps.put("TYPE_NAME", columnRS.getString(6));
                columnProps.put("COLUMN_SIZE", new BigDecimal(columnRS.getInt(7)));
                columnProps.put("DECIMAL_DIGITS", new BigDecimal(columnRS.getInt(9)));
                columnProps.put("NULLABLE", columnRS.getInt(11));
            }
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatementViaResultSet(columnRS);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatementViaResultSet(columnRS);
        schemaMayHaveChanged_ = false;
    }

    public static String[] getColumnNamesOfTable(String table, Connection con) throws SQLException {
        HashMap<String, HashMap<String, Object>> columns = null;
        String[] colNames = null;
        CMDbStoreFactory.checkAndLoadSchemaIfChanged(con);
        if (schemaTablesAndColumns_ != null && (columns = schemaTablesAndColumns_.get(table)) != null && !columns.isEmpty()) {
            colNames = new String[columns.size()];
            columns.keySet().toArray(colNames);
        }
        return colNames;
    }

    public static HashMap<String, Object> getColumnProperties(String table, String column, Connection con) throws SQLException {
        HashMap<String, HashMap<String, Object>> columns = null;
        HashMap<String, Object> colProps = null;
        CMDbStoreFactory.checkAndLoadSchemaIfChanged(con);
        if (schemaTablesAndColumns_ != null && (columns = schemaTablesAndColumns_.get(table)) != null && !columns.isEmpty()) {
            colProps = columns.get(column);
        }
        return colProps;
    }

    private static synchronized void checkAndLoadSchemaIfChanged(Connection con) throws SQLException {
        if (schemaMayHaveChanged_ || schemaTablesAndColumns_ == null) {
            CMDbStoreFactory.loadSchemaTablesAndColumnsFromDB(con);
        }
    }

    public static HashMap<String, HashMap<String, Object>> getTableColumnProperties(String table, Connection con) throws SQLException {
        HashMap<String, HashMap<String, Object>> columns = null;
        CMDbStoreFactory.checkAndLoadSchemaIfChanged(con);
        if (schemaTablesAndColumns_ != null) {
            columns = schemaTablesAndColumns_.get(table);
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyDBAdvancedSettingsSupported() {
        if (AdvancedSettings.SORTCOLLATION.trim().length() > 0 && (CMDbConnection.dbms_ == 2 || CMDbConnection.dbms_ == 1)) {
            String NLSParameter = AdvancedSettings.SORTCOLLATION.trim();
            String selectStmt = "select PROPNAME from CMSYSPROPS order by ";
            if (CMDbConnection.dbms_ == 2) {
                selectStmt = selectStmt + "NLSSORT(PROPNAME,'NLS_SORT=" + NLSParameter + "')";
            } else if (CMDbConnection.dbms_ == 1) {
                selectStmt = selectStmt + "PROPNAME COLLATE " + NLSParameter;
            }
            CMDbConnection dbCon = null;
            Statement stmt = null;
            try {
                dbCon = CMDbStoreFactory.getConnection();
                if (dbCon != null && (stmt = dbCon.createStatement()) != null) {
                    stmt.executeQuery(selectStmt);
                }
            }
            catch (CMStoreNotAvailable cMStoreNotAvailable) {
            }
            catch (SQLException ex1) {
                if (CMDbConnection.dbms_ == 2 && ex1.getErrorCode() == 12702 || CMDbConnection.dbms_ == 1 && ex1.getErrorCode() == 448) {
                    CMIndications.logException(new CMException("cmInvalidValueForAdvancedSetting", new CMException.Parm("name", "CM.SORTCOLLATION"), new CMException.Parm("value", AdvancedSettings.SORTCOLLATION)));
                    AdvancedSettings.SORTCOLLATION = "";
                }
            }
            finally {
                try {
                    if (dbCon != null) {
                        CMDbStoreFactory.releaseConnection(dbCon);
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void sortScriptSteps(List<CMScriptStep> scriptSteps) {
        int count = scriptSteps.size();
        for (int i = 1; i < count; ++i) {
            for (int j = 0; j < count - i; ++j) {
                CMScriptStep scriptStep1 = scriptSteps.get(j);
                CMScriptStep scriptStep2 = scriptSteps.get(j + 1);
                if (!(scriptStep1.fromVersionNumber_ > scriptStep2.fromVersionNumber_) && (scriptStep1.fromVersionNumber_ != scriptStep2.fromVersionNumber_ || scriptStep1.stepNumber_ <= scriptStep2.stepNumber_)) continue;
                scriptSteps.set(j, scriptStep2);
                scriptSteps.set(j + 1, scriptStep1);
            }
        }
    }

    private static boolean checkConsistencyBeforeUpgrade(CMDbConnection con) throws CMConfigurationException {
        boolean bConsistent = true;
        CMDbStoreConsistency consistencyChecker = new CMDbStoreConsistency(con);
        CMIndications.Audit_Message_FreeFormText("cmConsistencyCheckStart", null, 50000, "Upgrade", "ContentManagerService", "", "Info", null);
        CMException inconsistency = consistencyChecker.checkConsistency();
        if (inconsistency != null) {
            bConsistent = false;
            File makeConsistent = null;
            try {
                makeConsistent = CMDbStoreFactory.getScriptManager().getScriptFile("dbMakeConsistent", CMDbConnection.getDbmsInfo());
            }
            catch (Exception exception) {
                // empty catch block
            }
            String makeConsistentScriptName = makeConsistent != null ? makeConsistent.getAbsolutePath() : "";
            CMIndications.Audit_Message_FreeFormText("cmCannotUpgradeInconsistentCS", new CMException.Parm[]{new CMException.Parm("details", inconsistency.getFullMessage()), new CMException.Parm("makeConsistentScript", makeConsistentScriptName)}, 50000, "Upgrade", "ContentManagerService", "", "Info", null);
        }
        CMIndications.Audit_Message_FreeFormText("cmConsistencyCheckEnd", null, 50000, "Upgrade", "ContentManagerService", "", "Info", null);
        return bConsistent;
    }

    private static boolean makeConsistentHistory(CMDbConnection con) throws CMConfigurationException {
        boolean bNeedFix = false;
        HashSet<String> tables = new HashSet<String>(3);
        tables.add("CMOBJPROPS14");
        tables.add("CMOBJPROPS18");
        tables.add("CMREFORD1");
        CMDbStoreConsistency consistencyChecker = new CMDbStoreConsistency(con);
        CMException inconsistency = consistencyChecker.makeTablesConsistent(tables);
        if (inconsistency != null) {
            bNeedFix = true;
        }
        return bNeedFix;
    }

    private static void initializeUpgradeHistory(CMDbConnection dbcon, double currentVersion) throws CMConfigurationException {
        upgradeHistory_ = new ArrayList<Double>();
        List<?> previousUpgrades = CMDbStoreFactory.getConfig().getList(PARM_STOREUPGRADEHISTORY);
        if (previousUpgrades == null) {
            try {
                upgradeHistory_.add(new Double(currentVersion));
                dbcon.beginTransaction();
                CMDbStoreSysProperties.addSysProp(dbcon, "CMDbUpgradeHistory_" + Double.toString(currentVersion), Double.toString(currentVersion));
                dbcon.commitTransaction();
            }
            catch (SQLException ex) {
                throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
            }
            catch (CMException ex) {
                throw new CMConfigurationException((Throwable)ex, "cmStoreUnexpected");
            }
            finally {
                if (dbcon != null && dbcon.inTransaction()) {
                    try {
                        dbcon.rollbackTransaction();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        try {
            for (int i = 0; i < previousUpgrades.size(); ++i) {
                upgradeHistory_.add(new Double((String)previousUpgrades.get(i)));
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("Invalid value for CMDbUpgradeHistory");
        }
    }

    private static void updateUpgradeHistory(double dbVersion) {
        if (upgradeHistory_ == null) {
            throw new IllegalStateException("initializeUpgradeHistory method must be called before updateUpgradeHistory");
        }
        upgradeHistory_.add(new Double(dbVersion));
    }

    private static void clearUpgradeHistory() {
        if (upgradeHistory_ != null) {
            upgradeHistory_.clear();
            upgradeHistory_ = null;
        }
    }

    private static boolean skipCommandForThisUpgrade(String skipDefinition) throws CMConfigurationException {
        boolean skip = false;
        ArrayList<String> parms = new ArrayList<String>();
        String skipArgs = skipDefinition.substring(skipDefinition.indexOf("(") + 1, skipDefinition.indexOf(")")).trim();
        StringTokenizer st = new StringTokenizer(skipArgs, "|");
        while (st.hasMoreTokens()) {
            String rangeStr = st.nextToken();
            String start = rangeStr.substring(0, rangeStr.indexOf(",")).trim();
            String end = rangeStr.substring(rangeStr.indexOf(",") + 1).trim();
            parms.add(start);
            parms.add(end);
        }
        if (parms.isEmpty() || parms.contains("")) {
            throw new IllegalStateException("Invalid skip definition: " + skipDefinition);
        }
        try {
            for (int i = 0; i < parms.size() && !skip; i += 2) {
                double startVersion = Double.valueOf((String)parms.get(i));
                double endVersion = Double.valueOf((String)parms.get(i + 1));
                for (int y = 0; y < upgradeHistory_.size() && !skip; ++y) {
                    double version = upgradeHistory_.get(y);
                    if (!(version >= startVersion) || !(version < endVersion)) continue;
                    skip = true;
                }
            }
        }
        catch (NumberFormatException ex1) {
            throw new IllegalStateException("Invalid skip definition: " + skipDefinition);
        }
        return skip;
    }

    public static void afterMetadataIsLoaded() {
        metadata_ = new CMStoreMetadata(){
            private final CMObjectClassMapping classMap = new CMObjectClassMapping();
            private final PropertyMapping propMap = new CMPropertyMapping();
            private final CMFactory factory = new CMFactory(CMDbStoreFactory.access$000());

            @Override
            public ObjectClassMapping getClassMap() {
                return this.classMap;
            }

            @Override
            public PropertyMapping getPropertyMap() {
                return this.propMap;
            }

            @Override
            public CMObjectClasses getObjectClasses() {
                return objectClasses_;
            }

            @Override
            public CMFactory getFactory() {
                return this.factory;
            }
        };
        pluginFactory_ = new PluginFactory(metadata_);
    }

    public static CMStoreMetadata getMetadata() {
        return metadata_;
    }

    protected static void setupConnectionString(IConfiguration config) throws CMConfigurationException {
        String type4ConnectString;
        String server;
        String dbType = config.getDatabaseType();
        if (dbType == null || dbType.length() == 0) {
            throw new CMConfigurationException("cmMissingCSParm", new CMException.Parm("ParmName", "databaseType"));
        }
        if (dbType.equals("DB2") && (server = config.getDatabaseProp("server")) != null && server.length() > 0 && (type4ConnectString = config.getInternalProp("CMDatabase" + dbType + "Type4")) != null && type4ConnectString.length() > 0) {
            config.setInternalProp("CMDatabase" + dbType, type4ConnectString);
        }
    }

    public static CMDbConnectionPool getConnectionPool() {
        return connectionPool_;
    }

    public static void setConnectionPool(CMDbConnectionPool pool) {
        connectionPool_ = pool;
    }

    public static CMDbObjectClasses getObjectClasses() {
        return objectClasses_;
    }

    public static void setObjectClasses(CMDbObjectClasses classes) {
        objectClasses_ = classes;
    }

    static /* synthetic */ IConfiguration access$000() {
        return CMDbStoreFactory.getConfig();
    }

    static {
        dbInitializationState_ = 0;
        versionBeforeUpgrade_ = 0.0;
        scriptManager_ = null;
        scriptParameters_ = null;
        staticStore = null;
    }

    private static class CMScriptStep {
        public String name_;
        public Object value_;
        public String scriptFileName_;
        public int stepNumber_;
        public double fromVersionNumber_;
        public double toVersionNumber_;

        public CMScriptStep(String name, Object value) throws CMConfigurationException {
            this.name_ = name;
            this.value_ = value;
            int index = this.name_.lastIndexOf("+");
            if (index > -1) {
                this.scriptFileName_ = this.name_.substring(0, index);
                this.stepNumber_ = index + 1 < this.name_.length() ? new Integer(this.name_.substring(index + 1)) : 0;
            } else {
                this.scriptFileName_ = this.name_;
                this.stepNumber_ = 0;
            }
            double[] versionNumbers = CMUpgradeFile.getVersionFromTo(this.scriptFileName_);
            this.fromVersionNumber_ = versionNumbers[0];
            this.toVersionNumber_ = versionNumbers[1];
        }
    }

    private static class CMUpgradeFile {
        public File file_;
        public double fromVersionNumber_ = 0.0;
        public double toVersionNumber_ = 0.0;

        public CMUpgradeFile(String fileName, double versionFrom, double versionTo) {
            File scriptFolder = CMDbStoreFactory.getScriptManager().getScriptFolder(CMDbConnection.getDbmsInfo());
            this.file_ = new File(scriptFolder, fileName);
            this.fromVersionNumber_ = versionFrom;
            this.toVersionNumber_ = versionTo;
        }

        public static double[] getVersionFromTo(String fileName) throws CMConfigurationException {
            double[] versions = new double[2];
            String connector = "-to-";
            String suffix = CMDbStoreFactory.getDbScriptSuffix();
            int versionIndex = -1;
            String name = fileName.toLowerCase();
            if (!name.startsWith(CMDbStoreFactory.UPGRADEFILENAMEPREFIX)) {
                throw new CMConfigurationException("cmNoVersion");
            }
            versionIndex = CMDbStoreFactory.UPGRADEFILENAMEPREFIX.length();
            int connectorIndex = name.indexOf("-to-");
            if (connectorIndex < 0 || connectorIndex <= versionIndex) {
                throw new CMConfigurationException("cmNoVersion");
            }
            String fromVersion = CMDbStoreFactory.versionFromFileNameVersion(name.substring(versionIndex, connectorIndex));
            try {
                versions[0] = Double.parseDouble(fromVersion);
            }
            catch (NumberFormatException ex) {
                throw new CMConfigurationException("cmNoVersion");
            }
            versionIndex = connectorIndex + "-to-".length();
            int suffixIndex = name.lastIndexOf(suffix);
            if (suffixIndex < 0 || suffixIndex <= versionIndex) {
                throw new CMConfigurationException("cmNoVersion");
            }
            String toVersion = CMDbStoreFactory.versionFromFileNameVersion(name.substring(versionIndex, suffixIndex));
            try {
                versions[1] = Double.parseDouble(toVersion);
            }
            catch (NumberFormatException ex) {
                throw new CMConfigurationException("cmNoVersion");
            }
            return versions;
        }
    }
}

