/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbObjectClass;
import com.cognos.cm.dbstore.CMDbObjectClasses;
import com.cognos.cm.dbstore.CMDbPropertySets;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.dbstore.ICMDbObjectClass;
import com.cognos.cm.dbstore.ICMDbObjectClasses;
import com.cognos.cm.dbstore.ICMDbStore;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMIntList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;

public class CMDbStoreIDReferencesUtil {
    public int[] findReferencedObjects(CMDbStore store, int[] objectIDs, CMObjectClass[] selectedClasses) throws CMException {
        if (objectIDs.length == 0) {
            return null;
        }
        int[] referencedObjects = null;
        Statement statement = null;
        ResultSet rs = null;
        CMDbConnection con = store.getConnection();
        try {
            int i;
            ArrayList<String> propTables = this.getPropertyTables(store);
            BitSet referenceToSelectedClassesTables = new BitSet(propTables.size());
            if (selectedClasses != null) {
                for (i = 0; i < selectedClasses.length; ++i) {
                    ICMDbObjectClass objectClass = (ICMDbObjectClass)((Object)selectedClasses[i]);
                    referenceToSelectedClassesTables.or(objectClass.getReferenceToThisClassTables());
                }
            } else {
                CMDbObjectClasses objectClasses = (CMDbObjectClasses)store.getObjectClasses();
                for (i = 0; i < objectClasses.size(); ++i) {
                    CMDbObjectClass objectClass = objectClasses.get(i);
                    referenceToSelectedClassesTables.or(objectClass.getReferenceToThisClassTables());
                }
            }
            CMDbStoreDMLDef dmlDef = new CMDbStoreDMLDef("");
            CMDbStoreDMLDef.CMDbStoreWhereCMIDsInfo whereCMIDsInfo = dmlDef.constructWhereCMIDs(con, objectIDs, "r.REFCMID", true, true);
            String whereCMIDs = whereCMIDsInfo.whereClause_;
            String joinWhereCMIDs = whereCMIDsInfo.fromClause_;
            StringBuffer restOfStatement = new StringBuffer(10 + joinWhereCMIDs.length() + whereCMIDs.length());
            restOfStatement.append(" r ");
            restOfStatement.append(joinWhereCMIDs);
            restOfStatement.append(" where ");
            restOfStatement.append(whereCMIDs);
            StringBuffer completeStmt = new StringBuffer();
            int numSelect = 0;
            for (i = 0; i < propTables.size(); ++i) {
                if (!referenceToSelectedClassesTables.get(i)) continue;
                if (numSelect > 0) {
                    completeStmt.append(" union ");
                }
                completeStmt.append("select r.REFCMID from ");
                completeStmt.append(propTables.get(i));
                completeStmt.append(restOfStatement);
                ++numSelect;
            }
            if (numSelect == 0) {
                int[] nArray = null;
                return nArray;
            }
            CMIntList objectList = new CMIntList();
            statement = con.prepareStatement(completeStmt.toString());
            int bindOffset = 1;
            for (i = 0; i < numSelect; ++i) {
                bindOffset = CMDbStoreDMLDef.bindWhereCMIDsInfo(bindOffset, (PreparedStatement)statement, objectIDs, whereCMIDsInfo);
            }
            rs = statement.executeQuery();
            while (rs.next()) {
                int objectID = rs.getInt(1);
                if (objectList.contains(objectID)) continue;
                objectList.add(objectID);
            }
            if (objectList.size() != 0) {
                referencedObjects = objectList.toArray();
            }
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmFailedSelectReferenceTables");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedSelectReferenceTables");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ex) {}
            }
        }
        return referencedObjects;
    }

    public int[] getUnreferencedObjects(CMStore store, CMObjectClass cls) throws CMException {
        CMIntList notReferencedObjectArray = new CMIntList();
        Statement statement = null;
        Statement oracleStatement = null;
        ResultSet rs = null;
        CMDbConnection dbConnection = ((CMDbStore)store).getConnection();
        ICMDbStoreSqlGenerator sqlGenerator = dbConnection.getSqlGenerator();
        try {
            StringBuffer completeStmt = new StringBuffer();
            ArrayList<String> propTables = this.getPropertyTables(store);
            BitSet classRefTables = CMDbStoreIDReferencesUtil.getReferenceTables((CMDbStore)store, propTables);
            String tempTable = null;
            int queryId = -1;
            if (CMDbConnection.dbms_ == 2) {
                queryId = dbConnection.getTmpTableId().getId();
                tempTable = sqlGenerator.createTemporaryTablePrefix(CMDbConnection.dbms_) + "CMTMPIDS";
                completeStmt.append("insert into ");
                completeStmt.append(tempTable);
                completeStmt.append(" (QUERYID, CMID) ");
                if (AdvancedSettings.DBVENDORHINTSENABLED && CMDbConnection.getDbmsInfo().getDbmsVer() < 10) {
                    completeStmt.append("select /*+ ALL_ROWS */ ");
                } else {
                    completeStmt.append("select ");
                }
                completeStmt.append(queryId);
                completeStmt.append(",o.CMID from CMOBJECTS o where o.CLASSID =");
            } else {
                completeStmt.append("select o.CMID from CMOBJECTS o where o.CLASSID =");
            }
            completeStmt.append(cls.getID());
            completeStmt.append(" and o.CMID not in (");
            boolean firstSelect = true;
            for (int i = 0; i < propTables.size(); ++i) {
                if (!classRefTables.get(i)) continue;
                if (!firstSelect) {
                    completeStmt.append(") and o.CMID not in (");
                }
                completeStmt.append("select REFCMID from ");
                completeStmt.append(propTables.get(i));
                firstSelect = false;
            }
            if (firstSelect) {
                int[] i = null;
                return i;
            }
            completeStmt.append(")");
            String completeStmtString = completeStmt.toString();
            statement = dbConnection.createStatement();
            if (CMDbConnection.dbms_ == 2) {
                oracleStatement = dbConnection.createStatement();
                oracleStatement.execute(completeStmtString);
                completeStmtString = "select CMID from " + tempTable + " where QUERYID=" + String.valueOf(queryId);
                statement.setFetchSize(1000);
            }
            rs = statement.executeQuery(completeStmtString);
            while (rs.next()) {
                int objectID = rs.getInt(1);
                notReferencedObjectArray.add(objectID);
            }
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLException(dbConnection, ex, "cmFailedSelectReferenceTables");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedSelectReferenceTables");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException ex) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException ex) {}
            }
            if (oracleStatement != null) {
                try {
                    oracleStatement.close();
                    oracleStatement = null;
                }
                catch (SQLException ex) {}
            }
        }
        if (notReferencedObjectArray.size() != 0) {
            return notReferencedObjectArray.toArray();
        }
        return null;
    }

    protected ArrayList<String> getPropertyTables(CMStore store) {
        CMDbPropertySets propSets = (CMDbPropertySets)store.getPropertySets();
        ArrayList<String> propTables = propSets.getTables();
        return propTables;
    }

    private static BitSet getReferenceTables(ICMDbStore store, ArrayList<String> propTables) {
        BitSet classRefTables = new BitSet(propTables.size());
        ICMDbObjectClasses objectClasses = store.getICMDbObjectClasses();
        for (int i = 0; i < objectClasses.size(); ++i) {
            ICMDbObjectClass objectClass = objectClasses.get(i);
            classRefTables.or(objectClass.getReferenceToThisClassTables());
        }
        return classRefTables;
    }

    public int deleteInconsistentReferences(ICMDbStore store) throws CMException {
        int numberOfDeletedRows = 0;
        ICMDbConnection dbConnection = store.getICMDbConnection();
        ICMDbStoreSqlGenerator sqlGenerator = dbConnection.getSqlGenerator();
        Statement statement = null;
        try {
            StringBuffer completeStmt = new StringBuffer();
            ArrayList<String> propTables = this.getPropertyTables(store);
            BitSet classRefTables = CMDbStoreIDReferencesUtil.getReferenceTables(store, propTables);
            statement = dbConnection.createStatement();
            for (int i = 0; i < propTables.size(); ++i) {
                if (!classRefTables.get(i)) continue;
                completeStmt.setLength(0);
                completeStmt.append(sqlGenerator.createDeleteFromTableSql(propTables.get(i)));
                completeStmt.append(sqlGenerator.createWhereSql());
                if (!AdvancedSettings.ENABLE_NOT_EXIST_SQL_OPTIMIZATION) {
                    completeStmt.append("REFCMID");
                    completeStmt.append(sqlGenerator.createNotInSql());
                    completeStmt.append(sqlGenerator.createOpeningBracket());
                    completeStmt.append(sqlGenerator.createSelectCMIDFromCMOBJECTSSql());
                } else {
                    completeStmt.append(sqlGenerator.createNotExistsSql());
                    completeStmt.append(sqlGenerator.createOpeningBracket());
                    completeStmt.append(sqlGenerator.createSelectCMIDFromCMOBJECTSSql());
                    completeStmt.append(" WHERE CMOBJECTS.CMID = " + propTables.get(i) + ".REFCMID");
                }
                completeStmt.append(sqlGenerator.createClosingBracket());
                String completeStmtString = completeStmt.toString();
                numberOfDeletedRows += statement.executeUpdate(completeStmtString);
            }
        }
        catch (SQLException ex) {
            this.handleSQLException(dbConnection, ex);
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmStoreUnexpected");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException ex) {}
            }
        }
        return numberOfDeletedRows;
    }

    protected void handleSQLException(ICMDbConnection dbConnection, SQLException ex) throws CMException {
        CMDbStoreExceptionUtil.handleSQLException(dbConnection, ex, "cmStoreUnexpected");
    }
}

