/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.dbstore.CMDbColumn;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheQueryResults;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStoreSecurityUtil;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMCAMIDHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CMDbStoreMembership {
    private static String membershipQuerySelect;
    private static String membershipQueryWhere;
    private static String initialSubQueryPrefix;
    private static String membershipColumnName;
    private static String tenantMembershipQueryWhere;
    private static String tenantSubQueryPrefix;

    public static String getMembershipQuerySelect() {
        return membershipQuerySelect;
    }

    public static String getMembershipQueryWhere() {
        return membershipQueryWhere;
    }

    public static String getInitialSubQueryPrefix() {
        return initialSubQueryPrefix;
    }

    public static String getMembershipColumnName() {
        return membershipColumnName;
    }

    public static void initialize() throws CMException {
        CMDbStoreMembership.initMembersQuery();
        CMDbStoreMembership.initTenantMembersQuery();
    }

    public static void initMembersQuery() {
        CMDbColumn memberCol = CMDbStoreMembership.getMEMBERSColumn();
        CMDbColumn objIDCol = CMDbStoreMembership.getIDColumn();
        membershipColumnName = "o." + memberCol.getName();
        membershipQuerySelect = "select distinct o.CMID from " + memberCol.getTable() + " o ";
        membershipQueryWhere = " where ";
        if (((CMDbProperty)CMProperty.MEMBERS).hasPropertyID()) {
            membershipQueryWhere = membershipQueryWhere + "o.PROPID=" + ((CMDbProperty)CMProperty.MEMBERS).getPropertyID() + " and ";
        }
        initialSubQueryPrefix = "select p.CMID from " + objIDCol.getTable() + " p where ";
        initialSubQueryPrefix = CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive() ? initialSubQueryPrefix + "UPPER(p." + objIDCol.getName() + ") in (" : initialSubQueryPrefix + "p." + objIDCol.getName() + " in (";
    }

    public static void initTenantMembersQuery() {
        tenantMembershipQueryWhere = " where ";
        if (((CMDbProperty)CMProperty.TENANTMEMBERS).hasPropertyID()) {
            tenantMembershipQueryWhere = tenantMembershipQueryWhere + "o.PROPID=" + ((CMDbProperty)CMProperty.TENANTMEMBERS).getPropertyID() + " and ";
        }
        CMDbColumn tenantIDCol = ((CMDbProperty)CMProperty.TENANTID).getColumn(0);
        tenantSubQueryPrefix = "select p.CMID from " + tenantIDCol.getTable() + " p where p.CLASSID=" + CMObjectClass.TENANT.getID() + " and p." + tenantIDCol.getName() + " in(select n.TENANTID from CMTENANTID n where ";
        tenantSubQueryPrefix = CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive() ? tenantSubQueryPrefix + "UPPER(n.TENANTNAME) in (" : tenantSubQueryPrefix + "n.TENANTNAME in (";
    }

    private static CMDbColumn getMEMBERSColumn() {
        return ((CMDbProperty)CMProperty.MEMBERS).getColumn(0);
    }

    private static CMDbColumn getIDColumn() {
        return ((CMDbProperty)CMProperty.ID).getColumn(0);
    }

    protected static void addParameterToInClause(StringBuilder inClause, boolean isFirst, CMDbConnection con) {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        if (!isFirst) {
            inClause.append(sqlGenerator.createBindParametersSeparator());
        }
        sqlGenerator.appendCaseSensitiveBindParameterSymbolSql(con.getDbmsIsCaseSensitive(), con.getDbms(), inClause);
    }

    protected static String createMembershipQueryString(List<String> camIDs, int startIndex, int endIndex, CMDbConnection con) {
        StringBuilder initialClause = new StringBuilder(1024);
        initialClause.append(membershipQuerySelect);
        initialClause.append(membershipQueryWhere);
        initialClause.append(membershipColumnName);
        initialClause.append(" in(");
        initialClause.append(initialSubQueryPrefix);
        boolean isFirst = true;
        for (int i = startIndex; i < camIDs.size() && i < endIndex; ++i) {
            CMDbStoreMembership.addParameterToInClause(initialClause, isFirst, con);
            isFirst = false;
        }
        initialClause.append("))");
        return initialClause.toString();
    }

    protected static String createTenantMembershipQueryString(List<String> camIDs, int startIndex, int endIndex, CMDbConnection con) {
        StringBuilder initialClause = new StringBuilder(1024);
        initialClause.append(membershipQuerySelect);
        initialClause.append(tenantMembershipQueryWhere);
        initialClause.append(membershipColumnName);
        initialClause.append(" in(");
        initialClause.append(tenantSubQueryPrefix);
        boolean isFirst = true;
        for (int i = startIndex; i < camIDs.size() && i < endIndex; ++i) {
            CMDbStoreMembership.addParameterToInClause(initialClause, isFirst, con);
            isFirst = false;
        }
        initialClause.append(")))");
        return initialClause.toString();
    }

    private static String extractCAMID(ICMStorePath path) throws CMException {
        String CAMID2 = null;
        CMStorePathStep curStep = path.stepAt(0);
        if (curStep != null && path.size() == 1) {
            if (curStep.bCurrentUser_) {
                CMExecutionContext ctx = CMExecutionContext.get();
                String currentUserSearchPath = ctx.getCurrentUserSearchPath();
                if (currentUserSearchPath != null) {
                    CAMID2 = CMCAMIDHelper.CAMIDFromSearchPath(currentUserSearchPath);
                }
            } else {
                CAMID2 = curStep.getCAMIDLiteral();
            }
        }
        if (CAMID2 == null) {
            String membership = CMConstants.FUNC_MEMBERSHIP_DEF.getName();
            throw new CMException("cmBadFuncArg", new CMException.Parm("Name", membership));
        }
        return CAMID2;
    }

    protected static ArrayList<String> getArgumentCAMIDs(CMStorePathPredicateFunction parsedFunc) throws CMException {
        ArrayList<String> camIDs = new ArrayList<String>();
        ICMStorePath arg = (ICMStorePath)parsedFunc.args.get(0);
        if (arg.isUnion()) {
            for (int i = 0; i < arg.size(); ++i) {
                ICMStorePath path = arg.compoundPathElementAt(i);
                camIDs.add(CMDbStoreMembership.extractCAMID(path));
            }
        } else {
            camIDs.add(CMDbStoreMembership.extractCAMID(arg));
        }
        if (!CMDbStoreMembership.isLookingForAnonymous(camIDs)) {
            camIDs.add("::All Authenticated Users");
        }
        camIDs.add("::Everyone");
        return camIDs;
    }

    private static boolean isLookingForAnonymous(List<String> camIDs) {
        for (String CAMID2 : camIDs) {
            if (!CAMID2.equalsIgnoreCase("::Anonymous")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleObjectIDSet getTenantsForTenantIDs(CMDbStore store, List<String> tenantIDs) throws CMException {
        SimpleObjectIDSet tenantObjectIds = new SimpleObjectIDSet();
        CMDbConnection con = store.getConnection();
        int maxItems = CMDbConnection.getMaxObjectsInline();
        int maxIndex = tenantIDs.size();
        for (int startIndex = 0; startIndex < maxIndex; startIndex += maxItems) {
            int endIndex = startIndex + maxItems;
            if (endIndex > tenantIDs.size()) {
                endIndex = tenantIDs.size();
            }
            String stmtStr = CMDbStoreMembership.createTenantMembershipQueryString(tenantIDs, startIndex, endIndex, con);
            PreparedStatement stmt = null;
            try {
                stmt = con.prepareStatement(stmtStr);
                for (int bindIdx = 1; bindIdx <= endIndex - startIndex; ++bindIdx) {
                    stmt.setString(bindIdx, tenantIDs.get(bindIdx - 1 + startIndex));
                }
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    int objectID = rs.getInt(1);
                    int objectClassID = CMDbStoreMembership.getObjectClass(store, objectID);
                    int tenantId = store.getCache().CMCacheGetTenantID(objectID);
                    if (!CMExecutionContext.get().canSeeObjectsWithTenantId(tenantId) || objectClassID != CMObjectClass.TENANT.getID()) continue;
                    tenantObjectIds.add(objectID);
                }
            }
            catch (SQLException ex) {
                CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmUnexpectedQueryFailure");
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
            int[] newIDs = tenantObjectIds.toArray();
            int oldIDsSize = 0;
            while (newIDs.length > 0 && oldIDsSize < tenantObjectIds.size()) {
                oldIDsSize = tenantObjectIds.size();
                newIDs = CMDbStoreMembership.findMoreTenantMembers(store, newIDs);
                for (int i = 0; i < newIDs.length; ++i) {
                    tenantObjectIds.add(newIDs[i]);
                }
            }
        }
        return tenantObjectIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] findMoreTenantMembers(CMDbStore store, int[] CMIDs) throws CMException {
        if (CMIDs.length <= 0) {
            return new int[0];
        }
        SimpleObjectIDSet ids = new SimpleObjectIDSet();
        StringBuilder buffer = new StringBuilder(1024);
        CMDbConnection con = store.getConnection();
        CMDbStoreDMLDef dmlDefIn = new CMDbStoreDMLDef("");
        CMDbStoreDMLDef.CMDbStoreWhereCMIDsInfo whereCMIDsInfoIn = null;
        try {
            whereCMIDsInfoIn = dmlDefIn.constructWhereCMIDs(con, CMIDs, membershipColumnName, true, true);
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmErrQueryMembership");
        }
        buffer.append(membershipQuerySelect);
        buffer.append(whereCMIDsInfoIn.fromClause_);
        buffer.append(tenantMembershipQueryWhere);
        buffer.append(whereCMIDsInfoIn.whereClause_);
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(buffer.toString());
            int bindIdx = 1;
            bindIdx = CMDbStoreDMLDef.bindWhereCMIDsInfo(bindIdx, stmt, CMIDs, whereCMIDsInfoIn);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int objectID = rs.getInt(1);
                int objectClassID = CMDbStoreMembership.getObjectClass(store, objectID);
                int tenantId = store.getCache().CMCacheGetTenantID(objectID);
                if (!CMExecutionContext.get().canSeeObjectsWithTenantId(tenantId) || objectClassID != CMObjectClass.TENANT.getID()) continue;
                ids.add(objectID);
            }
        }
        catch (SQLException ex) {
            try {
                CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmUnexpectedQueryFailure");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        return ids.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleObjectIDSet getGroupAndRolesForCAMIDs(List<String> camIDs, CMDbStore store) throws CMException {
        SimpleObjectIDSet groupRoleObjects = new SimpleObjectIDSet();
        MembershipValidator validator = new MembershipValidator(store);
        CMDbConnection con = store.getConnection();
        int maxItems = CMDbConnection.getMaxObjectsInline();
        int maxIndex = camIDs.size();
        for (int startIndex = 0; startIndex < maxIndex; startIndex += maxItems) {
            int endIndex = startIndex + maxItems;
            if (endIndex > camIDs.size()) {
                endIndex = camIDs.size();
            }
            String stmtStr = CMDbStoreMembership.createMembershipQueryString(camIDs, startIndex, endIndex, store.getConnection());
            PreparedStatement stmt = null;
            try {
                stmt = con.prepareStatement(stmtStr);
                for (int bindIdx = 1; bindIdx <= endIndex - startIndex; ++bindIdx) {
                    stmt.setString(bindIdx, camIDs.get(bindIdx - 1 + startIndex));
                }
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    int objectID = rs.getInt(1);
                    if (!validator.isValidObject(objectID)) continue;
                    groupRoleObjects.add(objectID);
                }
            }
            catch (SQLException ex) {
                CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmUnexpectedQueryFailure");
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
            int[] newIDs = groupRoleObjects.toArray();
            int oldGroupSize = 0;
            while (newIDs.length > 0 && oldGroupSize < groupRoleObjects.size()) {
                oldGroupSize = groupRoleObjects.size();
                newIDs = CMDbStoreMembership.findMoreGroupsAndRoles(store, validator, newIDs);
                for (int i = 0; i < newIDs.length; ++i) {
                    groupRoleObjects.add(newIDs[i]);
                }
            }
        }
        boolean lookingForAnonymous = CMDbStoreMembership.isLookingForAnonymous(camIDs);
        groupRoleObjects.add(store.getInternalIdFromCAMID("::Everyone"));
        if (!lookingForAnonymous) {
            groupRoleObjects.add(store.getInternalIdFromCAMID("::All Authenticated Users"));
        }
        return groupRoleObjects;
    }

    protected static boolean isMultitenancyEnabled(CMDbStore store) {
        TenantRegistry registry = store.getTenantRegistry();
        return registry.getTenantCount() > 1;
    }

    private static SimpleObjectIDSet getGroupsAndRolesCMIDs(CMStorePathPredicateFunction parsedFunc, CMDbStore store) throws CMException {
        ArrayList<String> camIDs = CMDbStoreMembership.getArgumentCAMIDs(parsedFunc);
        return CMDbStoreMembership.getGroupAndRolesForCAMIDs(camIDs, store);
    }

    public static CMStoreQueryResults execute(CMStorePathPredicateFunction parsedFunc, CMDbStore store, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission) throws CMException {
        SimpleObjectIDSet groupRoleObjects = CMDbStoreMembership.getGroupsAndRolesCMIDs(parsedFunc, store);
        return CMDbStoreMembership.getMembershipQueryResults(store, properties, orderBy, operation, permissions, extraPermission, groupRoleObjects);
    }

    public static CMStoreQueryResults getMembershipQueryResults(CMDbStore store, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission, SimpleObjectIDSet groupRoleObjects) throws CMException, CMStoreUnexpected {
        int[] foundObjects = groupRoleObjects.toArray();
        CMDbStoreCacheQueryResults results = null;
        try {
            results = new CMDbStoreCacheQueryResults(store, foundObjects, null, properties, orderBy, operation, permissions, CMExecutionContext.get().getAccManPassportID(), extraPermission);
            results.setIsMembershipQuery();
        }
        catch (CMCacheException e) {
            throw new CMStoreUnexpected(e, "cmStoreUnexpected");
        }
        catch (CMCacheAccessDenied e) {
            CMDbStoreSecurityUtil.convertAccessDeniedException(store.getCache(), e);
        }
        return results;
    }

    private static int getObjectClass(CMDbStore store, int objectID) throws CMException {
        try {
            return store.getCache().CMCacheGetClass(objectID);
        }
        catch (CMCacheException ex) {
            throw new CMStoreUnexpected(ex, "cmStoreUnexpectedNoObjectClass");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] findMoreGroupsAndRoles(CMDbStore store, MembershipValidator validator, int[] CMIDs) throws CMException {
        if (CMIDs.length <= 0) {
            return new int[0];
        }
        SimpleObjectIDSet ids = new SimpleObjectIDSet();
        StringBuilder buffer = new StringBuilder(1024);
        CMDbConnection con = store.getConnection();
        CMDbStoreDMLDef dmlDefIn = new CMDbStoreDMLDef("");
        CMDbStoreDMLDef.CMDbStoreWhereCMIDsInfo whereCMIDsInfoIn = null;
        try {
            whereCMIDsInfoIn = dmlDefIn.constructWhereCMIDs(con, CMIDs, membershipColumnName, true, true);
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmErrQueryMembership");
        }
        buffer.append(membershipQuerySelect);
        buffer.append(whereCMIDsInfoIn.fromClause_);
        buffer.append(membershipQueryWhere);
        buffer.append(whereCMIDsInfoIn.whereClause_);
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(buffer.toString());
            int bindIdx = 1;
            bindIdx = CMDbStoreDMLDef.bindWhereCMIDsInfo(bindIdx, stmt, CMIDs, whereCMIDsInfoIn);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int objectID = rs.getInt(1);
                if (!validator.isValidObject(objectID)) continue;
                ids.add(objectID);
            }
        }
        catch (SQLException ex) {
            try {
                CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmUnexpectedQueryFailure");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        return ids.toArray();
    }

    public static class SimpleObjectIDSet {
        private HashSet<Integer> idSet = new HashSet(1024);

        boolean add(int objectID) {
            if (this.idSet.contains(objectID)) {
                return false;
            }
            this.idSet.add(objectID);
            return true;
        }

        public int size() {
            return this.idSet.size();
        }

        public int[] toArray() {
            int size = this.idSet.size();
            int[] retArray = new int[size];
            int index = 0;
            for (Integer i : this.idSet) {
                retArray[index++] = i;
            }
            return retArray;
        }
    }

    private static class MembershipValidator {
        private CMDbStore store;
        private boolean isMultitenancyEnabled;
        private CMExecutionContext context;

        public MembershipValidator(CMDbStore store) {
            this.store = store;
            this.isMultitenancyEnabled = CMDbStoreMembership.isMultitenancyEnabled(store);
            this.context = CMExecutionContext.get();
        }

        public boolean isValidObject(int objectId) throws CMException {
            int classId = CMDbStoreMembership.getObjectClass(this.store, objectId);
            return this.isGroupOrRole(classId) && this.canTenantSeeObject(objectId) && this.isCognosObject(objectId);
        }

        private boolean isGroupOrRole(int classId) {
            return classId == CMObjectClass.GROUP.getID() || classId == CMObjectClass.ROLE.getID();
        }

        private boolean canTenantSeeObject(int objectID) {
            if (!this.isMultitenancyEnabled) {
                return true;
            }
            int tenantID = this.store.getCache().CMCacheGetTenantID(objectID);
            return this.context.canSeeObjectsWithTenantId(tenantID);
        }

        private boolean isCognosObject(int objId) throws CMCacheException {
            CMCache cache = this.store.getCache();
            if (cache.CMCacheIsObjectExternal(objId)) {
                String secRef = cache.CMCacheGetSecurityReference(objId);
                return secRef.startsWith("CAMID(\"::");
            }
            return true;
        }
    }
}

