/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbObjectClass;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class CMDbStoreMetadataUtil {
    private static TreeMap<String, SortedSet<String>> classesMap_;
    private static TreeMap<String, SortedSet<String>> tablesMap_;
    private static List<String> propertyTables_;
    private static boolean initialized;

    private static synchronized void init() {
        classesMap_ = CMDbStoreMetadataUtil.createClassesMap();
        tablesMap_ = CMDbStoreMetadataUtil.createTablesMap(classesMap_);
        propertyTables_ = CMDbStoreMetadataUtil.createPropertyTablesList(tablesMap_);
        initialized = true;
    }

    private static TreeMap<String, SortedSet<String>> createClassesMap() {
        TreeMap<String, SortedSet<String>> classesMap = new TreeMap<String, SortedSet<String>>();
        for (CMObjectClass cls : CMDbStoreFactory.getObjectClasses().getAllClasses()) {
            classesMap.put(String.valueOf(cls.getID()), ((CMDbObjectClass)cls).getTables());
        }
        return classesMap;
    }

    private static TreeMap<String, SortedSet<String>> createTablesMap(TreeMap<String, SortedSet<String>> classes) {
        TreeMap<String, SortedSet<String>> result = new TreeMap<String, SortedSet<String>>();
        for (Map.Entry<String, SortedSet<String>> entry : classes.entrySet()) {
            String classId = entry.getKey();
            for (String tableName : entry.getValue()) {
                SortedSet<String> classesSet = result.get(tableName);
                if (classesSet == null) {
                    classesSet = new TreeSet<String>();
                    result.put(tableName, classesSet);
                }
                classesSet.add(classId);
            }
        }
        return result;
    }

    private static ArrayList<String> createPropertyTablesList(TreeMap<String, SortedSet<String>> tables) {
        ArrayList<String> result = new ArrayList<String>(tables.size());
        for (String tableName : tables.keySet()) {
            if (!CMDbStoreMetadataUtil.containsCMIDColumn(tableName) || tableName.equals("CMOBJECTS")) continue;
            result.add(tableName);
        }
        return result;
    }

    public static boolean containsCMIDColumn(String sTableName) {
        return !sTableName.equals("CMCLASSES");
    }

    public static Map<String, SortedSet<String>> getClassesMap() throws CMConfigurationException {
        if (!initialized) {
            CMDbStoreMetadataUtil.init();
        }
        return classesMap_;
    }

    public static Map<String, SortedSet<String>> getTablesMap() throws CMConfigurationException {
        if (!initialized) {
            CMDbStoreMetadataUtil.init();
        }
        return tablesMap_;
    }

    public static List<String> getPropertyTablesList() throws CMConfigurationException {
        if (!initialized) {
            CMDbStoreMetadataUtil.init();
        }
        return propertyTables_;
    }

    public static final CMDbProperty parseProperty(CMStore store, String propertyDef) throws CMException {
        if (!(store instanceof CMDbStore)) {
            throw new IllegalStateException("Failed to get database connection");
        }
        CMDbConnection con = ((CMDbStore)store).getConnection();
        try {
            return new CMDbProperty(con.getConnection(), propertyDef);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to parse property");
        }
    }

    static {
        initialized = false;
    }
}

