/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreTransactionAction;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheException;
import java.util.ArrayList;

public class CMDbStoreMoveCacheObjects
implements CMDbStoreTransactionAction {
    CMDbStore store_;
    int[] objectsMoved_;
    int parent_objid_;
    CMDbStoreLocalizedStringArray newName_;

    CMDbStoreMoveCacheObjects(CMDbStore store, int[] objectsMoved, int parent_objid, CMDbStoreLocalizedStringArray newName) {
        this.store_ = store;
        this.objectsMoved_ = objectsMoved;
        this.newName_ = newName;
        this.parent_objid_ = parent_objid;
    }

    @Override
    public void commit() {
        CMCache cache = this.store_.getCache();
        try {
            for (int i = 0; i < this.objectsMoved_.length; ++i) {
                if (this.newName_ != null) {
                    ArrayList<String> namesForCache = new ArrayList<String>();
                    ArrayList<Integer> localesForCache = new ArrayList<Integer>();
                    int strCount = this.newName_.getSize();
                    for (int strIdx = 0; strIdx != strCount; ++strIdx) {
                        CMDbStoreLocalizedString str = (CMDbStoreLocalizedString)this.newName_.get(strIdx);
                        namesForCache.add(str.getValue());
                        localesForCache.add(new Integer(str.getLocaleIDForCache()));
                    }
                    cache.CMCacheSetAllNames(this.objectsMoved_[i], namesForCache, localesForCache);
                }
                cache.CMCacheUpdateIntProperty(this.objectsMoved_[i], 5, this.parent_objid_);
            }
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException(e, "cmErrCommitMoveOp");
            CMIndications.logException(cmex);
        }
    }

    @Override
    public void rollback() {
    }
}

