/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheQueryResults;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStoreObjects;
import com.cognos.cm.dbstore.CMDbStoreSelectDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreCompoundResults;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.ICMStorePath;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class CMDbStoreMultiCacheComplexQueryResults
implements CMStoreCompoundResults {
    private CMDbStore store_;
    private OrderByField[] orderBy;
    private boolean bFixed = false;
    private List<CMDbStoreCacheQueryResults> resultSets;
    private int curResultIdx = -1;
    private CMDbStoreCacheQueryResults curResult;
    private int[] dbOrder_;
    private int idx_;
    private HashMap<Integer, Integer> duplicates;
    private int size_;
    private int[] candidates;

    public CMDbStoreMultiCacheComplexQueryResults(CMDbStore store, OrderByField[] orderBy) throws CMException {
        this.store_ = store;
        this.resultSets = new ArrayList<CMDbStoreCacheQueryResults>();
        this.orderBy = orderBy;
    }

    @Override
    public void add(ICMStorePath queryPath, CMStoreQueryResults results) throws CMException {
        if (this.bFixed) {
            throw new IllegalStateException("Attempted to add results to a closed result set");
        }
        if (!(results instanceof CMDbStoreCacheQueryResults)) {
            throw new CMException("cmBadCompoundPath", new CMException.Parm("Path", queryPath.toString()));
        }
        CMDbStoreCacheQueryResults cacheResults = (CMDbStoreCacheQueryResults)results;
        CMDbStoreObjects objects = cacheResults.getObjects();
        if (objects == null || !cacheResults.next()) {
            results.release();
            return;
        }
        int[] ids = objects.getObjectIDs();
        this.size_ += ids.length;
        this.resultSets.add(cacheResults);
    }

    @Override
    public void fixate() throws CMException {
        if (this.bFixed) {
            return;
        }
        this.bFixed = true;
        if (this.resultSets.size() > 1) {
            this.mergeIds();
            this.removeDuplicates();
            this.fillCandidates();
            this.sortObjects();
        }
    }

    private void mergeIds() {
        this.dbOrder_ = new int[this.size_];
        int offset = 0;
        for (CMDbStoreCacheQueryResults rs : this.resultSets) {
            int[] ids = rs.getObjects().getObjectIDs();
            System.arraycopy(ids, 0, this.dbOrder_, offset, ids.length);
            offset += ids.length;
        }
    }

    private void fillCandidates() throws CMException {
        this.candidates = new int[this.resultSets.size()];
        for (int i = 0; i < this.resultSets.size(); ++i) {
            CMDbStoreCacheQueryResults rs = this.resultSets.get(i);
            int cmid = this.getObjectID(rs);
            if (cmid != -1) {
                this.candidates[i] = cmid;
                continue;
            }
            rs.release();
            this.resultSets.remove(i);
            --i;
        }
        if (this.candidates.length != this.resultSets.size()) {
            this.candidates = this.trimArray(this.candidates, this.resultSets.size());
        }
    }

    private int getObjectID(CMDbStoreCacheQueryResults rs) throws CMException {
        do {
            int cmid = rs.getObjectID();
            if (this.duplicates != null && this.isDuplicate(cmid)) continue;
            return cmid;
        } while (rs.next());
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortObjects() throws CMException {
        CMProperty[] props = new CMDbProperty[this.orderBy.length];
        for (int i = 0; i < this.orderBy.length; ++i) {
            props[i] = this.orderBy[i].property;
        }
        CMDbConnection con = this.store_.getConnection();
        CMDbStoreSelectDef stmt = new CMDbStoreSelectDef(con, null, props, this.orderBy);
        ResultSet rs = null;
        CMDbStore.ReadTransactionHandle rtHandle = null;
        try {
            if (stmt.retrievingLobs()) {
                rtHandle = this.store_.beginReadTransaction();
            }
            rs = stmt.execute(con, this.dbOrder_);
            int i = 0;
            while (rs.next()) {
                this.dbOrder_[i] = rs.getInt(1);
                ++i;
            }
        }
        catch (SQLException e) {
            try {
                CMDbStoreExceptionUtil.handleSQLException(con, e, "cmUnexpectedResultProcessingFailure");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
                CMDbStore.releaseReadTransaction(rtHandle);
                throw throwable;
            }
            CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
            CMDbStore.releaseReadTransaction(rtHandle);
        }
        CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
        CMDbStore.releaseReadTransaction(rtHandle);
    }

    private boolean isDuplicate(int cmid) {
        Integer objCount = this.duplicates.get(cmid);
        if (objCount == null) {
            return false;
        }
        if (objCount == 1) {
            this.duplicates.remove(cmid);
            if (this.duplicates.isEmpty()) {
                this.duplicates = null;
            }
        } else {
            this.duplicates.put(cmid, objCount - 1);
        }
        return true;
    }

    private void removeDuplicates() {
        Arrays.sort(this.dbOrder_);
        int deleted = 0;
        for (int i = this.dbOrder_.length - 1; i > 0; --i) {
            int start = i;
            int cmid = this.dbOrder_[i];
            while (cmid == this.dbOrder_[i - 1] && --i > 0) {
            }
            if (start == i) continue;
            System.arraycopy(this.dbOrder_, start, this.dbOrder_, i, this.dbOrder_.length - deleted - start);
            int deletedNow = start - i;
            deleted += deletedNow;
            if (this.duplicates == null) {
                this.duplicates = new HashMap();
            }
            this.duplicates.put(cmid, deletedNow);
        }
        if (deleted != 0) {
            this.dbOrder_ = this.trimArray(this.dbOrder_, this.dbOrder_.length - deleted);
        }
    }

    private int[] trimArray(int[] array, int size) {
        int[] tmp = new int[size];
        System.arraycopy(array, 0, tmp, 0, size);
        return tmp;
    }

    private boolean dropCurrentResult() {
        this.curResult.release();
        this.curResult = null;
        this.resultSets.remove(this.curResultIdx);
        if (this.resultSets.isEmpty()) {
            return false;
        }
        int[] temp = new int[this.candidates.length - 1];
        if (this.curResultIdx != 0) {
            System.arraycopy(this.candidates, 0, temp, 0, this.curResultIdx);
        }
        if (this.curResultIdx != this.candidates.length - 1) {
            System.arraycopy(this.candidates, this.curResultIdx + 1, temp, this.curResultIdx, temp.length - this.curResultIdx);
        }
        this.candidates = temp;
        return true;
    }

    private int findResultSet(int cmid) {
        if (cmid < 0) {
            return -1;
        }
        for (int i = 0; i < this.candidates.length; ++i) {
            if (cmid != this.candidates[i]) continue;
            return i;
        }
        return -1;
    }

    private boolean advanceCurrent() throws CMException {
        int cmid;
        if (this.curResult == null) {
            return true;
        }
        boolean drop = true;
        if (this.curResult.next() && (cmid = this.getObjectID(this.curResult)) != -1) {
            this.candidates[this.curResultIdx] = cmid;
            drop = false;
        }
        return drop ? this.dropCurrentResult() : true;
    }

    @Override
    public boolean next() throws CMException {
        if (!this.bFixed || this.resultSets.isEmpty()) {
            return false;
        }
        if (this.dbOrder_ == null) {
            if (this.curResult == null) {
                this.curResult = this.resultSets.get(0);
                return true;
            }
            return this.curResult.next();
        }
        if (!this.advanceCurrent()) {
            return false;
        }
        while (this.idx_ < this.dbOrder_.length && this.dbOrder_[this.idx_] < 0) {
            ++this.idx_;
        }
        for (int i = this.idx_; i < this.dbOrder_.length; ++i) {
            this.curResultIdx = this.findResultSet(this.dbOrder_[i]);
            if (this.curResultIdx == -1) continue;
            this.curResult = this.resultSets.get(this.curResultIdx);
            if (i != this.idx_) {
                this.dbOrder_[i] = -this.dbOrder_[i];
            } else {
                ++this.idx_;
            }
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(int index) throws CMException {
        return this.curResult.getValue(index);
    }

    @Override
    public Object getValue(CMProperty prop) throws CMException {
        return this.curResult.getValue(prop);
    }

    @Override
    public boolean wasAcquired() {
        return this.curResult.wasAcquired();
    }

    @Override
    public int getObjectID() {
        return this.curResult.getObjectID();
    }

    @Override
    public String getPath() {
        return this.curResult.getPath();
    }

    @Override
    public String getSearchPath() {
        return this.curResult.getSearchPath();
    }

    @Override
    public String getParentSearchPath() {
        return this.curResult.getParentSearchPath();
    }

    @Override
    public int getParentObjectID() {
        return this.curResult.getParentObjectID();
    }

    @Override
    public int getTenantID() {
        return this.curResult.getTenantID();
    }

    @Override
    public String getSecurityReference() {
        return this.curResult.getSecurityReference();
    }

    @Override
    public CMAncestors getAncestors() {
        return this.curResult.getAncestors();
    }

    @Override
    public String getName() {
        return this.curResult.getName();
    }

    @Override
    public CMObjectClass getObjectClass() {
        return this.curResult.getObjectClass();
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.curResult.hasPermission(permission);
    }

    @Override
    public boolean hasExternalProperty(CMProperty property) {
        return this.curResult.hasExternalProperty(property);
    }

    @Override
    public int getState() {
        return this.curResult.getState();
    }

    @Override
    public void exclude() {
        this.curResult.exclude();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void release() {
        for (CMStoreQueryResults cMStoreQueryResults : this.resultSets) {
            cMStoreQueryResults.release();
        }
        this.resultSets.clear();
        this.curResult = null;
        this.idx_ = -1;
        this.curResultIdx = -1;
    }

    @Override
    public void rewind() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsRewind() {
        return false;
    }

    @Override
    public boolean supportsSkipObjects() {
        return false;
    }

    @Override
    public CMStore getStore() {
        return this.store_;
    }
}

