/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.ICMDbStoreMultipleCMsUtil;
import com.cognos.cm.dbstore.binders.CMDbStoreStringBinder;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.properties.CMPropertySets;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMDeferredInitActionUtils;
import com.cognos.cm.util.CMMethodInvoker;
import com.cognos.cm.util.UrlUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class CMDbStoreMultipleCMsUtil
implements ICMDbStoreMultipleCMsUtil {
    public static final Double DEFAULT_ACTIVE_CM_CAPACITY = new Double("1.0E+30");
    public static final int USAGE_CAPACITY = 1;
    public static final int USAGE_NEGOTIATION = 2;
    public static final int USAGE_ACTIVATEREQUEST = 3;
    public static final int USAGE_LOCK = 4;
    public static final int USAGE_HEARTBEAT = 5;
    public static ICMDbStoreMultipleCMsUtil instance = new CMDbStoreMultipleCMsUtil();

    public static ICMDbStoreMultipleCMsUtil getInstance() {
        return instance;
    }

    @Override
    public boolean lockDatabase(CMDbConnection con, boolean suspended) throws CMException {
        boolean bCanLockDB = false;
        Statement stmt = null;
        Statement delStmt = null;
        try {
            String serverName = null;
            IConfiguration config = ConfigurationFactory.getConfig();
            serverName = config.getCognosProp("localCMURL");
            if (serverName == null) {
                boolean bl = false;
                return bl;
            }
            serverName = UrlUtils.convertURItoDispatcherPath(serverName, true, false);
            int num = 0;
            StringBuffer updateStmt = new StringBuffer();
            updateStmt.append("update CMCAPACITY set CMPATH=?, CAPACITY=? where USAGE=4 and (CMPATH=? or CMPATH=? or CMPATH IS NULL)");
            String sqlString = updateStmt.toString();
            con.beginTransaction();
            stmt = con.prepareStatement(sqlString);
            CMDbStoreStringBinder.bind((PreparedStatement)stmt, 1, serverName);
            if (suspended) {
                stmt.setDouble(2, -1.0);
            } else {
                stmt.setDouble(2, 0.0);
            }
            CMDbStoreStringBinder.bind((PreparedStatement)stmt, 3, new String(""));
            CMDbStoreStringBinder.bind((PreparedStatement)stmt, 4, serverName);
            num = CMDbConnection.executeUpdate((PreparedStatement)stmt);
            if (num > 0) {
                bCanLockDB = true;
                delStmt = con.createStatement();
                CMDbConnection.executeUpdate(delStmt, "DELETE from CMCAPACITY where USAGE=3 or USAGE=2");
            }
            con.commitTransaction();
        }
        catch (SQLException ex) {
            this.throwSQLException(con, ex, "cmFailedToLockDB");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedToLockDB");
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {}
            }
            if (delStmt != null) {
                try {
                    delStmt.close();
                    delStmt = null;
                }
                catch (SQLException ex) {}
            }
        }
        return bCanLockDB;
    }

    @Override
    public boolean updateNegotiatedActiveCM(CMDbConnection lockConnection, String pathNoProtocol) throws CMException {
        boolean bUpdated = false;
        PreparedStatement stmt = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            lockConnection.beginTransaction();
            stmt = lockConnection.prepareStatement("UPDATE CMCAPACITY SET CMPATH=?, CAPACITY=(SELECT max(CAPACITY) FROM CMCAPACITY WHERE CMPATH=? AND (USAGE=1 or USAGE=0)) WHERE USAGE = 2 AND (CAPACITY IS NULL OR CAPACITY < (SELECT max(CAPACITY) FROM CMCAPACITY WHERE CMPATH=? AND (USAGE=1 or USAGE=0)))");
            CMDbStoreStringBinder.bind(stmt, 1, pathNoProtocol);
            CMDbStoreStringBinder.bind(stmt, 2, pathNoProtocol);
            CMDbStoreStringBinder.bind(stmt, 3, pathNoProtocol);
            int numberOfUpdatedRows = stmt.executeUpdate();
            stmt.close();
            stmt = null;
            if (numberOfUpdatedRows > 0) {
                bUpdated = true;
            } else {
                statement = lockConnection.createStatement();
                rs = statement.executeQuery("select count(*) from CMCAPACITY where USAGE=2");
                if (rs.next() && rs.getInt(1) <= 0) {
                    stmt = CMDbConnection.dbms_ == 3 ? lockConnection.prepareStatement("INSERT into CMCAPACITY(CMPATH, CAPACITY, USAGE) select cast(? as varchar(3220)), max(CAPACITY), cast(2 as smallint) FROM CMCAPACITY WHERE CMPATH=? AND (USAGE=1 or USAGE=0)") : (CMDbConnection.dbms_ == 8 ? lockConnection.prepareStatement("INSERT into CMCAPACITY(CMPATH, CAPACITY, USAGE) select cast(? as lvarchar(3220)), max(CAPACITY), cast(2 as smallint) FROM CMCAPACITY WHERE CMPATH=? AND (USAGE=1 or USAGE=0)") : lockConnection.prepareStatement("INSERT into CMCAPACITY(CMPATH, CAPACITY, USAGE) select ?, max(CAPACITY), 2 FROM CMCAPACITY WHERE CMPATH=? AND (USAGE=1 or USAGE=0)"));
                    CMDbStoreStringBinder.bind(stmt, 1, pathNoProtocol);
                    CMDbStoreStringBinder.bind(stmt, 2, pathNoProtocol);
                    numberOfUpdatedRows = stmt.executeUpdate();
                    stmt.close();
                    stmt = null;
                    if (numberOfUpdatedRows > 0) {
                        bUpdated = true;
                    }
                }
                rs.close();
                rs = null;
                statement.close();
                statement = null;
                if (!bUpdated) {
                    stmt = lockConnection.prepareStatement("select count(*) from CMCAPACITY where CMPATH=? and (USAGE=0 or USAGE=1)");
                    CMDbStoreStringBinder.bind(stmt, 1, pathNoProtocol);
                    rs = stmt.executeQuery();
                    if (rs.next() && rs.getInt(1) <= 0) {
                        stmt.close();
                        stmt = lockConnection.prepareStatement("INSERT into CMCAPACITY(CMPATH, CAPACITY, USAGE) values (?, 0, 2 ) ");
                        CMDbStoreStringBinder.bind(stmt, 1, pathNoProtocol);
                        numberOfUpdatedRows = stmt.executeUpdate();
                        stmt.close();
                        stmt = null;
                        if (numberOfUpdatedRows > 0) {
                            bUpdated = true;
                        }
                    }
                }
            }
            lockConnection.commitTransaction();
        }
        catch (SQLException ex) {
            this.throwSQLException(lockConnection, ex, "cmFailedNegotiate");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedNegotiate");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException ex) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException ex) {}
            }
            if (lockConnection.inTransaction()) {
                try {
                    lockConnection.rollbackTransaction();
                }
                catch (SQLException ex) {}
            }
        }
        return bUpdated;
    }

    @Override
    public String getNegotiatedActiveCM(CMDbConnection lockConnection) throws CMException {
        String negotiatedPath = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = lockConnection.createStatement();
            rs = stmt.executeQuery("SELECT CMPATH FROM CMCAPACITY WHERE USAGE=2");
            if (rs.next()) {
                boolean index = true;
                negotiatedPath = (String)CMDbStoreStringBinder.get(rs, 1);
            }
        }
        catch (SQLException ex) {
            this.throwSQLException(lockConnection, ex, "cmFailedNegotiate");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedNegotiate");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {}
            }
        }
        return negotiatedPath;
    }

    @Override
    public String getRequestedActiveCM(CMDbConnection lockConnection) throws CMException {
        String requestedPath = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = lockConnection.createStatement();
            rs = stmt.executeQuery("SELECT CMPATH FROM CMCAPACITY WHERE USAGE=3");
            if (rs.next()) {
                boolean index = true;
                requestedPath = (String)CMDbStoreStringBinder.get(rs, 1);
            }
        }
        catch (SQLException ex) {
            this.throwSQLException(lockConnection, ex, "cmFailedNegotiate");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedNegotiate");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {}
            }
        }
        return requestedPath;
    }

    @Override
    public String getHighestCapacityCM(CMDbConnection lockConnection) throws CMException {
        String highestCapacityPath = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = lockConnection.createStatement();
            rs = stmt.executeQuery("SELECT CMPATH FROM CMCAPACITY WHERE (USAGE=1 or USAGE=0) and CAPACITY = (SELECT MAX(CAPACITY) from CMCAPACITY where (USAGE=1 or USAGE=0) and CAPACITY IS NOT NULL)");
            if (rs.next()) {
                boolean index = true;
                highestCapacityPath = (String)CMDbStoreStringBinder.get(rs, 1);
            }
        }
        catch (SQLException ex) {
            this.throwSQLException(lockConnection, ex, "cmFailedNegotiate");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedNegotiate");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {}
            }
        }
        return highestCapacityPath;
    }

    @Override
    public boolean setRequestedActiveCM(CMDbConnection lockConnection, String pathNoProtocol) throws CMException {
        boolean bUpdated = false;
        Statement stmt = null;
        Statement delStmt = null;
        try {
            lockConnection.beginTransaction();
            delStmt = lockConnection.createStatement();
            delStmt.execute("DELETE from CMCAPACITY where USAGE=3");
            if (pathNoProtocol != null) {
                stmt = lockConnection.prepareStatement("INSERT into CMCAPACITY(CMPATH, USAGE) values(?, 3)");
                CMDbStoreStringBinder.bind((PreparedStatement)stmt, 1, pathNoProtocol);
                int numberOfUpdatedRows = stmt.executeUpdate();
                if (numberOfUpdatedRows > 0) {
                    bUpdated = true;
                }
            }
            lockConnection.commitTransaction();
        }
        catch (SQLException ex) {
            this.throwSQLException(lockConnection, ex, "cmFailedNegotiate");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedNegotiate");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {}
            }
            if (delStmt != null) {
                try {
                    delStmt.close();
                    delStmt = null;
                }
                catch (SQLException ex) {}
            }
            if (lockConnection.inTransaction()) {
                try {
                    lockConnection.rollbackTransaction();
                }
                catch (SQLException ex) {}
            }
        }
        return bUpdated;
    }

    @Override
    public void addedContententManagerService(CMDbConnection con, int obj_id, String pathWithProtocol, Object capacityObject) throws CMException {
        String pathNoProtocol = UrlUtils.removeProtocol(pathWithProtocol);
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE from CMCAPACITY where CMPATH=? and (USAGE=1 or USAGE=0)");
            CMDbStoreStringBinder.bind(stmt, 1, pathNoProtocol);
            stmt.execute();
            stmt.close();
            stmt = null;
            stmt = con.prepareStatement("INSERT into CMCAPACITY(CMPATH, CAPACITY, USAGE) values(?, ?, 1)");
            CMDbStoreStringBinder.bind(stmt, 1, pathNoProtocol);
            if (capacityObject == null) {
                stmt.setNull(2, 8);
            } else {
                Double doubleObject = new Double(capacityObject.toString());
                stmt.setDouble(2, doubleObject);
            }
            stmt.execute();
            this.makeUniqueDefaultContentManagerService(con, obj_id, pathNoProtocol);
        }
        catch (SQLException ex) {
            this.throwSQLException(con, ex, "cmFailedNegotiate");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedNegotiate");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {}
            }
        }
    }

    @Override
    public void makeUniqueDefaultContentManagerService(CMDbConnection con, int obj_id, String dispatcherPathWithProtocol) throws CMException {
        String pathNoProtocol = UrlUtils.removeProtocol(dispatcherPathWithProtocol);
        Statement defActiveCMStmt = null;
        String updateStmt = null;
        try {
            StringBuffer buffer = new StringBuffer();
            CMDbProperty defaultActiveCMProperty = (CMDbProperty)CMProperty.STARTASACTIVE;
            buffer.append("update ");
            buffer.append(defaultActiveCMProperty.getColumn(0).getTable());
            buffer.append(" set ");
            buffer.append(defaultActiveCMProperty.getColumn(0).getName());
            buffer.append("=? where CMID <> ? and CMID in (select CMID from CMOBJECTS where CLASSID=?) and 0 < (select count(*) from ");
            buffer.append(defaultActiveCMProperty.getColumn(0).getTable());
            buffer.append(" where CMID=? and ");
            buffer.append(defaultActiveCMProperty.getColumn(0).getName());
            buffer.append("=?)");
            updateStmt = buffer.toString();
            defActiveCMStmt = con.prepareStatement(updateStmt);
            defActiveCMStmt.setBoolean(1, Boolean.FALSE);
            defActiveCMStmt.setInt(2, obj_id);
            defActiveCMStmt.setInt(3, CMObjectClass.CONTENTMANAGERSERVICE.getID());
            defActiveCMStmt.setInt(4, obj_id);
            defActiveCMStmt.setBoolean(5, Boolean.TRUE);
            int numRows = defActiveCMStmt.executeUpdate();
            if (numRows > 0) {
                this.updatedDefaultActiveContentManager(con, pathNoProtocol);
            } else {
                defActiveCMStmt.close();
                buffer.setLength(0);
                buffer.append("update ");
                buffer.append(defaultActiveCMProperty.getColumn(0).getTable());
                buffer.append(" set ");
                buffer.append(defaultActiveCMProperty.getColumn(0).getName());
                buffer.append("=? where CMID = ? and 0 = (select count(*) from ");
                buffer.append(defaultActiveCMProperty.getColumn(0).getTable());
                buffer.append(" where ");
                buffer.append(defaultActiveCMProperty.getColumn(0).getName());
                buffer.append("=?)");
                updateStmt = buffer.toString();
                defActiveCMStmt = con.prepareStatement(updateStmt);
                defActiveCMStmt.setBoolean(1, Boolean.TRUE);
                defActiveCMStmt.setInt(2, obj_id);
                defActiveCMStmt.setBoolean(3, Boolean.TRUE);
                numRows = defActiveCMStmt.executeUpdate();
                if (numRows > 0) {
                    this.updatedDefaultActiveContentManager(con, pathNoProtocol);
                }
            }
        }
        catch (SQLException ex) {
            this.throwSQLException(con, ex, "cmFailedNegotiate");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedNegotiate");
        }
        finally {
            if (defActiveCMStmt != null) {
                try {
                    defActiveCMStmt.close();
                    defActiveCMStmt = null;
                }
                catch (SQLException ex) {}
            }
        }
    }

    @Override
    public void makeUniqueDefaultContentManagerService(CMDbConnection con) throws CMException {
        Statement defActiveCMStmt = null;
        ResultSet rs = null;
        String selectStmt = null;
        try {
            StringBuffer buffer = new StringBuffer();
            CMDbProperty defaultActiveCMProperty = (CMDbProperty)CMProperty.STARTASACTIVE;
            CMDbProperty dispatcherPathCMProperty = (CMDbProperty)CMProperty.DISPATCHERPATH;
            buffer.append("select count(*) from ");
            buffer.append(defaultActiveCMProperty.getColumn(0).getTable());
            buffer.append(" where ");
            buffer.append(defaultActiveCMProperty.getColumn(0).getName());
            buffer.append("=?");
            selectStmt = buffer.toString();
            defActiveCMStmt = con.prepareStatement(selectStmt);
            defActiveCMStmt.setBoolean(1, Boolean.TRUE);
            int count = 1;
            rs = defActiveCMStmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            rs = null;
            defActiveCMStmt.close();
            defActiveCMStmt = null;
            if (count == 0) {
                buffer.setLength(0);
                buffer.append("select o.CMID, d.");
                buffer.append(dispatcherPathCMProperty.getColumn(0).getName());
                buffer.append(" from CMOBJECTS o, ");
                buffer.append(dispatcherPathCMProperty.getColumn(0).getTable());
                buffer.append(" d where o.CLASSID=? and d.CMID=o.PCMID and d.");
                buffer.append(dispatcherPathCMProperty.getColumn(0).getName());
                buffer.append(" is not NULL");
                selectStmt = buffer.toString();
                defActiveCMStmt = con.prepareStatement(selectStmt);
                defActiveCMStmt.setInt(1, CMObjectClass.CONTENTMANAGERSERVICE.getID());
                rs = defActiveCMStmt.executeQuery();
                if (rs.next()) {
                    int objID = rs.getInt(1);
                    String dispatcherPath = rs.getString(2);
                    this.makeUniqueDefaultContentManagerService(con, objID, dispatcherPath);
                }
            }
        }
        catch (SQLException ex) {
            this.throwSQLException(con, ex, "cmFailedNegotiate");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedNegotiate");
        }
        finally {
            if (defActiveCMStmt != null) {
                try {
                    defActiveCMStmt.close();
                    defActiveCMStmt = null;
                }
                catch (SQLException ex) {}
            }
        }
    }

    @Override
    public void updatedDispatcherPath(CMDbConnection con, String oldDispatcherPathWithProtocol, String newDispatcherPathWithProtocol) throws CMException {
        String oldPathNoProtocol = UrlUtils.removeProtocol(oldDispatcherPathWithProtocol);
        String newPathNoProtocol = UrlUtils.removeProtocol(newDispatcherPathWithProtocol);
        PreparedStatement updateStmt = null;
        try {
            updateStmt = con.prepareStatement("update CMCAPACITY set CMPATH=? where CMPATH=?");
            CMDbStoreStringBinder.bind(updateStmt, 1, newPathNoProtocol);
            CMDbStoreStringBinder.bind(updateStmt, 2, oldPathNoProtocol);
            CMDbConnection.executeUpdate(updateStmt);
        }
        catch (SQLException ex) {
            this.throwSQLException(con, ex, "cmFailedNegotiate");
        }
    }

    @Override
    public boolean clearAllHeartbeats(CMDbConnection con) throws CMException {
        int rows = 0;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            rows = CMDbConnection.executeUpdate(stmt, "delete from CMCAPACITY where USAGE=5");
        }
        catch (SQLException ex) {
            this.throwSQLException(con, ex, "cmFailedNegotiate");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedNegotiate");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {}
            }
        }
        return rows != 0;
    }

    @Override
    public void setHeartbeat(CMDbConnection con, String cmURI) throws CMException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT into CMCAPACITY(CMPATH, USAGE) values(?, 5)");
            CMDbStoreStringBinder.bind(stmt, 1, cmURI);
            CMDbConnection.executeUpdate(stmt);
        }
        catch (SQLException ex) {
            this.throwSQLException(con, ex, "cmFailedNegotiate");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedNegotiate");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {}
            }
        }
    }

    @Override
    public boolean clearHeartbeat(CMDbConnection con, String cmURI) throws CMException {
        int rows = 0;
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE from CMCAPACITY where CMPATH=? and USAGE=5");
            CMDbStoreStringBinder.bind(stmt, 1, cmURI);
            rows = CMDbConnection.executeUpdate(stmt);
        }
        catch (SQLException ex) {
            this.throwSQLException(con, ex, "cmFailedNegotiate");
        }
        catch (Exception ex) {
            throw new CMConfigurationException((Throwable)ex, "cmFailedNegotiate");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {}
            }
        }
        return rows != 0;
    }

    @Override
    public PreparedStatement createUpdateCapacityStatement(CMDbConnection con) throws CMException {
        PreparedStatement updateStmt = null;
        try {
            updateStmt = con.prepareStatement("update CMCAPACITY set CAPACITY=? where USAGE=1 and CMPATH=?");
        }
        catch (SQLException ex) {
            this.throwSQLException(con, ex, "cmFailedNegotiate");
        }
        return updateStmt;
    }

    @Override
    public void executeUpdateCapacityStatement(PreparedStatement updateStatement, String pathWithProtocol, Double capacity) throws CMException {
        String pathNoProtocol = UrlUtils.removeProtocol(pathWithProtocol);
        try {
            updateStatement.setDouble(1, capacity);
            CMDbStoreStringBinder.bind(updateStatement, 2, pathNoProtocol);
            CMDbConnection.executeUpdate(updateStatement);
        }
        catch (SQLException ex) {
            throw new CMException(ex, "cmFailedNegotiate");
        }
    }

    @Override
    public void executeDeleteCapacityStatement(Statement deleteStatement, int[] dispatcherIds) throws SQLException {
        if (dispatcherIds.length <= 0) {
            return;
        }
        CMDbProperty dispatcherPathProperty = (CMDbProperty)CMProperty.DISPATCHERPATH;
        StringBuffer selectStmt = new StringBuffer();
        selectStmt.append("select ");
        selectStmt.append(dispatcherPathProperty.getColumn(0).getName());
        selectStmt.append(" from ");
        selectStmt.append(dispatcherPathProperty.getColumn(0).getTable());
        selectStmt.append(" where CMID in (");
        for (int i = 0; i < dispatcherIds.length; ++i) {
            if (i > 0) {
                selectStmt.append(",");
            }
            selectStmt.append("?");
        }
        selectStmt.append(") ");
        PreparedStatement stmt = deleteStatement.getConnection().prepareStatement(selectStmt.toString());
        for (int i = 0; i < dispatcherIds.length; ++i) {
            stmt.setInt(i + 1, dispatcherIds[i]);
        }
        ResultSet rs = stmt.executeQuery();
        StringBuffer buffer = null;
        boolean first = true;
        while (rs.next()) {
            String dispatcherPath;
            if (buffer == null) {
                buffer = new StringBuffer();
            }
            if ((dispatcherPath = rs.getString(1)) == null) continue;
            String pathNoProtocol = UrlUtils.removeProtocol(dispatcherPath);
            if (!first) {
                buffer.append(",");
            }
            buffer.append("'");
            buffer.append(pathNoProtocol);
            buffer.append("'");
            first = false;
        }
        if (!first) {
            CMDbConnection.executeUpdate(deleteStatement, "delete from CMCAPACITY where CMPATH in (" + buffer.toString() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseDatabaseLock(CMDbConnection con, String fromServerName, boolean clearSuspended) throws CMException {
        Statement stmt = null;
        try {
            String serverName = fromServerName;
            if (serverName == null) {
                IConfiguration config = ConfigurationFactory.getConfig();
                serverName = config.getCognosProp("localCMURL");
                if (serverName == null) {
                    return;
                }
                serverName = UrlUtils.convertURItoDispatcherPath(serverName, true, false);
            }
            StringBuffer updateStmt = new StringBuffer();
            updateStmt.append("update CMCAPACITY set CMPATH=?");
            if (clearSuspended) {
                updateStmt.append(", CAPACITY=?");
            }
            updateStmt.append(" where USAGE=4");
            updateStmt.append(" and CMPATH=?");
            String sqlString = updateStmt.toString();
            con.beginTransaction();
            stmt = con.prepareStatement(sqlString);
            CMDbStoreStringBinder.bind((PreparedStatement)stmt, 1, new String(""));
            int index = 2;
            if (clearSuspended) {
                stmt.setDouble(index, 0.0);
                ++index;
            }
            CMDbStoreStringBinder.bind((PreparedStatement)stmt, index, serverName);
            CMDbConnection.executeUpdate((PreparedStatement)stmt);
            con.commitTransaction();
        }
        catch (SQLException ex) {
            this.throwSQLException(con, ex, "cmFailedNegotiate");
        }
        catch (Exception exception) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null && con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public String getRunningContentStoreName() {
        String name = null;
        try {
            name = this.getRunningContentStoreName(null);
        }
        catch (Exception ex) {
            CMIndications.logException(ex);
        }
        return name;
    }

    @Override
    public String getRunningContentStoreName(CMDbConnection con) throws CMException {
        String dbServer;
        block25: {
            dbServer = null;
            Statement stmt = null;
            ResultSet rs = null;
            boolean bReleaseConnection = con == null;
            try {
                if (con == null) {
                    con = CMDbStoreFactory.getAdminConnection();
                }
                if ((rs = (stmt = con.createStatement()).executeQuery("select CMPATH from CMCAPACITY where USAGE=4")).next()) {
                    dbServer = (String)CMDbStoreStringBinder.get(rs, 1);
                    if (rs.wasNull()) {
                        dbServer = null;
                    } else if (dbServer != null) {
                        dbServer.trim();
                        if (dbServer.length() == 0) {
                            dbServer = null;
                        }
                    }
                    break block25;
                }
                try {
                    this.checkCMLockConsistency(con);
                }
                catch (CMConfigurationException ex) {
                    throw new CMException(ex, "cmFailedToReadActiveCMURI");
                }
            }
            catch (SQLException ex) {
                CMException exception = CMDbStoreExceptionUtil.analyzeSQLException(con, ex, "cmFailedToReadActiveCMURI");
                throw new CMException(exception, "cmFailedToReadActiveCMURI");
            }
            catch (Exception ex) {
                throw new CMException(ex, "cmFailedToReadActiveCMURI");
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                        rs = null;
                    }
                    catch (SQLException sQLException) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                        stmt = null;
                    }
                    catch (SQLException sQLException) {}
                }
                if (con != null && bReleaseConnection) {
                    CMDbStoreFactory.releaseConnection(con);
                }
            }
        }
        return dbServer;
    }

    private void updatedDefaultActiveContentManager(CMDbConnection con, String pathNoProtocol) throws CMException {
        Statement stmt = null;
        Statement delStmt = null;
        try {
            delStmt = con.createStatement();
            CMDbConnection.executeUpdate(delStmt, "DELETE from CMCAPACITY where USAGE=0");
            if (pathNoProtocol != null) {
                stmt = con.prepareStatement("INSERT into CMCAPACITY(CMPATH, CAPACITY, USAGE) values(?, ?, 0)");
                CMDbStoreStringBinder.bind((PreparedStatement)stmt, 1, pathNoProtocol);
                stmt.setDouble(2, DEFAULT_ACTIVE_CM_CAPACITY);
                stmt.execute();
            }
        }
        catch (SQLException ex) {
            this.throwSQLException(con, ex, "cmFailedNegotiate");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedNegotiate");
        }
        finally {
            if (delStmt != null) {
                try {
                    delStmt.close();
                    delStmt = null;
                }
                catch (SQLException ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {}
            }
        }
    }

    @Override
    public void checkCMLockConsistency(CMDbConnection con) throws CMConfigurationException {
        Statement selStmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        int num = -1;
        try {
            selStmt = con.createStatement();
            rs = selStmt.executeQuery("select count(*) from CMCAPACITY where USAGE=4");
            if (rs != null && rs.next()) {
                num = rs.getInt(1);
            }
            rs.close();
            rs = null;
            if (num > 1) {
                throw new CMConfigurationException("cmFailedToLockDB");
            }
            if (num == 0) {
                con.beginTransaction();
                stmt = con.prepareStatement("insert into CMCAPACITY(CMPATH, CAPACITY, USAGE) values(?,?,?)");
                CMDbStoreStringBinder.bind((PreparedStatement)stmt, 1, new String(""));
                float capacity = 0.0f;
                stmt.setFloat(2, 0.0f);
                int usage = 4;
                stmt.setShort(3, (short)4);
                num = CMDbConnection.executeUpdate((PreparedStatement)stmt);
                if (num != 1) {
                    throw new CMConfigurationException("cmFailedToLockDB");
                }
                con.commitTransaction();
            }
        }
        catch (SQLException ex) {
            throw new CMConfigurationException((Throwable)ex, "cmFailedToLockDB");
        }
        catch (Exception ex) {
            throw new CMConfigurationException((Throwable)ex, "cmFailedToLockDB");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException sQLException) {}
            }
            if (selStmt != null) {
                try {
                    selStmt.close();
                    selStmt = null;
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException sQLException) {}
            }
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    void throwSQLException(CMDbConnection con, SQLException ex, String contextError) throws CMException {
        CMException exception = CMDbStoreExceptionUtil.analyzeSQLException(con, ex, contextError);
        throw new CMException(exception, contextError);
    }

    @Override
    public void activeCMIsSuspended(CMDbConnection con, boolean suspended) throws CMException {
        PreparedStatement stmt = null;
        try {
            con.beginTransaction();
            stmt = con.prepareStatement("update CMCAPACITY set CAPACITY=? where USAGE=4");
            if (suspended) {
                stmt.setDouble(1, -1.0);
            } else {
                stmt.setDouble(1, 0.0);
            }
            con.commitTransaction();
        }
        catch (SQLException ex) {
            this.throwSQLException(con, ex, "cmFailedToLockDB");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedToLockDB");
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {}
            }
        }
    }

    @Override
    public boolean isActiveCMSuspended(CMDbConnection con) throws CMException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select CAPACITY from CMCAPACITY where USAGE=4");
            if (rs.next()) {
                double capacity = rs.getDouble(1);
                if (capacity < 0.0) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException ex) {
            this.throwSQLException(con, ex, "cmFailedToLockDB");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedToLockDB");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {}
            }
        }
        return false;
    }

    @Override
    public void resetDispatcherState() throws CMException {
        try {
            CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreMultipleCMsUtil.class.getDeclaredMethod("updateDispatcherRunningState", null), null), "POSTINITACTIONS", null);
        }
        catch (Exception ex) {
            throw new CMStoreUnexpected(ex, "cmUnexpectedError");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDispatcherRunningState() {
        try {
            CMStoreQueryResults results = null;
            CMDbStore store = (CMDbStore)CMExecutionContext.get().getStore();
            try {
                store.beginTransaction();
                CMStoreXPath updateObjPath = new CMStoreXPath("/configuration//dispatcher");
                results = store.executeQuery(updateObjPath, null, null, 7, 512, null);
                ArrayList<CMProperty> stateProp = new ArrayList<CMProperty>();
                CMPropertySets propSets = store.getPropertySets();
                CMPropertySet propSet = propSets.getPropertySet();
                CMObjectClass dispatcherClass = CMExecutionContext.get().getStore().getObjectClasses().getClassByName("dispatcher");
                CMProperty runningStateProp = propSet.getProperty("runningState", dispatcherClass);
                stateProp.add(runningStateProp);
                ArrayList<Object> stateValue = new ArrayList<Object>();
                stateValue.add(new String("standby"));
                store.update(results, stateProp, stateValue);
                store.commitTransaction();
            }
            finally {
                if (results != null) {
                    results.release();
                }
                if (store.inTransaction()) {
                    try {
                        store.rollbackTransaction();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Throwable ex) {
            CMIndications.logException(ex);
        }
    }

    public static void setInstance_test(ICMDbStoreMultipleCMsUtil toSet) {
        instance = toSet;
    }

    public static void resetInstance_test() {
        instance = new CMDbStoreMultipleCMsUtil();
    }
}

