/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreAddDef;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.server.CMException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class CMDbStoreMultipleLocalizedStringTableAddDef
extends CMDbStoreAddDef {
    CMDbStoreMultipleLocalizedStringTableAddDef(String tableName) {
        super(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CMDbConnection con, int objectID) throws SQLException, CMException {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        if (this.numProps_ <= 0) {
            return;
        }
        CMDbProperty firstProp = this.properties_[0];
        String insertSql = sqlGenerator.createInsertMultipleLocalizedStringTableAddSql(this.tableName_, firstProp);
        PreparedStatement insertStmt = con.prepareStatement(insertSql);
        try {
            for (int propIdx = 0; propIdx < this.numProps_; ++propIdx) {
                CMDbStoreLocalizedStringArray values = (CMDbStoreLocalizedStringArray)this.values_[propIdx];
                if (values == null || values.getSize() <= 0) continue;
                values.computeDefaults();
                CMDbProperty prop = this.properties_[propIdx];
                String propName = "";
                boolean propIsLocalizedStrRelated = prop.isMultilingualRelated();
                if (propIsLocalizedStrRelated) {
                    propName = prop.getNameInTable();
                }
                insertStmt.setInt(1, objectID);
                for (int j = 0; j != values.getSize(); ++j) {
                    int stmtIdx = 2;
                    if (propIsLocalizedStrRelated) {
                        insertStmt.setString(stmtIdx++, propName);
                    }
                    CMDbStorePropertySerialization.bindParameterByProperty(insertStmt, stmtIdx, this.properties_[propIdx], values.getItem(j));
                    CMDbConnection.executeUpdate(insertStmt);
                }
            }
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(insertStmt);
        }
    }
}

