/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreBatchUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreDeleteDef;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.dbstore.binders.CMDbStoreStringBinder;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStoreUnexpected;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class CMDbStoreMultipleLocalizedStringTableBatchUpdate
extends CMDbStoreBatchUpdateDef {
    CMDbStoreMultipleLocalizedStringTableBatchUpdate(String table) {
        super(table);
    }

    @Override
    void execute(CMDbConnection con, int objectID) throws SQLException, CMException, CMStoreUnexpected {
        int[] objectIDs = new int[]{objectID};
        this.execute(con, objectIDs);
    }

    @Override
    void execute(CMDbConnection con, String additionToSetClause, int objectID) throws SQLException, CMException, CMStoreUnexpected {
        throw new IllegalStateException("Function is not implemented");
    }

    @Override
    void execute(CMDbConnection con, String additionToSetClause, int[] objectIDs) throws SQLException, CMException, CMStoreUnexpected {
        throw new IllegalStateException("Function is not implemented");
    }

    @Override
    void execute(CMDbConnection con, String additionToSetClause, String additionToWhereClause, int[] objectIDs) throws SQLException, CMException, CMStoreUnexpected {
        throw new IllegalStateException("Function is not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void execute(CMDbConnection con, int[] objectIDs) throws SQLException, CMException {
        this.preExecute(con, objectIDs);
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        StringBuffer updateSQL = new StringBuffer(1024);
        StringBuffer insertSQL = new StringBuffer(1024);
        StringBuffer parmList = new StringBuffer(this.numProps_ * 2);
        sqlGenerator.appendInsertMultipleLocalizedStringTableBatchUpdateBeginningSql(this.getTableName(), updateSQL, insertSQL, parmList);
        int numMLPropsToUpdate = 0;
        for (int propIdx = 0; propIdx != this.numProps_; ++propIdx) {
            CMDbProperty prop = this.properties_[propIdx];
            CMArrayPropertyValue value = (CMArrayPropertyValue)this.values_[propIdx];
            if (value == null || value.getSize() <= 0) continue;
            ++numMLPropsToUpdate;
            sqlGenerator.appendInsertMultipleLocalizedStringTableBatchUpdatePropertySql(prop, updateSQL, insertSQL, parmList);
            break;
        }
        sqlGenerator.appendInsertMultipleLocalizedStringTableBatchUpdateEndSql(updateSQL, insertSQL, parmList);
        if (numMLPropsToUpdate > 0) {
            PreparedStatement update2 = con.prepareStatement(updateSQL.toString());
            PreparedStatement insert = null;
            try {
                int valueCount = this.numProps_;
                for (int valueIdx = 0; valueIdx < valueCount; ++valueIdx) {
                    CMDbStoreLocalizedStringArray value = (CMDbStoreLocalizedStringArray)this.values_[valueIdx];
                    if (value == null || value.getSize() == 0) continue;
                    int strCount = value.getSize();
                    for (int strIdx = 0; strIdx != strCount; ++strIdx) {
                        CMDbStoreLocalizedString str = (CMDbStoreLocalizedString)value.get(strIdx);
                        CMDbStoreStringLocale locale = (CMDbStoreStringLocale)str.getLocale();
                        for (int objIdx = 0; objIdx < objectIDs.length; ++objIdx) {
                            int colIdx = 1;
                            int objectID = objectIDs[objIdx];
                            String strValue = str.getValue();
                            if (strValue == null) {
                                strValue = "";
                            }
                            CMDbStoreStringBinder.bind(update2, colIdx++, strValue);
                            update2.setBoolean(colIdx++, str.isDefault());
                            if (str.isDefaultForMappedLocale()) {
                                update2.setShort(colIdx++, locale.getMappedID());
                            } else {
                                update2.setNull(colIdx++, 5);
                            }
                            update2.setInt(colIdx++, objectID);
                            CMDbProperty prop = this.properties_[valueIdx];
                            CMDbStoreStringBinder.bind(update2, colIdx++, prop.getNameInTable());
                            update2.setShort(colIdx, locale.getInternalID());
                            if (CMDbConnection.executeUpdate(update2) != 0) continue;
                            if (insert == null) {
                                insert = con.prepareStatement(insertSQL.toString());
                            }
                            insert.setInt(1, objectID);
                            insert.setString(2, prop.getNameInTable());
                            CMDbStorePropertySerialization.bindParameterByProperty(insert, 3, this.properties_[valueIdx], str);
                            CMDbConnection.executeUpdate(insert);
                        }
                    }
                }
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(update2);
                CMDbStoreUtil.safeCloseStatement(insert);
            }
        }
        this.postExecute(con, objectIDs);
    }

    boolean preExecute(CMDbConnection con, int[] objectIDs) throws SQLException, CMException {
        CMDbProperty prop;
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        StringBuffer whereClauseExt = new StringBuffer();
        boolean bFirstProp = true;
        for (int i = 0; i < this.numProps_; ++i) {
            prop = this.properties_[i];
            if (prop == null || !prop.isMultilingualRelated()) continue;
            if (bFirstProp) {
                whereClauseExt.append(sqlGenerator.createOpeningBracket());
            }
            if (!bFirstProp) {
                whereClauseExt.append(sqlGenerator.createOrSql());
            }
            whereClauseExt.append("PROPNAME");
            whereClauseExt.append(sqlGenerator.createEqualsSql());
            whereClauseExt.append(sqlGenerator.createStringLiteralSingleQuote());
            whereClauseExt.append(prop.getNameInTable());
            whereClauseExt.append(sqlGenerator.createStringLiteralSingleQuote());
            whereClauseExt.append(" ");
            bFirstProp = false;
        }
        if (whereClauseExt.length() > 0) {
            whereClauseExt.append(sqlGenerator.createClosingBracket());
        }
        CMDbStoreUpdateDef updateDef = new CMDbStoreUpdateDef(this.getTableName());
        prop = this.properties_[0];
        updateDef.execute(con, sqlGenerator.createMultipleLocalizedStringTableBatchUpdateAdditionToSetClause(prop), whereClauseExt.toString(), objectIDs);
        return true;
    }

    void postExecute(CMDbConnection con, int[] objectIDs) throws SQLException, CMException {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        CMDbStoreDeleteDef deleteDef = new CMDbStoreDeleteDef(this.getTableName());
        deleteDef.execute(con, "VALUE" + sqlGenerator.createIsNullSql(), objectIDs);
    }
}

