/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.dbstore.StatementProxy;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;

public class CMDbStorePrepStmtCache {
    public static final int STMT_COPY_NAME = 1;
    public static final int STMT_COPY_BASE_TABLE_PROPS = 2;
    private static final int STMT_ARRAY_BASE = 1000;
    public static final int STMT_ARRAY_COPY_PROPS = 1001;
    public static String[] deletePropsStmts_;
    private static String[] tableAliases_;
    private HashMap<String, StatementProxy> preparedStatements_ = new HashMap();
    private Hashtable<Integer, PreparedStatement> stmts_ = new Hashtable();
    private Hashtable<Integer, PreparedStatement[]> stmtArrays_ = new Hashtable();
    private CMDbConnection connection_ = null;
    private static Hashtable<Integer, Object> stmtStrs_;
    private static Hashtable<Integer, Integer> StmtTableMap_;

    public CMDbStorePrepStmtCache(CMDbConnection connection) {
        this.connection_ = connection;
    }

    public static String[] getTableAliases() {
        return tableAliases_;
    }

    public static void init(CMDbConnection dbConnection) throws CMConfigurationException {
        ICMDbStoreSqlGenerator sqlGenerator = dbConnection.getSqlGenerator();
        CMDbStorePrepStmtCache.initializeAliases();
        ArrayList<String> allTables = CMDbStoreFactory.propertySets_.getTables();
        int allTableCount = allTables.size();
        ArrayList<String> copyOnCopyTables = CMDbStoreFactory.propertySets_.getCopyOnCopyTables();
        int copyOnCopyTableCount = copyOnCopyTables.size();
        try {
            if (allTableCount > 0) {
                HashSet<String> skipTables = new HashSet<String>();
                skipTables.add("CMCLASSES");
                deletePropsStmts_ = CMDbStorePrepStmtCache.getDelStmtFragments(dbConnection, allTables, 0, allTableCount - 1, skipTables);
                String[] copyPropsStmts = new String[copyOnCopyTableCount - 2];
                int copyOffset = 0;
                for (int i = 0; i < copyOnCopyTableCount; ++i) {
                    String currentTable = copyOnCopyTables.get(i);
                    if (!currentTable.equals("CMCLASSES") && !currentTable.equals("CMOBJNAMES")) {
                        String columns = CMDbStorePrepStmtCache.getTableColumnsExceptCMID(dbConnection, currentTable);
                        copyPropsStmts[i - copyOffset] = sqlGenerator.createCopyPropertyTableSql(currentTable, columns);
                        int indexInAllTables = CMDbStoreFactory.propertySets_.getTableIndex(currentTable);
                        if (indexInAllTables < 0) {
                            throw new IllegalStateException("A copy table name is not in all table names.");
                        }
                        StmtTableMap_.put(new Integer(i - copyOffset), new Integer(indexInAllTables));
                        continue;
                    }
                    ++copyOffset;
                }
                CMDbStorePrepStmtCache.registerStmtArray(1001, copyPropsStmts);
            }
            String columns = CMDbStorePrepStmtCache.getBaseTableColumns(dbConnection);
            CMDbStorePrepStmtCache.registerStmt(2, sqlGenerator.createCopyTableSql("CMOBJECTS", columns, true, true));
            columns = CMDbStorePrepStmtCache.getTableColumnsExceptCMID(dbConnection, "CMOBJNAMES");
            CMDbStorePrepStmtCache.registerStmt(1, sqlGenerator.createCopyPropertyTableSql("CMOBJNAMES", columns));
        }
        catch (SQLException ex) {
            throw new CMConfigurationException((Throwable)ex, "cmNoInitQueryStrs");
        }
    }

    public static void initializeAliases() {
        tableAliases_ = new String[256];
        for (int i = 0; i < 256; ++i) {
            CMDbStorePrepStmtCache.tableAliases_[i] = "p" + Integer.toString(i);
        }
    }

    private static String[] getDelStmtFragments(CMDbConnection con, ArrayList<String> tableNames, int startIdx, int endIdx, Set<String> skipTables) {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        int count = endIdx - startIdx + 1;
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        String[] sa = new String[count];
        for (int i = startIdx; i <= endIdx; ++i) {
            String tableName = tableNames.get(i);
            if (skipTables.contains(tableName)) continue;
            sa[i] = sqlGenerator.createDelStmtFragment(tableName);
        }
        return sa;
    }

    public void finalize() {
        try {
            this.release();
        }
        catch (Exception ex) {
            CMIndications.CMTrace("cmSQLConnectionException", new CMException.Parm("Exception", ex.getMessage()), new CMException.Parm("ConID", Integer.toString(this.connection_.getID())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws SQLException {
        HashMap<String, StatementProxy> hashMap = this.preparedStatements_;
        synchronized (hashMap) {
            this.preparedStatements_.clear();
        }
        this.releaseStmts();
        this.releaseStmtArrays();
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType) throws SQLException {
        PreparedStatement ps = this.connection_.getConnection().prepareStatement(sql, resultSetType, 1007);
        return new StatementProxy(ps, sql);
    }

    protected Statement getProxyStatement(Statement realStmt) throws SQLException {
        return new StatementProxy(realStmt, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getPreparedStatement(String name, String sql) throws SQLException {
        HashMap<String, StatementProxy> hashMap = this.preparedStatements_;
        synchronized (hashMap) {
            StatementProxy ps = this.preparedStatements_.get(name);
            if (ps == null) {
                ps = (StatementProxy)this.prepareStatement(sql, 1003);
                this.preparedStatements_.put(name, ps);
            } else {
                ps.reset();
            }
            return ps;
        }
    }

    public PreparedStatement getPreparedStatement(int stmt_id) throws SQLException {
        PreparedStatement stmt = this.getStmt(stmt_id);
        return stmt;
    }

    public PreparedStatement getPreparedStatement(int stmtArray_id, int idx) throws SQLException {
        PreparedStatement[] stmtArray = this.getStmtArray(stmtArray_id);
        PreparedStatement stmt = stmtArray[idx];
        return stmt;
    }

    public int getStmtArraySize(int stmt_id) throws SQLException {
        PreparedStatement[] a = this.getStmtArray(stmt_id);
        return a.length;
    }

    private static void registerStmt(int key, String stmtStr) {
        stmtStrs_.put(new Integer(key), stmtStr);
    }

    private static void registerStmtArray(int key, String[] stmtStrArray) {
        stmtStrs_.put(new Integer(key), stmtStrArray);
    }

    private PreparedStatement getStmt(int stmt_id) throws SQLException {
        Integer key = new Integer(stmt_id);
        PreparedStatement stmt = this.stmts_.get(key);
        if (stmt != null) {
            return stmt;
        }
        String stmtStr = (String)stmtStrs_.get(key);
        if (stmtStr == null) {
            throw new RuntimeException(this.getClass().getName() + ": unknown statement (id=" + stmt_id + ")");
        }
        stmt = this.connection_.prepareStatement(stmtStr);
        this.stmts_.put(key, stmt);
        return stmt;
    }

    private PreparedStatement[] getStmtArray(int stmt_id) throws SQLException {
        Integer key = new Integer(stmt_id);
        PreparedStatement[] stmtArray = this.stmtArrays_.get(key);
        if (stmtArray != null) {
            return stmtArray;
        }
        String[] stmtStrArray = (String[])stmtStrs_.get(key);
        if (stmtStrArray == null) {
            throw new RuntimeException(this.getClass().getName() + ": unknown statement (id=" + stmt_id + ")");
        }
        stmtArray = new PreparedStatement[stmtStrArray.length];
        for (int i = 0; i < stmtStrArray.length; ++i) {
            stmtArray[i] = this.connection_.prepareStatement(stmtStrArray[i]);
        }
        this.stmtArrays_.put(key, stmtArray);
        return stmtArray;
    }

    private void releaseStmts() throws SQLException {
        Enumeration<Integer> keys = this.stmts_.keys();
        while (keys.hasMoreElements()) {
            Integer key = keys.nextElement();
            PreparedStatement stmt = this.stmts_.get(key);
            if (stmt == null) continue;
            stmt.close();
        }
        this.stmts_.clear();
    }

    private void releaseStmtArrays() throws SQLException {
        Enumeration<Integer> keys = this.stmtArrays_.keys();
        while (keys.hasMoreElements()) {
            Integer key = keys.nextElement();
            PreparedStatement[] stmtArray = this.stmtArrays_.get(key);
            if (stmtArray == null) continue;
            for (PreparedStatement stmt : stmtArray) {
                stmt.close();
            }
        }
        this.stmtArrays_.clear();
    }

    private static String getTableColumnsExceptCMID(CMDbConnection con, String tableName) throws SQLException {
        StringBuffer cols = new StringBuffer(1024);
        int count = 0;
        String[] colNames = CMDbStoreFactory.getColumnNamesOfTable(tableName, con.getConnection());
        if (colNames != null) {
            for (int i = 0; i < colNames.length; ++i) {
                String columnName = colNames[i];
                if (columnName.equalsIgnoreCase("CMID") || columnName.equalsIgnoreCase("OBJID") || columnName.equalsIgnoreCase("DB2_GENERATED_ROWID_FOR_LOBS")) continue;
                if (count++ > 0) {
                    cols.append(con.getSqlGenerator().createColumnsSeparator());
                }
                cols.append(columnName);
            }
        }
        return cols.toString();
    }

    private static String getBaseTableColumns(CMDbConnection dbConnection) throws SQLException {
        Connection con = dbConnection.getConnection();
        ICMDbStoreSqlGenerator sqlGenerator = dbConnection.getSqlGenerator();
        StringBuffer cols = new StringBuffer(1024);
        String currentSep = "";
        String sep = sqlGenerator.createColumnsSeparator();
        String[] colNames = CMDbStoreFactory.getColumnNamesOfTable("CMOBJECTS", con);
        List<String> columnsToIgnore = Arrays.asList("CMID", "PCMID", "TENANTID");
        if (colNames != null) {
            for (int i = 0; i < colNames.length; ++i) {
                String columnName = colNames[i];
                if (columnsToIgnore.contains(columnName)) continue;
                cols.append(currentSep);
                cols.append(columnName);
                currentSep = sep;
            }
        }
        return cols.toString();
    }

    public int getTableIndex(int i) {
        return StmtTableMap_.get(new Integer(i));
    }

    public static void setTableAliases(String[] tableAliases) {
        tableAliases_ = tableAliases;
    }

    static {
        stmtStrs_ = new Hashtable();
        StmtTableMap_ = new Hashtable();
    }
}

