/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.binders.CMDbStoreBindUtil;
import com.cognos.cm.dbstore.binders.CMDbStoreDataBinder;
import com.cognos.cm.dbstore.properties.CMDbStoreArrayXMLValue;
import com.cognos.cm.dbstore.properties.CMDbStoreFaultDetailArray;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMDbStoreStringMapEntryArray;
import com.cognos.cm.dbstore.properties.CMDbStoreUncheckedArray;
import com.cognos.cm.dbstore.serializers.CMDbStoreDeploymentReferenceArraySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreFaultDetailArraySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreNavigationPathArraySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreRepositoryRuleSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreRetentionRuleSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreStringCompressingSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreStringMapEntryArraySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreUncheckedArraySerializer;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.properties.CMBasePropertyValue;
import com.cognos.cm.properties.CMNameValuePair;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.properties.CMString;
import com.cognos.cm.properties.CMTypedNameValuePair;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMInputStreamWithSize;
import com.cognos.cm.util.CMObjectRef;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.date.DateUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;

public class CMDbStorePropertySerialization {
    public static Object getColumnByProperty(ResultSet rs, int colIdx, CMProperty property) throws SQLException {
        CMDbProperty prop = (CMDbProperty)property;
        CMDbStoreDataBinder binder = prop.getDataBinder();
        CMObjectRef valueRef = new CMObjectRef();
        binder.getData(rs, colIdx, valueRef);
        try {
            return prop.getDataSerializer().deserialize(valueRef.get());
        }
        catch (NullPointerException ex) {
            if (CMDbConnection.getDbmsInfo().getDbmsSubtype() == 6) {
                throw new SQLException("NullPointerException", "40003");
            }
            throw ex;
        }
    }

    public static int bindParameterByProperty(Object bindee, int parmIdx, CMProperty property, Object parmValue) throws SQLException, CMException {
        int nextParmIdx = parmIdx;
        CMDbProperty prop = (CMDbProperty)property;
        if (bindee instanceof PreparedStatement) {
            PreparedStatement stmt = (PreparedStatement)bindee;
            CMDbStoreDataSerializer serializer = prop.getDataSerializer();
            Object value = serializer.serialize(parmValue);
            if (value == null && !prop.allowNullValues()) {
                throw new CMException("cmBadPropertyData", new CMException.Parm("Property", prop.getName()));
            }
            CMDbStoreDataBinder binder = prop.getDataBinder();
            nextParmIdx = binder.bindData(stmt, parmIdx, value);
        } else {
            ResultSet rs = null;
            rs = (ResultSet)bindee;
            if (property.getType() == CMPropertyTypes.BIBUS_DEPLOYMENTOPTIONARRAY || property.getType() == CMPropertyTypes.BIBUS_GOVERNORARRAY || property.getType() == CMPropertyTypes.BIBUS_POWERPLAYOPTIONARRAY) {
                try {
                    CMDbStoreDataSerializer serializer = prop.getDataSerializer();
                    Object value = serializer.serialize(parmValue);
                    if (value != null && value instanceof String) {
                        nextParmIdx = CMDbStoreBindUtil.bindCLOBToResultSet((String)value, rs, prop.getColumn(0).getDbType(), parmIdx);
                    }
                }
                catch (CMException serializer) {}
            } else if (property.getType() == CMPropertyTypes.BIBUS_RUNOPTIONARRAY) {
                CMTypedNameValuePair value = (CMTypedNameValuePair)parmValue;
                String theValue = value.getValue();
                byte[] data = null;
                try {
                    data = CMStringUtils.compressUTF8String(theValue);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                nextParmIdx = CMDbStoreBindUtil.bindBLOBToResultSet(data, rs, prop.getColumn(0).getDbType(), parmIdx);
            } else {
                nextParmIdx = CMDbStorePropertySerialization.bindParameterToResultSet(rs, parmIdx, property.getType(), property.getMaxOccurs(), prop.getColumn(0).getDbType(), parmValue, prop);
            }
        }
        return nextParmIdx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int bindParameterToResultSet(ResultSet rs, int parmIdx, CMPropertyTypes.Type parmType, int maxOccurs, int dbType, Object parmValue, CMDbProperty property) throws SQLException {
        boolean scalarBind;
        int nextParmIdx = parmIdx;
        if (parmType == CMPropertyTypes.XML_STRING || parmType == CMPropertyTypes.XML_ANYURI || parmType == CMPropertyTypes.XML_ANYTYPE || parmType == CMPropertyTypes.BIBUS_ANYTYPEMIME || parmType == CMPropertyTypes.XML_LANGUAGE || parmType == CMPropertyTypes.XML_TOKEN || parmType == CMPropertyTypes.XML_NMTOKEN || parmType == CMPropertyTypes.XML_NCNAME || parmType == CMPropertyTypes.XML_DECIMAL || parmType == CMPropertyTypes.XML_DURATION || parmType == CMPropertyTypes.BIBUS_FAULTDETAILARRAY || parmType == CMPropertyTypes.BIBUS_DATASOURCECOMMANDBLOCK || parmType == CMPropertyTypes.BIBUS_POWERPLAYDATABLOCKARRAY || parmType == CMPropertyTypes.BIBUS_STRINGMAPENTRYARRAY || parmType == CMPropertyTypes.BIBUS_QUERYSPECIFICATION || parmType == CMPropertyTypes.BIBUS_XMLENCODEDXML || parmType == CMPropertyTypes.BIBUS_DATAINTEGRATIONSERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_PLANNINGTASKSERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_INDEXUPDATESERVICESERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_DATAMOVEMENTSERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_MIGRATIONSERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_REPORTDATASERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_XMLENCODEDXMLMIME || parmType == CMPropertyTypes.BIBUS_PLANNINGADMINISTRATIONCONSOLESERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_POWERPLAYSERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_REPORTSERVICEDRILLTHROUGHSPECIFICATION || CMPropertyTypes.isUncheckedArrayType(parmType)) {
            String sValue;
            block52: {
                sValue = null;
                if (dbType == 2004 && parmValue != null) {
                    try {
                        if (parmValue.getClass() == String.class || parmValue instanceof CMString || parmValue.getClass() == CMDbStoreArrayXMLValue.class) {
                            CMDbStoreStringCompressingSerializer dataSerializer = new CMDbStoreStringCompressingSerializer();
                            parmValue = dataSerializer.serialize(parmValue);
                            break block52;
                        }
                        if (parmValue.getClass() == CMDbStoreFaultDetailArray.class) {
                            CMDbStoreFaultDetailArraySerializer dataSerializer = new CMDbStoreFaultDetailArraySerializer();
                            parmValue = dataSerializer.serialize(parmValue);
                            break block52;
                        }
                        if (parmValue.getClass() == CMDbStoreStringMapEntryArray.class) {
                            CMDbStoreStringMapEntryArraySerializer dataSerializer = new CMDbStoreStringMapEntryArraySerializer();
                            parmValue = dataSerializer.serialize(parmValue);
                            break block52;
                        }
                        if (parmValue.getClass() == CMDbStoreUncheckedArray.class) {
                            CMDbStoreUncheckedArraySerializer dataSerializer2 = new CMDbStoreUncheckedArraySerializer(parmType);
                            parmValue = dataSerializer2.serialize(parmValue);
                        }
                    }
                    catch (CMException dataSerializer2) {
                        // empty catch block
                    }
                }
            }
            if (parmValue == null) return CMDbStoreBindUtil.bindCLOBToResultSet(sValue, rs, dbType, parmIdx);
            if (parmValue.getClass() != String.class) {
                if (parmValue instanceof CMBasePropertyValue) {
                    if (parmValue.getClass() == CMDbStoreLocalizedString.class) {
                        throw new IllegalStateException("Cannot bind localized string to result set");
                    }
                    sValue = parmValue.toString();
                    return CMDbStoreBindUtil.bindCLOBToResultSet(sValue, rs, dbType, parmIdx);
                } else {
                    if (parmValue instanceof CMInputStreamWithSize) {
                        return CMDbStoreBindUtil.bindBLOBAsStreamToResultSet((CMInputStreamWithSize)parmValue, rs, dbType, parmIdx);
                    }
                    if (!(parmValue instanceof byte[])) return CMDbStoreBindUtil.bindCLOBToResultSet(sValue, rs, dbType, parmIdx);
                    return CMDbStoreBindUtil.bindBLOBToResultSet((byte[])parmValue, rs, dbType, parmIdx);
                }
            }
            sValue = parmValue.toString();
            return CMDbStoreBindUtil.bindCLOBToResultSet(sValue, rs, dbType, parmIdx);
        }
        if (parmType == CMPropertyTypes.BIBUS_NAVIGATIONPATHARRAY) {
            if (parmValue == null) {
                throw new IllegalStateException("Cannot bind null navigation path array to result set");
            }
            try {
                CMDbStoreNavigationPathArraySerializer dataSerializer = new CMDbStoreNavigationPathArraySerializer(property);
                parmValue = dataSerializer.serialize(parmValue);
                if (parmValue.getClass() != String.class) throw new IllegalStateException("Cannot bind navigation path array to result set");
                return CMDbStoreBindUtil.bindCLOBToResultSet((String)parmValue, rs, dbType, parmIdx);
            }
            catch (CMException dataSerializer) {
                return nextParmIdx;
            }
        }
        if (parmType == CMPropertyTypes.BIBUS_DEPLOYMENTREFERENCEARRAY) {
            if (parmValue == null) {
                throw new IllegalStateException("Cannot bind null deployment reference array to result set");
            }
            try {
                CMDbStoreDeploymentReferenceArraySerializer dataSerializer = new CMDbStoreDeploymentReferenceArraySerializer(property);
                parmValue = dataSerializer.serialize(parmValue);
                if (parmValue.getClass() != String.class) throw new IllegalStateException("Cannot bind deployment reference array to result set");
                return CMDbStoreBindUtil.bindCLOBToResultSet((String)parmValue, rs, dbType, parmIdx);
            }
            catch (CMException dataSerializer) {
                return nextParmIdx;
            }
        }
        if (parmType == CMPropertyTypes.BIBUS_MULTILINGUALSTRING) throw new IllegalStateException("Cannot bind a multilingual value to result set");
        if (parmType == CMPropertyTypes.BIBUS_MULTILINGUALTOKEN) {
            throw new IllegalStateException("Cannot bind a multilingual value to result set");
        }
        if (parmType == CMPropertyTypes.XML_FLOAT) {
            throw new IllegalStateException("Cannot bind a float value to result set");
        }
        if (parmType == CMPropertyTypes.XML_INT) throw new IllegalStateException("Cannot bind a numeric value to result set");
        if (parmType == CMPropertyTypes.XML_POSITIVEINTEGER) throw new IllegalStateException("Cannot bind a numeric value to result set");
        if (parmType == CMPropertyTypes.XML_NONNEGATIVEINTEGER) {
            throw new IllegalStateException("Cannot bind a numeric value to result set");
        }
        if (parmType == CMPropertyTypes.XML_DATETIME) {
            throw new IllegalStateException("Cannot bind a datetime value to result set");
        }
        if (parmType == CMPropertyTypes.BIBUS_POLICYARRAY || parmType == CMPropertyTypes.BIBUS_USERCAPABILITYPOLICYARRAY) {
            byte[] policyData = (byte[])parmValue;
            return CMDbStoreBindUtil.bindBLOBToResultSet(policyData, rs, dbType, parmIdx);
        }
        if (parmType == CMPropertyTypes.BIBUS_OPTIONARRAY) {
            CMDbStoreDataSerializer dataSerializer = property.getDataSerializer();
            try {
                parmValue = dataSerializer.serialize(parmValue);
                return CMDbStoreBindUtil.bindCLOBToResultSet((String)parmValue, rs, dbType, parmIdx);
            }
            catch (CMException dataSerializer2) {
                // empty catch block
            }
            return CMDbStoreBindUtil.bindCLOBToResultSet((String)parmValue, rs, dbType, parmIdx);
        }
        if (parmType == CMPropertyTypes.XML_BASE64BINARY || parmType == CMPropertyTypes.BIBUS_BASE64BINARYMIME) {
            if (parmValue == null) {
                throw new IllegalStateException("Cannot bind null binary value to result set");
            }
            if (parmValue instanceof byte[]) {
                byte[] data = (byte[])parmValue;
                return CMDbStoreBindUtil.bindBLOBToResultSet(data, rs, dbType, parmIdx);
            }
            if (!(parmValue instanceof CMInputStreamWithSize)) throw new IllegalStateException("property is not one of the valid types");
            return CMDbStoreBindUtil.bindBLOBAsStreamToResultSet((CMInputStreamWithSize)parmValue, rs, dbType, parmIdx);
        }
        if (parmType == CMPropertyTypes.BIBUS_RETENTIONRULEARRAY) {
            if (parmValue == null) {
                throw new IllegalStateException("Cannot bind null retention rule array value to result set");
            }
            try {
                CMDbStoreRetentionRuleSerializer dataSerializer = new CMDbStoreRetentionRuleSerializer();
                parmValue = dataSerializer.serialize(parmValue);
                if (parmValue.getClass() != String.class) throw new IllegalStateException("Cannot bind retention rule array to result set");
                return CMDbStoreBindUtil.bindCLOBToResultSet((String)parmValue, rs, dbType, parmIdx);
            }
            catch (CMException dataSerializer) {
                return nextParmIdx;
            }
        }
        if (parmType == CMPropertyTypes.BIBUS_REPOSITORYRULEARRAY) {
            if (parmValue == null) {
                throw new IllegalStateException("Cannot bind null repository rule array value to result set");
            }
            try {
                CMDbStoreRepositoryRuleSerializer dataSerializer = new CMDbStoreRepositoryRuleSerializer();
                parmValue = dataSerializer.serialize(parmValue);
                if (parmValue.getClass() != String.class) throw new IllegalStateException("Cannot bind repository rule array to result set");
                return CMDbStoreBindUtil.bindCLOBToResultSet((String)parmValue, rs, dbType, parmIdx);
            }
            catch (CMException dataSerializer) {
                return nextParmIdx;
            }
        }
        if (parmType == CMPropertyTypes.BIBUS_PARAMETERVALUEARRAY) {
            CMNameValuePair value = (CMNameValuePair)parmValue;
            byte[] data = null;
            if (value.getValue() == null) return CMDbStoreBindUtil.bindBLOBToResultSet(data, rs, dbType, parmIdx);
            try {
                data = CMStringUtils.compressUTF8String(value.getValue());
                return CMDbStoreBindUtil.bindBLOBToResultSet(data, rs, dbType, parmIdx);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return CMDbStoreBindUtil.bindBLOBToResultSet(data, rs, dbType, parmIdx);
        }
        if (parmType != CMPropertyTypes.BIBUS_BASECLASSARRAY && parmType != CMPropertyTypes.BIBUS_STRINGARRAY && parmType != CMPropertyTypes.BIBUS_TOKENARRAY && parmType != CMPropertyTypes.BIBUS_EVENTTYPEENUMARRAY && parmType != CMPropertyTypes.BIBUS_UICOMPONENTENUMARRAY) {
            if (parmType != CMPropertyTypes.BIBUS_ANYURIARRAY) throw new IllegalStateException("bindParameterToResultSet unknown type: \"" + parmType.getName() + "\"");
        }
        int size = 1;
        boolean bl = scalarBind = maxOccurs == 1 || dbType == -9 || dbType == 12 || dbType == -1 || dbType == -16 || dbType == 3 || dbType == 4;
        if (parmValue != null) {
            if (parmValue.getClass() == ArrayList.class) {
                size = ((ArrayList)parmValue).size();
            } else if (parmValue instanceof CMArrayPropertyValue) {
                size = ((CMArrayPropertyValue)parmValue).getSize();
            }
        }
        if (parmValue == null) throw new IllegalStateException("Cannot bind null array value to result set");
        if (size == 0) {
            throw new IllegalStateException("Cannot bind null array value to result set");
        }
        if (scalarBind) throw new IllegalStateException("bindParameterToResultSet unknown type: \"" + parmType.getName() + "\"");
        CMArrayPropertyValue value = (CMArrayPropertyValue)parmValue;
        StringBuffer buffer = new StringBuffer(1024);
        int i = 0;
        while (i < value.getSize()) {
            Object item = value.getItem(i);
            if (item != null) {
                String elementStr = item.toString();
                buffer.append(Integer.toString(elementStr.length()));
                buffer.append('\n');
                buffer.append(elementStr);
            }
            ++i;
        }
        return CMDbStoreBindUtil.bindCLOBToResultSet(buffer.toString(), rs, dbType, parmIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void bindParameterToPreparedStatement(PreparedStatement stmt, int parmIdx, CMPropertyTypes.Type parmType, int maxOccurs, int dbType, Object parmValue) throws SQLException {
        if (parmType == CMPropertyTypes.XML_BOOLEAN) {
            if (parmValue == null || ((String)parmValue).length() == 0) {
                stmt.setNull(parmIdx, -7);
                return;
            } else {
                try {
                    stmt.setBoolean(parmIdx, CMXMLUtils.parseBooleanAttribute((String)parmValue));
                    return;
                }
                catch (CMException ex) {
                    stmt.setBoolean(parmIdx, false);
                }
            }
            return;
        }
        if (parmType == CMPropertyTypes.XML_STRING || parmType == CMPropertyTypes.XML_ANYURI || parmType == CMPropertyTypes.XML_ANYTYPE || parmType == CMPropertyTypes.BIBUS_ANYTYPEMIME || parmType == CMPropertyTypes.XML_LANGUAGE || parmType == CMPropertyTypes.XML_TOKEN || parmType == CMPropertyTypes.XML_NMTOKEN || parmType == CMPropertyTypes.XML_NCNAME || parmType == CMPropertyTypes.XML_DECIMAL || parmType == CMPropertyTypes.XML_DURATION || parmType == CMPropertyTypes.BIBUS_FAULTDETAILARRAY || parmType == CMPropertyTypes.BIBUS_STRINGMAPENTRYARRAY || parmType == CMPropertyTypes.BIBUS_DATASOURCECOMMANDBLOCK || parmType == CMPropertyTypes.BIBUS_QUERYSPECIFICATION || parmType == CMPropertyTypes.BIBUS_XMLENCODEDXML || parmType == CMPropertyTypes.BIBUS_DATAINTEGRATIONSERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_PLANNINGTASKSERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_INDEXUPDATESERVICESERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_DATAMOVEMENTSERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_MIGRATIONSERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_REPORTDATASERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_XMLENCODEDXMLMIME || parmType == CMPropertyTypes.BIBUS_PLANNINGADMINISTRATIONCONSOLESERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_POWERPLAYSERVICESPECIFICATION || parmType == CMPropertyTypes.BIBUS_REPORTSERVICEDRILLTHROUGHSPECIFICATION || CMPropertyTypes.isUncheckedArrayType(parmType)) {
            String sValue = null;
            if (dbType == 2004 && parmValue != null) {
                try {
                    CMDbStoreDataSerializer dataSerializer;
                    if (parmValue.getClass() == String.class || parmValue instanceof CMString) {
                        dataSerializer = new CMDbStoreStringCompressingSerializer();
                        parmValue = ((CMDbStoreStringCompressingSerializer)dataSerializer).serialize(parmValue);
                    } else if (parmValue.getClass() == CMDbStoreFaultDetailArray.class) {
                        dataSerializer = new CMDbStoreFaultDetailArraySerializer();
                        parmValue = ((CMDbStoreFaultDetailArraySerializer)dataSerializer).serialize(parmValue);
                    } else if (parmValue.getClass() == CMDbStoreStringMapEntryArray.class) {
                        dataSerializer = new CMDbStoreStringMapEntryArraySerializer();
                        parmValue = ((CMDbStoreStringMapEntryArraySerializer)dataSerializer).serialize(parmValue);
                    } else if (parmValue.getClass() == CMDbStoreUncheckedArray.class) {
                        dataSerializer = new CMDbStoreUncheckedArraySerializer(parmType);
                        parmValue = ((CMDbStoreUncheckedArraySerializer)dataSerializer).serialize(parmValue);
                    }
                }
                catch (CMException dataSerializer) {
                    // empty catch block
                }
            }
            if (parmValue != null) {
                if (parmValue.getClass() != String.class) {
                    if (parmValue instanceof CMBasePropertyValue) {
                        if (parmValue.getClass() == CMDbStoreLocalizedString.class) {
                            CMDbStoreLocalizedString str = (CMDbStoreLocalizedString)parmValue;
                            stmt.setInt(parmIdx, ((CMDbStoreStringLocale)str.getLocale()).getInternalID());
                            stmt.setString(parmIdx + 1, str.getValue());
                            stmt.setBoolean(parmIdx + 2, str.isDefault());
                            return;
                        }
                    } else {
                        if (parmValue instanceof CMInputStreamWithSize) {
                            CMDbStoreBindUtil.bindBLOBAsStreamToPreparedStatement((CMInputStreamWithSize)parmValue, stmt, dbType, parmIdx);
                            return;
                        }
                        if (parmValue instanceof byte[]) {
                            CMDbStoreBindUtil.bindBLOBToPreparedStatement((byte[])parmValue, stmt, dbType, parmIdx);
                            return;
                        }
                    }
                } else {
                    sValue = parmValue.toString();
                }
            }
            CMDbStoreBindUtil.bindCLOBToPreparedStatement(sValue, stmt, dbType, parmIdx);
            return;
        }
        if (parmType == CMPropertyTypes.BIBUS_NAVIGATIONPATHARRAY) {
            if (parmValue == null) {
                if (CMDbConnection.dbms_ == 8) {
                    stmt.setNull(parmIdx, -1);
                    return;
                } else {
                    stmt.setNull(parmIdx, 12);
                }
                return;
            } else {
                try {
                    CMDbStoreNavigationPathArraySerializer dataSerializer = new CMDbStoreNavigationPathArraySerializer(null);
                    parmValue = dataSerializer.serialize(parmValue);
                    if (parmValue.getClass() != String.class) {
                        throw new IllegalStateException("Cannot bind navigation path array to statement");
                    }
                    CMDbStoreBindUtil.bindCLOBToPreparedStatement((String)parmValue, stmt, dbType, parmIdx);
                    return;
                }
                catch (CMException dataSerializer) {}
            }
            return;
        }
        if (parmType == CMPropertyTypes.BIBUS_DEPLOYMENTREFERENCEARRAY) {
            if (parmValue == null) {
                if (CMDbConnection.dbms_ == 8) {
                    stmt.setNull(parmIdx, -1);
                    return;
                } else {
                    stmt.setNull(parmIdx, 12);
                }
                return;
            } else {
                try {
                    CMDbStoreDeploymentReferenceArraySerializer dataSerializer = new CMDbStoreDeploymentReferenceArraySerializer(null);
                    parmValue = dataSerializer.serialize(parmValue);
                    if (parmValue.getClass() != String.class) {
                        throw new IllegalStateException("Cannot bind deployment reference array to statement");
                    }
                    CMDbStoreBindUtil.bindCLOBToPreparedStatement((String)parmValue, stmt, dbType, parmIdx);
                    return;
                }
                catch (CMException dataSerializer) {}
            }
            return;
        }
        if (parmType == CMPropertyTypes.BIBUS_MULTILINGUALSTRING || parmType == CMPropertyTypes.BIBUS_MULTILINGUALTOKEN) {
            if (parmValue == null || parmValue.getClass() != String.class) {
                CMBasePropertyValue pValue = (CMBasePropertyValue)parmValue;
                CMDbStoreLocalizedString lString = (CMDbStoreLocalizedString)pValue;
                if (lString == null) {
                    throw new IllegalStateException("Cannot set a multivalued property to null");
                }
                stmt.setInt(parmIdx, ((CMDbStoreStringLocale)lString.getLocale()).getInternalID());
                if (CMDbConnection.dbms_ == 8) {
                    stmt.setObject(parmIdx + 1, (Object)lString.getValue(), -1);
                } else {
                    stmt.setObject(parmIdx + 1, (Object)lString.getValue(), 12);
                }
                stmt.setBoolean(parmIdx + 2, lString.isDefault());
                return;
            } else if (CMDbConnection.dbms_ == 8) {
                stmt.setObject(parmIdx, (Object)parmValue.toString(), -1);
                return;
            } else {
                stmt.setObject(parmIdx, (Object)parmValue.toString(), 12);
            }
            return;
        }
        if (parmType == CMPropertyTypes.XML_FLOAT) {
            String dValue = (String)parmValue;
            if (dValue == null || dValue.length() == 0) {
                stmt.setNull(parmIdx, 8);
                return;
            } else {
                stmt.setDouble(parmIdx, Double.parseDouble((String)parmValue));
            }
            return;
        }
        if (parmType == CMPropertyTypes.XML_INT || parmType == CMPropertyTypes.XML_POSITIVEINTEGER) {
            String iValue = (String)parmValue;
            if (iValue == null || iValue.length() == 0) {
                stmt.setNull(parmIdx, 4);
                return;
            } else {
                stmt.setInt(parmIdx, Integer.parseInt(iValue));
            }
            return;
        }
        if (parmType == CMPropertyTypes.XML_NONNEGATIVEINTEGER) {
            String iValue = (String)parmValue;
            if (iValue == null || iValue.length() == 0) {
                if (dbType == -5) {
                    stmt.setNull(parmIdx, -5);
                    return;
                } else {
                    stmt.setNull(parmIdx, 4);
                }
                return;
            } else if (dbType == -5) {
                stmt.setLong(parmIdx, Long.parseLong(iValue));
                return;
            } else {
                stmt.setInt(parmIdx, Integer.parseInt(iValue));
            }
            return;
        }
        if (parmType == CMPropertyTypes.XML_DATETIME) {
            if (parmValue != null && parmValue.getClass() == Timestamp.class) {
                stmt.setTimestamp(parmIdx, (Timestamp)parmValue);
                return;
            } else {
                String tsValue = (String)parmValue;
                if (tsValue == null || tsValue.length() == 0) {
                    stmt.setNull(parmIdx, 93);
                    return;
                } else {
                    stmt.setTimestamp(parmIdx, new Timestamp(DateUtils.getUTCTime((Date)DateUtils.parse((String)((String)parmValue)))));
                }
            }
            return;
        }
        if (parmType == CMPropertyTypes.BIBUS_POLICYARRAY || parmType == CMPropertyTypes.BIBUS_USERCAPABILITYPOLICYARRAY) {
            byte[] policyData = (byte[])parmValue;
            CMDbStoreBindUtil.bindBLOBToPreparedStatement(policyData, stmt, dbType, parmIdx);
            return;
        }
        if (parmType == CMPropertyTypes.XML_BASE64BINARY || parmType == CMPropertyTypes.BIBUS_BASE64BINARYMIME) {
            if (parmValue == null) {
                if (CMDbConnection.dbms_ == 4) {
                    stmt.setBinaryStream(parmIdx, (InputStream)null, 0);
                    return;
                } else {
                    stmt.setNull(parmIdx, 2004);
                }
                return;
            } else if (parmValue instanceof byte[]) {
                byte[] data = (byte[])parmValue;
                CMDbStoreBindUtil.bindBLOBToPreparedStatement(data, stmt, dbType, parmIdx);
                return;
            } else {
                if (!(parmValue instanceof CMInputStreamWithSize)) throw new IllegalStateException("property is not one of the valid types");
                CMDbStoreBindUtil.bindBLOBAsStreamToPreparedStatement((CMInputStreamWithSize)parmValue, stmt, dbType, parmIdx);
            }
            return;
        }
        if (parmType == CMPropertyTypes.BIBUS_RETENTIONRULEARRAY) {
            if (parmValue == null) {
                if (CMDbConnection.dbms_ == 8) {
                    stmt.setNull(parmIdx, -1);
                    return;
                } else {
                    stmt.setNull(parmIdx, 12);
                }
                return;
            } else {
                try {
                    CMDbStoreRetentionRuleSerializer dataSerializer = new CMDbStoreRetentionRuleSerializer();
                    parmValue = dataSerializer.serialize(parmValue);
                    if (parmValue.getClass() != String.class) {
                        throw new IllegalStateException("Cannot bind retention rule array to statement");
                    }
                    CMDbStoreBindUtil.bindCLOBToPreparedStatement((String)parmValue, stmt, dbType, parmIdx);
                    return;
                }
                catch (CMException dataSerializer) {}
            }
            return;
        }
        if (parmType == CMPropertyTypes.BIBUS_REPOSITORYRULEARRAY) {
            if (parmValue == null) {
                if (CMDbConnection.dbms_ == 8) {
                    stmt.setNull(parmIdx, -1);
                    return;
                } else {
                    stmt.setNull(parmIdx, 12);
                }
                return;
            } else {
                try {
                    CMDbStoreRepositoryRuleSerializer dataSerializer = new CMDbStoreRepositoryRuleSerializer();
                    parmValue = dataSerializer.serialize(parmValue);
                    if (parmValue.getClass() != String.class) {
                        throw new IllegalStateException("Cannot bind repository rule array to statement");
                    }
                    CMDbStoreBindUtil.bindCLOBToPreparedStatement((String)parmValue, stmt, dbType, parmIdx);
                    return;
                }
                catch (CMException dataSerializer) {}
            }
            return;
        }
        if (parmType == CMPropertyTypes.BIBUS_PARAMETERVALUEARRAY) {
            CMNameValuePair value = (CMNameValuePair)parmValue;
            byte[] data = null;
            if (value.getValue() != null) {
                try {
                    data = CMStringUtils.compressUTF8String(value.getValue());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            CMDbStoreBindUtil.bindBLOBToPreparedStatement(data, stmt, dbType, parmIdx);
            return;
        }
        if (parmType != CMPropertyTypes.BIBUS_BASECLASSARRAY && parmType != CMPropertyTypes.BIBUS_STRINGARRAY && parmType != CMPropertyTypes.BIBUS_TOKENARRAY && parmType != CMPropertyTypes.BIBUS_EVENTTYPEENUMARRAY && parmType != CMPropertyTypes.BIBUS_UICOMPONENTENUMARRAY && parmType != CMPropertyTypes.BIBUS_ANYURIARRAY) throw new IllegalStateException("bindParameterToPreparedStatement unknown type");
        int size = 1;
        boolean scalarBind = maxOccurs == 1 || dbType == -9 || dbType == 12 || dbType == -1 || dbType == -16 || dbType == 3 || dbType == 4;
        boolean scalarValue = true;
        if (parmValue != null) {
            if (parmValue.getClass() == ArrayList.class) {
                size = ((ArrayList)parmValue).size();
                scalarValue = false;
            } else if (parmValue instanceof CMArrayPropertyValue) {
                size = ((CMArrayPropertyValue)parmValue).getSize();
                scalarValue = false;
            }
        }
        if (parmValue == null || size == 0) {
            if (CMDbConnection.dbms_ == 8) {
                stmt.setNull(parmIdx, -1);
                return;
            } else {
                stmt.setNull(parmIdx, 12);
            }
            return;
        }
        if (!scalarBind) {
            CMArrayPropertyValue value = (CMArrayPropertyValue)parmValue;
            StringBuffer buffer = new StringBuffer(1024);
            for (int i = 0; i < value.getSize(); ++i) {
                Object item = value.getItem(i);
                if (item == null) continue;
                String elementStr = item.toString();
                buffer.append(Integer.toString(elementStr.length()));
                buffer.append('\n');
                buffer.append(elementStr);
            }
            CMDbStoreBindUtil.bindCLOBToPreparedStatement(buffer.toString(), stmt, dbType, parmIdx);
            return;
        }
        if (dbType == 3 || dbType == 4) {
            Object firstValue = parmValue.getClass() == ArrayList.class ? ((ArrayList)parmValue).get(0) : ((CMArrayPropertyValue)parmValue).getItem(0);
            String searchPath = null;
            int objectID = 0;
            if (firstValue.getClass() == Integer.class) {
                objectID = (Integer)firstValue;
            } else {
                searchPath = firstValue.toString();
            }
            if (searchPath != null) {
                CMStoreQueryResults results = null;
                try {
                    CMStoreXPath path = new CMStoreXPath(searchPath, 10);
                    CMStore store = CMExecutionContext.get().getStore();
                    results = store.executeQuery(path, null, null, 0, 512, null);
                    if (results.next()) {
                        String camID;
                        objectID = results.getObjectID();
                        results.reset();
                        if (objectID == 0 && (camID = path.getCAMIDFromFirstStep()) != null) {
                            objectID = store.createSecurityProxyObject(camID, null, CMObjectClass.ACCOUNT, false, true);
                        }
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (results != null) {
                        results.release();
                    }
                }
            }
            if (objectID != 0) {
                stmt.setInt(parmIdx, objectID);
                return;
            } else {
                stmt.setNull(parmIdx, dbType);
            }
            return;
        }
        if (scalarValue) {
            if (CMDbConnection.dbms_ == 8) {
                stmt.setObject(parmIdx, (Object)parmValue.toString(), -1);
                return;
            } else {
                stmt.setObject(parmIdx, (Object)parmValue.toString(), 12);
            }
            return;
        } else if (parmValue.getClass() == ArrayList.class) {
            ArrayList value = (ArrayList)parmValue;
            if (CMDbConnection.dbms_ == 8) {
                stmt.setObject(parmIdx, (Object)value.get(0).toString(), -1);
                return;
            } else {
                stmt.setObject(parmIdx, (Object)value.get(0).toString(), 12);
            }
            return;
        } else {
            CMArrayPropertyValue value = (CMArrayPropertyValue)parmValue;
            if (CMDbConnection.dbms_ == 8) {
                stmt.setObject(parmIdx, (Object)value.getItem(0).toString(), -1);
                return;
            } else {
                stmt.setObject(parmIdx, (Object)value.getItem(0).toString(), 12);
            }
        }
    }
}

