/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.securityproxy.AccountProxy;
import com.cognos.cm.dbstore.securityproxy.AnonymousAccountProxy;
import com.cognos.cm.dbstore.securityproxy.BasicProxy;
import com.cognos.cm.dbstore.securityproxy.NamespaceProxy;
import com.cognos.cm.dbstore.securityproxy.SecurityProxy;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMCAMIDHelper;
import java.util.List;

public class CMDbStoreProxyFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSecurityProxyObject(CMStore store, List<String> proxyLineage, CMObjectClass classHint, int tenantID) throws CMException {
        CMStoreQueryResults qresults = null;
        try {
            CMStoreXPath parentPath = new CMStoreXPath(proxyLineage.get(1), 10);
            for (int idx = 2; idx < proxyLineage.size(); ++idx) {
                if (qresults != null) {
                    qresults.release();
                }
                qresults = store.executeQuery(parentPath, null, null, 0, 512, null);
                int parentID = -1;
                if (!qresults.next()) {
                    throw new CMException("cmSearchErrCreateProxy", new CMException.Parm("Account", parentPath.toString()));
                }
                parentID = qresults.getObjectID();
                String sPath = proxyLineage.get(idx);
                if (CMIndicationGlobals.bDebugLogEnabled) {
                    CMIndications.CMDebugTrace("proxy[" + idx + "]: parentID=" + parentID + ", path=" + sPath);
                }
                CMStoreXPath path = parentPath = new CMStoreXPath(null, sPath, false, 10);
                qresults.release();
                qresults = null;
                qresults = store.executeQuery(path, null, null, 0, 512, null);
                if (qresults.next()) continue;
                if (CMIndicationGlobals.bDebugLogEnabled) {
                    CMIndications.CMDebugTrace("\tproxy[" + idx + "] does not exist!");
                }
                CMObjectClass classHintForThisProxy = idx == proxyLineage.size() - 1 ? classHint : null;
                CMObjectClass cls = this.determineProxyClass(classHintForThisProxy, store, sPath);
                SecurityProxy proxy = this.buildProxy(store, CMCAMIDHelper.getCAMIDFromInternalPath(sPath, false), cls, parentID, tenantID);
                proxy.createInStore(store);
            }
        }
        finally {
            if (qresults != null) {
                qresults.release();
            }
        }
    }

    private CMObjectClass determineProxyClass(CMObjectClass classHint, CMStore store, String sPath) throws CMException {
        CMObjectClass cls = null;
        if (classHint != null) {
            cls = classHint;
        }
        if (cls == null) {
            cls = CMCAMIDHelper.getClassFromCAMID(store, CMCAMIDHelper.getCAMIDFromInternalPath(sPath, true));
        }
        return cls;
    }

    private SecurityProxy buildProxy(CMStore store, String camID, CMObjectClass objectClass, int parentID, int tenantID) {
        SecurityProxy proxy = null;
        proxy = objectClass == CMObjectClass.NAMESPACE ? new NamespaceProxy(camID, parentID) : (objectClass == CMObjectClass.ACCOUNT ? this.buildAccountProxy(camID, parentID, this.getTenantName(store, tenantID)) : new BasicProxy(camID, objectClass, parentID));
        return proxy;
    }

    private String getTenantName(CMStore store, int tenantID) {
        String tenantName = null;
        tenantName = tenantID == -1 ? store.getTenantRegistry().getTenantIdStringFromInt(CMExecutionContext.get().getCurrentUserTenantId()) : store.getTenantRegistry().getTenantIdStringFromInt(tenantID);
        return tenantName;
    }

    private AccountProxy buildAccountProxy(String camID, int parentID, String tenantName) {
        if (null != camID && camID.equals("::Anonymous")) {
            return new AnonymousAccountProxy(parentID);
        }
        return new AccountProxy(camID, parentID, tenantName);
    }
}

