/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbmsInfo;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import java.io.File;

public class CMDbStoreScriptManager {
    private File cmSchemasDir;

    public CMDbStoreScriptManager(File cmSchemasDir) {
        this.cmSchemasDir = cmSchemasDir;
    }

    protected String getDefaultDbScriptSuffix(CMDbmsInfo dbmsInfo) {
        int dbms = dbmsInfo.getDbms();
        if (dbms == 1) {
            return "mssqlserver";
        }
        if (dbms == 2) {
            return "oracle";
        }
        if (dbms == 3) {
            if (dbmsInfo.getDbmsSubtype() == 6) {
                return "db2zOS";
            }
            return "db2";
        }
        if (dbms == 4) {
            return "sybase";
        }
        if (dbms == 5) {
            return "derby";
        }
        if (dbms == 8) {
            return "informix";
        }
        throw new IllegalStateException("Unexpected dbms value " + String.valueOf(dbms));
    }

    public File getScriptFolder(CMDbmsInfo dbmsInfo) {
        String dbmsName = this.getDefaultDbScriptSuffix(dbmsInfo);
        if (dbmsName.equals("mssqlserver")) {
            dbmsName = "sqlserver";
        }
        File scriptFolder = new File(this.cmSchemasDir, dbmsName);
        return scriptFolder;
    }

    protected String appendDbFileName(StringBuffer fileName, String fileNameBase, CMDbmsInfo dbmsInfo) {
        if (fileNameBase != null) {
            fileName.append(fileNameBase);
        }
        String dbmsName = this.getDefaultDbScriptSuffix(dbmsInfo);
        fileName.append("_");
        fileName.append(dbmsName);
        return fileName.toString();
    }

    public File getScriptFile(String fileNameBase, CMDbmsInfo dbmsInfo) throws CMConfigurationException {
        StringBuffer fileName = new StringBuffer();
        this.appendDbFileName(fileName, fileNameBase, dbmsInfo);
        fileName.append(".sql");
        File scriptFolder = this.getScriptFolder(dbmsInfo);
        File scriptFile = new File(scriptFolder, fileName.toString());
        if (!scriptFile.exists()) {
            throw new CMConfigurationException("cmNoCSInitScript", new CMException.Parm("FileName", scriptFile.getAbsolutePath()));
        }
        return scriptFile;
    }
}

