/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import java.util.Map;
import java.util.Properties;

public class CMDbStoreScriptParameters {
    private final Properties parameters = new Properties();

    public CMDbStoreScriptParameters(IConfiguration configuration) {
    }

    protected void loadFromConfiguration() throws Exception {
        IConfiguration config = ConfigurationFactory.getConfig();
        for (Map.Entry<Object, Object> entry : config.getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith("CMSCRIPT_")) continue;
            this.parameters.put(entry.getKey(), entry.getValue());
        }
    }

    public void initialize() throws Exception {
        this.loadFromConfiguration();
    }

    public String getParameter(String parameterName) {
        return this.parameters.getProperty(parameterName);
    }

    public String getParameter(String parameterName, String defaultValue) {
        String parameterValue = this.parameters.getProperty(parameterName);
        if (parameterValue != null) {
            return parameterValue;
        }
        return defaultValue;
    }

    public String replaceAllParameters(String line) {
        if (line.indexOf("CMSCRIPT_") < 0) {
            return line;
        }
        for (String string : this.parameters.keySet()) {
            String parameterValue = (String)this.parameters.get(string);
            line = line.replaceAll(string, parameterValue);
        }
        return line;
    }
}

