/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.CAM.AAAException;
import com.cognos.cm.cam.azn.AznUtil;
import com.cognos.cm.dbstore.CMDbObjectClass;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.dbstore.CMDbStoreSecurityUtil;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.trustedServices.trustedService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CMDbStoreSecurityHandler {
    private static final int NOT_SET = -1;
    private int iTraverse = -1;
    private int iExecute = -1;
    private int iRead = -1;
    private int iWrite = -1;
    private int iSetPolicy = -1;
    private boolean currObjectDeniedRead;
    private boolean currObjectDeniedSetPolicy;
    private int queryOptions;
    private List<String> permissions_;
    private int numEnforcedPerms;
    private int[] filterPermissions;
    private int[] currPolicyCheckResults;
    private int currPoliciesPermissions;

    public CMDbStoreSecurityHandler(List<String> permissions, int[] filterPermisssions, List<String> otherPermissions, int queryOptions) {
        this.filterPermissions = filterPermisssions;
        this.queryOptions = queryOptions;
        this.permissions_ = new ArrayList<String>();
        if (permissions != null) {
            this.permissions_.addAll(permissions);
            this.numEnforcedPerms = permissions.size();
        }
        if (otherPermissions != null) {
            this.permissions_.addAll(otherPermissions);
        }
        if (!this.permissions_.isEmpty()) {
            this.initPermissionIndices();
            if (this.hasOption(1) && this.iSetPolicy == -1) {
                throw new IllegalStateException("setPolicy must be one of the permissions being checked if force is turned on");
            }
            if (this.hasOption(8) && this.iTraverse == -1) {
                throw new IllegalStateException("read must be one of the permissions being checked for a target of a move or copy");
            }
            if (this.hasOption(32) && this.iExecute == -1) {
                throw new IllegalStateException("execute must be one of the permissions being checked for a parent when creating a runHistory");
            }
            this.currPolicyCheckResults = new int[this.permissions_.size()];
        }
    }

    private void initPermissionIndices() {
        block14: for (int i = 0; i < this.permissions_.size(); ++i) {
            switch (this.permissions_.get(i)) {
                case "setPolicy": {
                    if (this.iSetPolicy != -1) continue block14;
                    this.iSetPolicy = i;
                    continue block14;
                }
                case "write": {
                    if (this.iWrite != -1) continue block14;
                    this.iWrite = i;
                    continue block14;
                }
                case "execute": {
                    if (this.iExecute != -1) continue block14;
                    this.iExecute = i;
                    continue block14;
                }
                case "traverse": {
                    if (this.iTraverse != -1) continue block14;
                    this.iTraverse = i;
                    continue block14;
                }
                case "read": {
                    if (this.iRead != -1) continue block14;
                    this.iRead = i;
                }
            }
        }
    }

    private boolean hasOption(int opt) {
        return (this.queryOptions & opt) != 0;
    }

    private final int[] performAccessChecks(CMCacheQueryInstance query2, int objectIndex, int objectID, byte[] policies) throws CMException {
        int[] results;
        block10: {
            results = null;
            if (policies == null && this.filterPermissions != null) {
                try {
                    policies = query2.getAcquiredPolicy(objectIndex, 1);
                }
                catch (CMCacheException ex) {
                    throw new CMStoreUnexpected(ex, "cmStoreUnexpectedErrCacheCheckAccess");
                }
            }
            if (policies == null) {
                try {
                    results = query2.checkAccess(objectIndex, 0);
                    if (results == null) {
                        return this.currPolicyCheckResults;
                    }
                    break block10;
                }
                catch (CMCacheException ex) {
                    throw new CMStoreUnexpected(ex, "cmStoreUnexpectedErrCacheCheckAccess");
                }
                catch (CMCacheAccessDenied ex) {
                    throw new IllegalStateException("Cache threw AccessDenied exception when it should not");
                }
            }
            try {
                CMExecutionContext context = CMExecutionContext.get();
                boolean bGrantAll = context.executingStaticRequest() || context.getCurrentUserIsAdministrator();
                AznUtil azn = new AznUtil(CMServlet.AAA, context.getAccManPassportID(), context.getCAMAdditionalInfo());
                results = azn.bulkCheckAccess(policies, this.permissions_, bGrantAll);
            }
            catch (AAAException ex) {
                throw new CMException((Exception)((Object)ex), "cmNoCheckAccess");
            }
        }
        return results;
    }

    public boolean keepObjectAfterAccessChecks(CMDbStore store, CMDbObjectClass objectClass, CMDbStoreObjectReference owner, CMCacheQueryInstance query2, byte[] policies, int objectID, int objectIndex, boolean captureInheritedValues) throws CMException {
        int iOwner;
        boolean keep = true;
        this.currObjectDeniedRead = false;
        this.currObjectDeniedSetPolicy = false;
        if (this.permissions_.isEmpty()) {
            return keep;
        }
        CMExecutionContext currentContext = CMExecutionContext.get();
        Arrays.fill(this.currPolicyCheckResults, 0);
        if (this.adminCanSkipAccessChecks(currentContext, objectClass, objectID, store)) {
            return true;
        }
        if (this.hasOption(2) && objectClass == CMObjectClass.HISTORY) {
            return true;
        }
        if (owner != null && currentContext.getCurrentUserIdentityIncludesObject(owner.getObjectID())) {
            if (captureInheritedValues) {
                int[] results = this.performAccessChecks(query2, objectIndex, objectID, policies);
                try {
                    this.computePolicyFlags(store.getCache().CMCacheIsObjectDisabled(objectID), results);
                }
                catch (CMCacheException ex) {
                    throw new CMException(ex, "cmNoCheckAccess");
                }
            }
            return true;
        }
        boolean isDisabledCalculated = false;
        boolean isDisabled = false;
        trustedService currentService = currentContext.getTrustedService();
        boolean bAllAccessGranted = false;
        if (currentService != null && currentService.getAppliesToAllPermissions()) {
            try {
                isDisabled = store.getCache().CMCacheIsObjectDisabled(objectID);
                isDisabledCalculated = true;
            }
            catch (CMCacheException ex) {
                throw new CMException(ex, "cmNoCheckAccess");
            }
            Arrays.fill(this.currPolicyCheckResults, 1);
            bAllAccessGranted = currentService.trustedCheckAccess(this.currPolicyCheckResults, this.permissions_, objectClass);
        }
        String currentUserPassport = currentContext.getAccManPassportID();
        if (!bAllAccessGranted && currentUserPassport != null) {
            this.currPolicyCheckResults = this.performAccessChecks(query2, objectIndex, objectID, policies);
            if (captureInheritedValues) {
                if (!isDisabledCalculated) {
                    try {
                        isDisabled = store.getCache().CMCacheIsObjectDisabled(objectID);
                        isDisabledCalculated = true;
                    }
                    catch (CMCacheException ex) {
                        throw new CMException(ex, "cmNoCheckAccess");
                    }
                }
                this.computePolicyFlags(isDisabled, this.currPolicyCheckResults);
            }
        }
        if (!bAllAccessGranted) {
            if (currentService != null) {
                if (!isDisabledCalculated) {
                    try {
                        isDisabled = store.getCache().CMCacheIsObjectDisabled(objectID);
                        isDisabledCalculated = true;
                    }
                    catch (CMCacheException ex) {
                        throw new CMException(ex, "cmNoCheckAccess");
                    }
                }
                if (!isDisabled) {
                    currentService.trustedCheckAccess(this.currPolicyCheckResults, this.permissions_, objectClass);
                }
            }
            try {
                if (this.isDenied(this.iWrite) && this.isDenied(this.iSetPolicy)) {
                    if (!isDisabledCalculated) {
                        isDisabled = store.getCache().CMCacheIsObjectDisabled(objectID);
                        isDisabledCalculated = true;
                    }
                    if (isDisabled) {
                        Arrays.fill(this.currPolicyCheckResults, 1);
                    }
                }
            }
            catch (CMCacheException ex) {
                throw new CMException(ex, "cmNoCheckAccess");
            }
        }
        if (owner == null && (iOwner = store.getOwnerObjectID(objectID)) > 0) {
            for (int i = 0; i < this.currPolicyCheckResults.length; ++i) {
                if (this.isGranted(i) || !currentContext.getCurrentUserIdentityIncludesObject(iOwner)) continue;
                if (captureInheritedValues) {
                    int[] results = this.performAccessChecks(query2, objectIndex, objectID, policies);
                    try {
                        this.computePolicyFlags(store.getCache().CMCacheIsObjectDisabled(objectID), results);
                    }
                    catch (CMCacheException ex) {
                        throw new CMException(ex, "cmNoCheckAccess");
                    }
                }
                while (i < this.currPolicyCheckResults.length) {
                    this.currPolicyCheckResults[i] = 0;
                    ++i;
                }
                return true;
            }
        }
        if (this.filterPermissions != null && !this.keepObjectAfterFilterPermissions()) {
            keep = false;
        }
        if (keep && (!this.hasOption(1) || this.isDenied(this.iSetPolicy))) {
            for (int i = 0; i < this.numEnforcedPerms; ++i) {
                if (!this.isDenied(i)) continue;
                if (i == this.iRead && !this.hasOption(16)) {
                    this.currObjectDeniedRead = true;
                    continue;
                }
                if (i == this.iSetPolicy && this.hasOption(64)) {
                    this.currObjectDeniedSetPolicy = true;
                    continue;
                }
                this.throwPermissionException(query2, objectIndex, i);
            }
        }
        if (keep && this.hasOption(8) && this.isDenied(this.iTraverse)) {
            this.throwPermissionException(query2, objectIndex, this.iTraverse);
        }
        if (keep && this.hasOption(128) && (!this.hasOption(1) || this.isDenied(this.iSetPolicy)) && store.getCache().CMCacheGetHasChildren(objectID) && this.isDenied(this.iTraverse)) {
            this.throwPermissionException(query2, objectIndex, this.iTraverse);
        }
        if (keep && this.hasOption(32) && this.isDenied(this.iExecute)) {
            this.throwPermissionException(query2, objectIndex, this.iExecute);
        }
        if (this.hasOption(4)) {
            int option = this.hasOption(1) ? 2 : 1;
            try {
                query2.checkAccess(objectIndex, option);
            }
            catch (CMCacheException ex) {
                throw new CMStoreUnexpected(ex, "cmStoreUnexpectedErrCacheCheckParent");
            }
            catch (CMCacheAccessDenied ex) {
                CMDbStoreSecurityUtil.convertAccessDeniedException(store.getCache(), ex);
            }
        }
        return keep;
    }

    private void throwPermissionException(CMCacheQueryInstance query2, int objectIndex, int permIdx) throws CMException {
        String objectName = "<unknown>";
        try {
            objectName = query2.objectPath(objectIndex, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (CMCacheException cMCacheException) {
            // empty catch block
        }
        CMDbStoreSecurityUtil.throwPermissionException(this.permissions_.get(permIdx), objectName);
    }

    private boolean adminCanSkipAccessChecks(CMExecutionContext currentContext, CMDbObjectClass objectClass, int objectID, CMDbStore store) throws CMException {
        if (currentContext.getCurrentUserIsAdministrator()) {
            this.adminAdjustNamespacePermissions(objectClass, objectID, store);
            return true;
        }
        return false;
    }

    private void adminAdjustNamespacePermissions(CMDbObjectClass objectClass, int objectID, CMDbStore store) throws CMException {
        if (objectClass == CMObjectClass.NAMESPACE) {
            String namespaceID;
            try {
                namespaceID = store.getCache().CMCacheGetName(objectID, new int[]{0});
            }
            catch (Exception ex) {
                throw new CMStoreUnexpected(ex, "asddsa");
            }
            if (namespaceID.charAt(0) != ':') {
                if (this.iTraverse != -1) {
                    this.currPolicyCheckResults[this.iTraverse] = 1;
                }
                if (this.iRead != -1) {
                    this.currPolicyCheckResults[this.iRead] = 0;
                }
                if (CMExecutionContext.get().isUserAuthenticatedIntoNamespace(namespaceID) && this.iTraverse != -1) {
                    this.currPolicyCheckResults[this.iTraverse] = 0;
                }
            }
        }
    }

    public boolean hasPermission(String permission) {
        for (int i = 0; i < this.permissions_.size(); ++i) {
            if (!this.permissions_.get(i).equals(permission)) continue;
            return this.isGranted(i);
        }
        throw new IllegalStateException("Query for permission without properly enumerating them");
    }

    private boolean isGranted(int idx) {
        return this.currPolicyCheckResults[idx] == 0;
    }

    private boolean isDenied(int idx) {
        return this.currPolicyCheckResults[idx] == 1;
    }

    public boolean readAccessDenied() {
        if (this.iRead != -1 && this.iRead < this.numEnforcedPerms) {
            return this.currObjectDeniedRead;
        }
        return false;
    }

    public boolean setPolicyAccessDenied() {
        return this.currObjectDeniedSetPolicy;
    }

    public List<String> getPermissions() {
        return this.permissions_;
    }

    public int[] getPolicyCheckResults() {
        return this.currPolicyCheckResults;
    }

    private boolean keepObjectAfterFilterPermissions() {
        int i;
        for (i = 0; i < this.filterPermissions.length && !this.isGranted(this.filterPermissions[i]); ++i) {
        }
        return i < this.filterPermissions.length;
    }

    public int getGrantedPermissions() {
        return this.currPoliciesPermissions;
    }

    private final void computePolicyFlags(boolean isDisabled, int[] permResults) {
        this.currPoliciesPermissions = 0;
        if (isDisabled) {
            this.currPoliciesPermissions |= 0x20;
        }
        if (permResults != null) {
            if (permResults[this.iRead] == 0) {
                this.currPoliciesPermissions |= 1;
            }
            if (permResults[this.iTraverse] == 0) {
                this.currPoliciesPermissions |= 2;
            }
            if (permResults[this.iWrite] == 0) {
                this.currPoliciesPermissions |= 4;
            }
            if (permResults[this.iSetPolicy] == 0) {
                this.currPoliciesPermissions |= 8;
            }
            if (permResults[this.iExecute] == 0) {
                this.currPoliciesPermissions |= 0x10;
            }
        }
    }

    public boolean isCurrentUserOwnerOf(int objID) {
        boolean isOwner = false;
        CMExecutionContext context = CMExecutionContext.get();
        int iOwner = -1;
        try {
            iOwner = context.getStore().getOwnerObjectID(objID);
        }
        catch (CMException cmEx) {
            CMIndications.logException(cmEx);
        }
        if (iOwner > 0 && context.getCurrentUserIdentityIncludesObject(iOwner)) {
            isOwner = true;
        }
        return isOwner;
    }
}

