/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.CAM.AAAException;
import com.cognos.cm.cam.azn.AznUtil;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.CMAsyncAAASearch;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbPropertyHandlerProvider;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreAcquiredPropertiesHandler;
import com.cognos.cm.dbstore.CMDbStoreCacheComplexObjects;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreObjects;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreSecurityUtil;
import com.cognos.cm.dbstore.CMDbStoreSelectDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.CMPropertyHandler;
import com.cognos.cm.dbstore.PropertyArray;
import com.cognos.cm.dbstore.properties.CMDbStoreAncestors;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.dbstore.properties.CMDbStorePermissions;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multipart.Base64;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMBaseClassArray;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.trustedServices.trustedService;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.date.DateUtils;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMDbStoreSecurityQueryResults
implements CMStoreQueryResults {
    private static final Object UNSET = new Object();
    private ResultSet rs_;
    private CMDbStore.ReadTransactionHandle rtHandle_;
    private String AccManPassportID_;
    private ICMStorePath query_;
    private CMDbStore store_;
    private Node currentChild_;
    private Object[] values_;
    private boolean[] fromExternal_;
    private int searchPathIdx_ = -1;
    private Document queryResults_;
    private PropertyArray properties;
    private CMObjectClass currObjectClass_;
    private int currObjectState_;
    private int currObjectID_;
    private Date currCreationTime_;
    private static final String pathStart_ = "/child::*[@objectClass=\"directory\"]";
    private int[] filterPermissions_;
    private int[] currPolicyCheckResults_;
    private int[] accountTemplatePolicyCheckResults_;
    private List<String> permissions_;
    private int[] enforcedPermissions_;
    private CMDbStoreObjectReference currOwner_;
    private byte[] currPolicies_;
    private byte[] accountTemplatePolicy_;
    private byte[] namespacePolicy_;
    private int permissionsIdx_ = -1;
    private boolean currObjectDeniedSetPolicy_;
    private boolean currObjectDeniedRead_;
    private int usefulPermIdxExecute_ = -1;
    private int usefulPermIdxRead_ = -1;
    private int usefulPermIdxWrite_ = -1;
    private int usefulPermIdxSetPolicy_ = -1;
    private boolean dontThrowSetPolicy_;
    private String baseQuery_;
    private boolean canUseCAMSkipObjects_;
    private int reqSkipObjects_ = -1;
    private int reqMaxObjects_ = -1;
    private int curCAMSkipObjects_;
    private int curCAMObjectsRetrieved_;
    private int curQueryObjectsRetrieved_;
    private int maxCAMObjectsThisQuery_;
    private int retrievedCAMObjectsThisQuery_;
    private static final int MAXOBJECTSFIRSTQUERY = 10;
    private int maxCAMObjectsPerQuery_ = 10;
    private boolean atBOF = true;
    private boolean wasAcquired_;
    private BitSet wasAcquiredSet_;
    private boolean productLocaleWasAcquired_;
    private boolean contentLocaleWasAcquired_;
    private CMDbPropertyHandlerProvider propertyHandlerUtil_;
    private CMDbStoreAcquiredPropertiesHandler acquiredProperties_;
    private int policiesIdx = -1;
    private boolean lockAcquired;

    public CMDbStoreSecurityQueryResults(CMDbStore store, ICMStorePath query2, CMProperty[] properties, OrderByField[] orderBy, int permissionFlags, String AccManPassportID, List<String> enforcedPerms) {
        this.Initialize(store, query2, properties, orderBy, permissionFlags, enforcedPerms, AccManPassportID, -1, -1);
    }

    public CMDbStoreSecurityQueryResults(CMDbStore store, ICMStorePath query2, CMProperty[] properties, OrderByField[] orderBy, int permissionFlags, String AccManPassportID, List<String> enforcedPerms, int skipObjects, int maxObjects) {
        this.Initialize(store, query2, properties, orderBy, permissionFlags, enforcedPerms, AccManPassportID, skipObjects, maxObjects);
    }

    private void Initialize(CMDbStore store, ICMStorePath query2, CMProperty[] properties, OrderByField[] orderBy, int permissionFlags, List<String> enforcedPerms, String AccManPassportID, int skipObjects, int maxObjects) {
        this.query_ = query2;
        this.AccManPassportID_ = AccManPassportID;
        this.store_ = store;
        this.propertyHandlerUtil_ = new CMDbPropertyHandlerProvider(this.store_);
        this.filterPermissions_ = this.getPermissions(permissionFlags, query2, enforcedPerms);
        if (this.filterPermissions_ == null || this.filterPermissions_.length == 0) {
            this.canUseCAMSkipObjects_ = true;
        }
        this.reqSkipObjects_ = skipObjects;
        this.reqMaxObjects_ = maxObjects;
        if (this.reqMaxObjects_ == 0) {
            this.reqMaxObjects_ = -1;
        }
        if (properties == null) {
            properties = new CMProperty[]{};
        }
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append(CMSOAPConstants.SOAPEnvHeaderStart);
        queryBuf.append(CMExecutionContext.get().getCAMAdditionalInfo());
        queryBuf.append(CMSOAPConstants.SOAPHeaderToBody);
        queryBuf.append("<bus:query>");
        queryBuf.append("<search>");
        String aQuery = query2.getCAMQuery();
        if (aQuery.startsWith(pathStart_)) {
            aQuery = "/directory" + aQuery.substring(pathStart_.length());
        }
        if (query2.size() == 2 && aQuery.startsWith("/directory/*")) {
            aQuery = "/directory/*";
        }
        if (aQuery.endsWith("child::*")) {
            aQuery = aQuery.substring(0, aQuery.length() - 8) + "*";
        } else if (aQuery.endsWith("child::*[permission(\"read\")]")) {
            aQuery = aQuery.substring(0, aQuery.length() - 28) + "*";
        }
        queryBuf.append(XMLUtils.escape((String)aQuery));
        queryBuf.append("</search>");
        queryBuf.append("<properties xsi:type='SOAP-ENC:Array' SOAP-ENC:arrayType='bus:propEnum[");
        int ownerIdx = -1;
        int[] externalPropMap = new int[properties.length + 1];
        int numExternalProps = 0;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i] == CMProperty.SEARCHPATH) {
                externalPropMap[numExternalProps++] = i;
                this.searchPathIdx_ = i;
            } else if (properties[i].isExternal() || properties[i] == CMProperty.ANCESTORS || properties[i] == CMProperty.HASCHILDREN || properties[i] == CMProperty.CONTENTLOCALE || properties[i] == CMProperty.PRODUCTLOCALE || properties[i] == CMProperty.DEFAULTNAME || properties[i] == CMProperty.NAME || properties[i] == CMProperty.PARENT || properties[i] == CMProperty.COMMONSYMMETRICKEY || properties[i] == CMProperty.CACHEDCACERTIFICATES || properties[i] == CMProperty.PARAMETERS) {
                externalPropMap[numExternalProps++] = i;
            }
            if (properties[i] == CMProperty.POLICIES) {
                this.policiesIdx = i;
                continue;
            }
            if (properties[i] == CMProperty.PERMISSIONS) {
                this.permissionsIdx_ = i;
                continue;
            }
            if (properties[i] != CMProperty.OWNER) continue;
            ownerIdx = i;
        }
        this.properties = new PropertyArray(properties);
        if (!(this.permissions_ == null && this.permissionsIdx_ == -1 || this.policiesIdx != -1 && ownerIdx != -1 || CMExecutionContext.get().getCurrentUserIsAdministrator())) {
            if (this.policiesIdx == -1) {
                this.policiesIdx = this.properties.append(CMProperty.POLICIES);
            }
            if (ownerIdx == -1) {
                this.properties.append(CMProperty.OWNER);
            }
        }
        if (this.searchPathIdx_ < 0 && (this.properties.size() != 0 || 0 == (permissionFlags & 0x10000))) {
            this.searchPathIdx_ = this.properties.append(CMProperty.SEARCHPATH);
            externalPropMap[numExternalProps++] = this.searchPathIdx_;
        }
        queryBuf.append(Integer.toString(numExternalProps));
        queryBuf.append("]'>");
        boolean hasParent = false;
        boolean hasAncestors = false;
        for (int i = 0; i < numExternalProps; ++i) {
            CMProperty prop = this.properties.get(externalPropMap[i]);
            if (prop != CMProperty.PARENT) {
                queryBuf.append("<item xsi:type='bus:propEnum'>");
                queryBuf.append(prop.getName());
                queryBuf.append("</item>");
            } else {
                hasParent = true;
            }
            if (prop != CMProperty.ANCESTORS) continue;
            hasAncestors = true;
        }
        if (hasParent && !hasAncestors) {
            queryBuf.append("<item xsi:type='bus:propEnum'>");
            queryBuf.append(CMProperty.ANCESTORS.getName());
            queryBuf.append("</item>");
        }
        queryBuf.append("</properties>");
        if (orderBy != null && orderBy.length > 0) {
            queryBuf.append("<sortBy xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:sort[");
            queryBuf.append(Integer.toString(orderBy.length));
            queryBuf.append("]\">");
            for (int iSortBy = 0; iSortBy < orderBy.length; ++iSortBy) {
                queryBuf.append("<item xsi:type=\"cm:sort\">");
                queryBuf.append("<propName xsi:type=\"cm:propEnum\">");
                queryBuf.append(orderBy[iSortBy].property.getName());
                queryBuf.append("</propName>");
                queryBuf.append("<order xsi:type=\"cm:orderEnum\">");
                if (orderBy[iSortBy].bDescend) {
                    queryBuf.append("descending");
                } else {
                    queryBuf.append("ascending");
                }
                queryBuf.append("</order>");
                queryBuf.append("</item>");
            }
            queryBuf.append("</sortBy>");
        }
        this.baseQuery_ = queryBuf.toString();
        this.values_ = new Object[this.properties.size()];
        this.fromExternal_ = new boolean[this.properties.size()];
    }

    private void advance() throws CMException {
        if (this.queryResults_ == null && !this.fetchMoreRecords()) {
            this.currentChild_ = null;
            return;
        }
        if (!this.atBOF) {
            this.currentChild_ = this.currentChild_.getNextSibling();
            while (this.currentChild_ != null && this.currentChild_.getNodeType() != 1) {
                this.currentChild_ = this.currentChild_.getNextSibling();
            }
            if (this.currentChild_ == null) {
                if (!this.fetchMoreRecords()) {
                    this.currentChild_ = null;
                    return;
                }
            } else {
                ++this.curCAMObjectsRetrieved_;
                ++this.retrievedCAMObjectsThisQuery_;
            }
        }
        if (this.atBOF) {
            Node resultNode;
            NodeList objects;
            Node responseNode = this.queryResults_.getFirstChild();
            if (responseNode != null && (objects = (resultNode = responseNode.getFirstChild()).getChildNodes()).getLength() > 0) {
                this.currentChild_ = objects.item(0);
                while (this.currentChild_ != null && this.currentChild_.getNodeType() != 1) {
                    this.currentChild_ = this.currentChild_.getNextSibling();
                }
                ++this.curCAMObjectsRetrieved_;
                ++this.retrievedCAMObjectsThisQuery_;
            }
            this.atBOF = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean fetchMoreRecords() throws CMException {
        String results;
        if (this.curCAMObjectsRetrieved_ > 0 && this.retrievedCAMObjectsThisQuery_ < this.maxCAMObjectsThisQuery_) {
            return false;
        }
        this.currentChild_ = null;
        this.retrievedCAMObjectsThisQuery_ = 0;
        if (this.reqSkipObjects_ > this.curCAMSkipObjects_ && this.canUseCAMSkipObjects_) {
            this.curCAMObjectsRetrieved_ = this.reqSkipObjects_;
            this.curQueryObjectsRetrieved_ = this.reqSkipObjects_;
        }
        this.curCAMSkipObjects_ = this.curCAMObjectsRetrieved_;
        this.maxCAMObjectsThisQuery_ = this.reqMaxObjects_ < 0 ? this.maxCAMObjectsPerQuery_ : Math.min(this.maxCAMObjectsPerQuery_, this.reqMaxObjects_ - this.curQueryObjectsRetrieved_ + this.reqSkipObjects_);
        StringBuilder queryBuf = new StringBuilder(this.baseQuery_);
        queryBuf.append("<options xsi:type=\"cm:queryOptions\">");
        queryBuf.append("<skipObjects xsi:type=\"xsd:integer\">");
        queryBuf.append(Integer.toString(this.curCAMSkipObjects_));
        queryBuf.append("</skipObjects>");
        queryBuf.append("<maxObjects xsi:type=\"xsd:integer\">");
        queryBuf.append(Integer.toString(this.maxCAMObjectsThisQuery_));
        queryBuf.append("</maxObjects>");
        queryBuf.append("</options>");
        queryBuf.append("</bus:query>");
        queryBuf.append(CMSOAPConstants.SOAPBodyEnvEnd);
        try {
            results = queryBuf.toString();
            if (AdvancedSettings.ENABLEMAXEXECUTIONTIMEOUT && CMExecutionContext.isOperationPatternMatch()) {
                CMAsyncAAASearch asyncAAASearch = new CMAsyncAAASearch(this.AccManPassportID_, results);
                do {
                    CMAsyncAAASearch cMAsyncAAASearch = asyncAAASearch;
                    synchronized (cMAsyncAAASearch) {
                        CMExecutionContext.checkCancelOrTimeOut(true);
                        asyncAAASearch.wait(5000L);
                    }
                } while (!asyncAAASearch.isExecutionComplete());
                CMException ex = asyncAAASearch.getStatus();
                if (ex != null) throw ex;
                results = asyncAAASearch.getResult();
            } else {
                results = CMServlet.AAA.Search(this.AccManPassportID_, results);
            }
            if (results != null) {
                this.queryResults_ = CMXMLUtils.parseString(results);
            }
        }
        catch (AAAException ex) {
            throw new CMException((Exception)((Object)ex), "cmNameSpaceQueryErr");
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmNameSpaceQueryErr");
        }
        if (this.maxCAMObjectsPerQuery_ == 10) {
            int avgSize = (results.length() - 264) / 10;
            if (avgSize < 26) {
                avgSize = 26;
            }
            this.maxCAMObjectsPerQuery_ = AdvancedSettings.MAXCAMRESPONSE * 1024 / avgSize;
            if (this.maxCAMObjectsPerQuery_ <= 10) {
                this.maxCAMObjectsPerQuery_ = 11;
            }
        }
        this.atBOF = true;
        return true;
    }

    private static int addPermissionToList(List<String> perms, String perm) {
        for (int i = 0; i < perms.size(); ++i) {
            if (!perms.get(i).equals(perm)) continue;
            return i;
        }
        perms.add(perm);
        return perms.size() - 1;
    }

    private int[] getPermissions(int permissionFlags, ICMStorePath query2, List<String> enforcedPerms) {
        CMStorePathStep step;
        int[] filterPermissions = null;
        this.permissions_ = new ArrayList<String>();
        int numEnforced = 0;
        if (enforcedPerms != null) {
            numEnforced += enforcedPerms.size();
        }
        if (AdvancedSettings.SECURITYQUERYREQUIRESREAD) {
            ++numEnforced;
        }
        if (permissionFlags != 0) {
            if ((permissionFlags & 2) != 0) {
                ++numEnforced;
            }
            if ((permissionFlags & 0x800) != 0) {
                ++numEnforced;
            }
            if ((permissionFlags & 1) != 0 || (permissionFlags & 0x400) != 0) {
                ++numEnforced;
            }
            if ((permissionFlags & 4) != 0) {
                ++numEnforced;
            }
        }
        if ((permissionFlags & 0x1000) != 0) {
            this.dontThrowSetPolicy_ = true;
        }
        if (query2.size() > 0 && (step = query2.stepAt(query2.size() - 1)).requiresReadAccess()) {
            ++numEnforced;
        }
        this.enforcedPermissions_ = new int[numEnforced];
        for (int idxEnforced = 0; enforcedPerms != null && idxEnforced < enforcedPerms.size(); ++idxEnforced) {
            this.enforcedPermissions_[idxEnforced] = CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, enforcedPerms.get(idxEnforced));
        }
        if (AdvancedSettings.SECURITYQUERYREQUIRESREAD) {
            this.enforcedPermissions_[idxEnforced++] = CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, "read");
        }
        if (permissionFlags != 0) {
            if ((permissionFlags & 1) != 0 || (permissionFlags & 0x400) != 0) {
                this.enforcedPermissions_[idxEnforced++] = CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, "read");
            }
            if ((permissionFlags & 2) != 0) {
                this.enforcedPermissions_[idxEnforced++] = CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, "write");
            }
            if ((permissionFlags & 0x800) != 0) {
                this.enforcedPermissions_[idxEnforced++] = CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, "execute");
            }
            if ((permissionFlags & 4) != 0) {
                this.enforcedPermissions_[idxEnforced++] = CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, "setPolicy");
            }
        }
        if (query2.size() > 0) {
            List<String> stepPerms;
            int nStepPerms;
            CMStorePathStep step2 = query2.stepAt(query2.size() - 1);
            if (step2.requiresReadAccess()) {
                this.enforcedPermissions_[idxEnforced++] = CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, "read");
            }
            int nFilterPerms = nStepPerms = (stepPerms = step2.getFilterPermissions()) != null ? stepPerms.size() : 0;
            if (AdvancedSettings.SECURITYQUERYREQUIRESREAD) {
                ++nFilterPerms;
            }
            if (nFilterPerms > 0) {
                filterPermissions = new int[nFilterPerms];
                for (int i = 0; i < nStepPerms; ++i) {
                    filterPermissions[i] = CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, stepPerms.get(i));
                }
                if (AdvancedSettings.SECURITYQUERYREQUIRESREAD) {
                    filterPermissions[nFilterPerms - 1] = CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, "read");
                }
            }
        }
        CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, "write");
        CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, "setPolicy");
        if ((permissionFlags & 0x20) != 0) {
            CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, "read");
            CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, "execute");
            CMDbStoreSecurityQueryResults.addPermissionToList(this.permissions_, "traverse");
        }
        for (int i = 0; i < this.permissions_.size(); ++i) {
            if (this.permissions_.get(i).equals("execute") && this.usefulPermIdxExecute_ == -1) {
                this.usefulPermIdxExecute_ = i;
                continue;
            }
            if (this.permissions_.get(i).equals("read") && this.usefulPermIdxRead_ == -1) {
                this.usefulPermIdxRead_ = i;
                continue;
            }
            if (this.permissions_.get(i).equals("write") && this.usefulPermIdxWrite_ == -1) {
                this.usefulPermIdxWrite_ = i;
                continue;
            }
            if (!this.permissions_.get(i).equals("setPolicy") || this.usefulPermIdxSetPolicy_ != -1) continue;
            this.usefulPermIdxSetPolicy_ = i;
        }
        this.currPolicyCheckResults_ = new int[this.permissions_.size()];
        return filterPermissions;
    }

    private static String getObjectNameFromPath(String accmanPath) {
        int lastSlash = accmanPath.lastIndexOf(47);
        return accmanPath.substring(lastSlash + 1);
    }

    boolean readAccessDenied() {
        return this.currObjectDeniedRead_;
    }

    @Override
    public void release() {
        this.reset();
    }

    @Override
    public boolean next() throws CMException {
        boolean bmore = true;
        if (this.reqMaxObjects_ > -1 && this.curQueryObjectsRetrieved_ - this.reqSkipObjects_ >= this.reqMaxObjects_) {
            bmore = false;
        }
        while (bmore) {
            CMExecutionContext.checkCancelOrTimeOut();
            this.advance();
            if (this.currentChild_ != null) {
                if (this.rs_ != null) {
                    CMDbStoreUtil.safeCloseStatementViaResultSet(this.rs_);
                    this.rs_ = null;
                }
                if (this.rtHandle_ != null) {
                    CMDbStore.releaseReadTransaction(this.rtHandle_);
                    this.rtHandle_ = null;
                }
                this.getValues();
                if (!this.keepObjectAfterAccessChecks()) continue;
                if (this.permissionsIdx_ != -1) {
                    CMDbStorePermissions value = new CMDbStorePermissions();
                    for (int j = 0; j < this.currPolicyCheckResults_.length; ++j) {
                        if (this.currPolicyCheckResults_[j] != 0) continue;
                        value.add(this.permissions_.get(j));
                    }
                    this.values_[this.permissionsIdx_] = value;
                }
                if (++this.curQueryObjectsRetrieved_ <= this.reqSkipObjects_) continue;
                break;
            }
            bmore = false;
        }
        return bmore;
    }

    private boolean keepObjectAfterAccessChecks() throws CMException {
        boolean keep = true;
        this.currObjectDeniedRead_ = false;
        this.currObjectDeniedSetPolicy_ = false;
        this.currPolicyCheckResults_ = null;
        if (this.permissions_ != null && this.permissions_.size() > 0) {
            boolean fullAccess;
            CMExecutionContext currentContext = CMExecutionContext.get();
            boolean bl = fullAccess = currentContext.getCurrentUserIsAdministrator() || currentContext.executingStaticRequest() || this.currOwner_ != null && currentContext.getCurrentUserIdentityIncludesObject(this.currOwner_.getObjectID());
            if (fullAccess) {
                if (this.currPolicyCheckResults_ == null) {
                    this.currPolicyCheckResults_ = new int[this.permissions_.size()];
                }
                for (int j = 0; j < this.currPolicyCheckResults_.length; ++j) {
                    this.currPolicyCheckResults_[j] = 0;
                }
                return true;
            }
            trustedService currentService = currentContext.getTrustedService();
            boolean bAllAccessGranted = false;
            if (currentService != null && currentService.getAppliesToAllPermissions()) {
                if (this.currPolicyCheckResults_ == null) {
                    this.currPolicyCheckResults_ = new int[this.permissions_.size()];
                }
                for (int i = 0; i < this.currPolicyCheckResults_.length; ++i) {
                    this.currPolicyCheckResults_[i] = 1;
                }
                bAllAccessGranted = currentService.trustedCheckAccess(this.currPolicyCheckResults_, this.permissions_, this.currObjectClass_);
            }
            String currentUserPassport = currentContext.getAccManPassportID();
            CMExecutionContext context = CMExecutionContext.get();
            boolean bGrantAll = context.executingStaticRequest() || context.getCurrentUserIsAdministrator();
            AznUtil azn = new AznUtil(CMServlet.AAA, currentUserPassport, context.getCAMAdditionalInfo());
            if (!bAllAccessGranted && currentUserPassport != null) {
                if (this.currPolicies_ != null) {
                    try {
                        if (this.currPolicies_ == this.accountTemplatePolicy_) {
                            if (this.accountTemplatePolicyCheckResults_ == null) {
                                this.accountTemplatePolicyCheckResults_ = azn.bulkCheckAccess(this.accountTemplatePolicy_, this.permissions_, bGrantAll);
                            }
                            this.currPolicyCheckResults_ = this.accountTemplatePolicyCheckResults_;
                        }
                        this.currPolicyCheckResults_ = azn.bulkCheckAccess(this.currPolicies_, this.permissions_, bGrantAll);
                    }
                    catch (AAAException ex) {
                        throw new CMException((Exception)((Object)ex), "cmNoCheckAccess");
                    }
                } else {
                    if (this.currPolicyCheckResults_ == null) {
                        this.currPolicyCheckResults_ = new int[this.permissions_.size()];
                    }
                    try {
                        byte[] nsPolicies = this.getExternalNamespacePolicy();
                        if (nsPolicies != null) {
                            this.currPolicyCheckResults_ = azn.bulkCheckAccess(nsPolicies, this.permissions_, bGrantAll);
                        } else {
                            for (int i = 0; i < this.permissions_.size(); ++i) {
                                this.currPolicyCheckResults_[i] = 0;
                            }
                        }
                    }
                    catch (AAAException ex) {
                        throw new CMException((Exception)((Object)ex), "cmNoCheckAccess");
                    }
                }
            }
            if (!bAllAccessGranted) {
                if (currentService != null) {
                    currentService.trustedCheckAccess(this.currPolicyCheckResults_, this.permissions_, this.currObjectClass_);
                }
                try {
                    if (this.currObjectID_ > 0 && this.currPolicyCheckResults_[this.usefulPermIdxWrite_] == 1 && this.currPolicyCheckResults_[this.usefulPermIdxSetPolicy_] == 1 && this.store_.getCache().CMCacheIsObjectDisabled(this.currObjectID_)) {
                        for (int i = 0; i < this.currPolicyCheckResults_.length; ++i) {
                            this.currPolicyCheckResults_[i] = 1;
                        }
                    }
                }
                catch (CMCacheException ex) {
                    throw new CMException(ex, "cmNoCheckAccess");
                }
            }
            if (this.filterPermissions_ != null) {
                int i;
                for (i = 0; i < this.filterPermissions_.length && this.currPolicyCheckResults_[this.filterPermissions_[i]] != 0; ++i) {
                }
                if (i >= this.filterPermissions_.length) {
                    keep = false;
                }
            }
            if (AdvancedSettings.SECURITYQUERYREQUIRESREAD && this.currPolicyCheckResults_[this.usefulPermIdxRead_] == 1) {
                this.currObjectDeniedRead_ = true;
                keep = false;
            }
            if (keep && this.enforcedPermissions_ != null) {
                int i;
                for (i = 0; i < this.enforcedPermissions_.length && this.currPolicyCheckResults_[this.enforcedPermissions_[i]] != 1; ++i) {
                }
                if (i != this.enforcedPermissions_.length) {
                    if (this.enforcedPermissions_[i] == this.usefulPermIdxRead_) {
                        this.currObjectDeniedRead_ = true;
                    } else if (this.enforcedPermissions_[i] == this.usefulPermIdxSetPolicy_ && this.dontThrowSetPolicy_) {
                        this.currObjectDeniedSetPolicy_ = true;
                    } else {
                        String objectName = null;
                        objectName = this.currObjectID_ > 0 ? this.store_.getPathUsingId(this.currObjectID_) : this.getSearchPath();
                        CMDbStoreSecurityUtil.throwPermissionException(this.permissions_.get(this.enforcedPermissions_[i]), objectName);
                    }
                }
            }
        }
        return keep;
    }

    private static CMAncestors extractAncestorInfo(Element propValue) throws CMException {
        if (propValue == null || !propValue.hasChildNodes()) {
            return null;
        }
        CMDbStoreAncestors result = new CMDbStoreAncestors();
        for (Node item = propValue.getFirstChild(); item != null; item = item.getNextSibling()) {
            if (item.getNodeType() != 1) continue;
            NodeList members = item.getChildNodes();
            String objClass = CMDbStoreSecurityQueryResults.getElementText("objectClass", members);
            String searchPath = CMDbStoreSecurityQueryResults.getElementText("searchPath", members);
            String title = CMDbStoreSecurityQueryResults.getElementText("title", members);
            String storeID = CMDbStoreSecurityQueryResults.getElementText("storeID", members);
            if (storeID == null) {
                if (searchPath.equals("/directory")) {
                    CMStore store = CMExecutionContext.get().getStore();
                    storeID = store.getDirectoryStoreID();
                } else {
                    String camid = CMDbStoreSecurityQueryResults.getCAMID(searchPath);
                    if (camid != null) {
                        storeID = CMCAMIDHelper.CAMID2storeID(camid);
                    }
                }
            }
            result.addChild(title, searchPath, objClass, storeID);
        }
        return result;
    }

    private static String getElementText(String name, NodeList nodes) {
        Element el = CMDbStoreSecurityQueryResults.findElement(name, nodes);
        return CMXMLUtils.getCharacterContent(el);
    }

    private static CMBaseClassArray extractBaseClassArray(Element propValue) {
        if (!propValue.hasChildNodes()) {
            return null;
        }
        CMDbStoreBaseClassArray baseClassArray = new CMDbStoreBaseClassArray();
        for (Node item = propValue.getFirstChild(); item != null; item = item.getNextSibling()) {
            String searchPath;
            if (item.getNodeType() != 1) continue;
            CMObjectClass objClass = CMDbStoreSecurityQueryResults.getObjectClassFromAAANode(item);
            Element value = CMDbStoreSecurityQueryResults.getPropertyValue(CMProperty.SEARCHPATH, item.getChildNodes());
            if (value == null || (searchPath = CMXMLUtils.getCharacterContent(value)) == null) continue;
            baseClassArray.add(new CMDbStoreObjectReference(objClass, searchPath));
        }
        return baseClassArray;
    }

    private static CMObjectClass getObjectClassFromAAANode(Node item) {
        NamedNodeMap attrs = item.getAttributes();
        String className = attrs.getNamedItem("xsi:type").getNodeValue();
        int colonPos = className.indexOf(58);
        if (colonPos >= 0) {
            className = className.substring(colonPos + 1);
        }
        return CMDbStoreFactory.objectClasses_.getClassByName(className);
    }

    private static CMLocalizedStringArray extractMultilingualStringArray(Element el) {
        CMDbStoreLocalizedStringArray strings = new CMDbStoreLocalizedStringArray();
        for (Node item = el.getFirstChild(); item != null; item = item.getNextSibling()) {
            if (item.getNodeType() != 1) continue;
            NodeList members = item.getChildNodes();
            String locale = CMDbStoreSecurityQueryResults.getElementText("locale", members);
            String value = CMDbStoreSecurityQueryResults.getElementText("value", members);
            strings.add(new CMDbStoreLocalizedString(CMDbStoreStringLocales.findLocale(locale), value));
        }
        return strings.getSize() > 0 ? strings : null;
    }

    private void resetForNextObject() {
        Arrays.fill(this.values_, null);
        Arrays.fill(this.fromExternal_, false);
        this.currObjectState_ = 2;
        this.currObjectID_ = 0;
        this.currCreationTime_ = null;
        this.currPolicies_ = null;
        this.currOwner_ = null;
        this.wasAcquiredSet_ = new BitSet(this.properties.size());
        this.safeReleaseLocks();
    }

    private void extractPropertiesFromCAMQueryResult(NodeList docProps) throws CMException {
        CMAncestors ancestors = null;
        for (int i = 0; i < this.properties.size(); ++i) {
            CMProperty prop = this.properties.get(i);
            if (prop.isExternal() || prop == CMProperty.SEARCHPATH || prop == CMProperty.ANCESTORS || prop == CMProperty.HASCHILDREN || prop == CMProperty.DEFAULTNAME || prop == CMProperty.NAME || prop == CMProperty.PRODUCTLOCALE || prop == CMProperty.CONTENTLOCALE || prop == CMProperty.PERMISSIONS || prop == CMProperty.PARAMETERS) {
                CMPropertyTypes.Type propType = prop.getType();
                Element propValue = CMDbStoreSecurityQueryResults.getPropertyValue(prop, docProps);
                if (propValue != null) {
                    if (propType == CMPropertyTypes.BIBUS_ANCESTORINFOARRAY) {
                        ancestors = CMDbStoreSecurityQueryResults.extractAncestorInfo(propValue);
                        this.values_[i] = ancestors;
                    } else {
                        this.values_[i] = propType == CMPropertyTypes.BIBUS_BASECLASSARRAY ? CMDbStoreSecurityQueryResults.extractBaseClassArray(propValue) : (propType == CMPropertyTypes.BIBUS_MULTILINGUALSTRING || propType == CMPropertyTypes.BIBUS_MULTILINGUALTOKEN ? CMDbStoreSecurityQueryResults.extractMultilingualStringArray(propValue) : (prop == CMProperty.CAPABILITIES ? (this.currObjectClass_ == CMObjectClass.NAMESPACE ? new CMDbStoreStringArray(AccMan.parseCapabilitesValue(propValue)) : null) : (prop == CMProperty.CONTENTLOCALE || prop == CMProperty.PRODUCTLOCALE ? this.parseLocale(propValue) : (prop == CMProperty.PARAMETERS ? AccMan.parseParametersValue(propValue) : new CMDbStoreString(CMXMLUtils.getCharacterContentProper(propValue))))));
                    }
                }
                if (this.values_[i] == null) continue;
                this.fromExternal_[i] = true;
                continue;
            }
            if (prop == CMProperty.PARENT) {
                this.values_[i] = this.getParent(ancestors, docProps);
                continue;
            }
            if (prop == CMProperty.COMMONSYMMETRICKEY) {
                this.values_[i] = CMExecutionContext.get().getCommonSymmetricKey();
                continue;
            }
            if (prop != CMProperty.CACHEDCACERTIFICATES) continue;
            this.values_[i] = CMExecutionContext.get().getCACertificates();
        }
    }

    private void getValues() throws CMException {
        this.resetForNextObject();
        NodeList docProps = this.currentChild_.getChildNodes();
        this.currObjectClass_ = CMDbStoreSecurityQueryResults.getObjectClassFromAAANode(this.currentChild_);
        this.extractPropertiesFromCAMQueryResult(docProps);
        String camid = CMDbStoreSecurityQueryResults.getCAMID(this.getSearchPath());
        if (camid == null) {
            return;
        }
        if (this.currObjectClass_ == CMObjectClass.NAMESPACE && camid.equals(":")) {
            this.currObjectState_ &= 0xFFFFFFFD;
            this.setCognosNamespaceCapabilities();
        }
        try {
            if (AdvancedSettings.CAMSEARCHDEFERREDLOCKING && !this.store_.getLockManager().hasLocks()) {
                this.currObjectID_ = this.store_.lockInternalIdFromCAMID(camid);
                this.lockAcquired = true;
            } else {
                this.currObjectID_ = this.store_.getInternalIdFromCAMID(camid);
            }
            if (this.currObjectID_ != 0) {
                this.currObjectState_ |= 1;
                this.setVersion();
                this.setHasChildrent();
                CMObjectClass[] objClasses = new CMObjectClass[]{this.currObjectClass_};
                CMDbStoreSelectDef selectDef = new CMDbStoreSelectDef(this.store_.getConnection(), null, this.properties.getArray(), null, false, true, objClasses, true, 0);
                CMDbConnection con = this.store_.getConnection();
                int dbCount = selectDef.getDbPropertyCount();
                Object[] dbvalues = new Object[dbCount];
                BitSet dbCountBitSet = new BitSet(dbCount);
                try {
                    if (selectDef.retrievingLobs()) {
                        this.rtHandle_ = this.store_.beginReadTransaction();
                    }
                    this.rs_ = selectDef.execute(con, new int[]{this.currObjectID_});
                    if (this.rs_.next()) {
                        int dbPropCount = selectDef.getDbPropertyCount();
                        int[] columnMap = selectDef.getDbPropertyMap();
                        int[] propertyColumnMap = selectDef.getPropertyDBColumnMap();
                        CMProperty[] properties = selectDef.getProperties();
                        int propOffset = 2;
                        for (int idx = 0; idx < dbPropCount; ++idx) {
                            int propIdx = columnMap[idx];
                            CMDbProperty prop = (CMDbProperty)properties[propIdx];
                            if (this.currObjectClass_ == CMObjectClass.ACCOUNT && prop == CMProperty.PARAMETERS) {
                                --propOffset;
                                continue;
                            }
                            if (prop.columnCount() > 0) {
                                if (this.values_[propIdx] == null) {
                                    if (prop == CMProperty.POLICIES) {
                                        this.currPolicies_ = this.getPolicies(idx + propOffset);
                                        this.values_[propIdx] = this.currPolicies_;
                                    } else if (prop.hasMeaning(CMPropertyMeaning.DATA)) {
                                        InputStream dataStream = null;
                                        dataStream = (InputStream)CMDbStorePropertySerialization.getColumnByProperty(this.rs_, idx + propOffset, prop);
                                        this.values_[propIdx] = dataStream;
                                    } else if (prop.isStoredAsArray() && (!prop.isStoreIDBased() || prop.getMaxOccurs() != 1)) {
                                        this.values_[propIdx] = UNSET;
                                    } else if (prop == CMProperty.REPOSITORYRULES) {
                                        Object value;
                                        if (this.acquiredProperties_ == null) {
                                            this.acquiredProperties_ = new CMDbStoreAcquiredPropertiesHandler(this.store_, selectDef);
                                        }
                                        CMPropertyHandler handler = this.propertyHandlerUtil_.getHandler(this.currObjectClass_, prop, this.currObjectID_, selectDef, this.acquiredProperties_);
                                        dbvalues[idx] = value = handler.getValue(idx + propOffset, this.rs_);
                                        if (handler.isValueAcquired()) {
                                            this.wasAcquiredSet_.set(propIdx);
                                        }
                                        this.values_[propIdx] = value;
                                    } else {
                                        CMBaseClassArray arr;
                                        this.values_[propIdx] = CMDbStorePropertySerialization.getColumnByProperty(this.rs_, idx + propOffset, prop);
                                        if (prop == CMProperty.CREATIONTIME && this.values_[propIdx] != null) {
                                            this.currCreationTime_ = DateUtils.parse((String)this.values_[propIdx].toString());
                                        }
                                        if (prop == CMProperty.OWNER && (arr = (CMBaseClassArray)this.values_[propIdx]) != null) {
                                            this.currOwner_ = (CMDbStoreObjectReference)arr.getItem(0);
                                        }
                                    }
                                } else if (prop == CMProperty.PRODUCTLOCALE || prop == CMProperty.CONTENTLOCALE) {
                                    Object localeValue = CMDbStorePropertySerialization.getColumnByProperty(this.rs_, idx + propOffset, prop);
                                    if (localeValue != null) {
                                        this.values_[propIdx] = localeValue;
                                    } else if (prop == CMProperty.PRODUCTLOCALE) {
                                        this.productLocaleWasAcquired_ = true;
                                    } else {
                                        this.contentLocaleWasAcquired_ = true;
                                    }
                                }
                                if (prop.isStoredAsArray() && (!prop.isStoreIDBased() || prop.getMaxOccurs() != 1)) {
                                    --propOffset;
                                } else if (!prop.isDefaultMultilingualProperty()) {
                                    propOffset += prop.columnCount() - 1;
                                }
                            } else {
                                --propOffset;
                            }
                            this.handleAcquiredProperties(dbvalues, dbCountBitSet, columnMap, idx);
                            this.copySameNamedProperties(propertyColumnMap, idx, propIdx);
                        }
                    }
                }
                catch (SQLException ex) {
                    CMDbStoreExceptionUtil.handleSQLException(con, ex, "query failure");
                }
            }
            this.applyAccountPoliciesFromTemplate();
            this.setStoreId(camid);
        }
        catch (CMException e) {
            this.safeReleaseLocks();
            throw e;
        }
    }

    private byte[] getPolicies(int idx) throws SQLException {
        Integer objectID = new Integer(this.currObjectID_);
        byte[] policies = CMDbStoreFactory.policyCache_.get(objectID);
        if (policies == null && (policies = (byte[])CMDbStorePropertySerialization.getColumnByProperty(this.rs_, idx, CMProperty.POLICIES)) != null) {
            CMDbStoreFactory.policyCache_.add(objectID, policies);
        }
        return policies;
    }

    private void applyAccountPoliciesFromTemplate() {
        if ((this.permissionsIdx_ != -1 || this.policiesIdx != -1) && this.currPolicies_ == null && this.currObjectClass_ == CMObjectClass.ACCOUNT && (this.currObjectState_ & 1) != 1) {
            this.currPolicies_ = this.getAccountTemplatePolicy();
            if (this.policiesIdx != -1) {
                this.values_[this.policiesIdx] = this.currPolicies_;
            }
        }
    }

    private void setStoreId(String camid) {
        int idx = this.properties.indexOf(CMProperty.STOREID);
        if (idx == -1) {
            return;
        }
        String storeId = null;
        if ((this.currObjectState_ & 2) != 0) {
            if (camid != null) {
                storeId = CMCAMIDHelper.CAMID2storeID(camid);
            }
        } else if (this.currObjectID_ != -1) {
            try {
                storeId = this.store_.getObjectStoreID(this.currObjectID_);
            }
            catch (CMException e) {
                CMException cmex = new CMException((Exception)e, "cmErrCacheIn", new CMException.Parm("Location", "CacheObjects.getStoreID"));
                CMIndications.logException(cmex);
            }
        }
        if (storeId != null) {
            this.values_[idx] = new CMDbStoreString(storeId);
        }
    }

    private void setVersion() {
        int idx = this.properties.indexOf(CMProperty.VERSION);
        if (idx != -1) {
            int version = this.store_.getCache().getVersionNumber(this.currObjectID_);
            this.values_[idx] = new CMDbStoreString(Integer.toString(version));
        }
    }

    private void handleAcquiredProperties(Object[] dbvalues, BitSet dbCountBitSet, int[] columnMap, int idx) throws CMException, CMStoreUnexpected {
        if (this.acquiredProperties_ == null) {
            return;
        }
        this.acquiredProperties_.populateAcquiredValues(this.currObjectID_, dbvalues, dbCountBitSet);
        for (int dbv = 0; dbv < dbvalues.length; ++dbv) {
            if (dbvalues[dbv] == null) continue;
            this.values_[columnMap[idx]] = dbvalues[dbv];
            if (!dbCountBitSet.get(idx)) continue;
            this.wasAcquiredSet_.set(columnMap[idx]);
        }
    }

    private static Element findElement(String elementName, NodeList nodes) {
        int numProperties = nodes.getLength();
        for (int i = 0; i < numProperties; ++i) {
            Node curNode = nodes.item(i);
            if (curNode.getNodeType() != 1 || !curNode.getNodeName().equals(elementName)) continue;
            return (Element)curNode;
        }
        return null;
    }

    private static Element getPropertyValue(CMProperty prop, NodeList props) {
        Element property = CMDbStoreSecurityQueryResults.findElement(prop.getName(), props);
        if (property != null) {
            return CMDbStoreSecurityQueryResults.findElement("value", property.getChildNodes());
        }
        return null;
    }

    private void copySameNamedProperties(int[] propertyColumnMap, int idx, int propIdx) {
        for (int i = 0; i < this.values_.length; ++i) {
            if (propertyColumnMap[i] < 0 || propertyColumnMap[i] != idx || i == propIdx) continue;
            this.values_[i] = this.values_[propIdx];
        }
        boolean bFirst = true;
        for (int i = 0; i < propertyColumnMap.length; ++i) {
            if (propertyColumnMap[i] != idx) continue;
            if (bFirst) {
                bFirst = false;
                continue;
            }
            this.values_[i] = this.values_[propIdx];
        }
    }

    private void setHasChildrent() throws CMException {
        int idx = this.properties.indexOf(CMProperty.HASCHILDREN);
        if (idx == -1) {
            return;
        }
        Object currentValue = this.values_[idx];
        if (currentValue == null || CMXMLUtils.isBooleanAttrFalse(currentValue.toString())) {
            boolean hasChildren = this.store_.getCache().CMCacheGetHasChildren(this.currObjectID_);
            this.values_[idx] = CMXMLUtils.getBooleanXMLValue(hasChildren);
        }
    }

    private static String getCAMID(String sPath) throws CMException {
        if (sPath == null) {
            return null;
        }
        CMStoreXPath path = new CMStoreXPath(sPath);
        return path.size() > 0 ? path.getCAMIDFromFirstStep() : null;
    }

    private void setCognosNamespaceCapabilities() {
        int i = this.properties.indexOf(CMProperty.CAPABILITIES);
        if (i != -1) {
            CMDbStoreStringArray caps = new CMDbStoreStringArray();
            caps.add("contains");
            caps.add("equals");
            caps.add("startsWith");
            caps.add("sort");
            this.values_[i] = caps;
        }
    }

    private CMDbStoreString parseLocale(Element propValue) {
        String userLocale = CMXMLUtils.getCharacterContent(propValue);
        CMStringLocale locale = CMDbStoreStringLocales.findLocale(userLocale);
        return locale != null ? new CMDbStoreString(locale.getLocaleID()) : null;
    }

    private CMDbStoreBaseClassArray getParent(CMAncestors ancestors, NodeList docProps) throws CMException {
        if (ancestors == null) {
            Element propValue = CMDbStoreSecurityQueryResults.getPropertyValue(CMProperty.ANCESTORS, docProps);
            ancestors = CMDbStoreSecurityQueryResults.extractAncestorInfo(propValue);
        }
        CMDbStoreBaseClassArray array = null;
        if (ancestors != null) {
            array = new CMDbStoreBaseClassArray();
            int n = ancestors.getSize() - 1;
            CMObjectClass objClass = CMDbStoreFactory.objectClasses_.getClassByName(ancestors.getObjectClass(n));
            CMDbStoreObjectReference reference = new CMDbStoreObjectReference(objClass, ancestors.getSearchPath(n));
            reference.setStoreID(ancestors.getStoreID(n));
            array.add(reference);
        }
        return array;
    }

    private void safeReleaseLocks() {
        if (this.lockAcquired) {
            try {
                this.store_.getLockManager().releaseLocks();
            }
            catch (CMException e) {
                CMIndications.logException(e);
            }
            this.lockAcquired = false;
        }
    }

    @Override
    public Object getValue(CMProperty prop) throws CMException {
        return this.getValue(this.properties.indexOf(prop));
    }

    @Override
    public Object getValue(int index) throws CMException {
        CMDbProperty prop;
        this.wasAcquired_ = this.wasAcquiredSet_.get(index);
        CMProperty property = this.properties.get(index);
        if (property.requiresReadAccess() && this.readAccessDenied()) {
            return null;
        }
        if (property == CMProperty.OBJECTCLASS) {
            return this.currObjectClass_;
        }
        if (property == CMProperty.POLICIES && this.setPolicyAccessDenied()) {
            return null;
        }
        if (property == CMProperty.SEARCHPATHFORURL) {
            if (this.currObjectID_ > -1 && this.currCreationTime_ != null) {
                CMDbStoreStringLocale sysLocale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(ConfigurationFactory.getConfig().getServerLocale().toString());
                StringBuilder urlBuf = new StringBuilder(30);
                urlBuf.append(Integer.toString(this.currObjectID_));
                urlBuf.append(":");
                urlBuf.append(Long.toString(DateUtils.getUTCTime((Date)this.currCreationTime_)));
                urlBuf.append(":");
                try {
                    urlBuf.append(Long.toString(CMDbStoreCacheComplexObjects.hashPathForURL(this.store_.getCache().CMCacheGetNameOnlyPath(this.currObjectID_, new int[]{sysLocale.getInternalID(), sysLocale.getMappedID()}))));
                }
                catch (CMCacheException e) {
                    CMException cmex = new CMException(e, "cmErrCache");
                    CMIndications.logException(cmex);
                }
                return new CMDbStoreString("URLID(\"" + Base64.encode(urlBuf.toString().getBytes()) + "\")");
            }
            StringBuilder urlBuf = new StringBuilder(30);
            urlBuf.append("+1:");
            urlBuf.append(this.getSearchPath());
            CMDbStoreString urlID = new CMDbStoreString("URLID(\"" + Base64.encode(urlBuf.toString().getBytes()) + "\")");
            return urlID;
        }
        if (property == CMProperty.USAGE) {
            return new CMDbStoreString(this.currObjectClass_.getUsage());
        }
        if (property == CMProperty.PRODUCTLOCALE) {
            this.wasAcquired_ = this.productLocaleWasAcquired_;
        } else if (property == CMProperty.CONTENTLOCALE) {
            this.wasAcquired_ = this.contentLocaleWasAcquired_;
        } else {
            if (property == CMProperty.PARAMETERS) {
                this.wasAcquired_ = true;
                return this.values_[index];
            }
            if (property == CMProperty.DISABLED) {
                int value = this.store_.getCache().CMCacheGetIntegerProperty(this.currObjectID_, 6);
                boolean disabledValue = false;
                if (value == 0) {
                    disabledValue = this.store_.getCache().CMCacheIsObjectDisabled(this.currObjectID_);
                    this.wasAcquired_ = true;
                } else {
                    disabledValue = value == 1;
                }
                return new CMDbStoreString(CMXMLUtils.getBooleanXMLValue(disabledValue));
            }
            if (property == CMProperty.TENANTID) {
                int tenantIdInt = this.getTenantID();
                return new CMDbStoreString(this.store_.getTenantRegistry().getTenantIdStringFromInt(tenantIdInt));
            }
        }
        if (this.values_[index] == UNSET && (prop = (CMDbProperty)property).isStoredAsArray()) {
            this.values_[index] = CMDbStoreUtil.getArray(this.store_.getConnection(), prop, this.currObjectID_);
        }
        return this.values_[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getAccountTemplatePolicy() {
        CMCacheQueryInstance cacheQuery = null;
        try {
            if (this.accountTemplatePolicy_ == null) {
                CMStoreXPath path = new CMStoreXPath("/configuration/account");
                cacheQuery = this.store_.getCache().executeAdminQuery(path, 0);
                if (cacheQuery.count() > 0) {
                    this.accountTemplatePolicy_ = this.store_.getPolicy(cacheQuery.resultObjects()[0]);
                    if (this.accountTemplatePolicy_ != null) {
                        String xmlPolicy = CMServlet.AAA.DescribePolicy(null, this.accountTemplatePolicy_, null, null);
                        XMLDoc xmlDoc = null;
                        XMLDocParser parser = new XMLDocParser();
                        xmlDoc = parser.readXML(xmlPolicy);
                        if (xmlDoc != null && xmlDoc.getRootXMLElement() != null) {
                            XMLElement xmlPolicies = xmlDoc.getRootXMLElement().getOptionalChildWithName("value");
                            if (xmlPolicies != null && xmlPolicies.children_ != null) {
                                ListIterator<XMLElement> policiesIterator = xmlPolicies.children_.listIterator();
                                ArrayList<XMLElement> newPolicies = new ArrayList<XMLElement>();
                                while (policiesIterator.hasNext()) {
                                    XMLElement searchPathValue;
                                    XMLElement searchPath;
                                    XMLElement policy = policiesIterator.next();
                                    XMLElement securityObject = policy.getOptionalChildWithName("securityObject");
                                    if (securityObject != null && (searchPath = securityObject.getOptionalChildWithName("searchPath")) != null && (searchPathValue = searchPath.getOptionalChildWithName("value")) != null && searchPathValue.value_.indexOf("::Everyone") != -1) continue;
                                    newPolicies.add(policy);
                                }
                                xmlPolicies.children_ = newPolicies;
                            }
                            xmlPolicy = xmlDoc.getRootXMLElement().makeXML(null, true, true);
                            this.accountTemplatePolicy_ = CMServlet.AAA.CreatePolicy(xmlPolicy, CMExecutionContext.get().getCAMAdditionalInfo());
                        }
                    }
                }
            }
        }
        catch (CMCacheAccessDenied path) {
        }
        catch (AAAException e) {
            CMException cmex = new CMException((Exception)((Object)e), "cmErrAddUserPolicy");
            CMIndications.logException(cmex);
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException(e, "cmErrCache");
            CMIndications.logException(cmex);
        }
        catch (Exception e) {
            CMException cmex = new CMException(e, "cmErrAddUserPolicy");
            CMIndications.logException(cmex);
        }
        finally {
            try {
                cacheQuery.release();
            }
            catch (Throwable e) {}
        }
        return this.accountTemplatePolicy_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getExternalNamespacePolicy() throws CMException {
        CMCacheQueryInstance cacheQuery = null;
        try {
            if (this.namespacePolicy_ == null) {
                CMStoreXPath path = new CMStoreXPath("/directory//*[@id=\"" + this.query_.getCAMIDFromFirstStep() + "\"]");
                cacheQuery = this.store_.getCache().executeAdminQuery(path, 0);
                if (cacheQuery.count() > 0) {
                    this.namespacePolicy_ = this.store_.getPolicy(cacheQuery.getPolicyObject(0));
                }
            }
        }
        catch (CMCacheAccessDenied e) {
            throw new IllegalStateException("Cache threw AccessDenied exception at querying namespace policies. This should not happen");
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException(e, "cmErrCache");
            CMIndications.logException(cmex);
        }
        finally {
            try {
                cacheQuery.release();
            }
            catch (Throwable throwable) {}
        }
        return this.namespacePolicy_;
    }

    @Override
    public boolean wasAcquired() {
        return this.wasAcquired_;
    }

    @Override
    public int getObjectID() {
        return this.currObjectID_;
    }

    @Override
    public int getTenantID() {
        if (this.currObjectID_ > 0) {
            return this.store_.getCache().CMCacheGetTenantID(this.currObjectID_);
        }
        return 0;
    }

    @Override
    public CMObjectClass getObjectClass() {
        return this.currObjectClass_;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public String getSearchPath() {
        return this.searchPathIdx_ == -1 ? null : this.values_[this.searchPathIdx_].toString();
    }

    @Override
    public String getSecurityReference() {
        return this.searchPathIdx_ == -1 ? null : this.values_[this.searchPathIdx_].toString();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void exclude() {
    }

    @Override
    public boolean hasPermission(String permission) {
        for (int i = 0; i < this.permissions_.size(); ++i) {
            if (!this.permissions_.get(i).toString().equalsIgnoreCase(permission)) continue;
            return this.currPolicyCheckResults_[i] == 0;
        }
        return false;
    }

    @Override
    public boolean hasExternalProperty(CMProperty property) {
        if (!property.isExternal()) {
            throw new IllegalStateException("hasExternalProperty called for a non external property");
        }
        int i = this.properties.indexOf(property);
        if (i == -1) {
            return false;
        }
        if (property == CMProperty.MEMBERS) {
            return true;
        }
        return this.fromExternal_[i];
    }

    @Override
    public int getState() {
        return this.currObjectState_;
    }

    @Override
    public void reset() {
        this.atBOF = true;
        if (this.rs_ != null) {
            CMDbStoreUtil.safeCloseStatementViaResultSet(this.rs_);
            this.rs_ = null;
        }
        if (this.rtHandle_ != null) {
            CMDbStore.releaseReadTransaction(this.rtHandle_);
            this.rtHandle_ = null;
        }
        this.safeReleaseLocks();
    }

    CMDbStoreObjects getObjects() {
        return null;
    }

    @Override
    public CMAncestors getAncestors() {
        return null;
    }

    @Override
    public void rewind() {
        throw new UnsupportedOperationException();
    }

    boolean setPolicyAccessDenied() {
        return this.currObjectDeniedSetPolicy_;
    }

    @Override
    public boolean supportsRewind() {
        return false;
    }

    @Override
    public boolean supportsSkipObjects() {
        return true;
    }

    @Override
    public String getParentSearchPath() {
        if (this.currObjectID_ > 0) {
            try {
                int parentID = this.store_.getCache().CMCacheGetIntegerProperty(this.currObjectID_, 5);
                return this.store_.getCache().CMCacheGetSearchPath(parentID, CMDbStoreCacheUtil.getCacheSearchLocales());
            }
            catch (CMCacheException e) {
                CMException cmex = new CMException((Exception)e, "cmErrCacheAddRollBack", new CMException.Parm("Location", "CacheObjects.getSearchPath"));
                CMIndications.logException(cmex);
            }
            catch (CMException e) {
                CMIndications.logException(e);
            }
        }
        return null;
    }

    @Override
    public int getParentObjectID() {
        if (this.currObjectID_ > 0) {
            return this.store_.getCache().CMCacheGetIntegerProperty(this.currObjectID_, 5);
        }
        return -1;
    }

    @Override
    public CMStore getStore() {
        return this.store_;
    }

    public static class AccManObject {
        int hashCode_;
        String name_;
        String path_;
        String id_;
        CMObjectClass objectClass_;

        AccManObject() {
        }

        AccManObject(String name, String id, CMObjectClass objClass) {
            this.reset(name, id, objClass);
        }

        void reset(String path, String id, CMObjectClass objClass) {
            this.path_ = path;
            this.id_ = id;
            this.objectClass_ = objClass;
            this.hashCode_ = this.path_.toLowerCase().hashCode();
        }

        public int hashCode() {
            return this.hashCode_;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AccManObject other = (AccManObject)object;
            return other.path_.equalsIgnoreCase(this.path_) && other.objectClass_ == this.objectClass_ && other.id_.equalsIgnoreCase(this.id_);
        }

        public String getid() {
            return this.id_;
        }

        public String getName() {
            return CMDbStoreSecurityQueryResults.getObjectNameFromPath(this.path_);
        }

        public String getPath() {
            return this.path_;
        }

        public CMObjectClass getCMClass() {
            return this.objectClass_;
        }
    }
}

