/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbColumn;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStorePrepStmtCache;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.dbstore.ISelectDef;
import com.cognos.cm.dbstore.binders.CMDbStoreDataBinder;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.deployment.DeploymentExecutionContext;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryInfo;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMPathStepTokenizer;
import com.cognos.cm.store.path.CMStorePathPredicate;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStorePredicateElement;
import com.cognos.cm.util.CMIntList;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CMDbStoreSelectDef
implements ISelectDef {
    private static final String ALIAS_O = "o";
    private static final String TENANTID_COLUMN = "TENANTID";
    private CMDbConnection connection;
    private CMProperty[] properties_;
    private String[] tables_ = new String[256];
    private String[] extraJoinExpression_ = new String[256];
    private int numTables_;
    private int[] columnMap_;
    private int[] propertyColumnMap_;
    private int dbPropCount_;
    private int[] externalProps_;
    private int externalPropCount_;
    private String selectStmt_;
    private String whereClause_;
    private String orderBy_;
    private boolean cacheOnly_ = true;
    private int existsAlias_ = -1;
    private BitSet tablesNotInFromClause_ = new BitSet(256);
    private int[] inheritableProps_;
    private int inheritedPropCount_;
    private CMDbStoreSelectDef inheritanceQuery_;
    private ArrayList<MLPropInfo> multilingualProps_;
    private ArrayList<String> specialOrderByCols_;
    private boolean suppressCachePredicates_;
    private boolean retrievingLobs_;
    private int[] objectIds_;
    private Object[] ancestorIds_;
    private Map<CMStoreQueryInfo, ArrayList<Literal>> literalsNotInline_;
    private boolean inCaseExpression_;
    private ArrayList<Object> literals_ = new ArrayList();
    private static CMStorePathPredicate selectBurstOutput_;
    private ICMDbStoreSqlGenerator sqlGenerator;

    public CMDbStoreSelectDef(CMDbConnection con, CMStorePathStep query2, CMProperty[] properties, OrderByField[] orderBys) throws CMStoreUnexpected {
        this(con, query2, properties, orderBys, false, true, null, true, 0);
    }

    public CMDbStoreSelectDef(CMDbConnection con, CMStorePathStep query2, CMProperty[] properties, OrderByField[] orderBys, boolean filterBurstOutput, boolean suppressCachePredicates, CMObjectClass[] selectedClasses, boolean selectPolicies, int action) throws CMStoreUnexpected {
        this(con, query2, properties, orderBys, filterBurstOutput, suppressCachePredicates, selectedClasses, selectPolicies, null, null, action);
    }

    public CMDbStoreSelectDef(CMDbConnection con, CMStorePathStep query2, CMProperty[] properties, OrderByField[] orderBys, boolean filterBurstOutput, boolean suppressCachePredicates, CMObjectClass[] selectedClasses, boolean selectPolicies, Object[] ancestorIds, int[] objectIds, int action) throws CMStoreUnexpected {
        this(con, query2, properties, orderBys, filterBurstOutput, suppressCachePredicates, selectedClasses, selectPolicies, ancestorIds, objectIds, false, action);
    }

    public CMDbStoreSelectDef(CMDbConnection con, CMStorePathStep query2, CMProperty[] properties, OrderByField[] orderBys, boolean filterBurstOutput, boolean suppressCachePredicates, CMObjectClass[] selectedClasses, boolean selectPolicies, Object[] ancestorIds, int[] objectIds, boolean forceDBQueryForCachedProps, int action) throws CMStoreUnexpected {
        int i;
        if (query2 != null && query2.hasAcquirablePropertyPredicate() && (ancestorIds == null || objectIds == null || ancestorIds.length != objectIds.length)) {
            throw new IllegalStateException("CMDbStoreSelectDef: missing ancestorIds.");
        }
        this.connection = con;
        this.sqlGenerator = con.getSqlGenerator();
        this.ancestorIds_ = ancestorIds;
        this.objectIds_ = objectIds;
        StringBuffer selectStmt = new StringBuffer(1024);
        this.suppressCachePredicates_ = suppressCachePredicates;
        this.properties_ = properties;
        if (properties != null) {
            this.columnMap_ = new int[properties.length + 1];
            this.propertyColumnMap_ = new int[properties.length];
            this.inheritableProps_ = new int[properties.length + 1];
            this.externalProps_ = new int[properties.length];
        }
        StringBuffer columns = new StringBuffer(1024);
        boolean selectObjectId = true;
        if (this.properties_ != null && this.properties_.length == 1 && ((CMDbProperty)this.properties_[0]).getBehaviourName() == "matchLocaleGetLocale") {
            selectObjectId = false;
        }
        selectStmt.append(this.sqlGenerator.createSelectSql());
        if (selectObjectId) {
            this.sqlGenerator.appendColumnWithAlias("CMID", ALIAS_O, selectStmt);
        } else {
            selectStmt.append(this.sqlGenerator.createDistinctSql());
        }
        for (i = 0; this.properties_ != null && i < this.properties_.length; ++i) {
            CMDbProperty prop = (CMDbProperty)this.properties_[i];
            this.columnMap_[i] = -1;
            this.propertyColumnMap_[i] = -1;
            if (selectedClasses != null) {
                int iClass;
                for (iClass = 0; !(iClass >= selectedClasses.length || selectedClasses[iClass] != null && selectedClasses[iClass].hasProperty(prop)); ++iClass) {
                }
                if (iClass == selectedClasses.length) continue;
            }
            if (prop == CMProperty.POLICIES && !selectPolicies) continue;
            if (prop.columnCount() > 0 && (forceDBQueryForCachedProps || !prop.isCached()) || prop.getBehaviourName() == "evalDBPredicate") {
                boolean bInclude = true;
                for (int j = 0; bInclude && j < i; ++j) {
                    CMDbProperty includedProp;
                    if (this.propertyColumnMap_[j] < 0 || this.columnMap_[this.propertyColumnMap_[j]] < 0 || !this.isSameDbProperty(includedProp = (CMDbProperty)this.properties_[this.columnMap_[this.propertyColumnMap_[j]]], prop)) continue;
                    this.propertyColumnMap_[i] = this.propertyColumnMap_[j];
                    bInclude = false;
                }
                if (!bInclude) continue;
                boolean bl = this.retrievingLobs_ = this.retrievingLobs_ || prop.storedAsBlob();
                if (!prop.isStoredAsArray() || prop.isStoreIDBased() && prop.getMaxOccurs() == 1) {
                    if (selectObjectId || i > 0) {
                        columns.append(this.sqlGenerator.createColumnsSeparator());
                    }
                    if (prop.getBehaviourName() == "evalPredicate" || prop.getBehaviourName() == "evalDBPredicate") {
                        String predWhereClause;
                        CMStorePathPredicate pred = (CMStorePathPredicate)prop.getBehaviourParms().get(0);
                        if (prop.getType() == CMPropertyTypes.XML_BOOLEAN) {
                            columns.append(this.sqlGenerator.createStartCaseWhenSql());
                            this.inCaseExpression_ = true;
                        }
                        try {
                            predWhereClause = pred.getWhereClause(null, this);
                        }
                        catch (CMException ex) {
                            throw new CMStoreUnexpected(ex, "cmStoreUnexpected");
                        }
                        columns.append(predWhereClause);
                        if (this.inCaseExpression_) {
                            columns.append(this.sqlGenerator.createEndCaseForBooleanSql());
                            this.inCaseExpression_ = false;
                        }
                        if (prop.getBehaviourName() == "evalDBPredicate") {
                            this.cacheOnly_ = false;
                        }
                    } else if (prop.getBehaviourName() == "isNotNULL") {
                        columns.append(this.sqlGenerator.createStartCaseWhenSql());
                        this.sqlGenerator.appendEndCaseForColumnIsNotNullSql(this.getColumn(prop, true), prop.storedAsBlob(), columns);
                    } else if (prop.getBehaviourName() == "matchLocale") {
                        this.addMultilingualProperty(prop, columns, false, false);
                    } else if (prop.getBehaviourName() == "matchLocaleGetLocale") {
                        this.addMultilingualProperty(prop, columns, false, true);
                    } else if (prop.getBehaviourName() == "rankFormat") {
                        this.addFormatBestMatch(prop, columns);
                    } else if (prop.getBehaviourName() == "rankLocale") {
                        this.addLocaleBestMatch(prop, columns);
                    } else if (prop.isStoredAsArray() && prop.isStoreIDBased() && prop.getMaxOccurs() == 1) {
                        this.addIDBaseSingleReferenceProperty(prop, columns);
                    } else {
                        columns.append(this.getColumn(prop, false));
                    }
                }
                if (prop.isExternal()) {
                    this.externalProps_[this.externalPropCount_++] = this.dbPropCount_;
                }
                if (prop.isInheritable() && prop != CMProperty.POLICIES && !prop.isCached()) {
                    this.inheritableProps_[this.inheritedPropCount_++] = this.dbPropCount_;
                }
                this.propertyColumnMap_[i] = this.dbPropCount_;
                this.columnMap_[this.dbPropCount_++] = i;
                continue;
            }
            if (!prop.isExternal()) continue;
            this.externalProps_[this.externalPropCount_++] = this.dbPropCount_;
            this.propertyColumnMap_[i] = this.dbPropCount_;
            this.columnMap_[this.dbPropCount_++] = i;
        }
        if (query2 != null) {
            String predWhereClause;
            try {
                predWhereClause = query2.getWhereClause(this);
            }
            catch (CMException ex) {
                throw new CMStoreUnexpected(ex, "cmStoreUnexpected");
            }
            this.whereClause_ = predWhereClause;
        }
        if (filterBurstOutput) {
            String predWhereClause;
            try {
                predWhereClause = CMDbStoreSelectDef.getBurstOutputSelection().getWhereClause(null, this);
            }
            catch (CMException ex) {
                throw new CMStoreUnexpected(ex, "cmStoreUnexpected");
            }
            String clause = this.sqlGenerator.createOpeningBracket() + predWhereClause + this.sqlGenerator.createClosingBracket();
            this.whereClause_ = this.whereClause_ != null && this.whereClause_.length() > 0 ? this.whereClause_ + this.sqlGenerator.createAndSql() + clause : clause;
        }
        this.orderBy_ = this.constructOrderBy(orderBys);
        if (this.orderBy_ != null || query2 != null && !query2.resolvableInCache()) {
            this.cacheOnly_ = false;
        }
        if (this.specialOrderByCols_ != null && this.specialOrderByCols_.size() > 0) {
            for (i = 0; i < this.specialOrderByCols_.size(); ++i) {
                columns.append(this.sqlGenerator.createOrderByColumnsSeparator());
                columns.append(this.specialOrderByCols_.get(i));
            }
        }
        selectStmt.append(columns.toString());
        selectStmt.append(this.sqlGenerator.createFromSql());
        selectStmt.append(this.sqlGenerator.createTableWithAliasSql("CMOBJECTS", ALIAS_O));
        String[] tableAliases = CMDbStorePrepStmtCache.getTableAliases();
        for (int i2 = 0; i2 < this.numTables_ && this.tables_[i2] != null; ++i2) {
            String alias = tableAliases[i2];
            if (this.tablesNotInFromClause_.get(i2)) continue;
            selectStmt.append(this.sqlGenerator.createLeftOuterJoinTableWithAliasSql(this.tables_[i2], alias));
            if (this.tables_[i2].equals("CMCLASSES")) {
                this.sqlGenerator.appendOnJoinColumns("CLASSID", ALIAS_O, "CLASSID", alias, selectStmt);
                continue;
            }
            if (this.tables_[i2].equals("CMLOCALES")) {
                selectStmt.append(this.sqlGenerator.createOnSql());
                selectStmt.append(this.extraJoinExpression_[i2]);
                continue;
            }
            this.sqlGenerator.appendOnJoinColumns("CMID", ALIAS_O, "CMID", alias, selectStmt);
            if (this.extraJoinExpression_[i2] == null) continue;
            selectStmt.append(this.sqlGenerator.createAndSql());
            selectStmt.append(this.extraJoinExpression_[i2]);
        }
        this.selectStmt_ = selectStmt.toString();
        if (CMExecutionContext.get().shouldDoTenantFiltering(action == 10)) {
            this.addTenantIDToWhereClause(this.sqlGenerator);
        }
        if (this.whereClause_ != null && this.whereClause_.length() > 0) {
            StringBuilder whereClause = new StringBuilder();
            whereClause.append(this.sqlGenerator.createWhereSql());
            whereClause.append(this.whereClause_);
            this.whereClause_ = whereClause.toString();
        }
    }

    public boolean isSameDbProperty(CMDbProperty propA, CMDbProperty propB) {
        if (propA.getName().equalsIgnoreCase(propB.getName())) {
            if (propB.getBehaviourName() == "evalDBPredicate") {
                return true;
            }
            if (propA.columnCount() == propB.columnCount() && propA.columnCount() != 0 && propA.getColumn(0).getTable().equalsIgnoreCase(propB.getColumn(0).getTable()) && propA.getColumn(0).getName().equalsIgnoreCase(propB.getColumn(0).getName())) {
                return true;
            }
        }
        return false;
    }

    private void addTenantIDToWhereClause(ICMDbStoreSqlGenerator sqlGenerator) {
        CMExecutionContext ctx = CMExecutionContext.get();
        int sessionTenantID = ctx.getCurrentUserTenantId();
        StringBuilder tenantIDWhereClause = new StringBuilder();
        if (this.whereClause_ != null && this.whereClause_.length() > 0) {
            tenantIDWhereClause.append(sqlGenerator.createAndSql());
        }
        DeploymentExecutionContext deploymentContext = DeploymentExecutionContext.get();
        int[] ids = null;
        ids = deploymentContext.isMultiTenantDeployment() ? deploymentContext.getTenantIDIntList() : ctx.getReadTenantIds();
        if (ids != null && ids.length > 0) {
            boolean needBrackets;
            boolean bl = needBrackets = ids.length > 1;
            if (needBrackets) {
                tenantIDWhereClause.append(sqlGenerator.createOpeningBracket());
            }
            tenantIDWhereClause.append(sqlGenerator.createColumnWithAliasEqualsLiteralSql(TENANTID_COLUMN, ALIAS_O, String.valueOf(ids[0])));
            for (int i = 1; i < ids.length; ++i) {
                tenantIDWhereClause.append(sqlGenerator.createOrSql());
                tenantIDWhereClause.append(sqlGenerator.createColumnWithAliasEqualsLiteralSql(TENANTID_COLUMN, ALIAS_O, String.valueOf(ids[i])));
            }
            if (needBrackets) {
                tenantIDWhereClause.append(sqlGenerator.createClosingBracket());
            }
        } else {
            if (sessionTenantID != 0) {
                tenantIDWhereClause.append(sqlGenerator.createOpeningBracket());
            }
            tenantIDWhereClause.append(sqlGenerator.createColumnWithAliasEqualsLiteralSql(TENANTID_COLUMN, ALIAS_O, String.valueOf(0)));
            if (sessionTenantID != 0) {
                tenantIDWhereClause.append(sqlGenerator.createOrSql());
                tenantIDWhereClause.append(sqlGenerator.createColumnWithAliasEqualsLiteralSql(TENANTID_COLUMN, ALIAS_O, String.valueOf(sessionTenantID)));
                tenantIDWhereClause.append(sqlGenerator.createClosingBracket());
            }
        }
        this.whereClause_ = this.whereClause_ != null && this.whereClause_.length() > 0 ? this.whereClause_ + tenantIDWhereClause.toString() : tenantIDWhereClause.toString();
    }

    private void addFormatBestMatch(CMDbProperty prop, StringBuffer buffer) {
        CMExecutionContext context = CMExecutionContext.get();
        CMDbProperty propFormat = (CMDbProperty)CMProperty.FORMAT;
        String prefFormat = context.getPreference(CMPreference.FORMAT);
        int formatEnumID = -1;
        formatEnumID = prefFormat == null || prefFormat.length() == 0 ? (int)propFormat.getEnumID("HTML") : (int)propFormat.getEnumID(prefFormat);
        String table = prop.getColumn(0).getTable();
        int tableIdx = this.findTable(table);
        if (tableIdx < 0) {
            tableIdx = this.numTables_++;
            this.tables_[tableIdx] = table;
        }
        String[] tableAliases = CMDbStorePrepStmtCache.getTableAliases();
        buffer.append(this.sqlGenerator.createStartCaseWhenSql());
        this.sqlGenerator.appendColumnWithAlias(prop.getColumn(0).getName(), tableAliases[tableIdx], buffer);
        buffer.append(this.sqlGenerator.createEqualsSql());
        buffer.append(formatEnumID);
        buffer.append(this.sqlGenerator.createThenSql());
        buffer.append("2");
        buffer.append(this.sqlGenerator.createElseSql());
        buffer.append("1");
        buffer.append(this.sqlGenerator.createEndWithClosingBracketSql());
    }

    private void addLocaleBestMatch(CMDbProperty prop, StringBuffer buffer) {
        CMStringLocale[] contentLocales = CMExecutionContext.get().getCurrentUserMappedLocales();
        CMDbStoreStringLocale contentLocale = (CMDbStoreStringLocale)contentLocales[0];
        int exactMatchCount = contentLocale.getInternalID() != contentLocale.getMappedID() && contentLocale.getMappedID() != 0 ? 2 : 1;
        String table = prop.getColumn(0).getTable();
        int tableIdx = this.findTable(table);
        if (tableIdx < 0) {
            tableIdx = this.numTables_++;
            this.tables_[tableIdx] = table;
        }
        String[] tableAliases = CMDbStorePrepStmtCache.getTableAliases();
        String basicComparePrefix = this.sqlGenerator.createBasicLocaleComparePrefix(prop.getColumn(0).getName(), tableAliases[tableIdx]);
        buffer.append(this.sqlGenerator.createStartCaseSql());
        buffer.append(basicComparePrefix);
        buffer.append(contentLocale.getInternalID());
        buffer.append(this.sqlGenerator.createThenSql());
        buffer.append("4");
        if (exactMatchCount > 1) {
            buffer.append(basicComparePrefix);
            buffer.append(contentLocale.getMappedID());
            buffer.append(this.sqlGenerator.createThenSql());
            buffer.append("3");
        }
        int localeTableIdx = this.numTables_++;
        this.tables_[localeTableIdx] = "CMLOCALES";
        StringBuffer extraJoinExpressionBuffer = new StringBuffer();
        this.sqlGenerator.appendJoinColumnsWithAlias("LOCALEID", tableAliases[localeTableIdx], prop.getColumn(0).getName(), tableAliases[tableIdx], extraJoinExpressionBuffer);
        this.extraJoinExpression_[localeTableIdx] = " " + extraJoinExpressionBuffer.toString() + " ";
        buffer.append(this.sqlGenerator.createWhenSql());
        this.sqlGenerator.appendColumnWithAlias("MAPDLOCALEID", tableAliases[localeTableIdx], buffer);
        buffer.append(this.sqlGenerator.createEqualsSql());
        buffer.append(contentLocale.getMappedID());
        buffer.append(this.sqlGenerator.createThenSql());
        buffer.append("2");
        buffer.append(this.sqlGenerator.createElseSql());
        buffer.append("1");
        buffer.append(this.sqlGenerator.createEndWithClosingBracketSql());
    }

    @Override
    public void addMultilingualProperty(CMProperty prop, StringBuffer buffer, boolean forOrderBy, boolean forSelectLocaleId) {
        if (!(prop instanceof CMDbProperty)) {
            throw new IllegalStateException("Unexpected property instance is not CMDbProperty in addMultilingualProperty");
        }
        this.addMultilingualProperty((CMDbProperty)prop, buffer, forOrderBy, forSelectLocaleId);
    }

    private void addMultilingualProperty(CMDbProperty prop, StringBuffer buffer, boolean forOrderBy, boolean forSelectLocaleId) {
        int lastTable;
        String tableAlias;
        int exactMatchCount;
        CMStringLocale[] contentLocales = CMExecutionContext.get().getCurrentUserMappedLocales();
        CMDbStoreStringLocale contentLocale = (CMDbStoreStringLocale)contentLocales[0];
        this.cacheOnly_ = this.cacheOnly_ && prop.isCached();
        String table = prop.getColumn(1).getTable();
        int tableIdx = this.findTable(table);
        boolean bPropIsMultilingualRelated = false;
        String propName = "";
        bPropIsMultilingualRelated = prop.isMultilingualRelated();
        if (bPropIsMultilingualRelated) {
            propName = prop.getNameInTable();
        }
        int n = exactMatchCount = contentLocale.getInternalID() != contentLocale.getMappedID() && contentLocale.getMappedID() != 0 ? 2 : 1;
        if (tableIdx < 0 || bPropIsMultilingualRelated) {
            tableIdx = this.numTables_++;
            this.tables_[tableIdx] = table;
            int curTable = tableIdx;
            String[] tableAliases = CMDbStorePrepStmtCache.getTableAliases();
            this.extraJoinExpression_[curTable] = this.sqlGenerator.createColumnWithAliasEqualsLiteralSql(prop.getColumn(0).getName(), tableAliases[curTable], String.valueOf(contentLocale.getInternalID()));
            if (bPropIsMultilingualRelated) {
                this.extraJoinExpression_[curTable] = this.extraJoinExpression_[curTable] + this.sqlGenerator.createAndSql() + this.sqlGenerator.createColumnWithAliasEqualsLiteralSql("PROPNAME", tableAliases[curTable], this.sqlGenerator.createStringLiteralSingleQuote() + propName + this.sqlGenerator.createStringLiteralSingleQuote());
            }
            if (forSelectLocaleId) {
                this.extraJoinExpression_[curTable] = this.extraJoinExpression_[curTable] + this.sqlGenerator.createAndSql() + this.sqlGenerator.createColumnWithAliasIsNotNullSql(prop.getColumn(1).getName(), tableAliases[curTable]);
            }
            if (contentLocale.getInternalID() != contentLocale.getMappedID() && contentLocale.getMappedID() != 0) {
                curTable = this.numTables_++;
                this.tables_[curTable] = table;
                this.extraJoinExpression_[curTable] = this.sqlGenerator.createColumnWithAliasEqualsLiteralSql(prop.getColumn(0).getName(), tableAliases[curTable], String.valueOf(contentLocale.getMappedID()));
                if (bPropIsMultilingualRelated) {
                    this.extraJoinExpression_[curTable] = this.extraJoinExpression_[curTable] + this.sqlGenerator.createAndSql() + this.sqlGenerator.createColumnWithAliasEqualsLiteralSql("PROPNAME", tableAliases[curTable], this.sqlGenerator.createStringLiteralSingleQuote() + propName + this.sqlGenerator.createStringLiteralSingleQuote());
                }
                if (forSelectLocaleId) {
                    this.extraJoinExpression_[curTable] = this.extraJoinExpression_[curTable] + this.sqlGenerator.createAndSql() + this.sqlGenerator.createColumnWithAliasIsNotNullSql(prop.getColumn(1).getName(), tableAliases[curTable]);
                }
            }
        }
        int propIdx = 0;
        int propCount = 0;
        int defaultMatchIdx = 0;
        if (this.multilingualProps_ != null) {
            propCount = this.multilingualProps_.size();
            for (propIdx = 0; propIdx != propCount && this.multilingualProps_.get((int)propIdx).property_ != prop; ++propIdx) {
            }
        } else {
            this.multilingualProps_ = new ArrayList();
        }
        if (propIdx == propCount) {
            defaultMatchIdx = this.numTables_++;
            this.multilingualProps_.add(new MLPropInfo(prop, defaultMatchIdx));
            int curTable = defaultMatchIdx;
            this.tables_[curTable] = table;
            tableAlias = CMDbStorePrepStmtCache.getTableAliases()[curTable];
            this.extraJoinExpression_[curTable] = this.sqlGenerator.createColumnWithAliasEqualsLiteralSql(prop.getColumn(3).getName(), tableAlias, String.valueOf(contentLocale.getMappedID()));
            if (bPropIsMultilingualRelated) {
                this.extraJoinExpression_[curTable] = this.extraJoinExpression_[curTable] + this.sqlGenerator.createAndSql() + this.sqlGenerator.createColumnWithAliasEqualsLiteralSql("PROPNAME", tableAlias, this.sqlGenerator.createStringLiteralSingleQuote() + propName + this.sqlGenerator.createStringLiteralSingleQuote());
            }
            if (forSelectLocaleId) {
                this.extraJoinExpression_[curTable] = this.extraJoinExpression_[curTable] + this.sqlGenerator.createAndSql() + this.sqlGenerator.createColumnWithAliasIsNotNullSql(prop.getColumn(1).getName(), tableAlias);
            }
            curTable = this.numTables_++;
            this.tables_[curTable] = table;
            tableAlias = CMDbStorePrepStmtCache.getTableAliases()[curTable];
            this.extraJoinExpression_[curTable] = this.sqlGenerator.createColumnWithAliasEqualsLiteralSql(prop.getColumn(2).getName(), tableAlias, "1");
            if (bPropIsMultilingualRelated) {
                this.extraJoinExpression_[curTable] = this.extraJoinExpression_[curTable] + this.sqlGenerator.createAndSql() + this.sqlGenerator.createColumnWithAliasEqualsLiteralSql("PROPNAME", tableAlias, this.sqlGenerator.createStringLiteralSingleQuote() + propName + this.sqlGenerator.createStringLiteralSingleQuote());
            }
            if (forSelectLocaleId) {
                this.extraJoinExpression_[curTable] = this.extraJoinExpression_[curTable] + this.sqlGenerator.createAndSql() + this.sqlGenerator.createColumnWithAliasIsNotNullSql(prop.getColumn(1).getName(), tableAlias);
            }
        } else {
            defaultMatchIdx = this.multilingualProps_.get((int)propIdx).tableIdx_;
        }
        if (this.requiresCIHandling() && forOrderBy) {
            buffer.append(this.sqlGenerator.createStartUpperSql());
        }
        if (CMDbConnection.dbms_ == 5) {
            buffer.append(this.sqlGenerator.createStartCaseSql());
            lastTable = tableIdx + exactMatchCount;
            do {
                tableAlias = CMDbStorePrepStmtCache.getTableAliases()[tableIdx];
                buffer.append(this.sqlGenerator.createWhenSql());
                this.sqlGenerator.appendColumnWithAliasIsNotNull(prop.getColumn(1).getName(), tableAlias, buffer);
                buffer.append(this.sqlGenerator.createThenSql());
                if (forSelectLocaleId) {
                    this.sqlGenerator.appendColumnWithAlias(prop.getColumn(0).getName(), tableAlias, buffer);
                    continue;
                }
                this.sqlGenerator.appendColumnWithAlias(prop.getColumn(1).getName(), tableAlias, buffer);
            } while (++tableIdx < lastTable);
            lastTable = defaultMatchIdx + 2;
            for (tableIdx = defaultMatchIdx; tableIdx != lastTable; ++tableIdx) {
                String alias = CMDbStorePrepStmtCache.getTableAliases()[tableIdx];
                buffer.append(this.sqlGenerator.createWhenSql());
                this.sqlGenerator.appendColumnWithAliasIsNotNull(prop.getColumn(1).getName(), alias, buffer);
                buffer.append(this.sqlGenerator.createThenSql());
                if (forSelectLocaleId) {
                    this.sqlGenerator.appendColumnWithAlias(prop.getColumn(0).getName(), alias, buffer);
                    continue;
                }
                this.sqlGenerator.appendColumnWithAlias(prop.getColumn(1).getName(), alias, buffer);
            }
            if (forSelectLocaleId) {
                buffer.append(this.sqlGenerator.createElseCastNullAsIntegerSql());
            }
            buffer.append(this.sqlGenerator.createEndWithClosingBracketSql());
        } else if (CMDbConnection.dbms_ == 8) {
            lastTable = tableIdx + exactMatchCount;
            int NVLCount = 0;
            NVLCount += this.composeNVLSubstmt(lastTable, tableIdx, buffer, forSelectLocaleId, prop, false);
            tableIdx = defaultMatchIdx;
            lastTable = defaultMatchIdx + 2;
            NVLCount += this.composeNVLSubstmt(lastTable, tableIdx, buffer, forSelectLocaleId, prop, true);
            while (NVLCount > 0) {
                buffer.append(this.sqlGenerator.createClosingBracket());
                --NVLCount;
            }
        } else {
            String alias;
            buffer.append(this.sqlGenerator.createStartCoalesceSql());
            boolean first = true;
            int lastTable2 = tableIdx + exactMatchCount;
            do {
                alias = CMDbStorePrepStmtCache.getTableAliases()[tableIdx];
                if (!first) {
                    buffer.append(this.sqlGenerator.createColumnsSeparator());
                }
                first = false;
                if (forSelectLocaleId) {
                    this.sqlGenerator.appendColumnWithAlias(prop.getColumn(0).getName(), alias, buffer);
                    continue;
                }
                this.sqlGenerator.appendColumnWithAlias(prop.getColumn(1).getName(), alias, buffer);
            } while (++tableIdx < lastTable2);
            lastTable2 = defaultMatchIdx + 2;
            for (tableIdx = defaultMatchIdx; tableIdx != lastTable2; ++tableIdx) {
                alias = CMDbStorePrepStmtCache.getTableAliases()[tableIdx];
                buffer.append(this.sqlGenerator.createColumnsSeparator());
                if (forSelectLocaleId) {
                    this.sqlGenerator.appendColumnWithAlias(prop.getColumn(0).getName(), alias, buffer);
                    continue;
                }
                this.sqlGenerator.appendColumnWithAlias(prop.getColumn(1).getName(), alias, buffer);
            }
            buffer.append(this.sqlGenerator.createClosingBracket());
        }
        if (this.requiresCIHandling() && forOrderBy) {
            buffer.append(this.sqlGenerator.createClosingBracket());
        }
    }

    private int composeNVLSubstmt(int lastTable, int tableIdx, StringBuffer buffer, boolean forSelectLocaleId, CMDbProperty prop, boolean isEndStmt) {
        boolean last = false;
        int NVLCount = 0;
        do {
            if (!isEndStmt || !last) {
                buffer.append(this.sqlGenerator.createStartCoalesceSql());
                ++NVLCount;
            }
            String alias = CMDbStorePrepStmtCache.getTableAliases()[tableIdx];
            if (forSelectLocaleId) {
                this.sqlGenerator.appendColumnWithAlias(prop.getColumn(0).getName(), alias, buffer);
            } else {
                this.sqlGenerator.appendColumnWithAlias(prop.getColumn(1).getName(), alias, buffer);
            }
            if (!isEndStmt || !last) {
                buffer.append(this.sqlGenerator.createColumnsSeparator());
                buffer.append(" ");
            }
            if (++tableIdx != lastTable - 1 || !isEndStmt) continue;
            last = true;
        } while (tableIdx < lastTable);
        return NVLCount;
    }

    private void addIDBaseSingleReferenceProperty(CMDbProperty prop, StringBuffer buffer) {
        String table = prop.getColumn(0).getTable();
        int curTable = this.numTables_++;
        this.tables_[curTable] = table;
        String[] tableAliases = CMDbStorePrepStmtCache.getTableAliases();
        if (prop.hasPropertyID()) {
            int refPropID = prop.getPropertyID();
            this.extraJoinExpression_[curTable] = this.sqlGenerator.createColumnWithAliasEqualsLiteralSql("PROPID", tableAliases[curTable], String.valueOf(refPropID));
        }
        this.sqlGenerator.appendColumnWithAlias(prop.getColumn(0).getName(), tableAliases[curTable], buffer);
        this.cacheOnly_ = this.cacheOnly_ && prop.isCached();
    }

    @Override
    public void addIndexProperty(CMProperty prop, StringBuffer buffer) {
        if (!(prop instanceof CMDbProperty)) {
            throw new IllegalStateException("Unexpected property instance is not CMDbProperty in addIndexProperty");
        }
        this.addIndexProperty((CMDbProperty)prop, buffer);
    }

    private void addIndexProperty(CMDbProperty prop, StringBuffer buffer) {
        CMDbProperty indexProp = (CMDbProperty)prop.getIndexProperty();
        String alias = this.getAlias(indexProp.getColumn(0), false);
        this.sqlGenerator.appendColumnWithAlias(indexProp.getColumn(0).getName(), alias, buffer);
        this.cacheOnly_ = this.cacheOnly_ && prop.isCached();
    }

    @Override
    public int[] getInheritedPropertyMap() {
        return this.inheritableProps_;
    }

    @Override
    public int getInheritedPropertyCount() {
        return this.inheritedPropCount_;
    }

    @Override
    public CMDbStoreSelectDef getInheritanceQuery(CMDbConnection con) throws CMStoreUnexpected {
        if (this.inheritanceQuery_ == null && this.inheritedPropCount_ > 0) {
            CMProperty[] iProps = new CMProperty[this.inheritedPropCount_];
            for (int propIdx = 0; propIdx < this.inheritedPropCount_; ++propIdx) {
                iProps[propIdx] = this.properties_[this.columnMap_[this.inheritableProps_[propIdx]]];
            }
            this.inheritanceQuery_ = this.newSelectDef(con, iProps);
        }
        return this.inheritanceQuery_;
    }

    @Override
    public CMProperty[] getProperties() {
        return this.properties_;
    }

    @Override
    public int getDbPropertyCount() {
        return this.dbPropCount_;
    }

    @Override
    public int[] getDbPropertyMap() {
        return this.columnMap_;
    }

    @Override
    public int[] getPropertyDBColumnMap() {
        return this.propertyColumnMap_;
    }

    @Override
    public int getExternalPropertyCount() {
        return this.externalPropCount_;
    }

    @Override
    public int[] getExternalPropertyMap() {
        return this.externalProps_;
    }

    @Override
    public boolean resolvableInCache() {
        return this.cacheOnly_;
    }

    @Override
    public boolean retrievingLobs() {
        return this.retrievingLobs_;
    }

    @Override
    public ResultSet execute(CMDbConnection con, String stmt) throws SQLException, CMException {
        return this.execute(con, stmt, null, null);
    }

    private void insertLiteralsIntoTempTable(CMDbConnection con) throws SQLException, CMException {
        if (this.literalsNotInline_ != null) {
            Set<CMStoreQueryInfo> queryIdSet = this.literalsNotInline_.keySet();
            for (CMStoreQueryInfo queryInfo : queryIdSet) {
                ArrayList<Literal> literals = this.literalsNotInline_.get(queryInfo);
                CMIntList CMIDList = new CMIntList();
                if (literals == null) continue;
                for (int i = 0; i < literals.size(); ++i) {
                    Literal literal = literals.get(i);
                    if (literal.property_ == null) continue;
                    CMDbProperty prop = (CMDbProperty)literal.property_;
                    CMDbStoreDataSerializer serializer = prop.getDataSerializer();
                    Integer CMIDInteger = null;
                    Object value = serializer.serialize(literal.value_);
                    if (value instanceof Object[] && ((Object[])value).length == 2) {
                        CMIDInteger = (Integer)((Object[])value)[0];
                    } else if (value instanceof Integer) {
                        CMIDInteger = (Integer)value;
                    }
                    if (CMIDInteger == null) continue;
                    CMIDList.add(CMIDInteger);
                }
                CMDbStoreDMLDef.insertCMIDsIntoTempTable(con, CMIDList.toArray(), (CMDbStoreDMLDef.CMDbStoreWhereCMIDsInfo)queryInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResultSet execute(CMDbConnection con, String stmt, int[] objectIDs, CMDbStoreDMLDef.CMDbStoreWhereCMIDsInfo whereCMIDsInfo) throws SQLException, CMException {
        Statement queryStmt = null;
        ResultSet rs = null;
        try {
            this.insertLiteralsIntoTempTable(con);
            if (this.literals_.size() > 0 || whereCMIDsInfo != null && objectIDs != null) {
                PreparedStatement curStmt = con.prepareStatement(stmt, 1003);
                queryStmt = curStmt;
                int bindOffset = 1;
                for (int i = 0; i < this.literals_.size(); ++i) {
                    Object value;
                    Object literalObject = this.literals_.get(i);
                    if (literalObject instanceof LiteralValue) {
                        LiteralValue literalValue = (LiteralValue)literalObject;
                        curStmt.setObject(bindOffset++, literalValue.value_);
                        continue;
                    }
                    if (!(literalObject instanceof Literal)) continue;
                    Literal literal = (Literal)literalObject;
                    if (literal.property_ == null) {
                        if (literal.value_ != null && literal.value_ instanceof Integer) {
                            curStmt.setInt(bindOffset++, (Integer)literal.value_);
                            continue;
                        }
                        if (CMDbConnection.dbms_ == 8) {
                            CMDbStorePropertySerialization.bindParameterToPreparedStatement(curStmt, bindOffset++, CMPropertyTypes.XML_STRING, -1, -1, literal.value_);
                            continue;
                        }
                        CMDbStorePropertySerialization.bindParameterToPreparedStatement(curStmt, bindOffset++, CMPropertyTypes.XML_STRING, -1, 12, literal.value_);
                        continue;
                    }
                    CMDbProperty prop = (CMDbProperty)literal.property_;
                    CMDbStoreDataSerializer serializer = prop.getDataSerializer();
                    try {
                        value = serializer.serialize(literal.value_);
                    }
                    catch (CMException ex) {
                        if (!prop.hasMeaning(CMPropertyMeaning.TENANTID)) throw ex;
                        value = new Integer(-9999);
                    }
                    CMDbStoreDataBinder binder = prop.getSearchDataBinder();
                    bindOffset = binder.bindData(curStmt, bindOffset, value);
                }
                if (whereCMIDsInfo != null && objectIDs != null) {
                    bindOffset = CMDbStoreDMLDef.bindWhereCMIDsInfo(bindOffset, curStmt, objectIDs, whereCMIDsInfo);
                }
                rs = curStmt.executeQuery();
            } else {
                queryStmt = con.createStatement();
                rs = queryStmt.executeQuery(stmt);
            }
            if (rs != null) return rs;
        }
        catch (Throwable throwable) {
            if (rs != null) throw throwable;
            CMDbStoreUtil.safeCloseStatement(queryStmt);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(queryStmt);
        return rs;
    }

    @Override
    public ResultSet execute(CMDbConnection con) throws SQLException, CMException {
        String completeSelectStmt = this.selectStmt_;
        if (this.whereClause_ != null) {
            completeSelectStmt = completeSelectStmt + this.whereClause_;
        }
        if (this.orderBy_ != null) {
            completeSelectStmt = completeSelectStmt + this.orderBy_;
        }
        return this.execute(con, completeSelectStmt);
    }

    @Override
    public ResultSet execute(CMDbConnection con, int[] objectIDs) throws SQLException, CMException {
        return this.execute(con, objectIDs, false);
    }

    @Override
    public ResultSet execute(CMDbConnection con, int[] objectIDs, boolean useParentIDs) throws SQLException, CMException {
        String completeSelectStmt = this.selectStmt_;
        if (objectIDs.length == 0) {
            return null;
        }
        CMDbStoreDMLDef.CMDbStoreWhereCMIDsInfo whereCMIDsInfo = this.constructWhereCMIDs(con, objectIDs, useParentIDs);
        String restOfStmt = whereCMIDsInfo.whereClause_;
        completeSelectStmt = completeSelectStmt + whereCMIDsInfo.fromClause_;
        if (this.whereClause_ != null && this.whereClause_.length() != 0) {
            completeSelectStmt = completeSelectStmt + this.whereClause_;
            completeSelectStmt = completeSelectStmt + this.sqlGenerator.createAndSql();
        } else {
            completeSelectStmt = completeSelectStmt + this.sqlGenerator.createWhereSql();
        }
        completeSelectStmt = completeSelectStmt + restOfStmt;
        if (this.orderBy_ != null) {
            completeSelectStmt = completeSelectStmt + this.orderBy_;
        }
        return this.execute(con, completeSelectStmt, objectIDs, whereCMIDsInfo);
    }

    static boolean isBaseTableColumn(CMDbProperty prop) {
        return prop.columnCount() > 0 && prop.getColumn(0).getTable().equalsIgnoreCase("CMOBJECTS");
    }

    private CMDbStoreDMLDef.CMDbStoreWhereCMIDsInfo constructWhereCMIDs(CMDbConnection con, int[] objectIDs, boolean useParentCMIDs) throws SQLException, CMException {
        String idColumn = this.sqlGenerator.createColumnWithAliasSql("CMID", ALIAS_O);
        if (useParentCMIDs) {
            idColumn = this.sqlGenerator.createColumnWithAliasSql("PCMID", ALIAS_O);
        }
        return new CMDbStoreDMLDef("").constructWhereCMIDs(con, objectIDs, idColumn, true, true);
    }

    @Override
    public CMStoreQueryInfo constructWhereCMIDsNotInline(CMStore store, int objectIDsLength, String columnName) throws CMException {
        CMDbStore dbStore = (CMDbStore)store;
        CMDbConnection con = dbStore.getConnection();
        return new CMDbStoreDMLDef("").constructWhereCMIDsNotInline(con, objectIDsLength, columnName, true);
    }

    private String constructOrderBy(OrderByField[] orderBys) {
        if (orderBys != null && orderBys.length > 0) {
            StringBuffer orderByClause;
            StringBuffer buffer = orderByClause = new StringBuffer(this.sqlGenerator.createOrderBySql());
            String sortCollationName = AdvancedSettings.SORTCOLLATION.trim();
            boolean bUseCollation = sortCollationName.length() > 0 && (CMDbConnection.dbms_ == 2 || CMDbConnection.dbms_ == 1);
            boolean bUseSpecialSortColumns = false;
            if (CMDbConnection.dbms_ == 5) {
                bUseSpecialSortColumns = true;
            }
            if (bUseCollation || bUseSpecialSortColumns) {
                buffer = new StringBuffer();
            }
            for (int i = 0; i < orderBys.length; ++i) {
                if (i > 0) {
                    orderByClause.append(this.sqlGenerator.createColumnsSeparator());
                }
                if (bUseCollation || bUseSpecialSortColumns) {
                    buffer.setLength(0);
                }
                boolean bComplexOrderBy = true;
                CMDbProperty prop = (CMDbProperty)orderBys[i].property;
                if (prop.getBehaviourName() == "matchLocale") {
                    this.addMultilingualProperty(prop, buffer, true, false);
                } else if (prop.getBehaviourName() == "matchLocaleGetLocale") {
                    this.addMultilingualProperty(prop, buffer, true, true);
                } else if (prop.getBehaviourName() == "rankFormat") {
                    this.addFormatBestMatch(prop, buffer);
                } else if (prop.getBehaviourName() == "rankLocale") {
                    this.addLocaleBestMatch(prop, buffer);
                } else {
                    buffer.append(this.getColumn(prop, true));
                    bComplexOrderBy = false;
                }
                if (bUseSpecialSortColumns) {
                    if (bComplexOrderBy) {
                        if (this.specialOrderByCols_ == null) {
                            this.specialOrderByCols_ = new ArrayList();
                        }
                        String colAlias = "sc" + i;
                        this.specialOrderByCols_.add(buffer.toString() + this.sqlGenerator.createAsSql() + colAlias);
                        orderByClause.append(colAlias);
                    } else {
                        orderByClause.append(buffer);
                    }
                }
                boolean canContainNationalChar = prop.canContainNationalChar();
                if (bUseCollation) {
                    if (canContainNationalChar) {
                        this.sqlGenerator.appendOrderByForNationalCharacters(buffer, orderByClause);
                    } else {
                        orderByClause.append(buffer);
                    }
                }
                if (orderBys[i].bDescend) {
                    orderByClause.append(this.sqlGenerator.createDescSql());
                    continue;
                }
                orderByClause.append(this.sqlGenerator.createAscSql());
            }
            return orderByClause.toString();
        }
        return null;
    }

    @Override
    public boolean requiresCIHandling() {
        return CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive();
    }

    @Override
    public boolean parametersRequireCasting() {
        return CMDbConnection.dbms_ == 3;
    }

    private int findTable(String table) {
        for (int tableIdx = 0; tableIdx < this.numTables_; ++tableIdx) {
            if (!this.tables_[tableIdx].equals(table) || this.tablesNotInFromClause_.get(tableIdx)) continue;
            return tableIdx;
        }
        return -1;
    }

    protected String getAlias(CMDbColumn propColumn, boolean force) {
        int tableIdx;
        if (force) {
            tableIdx = this.numTables_++;
            this.tables_[tableIdx] = propColumn.getTable();
        } else {
            tableIdx = this.findTable(propColumn.getTable());
            if (tableIdx < 0) {
                tableIdx = this.numTables_++;
                this.tables_[tableIdx] = propColumn.getTable();
            }
        }
        return CMDbStorePrepStmtCache.getTableAliases()[tableIdx];
    }

    @Override
    public String existsAcquirableExpression(CMProperty property) {
        CMIndications.Audit_Message_FreeFormText("cmSearchByAcquirableProperty", new CMException.Parm[]{new CMException.Parm("property", property.getName())}, 50000, "Query", "ContentManagerService", "", "Warning", null);
        if (this.ancestorIds_ == null || this.objectIds_ == null || this.ancestorIds_.length != this.objectIds_.length) {
            return new String();
        }
        StringBuffer buffer = new StringBuffer();
        CMDbProperty prop = (CMDbProperty)property;
        String filter = prop.getFilter();
        buffer.append(this.sqlGenerator.createOpeningBracket());
        for (int i = 0; i < this.objectIds_.length; ++i) {
            if (i > 0) {
                buffer.append(this.sqlGenerator.createOrSql());
            }
            buffer.append(this.sqlGenerator.createExistsSelectFromSql());
            buffer.append(prop.getColumn(0).getTable());
            buffer.append(" ");
            this.existsAlias_ = this.numTables_;
            this.tablesNotInFromClause_.set(this.existsAlias_);
            String alias = this.getAlias(prop.getColumn(0), true);
            buffer.append(alias);
            buffer.append(this.sqlGenerator.createWhereSql());
            buffer.append(this.sqlGenerator.createColumnWithAliasSql("CMID", ALIAS_O));
            buffer.append(this.sqlGenerator.createEqualsBindParameterSymbol());
            buffer.append(this.sqlGenerator.createAndSql());
            this.addLiteral(null, new Integer(this.objectIds_[i]));
            buffer.append(alias);
            buffer.append(this.sqlGenerator.createAliasSeparator());
            buffer.append("CMID");
            buffer.append(this.sqlGenerator.createInNoSpaceSql());
            buffer.append(this.sqlGenerator.createOpeningBracket());
            buffer.append(this.sqlGenerator.createBindParameterSymbol());
            this.addLiteral(null, new Integer(this.objectIds_[i]));
            for (int j = 0; j < ((int[])this.ancestorIds_[i]).length; ++j) {
                buffer.append(this.sqlGenerator.createBindParametersSeparator());
                buffer.append(this.sqlGenerator.createBindParameterSymbol());
                this.addLiteral(null, new Integer(((int[])this.ancestorIds_[i])[j]));
            }
            buffer.append(this.sqlGenerator.createClosingBracket());
            if (!this.hasMultipleRecords(property)) {
                buffer.append(this.sqlGenerator.createAndSql());
                buffer.append(this.startIsNullExpression(property, true));
                buffer.append(this.endIsNullExpression(property, false));
            }
            if (filter != null && filter.length() > 0) {
                buffer.append(this.sqlGenerator.createAndSql());
                buffer.append(CMDbStoreUtil.substituteVars(filter, new String[]{"ALIAS"}, new String[]{alias + this.sqlGenerator.createAliasSeparator()}));
            }
            if (property.isStoreIDBased() && property instanceof CMDbProperty) {
                this.appendPropertyID(buffer, property, alias);
            }
            buffer.append(this.sqlGenerator.createClosingBracket());
        }
        buffer.append(this.sqlGenerator.createClosingBracket());
        return buffer.toString();
    }

    @Override
    public String startExistsExpressionFromClause(CMProperty property) {
        StringBuffer buffer = new StringBuffer(this.sqlGenerator.createExistsSelectFromSql());
        CMDbProperty prop = (CMDbProperty)property;
        buffer.append(prop.getColumn(0).getTable());
        buffer.append(" ");
        this.existsAlias_ = this.numTables_;
        this.tablesNotInFromClause_.set(this.existsAlias_);
        String alias = this.getAlias(prop.getColumn(0), true);
        buffer.append(alias);
        return buffer.toString();
    }

    @Override
    public String startExistsExpressionWhereClause(CMProperty property) {
        if (this.existsAlias_ == -1) {
            throw new IllegalStateException("startExistsExpressionWhereClause should be called after startExistsExpressionFromClause");
        }
        StringBuffer buffer = new StringBuffer(this.sqlGenerator.createWhereSql());
        CMDbProperty prop = (CMDbProperty)property;
        String filter = prop.getFilter();
        String alias = this.getColumnAlias(prop);
        this.sqlGenerator.appendJoinColumnsWithAlias("CMID", ALIAS_O, "CMID", alias, buffer);
        if (filter != null && filter.length() > 0) {
            buffer.append(this.sqlGenerator.createAndSql());
            buffer.append(CMDbStoreUtil.substituteVars(filter, new String[]{"ALIAS"}, new String[]{alias + this.sqlGenerator.createAliasSeparator()}));
        }
        if (property.isStoreIDBased() && property instanceof CMDbProperty) {
            this.appendPropertyID(buffer, property, alias);
        }
        return buffer.toString();
    }

    @Override
    public String startExistsExpression(CMProperty property) {
        return this.startExistsExpression(property, true);
    }

    @Override
    public String startExistsExpression(CMProperty property, boolean excludeDeleteObjects) {
        StringBuffer buffer = new StringBuffer();
        if (this.useCountInsteadOfExistsExpression()) {
            buffer.append(this.sqlGenerator.createSelectCountInsteadOfExistsSql());
        } else {
            buffer.append(this.sqlGenerator.createExistsSelectFromSql());
        }
        CMDbProperty prop = (CMDbProperty)property;
        String filter = prop.getFilter();
        buffer.append(prop.getColumn(0).getTable());
        buffer.append(" ");
        this.existsAlias_ = this.numTables_;
        this.tablesNotInFromClause_.set(this.existsAlias_);
        String aliasDeletedObjects = "d0";
        String alias = this.getAlias(prop.getColumn(0), true);
        buffer.append(alias);
        if (property.isStoreIDBased() && excludeDeleteObjects) {
            this.appendJoinExcludeDeletedObjects(buffer, property, alias, aliasDeletedObjects);
        }
        buffer.append(this.sqlGenerator.createWhereSql());
        this.sqlGenerator.appendJoinColumnsWithAlias("CMID", ALIAS_O, "CMID", alias, buffer);
        if (filter != null && filter.length() > 0) {
            buffer.append(this.sqlGenerator.createAndSql());
            buffer.append(CMDbStoreUtil.substituteVars(filter, new String[]{"ALIAS"}, new String[]{alias + this.sqlGenerator.createAliasSeparator()}));
        }
        if (property.isStoreIDBased()) {
            this.appendPropertyID(buffer, property, alias);
            if (excludeDeleteObjects) {
                this.appendExcludeDeletedObjects(buffer, property, aliasDeletedObjects);
            }
        }
        return buffer.toString();
    }

    private void appendPropertyID(StringBuffer buffer, CMProperty property, String alias) {
        if (property instanceof CMDbProperty) {
            ArrayList<? extends CMProperty> subpropertiesAndSelf = ((CMDbProperty)property).getSubpropertiesAndSelf();
            boolean firstTime = true;
            for (int subpropertyIdx = 0; subpropertyIdx < subpropertiesAndSelf.size(); ++subpropertyIdx) {
                CMDbProperty subproperty = (CMDbProperty)subpropertiesAndSelf.get(subpropertyIdx);
                if (!subproperty.hasPropertyID()) continue;
                if (!firstTime) {
                    buffer.append(this.sqlGenerator.createOrSql());
                } else {
                    buffer.append(this.sqlGenerator.createAndSql());
                    buffer.append(this.sqlGenerator.createOpeningBracket());
                }
                this.sqlGenerator.appendColumnWithAliasEqualsLiteral("PROPID", alias, String.valueOf(((CMDbProperty)subpropertiesAndSelf.get(subpropertyIdx)).getPropertyID()), buffer);
                firstTime = false;
            }
            if (!firstTime) {
                buffer.append(this.sqlGenerator.createClosingBracket());
                buffer.append(" ");
            }
        }
    }

    private void appendExcludeDeletedObjects(StringBuffer buffer, CMProperty property, String alias) {
        if (property instanceof CMDbProperty) {
            buffer.append(this.sqlGenerator.createAndSql());
            buffer.append(this.sqlGenerator.createOpeningBracket());
            this.sqlGenerator.appendColumnWithAliasNotEqualsLiteral(((CMDbProperty)CMProperty.OBJECTCLASS).getColumn(0).getName(), alias, String.valueOf(CMObjectClass._DELETEDOBJECT.getID()), buffer);
            buffer.append(this.sqlGenerator.createClosingBracket());
            buffer.append(" ");
        }
    }

    private void appendJoinExcludeDeletedObjects(StringBuffer buffer, CMProperty property, String alias, String aliasDeletedObjects) {
        if (property instanceof CMDbProperty) {
            buffer.append(this.sqlGenerator.createLeftOuterJoinTableWithAliasSql("CMOBJECTS", aliasDeletedObjects));
            this.sqlGenerator.appendOnJoinColumns("REFCMID", alias, "CMID", aliasDeletedObjects, buffer);
        }
    }

    @Override
    public String endExistsExpression() {
        this.existsAlias_ = -1;
        return this.sqlGenerator.createClosingBracket();
    }

    @Override
    public boolean inExistsExpression() {
        return this.existsAlias_ > -1;
    }

    @Override
    public boolean suppressCachePredicates() {
        return this.suppressCachePredicates_;
    }

    @Override
    public String getSelectStmt() {
        return this.selectStmt_;
    }

    @Override
    public String getWhereClause() {
        return this.whereClause_;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy_;
    }

    @Override
    public String getColumn(CMProperty property, boolean forPredicate) {
        return this.getColumn(property, forPredicate, false);
    }

    @Override
    public String getColumn(CMProperty property, boolean forPredicate, boolean forIsNullPredicate) {
        CMDbProperty prop = (CMDbProperty)property;
        String alias = null;
        CMDbColumn column = this.getPropertyColumn(prop);
        if (!prop.isCached()) {
            this.cacheOnly_ = false;
        }
        alias = this.getColumnAlias(prop);
        return CMDbStoreUtil.getPropertySelectString(this.connection, alias, prop, column.getDbType() == -4, forPredicate, forIsNullPredicate);
    }

    @Override
    public CMDbColumn getPropertyColumn(CMProperty property) {
        CMDbProperty prop = (CMDbProperty)property;
        int colIdx = 0;
        if (prop.columnCount() > 1 && (prop == CMProperty.NAME || prop == CMProperty.DEFAULTNAME || prop.isMultilingualRelated())) {
            colIdx = 1;
        }
        return prop.getColumn(colIdx);
    }

    @Override
    public String getColumnAlias(CMProperty property) {
        CMDbProperty prop = (CMDbProperty)property;
        String alias = null;
        CMDbColumn column = this.getPropertyColumn(prop);
        if (!prop.isCached()) {
            this.cacheOnly_ = false;
        }
        alias = this.existsAlias_ != -1 ? (this.tables_[this.existsAlias_].equals(column.getTable()) ? CMDbStorePrepStmtCache.getTableAliases()[this.existsAlias_] : this.getAlias(column, false)) : (CMDbStoreSelectDef.isBaseTableColumn(prop) ? ALIAS_O : this.getAlias(column, false));
        return alias;
    }

    @Override
    public String getColumnForCMID(boolean forPredicate) {
        String alias = null;
        alias = ALIAS_O;
        return this.sqlGenerator.createColumnWithAliasSql("CMID", alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMIntList executeStepInDB(CMStore store, CMStorePathStep query2, int[] objectIDs, boolean reduceOnly) throws CMException {
        CMIntList referencingObjIDs = null;
        if (objectIDs == null || objectIDs.length == 0 || query2 == null) {
            return null;
        }
        boolean stepHasDbPredicateNotContainsReferences = false;
        int predicateCount = query2.Predicates != null ? query2.Predicates.size() : 0;
        for (int i = 0; i < predicateCount; ++i) {
            CMStorePathPredicate pathPredicate;
            CMExecutionContext.checkCancelOrTimeOut();
            CMStorePredicateElement elem = query2.Predicates.get(i);
            if (!(elem instanceof CMStorePathPredicate) || (pathPredicate = (CMStorePathPredicate)elem).CanBeProcessedByCache()) continue;
            stepHasDbPredicateNotContainsReferences = true;
        }
        if (reduceOnly) {
            return referencingObjIDs;
        }
        if (stepHasDbPredicateNotContainsReferences) {
            int[] reducedObjectIDs = objectIDs;
            referencingObjIDs = new CMIntList();
            ResultSet rs = null;
            CMDbStore dbStore = (CMDbStore)store;
            CMDbConnection con = dbStore.getConnection();
            try {
                CMExecutionContext.checkCancelOrTimeOut();
                CMDbStoreSelectDef dbQuery = new CMDbStoreSelectDef(con, query2, null, null, false, false, null, true, 0);
                rs = dbQuery.execute(con, reducedObjectIDs);
                while (rs.next()) {
                    referencingObjIDs.add(rs.getInt(1));
                }
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
            }
            catch (SQLException ex) {
                CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmUnexpectedResultProcessingFailure");
            }
            finally {
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
            }
        }
        if (referencingObjIDs == null) {
            referencingObjIDs = new CMIntList();
        }
        return referencingObjIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMIntList executeChildStepInDB(CMStore store, int[] parentIds, CMStorePathStep query2) throws CMException {
        CMIntList resultIds = new CMIntList();
        ResultSet rs = null;
        CMDbStore dbStore = (CMDbStore)store;
        CMDbConnection con = dbStore.getConnection();
        try {
            CMDbStoreSelectDef dbQuery = new CMDbStoreSelectDef(con, query2, null, null, false, false, null, true, 0);
            rs = dbQuery.execute(con, parentIds, true);
            while (rs.next()) {
                resultIds.add(rs.getInt(1));
            }
            CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmUnexpectedResultProcessingFailure");
        }
        finally {
            CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
        }
        return resultIds;
    }

    @Override
    public void addLiteralNotInline(CMStoreQueryInfo queryNotInline, CMProperty property, Object literal) {
        ArrayList<Literal> queryLiterals = null;
        if (this.literalsNotInline_ == null) {
            this.literalsNotInline_ = new HashMap<CMStoreQueryInfo, ArrayList<Literal>>();
        } else {
            queryLiterals = this.literalsNotInline_.get(queryNotInline);
        }
        if (queryLiterals == null) {
            queryLiterals = new ArrayList();
        }
        queryLiterals.add(new Literal(property, literal));
        this.literalsNotInline_.put(queryNotInline, queryLiterals);
    }

    @Override
    public void addLiteralValue(Object literal) {
        this.literals_.add(new LiteralValue(literal));
    }

    @Override
    public String addLiteral(CMProperty property, Object literal) {
        this.literals_.add(new Literal(property, literal));
        return CMDbStoreUtil.addLiteral(this.connection, property, literal);
    }

    @Override
    public boolean requiresSpecialIsNullHandling(CMProperty property) {
        if (CMDbConnection.dbms_ == 4 && property instanceof CMDbProperty) {
            CMDbProperty prop = (CMDbProperty)property;
            return prop.storedAsBlob();
        }
        return false;
    }

    @Override
    public String getIsNullExpression(String column, boolean bIsNull) {
        return this.sqlGenerator.createIsNullExpression(column, bIsNull);
    }

    @Override
    public String startIsNullExpression(CMProperty property, boolean forPredicate) {
        return this.sqlGenerator.createStartIsNullExpression(this.getColumn(property, forPredicate, true), this.requiresSpecialIsNullHandling(property));
    }

    @Override
    public String endIsNullExpression(CMProperty property, boolean isNull) {
        return this.sqlGenerator.createEndIsNullExpression(this.requiresSpecialIsNullHandling(property), isNull);
    }

    @Override
    public boolean hasMultipleRecords(CMProperty property) {
        if (property instanceof CMDbProperty) {
            CMDbProperty prop = (CMDbProperty)property;
            return property == CMProperty.NAME || property == CMProperty.DEFAULTNAME || property.isMultilingualRelated() || prop.isStoredAsArray();
        }
        return false;
    }

    @Override
    public int getMaxObjectsInline() {
        return CMDbConnection.getMaxObjectsInline();
    }

    @Override
    public int getMaxRefObjectsInline() {
        return CMDbConnection.getMaxRefObjectsInline();
    }

    @Override
    public boolean useCountInsteadOfExistsExpression() {
        return CMDbConnection.getDbmsInfo().getDbmsReplaceExistsWithCount();
    }

    protected CMDbStoreSelectDef newSelectDef(CMDbConnection con, CMProperty[] props) throws CMStoreUnexpected {
        return new CMDbStoreSelectDef(con, null, props, null);
    }

    static void init() {
        StringReader reader = new StringReader("(isNull('_recipients') or matchesIdentity(@_UfRecipients))");
        CMPathStepTokenizer toker = new CMPathStepTokenizer(reader);
        try {
            selectBurstOutput_ = new CMStorePathPredicate(toker, -1);
        }
        catch (Exception ex) {
            throw new IllegalStateException("CMDbStoreSelectDef: invalid predicate " + ex.toString());
        }
    }

    private static final CMStorePathPredicate getBurstOutputSelection() {
        return selectBurstOutput_;
    }

    @Override
    public String getColumnsSeparator() {
        return this.sqlGenerator.createColumnsSeparator();
    }

    @Override
    public String getLiteralsSeparator() {
        return this.sqlGenerator.createBindParametersSeparator();
    }

    public CMDbProperty getMappedProperty(int idx) {
        return (CMDbProperty)this.properties_[this.columnMap_[idx]];
    }

    private static class LiteralValue {
        Object value_;

        LiteralValue(Object value) {
            this.value_ = value;
        }
    }

    private static class Literal {
        CMProperty property_;
        Object value_;

        Literal(CMProperty prop, Object value) {
            this.property_ = prop;
            this.value_ = value;
        }
    }

    private static class MLPropInfo {
        CMProperty property_;
        int tableIdx_;

        MLPropInfo(CMProperty prop, int tableIdx) {
            this.property_ = prop;
            this.tableIdx_ = tableIdx;
        }
    }
}

