/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.dbstore.CMDbStoreObjects;
import com.cognos.cm.dbstore.PropertyArray;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.dbstore.properties.CMDbStorePermissions;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.ExtendedUserCapabilities;
import com.cognos.cm.server.profileSettings.SessionProfileSettings;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cmutils.hash.HashUtil;
import java.util.ArrayList;
import java.util.List;

public class CMDbStoreSessionQueryResults
implements CMStoreQueryResults {
    private CMProperty EXTENDEDUSERCAPABILITIES = CMObjectClass.SESSION.getProperty("extendedUserCapabilities");
    private String passportID_;
    private boolean bNextCalledOnce_ = false;
    private PropertyArray properties;
    private CMDbStore store_ = null;
    private int sessionObjectID_ = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMDbStoreSessionQueryResults(CMDbStore store, ICMStorePath query2, CMProperty[] properties) throws CMCacheException, CMCacheAccessDenied, CMException {
        if (query2 == null) {
            return;
        }
        CMExecutionContext curContext = CMExecutionContext.get();
        this.passportID_ = curContext.getAccManPassportID();
        this.properties = new PropertyArray(properties);
        this.store_ = store;
        int[] curUserObjID = new int[]{curContext.getCurrentUserAccountObjectID()};
        if (curUserObjID[0] > 0) {
            CMStoreXPath sessionPath = new CMStoreXPath("/*/*[@name='" + this.getName() + "']");
            CMCacheQueryInstance cacheQuery = null;
            try {
                cacheQuery = store.getCache().executeAdminQuery(curUserObjID, 1, sessionPath, 0);
                int[] objs = cacheQuery.resultObjects();
                if (objs != null && objs.length == 1) {
                    this.sessionObjectID_ = objs[0];
                }
            }
            catch (CMCacheException cMCacheException) {
            }
            finally {
                if (cacheQuery != null) {
                    cacheQuery.release();
                }
            }
        }
    }

    @Override
    public void release() {
        this.bNextCalledOnce_ = false;
    }

    @Override
    public boolean next() throws CMException {
        if (this.bNextCalledOnce_) {
            return false;
        }
        this.bNextCalledOnce_ = true;
        return true;
    }

    @Override
    public Object getValue(CMProperty prop) throws CMException {
        return this.getValue(this.properties.indexOf(prop));
    }

    @Override
    public Object getValue(int index) throws CMException {
        CMProperty property = this.properties.get(index);
        if (property == CMProperty.OBJECTCLASS) {
            return CMObjectClass.SESSION;
        }
        if (property == CMProperty.DEFAULTNAME) {
            return this.getName();
        }
        if (property == CMProperty.SEARCHPATH) {
            return this.getSearchPath();
        }
        if (property == CMProperty.SEARCHPATHFORURL) {
            return new CMDbStoreString("~~");
        }
        if (property == CMProperty.NAME) {
            CMDbStoreLocalizedStringArray names = new CMDbStoreLocalizedStringArray();
            String userLocale = CMExecutionContext.get().getPreference(CMPreference.CONTENTLOCALE);
            names.add(new CMDbStoreLocalizedString(CMDbStoreStringLocales.findLocale(userLocale), this.getName()));
            return names;
        }
        if (property == CMProperty.CREATIONTIME) {
            return CMDateUtils.getIsoDate(CMExecutionContext.get().getCurrentUserSessionCreateTime());
        }
        if (property == CMProperty.MODIFICATIONTIME) {
            return CMDateUtils.getIsoDate();
        }
        if (property == CMProperty.PARENT) {
            CMDbStoreBaseClassArray value = new CMDbStoreBaseClassArray();
            value.add(new CMDbStoreObjectReference(this.getParentSearchPath()));
            return value;
        }
        if (property == CMProperty.HASCHILDREN) {
            if (this.sessionObjectID_ > 0) {
                try {
                    if (this.store_.getCache().CMCacheGetHasChildren(this.sessionObjectID_)) {
                        return new CMDbStoreString("true");
                    }
                }
                catch (CMCacheException value) {
                    // empty catch block
                }
            }
            return new CMDbStoreString("false");
        }
        if (property == CMProperty.DISABLED) {
            if (this.sessionObjectID_ > 0) {
                try {
                    if (this.store_.getCache().CMCacheIsObjectDisabled(this.sessionObjectID_)) {
                        return new CMDbStoreString("true");
                    }
                }
                catch (CMCacheException value) {
                    // empty catch block
                }
            }
            return new CMDbStoreString("false");
        }
        if (property == CMProperty.IDENTITY) {
            ArrayList<CMObjectReference> userMembership = CMExecutionContext.get().getCurrentUserIdentity();
            CMDbStoreBaseClassArray anonymousIdentities = new CMDbStoreBaseClassArray();
            for (int iIdent = 0; iIdent < userMembership.size(); ++iIdent) {
                anonymousIdentities.add(userMembership.get(iIdent));
            }
            return anonymousIdentities;
        }
        if (property == CMProperty.USERCAPABILITIES || property == this.EXTENDEDUSERCAPABILITIES) {
            CMDbStoreStringArray value = new CMDbStoreStringArray();
            ExtendedUserCapabilities caps = CMExecutionContext.get().getUserCapabilities();
            if (caps == null) {
                return value;
            }
            List<String> list = property == CMProperty.USERCAPABILITIES ? caps.getLegacyCapabilities() : caps.getCapabilities();
            for (String s : list) {
                value.add(s);
            }
            return value;
        }
        if (property == CMProperty.ANCESTORS) {
            CMExecutionContext conn = CMExecutionContext.get();
            try {
                int obj_id = conn.getCurrentUserAccountObjectID();
                CMAncestors propValue = this.store_.getCache().getAncestors(obj_id, CMDbStoreCacheUtil.getCacheSearchLocales());
                propValue.addChild(conn.getCurrentUserDisplayName(), conn.getCurrentUserSearchPath(), CMObjectClass.ACCOUNT.getName(), this.store_.getObjectStoreID(obj_id));
                return propValue;
            }
            catch (CMCacheException obj_id) {}
        } else {
            SessionProfileSettings ps;
            if (property == CMProperty.OWNER) {
                CMDbStoreBaseClassArray arr = new CMDbStoreBaseClassArray();
                arr.add(new CMDbStoreObjectReference(CMExecutionContext.get().getCurrentUserSearchPath()));
                return arr;
            }
            if (property == CMProperty.VERSION) {
                return new CMDbStoreString("1");
            }
            if (property == CMProperty.USAGE) {
                return new CMDbStoreString("object");
            }
            if (property == CMProperty.PERMISSIONS) {
                CMDbStorePermissions value = new CMDbStorePermissions();
                value.add("read");
                value.add("write");
                value.add("execute");
                value.add("traverse");
                return value;
            }
            if (property == CMProperty.TENANTID) {
                int tenantIdInt = CMExecutionContext.get().getCurrentUserTenantId();
                return new CMDbStoreString(this.store_.getTenantRegistry().getTenantIdStringFromInt(tenantIdInt));
            }
            if ("profileRole".equals(property.getName())) {
                CMDbStoreBaseClassArray bca = new CMDbStoreBaseClassArray();
                CMObjectReference ref = CMExecutionContext.get().getSessionProfileRole();
                if (ref != null) {
                    bca.add(ref);
                }
                return bca;
            }
            if ("userProfileSettings".equals(property.getName())) {
                SessionProfileSettings ps2 = CMExecutionContext.get().getCurrentUserProfileSettings();
                if (ps2 != null) {
                    return new CMDbStoreString(ps2.toString());
                }
            } else if (property == CMProperty.EFFECTIVEGLOBALPARAMETERS && (ps = CMExecutionContext.get().getCurrentUserProfileSettings()) != null) {
                return ps.getEffectiveGlobalParameters();
            }
        }
        return null;
    }

    @Override
    public boolean wasAcquired() {
        return false;
    }

    @Override
    public int getObjectID() {
        return -1;
    }

    @Override
    public String getPath() {
        return "~/" + this.getName();
    }

    @Override
    public String getSearchPath() {
        return CMExecutionContext.get().getCurrentUserSearchPath() + "/session[@defaultName='" + this.getName() + "']";
    }

    @Override
    public String getSecurityReference() {
        return null;
    }

    @Override
    public String getParentSearchPath() {
        return CMExecutionContext.get().getCurrentUserSearchPath();
    }

    @Override
    public int getParentObjectID() {
        return -1;
    }

    @Override
    public int getTenantID() {
        return CMExecutionContext.get().getCurrentUserTenantId();
    }

    @Override
    public String getName() {
        return new HashUtil().hash(this.passportID_);
    }

    @Override
    public CMObjectClass getObjectClass() {
        return CMObjectClass.SESSION;
    }

    @Override
    public void exclude() {
    }

    @Override
    public void reset() {
        this.bNextCalledOnce_ = false;
    }

    @Override
    public boolean hasPermission(String permission) {
        return true;
    }

    @Override
    public boolean hasExternalProperty(CMProperty property) {
        return false;
    }

    @Override
    public int getState() {
        return 1;
    }

    CMDbStoreObjects getObjects() {
        return null;
    }

    @Override
    public CMAncestors getAncestors() {
        return null;
    }

    @Override
    public void rewind() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsRewind() {
        return false;
    }

    @Override
    public boolean supportsSkipObjects() {
        return false;
    }

    @Override
    public CMStore getStore() {
        return this.store_;
    }
}

