/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.properties.CMCountInfo;
import com.cognos.cm.properties.CMCountSizeInfo;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.properties.CMSizeInfoArray;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class CMDbStoreSizeUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<Integer, Long> selectAllClassCounts(CMStore store) throws CMException {
        HashMap<Integer, Long> allClassCountsMap = new HashMap<Integer, Long>();
        CMDbStore dbstore = (CMDbStore)store;
        CMDbConnection con = dbstore.getConnection();
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append(sqlGenerator.createSelectAllClassCountsSql());
            stmt = con.createStatement();
            rs = stmt.executeQuery(buffer.toString());
            while (rs.next()) {
                int classId = rs.getInt(1);
                long totalCount = rs.getLong(2);
                allClassCountsMap.put(new Integer(classId), new Long(totalCount));
            }
            if (stmt == null) return allClassCountsMap;
        }
        catch (SQLException ex) {
            try {
                throw new CMException(ex);
            }
            catch (Throwable throwable) {
                if (stmt == null) throw throwable;
                CMDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        return allClassCountsMap;
    }

    public static Map<Integer, CMCountInfo> getTotalsFromDatabase(CMStore store, String storeID) throws CMException {
        HashMap<Integer, CMCountInfo> totalForClassId2;
        HashMap<Integer, CMCountInfo> allTotalsMap = new HashMap<Integer, CMCountInfo>();
        CMDbStore dbstore = (CMDbStore)store;
        CMObjectClasses objectClasses = dbstore.getObjectClasses();
        CMDbConnection con = dbstore.getConnection();
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        CMCountInfo info = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append(sqlGenerator.createSelectSql());
        sqlGenerator.appendColumnNames(new String[]{"TOTALFORCLASSID", "TOTALCOUNT", "TOTALSIZE"}, buffer);
        buffer.append(sqlGenerator.createFromSql());
        buffer.append("CMSIZEINFO");
        buffer.append(sqlGenerator.createWhereSql());
        sqlGenerator.appendColumnEqualsBindParameterSymbol("STOREID", buffer);
        try {
            stmt = con.prepareStatement(buffer.toString());
            stmt.setString(1, storeID);
            rs = stmt.executeQuery();
            while (rs.next()) {
                int totalForClassId2 = rs.getInt(1);
                CMObjectClass objectClass = objectClasses.getClassByID(totalForClassId2);
                if (objectClass == null) continue;
                String className = objectClass.getName();
                long totalCount = rs.getLong(2);
                if (rs.wasNull()) continue;
                long totalSize = rs.getLong(3);
                info = rs.wasNull() ? new CMCountInfo(className, totalCount) : new CMCountSizeInfo(className, totalCount, totalSize);
                allTotalsMap.put(new Integer(totalForClassId2), info);
            }
            totalForClassId2 = allTotalsMap;
        }
        catch (SQLException ex) {
            try {
                throw new CMException(ex);
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        return totalForClassId2;
    }

    public static void deleteTotalsInDatabase(CMStore store, String storeID) throws CMException {
        CMDbStore dbstore = (CMDbStore)store;
        CMDbConnection con = dbstore.getConnection();
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        PreparedStatement stmt = null;
        store.beginTransaction();
        boolean bCommit = true;
        StringBuffer buffer = new StringBuffer();
        sqlGenerator.appendDeleteFromTableSql("CMSIZEINFO", buffer);
        buffer.append(sqlGenerator.createWhereSql());
        sqlGenerator.appendColumnEqualsBindParameterSymbol("STOREID", buffer);
        try {
            int columnIdx = 1;
            stmt = con.prepareStatement(buffer.toString());
            stmt.setString(columnIdx++, storeID);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                bCommit = false;
                throw new CMException(ex);
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                if (bCommit) {
                    store.commitTransaction();
                } else {
                    store.rollbackTransaction();
                }
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        if (bCommit) {
            store.commitTransaction();
        } else {
            store.rollbackTransaction();
        }
    }

    public static void saveAllTotalsInDatabase(CMStore store, String storeID, int objectClassId, CMSizeInfoArray sizeInfoArray) throws CMException {
        boolean bCommit;
        PreparedStatement stmt_insert;
        PreparedStatement stmt_delete;
        block16: {
            CMDbStore dbstore = (CMDbStore)store;
            CMDbConnection con = dbstore.getConnection();
            ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
            CMObjectClasses objectClasses = store.getObjectClasses();
            stmt_delete = null;
            stmt_insert = null;
            StringBuffer deleteBuffer = new StringBuffer();
            sqlGenerator.appendDeleteFromTableSql("CMSIZEINFO", deleteBuffer);
            deleteBuffer.append(sqlGenerator.createWhereSql());
            sqlGenerator.appendColumnEqualsBindParameterSymbol("STOREID", deleteBuffer);
            deleteBuffer.append(sqlGenerator.createAndSql());
            sqlGenerator.appendColumnEqualsBindParameterSymbol("TOTALFORCLASSID", deleteBuffer);
            StringBuffer insertBuffer = new StringBuffer();
            sqlGenerator.appendInsertIntoTable("CMSIZEINFO", insertBuffer);
            sqlGenerator.appendColumnNames(new String[]{"STOREID", "CLASSID", "TOTALFORCLASSID", "TOTALCOUNT", "TOTALSIZE"}, insertBuffer);
            insertBuffer.append(sqlGenerator.createClosingBracket());
            sqlGenerator.appendValuesForInsertIntoTable(insertBuffer);
            sqlGenerator.appendNBindParameters(5, insertBuffer);
            insertBuffer.append(sqlGenerator.createClosingBracket());
            store.beginTransaction();
            bCommit = true;
            try {
                stmt_delete = con.prepareStatement(deleteBuffer.toString());
                stmt_insert = con.prepareStatement(insertBuffer.toString());
                int it_number = 0;
                int columnIdx = 1;
                for (int i = 0; i < sizeInfoArray.getSize(); ++i) {
                    CMCountInfo info = (CMCountInfo)sizeInfoArray.getItem(i);
                    String className = info.getClassName();
                    CMObjectClass totalObjectClass = objectClasses.getClassByName(className);
                    if (totalObjectClass == null) continue;
                    int classId = totalObjectClass.getID();
                    columnIdx = 1;
                    stmt_delete.setString(columnIdx++, storeID);
                    stmt_delete.setInt(columnIdx++, classId);
                    stmt_delete.addBatch();
                    columnIdx = 1;
                    stmt_insert.setString(columnIdx++, storeID);
                    stmt_insert.setInt(columnIdx++, objectClassId);
                    stmt_insert.setInt(columnIdx++, classId);
                    stmt_insert.setLong(columnIdx++, info.getCount());
                    if (info instanceof CMCountSizeInfo) {
                        stmt_insert.setLong(columnIdx++, ((CMCountSizeInfo)info).getSize());
                    } else {
                        stmt_insert.setNull(columnIdx++, -5);
                    }
                    stmt_insert.addBatch();
                    if ((it_number + 1 & 0x3FF) == 0) {
                        try {
                            stmt_delete.executeBatch();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        stmt_insert.executeBatch();
                    }
                    ++it_number;
                }
                if ((it_number & 0x3FF) == 0) break block16;
                try {
                    stmt_delete.executeBatch();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                stmt_insert.executeBatch();
            }
            catch (SQLException ex) {
                try {
                    bCommit = false;
                    throw new CMException(ex);
                }
                catch (Throwable throwable) {
                    CMDbStoreUtil.safeCloseStatement(stmt_delete);
                    CMDbStoreUtil.safeCloseStatement(stmt_insert);
                    if (bCommit) {
                        store.commitTransaction();
                    } else {
                        store.rollbackTransaction();
                    }
                    throw throwable;
                }
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt_delete);
        CMDbStoreUtil.safeCloseStatement(stmt_insert);
        if (bCommit) {
            store.commitTransaction();
        } else {
            store.rollbackTransaction();
        }
    }

    public static class OrderByColumn {
        public String columnName_;
        public boolean descending_;

        public OrderByColumn(boolean descending, String columnName) {
            this.columnName_ = columnName;
            this.descending_ = descending;
        }
    }
}

