/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreSysProperties;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.CMDbmsInfo;
import com.cognos.cm.server.CMException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CMDbStoreSplitTransactionUpgrade {
    private static final int CMSPLITTRANSACTION_ARGUMENT_ARRAY_LENGTH = 6;
    private static final int CHUNK_SIZE_ARG_IDX = 0;
    private static final int DML_SQL_COMMAND_ARG_IDX = 1;
    private static final int START_DML_SQL_ARG_IDX = 2;
    private static final int SELECT_FROM_TABLE_NAME_ARG_IDX = 3;
    private static final int DML_WHERE_SQL_ARG_IDX = 4;
    private static final int TRANSACTION_ID_ARG_IDX = 5;
    private static final String INSERT_OPERATION = "insert";
    private static final String UPDATE_OPERATION = "update";
    protected CMDbConnection con = null;
    protected CMDbmsInfo dbmsInfo = null;
    private int chunkSize = 0;
    private int maxCMID;
    private int minCMID;
    protected int currentChunkStart = -1;
    protected int currentChunkEnd = -1;
    protected String transactionID;
    protected PreparedStatement dmlStatement = null;
    private PreparedStatement cleanupStatement = null;

    public int getmaxCMID() {
        return this.maxCMID;
    }

    public int getminCMID() {
        return this.minCMID;
    }

    public String transactionID() {
        return this.transactionID;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    private void validateConnection(CMDbConnection connection) throws IllegalStateException {
        if (connection == null) {
            IllegalStateException cmex = new IllegalStateException("Invalid connection");
            throw cmex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readStatsFromCMSPLIT(String function) throws SQLException {
        PreparedStatement stmt = null;
        int value = -1;
        try {
            String singleQuote = this.con.getSqlGenerator().createStringLiteralSingleQuote();
            stmt = this.con.prepareStatement("select " + this.dbmsInfo.getAgregatedSQLFunction(function) + " (split.CMID) from CMSPLIT split where split.TRANSACTIONID = " + singleQuote + this.transactionID + singleQuote);
            ResultSet rs = stmt.executeQuery();
            if (rs != null && rs.next()) {
                rs.getInt(1);
                if (!rs.wasNull()) {
                    value = rs.getInt(1);
                }
            }
            stmt.close();
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        return value;
    }

    protected void validateArguments(String[] args) {
        if (args.length != this.getRequiredArgumentsArrayLength()) {
            throw new IllegalStateException("Invalid number of arguments to Split Transaction");
        }
        if (this.getChunkSize(args) <= 0) {
            throw new IllegalStateException("Invalid ChunkSize");
        }
        if (this.getTransactionID(args) == null || this.getTransactionID(args).length() == 0) {
            throw new IllegalStateException("Invalid transactionID");
        }
        if (!this.isSupportedOperation(this.getDmlSqlCommand(args))) {
            throw new IllegalStateException("Unsupported Operation");
        }
    }

    private boolean isSupportedOperation(String dmlSqlCommand) {
        if (dmlSqlCommand == null || dmlSqlCommand.length() == 0) {
            return false;
        }
        return dmlSqlCommand.equalsIgnoreCase(INSERT_OPERATION) || dmlSqlCommand.equalsIgnoreCase(UPDATE_OPERATION);
    }

    protected boolean isTransactionIDinCMSYSPROPS() throws CMException {
        String result = CMDbStoreSysProperties.getSysProp(this.con, this.transactionID);
        return result != null;
    }

    protected void insertTransactionIDintoCMSYSPROPS() throws CMException {
        CMDbStoreSysProperties.addSysProp(this.con, this.transactionID, "dummy");
    }

    public void deleteTransactionIDfromCMSYSPROPS(CMDbConnection con, String transactionID) throws CMException {
        CMDbStoreSysProperties.deleteSysProp(con, transactionID);
    }

    private boolean isLastChunk() {
        return this.currentChunkEnd >= this.maxCMID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCMIDsIntoCMSPLIT(String selectFromTableName, String dmlWhereSql) throws SQLException {
        PreparedStatement stmt = null;
        String selectStmt = this.selectCMIDsForCMSPLITSqlExpression(selectFromTableName, dmlWhereSql);
        try {
            stmt = this.con.prepareStatement("insert into CMSPLIT (CMID, TRANSACTIONID ) " + selectStmt);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
    }

    private String selectCMIDsForCMSPLITSqlExpression(String fromTableName, String whereSql) {
        String singleQuote = this.con.getSqlGenerator().createStringLiteralSingleQuote();
        String selectStmt = "select CMID, " + singleQuote + this.transactionID + singleQuote + this.con.getSqlGenerator().createFromSql() + fromTableName + " " + whereSql;
        return selectStmt;
    }

    private void processSplitTransactionInChunks() throws SQLException, CMException {
        boolean isLastChunkProcessed = false;
        while (!isLastChunkProcessed) {
            try {
                this.con.beginTransaction();
                this.processChunk();
                if (this.isLastChunk()) {
                    isLastChunkProcessed = true;
                    this.deleteTransactionIDfromCMSYSPROPS(this.con, this.transactionID);
                }
                this.con.commitTransaction();
            }
            catch (SQLException sqlex) {
                this.con.rollbackTransaction();
                throw sqlex;
            }
            catch (CMException cmex) {
                this.con.rollbackTransaction();
                throw cmex;
            }
        }
    }

    private void prepareSplitTransactionData(String fromTableName, String whereSql) throws SQLException, CMException {
        if (!this.isTransactionIDinCMSYSPROPS()) {
            try {
                this.con.beginTransaction();
                this.readCMIDsIntoCMSPLIT(fromTableName, whereSql);
                this.insertTransactionIDintoCMSYSPROPS();
                this.con.commitTransaction();
            }
            catch (SQLException sqlex) {
                this.con.rollbackTransaction();
                throw sqlex;
            }
            catch (CMException cmex) {
                this.con.rollbackTransaction();
                throw cmex;
            }
        }
    }

    private void setCurrentChunkLimits() {
        this.currentChunkStart = this.currentChunkStart < 0 ? this.minCMID : this.currentChunkEnd + 1;
        this.currentChunkEnd = this.currentChunkStart + this.chunkSize;
    }

    protected String appendChunkConditionSqlExpression(String whereExpression) {
        StringBuffer newWhereExpression = new StringBuffer();
        if (whereExpression.indexOf("where") != -1 || whereExpression.indexOf("WHERE") != -1) {
            newWhereExpression.append(whereExpression + " and ");
        } else {
            newWhereExpression.append(" where ");
        }
        newWhereExpression.append("CMID in (select split.CMID from CMSPLIT split " + this.constructChunkConditionSqlExpression() + ")");
        return newWhereExpression.toString();
    }

    private String constructChunkConditionSqlExpression() {
        String singleQuote = this.con.getSqlGenerator().createStringLiteralSingleQuote();
        return "where split.CMID >=? and split.CMID <=? and split.TRANSACTIONID = " + singleQuote + this.transactionID + singleQuote;
    }

    private String constructDmlSql(String dmlSqlCommand, String startDmlSql, String selectFromTableName, String dmlWhereSql) {
        return this.constructDmlSqlExpression(dmlSqlCommand, startDmlSql, selectFromTableName) + " " + this.constructDmlSqlWhereExpression(dmlWhereSql);
    }

    protected String constructDmlSqlWhereExpression(String dmlWhereSql) {
        return this.appendChunkConditionSqlExpression(dmlWhereSql);
    }

    private String constructDmlSqlExpression(String dmlSqlCommand, String startDmlSql, String selectFromTableName) {
        if (dmlSqlCommand.equalsIgnoreCase(INSERT_OPERATION)) {
            return dmlSqlCommand + " " + startDmlSql + " " + selectFromTableName;
        }
        return dmlSqlCommand + " " + startDmlSql;
    }

    private String constructCleanupSQL() {
        String singleQuote = this.con.getSqlGenerator().createStringLiteralSingleQuote();
        return "delete from CMSPLIT where CMID >=? and CMID <=? and TRANSACTIONID = " + singleQuote + this.transactionID + singleQuote;
    }

    private void processChunk() throws SQLException {
        this.setCurrentChunkLimits();
        this.executeDmlSqlForCurrentChunk();
        this.setChunkConditionSQLParameters(this.cleanupStatement);
        this.cleanupStatement.executeUpdate();
    }

    protected void executeDmlSqlForCurrentChunk() throws SQLException {
        this.setChunkConditionSQLParameters(this.dmlStatement);
        this.dmlStatement.executeUpdate();
    }

    protected void setChunkConditionSQLParameters(PreparedStatement statement) throws SQLException {
        statement.setInt(1, this.currentChunkStart);
        statement.setInt(2, this.currentChunkEnd);
    }

    private void initializeConnection(CMDbConnection connection) {
        this.con = connection;
        this.dbmsInfo = CMDbConnection.getDbmsInfo();
    }

    protected void initializePreparedStatements(String[] args) throws SQLException {
        this.dmlStatement = this.con.prepareStatement(this.constructDmlSql(this.getDmlSqlCommand(args), this.getStartDmlSql(args), this.getSelectFromTableName(args), this.getDmlWhereSql(args)));
        this.cleanupStatement = this.con.prepareStatement(this.constructCleanupSQL());
    }

    private String getTransactionID(String[] args) {
        return args[5];
    }

    private String getDmlWhereSql(String[] args) {
        return args[4];
    }

    protected String getSelectFromTableName(String[] args) {
        return args[3];
    }

    private String getStartDmlSql(String[] args) {
        return args[2];
    }

    private String getDmlSqlCommand(String[] args) {
        return args[1];
    }

    private int getChunkSize(String[] args) {
        return new Integer(args[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(CMDbConnection connection, String[] args) throws CMException, SQLException {
        try {
            this.initialize(connection, args);
            this.prepareSplitTransactionData(this.getSelectFromTableName(args), this.getPopulatingCMSPLITWhereSql(args));
            this.maxCMID = this.readStatsFromCMSPLIT("max");
            this.minCMID = this.readStatsFromCMSPLIT("min");
            if (this.maxCMID < 0 || this.minCMID < 0) {
                boolean bl = false;
                return bl;
            }
            this.processSplitTransactionInChunks();
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeStatements();
        }
    }

    protected String getPopulatingCMSPLITWhereSql(String[] args) {
        return this.getDmlWhereSql(args);
    }

    protected void initialize(CMDbConnection connection, String[] args) throws SQLException {
        this.validateConnection(connection);
        this.initializeConnection(connection);
        this.validateArguments(args);
        this.chunkSize = this.getChunkSize(args);
        this.transactionID = this.getTransactionID(args);
        this.initializePreparedStatements(args);
    }

    protected void closeStatements() {
        CMDbStoreUtil.safeCloseStatement(this.dmlStatement);
        CMDbStoreUtil.safeCloseStatement(this.cleanupStatement);
    }

    protected int getRequiredArgumentsArrayLength() {
        return 6;
    }
}

