/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStoreNonObjectAddDef;
import com.cognos.cm.dbstore.CMDbStoreNonObjectUpdateDef;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CMDbStoreSysProperties {
    private static CMDbProperty SYSPROP_KEY;
    private static final String SYSPROP_KEYDEF = "<property name='propname' table='CMSYSPROPS' column='PROPNAME' type='xs:string'/>";
    private static CMDbProperty SYSPROP_VALUE;
    private static final String SYSPROP_VALUEDEF = "<property name='propname' table='CMSYSPROPS' column='PROPVALUE' type='xs:string'/>";
    private static String sysPropWhereClause_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSysProp(CMDbConnection con, String propName) throws CMException {
        boolean closeTransaction;
        PreparedStatement stmt;
        block23: {
            String string;
            block22: {
                stmt = null;
                closeTransaction = false;
                try {
                    if (CMDbConnection.dbms_ == 3 && !con.inTransaction()) {
                        con.beginTransaction();
                        closeTransaction = true;
                    }
                    stmt = con.prepareStatement("select PROPVALUE from CMSYSPROPS where " + sysPropWhereClause_);
                    CMDbStorePropertySerialization.bindParameterByProperty(stmt, 1, SYSPROP_KEY, propName);
                    ResultSet rs2333332 = stmt.executeQuery();
                    if (rs2333332.next()) {
                        Object data = CMDbStorePropertySerialization.getColumnByProperty(rs2333332, 1, SYSPROP_VALUE);
                        string = data.toString();
                        CMDbStoreUtil.safeCloseStatement(stmt);
                        if (!closeTransaction) return string;
                        if (!con.inTransaction()) return string;
                        break block22;
                    }
                    if (closeTransaction) {
                        con.commitTransaction();
                    }
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    break block23;
                }
                catch (SQLException ex) {
                    CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmStoreUnexpectedErrDeleteObjs");
                    return null;
                }
            }
            try {
                con.rollbackTransaction();
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }
        if (!closeTransaction) return null;
        if (!con.inTransaction()) return null;
        try {
            con.rollbackTransaction();
            return null;
        }
        catch (Exception rs2333332) {
            return null;
        }
        catch (Exception exception) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            if (!closeTransaction) return null;
            if (!con.inTransaction()) return null;
            try {
                con.rollbackTransaction();
                return null;
            }
            catch (Exception exception2) {
                return null;
            }
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
            if (closeTransaction && con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSysProp(CMDbConnection con, String propName, String value) throws CMException {
        try {
            CMDbStoreNonObjectAddDef addDef = new CMDbStoreNonObjectAddDef("CMSYSPROPS", SYSPROP_KEY);
            addDef.addColumn(SYSPROP_VALUE, value);
            addDef.execute(con, propName);
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmStoreUnexpectedErrDeleteObjs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSysProp(CMDbConnection con, String propName) throws CMException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("delete from CMSYSPROPS where " + sysPropWhereClause_);
            CMDbStorePropertySerialization.bindParameterByProperty(stmt, 1, SYSPROP_KEY, propName);
            stmt.executeUpdate();
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmStoreUnexpectedErrDeleteObjs");
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateSysProp(CMDbConnection con, String propName, String value) throws CMException {
        boolean successful = false;
        try {
            CMDbStoreNonObjectUpdateDef updateDef = new CMDbStoreNonObjectUpdateDef("CMSYSPROPS", SYSPROP_KEY);
            updateDef.addColumn(SYSPROP_VALUE, value);
            successful = updateDef.execute(con, " where " + sysPropWhereClause_, new CMDbProperty[]{SYSPROP_VALUE}, new Object[]{propName}) > 0;
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmStoreUnexpectedErrDeleteObjs");
        }
        return successful;
    }

    public static void initializeSysPropTable(Connection con) throws CMException {
        try {
            SYSPROP_KEY = new CMDbProperty(con, SYSPROP_KEYDEF);
            SYSPROP_VALUE = new CMDbProperty(con, SYSPROP_VALUEDEF);
            boolean ciWrap = false;
            StringBuffer whereClause = new StringBuffer(1024);
            if (CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive()) {
                whereClause.append("CI_");
                ciWrap = true;
            }
            whereClause.append(SYSPROP_KEY.getColumn(0).getName());
            if (CMDbConnection.dbms_ == 3) {
                whereClause.append("=upper(cast(? as varchar(4000)))");
            } else if (CMDbConnection.dbms_ == 8) {
                whereClause.append("=upper(cast(? as lvarchar(4000)))");
            } else {
                whereClause.append(ciWrap ? "=UPPER(?)" : "=?");
            }
            sysPropWhereClause_ = whereClause.toString();
        }
        catch (Exception ex) {
            CMIndications.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperty(CMDbConnection con, String name, String value) throws CMException {
        try {
            con.beginTransaction();
            CMDbStoreSysProperties.deleteSysProp(con, name);
            CMDbStoreSysProperties.addSysProp(con, name, value);
            con.commitTransaction();
        }
        catch (SQLException e) {
            CMDbStoreExceptionUtil.handleSQLException(con, e, "cmStoreUnexpected");
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }
}

