/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreTransactionAction;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multipart.RequestFileAttachment;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCache;
import com.cognos.cmutils.tempcache.CMTempFile;
import java.io.File;

public class CMDbStoreTAAddToCache
implements CMDbStoreTransactionAction {
    private CMDbStore store_;
    private int objectID_;
    private CMProperty[] properties_;
    private RequestFileAttachment[] dataFiles_;
    private Long[] decryptedDataSizes_;

    public CMDbStoreTAAddToCache(CMDbStore store, int newObjectID, CMProperty[] properties, RequestFileAttachment[] dataFiles, Long[] decryptedDataSizes) {
        this.store_ = store;
        this.objectID_ = newObjectID;
        this.properties_ = properties;
        this.dataFiles_ = dataFiles;
        this.decryptedDataSizes_ = decryptedDataSizes;
    }

    @Override
    public void commit() {
        for (int i = 0; i < this.dataFiles_.length; ++i) {
            if (this.dataFiles_[i] == null) continue;
            this.dataFiles_[i].flush();
            if (this.decryptedDataSizes_[i].intValue() == 0 && this.dataFiles_[i] != null) {
                File f = new File(this.dataFiles_[i].getFilePath());
                this.decryptedDataSizes_[i] = new Long(f.length());
            }
            boolean bLockAndReturn = false;
            Object key = CMDbStoreFactory.tempfileCache_.getNewTempFileCacheKey(this.objectID_, this.properties_[i]);
            CMDbStoreFactory.tempfileCache_.add(key, this.dataFiles_[i].getFilePath(), bLockAndReturn);
        }
    }

    @Override
    public void rollback() {
        try {
            CMCache cache = this.store_.getCache();
            if (AdvancedSettings.DISCARDCMIDONERROR) {
                String dbCode;
                CMDbConnection dbConn = this.store_.getConnection();
                CMException dbEx = dbConn.getException();
                String string = dbCode = dbEx == null ? "" : dbEx.getCode();
                if (dbCode == "cmDatabaseConstraintViolation" || dbCode == "cmDatabaseRollback") {
                    cache.discardCMID(this.objectID_);
                } else {
                    cache.CMCacheDeleteObject(this.objectID_);
                }
            } else {
                cache.CMCacheDeleteObject(this.objectID_);
            }
            for (int i = 0; i < this.properties_.length; ++i) {
                Object key = CMDbStoreFactory.tempfileCache_.getNewTempFileCacheKey(this.objectID_, this.properties_[i]);
                CMTempFile tempfile = CMDbStoreFactory.tempfileCache_.get(key);
                if (tempfile == null) continue;
                tempfile.release();
                CMDbStoreFactory.tempfileCache_.remove(key);
            }
        }
        catch (CMException ex) {
            CMException cmex = new CMException(ex, "cmErrCacheAddRollBack");
            CMIndications.logException(cmex);
        }
    }
}

