/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreTransactionAction;
import com.cognos.cm.dbstore.CMUserCapabilityPoliciesHandler;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.collections.IntSet;
import java.util.ArrayList;
import java.util.List;

public class CMDbStoreTAUpdateCache
implements CMDbStoreTransactionAction {
    static final int UNCHANGED = 0;
    static final int SET = 1;
    static final int CLEARED = 2;
    CMDbStoreLocalizedStringArray names_;
    String name_;
    String cachedPropertyValue_;
    int cachedProperty_ = -1;
    boolean cachedPropertyUpdated_;
    boolean hasPolicies_;
    boolean policyUpdated_;
    boolean UCPoliciesUpdated_;
    boolean hasUCPolicies_;
    int disabled_;
    boolean disabledUpdated_;
    List<CMProperty> attachPropsUpdated_;
    boolean credentialNamespaceUpdated_;
    boolean credentialNamespaceSet_;
    boolean formatUpdated_;
    int format_;
    boolean localeUpdated_;
    CMDbStoreStringLocale locale_;
    boolean messageUpdated_;
    boolean hasMessage_;
    boolean deployedObjectUsageUpdated_;
    int deployedObjectUsage_;
    boolean hasRecipientsUpdated_;
    boolean hasRecipients_;
    boolean hasRecipientsEMailUpdated_;
    boolean hasRecipientsEMail_;
    boolean ownerUpdated_;
    String storeID_;
    boolean tenantIDUpdated_;
    int tenantID_;
    int[] objectIDs_;
    CMDbStore store_;

    public CMDbStoreTAUpdateCache(CMDbStore store, int[] shortcutObjectIDs, List<CMProperty> properties, List<Object> values, String storeId) {
        this.store_ = store;
        this.objectIDs_ = shortcutObjectIDs;
        this.storeID_ = storeId;
        if (properties != null) {
            for (int i = 0; i < properties.size(); ++i) {
                Short sValue;
                Object propValue;
                CMProperty prop = properties.get(i);
                if (prop == CMProperty.NAME) {
                    this.names_ = (CMDbStoreLocalizedStringArray)values.get(i);
                    continue;
                }
                if (prop == CMProperty.DEFAULTNAME) {
                    this.name_ = (String)values.get(i);
                    continue;
                }
                if (prop == CMProperty.POLICIES) {
                    this.hasPolicies_ = values.get(i) != null;
                    this.policyUpdated_ = true;
                    continue;
                }
                if (prop == CMProperty.USERCAPABILITYPOLICIES) {
                    this.UCPoliciesUpdated_ = true;
                    this.hasUCPolicies_ = values.get(i) != null;
                    continue;
                }
                if (prop.canBeAttachment()) {
                    if (this.attachPropsUpdated_ == null) {
                        this.attachPropsUpdated_ = new ArrayList<CMProperty>();
                    }
                    this.attachPropsUpdated_.add(prop);
                    continue;
                }
                if (prop == CMProperty.RECIPIENTSEMAIL) {
                    this.hasRecipientsEMailUpdated_ = true;
                    if (values.get(i) == null) continue;
                    this.hasRecipientsEMail_ = true;
                    continue;
                }
                if (prop == CMProperty.RECIPIENTS) {
                    this.hasRecipientsUpdated_ = true;
                    if (values.get(i) == null) continue;
                    this.hasRecipients_ = true;
                    continue;
                }
                if (prop == CMProperty.DISABLED) {
                    try {
                        this.disabled_ = values.get(i) == null ? 0 : (CMXMLUtils.parseBooleanAttribute((String)values.get(i)) ? 1 : 2);
                        this.disabledUpdated_ = true;
                    }
                    catch (CMException cMException) {}
                    continue;
                }
                if (this.propertyIsCached(prop)) {
                    if (values.get(i) != null) {
                        this.cachedPropertyValue_ = values.get(i).toString();
                    }
                    this.setCachedProperty(prop);
                    this.cachedPropertyUpdated_ = true;
                    continue;
                }
                if (prop == CMProperty.CREDENTIALNAMESPACES) {
                    this.credentialNamespaceUpdated_ = true;
                    if (values.get(i) == null) continue;
                    this.credentialNamespaceSet_ = true;
                    continue;
                }
                if (prop == CMProperty.LOCALE) {
                    this.localeUpdated_ = true;
                    propValue = values.get(i);
                    if (propValue == null) continue;
                    CMDbStoreStringLocale locale = null;
                    locale = propValue.getClass() != CMDbStoreStringLocale.class ? (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(propValue.toString()) : (CMDbStoreStringLocale)propValue;
                    this.locale_ = locale;
                    continue;
                }
                if (prop == CMProperty.FORMAT) {
                    try {
                        this.formatUpdated_ = true;
                        propValue = values.get(i);
                        sValue = (Short)((CMDbProperty)prop).getDataSerializer().serialize(propValue);
                        if (sValue != null) {
                            this.format_ = sValue.intValue();
                            continue;
                        }
                        this.format_ = 255;
                    }
                    catch (CMException ex) {
                        this.format_ = 255;
                    }
                    continue;
                }
                if (prop == CMProperty.MESSAGE) {
                    this.messageUpdated_ = true;
                    this.hasMessage_ = values.get(i) != null;
                    continue;
                }
                if (prop == CMProperty.DEPLOYEDOBJECTUSAGE) {
                    this.deployedObjectUsageUpdated_ = true;
                    try {
                        propValue = values.get(i);
                        sValue = (Short)((CMDbProperty)prop).getDataSerializer().serialize(propValue);
                        if (sValue != null) {
                            this.deployedObjectUsage_ = sValue.intValue();
                            continue;
                        }
                        this.deployedObjectUsage_ = 0;
                    }
                    catch (CMException ex) {
                        this.deployedObjectUsage_ = 0;
                    }
                    continue;
                }
                if (prop == CMProperty.OWNER) {
                    this.ownerUpdated_ = true;
                    continue;
                }
                if (prop != CMProperty.TENANTID) continue;
                this.tenantIDUpdated_ = true;
                TenantRegistry registry = store.getTenantRegistry();
                Object rawValue = values.get(i);
                String value = rawValue != null ? rawValue.toString() : null;
                try {
                    this.tenantID_ = registry.getTenantIdIntFromString(value, false);
                    continue;
                }
                catch (CMException ex) {
                    CMIndications.logException(ex);
                    this.tenantIDUpdated_ = false;
                }
            }
        }
    }

    private void setCachedProperty(Object prop) {
        if (prop == CMProperty.EVENTID) {
            this.cachedProperty_ = 15;
        } else if (prop == CMProperty.TASKID) {
            this.cachedProperty_ = 14;
        } else if (prop == CMProperty.DISPATCHERPATH) {
            this.cachedProperty_ = 5;
        } else if (prop == CMProperty.DOCUMENTID) {
            this.cachedProperty_ = 16;
        }
    }

    private boolean propertyIsCached(Object prop) {
        if (prop instanceof CMProperty) {
            return ((CMProperty)prop).isQuickLookupProperty();
        }
        return false;
    }

    @Override
    public void commit() {
        CMCache cache = this.store_.getCache();
        if (this.objectIDs_ != null) {
            ArrayList<String> names = null;
            ArrayList<Integer> locales = null;
            if (this.names_ != null) {
                names = new ArrayList<String>(this.names_.getSize());
                locales = new ArrayList<Integer>(this.names_.getSize());
                int nameCount = this.names_.getSize();
                for (int nameIdx = 0; nameIdx != nameCount; ++nameIdx) {
                    CMDbStoreLocalizedString str = (CMDbStoreLocalizedString)this.names_.get(nameIdx);
                    names.add(str.getValue());
                    locales.add(new Integer(str.getLocaleIDForCache()));
                }
            }
            if (this.storeID_ != null) {
                cache.CMCacheUpdateStoreId(this.objectIDs_[0], this.storeID_);
            }
            for (int i = 0; i < this.objectIDs_.length; ++i) {
                try {
                    if (this.names_ != null) {
                        cache.CMCacheSetAllNames(this.objectIDs_[i], names, locales);
                    } else if (this.name_ != null) {
                        int[] searchLocales;
                        try {
                            searchLocales = CMDbStoreCacheUtil.getCacheSearchLocales();
                        }
                        catch (CMException ex) {
                            searchLocales = new int[]{0};
                        }
                        int defaultNameLocaleId = cache.CMCacheGetDefaultNameLocale(this.objectIDs_[i], searchLocales);
                        if (defaultNameLocaleId >= 0) {
                            CMDbStoreStringLocale locale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale((short)defaultNameLocaleId);
                            CMDbStoreLocalizedString str = new CMDbStoreLocalizedString(locale, this.name_, false, true);
                            cache.CMCacheUpdateStringProperty(this.objectIDs_[i], 0, str.getValue(), str.getLocaleIDForCache());
                        }
                    }
                    if (this.policyUpdated_) {
                        cache.CMCacheUpdateBooleanProperty(this.objectIDs_[i], 4, this.hasPolicies_);
                        CMDbStoreFactory.policyCache_.remove(new Integer(this.objectIDs_[i]));
                    }
                    if (this.UCPoliciesUpdated_) {
                        CMUserCapabilityPoliciesHandler.policyUpdated(new Integer(this.objectIDs_[i]), !this.hasUCPolicies_);
                    }
                    if (this.disabledUpdated_) {
                        cache.CMCacheUpdateIntProperty(this.objectIDs_[i], 6, this.disabled_);
                    }
                    if (this.attachPropsUpdated_ != null) {
                        for (int j = 0; j < this.attachPropsUpdated_.size(); ++j) {
                            CMProperty prop = this.attachPropsUpdated_.get(j);
                            CMDbStoreFactory.tempfileCache_.remove(CMDbStoreFactory.tempfileCache_.getNewTempFileCacheKey(this.objectIDs_[i], prop));
                        }
                    }
                    if (this.hasRecipientsEMailUpdated_) {
                        cache.CMCacheUpdateBooleanProperty(this.objectIDs_[i], 16, this.hasRecipientsEMail_);
                    }
                    if (this.hasRecipientsUpdated_) {
                        cache.CMCacheUpdateBooleanProperty(this.objectIDs_[i], 15, this.hasRecipients_);
                    }
                    if (this.cachedPropertyUpdated_) {
                        cache.CMCacheUpdateCachedProperty(this.objectIDs_[i], this.cachedProperty_, this.cachedPropertyValue_);
                    }
                    if (this.credentialNamespaceUpdated_) {
                        cache.CMCacheUpdateBooleanProperty(this.objectIDs_[i], 9, this.credentialNamespaceSet_);
                    }
                    if (this.formatUpdated_) {
                        cache.CMCacheUpdateIntProperty(this.objectIDs_[i], 12, this.format_);
                    }
                    if (this.localeUpdated_) {
                        int locale = 0;
                        if (this.locale_ != null) {
                            CMDbStoreStringLocale mappedLocale = (CMDbStoreStringLocale)this.locale_.getMappedLocale();
                            locale = this.locale_.getInternalID() | (mappedLocale != null ? mappedLocale.getInternalID() : (short)0) << 16;
                        }
                        cache.CMCacheUpdateIntProperty(this.objectIDs_[i], 11, locale);
                    }
                    if (this.messageUpdated_) {
                        cache.CMCacheUpdateBooleanProperty(this.objectIDs_[i], 13, this.hasMessage_);
                    }
                    if (this.deployedObjectUsageUpdated_) {
                        cache.CMCacheUpdateIntProperty(this.objectIDs_[i], 14, this.deployedObjectUsage_);
                    }
                    if (this.ownerUpdated_) {
                        cache.CMCacheUpdateIntProperty(this.objectIDs_[i], 17, -2);
                    }
                    if (!AdvancedSettings.LAZYOUTPUTFORMATHTMLFIX || !this.hasRecipients_ || !this.formatUpdated_) continue;
                    cache.CMCacheUpdateParentFormat(this.objectIDs_[i], this.format_);
                    continue;
                }
                catch (CMCacheException e) {
                    CMException cmex = new CMException(e, "cmErrUpdateCache");
                    CMIndications.logException(cmex);
                }
            }
            if (this.tenantIDUpdated_) {
                try {
                    this.updateTenantIDs(cache);
                }
                catch (CMCacheException e) {
                    CMException cmex = new CMException(e, "cmErrUpdateCache");
                    CMIndications.logException(cmex);
                }
            }
        }
    }

    private void updateTenantIDs(CMCache cache) throws CMCacheException {
        IntSet set = new IntSet(this.objectIDs_.length);
        for (int cmid : this.objectIDs_) {
            set.add(cmid);
        }
        for (int cmid : set) {
            this.updateTenantIDRecursively(cache, set, cmid);
        }
    }

    private void updateTenantIDRecursively(CMCache cache, IntSet set, int cmid) throws CMCacheException {
        int pcmid = cache.CMCacheGetIntegerProperty(cmid, 5);
        if (set.contains(pcmid)) {
            this.updateTenantIDRecursively(cache, set, pcmid);
        }
        cache.CMCacheUpdateIntProperty(cmid, 18, this.tenantID_);
        set.remove(cmid);
    }

    @Override
    public void rollback() {
        CMCache cache = this.store_.getCache();
        if (this.storeID_ != null) {
            cache.CMCacheReleaseStoreId(this.objectIDs_[0], this.storeID_);
        }
    }
}

