/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.multitenancy.Tenant;
import com.cognos.cm.server.CMException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class CMDbStoreTenantPersistor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadTenants(List<Tenant> tenants) throws CMException {
        int maxTenantId = 0;
        CMDbConnection connection = null;
        Statement stmt = null;
        try {
            connection = CMDbStoreFactory.getAdminConnection();
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("select TENANTID,TENANTNAME from CMTENANTID");
            maxTenantId = this.loadMappings(rs, tenants);
            rs.close();
        }
        catch (SQLException ex) {
            try {
                CMDbStoreExceptionUtil.handleSQLException(connection, ex, "cmStoreUnexpected");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                if (connection != null) {
                    CMDbStoreFactory.releaseConnection(connection);
                }
                throw throwable;
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
            if (connection != null) {
                CMDbStoreFactory.releaseConnection(connection);
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        if (connection != null) {
            CMDbStoreFactory.releaseConnection(connection);
        }
        return maxTenantId;
    }

    protected int loadMappings(ResultSet resultSet, List<Tenant> tenantList) throws SQLException {
        int maxTenantId = 0;
        while (resultSet.next()) {
            int intValue = resultSet.getInt(1);
            String stringValue = resultSet.getString(2);
            if (0 == intValue) {
                stringValue = "";
            }
            if (intValue >= maxTenantId) {
                maxTenantId = intValue + 1;
            }
            Tenant newTenant = new Tenant(stringValue, intValue);
            tenantList.add(newTenant);
        }
        return maxTenantId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTenant(Tenant newTenant) throws CMException {
        CMDbConnection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = CMDbStoreFactory.getConnection();
            stmt = connection.prepareStatement("INSERT INTO CMTENANTID (TENANTID,TENANTNAME) VALUES (?,?)");
            stmt.setString(2, newTenant.getStringId());
            stmt.setInt(1, newTenant.getIntId());
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                CMDbStoreExceptionUtil.handleSQLException(connection, ex, "cmStoreUnexpected");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                if (connection != null) {
                    CMDbStoreFactory.releaseConnection(connection);
                }
                throw throwable;
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
            if (connection != null) {
                CMDbStoreFactory.releaseConnection(connection);
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        if (connection != null) {
            CMDbStoreFactory.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTenant(Integer tenantId) throws CMException {
        CMDbConnection connection = null;
        Statement stmt = null;
        try {
            connection = CMDbStoreFactory.getAdminConnection();
            stmt = connection.createStatement();
            StringBuffer buffer = new StringBuffer();
            buffer.append("delete from CMTENANTID where TENANTID in (");
            buffer.append(tenantId);
            buffer.append(")");
            stmt.executeUpdate(buffer.toString());
        }
        catch (SQLException ex) {
            try {
                CMDbStoreExceptionUtil.handleSQLException(connection, ex, "cmStoreUnexpected");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                if (connection != null) {
                    CMDbStoreFactory.releaseConnection(connection);
                }
                throw throwable;
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
            if (connection != null) {
                CMDbStoreFactory.releaseConnection(connection);
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        if (connection != null) {
            CMDbStoreFactory.releaseConnection(connection);
        }
    }
}

