/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbStoreTenantPersistor;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.multitenancy.MultiTenancyUtils;
import com.cognos.cm.multitenancy.Tenant;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePathFactory;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMQueryUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CMDbStoreTenantRegistry
implements TenantRegistry {
    protected CMDbStoreTenantPersistor persistor;
    protected Map<String, Tenant> stringToTenant;
    protected Map<Integer, Tenant> intToTenant;
    protected int nextIntID;
    private CMStorePathFactory pathFactory;

    protected CMDbStoreTenantRegistry() throws CMException {
        this(new CMDbStoreTenantPersistor(), new CMStorePathFactory());
    }

    protected CMDbStoreTenantRegistry(CMDbStoreTenantPersistor persistor, CMStorePathFactory pathFactory) throws CMException {
        this.persistor = persistor;
        this.pathFactory = pathFactory;
        this.stringToTenant = new HashMap<String, Tenant>();
        this.intToTenant = new HashMap<Integer, Tenant>();
        ArrayList<Tenant> tenants = new ArrayList<Tenant>();
        this.nextIntID = this.persistor.loadTenants(tenants);
        for (Tenant tenant : tenants) {
            this.addTenant(tenant);
        }
    }

    @Override
    public synchronized String getTenantIdStringFromInt(int numericalID) {
        Tenant tenant = this.intToTenant.get(numericalID);
        if (null == tenant) {
            throw new IllegalStateException("Unknown tenantID int: " + numericalID);
        }
        return tenant.getStringId();
    }

    @Override
    public synchronized int getTenantIdIntFromString(String textID, boolean createIfNotExist) throws CMException {
        Tenant tenant;
        if (null == textID) {
            textID = "";
        }
        if (null == (tenant = this.stringToTenant.get(textID = MultiTenancyUtils.normalizeTenantIDString(textID)))) {
            if (createIfNotExist) {
                tenant = this.createNewTenantMapping(textID);
            } else {
                throw new CMException("cmInvalidTenantID", new CMException.Parm("tenantID", textID));
            }
        }
        return tenant.getIntId();
    }

    @Override
    public synchronized int[] getTenantIdsAsIntArray(Collection<String> textIDs, boolean dropNonExistent) throws CMException {
        if (textIDs == null) {
            throw new IllegalArgumentException("textIDs must not be null.");
        }
        if (dropNonExistent) {
            ArrayList<String> mutable = new ArrayList<String>(textIDs);
            for (int i = mutable.size() - 1; i >= 0; --i) {
                if (this.isExistingTenant((String)mutable.get(i))) continue;
                mutable.remove(i);
            }
            textIDs = mutable;
        }
        int[] intIDs = new int[textIDs.size()];
        int index = 0;
        for (String textID : textIDs) {
            intIDs[index++] = this.getTenantIdIntFromString(textID, false);
        }
        return intIDs;
    }

    @Override
    public synchronized Set<String> getTenantIdStrings() {
        return new HashSet<String>(this.stringToTenant.keySet());
    }

    private void addTenant(Tenant tenant) {
        this.stringToTenant.put(tenant.getStringId(), tenant);
        this.intToTenant.put(new Integer(tenant.getIntId()), tenant);
    }

    private Tenant createNewTenantMapping(String textID) throws CMException {
        Tenant newTenant = new Tenant(textID, this.nextIntID);
        this.persistor.addTenant(newTenant);
        this.addTenant(newTenant);
        ++this.nextIntID;
        return newTenant;
    }

    @Override
    public synchronized void deleteTenants(Integer tenantId) throws CMException {
        if (tenantId == null) {
            return;
        }
        this.persistor.deleteTenant(tenantId);
        Tenant tenant = this.intToTenant.remove(tenantId);
        if (tenant != null) {
            this.stringToTenant.remove(tenant.getStringId());
        }
    }

    @Override
    public synchronized int getTenantCount() {
        return this.stringToTenant.size();
    }

    @Override
    public synchronized boolean isExistingTenant(String tenant) {
        return this.stringToTenant.containsKey(tenant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String getTenantObjectDefaultName(CMStore store, String tenantIDStr) {
        String tenantDefaultName;
        block14: {
            ICMLockManager lockMgr;
            CMStoreQueryResults results;
            block13: {
                tenantDefaultName = tenantIDStr;
                results = null;
                lockMgr = store.getLockManager();
                StringBuffer queryPathBuf = new StringBuffer("/directory/tenants/tenant[@tenantID=");
                queryPathBuf.append(CMStoreXPath.attributeQuoteString(tenantIDStr));
                queryPathBuf.append("]");
                CMStoreXPath queryPath = this.pathFactory.createCMStoreXPath(queryPathBuf.toString(), 10);
                CMProperty[] props = new CMProperty[]{CMProperty.DEFAULTNAME};
                lockMgr.requestLocks(queryPath);
                results = store.executeQuery(queryPath, props, null, 0, 512, null);
                if (results.next()) {
                    tenantDefaultName = results.getValue(0).toString();
                }
                if (results == null) break block13;
                CMQueryUtils.safeQueryResultsRelease(results);
            }
            try {
                lockMgr.releaseLocks();
            }
            catch (CMException ex) {
                CMIndications.logException(ex);
            }
            break block14;
            catch (CMException ex) {
                if (results != null) {
                    CMQueryUtils.safeQueryResultsRelease(results);
                }
                try {
                    lockMgr.releaseLocks();
                }
                catch (CMException ex2) {
                    CMIndications.logException(ex2);
                }
                catch (Throwable throwable) {
                    if (results != null) {
                        CMQueryUtils.safeQueryResultsRelease(results);
                    }
                    try {
                        lockMgr.releaseLocks();
                    }
                    catch (CMException ex3) {
                        CMIndications.logException(ex3);
                    }
                    throw throwable;
                }
            }
        }
        return tenantDefaultName;
    }
}

