/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbColumn;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStoreUnexpected;
import java.sql.SQLException;

class CMDbStoreUpdateDef
extends CMDbStoreDMLDef {
    public CMDbStoreUpdateDef(String table) {
        super(table);
    }

    protected boolean addPropertiesToSQL(CMDbConnection con, StringBuffer buffer, boolean prependComma) throws SQLException, CMException {
        CMDbProperty prop;
        int i;
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        boolean bNextPrependComma = prependComma;
        if (CMDbConnection.dbms_ == 2 && CMDbConnection.getDbmsInfo().getIsThinDriver()) {
            for (i = 0; i != this.numProps_; ++i) {
                prop = this.properties_[i];
                CMDbStoreDataSerializer serializer = prop.getDataSerializer();
                Object value = this.values_[i];
                if (!prop.storedAsBlob() || serializer.lobIsNull(value) || prop.isExternalizable()) continue;
                if (this.blobStmts_ == null) {
                    this.blobStmts_ = new Integer[this.numProps_];
                }
                this.blobStmts_[i] = con.storeTempBlob(prop, value);
            }
        }
        for (i = 0; i != this.numProps_; ++i) {
            prop = this.properties_[i];
            int propColumnCount = prop == null ? 0 : prop.columnCount();
            int colCount = propColumnCount;
            for (int colIdx = 0; colIdx != colCount; ++colIdx) {
                CMDbColumn curColumn = prop.getColumn(colIdx);
                if (bNextPrependComma) {
                    buffer.append(sqlGenerator.createColumnsSeparator());
                }
                buffer.append(curColumn.getName());
                if (curColumn.isLob() && this.blobStmts_ != null && this.blobStmts_[i] != null) {
                    CMDbColumn col = prop.getColumn(prop.getLOBColumnIndex());
                    buffer.append(sqlGenerator.createEqualsSql());
                    buffer.append(sqlGenerator.createOpeningBracket());
                    buffer.append(sqlGenerator.createSelectFromCMTMPLOBSSql(col.getDbType()));
                    buffer.append(sqlGenerator.createClosingBracket());
                } else {
                    buffer.append("=?");
                }
                bNextPrependComma = true;
            }
        }
        return bNextPrependComma;
    }

    void execute(CMDbConnection con, int objectID) throws SQLException, CMException, CMStoreUnexpected {
        this.execute(con, null, objectID);
    }

    void execute(CMDbConnection con, String additionToSetClause, int objectID) throws SQLException, CMException, CMStoreUnexpected {
        int[] objectIDs = new int[]{objectID};
        this.execute(con, additionToSetClause, objectIDs);
    }

    void execute(CMDbConnection con, int[] objectIDs) throws SQLException, CMException, CMStoreUnexpected {
        this.execute(con, null, objectIDs);
    }

    void execute(CMDbConnection con, String additionToSetClause, int[] objectIDs) throws SQLException, CMException, CMStoreUnexpected {
        this.execute(con, additionToSetClause, null, objectIDs);
    }

    void execute(CMDbConnection con, String additionToSetClause, String additionToWhereClause, int[] objectIDs) throws SQLException, CMException, CMStoreUnexpected {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        if (objectIDs.length == 0) {
            return;
        }
        StringBuffer beginUpdateStmt = new StringBuffer();
        beginUpdateStmt.append(sqlGenerator.createUpdateFromTableSetSql(this.tableName_));
        int updateSetLength = beginUpdateStmt.length();
        boolean prependComma = false;
        prependComma = this.addPropertiesToSQL(con, beginUpdateStmt, prependComma);
        if (additionToSetClause != null && additionToSetClause.length() > 0) {
            if (prependComma) {
                beginUpdateStmt.append(sqlGenerator.createColumnsSeparator());
            }
            beginUpdateStmt.append(additionToSetClause);
            prependComma = true;
        }
        if (updateSetLength == beginUpdateStmt.length()) {
            return;
        }
        beginUpdateStmt.append(sqlGenerator.createWhereSql());
        if (additionToWhereClause != null && additionToWhereClause.length() > 0) {
            beginUpdateStmt.append(additionToWhereClause);
            beginUpdateStmt.append(sqlGenerator.createAndSql());
        }
        CMExecutionContext.checkCancelOrTimeOut();
        this.executeInGroups(con, beginUpdateStmt.toString(), objectIDs, null);
    }
}

