/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbColumn;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbEnumeration;
import com.cognos.cm.dbstore.CMDbEnumerationSet;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbPropertyDef;
import com.cognos.cm.dbstore.CMDbPropertyDefXMLImpl;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreAddArrayDef;
import com.cognos.cm.dbstore.CMDbStoreAddDef;
import com.cognos.cm.dbstore.CMDbStoreConsistency;
import com.cognos.cm.dbstore.CMDbStoreExecutor;
import com.cognos.cm.dbstore.CMDbStoreMultipleCMsUtil;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreSecurityUtil;
import com.cognos.cm.dbstore.CMDbStoreSplitTransactionUpgrade;
import com.cognos.cm.dbstore.CMDbStoreSysProperties;
import com.cognos.cm.dbstore.CMDbStoreUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreNavigationPathArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.dbstore.properties.CMDbStoreRetentionRule;
import com.cognos.cm.dbstore.properties.CMDbStoreRetentionRuleArray;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.dbstore.properties.CMDbStoreTypedNameValuePairArray;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.properties.CMPropertySets;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.properties.CMRetentionRule;
import com.cognos.cm.properties.CMTypedNameValuePair;
import com.cognos.cm.request.delete;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMDeferredInitActionUtils;
import com.cognos.cm.util.CMIDBasedReferencesUtils;
import com.cognos.cm.util.CMMethodInvoker;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cm.util.CMUpgradeLogXMLGenerator;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.io.CMStreamUtils;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;

public class CMDbStoreUpgrade {
    private static final String ALL_DISTINCT_ORACLE_LOCALES = "select distinct LOCALEID from CMOBJNAMES_BASE union select distinct LOCALEID from CMOBJPROPS3_BASE order by 1";
    private static final String ALL_DISTINCT_MSSQL_LOCALES = "select distinct LOCALEID from CMOBJNAMES union select distinct LOCALEID from CMOBJPROPS3 order by 1";
    private static final String UPDATE_CMOBJNAMES_MSSQL = "update CMOBJNAMES set LOCALEID=? from CMOBJNAMES a where a.LOCALEID=? and ? not in (select b.LOCALEID from CMOBJNAMES b where b.CMID=a.CMID)";
    private static final String UPDATE_CMOBJNAMES_ORACLE = "update CMOBJNAMES_BASE a set a.LOCALEID=? where a.LOCALEID=? and ? not in (select b.LOCALEID from CMOBJNAMES_BASE b where b.CMID=a.CMID)";
    private static final String UPDATE_CMOBJPROPS3_MSSQL = "update CMOBJPROPS3 set LOCALEID=? from CMOBJPROPS3 a where a.LOCALEID=? and ? not in (select b.LOCALEID from CMOBJPROPS3 b where b.CMID=a.CMID)";
    private static final String UPDATE_CMOBJPROPS3_ORACLE = "update CMOBJPROPS3_BASE a set a.LOCALEID=? where a.LOCALEID=? and ? not in (select b.LOCALEID from CMOBJPROPS3_BASE b where b.CMID=a.CMID)";
    private static final String[] MAPPED_LOG_VALUES = new String[]{"minimal", "basic", "basic", "request", "full"};
    private static boolean addedRestartMsg_ = false;

    private static final CMDbProperty parseProperty(Connection con, String propertyDef) throws CMException {
        try {
            return new CMDbProperty(con, propertyDef);
        }
        catch (Exception ex) {
            throw new CMException(ex, "Failed to upgrade property");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void MES() throws CMException, SQLException {
        CMDbStore store = (CMDbStore)CMExecutionContext.get().getStore();
        CMDbConnection con = store.getConnection();
        String sql = CMDbConnection.dbms_ == 2 ? ALL_DISTINCT_ORACLE_LOCALES : ALL_DISTINCT_MSSQL_LOCALES;
        Statement stmt = con.createStatement();
        PreparedStatement updateNames = null;
        PreparedStatement updateOthers = null;
        try {
            con.beginTransaction();
            ResultSet rs = stmt.executeQuery(sql);
            updateNames = con.prepareStatement(CMDbConnection.dbms_ == 2 ? UPDATE_CMOBJNAMES_ORACLE : UPDATE_CMOBJNAMES_MSSQL);
            updateOthers = con.prepareStatement(CMDbConnection.dbms_ == 2 ? UPDATE_CMOBJPROPS3_ORACLE : UPDATE_CMOBJPROPS3_MSSQL);
            while (rs.next()) {
                CMDbStoreStringLocale locale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale((short)rs.getInt(1));
                String mappedLocaleStr = null;
                try {
                    IConfiguration config = ConfigurationFactory.getConfig();
                    mappedLocaleStr = config.mapContentLocale(locale.getLocaleID(), true);
                }
                catch (CMConfigurationException ex) {
                    throw new CMException(ex, "cmUnexpectedError");
                }
                CMDbStoreStringLocale mappedLocale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(mappedLocaleStr);
                if (locale == mappedLocale) continue;
                updateNames.setInt(1, mappedLocale.getInternalID());
                updateNames.setInt(2, locale.getInternalID());
                updateNames.setInt(3, mappedLocale.getInternalID());
                updateNames.executeUpdate();
                updateOthers.setInt(1, mappedLocale.getInternalID());
                updateOthers.setInt(2, locale.getInternalID());
                updateOthers.setInt(3, mappedLocale.getInternalID());
                updateOthers.executeUpdate();
            }
            con.commitTransaction();
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(updateNames);
            CMDbStoreUtil.safeCloseStatement(updateOthers);
            CMDbStoreUtil.safeCloseStatement(stmt);
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(updateNames);
        CMDbStoreUtil.safeCloseStatement(updateOthers);
        CMDbStoreUtil.safeCloseStatement(stmt);
        if (con.inTransaction()) {
            try {
                con.rollbackTransaction();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DefCM() throws CMException, SQLException {
        CMDbStore store = (CMDbStore)CMExecutionContext.get().getStore();
        CMStoreXPath cmServicePath = new CMStoreXPath("/configuration//contentManagerService");
        CMProperty[] properties = new CMProperty[]{CMProperty.DISPATCHERPATH};
        CMStoreQueryResults cmQresults = null;
        CMStoreQueryResults cmServiceResults = null;
        try {
            store.beginTransaction();
            cmServiceResults = store.executeQuery(cmServicePath, null, null, 0, 512, null);
            if (cmServiceResults != null) {
                while (cmServiceResults.next()) {
                    int obj_id = cmServiceResults.getObjectID();
                    int[] objIDs = new int[]{cmServiceResults.getParentObjectID()};
                    cmQresults = store.executeQuery(objIDs, properties, null, 0, 512, null);
                    if (cmQresults == null || !cmQresults.next()) continue;
                    Object valueObject = cmQresults.getValue(0);
                    String dispatcherPathValue = null;
                    if (valueObject != null) {
                        if (valueObject instanceof Reader) {
                            Reader stream = null;
                            stream = (Reader)valueObject;
                            try {
                                dispatcherPathValue = CMStreamUtils.readReaderIntoString((Reader)stream);
                                stream.close();
                                stream = null;
                            }
                            catch (IOException iOException) {
                            }
                            finally {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        } else {
                            dispatcherPathValue = valueObject.toString();
                        }
                    }
                    if (dispatcherPathValue == null) continue;
                    CMDbStoreMultipleCMsUtil.getInstance().makeUniqueDefaultContentManagerService(store.getConnection(), obj_id, dispatcherPathValue);
                }
            }
            store.commitTransaction();
        }
        finally {
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SLI(String tableName, String localeID) throws CMException, SQLException {
        CMDbStore store = (CMDbStore)CMExecutionContext.get().getStore();
        CMDbConnection con = store.getConnection();
        CMDbStoreStringLocale theLocale = localeID == null ? (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(ConfigurationFactory.getConfig().getServerLocale().toString()) : (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(localeID);
        Statement stmt = con.createStatement();
        try {
            stmt.executeUpdate("update " + tableName + " set LOCALEID=" + theLocale.getInternalID());
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
    }

    public static void DELETE(String query2) throws CMException, SQLException {
        CMStoreXPath selectExpr = new CMStoreXPath(query2);
        delete.setClassName();
        delete.deleteObjects(selectExpr, true, true, null, false);
    }

    public static void EN(boolean only3rdParty) throws CMException, SQLException {
        CMStore store = CMExecutionContext.get().getStore();
        CMStoreXPath namespaces = new CMStoreXPath("/directory/namespace");
        CMStoreQueryResults results = null;
        ArrayList<String> namespacesToDelete = new ArrayList<String>();
        try {
            String camID;
            results = store.executeQuery(namespaces, new CMProperty[]{CMProperty.ID}, null, 0, 512, null);
            while (results.next()) {
                Object idValue = results.getValue(0);
                if (idValue == null) continue;
                camID = idValue.toString();
                if (only3rdParty && !CMCAMIDHelper.CAMIDIsExternal(camID)) continue;
                namespacesToDelete.add(camID);
            }
            results.release();
            results = null;
            for (int i = 0; i != namespacesToDelete.size(); ++i) {
                camID = (String)namespacesToDelete.get(i);
                store.beginTransaction();
                CMStoreXPath deletePath = new CMStoreXPath("/directory//*[@id='" + CMStoreXPath.attributeEncodeString(camID, '\'') + "']/descendant::*");
                results = store.executeQuery(deletePath, null, null, 2, 512, null);
                while (results.next()) {
                }
                results.reset();
                store.delete(results, false);
                results.release();
                results = null;
                store.commitTransaction();
            }
        }
        catch (Exception ex) {
            throw new CMConfigurationException((Throwable)ex, "cmDeleteUsersFailed");
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ExecSQL(String sql, String ignoreErrorsString) throws SQLException, CMException {
        CMDbStore store = (CMDbStore)CMExecutionContext.get().getStore();
        CMDbConnection dbCon = store.getConnection();
        Statement stmt = dbCon.createStatement();
        try {
            stmt.execute(sql);
        }
        catch (SQLException ex) {
            if (!ignoreErrorsString.equalsIgnoreCase("ignoreErrors")) {
                throw ex;
            }
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
    }

    public static void WO800() throws CMException, SQLException {
        CMStore store = CMExecutionContext.get().getStore();
        CMStoreXPath objsToExamine = new CMStoreXPath("//*[@objectClass='report' or @objectClass='query' or @objectClass='reportView' or @objectClass='jobDefinition' or @objectClass='importDeployment' or @objectClass='exportDeployment']");
        ArrayList<CMDbStoreString> objSearchPathArray = new ArrayList<CMDbStoreString>();
        ArrayList<CMDbStoreRetentionRuleArray> retentionsArray = new ArrayList<CMDbStoreRetentionRuleArray>();
        CMProperty[] props = new CMProperty[]{CMProperty.RETENTIONS, CMProperty.SEARCHPATH};
        CMStoreQueryResults results = null;
        try {
            results = store.executeQuery(objsToExamine, props, null, 0, 512, null);
            while (results.next()) {
                CMDbStoreRetentionRuleArray rulesIn = (CMDbStoreRetentionRuleArray)results.getValue(0);
                if (rulesIn == null) continue;
                CMDbStoreRetentionRuleArray rulesOut = new CMDbStoreRetentionRuleArray();
                CMDbStoreRetentionRule newRule = null;
                for (int j = 0; j < rulesIn.getSize(); ++j) {
                    CMRetentionRule rule = rulesIn.getRule(j);
                    CMObjectClass objClass = rule.getObjectClass();
                    if (objClass.getName().equalsIgnoreCase("reportHistory") || objClass.getName().equalsIgnoreCase("jobHistory") || objClass.getName().equalsIgnoreCase("deploymentHistory")) {
                        newRule = new CMDbStoreRetentionRule(CMObjectClass.HISTORY, rule.getProperty(), rule.getMaxObjects(), rule.getMaxDuration());
                        rulesOut.add(newRule);
                        continue;
                    }
                    rulesOut.add(rule);
                }
                if (newRule == null) continue;
                CMDbStoreString searchPath = (CMDbStoreString)results.getValue(1);
                objSearchPathArray.add(searchPath);
                retentionsArray.add(rulesOut);
            }
            results.release();
            results = null;
            ArrayList<CMProperty> retentionsProp = new ArrayList<CMProperty>();
            retentionsProp.add(CMProperty.RETENTIONS);
            ArrayList<Object> retentionsValue = new ArrayList<Object>();
            retentionsValue.add(null);
            for (int i = 0; i != objSearchPathArray.size(); ++i) {
                CMDbStoreString searchPath = (CMDbStoreString)objSearchPathArray.get(i);
                store.beginTransaction();
                CMStoreXPath updateObjPath = new CMStoreXPath(searchPath.getValue());
                results = store.executeQuery(updateObjPath, null, null, 7, 512, null);
                while (results.next()) {
                }
                results.reset();
                retentionsValue.set(0, retentionsArray.get(i));
                store.update(results, retentionsProp, retentionsValue);
                results.release();
                results = null;
                store.commitTransaction();
            }
        }
        catch (Exception ex) {
            throw new CMException(ex, "Failed to upgrade property");
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void WO578() throws CMException, SQLException {
        CMStore store = CMExecutionContext.get().getStore();
        CMStoreXPath dispPath = new CMStoreXPath("/configuration//*[@objectClass='dispatcher']");
        CMProperty[] props = new CMProperty[]{CMProperty.SEARCHPATH};
        ArrayList<String> dispPathArray = new ArrayList<String>();
        CMStoreQueryResults results = null;
        try {
            results = store.executeQuery(dispPath, props, null, 0, 512, null);
            if (results == null) {
                return;
            }
            while (results.next()) {
                String searchPath = results.getValue(0).toString();
                dispPathArray.add(searchPath);
            }
            results.release();
            results = null;
            if (dispPathArray.size() > 0) {
                CMObjectClass logService = CMObjectClass.LOGSERVICE;
                CMProperty[] properties = new CMProperty[]{logService.getProperty("lsAuditAdminLevel"), logService.getProperty("lsAuditLevel"), logService.getProperty("lsAuditOtherLevel"), logService.getProperty("lsAuditUsageLevel"), logService.getProperty("lsAuditNativeQuery")};
                CMObjectClass dispatcher = CMObjectClass.DISPATCHER;
                ArrayList<CMProperty> newLevelProps = new ArrayList<CMProperty>();
                newLevelProps.add(dispatcher.getProperty("asAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("brsAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("cmsAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("csAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("dsAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("dispatcherAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("emsAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("jsAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("mdsAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("mmsAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("msAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("psAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("rsAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("ssAuditLevel"));
                newLevelProps.add(dispatcher.getProperty("brsAuditNativeQuery"));
                newLevelProps.add(dispatcher.getProperty("rsAuditNativeQuery"));
                store.beginTransaction();
                for (int i = 0; i != dispPathArray.size(); ++i) {
                    int maxValue = 0;
                    boolean bIsNativeQuery = false;
                    ArrayList<Object> newLevelValues = new ArrayList<Object>();
                    String sPath = (String)dispPathArray.get(i);
                    CMStoreXPath logServicePath = new CMStoreXPath(sPath + "//*[@objectClass='logService']");
                    results = store.executeQuery(logServicePath, properties, null, 0, 512, null);
                    if (results != null) {
                        while (results.next()) {
                            for (int j = 0; j < properties.length - 1; ++j) {
                                if (results.getValue(j) == null) continue;
                                try {
                                    int level = Integer.parseInt(results.getValue(j).toString());
                                    maxValue = Math.max(maxValue, level);
                                    continue;
                                }
                                catch (Exception level) {
                                    // empty catch block
                                }
                            }
                            bIsNativeQuery = bIsNativeQuery || CMXMLUtils.parseBooleanAttribute(results.getValue(properties.length - 1).toString());
                        }
                        results.release();
                    }
                    if (maxValue < true) continue;
                    String valueToSet = MAPPED_LOG_VALUES[maxValue - 1];
                    CMStoreXPath updateObjPath = new CMStoreXPath(sPath);
                    results = store.executeQuery(updateObjPath, null, null, 7, 512, null);
                    while (results.next()) {
                    }
                    results.reset();
                    for (int k = 0; k < 16; ++k) {
                        newLevelValues.add(valueToSet);
                    }
                    newLevelValues.add(16, CMXMLUtils.getBooleanXMLValue(bIsNativeQuery));
                    newLevelValues.add(17, CMXMLUtils.getBooleanXMLValue(bIsNativeQuery));
                    store.update(results, newLevelProps, newLevelValues);
                    results.release();
                    results = null;
                }
                store.commitTransaction();
            }
        }
        catch (Exception ex) {
            throw new CMException(ex, "Failed to upgrade *auditLevel properties");
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrateIDBasedRefs(String oldDefsFile, String newDefsFile, String logFile) throws CMException, SQLException, IOException {
        String startTime = CMDateUtils.getIsoDate();
        String RESOURCE_IDBASEDREFERENCES_OLD_DEF = "/WEB-INF/cm/" + oldDefsFile;
        String RESOURCE_IDBASEDREFERENCES_NEW_DEF = "/WEB-INF/cm/" + newDefsFile;
        CMDbStore store = (CMDbStore)CMExecutionContext.get().getStore();
        CMDbConnection dbCon = store.getConnection();
        Connection con = dbCon.getConnection();
        CMCache cache = store.getCache();
        CMDbStoreStringLocale currLocale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(CMExecutionContext.get().getPreference(CMPreference.CONTENTLOCALE));
        int[] searchPathLocales = new int[]{currLocale.getInternalID()};
        ArrayList oldPropertyDefs = CMDbStoreUpgrade.loadPropertyDefinitionsFromFile(con, RESOURCE_IDBASEDREFERENCES_OLD_DEF, true);
        ArrayList newPropertyDefs = CMDbStoreUpgrade.loadPropertyDefinitionsFromFile(con, RESOURCE_IDBASEDREFERENCES_NEW_DEF, false);
        Statement stmt = null;
        ResultSet rs = null;
        CMStoreQueryResults results = null;
        try {
            stmt = con.createStatement();
            for (int i = 0; i < oldPropertyDefs.size(); ++i) {
                CMDbProperty oldProp = (CMDbProperty)oldPropertyDefs.get(i);
                CMDbProperty newProp = null;
                for (int j = 0; j < newPropertyDefs.size(); ++j) {
                    CMDbProperty nextProp = (CMDbProperty)newPropertyDefs.get(j);
                    if (!nextProp.getName().equalsIgnoreCase(oldProp.getName())) continue;
                    newProp = nextProp;
                    break;
                }
                if (newProp == null) {
                    throw new IllegalStateException("Cannot find new property definition for " + oldProp.getName() + " in " + RESOURCE_IDBASEDREFERENCES_NEW_DEF);
                }
                if (newProp.columnCount() == 0 || oldProp.columnCount() == 0) {
                    throw new IllegalStateException("Cannot migrate property without columns from " + RESOURCE_IDBASEDREFERENCES_NEW_DEF);
                }
                CMDbProperty metadataModelPackageProp = null;
                if (oldProp.getName().equalsIgnoreCase("metadataModel")) {
                    for (int j = 0; j < newPropertyDefs.size(); ++j) {
                        CMDbProperty nextProp = (CMDbProperty)newPropertyDefs.get(j);
                        if (!nextProp.getName().equalsIgnoreCase("metadataModelPackage")) continue;
                        metadataModelPackageProp = nextProp;
                        break;
                    }
                }
                StringBuffer buffer = new StringBuffer();
                CMDbColumn oldColumn = oldProp.getColumn(0);
                if (oldProp.isStoredAsArray()) {
                    buffer.append("select distinct CMID from ");
                    buffer.append(oldColumn.getTable());
                } else {
                    buffer.append("select CMID,");
                    String propertySelect = CMDbStoreUtil.getPropertySelectString(dbCon, "", oldProp, oldColumn.getDbType() == -4, false, false);
                    buffer.append(propertySelect);
                    buffer.append(" from ");
                    buffer.append(oldColumn.getTable());
                    buffer.append(" where ");
                    buffer.append(propertySelect);
                    buffer.append(" is NOT NULL ");
                }
                String oldPropSelect = buffer.toString();
                buffer.setLength(0);
                if (!oldProp.isStoredAsArray()) {
                    buffer.append("update ");
                    buffer.append(oldColumn.getTable());
                    buffer.append(" set ");
                    String propertySelect = CMDbStoreUtil.getPropertySelectString(dbCon, "", oldProp, oldColumn.getDbType() == -4, false, false);
                    buffer.append(propertySelect);
                    buffer.append("=NULL");
                    buffer.append(" where ");
                    buffer.append(propertySelect);
                    buffer.append(" is NOT NULL ");
                }
                String oldPropDelete = buffer.toString();
                store.beginTransaction();
                rs = stmt.executeQuery(oldPropSelect);
                while (rs.next()) {
                    String searchPath = null;
                    int objectID = -1;
                    try {
                        objectID = rs.getInt(1);
                        Object value = null;
                        value = oldProp.isStoredAsArray() ? CMDbStoreUtil.getArray(dbCon, oldProp, objectID) : CMDbStorePropertySerialization.getColumnByProperty(rs, 2, oldProp);
                        if (value == null || !(value instanceof CMArrayPropertyValue)) continue;
                        searchPath = cache.CMCacheGetSearchPath(objectID, searchPathLocales);
                        CMArrayPropertyValue arrayValue = (CMArrayPropertyValue)value;
                        BitSet clearReference = new BitSet(arrayValue.getSize());
                        CMDbStoreBaseClassArray newValueMetadataModelPackage = null;
                        if (oldProp.getName().equalsIgnoreCase("metadataModel")) {
                            newValueMetadataModelPackage = new CMDbStoreBaseClassArray();
                        }
                        ArrayList<? extends CMProperty> subpropertiesAndSelf = newProp.getSubpropertiesAndSelf();
                        for (int subpropertyIdx = 0; subpropertyIdx < subpropertiesAndSelf.size(); ++subpropertyIdx) {
                            Object objectValue;
                            CMDbProperty subProperty = (CMDbProperty)subpropertiesAndSelf.get(subpropertyIdx);
                            if (!subProperty.isStoreIDBased() || !((objectValue = CMIDBasedReferencesUtils.getComplexTypeSubpropertyValue(value)) instanceof CMDbStoreBaseClassArray)) continue;
                            CMDbStoreBaseClassArray subPropertyValue = (CMDbStoreBaseClassArray)objectValue;
                            for (int j = 0; j < subPropertyValue.getSize(); ++j) {
                                CMDbStoreObjectReference reference = (CMDbStoreObjectReference)subPropertyValue.getReference(j);
                                if (reference == null) {
                                    CMException ex = new CMException("cmUpgradeReferenceFailed", new CMException.Parm("Object", searchPath), new CMException.Parm("Property", oldProp.getName()), new CMException.Parm("Reference", "null"));
                                    CMDbStoreUpgrade.logUpgradeException(null, searchPath, oldProp.getName(), ex);
                                    clearReference.set(j);
                                    continue;
                                }
                                if (oldProp.getName().equalsIgnoreCase("metadataModel") && reference.getSearchPath() != null) {
                                    String modelParent = reference.getSearchPath();
                                    int index = modelParent.indexOf("/model[");
                                    modelParent = index != -1 ? modelParent.substring(0, index) : modelParent + "/..";
                                    int modelPackageObjectID = -1;
                                    CMStoreXPath path = new CMStoreXPath(modelParent);
                                    CMStoreQueryResults packageResults = null;
                                    try {
                                        packageResults = store.executeQuery(path, null, null, 0, 33280, null);
                                        if (packageResults != null && packageResults.next()) {
                                            modelPackageObjectID = packageResults.getObjectID();
                                            if (packageResults.next()) {
                                                modelPackageObjectID = -1;
                                            }
                                        }
                                    }
                                    catch (CMException cmex) {
                                        modelPackageObjectID = -1;
                                    }
                                    finally {
                                        if (packageResults != null) {
                                            packageResults.release();
                                        }
                                    }
                                    if (modelPackageObjectID != -1) {
                                        newValueMetadataModelPackage.add(new CMDbStoreObjectReference(modelPackageObjectID, store.getObjectClass(modelPackageObjectID), null));
                                    }
                                }
                                if (reference.getObjectID() >= 0) continue;
                                int refObjectID = -1;
                                String refSearchPath = null;
                                if (oldProp.isRefsSecurity()) {
                                    refSearchPath = reference.toString();
                                    CMStoreXPath objectContext = (CMStoreXPath)CMStoreXPath.parse(refSearchPath);
                                    CMObjectReference objRef = CMCAMIDHelper.normalizeSecurityReference((CMStore)store, objectContext, true, true, false, true);
                                    refObjectID = objRef.getObjectID();
                                } else if (reference.getSearchPath() != null) {
                                    refSearchPath = reference.getSearchPath();
                                    CMStoreXPath path = new CMStoreXPath(refSearchPath);
                                    CMStoreQueryResults refResults = null;
                                    try {
                                        refResults = store.executeQuery(path, null, null, 0, 33280, null);
                                        if (refResults != null && refResults.next()) {
                                            refObjectID = refResults.getObjectID();
                                            if (refResults.next()) {
                                                refObjectID = -1;
                                            }
                                        }
                                    }
                                    catch (CMException cmex) {
                                        refObjectID = -1;
                                    }
                                    finally {
                                        if (refResults != null) {
                                            refResults.release();
                                        }
                                    }
                                }
                                if (refObjectID == -1) {
                                    CMException ex = new CMException("cmUpgradeReferenceFailed", new CMException.Parm("Object", searchPath), new CMException.Parm("Property", oldProp.getName()), new CMException.Parm("Reference", refSearchPath));
                                    CMDbStoreUpgrade.logUpgradeException(null, searchPath, oldProp.getName(), ex);
                                    clearReference.set(j);
                                    continue;
                                }
                                reference.setObjectID(refObjectID);
                            }
                            value = newProp.hasSubproperties() ? CMIDBasedReferencesUtils.mergeComplexType(value, subPropertyValue) : subPropertyValue;
                        }
                        CMArrayPropertyValue newValue = null;
                        if (arrayValue instanceof CMDbStoreBaseClassArray) {
                            newValue = new CMDbStoreBaseClassArray();
                        } else if (arrayValue instanceof CMDbStoreNavigationPathArray) {
                            newValue = new CMDbStoreNavigationPathArray();
                        } else {
                            throw new IllegalStateException("Cannot migrate property of unknown type" + arrayValue.getClass().getName());
                        }
                        for (int k = 0; k < arrayValue.getSize(); ++k) {
                            if (clearReference.get(k)) continue;
                            newValue.add(arrayValue.getItem(k));
                        }
                        ArrayList<CMProperty> props = new ArrayList<CMProperty>();
                        props.add(newProp);
                        ArrayList<Object> newValues = new ArrayList<Object>();
                        newValues.add(newValue);
                        if (oldProp.getName().equalsIgnoreCase("metadataModel") && metadataModelPackageProp != null) {
                            props.add(metadataModelPackageProp);
                            newValues.add(newValueMetadataModelPackage);
                        }
                        CMStoreXPath updateObjPath = new CMStoreXPath(searchPath);
                        results = store.executeQuery(updateObjPath, null, null, 7, 512, null);
                        while (results.next()) {
                        }
                        results.reset();
                        try {
                            store.update(results, props, newValues);
                        }
                        catch (Exception ex1) {
                            CMException ex = new CMException(ex1, "cmUpgradeReferenceFailed", new CMException.Parm("Object", searchPath), new CMException.Parm("Property", oldProp.getName()));
                            CMDbStoreUpgrade.logUpgradeException(results.getObjectClass().getName(), searchPath, oldProp.getName(), ex);
                        }
                        results.release();
                        results = null;
                    }
                    catch (Exception cex) {
                        String sPath = searchPath == null ? new Integer(objectID).toString() : searchPath;
                        CMException ex = new CMException(cex, "cmUpgradeReferenceFailed", new CMException.Parm("Object", sPath), new CMException.Parm("Property", oldProp.getName()));
                        CMDbStoreUpgrade.logUpgradeException(null, sPath, oldProp.getName(), ex);
                    }
                }
                store.commitTransaction();
                if (!oldProp.getName().equalsIgnoreCase("paths") && !oldProp.isStoredAsArray()) {
                    store.beginTransaction();
                    stmt.executeUpdate(oldPropDelete);
                    store.commitTransaction();
                }
                rs.close();
                rs = null;
            }
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
            if (results != null) {
                results.release();
            }
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception i) {}
            }
        }
        String endTime = CMDateUtils.getIsoDate();
        if (CMUpgradeLogXMLGenerator.hasLogs()) {
            CMUpgradeLogXMLGenerator.addDBUpgradeElement(startTime, endTime);
            File upgradeLogFile = new File(CMServlet.logsDir_, "upgradeLog.xml");
            try {
                CMUpgradeLogXMLGenerator.dumpLogAsXML(upgradeLogFile, false);
            }
            catch (Throwable ex) {
                CMException cmEx = new CMException(ex, "cmErrUpgradeLogFile", new CMException.Parm("PATH", upgradeLogFile.getAbsolutePath()));
                CMIndications.logException(cmEx);
            }
        }
    }

    public static void RunCMUpgradeScript(String scriptName) throws CMException {
        CMServlet.executeInitScript(scriptName);
    }

    public static void logUpgradeException(String objectClass, String searchPath, String propertyName, CMException ex) {
        String message = ex.getFullMessage();
        CMUpgradeLogXMLGenerator.addErrorElement("dataError", objectClass, propertyName, searchPath, message, null);
    }

    public static ArrayList loadPropertyDefinitionsFromFile(Connection con, String fileResourceName, boolean ignorePropertyCreationErrors) throws CMConfigurationException {
        ArrayList<CMDbProperty> propertyDefs = new ArrayList<CMDbProperty>();
        CMResourceLoader resourceLoader = CMResourceUtils.getResourceLoader();
        InputStream is = resourceLoader.getResourceInputStream(fileResourceName);
        if (is == null) {
            throw new CMConfigurationException("cmNoConfigFile", new CMException.Parm("Resource", fileResourceName));
        }
        try {
            CMDbPropertyDef el;
            String xml = new String(CMStreamUtils.readInputStreamIntoByteArray((InputStream)is), "UTF-8");
            CMDbPropertyDefXMLImpl root = new CMDbPropertyDefXMLImpl(xml);
            CMDbEnumerationSet enums = new CMDbEnumerationSet();
            Iterator<CMDbPropertyDef> it = root.getSubpropertyIterator("enumeration");
            while (it.hasNext()) {
                el = it.next();
                enums.add(new CMDbEnumeration(el));
            }
            it = root.getSubpropertyIterator("property");
            while (it.hasNext()) {
                el = it.next();
                try {
                    CMDbProperty prop = new CMDbProperty(con, el, enums, false);
                    propertyDefs.add(prop);
                }
                catch (SQLException ex) {
                    if (ignorePropertyCreationErrors) continue;
                    throw ex;
                }
                catch (CMConfigurationException ex) {
                    if (ignorePropertyCreationErrors) continue;
                    throw ex;
                }
            }
            return propertyDefs;
        }
        catch (Exception ex) {
            throw new CMConfigurationException((Throwable)ex, "cmNoConfigFile", new CMException.Parm("Resource", fileResourceName));
        }
    }

    public static void WO730_MoveDeploymentFolders() throws CMException, SQLException {
        CMDbStoreUpgrade.doQuickMove("/adminFolder[@name!='Administration']", "/adminFolder[@name='Administration']");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doQuickMove(String source, String target) throws CMException, SQLException {
        block25: {
            Statement updateStmt;
            CMDbConnection dbCon;
            CMCacheQueryInstance sourceQuery;
            block24: {
                CMCacheQueryInstance targetQuery = null;
                sourceQuery = null;
                StringBuffer sourceObjIDs = new StringBuffer();
                dbCon = null;
                updateStmt = null;
                CMStoreXPath targetPath = new CMStoreXPath(target);
                CMStoreXPath objsToMove = new CMStoreXPath(source);
                CMDbStore store = (CMDbStore)CMExecutionContext.get().getStore();
                dbCon = store.getConnection();
                CMCache cache = store.getCache();
                try {
                    targetQuery = cache.executeAdminQuery(targetPath, 0);
                    int[] targetObject = targetQuery.resultObjects();
                    sourceQuery = cache.executeAdminQuery(objsToMove, 0);
                    int[] sourceObjects = sourceQuery.resultObjects();
                    if (targetObject.length < 1) {
                        throw new CMException("cmBadTargetNotFound", new CMException.Parm("Path", CMQueryUtils.getPath((CMStore)store, targetPath)));
                    }
                    if (targetObject.length > 1) {
                        throw new CMException("cmBadTargetSelectionMany", new CMException.Parm("Path", CMQueryUtils.getPath((CMStore)store, targetPath)));
                    }
                    if (sourceObjects.length < 1) {
                        return;
                    }
                    for (int i = 0; i < sourceObjects.length; ++i) {
                        cache.CMCacheUpdateIntProperty(sourceObjects[i], 5, targetObject[0]);
                        if (sourceObjIDs.length() > 0) {
                            sourceObjIDs.append(", ");
                        }
                        sourceObjIDs.append(sourceObjects[i]);
                    }
                    String updateParentSQL = "update CMOBJECTS set PCMID = " + targetObject[0] + " where CMID in ( " + sourceObjIDs.toString() + " )";
                    dbCon = store.getConnection();
                    updateStmt = dbCon.createStatement();
                    dbCon.beginTransaction();
                    updateStmt.execute(updateParentSQL);
                    dbCon.commitTransaction();
                    if (targetQuery == null) break block24;
                }
                catch (CMCacheAccessDenied ex) {
                    CMDbStoreSecurityUtil.convertAccessDeniedException(cache, ex);
                    break block25;
                }
                finally {
                    if (targetQuery != null) {
                        targetQuery.release();
                    }
                    if (sourceQuery != null) {
                        sourceQuery.release();
                    }
                    CMDbStoreUtil.safeCloseStatement(updateStmt);
                    if (dbCon != null && dbCon.inTransaction()) {
                        try {
                            dbCon.rollbackTransaction();
                        }
                        catch (Exception exception) {}
                    }
                }
                targetQuery.release();
            }
            if (sourceQuery != null) {
                sourceQuery.release();
            }
            CMDbStoreUtil.safeCloseStatement(updateStmt);
            if (dbCon != null && dbCon.inTransaction()) {
                try {
                    dbCon.rollbackTransaction();
                }
                catch (Exception targetObject) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPackageUserInterfaces() throws CMException, SQLException, IOException {
        CMObjectClass packageClass;
        CMDbStore store = (CMDbStore)CMExecutionContext.get().getStore();
        CMStoreQueryResults results = null;
        CMPropertySets propSets = store.getPropertySets();
        CMPropertySet propSet = propSets.getPropertySet();
        CMDbProperty userInterfacesProp = (CMDbProperty)propSet.getProperty("userInterfaces", packageClass = CMObjectClass.PACKAGE);
        if (userInterfacesProp == null) {
            throw new IllegalStateException("Cannot find userInterfaces property");
        }
        try {
            ArrayList<CMProperty> props = new ArrayList<CMProperty>();
            props.add(userInterfacesProp);
            ArrayList<Object> newValues = new ArrayList<Object>();
            CMDbStoreStringArray newValue = new CMDbStoreStringArray();
            newValue.add(new String("eventStudio"));
            newValue.add(new String("queryStudio"));
            newValue.add(new String("reportStudio"));
            newValues.add(newValue);
            String searchPath = new String("/content/package");
            CMStoreXPath updateObjPath = new CMStoreXPath(searchPath);
            CMProperty[] properties = new CMProperty[]{userInterfacesProp, CMProperty.SEARCHPATH};
            ArrayList<Object> nullUserInterfacesObjects = new ArrayList<Object>();
            results = store.executeQuery(updateObjPath, properties, null, 0, 512, null);
            while (results.next()) {
                CMDbStoreStringArray value = (CMDbStoreStringArray)results.getValue(0);
                if (value != null) continue;
                nullUserInterfacesObjects.add(results.getValue(1));
            }
            results.release();
            results = null;
            store.beginTransaction();
            for (int i = 0; i < nullUserInterfacesObjects.size(); ++i) {
                CMStoreXPath nullObjPath = new CMStoreXPath((String)nullUserInterfacesObjects.get(i));
                results = store.executeQuery(nullObjPath, null, null, 7, 512, null);
                while (results.next()) {
                }
                results.reset();
                store.update(results, props, newValues);
                results.release();
                results = null;
            }
            store.commitTransaction();
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    static class SplitTransaction
    implements CMDbStoreExecutor {
        private CMDbStoreSplitTransactionUpgrade splitTransaction = new CMDbStoreSplitTransactionUpgrade();

        SplitTransaction() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            CMDbStoreSysProperties.initializeSysPropTable(con);
            return this.splitTransaction.execute(new CMDbConnection(con, true), args);
        }
    }

    static class ReinitializeCM
    implements CMDbStoreExecutor {
        ReinitializeCM() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            boolean deferred;
            if (args.length <= 0 || !(deferred = args[0].equals("_deferred"))) {
                // empty if block
            }
            if (!addedRestartMsg_) {
                CMServlet.addInitializationMsg(new CMException("cmRequiresRestartToCompleteUpgrade"));
                addedRestartMsg_ = true;
            }
            return true;
        }
    }

    static class AddUserInterfaces
    implements CMDbStoreExecutor {
        AddUserInterfaces() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreUpgrade.class.getDeclaredMethod("addPackageUserInterfaces", null), null), "POSTINITACTIONS", actionName);
            }
            catch (Exception ex) {
                throw new CMException(ex, "AddUserInterfaces failed");
            }
            return false;
        }
    }

    static class MigrateJSMPropertyValues
    implements CMDbStoreExecutor {
        MigrateJSMPropertyValues() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            String[] jsmPropColumns = new String[]{"NONPEAKBEGINHOUR", "PEAKBEGINHOUR", "NONPEAKMAXJOBS", "PEAKMAXJOBS"};
            String[] msPropColumns = new String[]{"NEWNONPEAKBEGINHOUR", "NEWPEAKBEGINHOUR", "NEWNONPEAKMAXJOBS", "NEWPEAKMAXJOBS"};
            for (int i = 0; i < jsmPropColumns.length; ++i) {
                String sqlGetNonNullJSMValue = "select p1.CMID, o.PCMID, o.CLASSID, p1." + jsmPropColumns[i] + " from CMOBJPROPS17 p1 left outer join CMOBJECTS o on o.CMID=p1.CMID where p1." + jsmPropColumns[i] + " is not null and o.CLASSID in (4,34,14,67) order by o.CLASSID";
                String sqlUpdateRelatedMSProp = "update CMOBJPROPS17 set " + msPropColumns[i] + " = ? where CMID = ?";
                Statement read = null;
                PreparedStatement update2 = null;
                try {
                    read = con.createStatement();
                    update2 = con.prepareStatement(sqlUpdateRelatedMSProp);
                    ResultSet rs = read.executeQuery(sqlGetNonNullJSMValue);
                    while (rs.next()) {
                        int classId = rs.getInt(3);
                        int objId = -1;
                        objId = classId == 67 ? rs.getInt(2) : rs.getInt(1);
                        if (objId <= -1) continue;
                        update2.setInt(1, rs.getInt(4));
                        update2.setInt(2, objId);
                        update2.executeUpdate();
                    }
                }
                catch (Throwable throwable) {
                    CMDbStoreUtil.safeCloseStatement(read);
                    CMDbStoreUtil.safeCloseStatement(update2);
                    throw throwable;
                }
                CMDbStoreUtil.safeCloseStatement(read);
                CMDbStoreUtil.safeCloseStatement(update2);
            }
            return true;
        }
    }

    static class MigratePropertyStorage
    implements CMDbStoreExecutor {
        MigratePropertyStorage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            if (args.length != 2) {
                throw new IllegalStateException("Invalid number of arguments to MigratePropertyStorage");
            }
            String oldPropertyDefinition = args[0];
            String newPropertyDefinition = args[1];
            CMDbProperty oldProperty = null;
            try {
                oldProperty = CMDbStoreUpgrade.parseProperty(con, oldPropertyDefinition);
            }
            catch (CMException ex) {
                if (ex.getException() instanceof CMConfigurationException) {
                    return true;
                }
                throw ex;
            }
            CMDbProperty newProperty = CMDbStoreUpgrade.parseProperty(con, newPropertyDefinition);
            if (oldProperty.columnCount() < 1 || newProperty.columnCount() < 1) {
                throw new IllegalStateException("Cannot convert from/to property with 0 columns in MigratePropertyStorage.");
            }
            StringBuffer selectOldProperty = new StringBuffer();
            selectOldProperty.append("select CMID");
            for (int i = 0; i < oldProperty.columnCount(); ++i) {
                selectOldProperty.append(",");
                selectOldProperty.append(oldProperty.getColumn(0).getName());
            }
            selectOldProperty.append(" from ");
            selectOldProperty.append(oldProperty.getColumn(0).getTable());
            Statement stmt = null;
            CMDbConnection dbCon = new CMDbConnection(con, true);
            ResultSet rs = null;
            try {
                stmt = con.createStatement();
                dbCon.beginTransaction();
                rs = stmt.executeQuery(selectOldProperty.toString());
                while (rs.next()) {
                    int objectID = rs.getInt(1);
                    Object value = CMDbStorePropertySerialization.getColumnByProperty(rs, 2, oldProperty);
                    if (value == null) continue;
                    if (newProperty.isEnumeration() && value instanceof CMDbStoreStringArray) {
                        boolean bValid = true;
                        CMDbStoreStringArray stringArray = (CMDbStoreStringArray)value;
                        for (int i = 0; i < stringArray.getSize(); ++i) {
                            String element = stringArray.getString(i);
                            if (newProperty.isValidEnumValue(null, element)) continue;
                            CMIndications.logException(new CMException((Exception)new CMException("cmBadPropValue", new CMException.Parm("Value", element)), "cmBadPropertyData", new CMException.Parm("Property", newProperty.getName())));
                            bValid = false;
                        }
                        if (!bValid) continue;
                    }
                    CMDbStoreAddArrayDef addDef = new CMDbStoreAddArrayDef(newProperty.getColumn(0).getTable());
                    addDef.addColumn(newProperty, value);
                    ((CMDbStoreAddDef)addDef).execute(dbCon, objectID);
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
                stmt = null;
                rs.close();
                rs = null;
                dbCon.commitTransaction();
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(stmt);
                if (rs != null) {
                    try {
                        rs.close();
                        rs = null;
                    }
                    catch (SQLException sQLException) {}
                }
                if (dbCon.inTransaction()) {
                    try {
                        dbCon.rollbackTransaction();
                    }
                    catch (Exception exception) {}
                }
            }
            return true;
        }
    }

    static class MoveDeploymentFolders
    implements CMDbStoreExecutor {
        MoveDeploymentFolders() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreUpgrade.class.getDeclaredMethod("WO730_MoveDeploymentFolders", null), null), "CMUPGRADESCRIPT", actionName);
            }
            catch (Exception ex) {
                throw new CMException(ex, "MoveDeploymentFolders failed");
            }
            return false;
        }
    }

    static class AddStoreIds
    implements CMDbStoreExecutor {
        private static final String sqlSelect = "select CMID from CMOBJECTS";
        private static final String sqlInsert = "insert into CMSTOREIDS(CMID, STOREID) values (?, ?)";
        private static final String sqlValidate = "select a.CMID from CMSTOREIDS a, CMSTOREIDS b where a.STOREID = b.STOREID and a.CMID <> b.CMID";
        private static final String sqlUpdate = "update CMSTOREIDS set STOREID=? where CMID=?";

        AddStoreIds() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            String storeId;
            int objectID;
            CMDbConnection dbCon = new CMDbConnection(con, true);
            ResultSet rs = null;
            Statement stmt = null;
            PreparedStatement prepStmt = null;
            try {
                stmt = con.createStatement();
                prepStmt = con.prepareStatement(sqlInsert);
                rs = stmt.executeQuery(sqlSelect);
                int transCount = 0;
                dbCon.beginTransaction();
                while (rs.next()) {
                    objectID = rs.getInt(1);
                    storeId = CMDbStore.generateStoreId();
                    try {
                        prepStmt.setInt(1, objectID);
                        prepStmt.setString(2, storeId);
                        prepStmt.execute();
                    }
                    catch (SQLException ex) {
                        if (CMDbConnection.isConstraintViolation(ex)) continue;
                        throw ex;
                    }
                    if (transCount++ != 100) continue;
                    dbCon.commitTransaction();
                    dbCon.beginTransaction();
                    transCount = 0;
                }
                dbCon.commitTransaction();
            }
            finally {
                if (dbCon.inTransaction()) {
                    dbCon.rollbackTransaction();
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
                CMDbStoreUtil.safeCloseStatement(prepStmt);
                stmt = null;
                prepStmt = null;
            }
            try {
                stmt = con.createStatement();
                prepStmt = con.prepareStatement(sqlUpdate);
                boolean hasDuplicates = true;
                while (hasDuplicates) {
                    hasDuplicates = false;
                    dbCon.beginTransaction();
                    rs = stmt.executeQuery(sqlValidate);
                    while (rs.next()) {
                        hasDuplicates = true;
                        objectID = rs.getInt(1);
                        storeId = CMDbStore.generateStoreId();
                        prepStmt.setString(1, storeId);
                        prepStmt.setInt(2, objectID);
                        prepStmt.execute();
                    }
                    dbCon.commitTransaction();
                }
            }
            finally {
                if (dbCon.inTransaction()) {
                    dbCon.rollbackTransaction();
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
                CMDbStoreUtil.safeCloseStatement(prepStmt);
            }
            return true;
        }
    }

    static class MigrateIDBasedReferences
    implements CMDbStoreExecutor {
        MigrateIDBasedReferences() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            if (args.length != 3) {
                throw new IllegalStateException("Cannot find property definition files");
            }
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreUpgrade.class.getDeclaredMethod("migrateIDBasedRefs", String.class, String.class, String.class), args), "POSTINITACTIONS", actionName);
            }
            catch (Exception ex) {
                throw new CMException(ex, "MigrateIDBasedReferences failed");
            }
            return false;
        }
    }

    static class MigrateOptions
    implements CMDbStoreExecutor {
        private static final String RESOURCE_OPTIONS_DEF = "/WEB-INF/cm/optionsDef.xml";
        private static final String runOptSelect = "select distinct p19.CMID from CMOBJPROPS19 p19 inner join CMOBJPROPS26 p26 on p19.CMID = p26.CMID where p26.DELIVOPTIONS is NULL";
        private static final String deplOptSelect = "select p7.CMID, p7.DEPLOYOPTIONS from CMOBJPROPS7 p7 inner join CMOBJPROPS26 p26 on p7.CMID = p26.CMID where p26.DELIVOPTIONS is NULL";

        MigrateOptions() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            CMDbProperty runOptProp = null;
            CMDbProperty deplOptProp = null;
            CMDbProperty optionsProp = null;
            ArrayList propertyDefs = CMDbStoreUpgrade.loadPropertyDefinitionsFromFile(con, RESOURCE_OPTIONS_DEF, false);
            for (int i = 0; i < propertyDefs.size(); ++i) {
                CMDbProperty prop = (CMDbProperty)propertyDefs.get(i);
                if (prop.getName().equals("runOptions")) {
                    runOptProp = prop;
                    continue;
                }
                if (prop.getName().equals("deploymentOptions")) {
                    deplOptProp = prop;
                    continue;
                }
                if (!prop.getName().equals("options")) continue;
                optionsProp = prop;
            }
            if (runOptProp == null || deplOptProp == null || optionsProp == null) {
                throw new CMConfigurationException("cmNoConfigFile", new CMException.Parm("Resource", RESOURCE_OPTIONS_DEF));
            }
            Statement stmt = null;
            CMDbConnection dbCon = new CMDbConnection(con, true);
            ResultSet rs = null;
            try {
                CMDbStoreUpdateDef updateDef;
                CMTypedNameValuePair pair;
                CMDbStoreTypedNameValuePairArray newValue;
                CMDbStoreTypedNameValuePairArray oldValue;
                Object value;
                int objectID;
                stmt = con.createStatement();
                dbCon.beginTransaction();
                rs = stmt.executeQuery(runOptSelect);
                while (rs.next()) {
                    objectID = rs.getInt(1);
                    value = CMDbStoreUtil.getArray(dbCon, runOptProp, objectID);
                    if (value == null) continue;
                    oldValue = (CMDbStoreTypedNameValuePairArray)value;
                    newValue = new CMDbStoreTypedNameValuePairArray();
                    for (int i = 0; i < oldValue.getSize(); ++i) {
                        pair = oldValue.getPair(i);
                        newValue.add(pair.getName(), "runOptionEnum", pair.getValue(), pair.getTypeName());
                    }
                    updateDef = new CMDbStoreUpdateDef("CMOBJPROPS26");
                    updateDef.addColumn(optionsProp, newValue);
                    updateDef.execute(dbCon, objectID);
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
                stmt = null;
                rs.close();
                rs = null;
                dbCon.commitTransaction();
                stmt = con.createStatement();
                rs = stmt.executeQuery(deplOptSelect);
                dbCon.beginTransaction();
                while (rs.next()) {
                    objectID = rs.getInt(1);
                    value = CMDbStorePropertySerialization.getColumnByProperty(rs, 2, deplOptProp);
                    if (value == null) continue;
                    oldValue = (CMDbStoreTypedNameValuePairArray)value;
                    newValue = new CMDbStoreTypedNameValuePairArray();
                    for (int i = 0; i < oldValue.getSize(); ++i) {
                        pair = oldValue.getPair(i);
                        newValue.add(pair.getName(), "deploymentOptionEnum", pair.getValue(), pair.getTypeName());
                    }
                    updateDef = new CMDbStoreUpdateDef("CMOBJPROPS26");
                    updateDef.addColumn(optionsProp, newValue);
                    updateDef.execute(dbCon, objectID);
                }
                dbCon.commitTransaction();
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(stmt);
                if (rs != null) {
                    try {
                        rs.close();
                        rs = null;
                    }
                    catch (SQLException sQLException) {}
                }
                if (dbCon.inTransaction()) {
                    try {
                        dbCon.rollbackTransaction();
                    }
                    catch (Exception exception) {}
                }
            }
            return true;
        }
    }

    static class MigrateRetentionsForHistory
    implements CMDbStoreExecutor {
        MigrateRetentionsForHistory() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreUpgrade.class.getDeclaredMethod("WO800", null), null), "POSTINITACTIONS", actionName);
            }
            catch (Exception ex) {
                throw new CMException(ex, "MigrateRetentions failed");
            }
            return false;
        }
    }

    static class PopulateDistributionListCMInteralObjID
    implements CMDbStoreExecutor {
        PopulateDistributionListCMInteralObjID() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            String sqlGetCreationTime = "select CMID, CREATED from CMOBJECTS where CLASSID in (15) and CMID in (select CMID from CMOBJPROPS1 where OBJID IS NULL)";
            String sqlUpdate = "update CMOBJPROPS1 set OBJID=? where CMID=?";
            Statement sqlGetStmt = null;
            PreparedStatement sqlUpdateStmt = null;
            ResultSet rs = null;
            int cmid = -1;
            Timestamp ts = null;
            CMDbConnection dbCon = new CMDbConnection(con, true);
            try {
                dbCon.beginTransaction();
                sqlGetStmt = con.createStatement();
                rs = sqlGetStmt.executeQuery(sqlGetCreationTime);
                sqlUpdateStmt = con.prepareStatement(sqlUpdate);
                while (rs.next()) {
                    cmid = rs.getInt(1);
                    ts = rs.getTimestamp(2);
                    long time = ts.getTime() / 1000L * 1000L;
                    CMDbStore store = (CMDbStore)CMExecutionContext.get().getStore();
                    String camID = store.getCache().CMCacheGetInternalCAMID(cmid, time);
                    sqlUpdateStmt.setString(1, camID);
                    sqlUpdateStmt.setInt(2, cmid);
                    sqlUpdateStmt.execute();
                }
                dbCon.commitTransaction();
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(sqlGetStmt);
                CMDbStoreUtil.safeCloseStatement(sqlUpdateStmt);
                if (dbCon.inTransaction()) {
                    try {
                        dbCon.rollbackTransaction();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            CMDbStoreUtil.safeCloseStatement(sqlGetStmt);
            CMDbStoreUtil.safeCloseStatement(sqlUpdateStmt);
            if (dbCon.inTransaction()) {
                try {
                    dbCon.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
            return true;
        }
    }

    static class PopulateCMInteralObjID
    implements CMDbStoreExecutor {
        PopulateCMInteralObjID() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            String sqlGetCreationTime = "select CMID, CREATED from CMOBJECTS where CLASSID in (11,15,54,26) and CMID in (select CMID from CMOBJPROPS1 where OBJID IS NULL)";
            String sqlUpdate = "update CMOBJPROPS1 set OBJID=? where CMID=?";
            Statement sqlGetStmt = null;
            PreparedStatement sqlUpdateStmt = null;
            ResultSet rs = null;
            int cmid = -1;
            Timestamp ts = null;
            CMDbConnection dbCon = new CMDbConnection(con, true);
            try {
                dbCon.beginTransaction();
                sqlGetStmt = con.createStatement();
                rs = sqlGetStmt.executeQuery(sqlGetCreationTime);
                sqlUpdateStmt = con.prepareStatement(sqlUpdate);
                while (rs.next()) {
                    cmid = rs.getInt(1);
                    ts = rs.getTimestamp(2);
                    long time = ts.getTime() / 1000L * 1000L;
                    CMDbStore store = (CMDbStore)CMExecutionContext.get().getStore();
                    String camID = store.getCache().CMCacheGetInternalCAMID(cmid, time);
                    sqlUpdateStmt.setString(1, camID);
                    sqlUpdateStmt.setInt(2, cmid);
                    sqlUpdateStmt.execute();
                }
                dbCon.commitTransaction();
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(sqlGetStmt);
                CMDbStoreUtil.safeCloseStatement(sqlUpdateStmt);
                if (dbCon.inTransaction()) {
                    try {
                        dbCon.rollbackTransaction();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            CMDbStoreUtil.safeCloseStatement(sqlGetStmt);
            CMDbStoreUtil.safeCloseStatement(sqlUpdateStmt);
            if (dbCon.inTransaction()) {
                try {
                    dbCon.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
            return true;
        }
    }

    static class PopulateDefaultActiveCM
    implements CMDbStoreExecutor {
        PopulateDefaultActiveCM() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            if (args.length > 0) {
                try {
                    CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreUpgrade.class.getDeclaredMethod("DefCM", null), null), "POSTINITACTIONS", actionName);
                }
                catch (Exception ex) {
                    throw new CMException(ex, "PopulateDefaultActiveCM failed");
                }
            }
            return false;
        }
    }

    static class PopulateCMCAPACITY
    implements CMDbStoreExecutor {
        PopulateCMCAPACITY() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            block16: {
                block15: {
                    sqlGetDispatcher = "select o.CMID, p6.DISPATCHERPATH, p11.CAPACITY  from CMOBJECTS o, CMOBJPROPS6 p6, CMOBJPROPS11 p11 where o.CMID=p6.CMID and o.CMID=p11.CMID and o.CMID in (select PCMID from CMOBJECTS where CLASSID=47)";
                    sqlGetParentCapacity = "select o.CMID, p11.CAPACITY  from CMOBJECTS o, CMOBJPROPS11 p11 where o.CMID=p11.CMID and o.CMID in (select PCMID from CMOBJECTS where CMID=?)";
                    sqlInsertCapacity = "insert into CMCAPACITY(PATH, CAPACITY, USAGE) values (?, ?, ?)";
                    getDispatcherStmt = null;
                    getCapacityStmt = null;
                    insertCapacityStmt = null;
                    rs = null;
                    dbCon = new CMDbConnection(con, true);
                    hasCapacity = false;
                    capacity = 0.0f;
                    dispatcherPath = null;
                    cmid = -1;
                    objectExists = false;
                    dbCon.beginTransaction();
                    getDispatcherStmt = con.createStatement();
                    rs = getDispatcherStmt.executeQuery(sqlGetDispatcher);
                    if (!rs.next()) ** GOTO lbl38
                    cmid = rs.getInt(1);
                    dispatcherPath = rs.getString(2);
                    if (!rs.wasNull()) break block15;
                    var17_17 = true;
                    CMDbStoreUtil.safeCloseStatement(getDispatcherStmt);
                    CMDbStoreUtil.safeCloseStatement(getCapacityStmt);
                    CMDbStoreUtil.safeCloseStatement(insertCapacityStmt);
                    if (dbCon.inTransaction()) {
                        try {
                            dbCon.rollbackTransaction();
                        }
                        catch (Exception var18_20) {
                            // empty catch block
                        }
                    }
                    return var17_17;
                }
                try {
                    objectExists = true;
                    capacity = rs.getFloat(3);
                    hasCapacity = rs.wasNull() == false;
lbl38:
                    // 2 sources

                    CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
                    rs = null;
                    getDispatcherStmt = null;
                    if (!hasCapacity && objectExists) {
                        getCapacityStmt = con.prepareStatement(sqlGetParentCapacity);
                    }
                    while (!hasCapacity && objectExists) {
                        objectExists = false;
                        getCapacityStmt.setInt(1, cmid);
                        rs = getCapacityStmt.executeQuery();
                        if (!rs.next()) continue;
                        objectExists = true;
                        cmid = rs.getInt(1);
                        capacity = rs.getFloat(2);
                        hasCapacity = rs.wasNull() == false;
                    }
                    if (hasCapacity && objectExists) {
                        insertCapacityStmt = con.prepareStatement(sqlInsertCapacity);
                        insertCapacityStmt.setString(1, dispatcherPath);
                        insertCapacityStmt.setFloat(2, capacity);
                        usage = 1;
                        insertCapacityStmt.setShort(3, usage);
                        insertCapacityStmt.executeUpdate();
                        dbCon.commitTransaction();
                        break block16;
                    }
                    dbCon.rollbackTransaction();
                }
                catch (Throwable var19_21) {
                    CMDbStoreUtil.safeCloseStatement(getDispatcherStmt);
                    CMDbStoreUtil.safeCloseStatement(getCapacityStmt);
                    CMDbStoreUtil.safeCloseStatement(insertCapacityStmt);
                    if (dbCon.inTransaction()) {
                        try {
                            dbCon.rollbackTransaction();
                        }
                        catch (Exception var20_22) {
                            // empty catch block
                        }
                    }
                    throw var19_21;
                }
            }
            CMDbStoreUtil.safeCloseStatement(getDispatcherStmt);
            CMDbStoreUtil.safeCloseStatement(getCapacityStmt);
            CMDbStoreUtil.safeCloseStatement(insertCapacityStmt);
            if (dbCon.inTransaction()) {
                try {
                    dbCon.rollbackTransaction();
                }
                catch (Exception var17_19) {}
            }
            return true;
        }
    }

    static class IfTableExists
    implements CMDbStoreExecutor {
        IfTableExists() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            if (args.length < 3) {
                throw new IllegalStateException("Invalid number of arguments to IfTableExists");
            }
            if (!args[0].equalsIgnoreCase("TRUE") && !args[0].equalsIgnoreCase("FALSE")) {
                throw new IllegalStateException("Invalid argument value to IfTableExists: " + args[0]);
            }
            ResultSet tableRS = null;
            Statement stmt = null;
            boolean bColExists = false;
            boolean bExecIfColExists = false;
            if (args[0].equalsIgnoreCase("TRUE")) {
                bExecIfColExists = true;
            }
            try {
                DatabaseMetaData dbInfo = con.getMetaData();
                tableRS = dbInfo.getTables(null, CMDbConnection.getDbmsInfo().getDbSchema(), args[1], null);
                if (tableRS.next()) {
                    bColExists = true;
                }
                if (bColExists && bExecIfColExists || !bColExists && !bExecIfColExists) {
                    for (int i = 2; i < args.length; ++i) {
                        stmt = con.createStatement();
                        stmt.execute(args[i]);
                    }
                }
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatementViaResultSet(tableRS);
                CMDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
            CMDbStoreUtil.safeCloseStatementViaResultSet(tableRS);
            CMDbStoreUtil.safeCloseStatement(stmt);
            return true;
        }
    }

    static class IfColumnExists
    implements CMDbStoreExecutor {
        IfColumnExists() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            Statement stmt;
            ResultSet columnRS;
            ResultSet tableRS;
            block9: {
                if (args.length != 4) {
                    throw new IllegalStateException("Invalid number of arguments to IfColumnExists");
                }
                if (!args[0].equalsIgnoreCase("TRUE") && !args[0].equalsIgnoreCase("FALSE")) {
                    throw new IllegalStateException("Invalid argument value to IfColumnExists: " + args[0]);
                }
                tableRS = null;
                columnRS = null;
                stmt = null;
                boolean bColExists = false;
                boolean bExecIfColExists = false;
                if (args[0].equalsIgnoreCase("TRUE")) {
                    bExecIfColExists = true;
                }
                try {
                    DatabaseMetaData dbInfo = con.getMetaData();
                    tableRS = dbInfo.getTables(null, CMDbConnection.getDbmsInfo().getDbSchema(), args[1], null);
                    if (!tableRS.next()) break block9;
                    columnRS = dbInfo.getColumns(null, CMDbConnection.getDbmsInfo().getDbSchema(), args[1], args[2]);
                    if (columnRS.next()) {
                        bColExists = true;
                    }
                    if (bColExists && bExecIfColExists) {
                        stmt = con.createStatement();
                        stmt.execute(args[3]);
                    } else if (!bColExists && !bExecIfColExists) {
                        stmt = con.createStatement();
                        stmt.execute(args[3]);
                    }
                }
                catch (Throwable throwable) {
                    CMDbStoreUtil.safeCloseStatementViaResultSet(tableRS);
                    CMDbStoreUtil.safeCloseStatementViaResultSet(columnRS);
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    throw throwable;
                }
            }
            CMDbStoreUtil.safeCloseStatementViaResultSet(tableRS);
            CMDbStoreUtil.safeCloseStatementViaResultSet(columnRS);
            CMDbStoreUtil.safeCloseStatement(stmt);
            return true;
        }
    }

    static class MigrateAuditLevels
    implements CMDbStoreExecutor {
        MigrateAuditLevels() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreUpgrade.class.getDeclaredMethod("WO578", null), null), "POSTINITACTIONS", actionName);
            }
            catch (Exception ex) {
                throw new CMException(ex, "MigrateAuditLevels failed");
            }
            return false;
        }
    }

    static class DeleteObjects
    implements CMDbStoreExecutor {
        DeleteObjects() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            if (args.length != 1) {
                // empty if block
            }
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreUpgrade.class.getDeclaredMethod("DELETE", String.class), args), "POSTINITACTIONS", actionName);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                return false;
            }
            return false;
        }
    }

    static class MakeConsistentTables
    implements CMDbStoreExecutor {
        MakeConsistentTables() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            if (args.length == 0) {
                throw new IllegalStateException("Invalid number of arguments to MakeConsistentTables");
            }
            HashSet<String> tables = new HashSet<String>(args.length);
            for (int i = 0; i < args.length; ++i) {
                tables.add(args[i]);
            }
            CMDbConnection dbcon = new CMDbConnection(con, true);
            CMDbStoreConsistency consistencyChecker = new CMDbStoreConsistency(dbcon);
            consistencyChecker.makeTablesConsistent(tables);
            return true;
        }
    }

    static class MapExistingStrings
    implements CMDbStoreExecutor {
        MapExistingStrings() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            if (args.length != 0) {
                // empty if block
            }
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreUpgrade.class.getDeclaredMethod("MES", null), null), "PRECACHEINITACTIONS", actionName);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                return false;
            }
            return false;
        }
    }

    static class RunCMScript
    implements CMDbStoreExecutor {
        RunCMScript() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            if (args.length != 1) {
                throw new IllegalStateException("RunCMScript: invalid number of arguments");
            }
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreUpgrade.class.getDeclaredMethod("RunCMUpgradeScript", String.class), args), "CMUPGRADESCRIPT", actionName);
            }
            catch (Exception ex) {
                throw new CMException(ex, "RunCMScript");
            }
            return false;
        }
    }

    static class SetLocaleID
    implements CMDbStoreExecutor {
        SetLocaleID() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            if (args.length < 1 || args.length > 2) {
                // empty if block
            }
            ArrayList<String> methodArgs = new ArrayList<String>();
            methodArgs.add(args[0]);
            if (args.length == 2) {
                methodArgs.add(args[1]);
            } else {
                methodArgs.add(null);
            }
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreUpgrade.class.getDeclaredMethod("SLI", String.class, String.class), methodArgs.toArray()), "PRECACHEINITACTIONS", actionName);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                return false;
            }
            return false;
        }
    }

    static class EmptyNamespaces
    implements CMDbStoreExecutor {
        EmptyNamespaces() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            ArrayList<Boolean> methodArgs = new ArrayList<Boolean>();
            if (args.length > 1) {
                return false;
            }
            if (args.length == 1) {
                if (args[0].equals("-3")) {
                    methodArgs.add(Boolean.TRUE);
                } else {
                    return false;
                }
            }
            if (methodArgs.size() == 0) {
                methodArgs.add(Boolean.FALSE);
            }
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreUpgrade.class.getDeclaredMethod("EN", Boolean.TYPE), methodArgs.toArray()), "POSTINITACTIONS", actionName);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                return false;
            }
            return false;
        }
    }

    static class AddPISQL
    implements CMDbStoreExecutor {
        AddPISQL() {
        }

        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            if (args.length < 1 || args.length > 2) {
                throw new IllegalStateException("Invalid number of arguments to AddPISQL");
            }
            if (args.length == 2) {
                if (!args[1].equalsIgnoreCase("ignoreErrors")) {
                    throw new IllegalStateException("Invalid second argument to AddPISQL");
                }
            } else {
                String sql = args[0];
                args = new String[]{sql, "throwException"};
            }
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreUpgrade.class.getDeclaredMethod("ExecSQL", String.class, String.class), args), "POSTINITACTIONS", actionName);
            }
            catch (Exception ex) {
                throw new CMException(ex, "AddPISQL failed");
            }
            return false;
        }
    }

    static class DropTable
    implements CMDbStoreExecutor {
        DropTable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            if (args.length != 1) {
                throw new IllegalStateException("Invalid number of arguments to DropTable");
            }
            ResultSet rs = null;
            Statement stmt = null;
            try {
                DatabaseMetaData dbInfo = con.getMetaData();
                rs = dbInfo.getTables(null, CMDbConnection.getDbmsInfo().getDbSchema(), args[0], null);
                if (rs.next()) {
                    stmt = con.createStatement();
                    stmt.execute("drop table " + args[0]);
                }
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
                CMDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
            CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
            CMDbStoreUtil.safeCloseStatement(stmt);
            return true;
        }
    }

    static class MigrateRelatedProperty
    implements CMDbStoreExecutor {
        MigrateRelatedProperty() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(Connection con, String[] args, String actionName) throws CMException, SQLException {
            String sqlGetOldRelated = "select CMID, RELATED from CMOBJPROPS6";
            String sqlInsertRelated = "insert into CMOBJPROPS14 (CMID, RELATED) values (?, ?)";
            Statement read = con.createStatement();
            PreparedStatement write = null;
            try {
                write = con.prepareStatement(sqlInsertRelated);
                ResultSet rs = read.executeQuery(sqlGetOldRelated);
                while (rs.next()) {
                    write.setInt(1, rs.getInt(1));
                    Object ref = rs.getString(2);
                    if (ref != null) {
                        ArrayList<String> newValue = new ArrayList<String>();
                        newValue.add(ref.toString());
                        ref = newValue;
                    }
                    CMDbStorePropertySerialization.bindParameterToPreparedStatement(write, 2, CMPropertyTypes.BIBUS_BASECLASSARRAY, Integer.MAX_VALUE, 2005, ref);
                    write.executeUpdate();
                }
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(read);
                CMDbStoreUtil.safeCloseStatement(write);
            }
            return true;
        }
    }
}

