/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.ArchiveStatusUpdater;
import com.cognos.cm.dbstore.CMDbColumn;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbPropertyDef;
import com.cognos.cm.dbstore.CMDbPropertyDefXMLImpl;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreSysProperties;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreNameValuePairArray;
import com.cognos.cm.dbstore.properties.CMDbStoreStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreTypedNameValuePairArray;
import com.cognos.cm.dbstore.serializers.CMDbStoreIDBasedBaseClassArraySingletonSerializer;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.CMLockManager;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.properties.CMBaseClassArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.IArchiveStatusUpdater;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMIntList;
import com.cognos.cm.util.CMMethodInvoker;
import com.cognos.cm.util.CMXMLUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Base64;
import java.util.BitSet;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CMDbStoreUtil {
    private static final String[] BO_QUERIES = new String[]{"/output[@_hasRecipients='true' and @_hasRecipientsEMail='false']", "/output[@_hasRecipients='false' and @_hasRecipientsEMail='true']"};
    private static IArchiveStatusUpdater archiveStatusUpdater;

    public static final void safeCloseStatement(Statement stmt) {
        if (stmt != null) {
            if (CMDbConnection.dbms_ == 5) {
                try {
                    ResultSet rs;
                    if (stmt.getUpdateCount() == -1 && (rs = stmt.getResultSet()) != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            try {
                stmt.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static final void safeCloseStatementViaResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                CMDbStoreUtil.safeCloseStatement(rs.getStatement());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static Object getArray(ICMDbConnection con, CMDbProperty prop, int objectID) throws CMException {
        return CMDbStoreUtil.getArray(con, prop, objectID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getArray(ICMDbConnection con, CMDbProperty prop, int objectID, boolean synchronizeORDAndIndex) throws CMException {
        PreparedStatement stmt;
        CMArrayPropertyValue value;
        block41: {
            String filter;
            ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
            value = null;
            if (prop.getType() == CMPropertyTypes.BIBUS_BASECLASSARRAY) {
                value = new CMDbStoreBaseClassArray();
            } else if (prop.getType() == CMPropertyTypes.BIBUS_PARAMETERVALUEARRAY) {
                value = new CMDbStoreNameValuePairArray();
            } else if (prop.getType() == CMPropertyTypes.BIBUS_RUNOPTIONARRAY) {
                value = new CMDbStoreTypedNameValuePairArray();
            } else if (prop.getType() == CMPropertyTypes.BIBUS_MULTILINGUALSTRING) {
                value = new CMDbStoreLocalizedStringArray();
            } else if (prop.isStoredAsArray()) {
                value = new CMDbStoreStringArray();
            }
            StringBuffer buffer = new StringBuffer(1024);
            buffer.append(sqlGenerator.createSelectSql());
            for (int colIdx = 0; colIdx != prop.columnCount(); ++colIdx) {
                if (colIdx > 0) {
                    buffer.append(sqlGenerator.createColumnsSeparator());
                }
                buffer.append(prop.getColumn(colIdx).getName());
            }
            boolean bORDIsSelected = false;
            if (synchronizeORDAndIndex && prop.isStoreIDBased() && prop.hasOrdinal()) {
                buffer.append(sqlGenerator.createColumnsSeparator());
                buffer.append("ORD");
                bORDIsSelected = true;
            }
            buffer.append(sqlGenerator.createFromSql());
            buffer.append(prop.getColumn(0).getTable());
            buffer.append(sqlGenerator.createWhereSql());
            buffer.append("CMID");
            buffer.append(sqlGenerator.createEqualsBindParameterSymbol());
            if (prop.isMultilingualRelated()) {
                buffer.append(sqlGenerator.createAndSql());
                buffer.append("PROPNAME");
                buffer.append(sqlGenerator.createEqualsBindParameterSymbol());
            }
            if (prop.hasPropertyID()) {
                buffer.append(sqlGenerator.createAndSql());
                buffer.append("PROPID");
                buffer.append(sqlGenerator.createEqualsBindParameterSymbol());
            }
            if ((filter = prop.getFilter()) != null && filter.length() > 0) {
                buffer.append(sqlGenerator.createAndSql());
                buffer.append(CMDbStoreUtil.substituteVars(filter, null, null));
            }
            buffer.append(sqlGenerator.createOrderBySql());
            if (prop.hasOrdinal()) {
                buffer.append("ORD");
            } else {
                buffer.append(prop.getColumn(0).getName());
            }
            stmt = null;
            try {
                stmt = con.prepareStatement(buffer.toString());
                int colIdx = 1;
                stmt.setInt(colIdx++, objectID);
                if (prop.isMultilingualRelated()) {
                    stmt.setString(colIdx++, prop.getNameInTable());
                }
                if (prop.hasPropertyID()) {
                    stmt.setInt(colIdx++, prop.getPropertyID());
                }
                ResultSet rs = stmt.executeQuery();
                int previousORD = -1;
                while (rs.next()) {
                    Object arrayEntry = CMDbStorePropertySerialization.getColumnByProperty(rs, 1, prop);
                    if (!bORDIsSelected) {
                        if (arrayEntry == null) continue;
                        value.add(arrayEntry);
                        continue;
                    }
                    int currentORD = rs.getInt("ORD");
                    for (int deltaORD = currentORD - previousORD; deltaORD > 1; --deltaORD) {
                        value.add(null);
                    }
                    value.add(arrayEntry);
                    previousORD = currentORD;
                }
                if (prop.getType() != CMPropertyTypes.BIBUS_BASECLASSARRAY || !prop.isStoreIDBased() || value.getSize() <= 0) break block41;
                CMDbStoreBaseClassArray arrayValue = (CMDbStoreBaseClassArray)value;
                if (prop.getMaxOccurs() != 1) {
                    int[] objectIds = new int[value.getSize()];
                    for (int i = 0; i < arrayValue.getSize(); ++i) {
                        Object entry = arrayValue.getItem(i);
                        if (entry == null) {
                            objectIds[i] = -1;
                            continue;
                        }
                        if (entry instanceof Integer) {
                            objectIds[i] = (Integer)entry;
                            continue;
                        }
                        throw new IllegalStateException("Unexpected class of the object deserialized as entry of base class array: " + entry.getClass().getName() + ". Integer is expected");
                    }
                    int[] properties = new int[]{4, 1, 2, 3};
                    Object[] cachedValues = CMLockManager.getObjectsCachedPropertiesInsideLockMutex(objectIds, properties);
                    int i = 0;
                    for (int j = 0; i < arrayValue.getSize() && j < cachedValues.length; ++i, ++j) {
                        if (arrayValue.getItem(i) == null) continue;
                        if (cachedValues[j] == null) {
                            if (synchronizeORDAndIndex) {
                                arrayValue.set(i, null);
                                continue;
                            }
                            arrayValue.removeItem(i);
                            --i;
                            continue;
                        }
                        if (!(cachedValues[j] instanceof Object[])) {
                            throw new IllegalStateException("Unexpected class of the object cached values: " + cachedValues[j].getClass().getName() + ". Object[] is expected");
                        }
                        Object[] cachedValue = (Object[])cachedValues[j];
                        CMObjectClass objectClass = (CMObjectClass)cachedValue[0];
                        String searchPath = (String)cachedValue[1];
                        String storeID = (String)cachedValue[2];
                        String securityReference = (String)cachedValue[3];
                        CMObjectReference ref = CMDbStoreIDBasedBaseClassArraySingletonSerializer.postDeserializeEntry(objectIds[j], objectClass, searchPath, storeID, securityReference);
                        if (ref != null) {
                            arrayValue.set(i, ref);
                            continue;
                        }
                        arrayValue.removeItem(i);
                        --i;
                    }
                    break block41;
                }
                Object arrayEntry = arrayValue.getItem(0);
                if (arrayEntry instanceof CMDbStoreBaseClassArray) {
                    Object ref = ((CMBaseClassArray)arrayEntry).getItem(0);
                    if (!(ref instanceof CMObjectReference)) {
                        throw new IllegalStateException("Unexpected class of the object cached values: " + ref.getClass().getName() + ". CMObjectReference is expected");
                    }
                    arrayValue.set(0, (CMObjectReference)ref);
                    break block41;
                }
                throw new IllegalStateException("Unexpected class of the object cached values: " + arrayEntry.getClass().getName() + ". CMBaseClassArray is expected");
            }
            catch (SQLException ex) {
                try {
                    CMDbStoreExceptionUtil.handleSQLException(con, ex, "failed to read array");
                }
                catch (Throwable throwable) {
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    throw throwable;
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        if (prop.getType() == CMPropertyTypes.BIBUS_BASECLASSARRAY) {
            for (int subpropertyIdx = 0; subpropertyIdx < prop.getSubproperties().size(); ++subpropertyIdx) {
                CMDbStoreBaseClassArray subpropertyValue;
                CMDbProperty currentProperty = (CMDbProperty)prop.getSubproperties().get(subpropertyIdx);
                if (!currentProperty.isStoredAsArray() || currentProperty.getType() != CMPropertyTypes.BIBUS_BASECLASSARRAY || (subpropertyValue = (CMDbStoreBaseClassArray)CMDbStoreUtil.getArray(con, currentProperty, objectID)) == null) continue;
                for (int i = 0; i < subpropertyValue.getSize(); ++i) {
                    Object arrayEntry = subpropertyValue.getItem(i);
                    value.add(arrayEntry);
                }
            }
        }
        if (value.getSize() == 0) {
            return null;
        }
        return value;
    }

    public static final String substituteVars(String original, String[] varNames, String[] varValues) {
        if (original == null) {
            return null;
        }
        int startOfVar = original.indexOf("$");
        StringBuffer result = new StringBuffer(original.length() * 2);
        int lastPos = 0;
        while (startOfVar >= 0 && original.length() > startOfVar + 2) {
            if (original.charAt(startOfVar + 1) == '(') {
                int endOfVar = original.indexOf(")", startOfVar + 2);
                if (endOfVar < 0) break;
                String varName = original.substring(startOfVar + 2, endOfVar);
                if (varNames != null) {
                    int varCnt = varNames.length;
                    for (int varIdx = 0; varIdx != varCnt; ++varIdx) {
                        if (!varName.equals(varNames[varIdx])) continue;
                        result.append(varValues[varIdx]);
                    }
                }
                lastPos = endOfVar + 1;
            } else {
                result.append("$");
                lastPos = startOfVar + 1;
            }
            startOfVar = original.indexOf("$", lastPos);
        }
        if (lastPos < original.length()) {
            result.append(original.substring(lastPos));
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int[] getBurstOutputObjects(CMDbStore store, CMCacheQueryInstance baseQuery, boolean hasRecipientsValue) throws Exception {
        CMCacheQueryInstance burstOutputTest = null;
        try {
            int[] results = baseQuery.resultObjects();
            if (results.length > 0) {
                CMStoreXPath newPath = new CMStoreXPath(hasRecipientsValue ? BO_QUERIES[0] : BO_QUERIES[1]);
                burstOutputTest = store.getCache().executeAdminQuery(results, results.length, newPath, 0);
                int[] nArray = burstOutputTest.resultObjects();
                return nArray;
            }
        }
        finally {
            if (burstOutputTest != null) {
                burstOutputTest.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int[] getBurstOutputObjects(CMDbStore store, CMCacheQueryInstance rootQuery) throws Exception {
        CMCacheQueryInstance burstOutputTest = null;
        try {
            int[] results = rootQuery.resultObjects();
            if (results.length > 0) {
                CMStoreXPath newPath = new CMStoreXPath("/output[@_IsBurstOutput='true']");
                burstOutputTest = store.getCache().executeAdminQuery(results, results.length, newPath, 0);
                int[] nArray = burstOutputTest.resultObjects();
                return nArray;
            }
        }
        finally {
            if (burstOutputTest != null) {
                burstOutputTest.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int[] getNonBurstOutputObjects(CMDbStore store, CMCacheQueryInstance rootQuery) throws Exception {
        CMCacheQueryInstance burstOutputTest = null;
        try {
            int[] results = rootQuery.resultObjects();
            if (results.length > 0) {
                CMStoreXPath newPath = new CMStoreXPath("/output[@_IsBurstOutput='false']");
                burstOutputTest = store.getCache().executeAdminQuery(results, results.length, newPath, 0);
                int[] nArray = burstOutputTest.resultObjects();
                return nArray;
            }
        }
        finally {
            if (burstOutputTest != null) {
                burstOutputTest.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int[] getOutputObjects(CMDbStore store, CMCacheQueryInstance rootQuery) throws Exception {
        CMCacheQueryInstance burstOutputTest = null;
        try {
            int[] results = rootQuery.resultObjects();
            if (results.length > 0) {
                CMStoreXPath newPath = new CMStoreXPath("/output");
                burstOutputTest = store.getCache().executeAdminQuery(results, results.length, newPath, 0);
                int[] nArray = burstOutputTest.resultObjects();
                return nArray;
            }
        }
        finally {
            if (burstOutputTest != null) {
                burstOutputTest.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean mightSelectBurstOutput(CMDbStore store, CMCacheQueryInstance rootQuery) throws Exception {
        CMCacheQueryInstance burstOutputTest = null;
        try {
            int[] results = rootQuery.resultObjects();
            if (results.length > 0) {
                CMStoreXPath newPath = new CMStoreXPath("/output[@_IsBurstOutput='true']");
                burstOutputTest = store.getCache().executeAdminQuery(results, results.length, newPath, 0);
                boolean bl = burstOutputTest.count() > 0;
                return bl;
            }
        }
        finally {
            if (burstOutputTest != null) {
                burstOutputTest.release();
            }
        }
        return false;
    }

    public static String getPropertySelectString(CMDbConnection con, String alias, CMDbProperty prop, boolean isLOB, boolean forPredicate, boolean forIsNullPredicate) {
        String aliasAndDot;
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        int colIdx = 0;
        if (prop.columnCount() > 1 && (prop == CMProperty.NAME || prop == CMProperty.DEFAULTNAME || prop.isMultilingualRelated())) {
            colIdx = 1;
        }
        CMDbColumn column = prop.getColumn(colIdx);
        String string = aliasAndDot = alias.length() > 0 ? alias + sqlGenerator.createAliasSeparator() : "";
        if (forPredicate && !forIsNullPredicate && prop.requiresCIHandling()) {
            return sqlGenerator.createStartUpperSql() + aliasAndDot + column.getName() + sqlGenerator.createClosingBracket();
        }
        if (isLOB && !forPredicate && CMDbConnection.getDbmsInfo().getUseTextPtr()) {
            return sqlGenerator.createStartJsqllobSql() + column.getName() + sqlGenerator.createJsqllobSeparator() + alias + sqlGenerator.createClosingBracket();
        }
        return aliasAndDot + prop.getColumn(colIdx).getName();
    }

    public static void storeScriptStepName(CMDbConnection con, String stepName) {
        try {
            con.beginTransaction();
            CMDbStoreSysProperties.addSysProp(con, stepName, null);
            con.commitTransaction();
        }
        catch (Exception exception) {
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeScriptStepNameReplacePrevious(CMDbConnection con, String nextStepName, String previousStepName) {
        try {
            con.beginTransaction();
            CMDbStoreSysProperties.deleteSysProp(con, previousStepName);
            CMDbStoreSysProperties.addSysProp(con, nextStepName, null);
            con.commitTransaction();
        }
        catch (Exception exception) {
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteScriptStepNameUpdateDbversion(CMDbConnection con, String dbversion, String stepName) {
        try {
            con.beginTransaction();
            CMDbStoreSysProperties.deleteSysProp(con, stepName);
            CMDbStoreUtil.updateDbversion(con, dbversion);
            con.commitTransaction();
        }
        catch (Exception ex) {
            CMIndications.logException(new CMStoreUnexpected(ex, "cmStoreUnexpected"));
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void deleteScriptStepName(CMDbConnection con, String stepName) {
        try {
            con.beginTransaction();
            CMDbStoreSysProperties.deleteSysProp(con, stepName);
            con.commitTransaction();
        }
        catch (Exception ex) {
            CMIndications.logException(new CMStoreUnexpected(ex, "cmStoreUnexpected"));
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDbversion(CMDbConnection con, String dbversion) {
        boolean inNestedTransaction = false;
        try {
            if (con.inTransaction()) {
                inNestedTransaction = true;
            } else {
                con.beginTransaction();
            }
            CMDbStoreSysProperties.updateSysProp(con, "CMStoreVersion", dbversion);
            CMDbStoreSysProperties.addSysProp(con, "CMDbUpgradeHistory_" + dbversion, dbversion);
            if (!inNestedTransaction) {
                con.commitTransaction();
            }
        }
        catch (Exception ex) {
            CMIndications.logException(new CMStoreUnexpected(ex, "cmStoreUnexpected"));
        }
        finally {
            if (!inNestedTransaction && con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Object[] getAncestorIds(CMDbStore store, int[] objectIds) throws CMException {
        Object[] ancestorIds = new Object[objectIds.length];
        for (int i = 0; i < objectIds.length; ++i) {
            ancestorIds[i] = store.getCache().CMCacheGetAncestorObjects(objectIds[i]);
        }
        return ancestorIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lockObjectParentsInDatabase(CMDbConnection con, int[] objectIDs) throws SQLException, CMException {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        PreparedStatement statement = null;
        try {
            CMDbStoreDMLDef dmlDefIn = new CMDbStoreDMLDef("");
            CMDbStoreDMLDef.CMDbStoreWhereCMIDsInfo whereCMIDsInfoIn = dmlDefIn.constructWhereCMIDs(con, objectIDs, "i.CMID", true, false);
            String whereCMIDsIn = whereCMIDsInfoIn.whereClause_;
            String joinWhereCMIDsIn = whereCMIDsInfoIn.fromClause_;
            StringBuffer statementBuffer = new StringBuffer();
            statementBuffer.append(sqlGenerator.createLockInDbSql());
            statementBuffer.append(joinWhereCMIDsIn);
            statementBuffer.append(sqlGenerator.createWhereSql());
            statementBuffer.append(whereCMIDsIn);
            statementBuffer.append(")");
            String statementString = statementBuffer.toString();
            statement = con.prepareStatement(statementString);
            int bindOffset = 1;
            bindOffset = CMDbStoreDMLDef.bindWhereCMIDsInfo(bindOffset, statement, objectIDs, whereCMIDsInfoIn);
            statement.execute();
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(statement);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lockObjectsInDatabase(CMDbConnection con, int[] objectIDs) throws SQLException, CMException {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        if (objectIDs == null || objectIDs.length == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            String tableName = "CMOBJECTS";
            CMDbStoreDMLDef dmlDefIn = new CMDbStoreDMLDef("");
            CMDbStoreDMLDef.CMDbStoreWhereCMIDsInfo whereCMIDsInfoIn = dmlDefIn.constructWhereCMIDs(con, objectIDs, "CMID", true, false);
            String whereCMIDsIn = whereCMIDsInfoIn.whereClause_;
            String joinWhereCMIDsIn = whereCMIDsInfoIn.fromClause_;
            StringBuffer statementBuffer = new StringBuffer();
            String columnName = "VERSION";
            statementBuffer.append(sqlGenerator.createUpdateFromTableSetSql(tableName)).append("VERSION").append(sqlGenerator.createEqualsSql()).append("VERSION").append(sqlGenerator.createWhereSql());
            if (joinWhereCMIDsIn.length() > 0) {
                statementBuffer.append("CMID").append(sqlGenerator.createInSql()).append(sqlGenerator.createOpeningBracket()).append(sqlGenerator.createSelectCMIDFromCMOBJECTSSql());
                statementBuffer.append(joinWhereCMIDsIn);
                statementBuffer.append(sqlGenerator.createWhereSql());
                statementBuffer.append(whereCMIDsIn);
                statementBuffer.append(sqlGenerator.createClosingBracket());
            } else {
                statementBuffer.append(whereCMIDsIn);
            }
            String statementString = statementBuffer.toString();
            statement = con.prepareStatement(statementString);
            int bindOffset = 1;
            bindOffset = CMDbStoreDMLDef.bindWhereCMIDsInfo(bindOffset, statement, objectIDs, whereCMIDsInfoIn);
            statement.execute();
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(statement);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(statement);
    }

    public static String addLiteral(CMDbConnection con, CMProperty property, Object literal) {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        CMDbProperty prop = (CMDbProperty)property;
        if (CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive() && (property == null && literal != null && !(literal instanceof Integer) || property != null && prop.requiresCIHandling())) {
            if (CMDbStoreUtil.parametersRequireCasting()) {
                CMDbColumn baseColumn;
                int strLength = 4000;
                if (property == null) {
                    return sqlGenerator.createUpperCastAsVarcharSql(strLength);
                }
                int colIdx = 0;
                if (prop.columnCount() > 1 && (prop == CMProperty.NAME || prop == CMProperty.DEFAULTNAME || prop.isMultilingualRelated())) {
                    colIdx = 1;
                }
                if ((baseColumn = prop.getColumn(colIdx)).getDbType() != 12 && baseColumn.getDbType() != -1 && baseColumn.getDbType() != -16) {
                    throw new IllegalStateException("Unexpected column type to be used for upper function, from column: " + property.getName());
                }
                if (strLength < 0) {
                    strLength = baseColumn.getLength();
                }
                return sqlGenerator.createUpperCastAsVarcharSql(strLength);
            }
            return sqlGenerator.createUpperBindParameterSql();
        }
        return sqlGenerator.createBindParameterSymbol();
    }

    public static boolean requiresCIHandling() {
        return CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive();
    }

    public static boolean parametersRequireCasting() {
        return CMDbConnection.dbms_ == 3;
    }

    public static int correctColumnType(String typeName, int dbType) {
        int dbTypeCorrected = dbType;
        if (dbType == 1111) {
            if (CMDbConnection.dbms_ == 2) {
                if (typeName.equalsIgnoreCase("clob")) {
                    dbTypeCorrected = 2005;
                } else if (typeName.equalsIgnoreCase("blob")) {
                    dbTypeCorrected = 2004;
                } else if (typeName.equalsIgnoreCase("float")) {
                    dbTypeCorrected = 6;
                } else if (typeName.substring(0, 9).equalsIgnoreCase("TIMESTAMP")) {
                    dbTypeCorrected = 93;
                }
            }
        } else if (CMDbConnection.dbms_ == 3 && CMDbConnection.getDbmsInfo().getDbmsSubtype() == 6 && dbType == -1) {
            dbTypeCorrected = 12;
            typeName = "varchar";
        }
        return dbTypeCorrected;
    }

    public static String getIndexValue(Object literal) throws CMException {
        MessageDigest md;
        if (literal == null) {
            return null;
        }
        String literalStr = literal.toString();
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMException(new CMException("cmFailedToCreateMessageDigest", new CMException.Parm("Algorithm", "SHA-256")));
        }
        md.update(literalStr.getBytes());
        byte[] raw = md.digest();
        return Base64.getEncoder().encodeToString(raw);
    }

    public static int deleteFromTables(CMDbConnection con, String[] delQueries, BitSet tableMask, int[] objectIDs, ArrayList<CMIntList> levelIds, Integer maxObjsInTransaction, boolean verifyObjectsCanBeDeleted) throws CMException, SQLException {
        int i;
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        int numOfObjectsDeleted = 0;
        CMDbStoreDMLDef deleteDef = new CMDbStoreDMLDef("");
        String deleteFromCMOBJECTSWhereSql = sqlGenerator.createDelStmtFragment("CMOBJECTS") + sqlGenerator.createWhereSql();
        if (levelIds != null) {
            for (i = 0; i < levelIds.size(); ++i) {
                CMIntList oneLevelIds = levelIds.get(i);
                int[] oneLevelObjectIDs = oneLevelIds.toArray();
                numOfObjectsDeleted += deleteDef.executeInGroups(con, deleteFromCMOBJECTSWhereSql, oneLevelObjectIDs, maxObjsInTransaction);
            }
        } else {
            numOfObjectsDeleted = deleteDef.executeInGroups(con, deleteFromCMOBJECTSWhereSql, objectIDs, maxObjsInTransaction);
        }
        for (i = 0; i < delQueries.length; ++i) {
            if (delQueries[i] == null || !tableMask.get(i)) continue;
            if (verifyObjectsCanBeDeleted) {
                CMDbStoreUtil.verifyObjectsCanBeModified(delQueries[i], objectIDs, con);
            }
            deleteDef.executeInGroups(con, delQueries[i] + sqlGenerator.createWhereSql(), objectIDs, maxObjsInTransaction);
        }
        return numOfObjectsDeleted;
    }

    public static void verifyObjectsCanBeModified(String deleteSQLOrTableName, int[] objectIDs, CMDbConnection con) throws CMException, SQLException {
        IArchiveStatusUpdater archiveStatusUpdater;
        String archiveStatusTableName = ((CMDbProperty)CMProperty._ARCHIVESTATUS).getColumn(0).getTable();
        if (deleteSQLOrTableName.contains(archiveStatusTableName) && !(archiveStatusUpdater = CMDbStoreUtil.getArchiveStatusUpdater()).canObjectsBeDeleted(con, objectIDs)) {
            throw new CMException("cmBadDeleteUnarchivedObjects");
        }
    }

    private static IArchiveStatusUpdater getArchiveStatusUpdater() {
        if (archiveStatusUpdater == null) {
            archiveStatusUpdater = new ArchiveStatusUpdater();
        }
        return archiveStatusUpdater;
    }

    protected void setArchiveStatusUpdater(IArchiveStatusUpdater updater) {
        archiveStatusUpdater = updater;
    }

    public static String getLengthFunctionName() {
        if (CMDbConnection.dbms_ == 2 || CMDbConnection.dbms_ == 3 || CMDbConnection.dbms_ == 5 || CMDbConnection.dbms_ == 8) {
            return "LENGTH";
        }
        if (CMDbConnection.dbms_ == 1 || CMDbConnection.dbms_ == 4) {
            return "DATALENGTH";
        }
        return "";
    }

    public static String getBigintDatatypeName() {
        if (CMDbConnection.dbms_ == 2 || CMDbConnection.dbms_ == 4) {
            return "decimal (19)";
        }
        if (CMDbConnection.dbms_ == 3 && CMDbConnection.getDbmsInfo().getDbmsSubtype() == 6) {
            return "integer";
        }
        return "bigint";
    }

    public static CMDbPropertyDef parseXMLPropertyDef(String xml) throws SAXException, IOException {
        Document propDoc = CMXMLUtils.parseString(xml);
        CMDbPropertyDefXMLImpl propEl = new CMDbPropertyDefXMLImpl(propDoc.getDocumentElement());
        return propEl;
    }

    static class CMDbStoreMethodInvoker
    extends CMMethodInvoker {
        CMDbStoreMethodInvoker(Object instance, Method method, Object[] args) {
            super(instance, method, args);
        }

        @Override
        public Object invoke() throws Throwable {
            try {
                return this.method_.invoke(this.object_, this.args_);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

