/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.dbstore.ICMDbConnectionParameters;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.IConfiguration;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class CMDriverManager {
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_USER = "user";
    private static Driver driver = null;

    public static void init(IConfiguration cfg) throws CMConfigurationException {
        Class<Driver> drvClass = CMDriverManager.getDriverClass(cfg);
        String s = cfg.getDatabaseProp("useDriverManger");
        if (s != null && (s.length() == 0 || s.equals("true") || s.equals("1"))) {
            return;
        }
        try {
            driver = drvClass.newInstance();
        }
        catch (Exception e) {
            CMIndications.Audit_Message("Unable to load jdbc driver, will use DriverManager for establishing database connections. Caused by: " + e.getMessage());
        }
    }

    private static Class<Driver> getDriverClass(IConfiguration config) throws CMConfigurationException {
        String dbType = config.getDatabaseType();
        if (dbType == null || dbType.length() == 0) {
            throw new CMConfigurationException("cmMissingCSParm", new CMException.Parm("ParmName", "databaseType"));
        }
        String driver = CMDriverManager.getJDBCDriverString(config, dbType);
        if (driver == null || driver.length() == 0) {
            throw new CMConfigurationException("cmBadDBType", new CMException.Parm("Type", dbType));
        }
        try {
            return Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            if (dbType.equalsIgnoreCase("Sybase")) {
                driver = CMDriverManager.getJDBCDriverString(config, dbType = new String(dbType + "JDBC4"));
                if (driver == null || driver.length() == 0) {
                    throw new CMConfigurationException("cmBadDBType", new CMException.Parm("Type", dbType));
                }
                try {
                    return Class.forName(driver);
                }
                catch (ClassNotFoundException e1) {
                    throw new CMConfigurationException((Throwable)e1, "cmErrCSDriver", new CMException.Parm("Driver", driver));
                }
            }
            throw new CMConfigurationException((Throwable)e, "cmErrCSDriver", new CMException.Parm("Driver", driver));
        }
    }

    private static String getJDBCDriverString(IConfiguration config, String dbType) {
        String driverParm = "CMDbDriver" + dbType;
        return System.getProperty("com.cognos.cm.dbstore.CMDbStoreFactory." + driverParm, config.getInternalProp(driverParm));
    }

    public static Connection getConnection(String url) throws SQLException {
        return CMDriverManager.getConnection(url, new Properties());
    }

    private static Connection getConnection(String url, Properties props) throws SQLException {
        if (driver == null) {
            return DriverManager.getConnection(url, props);
        }
        return driver.connect(url, props);
    }

    public static Connection getConnection(ICMDbConnectionParameters connectionParams) throws SQLException, CAMCryptoException {
        String dbPassword;
        String connectionURL = connectionParams.getConnectionURL();
        Properties connProps = new Properties();
        connProps.putAll(connectionParams.getConnectionAdvancedParameters());
        String dbUserName = connectionParams.getUserName();
        if (dbUserName != null) {
            connProps.put(PROP_USER, dbUserName);
        }
        if ((dbPassword = connectionParams.getPassword()) != null) {
            connProps.put(PROP_PASSWORD, dbPassword);
        }
        return CMDriverManager.getConnection(connectionURL, connProps);
    }
}

