/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMAcquiredPropertySubscriber;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreAcquiredPropertiesHandler;
import com.cognos.cm.dbstore.CMDbStoreAcquiredValue;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreSelectDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStoreXPath;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CMUserCapabilityPoliciesHandler
extends CMAcquiredPropertySubscriber {
    protected static Set<Integer> objectsThatHavePolicies_;
    private static byte[] slashContentPolicies_;
    private static int contentID_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateUserCapabilityPoliciesSet(CMDbConnection con) throws CMException {
        objectsThatHavePolicies_ = null;
        CMUserCapabilityPoliciesHandler.initPoliciesSet();
        try {
            CMStorePathStep step = new CMStorePathStep("*[hasProperty('userCapabilityPolicies')]");
            CMDbStoreSelectDef selectStmt = new CMDbStoreSelectDef(con, step, null, null);
            ResultSet rs = selectStmt.execute(con);
            try {
                while (rs.next()) {
                    Object id = CMDbStorePropertySerialization.getColumnByProperty(rs, 1, CMProperty._CMID);
                    objectsThatHavePolicies_.add(new Integer(id.toString()));
                }
            }
            finally {
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
            }
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedToLoadUserCapabilityPoliciesCache");
        }
    }

    public static void policyUpdated(Integer obj_id, boolean removed) {
        CMUserCapabilityPoliciesHandler.initPoliciesSet();
        CMDbStoreFactory.userCapabilityPoliciesCache_.remove(obj_id);
        if (removed) {
            objectsThatHavePolicies_.remove(obj_id);
        } else if (!objectsThatHavePolicies_.contains(obj_id)) {
            objectsThatHavePolicies_.add(obj_id);
        }
    }

    public CMUserCapabilityPoliciesHandler(int objectID, CMDbStore store, CMDbStoreAcquiredPropertiesHandler acquiredPropHandler, CMProperty prop) {
        super(objectID, store, acquiredPropHandler, prop);
    }

    @Override
    public Object getValue(int propPosition, ResultSet rs) throws CMException, SQLException {
        if (this.hasPolicy(this.objectID_)) {
            return this.queryPolicies(propPosition, rs);
        }
        return this.queryAncestors();
    }

    @Override
    public void acquiredValuePublished(CMDbStoreAcquiredValue value) {
        Integer acquiredFrom = new Integer(value.getAcquiredFrom());
        byte[] ucPolicies = (byte[])value.getValue();
        CMDbStoreFactory.userCapabilityPoliciesCache_.add(acquiredFrom, ucPolicies);
    }

    protected static void initPoliciesSet() {
        if (objectsThatHavePolicies_ == null) {
            objectsThatHavePolicies_ = Collections.synchronizedSet(new HashSet());
        }
    }

    private byte[] queryAncestors() {
        if (AdvancedSettings.USERCAPABILITYPOLICIESENABLED) {
            int inheritedAncestorID = -1;
            try {
                inheritedAncestorID = this.getInheritedID();
            }
            catch (CMCacheException ex) {
                return null;
            }
            if (inheritedAncestorID == -1) {
                return null;
            }
            return this.getAncestorPolicy(inheritedAncestorID);
        }
        return this.getSlashContentPolicies();
    }

    protected int getInheritedID() throws CMCacheException {
        int[] ancestors = this.store_.getCache().CMCacheGetAncestorObjects(this.objectID_);
        for (int i = 0; i < ancestors.length; ++i) {
            int ancestorID = ancestors[i];
            if (!this.hasPolicy(new Integer(ancestorID))) continue;
            return ancestorID;
        }
        return -1;
    }

    private byte[] getAncestorPolicy(int id) {
        Integer obj_id = new Integer(id);
        byte[] ucPolicies = CMDbStoreFactory.userCapabilityPoliciesCache_.get(obj_id);
        if (ucPolicies != null) {
            this.acquiredPropHandler_.addAcquiredValue(this.prop_, ucPolicies, id);
            this.isAcquired_ = true;
            return ucPolicies;
        }
        this.acquiredPropHandler_.requiresAcquiredValue(this.prop_);
        super.subscribe();
        return null;
    }

    private byte[] queryPolicies(int propPosition, ResultSet rs) throws SQLException {
        byte[] ucPolicies = CMDbStoreFactory.userCapabilityPoliciesCache_.get(this.objectID_);
        if (ucPolicies != null) {
            return ucPolicies;
        }
        ucPolicies = this.getPolicyFromResultSet(propPosition, rs);
        if (ucPolicies != null) {
            CMDbStoreFactory.userCapabilityPoliciesCache_.add(this.objectID_, ucPolicies);
        }
        return ucPolicies;
    }

    protected byte[] getPolicyFromResultSet(int propPosition, ResultSet rs) throws SQLException {
        return (byte[])CMDbStorePropertySerialization.getColumnByProperty(rs, propPosition, this.prop_);
    }

    private boolean hasPolicy(Integer objectID) {
        return objectsThatHavePolicies_.contains(objectID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getContentID() {
        if (contentID_ != -1) {
            return contentID_;
        }
        CMStoreQueryResults rs = null;
        try {
            CMStoreXPath path = new CMStoreXPath("/content");
            rs = CMExecutionContext.get().getStore().executeQuery(path, null, null, 0, 512, null);
            if (rs != null && rs.next()) {
                int n = contentID_ = rs.getObjectID();
                return n;
            }
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            if (rs != null) {
                rs.release();
            }
        }
        return -1;
    }

    private byte[] getSlashContentPolicies() {
        if (slashContentPolicies_ != null) {
            return slashContentPolicies_;
        }
        int contentID = this.getContentID();
        slashContentPolicies_ = this.getAncestorPolicy(contentID);
        return slashContentPolicies_;
    }

    static {
        slashContentPolicies_ = null;
        contentID_ = -1;
    }
}

