/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.binders.CMDbStoreRepositoryBinder;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.ICMProperty;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.util.StringUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class ExternalDataDef {
    private String dataType;
    private String dataSize;
    private Object isCompressed;

    ExternalDataDef() {
    }

    void addColumn(ICMProperty column, Object value) {
        if (CMPropertyMeaning.DATATYPE.equals(column.getMeaning())) {
            this.dataType = StringUtils.defaultIfNull(value, "");
        } else if (CMPropertyMeaning.DATASIZE.equals(column.getMeaning())) {
            this.dataSize = StringUtils.defaultIfNull(value, "");
        } else if (CMPropertyMeaning._DATAISCOMPRESSED.equals(column.getMeaning())) {
            this.isCompressed = value;
        }
    }

    void bindParameter(PreparedStatement stmt, int paramPos, Object value, int objectID) throws SQLException {
        this.bindParameter(stmt, paramPos, value, objectID, -1);
    }

    void bindParameter(PreparedStatement stmt, int paramPos, Object value, int objectID, int objectParentID) throws SQLException {
        CMDbStoreRepositoryBinder binder = new CMDbStoreRepositoryBinder(this.dataType, this.dataSize, this.isCompressed, objectID, objectParentID);
        binder.bindData(stmt, paramPos, value);
    }

    boolean isExternalBind(CMDbProperty property) {
        boolean isExternal = property.isExternalizable();
        isExternal = isExternal && ConfigurationFactory.getConfig().isExternalObjectStoreEnabled();
        return isExternal;
    }
}

