/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.SqlBuilder;
import com.cognos.cm.properties.CMLocalizedString;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.util.CMIntList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;

public class NameUniqueness {
    private int[] typesWithGloballyUniqueNames = null;
    private int lastTypeWithGloballyUniqueName = Integer.MAX_VALUE;
    private boolean namesHaveTenantScope;
    private String singleObject;
    private String singleObject_tenanted;
    private String multipleObjectsWithParent;
    private String multipleObjectsWithParent_tenanted;
    private String multipleObjects;
    private String multipleObjects_tenanted;

    private static NameUniqueness getInstance() {
        return LazyHolder.INSTANCE;
    }

    private NameUniqueness() {
        try {
            this.namesHaveTenantScope = ConfigurationFactory.getConfig().namesHaveTenantScope();
            this.initTypesWithGloballyUniqueNames();
            CMDbConnection con = CMDbStoreFactory.getConnection();
            this.initStatementSingleObject(con);
            this.initStatementMultipleObjectsWithParent(con);
            this.initStatementMultipleObjectsWithParentTenanted(con);
            this.initStatementMultipleObjects(con);
            this.initStatementMultipleObjectsTenanted(con);
        }
        catch (CMException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(CMDbStore store, int objectID, String name, int parentId) throws SQLException, CMException {
        CMDbConnection con = store.getConnection();
        boolean tenantScope = !this.hasGloballyUniqueName(store, objectID, parentId);
        PreparedStatement statement = null;
        try {
            statement = con.prepareStatement(tenantScope ? this.singleObject_tenanted : this.singleObject);
            statement.setInt(1, parentId);
            statement.setString(2, name);
            if (tenantScope) {
                int tenantId = store.getCache().CMCacheGetTenantID(objectID);
                statement.setInt(3, tenantId);
            }
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                int cmid = rs.getInt(1);
                if (cmid == objectID) continue;
                throw new SQLException("ID_CMOBJECTS");
            }
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(statement);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(statement);
    }

    public static void check(CMDbStore store, int objectID, CMLocalizedStringArray name, int parentId) throws SQLException, CMException {
        NameUniqueness instance = NameUniqueness.getInstance();
        for (int n = 0; n < name.getSize(); ++n) {
            CMLocalizedString localizedName = (CMLocalizedString)name.getItem(n);
            String localeName = localizedName.getValue();
            instance.check(store, objectID, localeName, parentId);
        }
    }

    public static void check(CMDbStore store, int[] objectIDs, int parentID) throws SQLException, CMException {
        NameUniqueness check = NameUniqueness.getInstance();
        Object groups = check.namesHaveTenantScope && !check.isObjectTenanted(store, parentID) ? check.splitObjectsWithGlobalNames(store, objectIDs) : (Object)new int[][]{objectIDs, new int[0]};
        if (groups[0].length != 0) {
            check.executeMultipleObjectsWithParentStatement(store, groups[0], parentID, false);
        }
        if (groups[1].length != 0) {
            check.executeMultipleObjectsWithParentStatement(store, groups[1], parentID, true);
        }
    }

    public static void check(CMDbStore store, int[] objectIDs) throws SQLException, CMException {
        if (NameUniqueness.requiresDerbyWorkaround(objectIDs)) {
            NameUniqueness.processObjectsIndividually(store, objectIDs);
            return;
        }
        NameUniqueness check = NameUniqueness.getInstance();
        int[][] groups = check.splitObjectsWithGlobalNames(store, objectIDs);
        if (groups[0].length != 0) {
            check.executeMultipleObjectsStatement(store, groups[0], false);
        }
        if (groups[1].length != 0) {
            check.executeMultipleObjectsStatement(store, groups[1], true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeMultipleObjectsStatement(CMDbStore store, int[] ids, boolean tenanted) throws CMException, SQLException {
        PreparedStatement ps = null;
        CMDbConnection con = store.getConnection();
        try {
            CMDbStoreDMLDef.CMDbStoreWhereCMIDsInfo info = new CMDbStoreDMLDef("").constructWhereCMIDs(con, ids, "i.CMID", true, false);
            String template = tenanted ? this.multipleObjects_tenanted : this.multipleObjects;
            String statement = String.format(template, info.fromClause_, info.whereClause_);
            ps = con.prepareStatement(statement);
            CMDbStoreDMLDef.bindWhereCMIDsInfo(1, ps, ids, info);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                throw new SQLException("ID_CMOBJECTS");
            }
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(ps);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeMultipleObjectsWithParentStatement(CMDbStore store, int[] ids, int parentId, boolean tenanted) throws CMException, SQLException {
        PreparedStatement ps = null;
        CMDbConnection con = store.getConnection();
        try {
            CMDbStoreDMLDef.CMDbStoreWhereCMIDsInfo info = new CMDbStoreDMLDef("").constructWhereCMIDs(con, ids, "i.CMID", true, false);
            String template = tenanted ? this.multipleObjectsWithParent_tenanted : this.multipleObjectsWithParent;
            String statement = String.format(template, info.fromClause_, info.whereClause_);
            ps = con.prepareStatement(statement);
            ps.setInt(1, parentId);
            CMDbStoreDMLDef.bindWhereCMIDsInfo(2, ps, ids, info);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                throw new SQLException("ID_CMOBJECTS");
            }
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(ps);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(ps);
    }

    private int[][] splitObjectsWithGlobalNames(CMDbStore store, int[] objectIDs) {
        CMIntList globalObjects = new CMIntList();
        CMIntList tenantedObjects = new CMIntList();
        for (int id : objectIDs) {
            if (this.hasGloballyUniqueName(store, id, -1)) {
                globalObjects.add(id);
                continue;
            }
            tenantedObjects.add(id);
        }
        return new int[][]{globalObjects.toArray(), tenantedObjects.toArray()};
    }

    private static boolean requiresDerbyWorkaround(int[] objectIDs) {
        return CMDbConnection.dbms_ == 5 && objectIDs.length > 1;
    }

    private static void processObjectsIndividually(CMDbStore store, int[] objectIDs) throws SQLException, CMException {
        int[] oneObjectID = new int[1];
        for (int i = 0; i < objectIDs.length; ++i) {
            oneObjectID[0] = objectIDs[i];
            NameUniqueness.check(store, oneObjectID);
        }
    }

    private boolean hasGloballyUniqueName(CMDbStore store, int objectId, int parentId) {
        if (!this.namesHaveTenantScope) {
            return true;
        }
        CMCache cache = store.getCache();
        try {
            if (parentId != -1 && this.isObjectTenanted(store, parentId)) {
                return true;
            }
            if (cache.CMCacheGetTenantID(objectId) == 0) {
                return true;
            }
            int classId = cache.CMCacheGetClass(objectId);
            if (classId > this.lastTypeWithGloballyUniqueName) {
                return classId == CMObjectClass.TENANT.getID();
            }
            for (int type : this.typesWithGloballyUniqueNames) {
                if (classId != type) continue;
                return true;
            }
            return false;
        }
        catch (Exception ignore) {
            return true;
        }
    }

    private boolean isObjectTenanted(CMDbStore store, int id) {
        return store.getCache().CMCacheGetTenantID(id) != 0;
    }

    private void initTypesWithGloballyUniqueNames() {
        CMIntList list = new CMIntList();
        for (CMObjectClass cls : CMDbStoreFactory.getObjectClasses().getAllClasses()) {
            if (cls == CMObjectClass.TENANT || !cls.hasGloballyUniqueName()) continue;
            list.add(cls.getID());
        }
        int[] array = list.toArray();
        Arrays.sort(array);
        this.typesWithGloballyUniqueNames = array;
        this.lastTypeWithGloballyUniqueName = array.length == 0 ? Integer.MAX_VALUE : array[array.length - 1];
    }

    private void initStatementSingleObject(CMDbConnection con) throws CMStoreNotAvailable {
        SqlBuilder sql = new SqlBuilder(con.getSqlGenerator());
        sql.select().column("a", "CMID").from(this.cmobjnames(), "a").innerJoin("CMOBJECTS", "ap").on().column("a", "CMID").eq().column("ap", "CMID").where().column("ap", "PCMID").equalsBindParameter().and().append(this.nameColumn(con, "a")).eq().append(this.nameBindParam(con));
        this.singleObject = sql.toString();
        sql.and().openBracket().column("ap", "TENANTID").equalsValue(0).or().column("ap", "TENANTID").equalsBindParameter().closeBracket();
        this.singleObject_tenanted = sql.toString();
    }

    private void initStatementMultipleObjects(CMDbConnection con) {
        SqlBuilder sql = this.createBaseMultipleObjectsSelectStatement(con);
        this.unknowParentFromClause(sql);
        this.unknownParentWhereClause(sql);
        sql.append("%s");
        this.multipleObjects = sql.toString();
    }

    private void initStatementMultipleObjectsTenanted(CMDbConnection con) throws CMStoreNotAvailable {
        SqlBuilder sql = this.createBaseMultipleObjectsSelectStatement(con);
        this.unknowParentFromClause(sql);
        this.unknownParentWhereClause(sql);
        this.tenantFilter(sql);
        this.multipleObjects_tenanted = sql.toString();
    }

    private void initStatementMultipleObjectsWithParent(CMDbConnection con) {
        SqlBuilder sql = this.createBaseMultipleObjectsSelectStatement(con);
        sql.append("%s");
        this.knownParentWhereClause(sql);
        sql.append("%s");
        this.multipleObjectsWithParent = sql.toString();
    }

    private void initStatementMultipleObjectsWithParentTenanted(CMDbConnection con) {
        SqlBuilder sql = this.createBaseMultipleObjectsSelectStatement(con);
        sql.innerJoin("CMOBJECTS", "ip").on().column("i", "CMID").eq().column("ip", "CMID");
        sql.append("%s");
        this.knownParentWhereClause(sql);
        this.tenantFilter(sql);
        this.multipleObjectsWithParent_tenanted = sql.toString();
    }

    private SqlBuilder createBaseMultipleObjectsSelectStatement(CMDbConnection con) {
        SqlBuilder sql = new SqlBuilder(con.getSqlGenerator());
        sql.select().column("a", "CMID").from(this.cmobjnames(), "a").leftOuterJoin(this.cmobjnames(), "i").on().append(this.nameColumn(con, "a")).eq().append(this.nameColumn(con, "i")).innerJoin("CMOBJECTS", "ap").on().column("a", "CMID").eq().column("ap", "CMID");
        return sql;
    }

    private void tenantFilter(SqlBuilder sql) {
        sql.openBracket().column("ap", "TENANTID").equalsValue(0).or().column("ip", "TENANTID").equalsValue(0).or().column("ap", "TENANTID").eq().column("ip", "TENANTID").closeBracket().and().append("%s");
    }

    private void knownParentWhereClause(SqlBuilder sql) {
        sql.where().column("ap", "PCMID").equalsBindParameter().and().column("i", "CMID").ne().column("a", "CMID").and();
    }

    private void unknowParentFromClause(SqlBuilder sql) {
        sql.innerJoin("CMOBJECTS", "ip").on().column("i", "CMID").eq().column("ip", "CMID").and().column("ap", "PCMID").eq().column("ip", "PCMID");
        sql.append("%s");
    }

    private void unknownParentWhereClause(SqlBuilder sql) {
        sql.where().column("i", "CMID").ne().column("a", "CMID").and();
    }

    private String cmobjnames() {
        return ((CMDbProperty)CMProperty.NAME).getColumn(0).getTable();
    }

    private String nameColumn(CMDbConnection con, String alias) {
        return CMDbStoreUtil.getPropertySelectString(con, alias, (CMDbProperty)CMProperty.NAME, false, true, false);
    }

    private String nameBindParam(CMDbConnection con) {
        return CMDbStoreUtil.addLiteral(con, CMProperty.NAME, "");
    }

    private static class LazyHolder {
        static final NameUniqueness INSTANCE = new NameUniqueness();

        private LazyHolder() {
        }
    }
}

