/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbSizeExecutable;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.SqlBuilder;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMTenantCountSizeInfo;
import com.cognos.cm.server.CMException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ObjectSizeByTenant
extends CMDbSizeExecutable {
    protected CMObjectClass objectClass;
    protected Map<Integer, CMTenantCountSizeInfo> result;
    protected int[] forTenantsIds;

    public ObjectSizeByTenant(CMDbStore store, int[] forTenants) {
        super(store);
        this.forTenantsIds = forTenants;
    }

    public Map<Integer, CMTenantCountSizeInfo> calculate(Set<String> tables, CMObjectClass objectClass) throws CMException {
        this.objectClass = objectClass;
        this.result = new HashMap<Integer, CMTenantCountSizeInfo>();
        this.execute(tables);
        return this.result;
    }

    @Override
    protected boolean useDirtyRead() {
        return true;
    }

    @Override
    protected boolean appendSqlForTable(SqlBuilder sql, String table, Map<String, HashMap<String, Object>> columns) throws CMException, SQLException {
        sql.select().aliasedColumn("o", "TENANTID").separator();
        sql.count().append("*").closeBracket().separator();
        boolean addedSql = this.appendSizeColumnsSql(sql, columns);
        if (!addedSql) {
            return false;
        }
        sql.from().aliasedTable("s", table);
        sql.innerJoin().aliasedTable("o", "CMOBJECTS").onJoinConditionEquals("s", "CMID", "o", "CMID");
        sql.where().aliasedColumn("o", "CLASSID").equalsBindParameter();
        if (this.filterByTenant()) {
            this.appendTenantFilterClause(sql, "o");
        }
        sql.groupBy().aliasedColumn("o", "TENANTID");
        return true;
    }

    protected void appendTenantFilterClause(SqlBuilder sql, String tableAlias) {
        sql.and().aliasedColumn(tableAlias, "TENANTID");
        CMDbStoreDMLDef.appendInBindVariables(sql.getSqlGenerator(), sql.getBuffer(), this.forTenantsIds.length);
    }

    @Override
    protected void bindParameters(PreparedStatement stmt) throws SQLException {
        stmt.setInt(1, this.objectClass.getID());
        if (this.filterByTenant()) {
            CMDbStoreDMLDef.bindInts(2, stmt, this.forTenantsIds, 0, this.forTenantsIds.length);
        }
    }

    @Override
    protected void extractResult(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            Integer tenantId = new Integer(resultSet.getInt(1));
            CMTenantCountSizeInfo info = this.result.get(tenantId);
            if (null == info) {
                info = new CMTenantCountSizeInfo(this.objectClass.getName(), tenantId, resultSet.getLong(2));
                this.result.put(tenantId, info);
            }
            info.incrementSize(resultSet.getLong(3));
        }
    }

    protected boolean filterByTenant() {
        return this.forTenantsIds != null && this.forTenantsIds.length > 0;
    }
}

