/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ObjectSizeByTenant;
import com.cognos.cm.dbstore.SqlBuilder;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMTenantCountSizeInfo;
import com.cognos.cm.server.CMException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OutputSizeByTenant
extends ObjectSizeByTenant {
    private List<String> ignoredColumns;

    public OutputSizeByTenant(CMDbStore store, int[] forTenants) {
        this(store, forTenants, Arrays.asList("DATAPROP"));
    }

    protected OutputSizeByTenant(CMDbStore store, int[] forTenants, List<String> ignoredColumns) {
        super(store, forTenants);
        this.ignoredColumns = ignoredColumns;
    }

    @Override
    protected void execute(Set<String> tables) throws CMException {
        super.execute(tables);
        this.executeSecondarySizing();
    }

    protected void executeSecondarySizing() throws CMException {
        CMDbStore.ReadTransactionHandle rtHandle;
        CMDbConnection con;
        int defaultIsolation;
        boolean changedIsolationLevel;
        block17: {
            changedIsolationLevel = false;
            defaultIsolation = -1;
            con = this.store.getConnection();
            SqlBuilder sql = new SqlBuilder(con.getSqlGenerator());
            PreparedStatement stmt = null;
            ResultSet rs = null;
            rtHandle = null;
            try {
                if (CMDbConnection.getDbmsInfo().getDbms() != 2) {
                    defaultIsolation = con.getConnection().getTransactionIsolation();
                    con.getConnection().setTransactionIsolation(1);
                    changedIsolationLevel = true;
                }
                this.prepare(con);
                this.buildSql(sql);
                stmt = con.prepareStatement(sql.toString());
                int currentBindIndex = 1;
                if (this.filterByTenant()) {
                    for (int i = 0; i < 2; ++i) {
                        currentBindIndex = CMDbStoreDMLDef.bindInts(currentBindIndex, stmt, this.forTenantsIds, 0, this.forTenantsIds.length);
                    }
                }
                rtHandle = this.store.beginReadTransaction();
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Integer tenantId = new Integer(rs.getInt(1));
                    long size = rs.getLong(2);
                    int count = rs.getInt(3);
                    boolean isEos = rs.getInt(4) == 1;
                    CMTenantCountSizeInfo info = (CMTenantCountSizeInfo)this.result.get(tenantId);
                    if (info == null) {
                        info = new CMTenantCountSizeInfo(this.objectClass.getName(), tenantId, (long)count);
                    }
                    if (isEos) {
                        info.incrementSizeInEOS(size);
                        continue;
                    }
                    info.incrementSize(size);
                }
                if (stmt == null) break block17;
            }
            catch (SQLException ex) {
                try {
                    throw new CMException(ex);
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        CMDbStoreUtil.safeCloseStatement(stmt);
                    }
                    CMDbStore.releaseReadTransaction(rtHandle);
                    if (changedIsolationLevel) {
                        try {
                            con.getConnection().setTransactionIsolation(defaultIsolation);
                        }
                        catch (SQLException e) {
                            throw new CMException(e);
                        }
                    }
                    throw throwable;
                }
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
        }
        CMDbStore.releaseReadTransaction(rtHandle);
        if (changedIsolationLevel) {
            try {
                con.getConnection().setTransactionIsolation(defaultIsolation);
            }
            catch (SQLException e) {
                throw new CMException(e);
            }
        }
    }

    private void buildSql(SqlBuilder sql) {
        for (int i = 0; i < 2; ++i) {
            boolean isEOSSection = i == 0;
            sql.select();
            sql.aliasedColumn("objs", "TENANTID").separator();
            sql.sum().coalesce().aliasedColumn("data", "DATASIZE").separator().append("0").closeBracket().closeBracket().separator();
            sql.count().append("*").closeBracket().separator();
            sql.append(isEOSSection ? "1" : "0");
            sql.from().aliasedTable("objs", "CMOBJECTS").innerJoin().aliasedTable("data", "CMDATA").onJoinConditionEquals("objs", "CMID", "data", "CMID");
            if (isEOSSection) {
                sql.where().aliasedColumn("objs", "CLASSID").equalsValue(CMObjectClass.OUTPUT.getID()).and().lobIsNull("data", "DATAPROP").and().aliasedColumn("data", "DATASIZE").greaterThan(0);
            } else {
                sql.where().aliasedColumn("objs", "CLASSID").equalsValue(CMObjectClass.OUTPUT.getID()).and().lobIsNotNull("data", "DATAPROP");
            }
            if (this.filterByTenant()) {
                this.appendTenantFilterClause(sql, "objs");
            }
            sql.groupBy().aliasedColumn("objs", "TENANTID");
            if (i != 0) continue;
            sql.union();
        }
    }

    @Override
    protected boolean appendSqlForTable(SqlBuilder sqlGenerator, String table, Map<String, HashMap<String, Object>> columns) throws CMException, SQLException {
        Map<String, HashMap<String, Object>> columnsCopy = this.copyMap(columns);
        for (String ignored : this.ignoredColumns) {
            columnsCopy.remove(ignored);
        }
        return super.appendSqlForTable(sqlGenerator, table, columnsCopy);
    }

    protected Map<String, HashMap<String, Object>> copyMap(Map<String, HashMap<String, Object>> toCopy) {
        HashMap<String, HashMap<String, Object>> copy2 = new HashMap<String, HashMap<String, Object>>();
        copy2.putAll(toCopy);
        return copy2;
    }
}

