/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbSizeExecutable;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.SqlBuilder;
import com.cognos.cm.server.CMException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OutputTotalSizeExecutable
extends CMDbSizeExecutable {
    private int[] objectIds;
    private CMDbStoreDMLDef.CMDbStoreWhereCMIDsInfo whereCMIDsInfo;
    private long dataSize;
    private long metadataSize;

    public OutputTotalSizeExecutable(CMDbStore store) {
        super(store);
    }

    public void calculate(Set<String> tables, int[] objectIds) throws CMException {
        this.dataSize = 0L;
        this.metadataSize = 0L;
        this.objectIds = objectIds;
        this.execute(tables);
    }

    @Override
    protected void prepare(CMDbConnection con) throws CMException, SQLException {
        CMDbStoreDMLDef selectDefinition = new CMDbStoreDMLDef("");
        this.whereCMIDsInfo = selectDefinition.constructWhereCMIDs(con, this.objectIds, "s.CMID", true, true);
    }

    @Override
    protected boolean appendSqlForTable(SqlBuilder sql, String table, Map<String, HashMap<String, Object>> columns) throws CMException, SQLException {
        boolean isDataTable = table.equals("CMDATA");
        Map<String, HashMap<String, Object>> dataColumnMap = null;
        if (isDataTable) {
            HashMap<String, HashMap<String, Object>> mutableColumns = new HashMap<String, HashMap<String, Object>>(columns);
            columns = mutableColumns;
            HashMap dataColumnInfo = (HashMap)mutableColumns.remove("DATAPROP");
            if (dataColumnInfo == null) {
                throw new IllegalStateException("CMDATA table missing DATAPROP column.");
            }
            dataColumnMap = Collections.singletonMap("DATAPROP", dataColumnInfo);
        }
        sql.select();
        boolean sqlAppended = this.appendSizeColumnsSql(sql, columns);
        if (!sqlAppended && !isDataTable) {
            return false;
        }
        if (isDataTable) {
            if (!sqlAppended) {
                sql.append("0");
            }
            sql.separator();
            this.appendSizeColumnsSql(sql, dataColumnMap);
        } else {
            sql.separator();
            sql.append("0");
        }
        sql.from().aliasedTable("s", table);
        sql.append(this.whereCMIDsInfo.fromClause_);
        sql.where().append(this.whereCMIDsInfo.whereClause_);
        return true;
    }

    @Override
    protected void bindParameters(PreparedStatement stmt) throws SQLException {
        CMDbStoreDMLDef.bindWhereCMIDsInfo(1, stmt, this.objectIds, this.whereCMIDsInfo);
    }

    @Override
    protected void extractResult(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            this.metadataSize += resultSet.getLong(1);
            this.dataSize += resultSet.getLong(2);
        }
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getMetadataSize() {
        return this.metadataSize;
    }
}

